/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.BufferLike;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;
import scala.util.Using;
import scala.util.Using$;

@ScalaSignature(bytes="\u0006\u0001\r\rc!B A\u0003\u0003)\u0005\"\u0002'\u0001\t\u0003i\u0005\"\u0003)\u0001\u0001\u0004\u0005\r\u0011\"\u0001R\u0011%i\u0006\u00011AA\u0002\u0013\u0005a\fC\u0005f\u0001\u0001\u0007\t\u0011)Q\u0005%\"9a\r\u0001b\u0001\n\u00139\u0007BB9\u0001A\u0003%\u0001\u000eC\u0003s\u0001\u0011\u00051\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0005~\u0001\u0001\u0007\t\u0019!C\u0001}\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0007\u0011)\t\t\u0002\u0001a\u0001\u0002\u0003\u0006Ka \u0005\u0007\u0003'\u0001a\u0011A)\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011Q\u0007\u0001\u0005\u0002\u0005]\u0002BBA\u001d\u0001\u0011\u0005\u0011\u000bC\u0004\u0002<\u0001!\t!!\u0010\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\u000b\u0001\u0005\u0002\u0005]\u0003\"CAE\u0001E\u0005I\u0011AAF\u0011\u001d\t\t\u000b\u0001C\t\u0003GCq!!\u001d\u0001\t#\t)\fC\u0004\u00028\u0002!\t\"!/\t\u000f\u00055\u0007\u0001\"\u0005\u0002P\"9\u0011q\u001c\u0001\u0005\u0012\u0005=\u0007bBAq\u0001\u0011E\u00111\u001d\u0005\b\u0003k\u0004A\u0011IA|\u0011\u001d\u0011\u0019\u0001\u0001C!\u0003oAqA!\u0004\u0001\t\u0003\u0011y\u0001C\u0005\u0003\u001a\u0001\t\n\u0011\"\u0001\u0003\u001c!I!q\u0004\u0001\u0012\u0002\u0013\u0005!1\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011%\u0011Y\u0003AI\u0001\n\u0003\tY\tC\u0005\u0003.\u0001\t\n\u0011\"\u0001\u00030!9!1\u0007\u0001\u0005\u0002\tU\u0002\"\u0003B,\u0001E\u0005I\u0011\u0001B-\u0011%\u0011i\u0006AI\u0001\n\u0003\u0011I\u0006C\u0005\u0003`\u0001\t\n\u0011\"\u0001\u00030!I!\u0011\r\u0001\u0012\u0002\u0013\u0005\u00111\u0012\u0005\n\u0005G\u0002\u0011\u0013!C\u0001\u0005_AqA!\u001a\u0001\t\u0003\u00119\u0007C\u0005\u0003x\u0001\t\n\u0011\"\u0001\u0002\f\"9!\u0011\u0010\u0001\u0005\u0002\tm\u0004\"\u0003BA\u0001E\u0005I\u0011AAF\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0005\u000bCqAa+\u0001\t\u0003\u0011i\u000bC\u0004\u00034\u0002!\tA!.\t\u000f\t]\u0006\u0001\"\u0001\u0003:\"9!q\u0017\u0001\u0005\u0002\t}\u0006b\u0002Bj\u0001\u0011\u0005!Q\u001b\u0005\b\u00053\u0004A\u0011\u0001Bn\u0011%\u0011y\u000eAI\u0001\n\u0003\u0011Y\u0002C\u0004\u0003b\u0002!\tAa9\t\u000f\t5\b\u0001\"\u0001\u0003p\"9!\u0011\u001f\u0001\u0005\u0002\tM\bb\u0002By\u0001\u0011\u00051q\u0001\u0005\b\u0007\u0013\u0001A\u0011AB\u0006\u0011\u001d\u0019y\u0001\u0001C\u0005\u0007#Aqa!\u0006\u0001\t\u0013\u00199\u0002C\u0004\u0004\u001e\u0001!\taa\b\t\u000f\r\r\u0002\u0001\"\u0001\u00028!91Q\u0005\u0001\u0005\u0002\r\u001d\u0002b\u0002B\u0011\u0001\u0011%1q\u0006\u0002\u0017\u0017\u000647.Y*feZ,'\u000fV3ti\"\u000b'O\\3tg*\u0011\u0011IQ\u0001\fS:$Xm\u001a:bi&|gNC\u0001D\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001$\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%\u0013\u0015AB:feZ,'/\u0003\u0002L\u0011\n\t\u0012+^8sk6$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005q\u0005CA(\u0001\u001b\u0005\u0001\u0015aD5ogR\fgnY3D_:4\u0017nZ:\u0016\u0003I\u00032a\u0015-[\u001b\u0005!&BA+W\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002/\u0006)1oY1mC&\u0011\u0011\f\u0016\u0002\u0004'\u0016\f\bCA$\\\u0013\ta\u0006JA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aE5ogR\fgnY3D_:4\u0017nZ:`I\u0015\fHCA0d!\t\u0001\u0017-D\u0001W\u0013\t\u0011gK\u0001\u0003V]&$\bb\u00023\u0004\u0003\u0003\u0005\rAU\u0001\u0004q\u0012\n\u0014\u0001E5ogR\fgnY3D_:4\u0017nZ:!\u0003!y&M]8lKJ\u001cX#\u00015\u0011\u0007%dg.D\u0001k\u0015\tYG+A\u0004nkR\f'\r\\3\n\u00055T'aC!se\u0006L()\u001e4gKJ\u0004\"aR8\n\u0005AD%aC&bM.\f'I]8lKJ\f\u0011b\u00182s_.,'o\u001d\u0011\u0002\u000f\t\u0014xn[3sgV\tA\u000fE\u0002jk:L!A\u001e6\u0003\r\t+hMZ3s\u0003\u001d\u0019XM\u001d<feN,\u0012!\u001f\t\u0004SVT\bCA$|\u0013\ta\bJA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018!B1mSZ,W#A@\u0011\u000b\u0001\f\t!!\u0002\n\u0007\u0005\raKA\u0003BeJ\f\u0017\u0010E\u0002a\u0003\u000fI1!!\u0003W\u0005\u001d\u0011un\u001c7fC:\f\u0011\"\u00197jm\u0016|F%Z9\u0015\u0007}\u000by\u0001C\u0004e\u0015\u0005\u0005\t\u0019A@\u0002\r\u0005d\u0017N^3!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001c\u0018aI2p]\u001aLw-\u001e:f'\u0016\u001cWO]5us\n+gm\u001c:f'\u0016\u0014h/\u001a:t'R\f'\u000f\u001e\u000b\u0004?\u0006e\u0001bBA\u000e\u001b\u0001\u0007\u0011QD\u0001\ti\u0016\u001cH/\u00138g_B!\u0011qDA\u0019\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012aA1qS*!\u0011qEA\u0015\u0003\u001dQW\u000f]5uKJTA!a\u000b\u0002.\u0005)!.\u001e8ji*\u0011\u0011qF\u0001\u0004_J<\u0017\u0002BA\u001a\u0003C\u0011\u0001\u0002V3ti&sgm\\\u0001#G>tg-[4ve\u0016\u001cVmY;sSRL\u0018I\u001a;feN+'O^3sgN#\u0018M\u001d;\u0015\u0003}\u000bqaY8oM&<7/A\u0006tKJ4XM\u001d$pe&#G\u0003BA \u0003\u000b\u0002B\u0001YA!u&\u0019\u00111\t,\u0003\r=\u0003H/[8o\u0011\u001d\t9\u0005\u0005a\u0001\u0003\u0013\n!!\u001b3\u0011\u0007\u0001\fY%C\u0002\u0002NY\u00131!\u00138u\u0003%\u0011w.\u001e8e!>\u0014H\u000f\u0006\u0003\u0002J\u0005M\u0003\"B%\u0012\u0001\u0004Q\u0018\u0001\u00052p_R\u001cHO]1q'\u0016\u0014h/\u001a:t)\u0011\tI&a\u001c\u0011\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n)\u0007E\u0002\u0002`Yk!!!\u0019\u000b\u0007\u0005\rD)\u0001\u0004=e>|GOP\u0005\u0004\u0003O2\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00055$AB*ue&twMC\u0002\u0002hYC\u0011\"!\u001d\u0013!\u0003\u0005\r!a\u001d\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\u0005U\u0014QQ\u0007\u0003\u0003oRA!!\u001f\u0002|\u00059a.\u001a;x_J\\'\u0002BA?\u0003\u007f\naaY8n[>t'bA\"\u0002\u0002*!\u00111QA\u0017\u0003\u0019\t\u0007/Y2iK&!\u0011qQA<\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003i\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\tiI\u000b\u0003\u0002t\u0005=5FAAI!\u0011\t\u0019*!(\u000e\u0005\u0005U%\u0002BAL\u00033\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005me+\u0001\u0006b]:|G/\u0019;j_:LA!a(\u0002\u0016\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!M,7-\u001e:jif\u0004&o\u001c;pG>dWCAAS!\u0011\t9+!-\u000e\u0005\u0005%&\u0002BAV\u0003[\u000bA!Y;uQ*!\u0011qVA>\u0003!\u0019XmY;sSRL\u0018\u0002BAZ\u0003S\u0013\u0001cU3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0005\u0005M\u0014A\u0004;skN$8\u000b^8sK\u001aKG.Z\u000b\u0003\u0003w\u0003R\u0001YA!\u0003{\u0003B!a0\u0002J6\u0011\u0011\u0011\u0019\u0006\u0005\u0003\u0007\f)-\u0001\u0002j_*\u0011\u0011qY\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0006\u0005'\u0001\u0002$jY\u0016\fAc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001cXCAAi!\u0015\u0001\u0017\u0011IAj!\u0011\t).a7\u000e\u0005\u0005]'\u0002BAm\u0003\u000b\fA!\u001e;jY&!\u0011Q\\Al\u0005)\u0001&o\u001c9feRLWm]\u0001\u0015G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:\u0002\u0015\t\u0014xn[3s)&lW\r\u0006\u0003\u0002f\u0006E\b\u0003BAt\u0003[l!!!;\u000b\t\u0005-\u00181P\u0001\u0006kRLGn]\u0005\u0005\u0003_\fIO\u0001\u0003US6,\u0007bBAz3\u0001\u0007\u0011\u0011J\u0001\tEJ|7.\u001a:JI\u0006)1/\u001a;VaR\u0019q,!?\t\u000f\u0005m!\u00041\u0001\u0002\u001e!\u001a!$!@\u0011\t\u0005}\u0011q`\u0005\u0005\u0005\u0003\t\tC\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00047\t\u001d\u0001\u0003BA\u0010\u0005\u0013IAAa\u0003\u0002\"\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0010e\u0016\u001c'/Z1uK\n\u0013xn[3sgR)qL!\u0005\u0003\u0016!I!1\u0003\u000f\u0011\u0002\u0003\u0007\u0011QA\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\rC\u0005\u0003\u0018q\u0001\n\u00111\u0001\u0002\u0006\u000591\u000f^1siV\u0004\u0018!\u0007:fGJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIE*\"A!\b+\t\u0005\u0015\u0011qR\u0001\u001ae\u0016\u001c'/Z1uK\n\u0013xn[3sg\u0012\"WMZ1vYR$#'\u0001\nde\u0016\fG/Z(gMN,Go\u001d+pa&\u001cG#B0\u0003&\t\u001d\u0002\"CA9?A\u0005\t\u0019AA:\u0011%\u0011Ic\bI\u0001\u0002\u0004\t\u0019.A\tbI6Lgn\u00117jK:$8i\u001c8gS\u001e\fAd\u0019:fCR,wJ\u001a4tKR\u001cHk\u001c9jG\u0012\"WMZ1vYR$\u0013'\u0001\u000fde\u0016\fG/Z(gMN,Go\u001d+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\tE\"\u0006BAj\u0003\u001f\u000b1b\u0019:fCR,Gk\u001c9jGRq!q\u0007B\"\u0005\u000f\u0012YEa\u0014\u0003T\tU\u0003\u0003\u0003B\u001d\u0005\u007f\tI%!\u0013\u000e\u0005\tm\"b\u0001B\u001f)\u0006I\u0011.\\7vi\u0006\u0014G.Z\u0005\u0005\u0005\u0003\u0012YDA\u0002NCBDqA!\u0012#\u0001\u0004\tI&A\u0003u_BL7\rC\u0005\u0003J\t\u0002\n\u00111\u0001\u0002J\u0005ia.^7QCJ$\u0018\u000e^5p]ND\u0011B!\u0014#!\u0003\u0005\r!!\u0013\u0002#I,\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fC\u0005\u0003R\t\u0002\n\u00111\u0001\u0002T\u0006YAo\u001c9jG\u000e{gNZ5h\u0011%\t\tH\tI\u0001\u0002\u0004\t\u0019\bC\u0005\u0003*\t\u0002\n\u00111\u0001\u0002T\u0006)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012TC\u0001B.U\u0011\tI%a$\u0002+\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u0013eK\u001a\fW\u000f\u001c;%g\u0005)2M]3bi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\"\u0014!F2sK\u0006$X\rV8qS\u000e$C-\u001a4bk2$H%N\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00137\u0003e\u0019'/Z1uKR{\u0007/[2XSRD\u0017i]:jO:lWM\u001c;\u0015\u0011\t]\"\u0011\u000eB6\u0005kBqA!\u0012)\u0001\u0004\tI\u0006C\u0004\u0003n!\u0002\rAa\u001c\u00025A\f'\u000f^5uS>t'+\u001a9mS\u000e\f\u0017i]:jO:lWM\u001c;\u0011\u000fM\u0013\t(!\u0013\u0003t%\u0019!\u0011\t+\u0011\tMC\u0016\u0011\n\u0005\n\u0003cB\u0003\u0013!a\u0001\u0003g\n1e\u0019:fCR,Gk\u001c9jG^KG\u000f[!tg&<g.\\3oi\u0012\"WMZ1vYR$3'A\u0006eK2,G/\u001a+pa&\u001cG#B0\u0003~\t}\u0004b\u0002B#U\u0001\u0007\u0011\u0011\f\u0005\n\u0003cR\u0003\u0013!a\u0001\u0003g\nQ\u0003Z3mKR,Gk\u001c9jG\u0012\"WMZ1vYR$#'\u0001\tbI\u0012\fe\u000e\u001a,fe&4\u00170Q2mgR)qLa\"\u0003\u001e\"9!\u0011\u0012\u0017A\u0002\t-\u0015\u0001B1dYN\u0004b!a\u0017\u0003\u000e\nE\u0015\u0002\u0002BH\u0003[\u00121aU3u!\u0011\u0011\u0019J!'\u000e\u0005\tU%\u0002\u0002BL\u0003w\n1!Y2m\u0013\u0011\u0011YJ!&\u0003%\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/\u001f\u0005\b\u0005?c\u0003\u0019\u0001BQ\u0003!\u0011Xm]8ve\u000e,\u0007\u0003\u0002BR\u0005Ok!A!*\u000b\t\t}\u00151P\u0005\u0005\u0005S\u0013)KA\bSKN|WO]2f!\u0006$H/\u001a:o\u0003M\u0011X-\\8wK\u0006sGMV3sS\u001aL\u0018i\u00197t)\u0015y&q\u0016BY\u0011\u001d\u0011I)\fa\u0001\u0005\u0017CqAa(.\u0001\u0004\u0011\t+\u0001\tlS2d'+\u00198e_6\u0014%o\\6feR\u0011\u0011\u0011J\u0001\u000bW&dGN\u0011:pW\u0016\u0014HcA0\u0003<\"9!QX\u0018A\u0002\u0005%\u0013!B5oI\u0016DH#B0\u0003B\n\r\u0007b\u0002B_a\u0001\u0007\u0011\u0011\n\u0005\b\u0005\u000b\u0004\u0004\u0019\u0001Bd\u0003\u001d!\u0018.\\3pkR\u0004BA!3\u0003P6\u0011!1\u001a\u0006\u0005\u0005\u001b\f)-\u0001\u0003uS6,\u0017\u0002\u0002Bi\u0005\u0017\u0014\u0001\u0002R;sCRLwN\\\u0001\fgR\f'\u000f\u001e\"s_.,'\u000fF\u0002`\u0005/DqA!02\u0001\u0004\tI%\u0001\nsKN$\u0018M\u001d;EK\u0006$'I]8lKJ\u001cHcA0\u0003^\"I!1\u0003\u001a\u0011\u0002\u0003\u0007\u0011QA\u0001\u001de\u0016\u001cH/\u0019:u\t\u0016\fGM\u0011:pW\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00132\u00039:\u0018-\u001b;G_J,6/\u001a:TGJ\fWn\u0011:fI\u0016tG/[1m)>\f\u0005\u000f]3be>s\u0017\t\u001c7Ce>\\WM]:\u0015\u000b}\u0013)O!;\t\u000f\t\u001dH\u00071\u0001\u0002Z\u0005y1\r\\5f]R\u0004&/\u001b8dSB\fG\u000eC\u0004\u0003lR\u0002\r!!\u0017\u0002\u001b5,7\r[1oSNlg*Y7f\u000359W\r^\"p]R\u0014x\u000e\u001c7feR\t!0A\u0006hKR$v\u000e]5d\u0013\u0012\u001cH\u0003\u0002B{\u0007\u0003\u0001\u0002\"a\u0017\u0003x\u0006e#\u0011`\u0005\u0005\u0005\u0003\ni\u0007\u0005\u0003\u0003|\nuXBAA>\u0013\u0011\u0011y0a\u001f\u0003\tU+\u0018\u000e\u001a\u0005\b\u0007\u00071\u0004\u0019AB\u0003\u0003\u0015q\u0017-\\3t!\u0011\u0019\u0006,!\u0017\u0015\u0005\tU\u0018!D4fiR{\u0007/[2OC6,7\u000f\u0006\u0002\u0004\u000eAA\u00111\fB|\u0005s\fI&A\u0007de\u0016\fG/\u001a\"s_.,'o\u001d\u000b\u0004?\u000eM\u0001b\u0002B\fs\u0001\u0007\u0011QA\u0001\u0017GJ,\u0017\r^3Ce>\\WM\u001d$s_6\u001cuN\u001c4jOR\u0019an!\u0007\t\r\rm!\b1\u0001[\u0003\u0019\u0019wN\u001c4jO\u0006a\u0011\r\\5wK\n\u0013xn[3sgV\u00111\u0011\u0005\t\u0004'bs\u0017!H3ogV\u0014XmQ8og&\u001cH/\u001a8u\u0017J\u000bg\r^'fi\u0006$\u0017\r^1\u0002)\rD\u0017M\\4f\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015y6\u0011FB\u0017\u0011\u001d\u0019Y#\u0010a\u0001\u00033\n\u0011c]1oSRL'0\u001a3DY&,g\u000e^%e\u0011\u001d\tI$\u0010a\u0001\u0003'$RaXB\u0019\u0007\u0003Bqaa\r?\u0001\u0004\u0019)$\u0001\u0005{W\u000ec\u0017.\u001a8u!\u0011\u00199d!\u0010\u000e\u0005\re\"bAB\u001e\u0005\u0006\u0011!p[\u0005\u0005\u0007\u007f\u0019IDA\u0007LC\u001a\\\u0017MW6DY&,g\u000e\u001e\u0005\u0007oz\u0002\ra!\t")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive;

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart(testInfo);
        this.createBrokers(true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig), (Function1 & Serializable & scala.Serializable)admin -> TestUtils$.MODULE$.createOffsetsTopicWithAdmin((Admin)admin, this.brokers(), this.controllerServers()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        this.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            return (scala.collection.immutable.Map)Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig), (Function1 & Serializable & scala.Serializable)admin -> {
                Buffer<KafkaBroker> x$3 = this.brokers();
                Seq<ControllerServer> x$4 = this.controllerServers();
                Map<Object, Seq<Object>> x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
                return TestUtils$.MODULE$.createTopicWithAdmin((Admin)admin, topic, x$3, x$4, numPartitions, replicationFactor, x$8, topicConfig);
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            return (scala.collection.immutable.Map)Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3()), (Function1 & Serializable & scala.Serializable)admin -> {
                Buffer<KafkaBroker> x$4 = this.brokers();
                Seq<ControllerServer> x$5 = this.controllerServers();
                int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
                int x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
                Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
                return TestUtils$.MODULE$.createTopicWithAdmin((Admin)admin, topic, x$4, x$5, x$6, x$7, partitionReplicaAssignment, x$8);
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, this.servers());
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3()), (Function1 & Serializable & scala.Serializable)admin -> {
                TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic, this.aliveBrokers(), this.controllerServers());
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizerForWrite = TestUtils$.MODULE$.pickAuthorizerForWrite(this.brokers(), this.controllerServers());
        Set aclBindings = (Set)acls.map((Function1 & Serializable & scala.Serializable)acl -> new AclBinding(resource, acl), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizerForWrite.createAcls(TestUtils$.MODULE$.anonymousAuthorizableContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)aclBindings.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> (AclCreateResult)x$1.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            KafkaServerTestHarness.$anonfun$addAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        ((BufferLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$2 -> (Authorizer)x$2.authorizer().get(), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.controllerServers().map((Function1 & Serializable & scala.Serializable)x$3 -> (Authorizer)x$3.authorizer().get(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(aclFilter)).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.entry(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)acls)), authorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        Authorizer authorizerForWrite = TestUtils$.MODULE$.pickAuthorizerForWrite(this.brokers(), this.controllerServers());
        Set aclBindingFilters = (Set)acls.map((Function1 & Serializable & scala.Serializable)acl -> new AclBindingFilter(resource.toFilter(), acl.toFilter()), Set$.MODULE$.canBuildFrom());
        ((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(authorizerForWrite.deleteAcls(TestUtils$.MODULE$.anonymousAuthorizableContext(), (List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)aclBindingFilters.toList()).asJava())).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> (AclDeleteResult)x$5.toCompletableFuture().get(), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)result -> {
            KafkaServerTestHarness.$anonfun$removeAndVerifyAcls$3(result);
            return BoxedUnit.UNIT;
        });
        AclBindingFilter aclFilter = new AclBindingFilter(resource.toFilter(), AccessControlEntryFilter.ANY);
        ((BufferLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$6 -> (Authorizer)x$6.authorizer().get(), Buffer$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.controllerServers().map((Function1 & Serializable & scala.Serializable)x$7 -> (Authorizer)x$7.authorizer().get(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)authorizer -> {
            TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(aclFilter)).asScala()).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.entry(), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)acls)), authorizer, resource, TestUtils$.MODULE$.waitAndVerifyAcls$default$4());
            return BoxedUnit.UNIT;
        });
    }

    public int killRandomBroker() {
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return index;
    }

    public void killBroker(int index) {
        this.killBroker(index, Duration.ofMinutes(5L));
    }

    public void killBroker(int index, Duration timeout) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown(timeout);
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
            return;
        }
    }

    public void startBroker(int index) {
        if (!this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).startup();
            this.alive()[index] = true;
            return;
        }
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (reconfigure) {
                this._brokers().update(i, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(i)));
            }
            ((KafkaBroker)this._brokers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(names).asJava()).get();
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.apply(name));
                }
                return BoxedUnit.UNIT;
            });
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).forEach((key, value) -> result.put(value, key));
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap(Predef$.MODULE$.$conforms());
    }

    private void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
        }
        return TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, false, this.isZkMigrationTest() || config.migrationEnabled() && config.interBrokerProtocolVersion().isApiForwardingEnabled());
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((SeqLike)this._brokers().filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, broker)))).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        if (this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
            return;
        }
    }

    public void changeClientIdConfig(String sanitizedClientId, Properties configs) {
        if (this.isKRaftTest()) {
            Using$.MODULE$.resource((Object)TestUtils$.MODULE$.createAdminClient(this.brokers(), this.listenerName(), TestUtils$.MODULE$.createAdminClient$default$3()), (Function1 & Serializable & scala.Serializable)admin -> {
                Tuple2[] tuple2Array = new Tuple2[1];
                String string = sanitizedClientId;
                String string2 = "<default>";
                tuple2Array[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), string != null && string.equals(string2) ? null : sanitizedClientId);
                return (Void)admin.alterClientQuotas(Collections.singleton(new ClientQuotaAlteration(new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava()), (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 != null) {
                        String key = (String)x0$1._1();
                        String value = (String)x0$1._2();
                        return new ClientQuotaAlteration.Op(key, Predef$.MODULE$.double2Double(new StringOps(Predef$.MODULE$.augmentString(value)).toDouble()));
                    }
                    throw new MatchError(null);
                }, Iterable$.MODULE$.canBuildFrom())).toList()).asJava()))).all().get();
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        this.adminZkClient().changeClientIdConfig(sanitizedClientId, configs);
    }

    private void createOffsetsTopic(KafkaZkClient zkClient, Seq<KafkaBroker> servers) {
        KafkaBroker server = (KafkaBroker)servers.head();
        int numPartitions = server.config().groupCoordinatorConfig().offsetsTopicPartitions();
        short replicationFactor = server.config().groupCoordinatorConfig().offsetsTopicReplicationFactor();
        try {
            TestUtils$.MODULE$.createTopic(zkClient, "__consumer_offsets", numPartitions, replicationFactor, servers, server.groupCoordinator().groupMetadataTopicConfigs());
            return;
        }
        catch (TopicExistsException ex) {
            Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> allPartitionsMetadata = TestUtils$.MODULE$.waitForAllPartitionsMetadata(servers, "__consumer_offsets", numPartitions);
            if (allPartitionsMetadata.size() != numPartitions || ((UpdateMetadataRequestData.UpdateMetadataPartitionState)((Tuple2)allPartitionsMetadata.head())._2()).replicas().size() != replicationFactor) {
                throw ex;
            }
            return;
        }
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ void $anonfun$addAndVerifyAcls$3(AclCreateResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ void $anonfun$removeAndVerifyAcls$3(AclDeleteResult result) {
        result.exception().ifPresent(e -> {
            throw e;
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache.cache(mechanismName$1, ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, KafkaBroker broker) {
        return $this.alive()[broker.config().brokerId()];
    }
}

