/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Optional;
import java.util.OptionalLong;
import kafka.log.LogTestUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.AbortedTxn;
import org.apache.kafka.storage.internals.log.BatchMetadata;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegmentOffsetOverflowException;
import org.apache.kafka.storage.internals.log.ProducerStateEntry;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.storage.internals.log.RollParams;
import org.apache.kafka.storage.internals.log.TimestampOffset;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\rh\u0001\u0002\u00192\u0001YBQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013%!\t\u0003\u0004O\u0001\u0001\u0006Ia\u0011\u0005\b\u001f\u0002\u0011\r\u0011\"\u0003Q\u0011\u0019\u0011\u0007\u0001)A\u0005#\"I1\r\u0001a\u0001\u0002\u0004%I\u0001\u001a\u0005\n[\u0002\u0001\r\u00111A\u0005\n9D\u0011\u0002\u001e\u0001A\u0002\u0003\u0005\u000b\u0015B3\t\u000bU\u0004A\u0011\u0001<\t\u0013\u0005M\u0001!%A\u0005\u0002\u0005U\u0001\"CA\u0016\u0001E\u0005I\u0011AA\u0017\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u0019\u0001\t\u0003\t\u0019\u0007C\u0004\u0002|\u0001!\t!a\u0019\t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\"9\u0011Q\u001a\u0001\u0005\u0002\u0005\r\u0004bBAl\u0001\u0011\u0005\u00111\r\u0005\b\u00037\u0004A\u0011AA2\u0011\u001d\ty\u000e\u0001C\u0001\u0003GBq!a9\u0001\t\u0003\t)\u000fC\u0004\u0003\n\u0001!\t!a\u0019\t\u000f\t5\u0001\u0001\"\u0001\u0002d!9!\u0011\u0003\u0001\u0005\u0002\u0005\r\u0004b\u0002B\u000b\u0001\u0011\u0005\u00111\r\u0005\b\u00053\u0001A\u0011AA2\u0011\u001d\u0011i\u0002\u0001C\u0001\u0003GBqA!\t\u0001\t\u0003\t\u0019\u0007C\u0004\u0003&\u0001!\t!a\u0019\t\u000f\t%\u0002\u0001\"\u0001\u0002d!9!Q\u0006\u0001\u0005\u0002\u0005\r\u0004b\u0002B\u0019\u0001\u0011%!1\u0007\u0005\n\u00057\u0002\u0011\u0013!C\u0005\u0003+A\u0011B!\u0018\u0001#\u0003%I!!\u0006\t\u0013\t}\u0003!%A\u0005\n\t\u0005\u0004b\u0002B3\u0001\u0011\u0005\u00111\r\u0005\b\u0005S\u0002A\u0011AA2\u0011\u0019)\b\u0001\"\u0003\u0003n!9!Q\u0010\u0001\u0005\u0002\u0005\r\u0004b\u0002BA\u0001\u0011\u0005\u00111\r\u0005\b\u0005\u000b\u0003A\u0011AA2\u0011\u001d\u0011I\t\u0001C\u0001\u0003GBqA!$\u0001\t\u0003\t\u0019\u0007C\u0004\u0003\u0012\u0002!\t!a\u0019\t\u000f\tU\u0005\u0001\"\u0001\u0002d!9!\u0011\u0014\u0001\u0005\n\tm\u0005b\u0002BR\u0001\u0011%!Q\u0015\u0005\b\u0005'\u0004A\u0011\u0002Bk\u00059aunZ*fO6,g\u000e\u001e+fgRT!AM\u001a\u0002\u00071|wMC\u00015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001c\u0011\u0005aZT\"A\u001d\u000b\u0003i\nQa]2bY\u0006L!\u0001P\u001d\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\b\u0005\u0002A\u00015\t\u0011'\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003\r\u0003\"\u0001\u0012'\u000e\u0003\u0015S!AR$\u0002\r\r|W.\\8o\u0015\t!\u0004J\u0003\u0002J\u0015\u00061\u0011\r]1dQ\u0016T\u0011aS\u0001\u0004_J<\u0017BA'F\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\tg\u0016<W.\u001a8ugV\t\u0011\u000bE\u0002S/fk\u0011a\u0015\u0006\u0003)V\u000bq!\\;uC\ndWM\u0003\u0002Ws\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a\u001b&aC!se\u0006L()\u001e4gKJ\u0004\"A\u00171\u000e\u0003mS!A\r/\u000b\u0005us\u0016!C5oi\u0016\u0014h.\u00197t\u0015\tyv)A\u0004ti>\u0014\u0018mZ3\n\u0005\u0005\\&A\u0003'pON+w-\\3oi\u0006I1/Z4nK:$8\u000fI\u0001\u0007Y><G)\u001b:\u0016\u0003\u0015\u0004\"AZ6\u000e\u0003\u001dT!\u0001[5\u0002\u0005%|'\"\u00016\u0002\t)\fg/Y\u0005\u0003Y\u001e\u0014AAR5mK\u0006QAn\\4ESJ|F%Z9\u0015\u0005=\u0014\bC\u0001\u001dq\u0013\t\t\u0018H\u0001\u0003V]&$\bbB:\b\u0003\u0003\u0005\r!Z\u0001\u0004q\u0012\n\u0014a\u00027pO\u0012K'\u000fI\u0001\u000eGJ,\u0017\r^3TK\u001elWM\u001c;\u0015\u000be;H0a\u0001\t\u000baL\u0001\u0019A=\u0002\r=4gm]3u!\tA$0\u0003\u0002|s\t!Aj\u001c8h\u0011\u001di\u0018\u0002%AA\u0002y\f!#\u001b8eKbLe\u000e^3sm\u0006d')\u001f;fgB\u0011\u0001h`\u0005\u0004\u0003\u0003I$aA%oi\"I\u0011QA\u0005\u0011\u0002\u0003\u0007\u0011qA\u0001\u0005i&lW\r\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!R\u0001\u0006kRLGn]\u0005\u0005\u0003#\tYA\u0001\u0003US6,\u0017aF2sK\u0006$XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t9BK\u0002\u007f\u00033Y#!a\u0007\u0011\t\u0005u\u0011qE\u0007\u0003\u0003?QA!!\t\u0002$\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003KI\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011FA\u0010\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0018GJ,\u0017\r^3TK\u001elWM\u001c;%I\u00164\u0017-\u001e7uIM*\"!a\f+\t\u0005\u001d\u0011\u0011D\u0001\be\u0016\u001cwN\u001d3t)\u0019\t)$!\u0011\u0002DA!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<\u0015\u000baA]3d_J$\u0017\u0002BA \u0003s\u0011Q\"T3n_JL(+Z2pe\u0012\u001c\b\"\u0002=\r\u0001\u0004I\bbBA\u0019\u0019\u0001\u0007\u0011Q\t\t\u0006q\u0005\u001d\u00131J\u0005\u0004\u0003\u0013J$A\u0003\u001fsKB,\u0017\r^3e}A!\u0011QJA.\u001d\u0011\ty%a\u0016\u0011\u0007\u0005E\u0013(\u0004\u0002\u0002T)\u0019\u0011QK\u001b\u0002\rq\u0012xn\u001c;?\u0013\r\tI&O\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0013q\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005e\u0013(A\u0003tKR,\b\u000fF\u0001pQ\ri\u0011q\r\t\u0005\u0003S\n9(\u0004\u0002\u0002l)!\u0011QNA8\u0003\r\t\u0007/\u001b\u0006\u0005\u0003c\n\u0019(A\u0004kkBLG/\u001a:\u000b\u0007\u0005U$*A\u0003kk:LG/\u0003\u0003\u0002z\u0005-$A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1sI><h\u000eK\u0002\u000f\u0003\u007f\u0002B!!\u001b\u0002\u0002&!\u00111QA6\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u0018uKN$\u0018\t\u001d9f]\u00124uN\u001d'pON+w-\\3oi>3gm]3u\u001fZ,'O\u001a7po\u0016C8-\u001a9uS>tG#B8\u0002\n\u00065\u0005BBAF\u001f\u0001\u0007\u00110\u0001\u0006cCN,wJ\u001a4tKRDa!a$\u0010\u0001\u0004I\u0018!\u00047be\u001e,7\u000f^(gMN,G\u000fK\u0004\u0010\u0003'\u000b\u0019+!*\u0011\t\u0005U\u0015qT\u0007\u0003\u0003/SA!!'\u0002\u001c\u0006A\u0001O]8wS\u0012,'O\u0003\u0003\u0002\u001e\u0006=\u0014A\u00029be\u0006l7/\u0003\u0003\u0002\"\u0006]%!C\"tmN{WO]2f\u0003\u00151\u0018\r\\;fY9\t9+a+\u00020\u0006M\u0016qWA^\u0003\u007f\u000b#!!+\u0002\u001dAb\u0003%\f\u001a2i]\"\u0004h\r\u001c5q\u0005\u0012\u0011QV\u0001\u000ea1\u0002#'\r\u001b8ia\u001ad\u0007\u000e\u001d\"\u0005\u0005E\u0016\u0001B\u0019-AA\n#!!.\u0002\u000fE\u0002\u0004\u0007\f\u00112a\u0005\u0012\u0011\u0011X\u0001\u000eeE\"t\u0007\u000e\u001d4mQBD\u0006\t\u0019\"\u0005\u0005u\u0016AD\u00173cQ:D\u0007O\u001a7iab\u0003\u0005M\u0011\u0003\u0003\u0003\fQCM\u00195oQB4G\u000e\u001b9YQ\u0012\u0014\bN\u001d7oIJd\u0007K\u0002\u0010\u0003\u000b\u0004B!a2\u0002J6\u0011\u00111T\u0005\u0005\u0003\u0017\fYJA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fa\u0003^3tiJ+\u0017\rZ(o\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004!\u0005E\u0007\u0003BA5\u0003'LA!!6\u0002l\t!A+Z:u\u0003e!Xm\u001d;SK\u0006$')\u001a4pe\u00164\u0015N]:u\u001f\u001a47/\u001a;)\u0007E\t\t.A\tuKN$(+Z1e\u0003\u001a$XM\u001d'bgRD3AEAi\u0003=!Xm\u001d;SK\u0006$gI]8n\u000f\u0006\u0004\bfA\n\u0002R\u0006IB/Z:u%\u0016\fGm\u00165f]:{W*\u0019=Q_NLG/[8o)\ry\u0017q\u001d\u0005\b\u0003S$\u0002\u0019AAv\u00035i\u0017N\\(oK6+7o]1hKB\u0019\u0001(!<\n\u0007\u0005=\u0018HA\u0004C_>dW-\u00198)\u000fQ\t\u00190!?\u0002|B!\u0011QSA{\u0013\u0011\t90a&\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\tE>|G.Z1og2\"\u0011Q`A\u00003\u0005\t\u0011$\u0001\u0001)\u000fQ\t)Ma\u0001\u0003\u0006\u0005!a.Y7fC\t\u00119!A\u0017uKN$(+Z1e/\",gNT8NCb\u0004vn]5uS>t\u0007%\\5o\u001f:,W*Z:tC\u001e,\u0007%\u0010\u0011|au\fA\u0002^3tiR\u0013XO\\2bi\u0016D3!FAi\u0003a!Xm\u001d;UeVt7-\u0019;f\u000b6\u0004H/_*fO6,g\u000e\u001e\u0015\u0004-\u0005E\u0017A\u000e;fgR\u0014V\r\\8bI2\u000b'oZ3tiRKW.Z:uC6\u0004\u0018I\u001c3OKb$xJ\u001a4tKR\fe\r^3s)J,hnY1uS>t\u0007fA\f\u0002R\u0006\u0001B/Z:u)J,hnY1uK\u001a+H\u000e\u001c\u0015\u00041\u0005E\u0017!\u0007;fgR4\u0015N\u001c3PM\u001a\u001cX\r\u001e\"z)&lWm\u001d;b[BD3!GAi\u0003e!Xm\u001d;OKb$xJ\u001a4tKR\u001c\u0015\r\\2vY\u0006$\u0018n\u001c8)\u0007i\t\t.\u0001\fuKN$8\t[1oO\u00164\u0015\u000e\\3Tk\u001a4\u0017\u000e_3tQ\rY\u0012\u0011[\u0001\u001ei\u0016\u001cHOU3d_Z,'/\u001f$jq\u0016\u001c8i\u001c:skB$\u0018J\u001c3fq\"\u001aA$!5\u00027Q,7\u000f\u001e*fG>4XM\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000eZ3yQ\ri\u0012\u0011[\u0001\u001fi\u0016\u001cHOU3d_Z,'/\u001f*fEVLG\u000eZ:Fa>\u001c\u0007nQ1dQ\u0016D3AHAi\u00035)g\u000e\u001a+y]J+7m\u001c:egR\u0001\u0012Q\u0007B\u001b\u0005\u007f\u0011\u0019E!\u0014\u0003P\tM#q\u000b\u0005\b\u0005oy\u0002\u0019\u0001B\u001d\u0003E\u0019wN\u001c;s_2\u0014VmY8sIRK\b/\u001a\t\u0005\u0003o\u0011Y$\u0003\u0003\u0003>\u0005e\"!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"1!\u0011I\u0010A\u0002e\f!\u0002\u001d:pIV\u001cWM]%e\u0011\u001d\u0011)e\ba\u0001\u0005\u000f\nQ\u0002\u001d:pIV\u001cWM]#q_\u000eD\u0007c\u0001\u001d\u0003J%\u0019!1J\u001d\u0003\u000bMCwN\u001d;\t\u000ba|\u0002\u0019A=\t\u0011\tEs\u0004%AA\u0002y\fA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0007\u0002\u0003B+?A\u0005\t\u0019\u0001@\u0002!\r|wN\u001d3j]\u0006$xN]#q_\u000eD\u0007\u0002\u0003B-?A\u0005\t\u0019A=\u0002\u0013QLW.Z:uC6\u0004\u0018aF3oIRChNU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003])g\u000e\u001a+y]J+7m\u001c:eg\u0012\"WMZ1vYR$c'A\ff]\u0012$\u0006P\u001c*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\r\u0016\u0004s\u0006e\u0011!\t;fgR\u0014VmY8wKJLh)\u001b=fg\u000e{'O];qiRKW.Z%oI\u0016D\bfA\u0012\u0002R\u0006qB/Z:u%\u0016\u001cwN^3ss^KG\u000f[\"peJ,\b\u000f^'fgN\fw-\u001a\u0015\u0004I\u0005EG#C-\u0003p\tE$Q\u000fB=\u0011\u0019\tY)\na\u0001s\"9!1O\u0013A\u0002\u0005-\u0018!\u00054jY\u0016\fEN]3bIf,\u00050[:ug\"1!qO\u0013A\u0002y\fA\"\u001b8ji\u001aKG.Z*ju\u0016DqAa\u001f&\u0001\u0004\tY/A\u0006qe\u0016\fG\u000e\\8dCR,\u0017a\n;fgR\u001c%/Z1uK^KG\u000f[%oSR4\u0015\u000e\\3TSj,\u0017\t\u001d9f]\u0012lUm]:bO\u0016D3AJAi\u0003\u001d\"Xm\u001d;De\u0016\fG/Z,ji\"Le.\u001b;GS2,7+\u001b>f\u00072,\u0017M]*ikR$wn\u001e8)\u0007\u001d\n\t.\u0001\u0018tQ>,H\u000e\u001a+sk:\u001c\u0017\r^3Fm\u0016t\u0017JZ(gMN,G\u000fU8j]R\u001cHk\\!HCBLe\u000e\u00165f\u0019><\u0007f\u0001\u0015\u0002R\u0006\u0011B/Z:u\u0003B\u0004XM\u001c3Ge>lg)\u001b7fQ\rI\u0013\u0011[\u0001\u001bi\u0016\u001cHoR3u\r&\u00148\u000f\u001e\"bi\u000eDG+[7fgR\fW\u000e\u001d\u0015\u0004U\u0005E\u0017A\u000b;fgRLe\u000eZ3y\r>\u0014X*\u001e7uSBdWMQ1uG\",7/\u00138NK6|'/\u001f*fG>\u0014Hm\u001d\u0015\u0004W\u0005E\u0017!O3ti:{g.T8o_R|g.[2US6,7\u000f^1na\u001a{'/T;mi&\u0004H.\u001a\"bi\u000eDWm]%o\u001b\u0016lwN]=SK\u000e|'\u000fZ:)\u00071\n\t.A\foK^\u0004&o\u001c3vG\u0016\u00148\u000b^1uK6\u000bg.Y4feR\u0011!Q\u0014\t\u00045\n}\u0015b\u0001BQ7\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f1b\u00195fG.,\u0015/^1mgV!!q\u0015B_)\u0015y'\u0011\u0016Bh\u0011\u001d\u0011YK\fa\u0001\u0005[\u000b!a]\u0019\u0011\r\t=&Q\u0017B]\u001b\t\u0011\tLC\u0002\u00034&\fA!\u001e;jY&!!q\u0017BY\u0005!IE/\u001a:bi>\u0014\b\u0003\u0002B^\u0005{c\u0001\u0001B\u0004\u0003@:\u0012\rA!1\u0003\u0003Q\u000bBAa1\u0003JB\u0019\u0001H!2\n\u0007\t\u001d\u0017HA\u0004O_RD\u0017N\\4\u0011\u0007a\u0012Y-C\u0002\u0003Nf\u00121!\u00118z\u0011\u001d\u0011\tN\fa\u0001\u0005[\u000b!a\u001d\u001a\u0002']\u0014\u0018\u000e^3O_:\u001cXM\\:f)>4\u0015\u000e\\3\u0015\u000f=\u00149Na7\u0003`\"1!\u0011\\\u0018A\u0002\u0015\f\u0001BZ5mK:\u000bW.\u001a\u0005\u0007\u0005;|\u0003\u0019A=\u0002\u0011A|7/\u001b;j_:DaA!90\u0001\u0004q\u0018\u0001B:ju\u0016\u0004")
public class LogSegmentTest {
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final ArrayBuffer<LogSegment> segments = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private File logDir;

    private TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ArrayBuffer<LogSegment> segments() {
        return this.segments;
    }

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    public LogSegment createSegment(long offset, int indexIntervalBytes, Time time) {
        LogSegment seg = LogTestUtils$.MODULE$.createSegment(offset, this.logDir(), indexIntervalBytes, time);
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public MemoryRecords records(long offset, Seq<String> records) {
        return MemoryRecords.withRecords((byte)1, (long)offset, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])((SimpleRecord[])((TraversableOnce)records.map((Function1 & Serializable & scala.Serializable)s -> new SimpleRecord(offset * 10L, s.getBytes()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
    }

    @BeforeEach
    public void setup() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
    }

    @AfterEach
    public void teardown() {
        this.segments().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        Utils.delete((File)this.logDir());
    }

    @ParameterizedTest
    @CsvSource(value={"0, -2147483648", "0, 2147483648", "1, 0", "100, 10", "2147483648, 0", "-2147483648, 0", "2147483648,4294967296"})
    public void testAppendForLogSegmentOffsetOverflowException(long baseOffset, long largestOffset) {
        LogSegment seg = this.createSegment(baseOffset, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords memoryRecords = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
        Assertions.assertThrows(LogSegmentOffsetOverflowException.class, () -> seg.append(largestOffset, memoryRecords));
    }

    @Test
    public void testReadOnEmptySegment() {
        Assertions.assertNull((Object)this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3()).read(40L, 300), (String)"Read beyond the last offset in the segment should be null");
    }

    @Test
    public void testReadBeforeFirstOffset() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "little", "bee"}));
        seg.append(53L, ms);
        Records read = seg.read((long)41L, (int)300).records;
        this.checkEquals(ms.records().iterator(), read.records().iterator());
    }

    @Test
    public void testReadAfterLast() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        Assertions.assertNull((Object)seg.read(52L, 200), (String)"Read beyond the last offset in the segment should give null");
    }

    @Test
    public void testReadFromGap() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @ParameterizedTest(name="testReadWhenNoMaxPosition minOneMessage = {0}")
    @ValueSource(booleans={true, false})
    public void testReadWhenNoMaxPosition(boolean minOneMessage) {
        Optional maxPosition = Optional.empty();
        int maxSize = 1;
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        FetchDataInfo read = seg.read(48L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(48L, 40L, 0), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(read.records.records().iterator()).asScala()).isEmpty());
        read = seg.read(50L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(50L, 40L, 0), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(read.records.records().iterator()).asScala()).isEmpty());
        read = seg.read(51L, maxSize, maxPosition, minOneMessage);
        Assertions.assertEquals((Object)new LogOffsetMetadata(51L, 40L, 39), (Object)read.fetchOffsetMetadata);
        Assertions.assertTrue((boolean)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(read.records.records().iterator()).asScala()).isEmpty());
        read = seg.read(52L, maxSize, maxPosition, minOneMessage);
        Assertions.assertNull((Object)read);
        read = seg.read(53L, maxSize, maxPosition, minOneMessage);
        Assertions.assertNull((Object)read);
    }

    @Test
    public void testTruncate() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 30).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            MemoryRecords ms1 = this.records(offset$2.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)offset$2.elem, ms1);
            MemoryRecords ms2 = this.records(offset$2.elem + 1, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"}));
            seg.append((long)(offset$2.elem + 1), ms2);
            FetchDataInfo read = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((Object)new .colon.colon((Object)((Record)ms1.records().iterator().next()), (List)new .colon.colon((Object)((Record)ms2.records().iterator().next()), (List)Nil$.MODULE$)), (Object)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read.records.records()).asScala()).toList());
            seg.truncateTo((long)(offset$2.elem + 1));
            FetchDataInfo read2 = seg.read((long)offset$2.elem, 10000);
            Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(read2.records.records()).asScala()).size());
            this.checkEquals(ms1.records().iterator(), read2.records.records().iterator());
            ++offset$2.elem;
        });
    }

    @Test
    public void testTruncateEmptySegment() {
        int maxSegmentMs = 300000;
        MockTime time = new MockTime();
        long x$1 = 0L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.timeIndex();
        seg.offsetIndex();
        seg.close();
        long x$4 = 0L;
        int x$6 = this.createSegment$default$2();
        LogSegment reopened = this.createSegment(x$4, x$6, (Time)time);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().sizeInBytes());
        Assertions.assertEquals((int)0, (int)seg.offsetIndex().sizeInBytes());
        time.sleep(500L);
        reopened.truncateTo(57L);
        Assertions.assertEquals((long)0L, (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)reopened.timeIndex().isFull());
        Assertions.assertFalse((boolean)reopened.offsetIndex().isFull());
        RollParams rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        time.sleep((long)(maxSegmentMs + 1));
        Assertions.assertEquals((long)(maxSegmentMs + 1), (long)reopened.timeWaitedForRoll(time.milliseconds(), -1L));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, 100L, 1024, time.milliseconds());
        Assertions.assertFalse((boolean)reopened.shouldRoll(rollParams));
        rollParams = new RollParams((long)maxSegmentMs, Integer.MAX_VALUE, -1L, (long)Integer.MAX_VALUE + 200L, 1024, time.milliseconds());
        Assertions.assertTrue((boolean)reopened.shouldRoll(rollParams));
    }

    @Test
    public void testReloadLargestTimestampAndNextOffsetAfterTruncation() {
        int numMessages = 30;
        LogSegment seg = this.createSegment(40L, 2 * this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})).sizeInBytes() - 1, this.createSegment$default$3());
        IntRef offset = IntRef.create((int)40);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            seg.append((long)offset$3.elem, this.records(offset$3.elem, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello"})));
            ++offset$3.elem;
        });
        Assertions.assertEquals((long)offset.elem, (long)seg.readNextOffset());
        int expectedNumEntries = numMessages / 2 - 1;
        Assertions.assertEquals((int)expectedNumEntries, (int)seg.timeIndex().entries(), (String)new StringBuilder(25).append("Should have ").append(expectedNumEntries).append(" time indexes").toString());
        seg.truncateTo(41L);
        Assertions.assertEquals((int)0, (int)seg.timeIndex().entries(), (String)"Should have 0 time indexes");
        Assertions.assertEquals((long)400L, (long)seg.largestTimestamp(), (String)"Largest timestamp should be 400");
        Assertions.assertEquals((long)41L, (long)seg.readNextOffset());
    }

    @Test
    public void testTruncateFull() {
        MockTime time = new MockTime();
        long x$1 = 40L;
        int x$3 = this.createSegment$default$2();
        LogSegment seg = this.createSegment(x$1, x$3, (Time)time);
        seg.append(41L, MemoryRecords.withRecords((byte)1, (long)40L, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}));
        time.sleep(500L);
        Assertions.assertEquals((long)500L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        seg.truncateTo(0L);
        Assertions.assertEquals((long)0L, (long)seg.timeWaitedForRoll(time.milliseconds(), -1L));
        Assertions.assertFalse((boolean)seg.timeIndex().isFull());
        Assertions.assertFalse((boolean)seg.offsetIndex().isFull());
        Assertions.assertNull((Object)seg.read(0L, 1024), (String)"Segment should be empty.");
        seg.append(41L, this.records(40L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"})));
    }

    @Test
    public void testFindOffsetByTimestamp() {
        int messageSize = this.records(0L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"msg00"})).sizeInBytes();
        LogSegment seg = this.createSegment(40L, messageSize * 2 - 1, this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(40), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(3).append("msg").append(i).toString()}))));
        Assertions.assertEquals((long)490L, (long)seg.largestTimestamp());
        Assertions.assertEquals((long)42L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)420L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)421L, (long)0L).get()).offset);
        Assertions.assertEquals((long)43L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)430L, (long)0L).get()).offset);
        Assertions.assertEquals((long)44L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)431L, (long)0L).get()).offset);
        Assertions.assertEquals(Optional.empty(), (Object)seg.findOffsetByTimestamp(491L, 0L));
        Assertions.assertEquals((long)41L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)401L, (long)0L).get()).offset);
        Assertions.assertEquals((long)40L, (long)((FileRecords.TimestampAndOffset)seg.findOffsetByTimestamp((long)399L, (long)0L).get()).offset);
    }

    @Test
    public void testNextOffsetCalculation() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)40L, (long)seg.readNextOffset());
        seg.append(52L, this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there", "you"})));
        Assertions.assertEquals((long)53L, (long)seg.readNextOffset());
    }

    @Test
    public void testChangeFileSuffixes() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        File logFile = seg.log().file();
        File indexFile = seg.offsetIndexFile();
        File timeIndexFile = seg.timeIndexFile();
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        seg.changeFileSuffixes("", ".deleted");
        Assertions.assertFalse((boolean)seg.offsetIndexFile().exists());
        Assertions.assertFalse((boolean)seg.timeIndexFile().exists());
        Assertions.assertEquals((Object)new StringBuilder(8).append(logFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.log().file().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(indexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.offsetIndexFile().getAbsolutePath());
        Assertions.assertEquals((Object)new StringBuilder(8).append(timeIndexFile.getAbsolutePath()).append(".deleted").toString(), (Object)seg.timeIndexFile().getAbsolutePath());
        Assertions.assertTrue((boolean)seg.log().file().exists());
        seg.offsetIndex();
        Assertions.assertTrue((boolean)seg.offsetIndexFile().exists());
        seg.timeIndex();
        Assertions.assertTrue((boolean)seg.timeIndexFile().exists());
    }

    @Test
    public void testRecoveryFixesCorruptIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File indexFile = seg.offsetIndexFile();
        this.writeNonsenseToFile(indexFile, 5L, (int)indexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Iterable records = seg$5.read((long)((long)i), (int)1, Optional.of(Predef$.MODULE$.long2Long((long)((long)seg$5.size()))), (boolean)true).records.records();
            Assertions.assertEquals((long)i, (long)((Record)records.iterator().next()).offset());
        });
    }

    @Test
    public void testRecoverTransactionIndex() {
        LogSegment segment = this.createSegment(100L, this.createSegment$default$2(), this.createSegment$default$3());
        short producerEpoch = (short)0;
        int partitionLeaderEpoch = 15;
        int sequence = 100;
        long pid1 = 5L;
        long pid2 = 10L;
        segment.append(101L, MemoryRecords.withTransactionalRecords((long)100L, (Compression)Compression.NONE, (long)pid1, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(103L, MemoryRecords.withTransactionalRecords((long)102L, (Compression)Compression.NONE, (long)pid2, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(105L, MemoryRecords.withRecords((long)104L, (Compression)Compression.NONE, (int)partitionLeaderEpoch, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        segment.append(106L, this.endTxnRecords(ControlRecordType.ABORT, pid2, producerEpoch, 106L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        segment.append(107L, this.endTxnRecords(ControlRecordType.COMMIT, pid1, producerEpoch, 107L, this.endTxnRecords$default$5(), this.endTxnRecords$default$6(), this.endTxnRecords$default$7()));
        ProducerStateManager stateManager = this.newProducerStateManager();
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        java.util.List abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        AbortedTxn abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)102L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
        stateManager = this.newProducerStateManager();
        stateManager.loadProducerEntry(new ProducerStateEntry(pid2, producerEpoch, 0, -1L, OptionalLong.of(75L), Optional.of(new BatchMetadata(10, 10L, 5, -1L))));
        segment.recover(stateManager, Optional.empty());
        Assertions.assertEquals((long)108L, (long)stateManager.mapEndOffset());
        abortedTxns = segment.txnIndex().allAbortedTxns();
        Assertions.assertEquals((int)1, (int)abortedTxns.size());
        abortedTxn = (AbortedTxn)abortedTxns.get(0);
        Assertions.assertEquals((long)pid2, (long)abortedTxn.producerId());
        Assertions.assertEquals((long)75L, (long)abortedTxn.firstOffset());
        Assertions.assertEquals((long)106L, (long)abortedTxn.lastOffset());
        Assertions.assertEquals((long)100L, (long)abortedTxn.lastStableOffset());
    }

    @Test
    public void testRecoveryRebuildsEpochCache() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(TestUtils$.MODULE$.tempFile(), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache = new LeaderEpochFileCache(this.topicPartition(), checkpoint, (Scheduler)new MockScheduler((Time)new MockTime()));
        seg.append(105L, MemoryRecords.withRecords((long)104L, (Compression)Compression.NONE, (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(107L, MemoryRecords.withRecords((long)106L, (Compression)Compression.NONE, (int)1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(109L, MemoryRecords.withRecords((long)108L, (Compression)Compression.NONE, (int)1, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.append(111L, MemoryRecords.withRecords((long)110L, (Compression)Compression.NONE, (int)2, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("a".getBytes()), new SimpleRecord("b".getBytes())}));
        seg.recover(this.newProducerStateManager(), Optional.of(cache));
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 104L), new EpochEntry(1, 106L), new EpochEntry(2, 110L)}), (Object)cache.epochEntries());
    }

    private MemoryRecords endTxnRecords(ControlRecordType controlRecordType, long producerId, short producerEpoch, long offset, int partitionLeaderEpoch, int coordinatorEpoch, long timestamp) {
        EndTransactionMarker marker = new EndTransactionMarker(controlRecordType, coordinatorEpoch);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)partitionLeaderEpoch, (long)producerId, (short)producerEpoch, (EndTransactionMarker)marker);
    }

    private int endTxnRecords$default$5() {
        return 0;
    }

    private int endTxnRecords$default$6() {
        return 0;
    }

    private long endTxnRecords$default$7() {
        return -1L;
    }

    @Test
    public void testRecoveryFixesCorruptTimeIndex() {
        LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
        File timeIndexFile = seg.timeIndexFile();
        this.writeNonsenseToFile(timeIndexFile, 5L, (int)timeIndexFile.length());
        seg.recover(this.newProducerStateManager(), Optional.empty());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Assertions.assertEquals((long)i, (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10)), (long)0L).get()).offset);
            if (i < 99) {
                Assertions.assertEquals((long)(i + 1), (long)((FileRecords.TimestampAndOffset)seg$6.findOffsetByTimestamp((long)((long)(i * 10 + 1)), (long)0L).get()).offset);
                return;
            }
        });
    }

    @Test
    public void testRecoveryWithCorruptMessage() {
        int messagesAppended = 20;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            LogSegment seg = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesAppended).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> seg.append((long)i, this.records(i, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Integer.toString(i)}))));
            int offsetToBeginCorruption = TestUtils$.MODULE$.random().nextInt(messagesAppended);
            int position = seg.log().searchForOffsetWithSize((long)((long)offsetToBeginCorruption), (int)0).position + TestUtils$.MODULE$.random().nextInt(15);
            this.writeNonsenseToFile(seg.log().file(), position, (int)(seg.log().file().length() - (long)position));
            seg.recover(this.newProducerStateManager(), Optional.empty());
            Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), offsetToBeginCorruption).toList(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(seg.log().batches()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lastOffset()), Iterable$.MODULE$.canBuildFrom())).toList(), (String)"Should have truncated off bad messages.");
            seg.deleteIfExists();
        });
    }

    private LogSegment createSegment(long baseOffset, boolean fileAlreadyExists, int initFileSize, boolean preallocate) {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)baseOffset, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)fileAlreadyExists, (int)initFileSize, (boolean)preallocate, (String)"");
        this.segments().$plus$eq((Object)seg);
        return seg;
    }

    public int createSegment$default$2() {
        return 10;
    }

    public Time createSegment$default$3() {
        return Time.SYSTEM;
    }

    @Test
    public void testCreateWithInitFileSizeAppendMessage() {
        LogSegment seg = this.createSegment(40L, false, 0x20000000, true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
    }

    @Test
    public void testCreateWithInitFileSizeClearShutdown() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        LogConfig logConfig = new LogConfig((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"index.interval.bytes"), (Object)BoxesRunTime.boxToInteger((int)10)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.index.bytes"), (Object)BoxesRunTime.boxToInteger((int)1000)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"segment.jitter.ms"), (Object)BoxesRunTime.boxToInteger((int)0))}))).asJava());
        LogSegment seg = LogSegment.open((File)tempDir, (long)40L, (LogConfig)logConfig, (Time)Time.SYSTEM, (int)0x20000000, (boolean)true);
        MemoryRecords ms = this.records(50L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hello", "there"}));
        seg.append(51L, ms);
        MemoryRecords ms2 = this.records(60L, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"alpha", "beta"}));
        seg.append(61L, ms2);
        FetchDataInfo read = seg.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), read.records.records().iterator());
        int oldSize = seg.log().sizeInBytes();
        long oldPosition = seg.log().channel().position();
        long oldFileSize = seg.log().file().length();
        Assertions.assertEquals((long)0x20000000L, (long)oldFileSize);
        seg.close();
        Assertions.assertEquals((long)oldSize, (long)seg.log().file().length());
        LogSegment segReopen = LogSegment.open((File)tempDir, (long)40L, (LogConfig)logConfig, (Time)Time.SYSTEM, (boolean)true, (int)0x20000000, (boolean)true, (String)"");
        this.segments().$plus$eq((Object)segReopen);
        FetchDataInfo readAgain = segReopen.read(55L, 200);
        this.checkEquals(ms2.records().iterator(), readAgain.records.records().iterator());
        int size = segReopen.log().sizeInBytes();
        long position = segReopen.log().channel().position();
        long fileSize = segReopen.log().file().length();
        Assertions.assertEquals((long)oldPosition, (long)position);
        Assertions.assertEquals((int)oldSize, (int)size);
        Assertions.assertEquals((long)size, (long)fileSize);
    }

    @Test
    public void shouldTruncateEvenIfOffsetPointsToAGapInTheLog() {
        LogSegment seg = this.createSegment(40L, this.createSegment$default$2(), this.createSegment$default$3());
        int offset = 40;
        MemoryRecords ms1 = LogSegmentTest.records$1(offset, "first message");
        seg.append((long)offset, ms1);
        MemoryRecords ms2 = LogSegmentTest.records$1(offset + 3, "message after gap");
        seg.append((long)(offset + 3), ms2);
        seg.truncateTo((long)(offset + 1));
        FetchDataInfo log = seg.read((long)offset, 10000);
        Assertions.assertEquals((long)offset, (long)((RecordBatch)log.records.batches().iterator().next()).baseOffset());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(log.records.batches()).asScala()).size());
    }

    @Test
    public void testAppendFromFile() {
        File tempDir = TestUtils$.MODULE$.tempDir();
        FileRecords fileRecords = FileRecords.open((File)LogFileUtils.logFile((File)tempDir, (long)0L));
        fileRecords.append(LogSegmentTest.records$2(0L, 1024));
        fileRecords.append(LogSegmentTest.records$2(500L, 0x100001));
        int sizeBeforeOverflow = fileRecords.sizeInBytes();
        fileRecords.append(LogSegmentTest.records$2(0x80000004L, 1024));
        int sizeAfterOverflow = fileRecords.sizeInBytes();
        LogSegment segment = this.createSegment(0L, this.createSegment$default$2(), this.createSegment$default$3());
        int bytesAppended = segment.appendFromFile(fileRecords, 0);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)bytesAppended);
        Assertions.assertEquals((int)sizeBeforeOverflow, (int)segment.size());
        LogSegment overflowSegment = this.createSegment(Integer.MAX_VALUE, this.createSegment$default$2(), this.createSegment$default$3());
        int overflowBytesAppended = overflowSegment.appendFromFile(fileRecords, sizeBeforeOverflow);
        Assertions.assertEquals((int)(sizeAfterOverflow - sizeBeforeOverflow), (int)overflowBytesAppended);
        Assertions.assertEquals((int)overflowBytesAppended, (int)overflowSegment.size());
        Utils.delete((File)tempDir);
    }

    @Test
    public void testGetFirstBatchTimestamp() {
        LogSegment segment = this.createSegment(1L, this.createSegment$default$2(), this.createSegment$default$3());
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)segment.getFirstBatchTimestamp());
        segment.append(1L, MemoryRecords.withRecords((long)1L, (Compression)Compression.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(1000L, "one".getBytes())}));
        Assertions.assertEquals((long)1000L, (long)segment.getFirstBatchTimestamp());
        segment.close();
    }

    @Test
    public void testIndexForMultipleBatchesInMemoryRecords() {
        LogSegment segment = this.createSegment(0L, 1, Time.SYSTEM);
        ByteBuffer buffer1 = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer1, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(0L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer1, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(1L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        buffer1.flip();
        MemoryRecords record = MemoryRecords.readableRecords((ByteBuffer)buffer1);
        segment.append(1L, record);
        ByteBuffer buffer2 = ByteBuffer.allocate(1024);
        builder = MemoryRecords.builder((ByteBuffer)buffer2, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(2L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        buffer2.flip();
        record = MemoryRecords.readableRecords((ByteBuffer)buffer2);
        segment.append(2L, record);
        Assertions.assertEquals((int)2, (int)segment.offsetIndex().entries());
        Assertions.assertEquals((long)1L, (long)segment.offsetIndex().entry((int)0).offset);
        Assertions.assertEquals((long)2L, (long)segment.offsetIndex().entry((int)1).offset);
        Assertions.assertEquals((int)2, (int)segment.timeIndex().entries());
        Assertions.assertEquals((Object)new TimestampOffset(1L, 1L), (Object)segment.timeIndex().entry(0));
        Assertions.assertEquals((Object)new TimestampOffset(2L, 2L), (Object)segment.timeIndex().entry(1));
    }

    @Test
    public void estNonMonotonicTimestampForMultipleBatchesInMemoryRecords() {
        LogSegment segment = this.createSegment(0L, 1, Time.SYSTEM);
        ByteBuffer buffer1 = ByteBuffer.allocate(1024);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer1, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(1L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer1, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(0L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buffer1, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)2L);
        builder.append(2L, "key1".getBytes(), "value1".getBytes());
        builder.close();
        buffer1.flip();
        MemoryRecords record = MemoryRecords.readableRecords((ByteBuffer)buffer1);
        segment.append(2L, record);
        Assertions.assertEquals((int)2, (int)segment.offsetIndex().entries());
        Assertions.assertEquals((long)1L, (long)segment.offsetIndex().entry((int)0).offset);
        Assertions.assertEquals((long)2L, (long)segment.offsetIndex().entry((int)1).offset);
        Assertions.assertEquals((int)2, (int)segment.timeIndex().entries());
        Assertions.assertEquals((Object)new TimestampOffset(1L, 0L), (Object)segment.timeIndex().entry(0));
        Assertions.assertEquals((Object)new TimestampOffset(2L, 2L), (Object)segment.timeIndex().entry(1));
    }

    private ProducerStateManager newProducerStateManager() {
        return new ProducerStateManager(this.topicPartition(), this.logDir(), 300000, new ProducerStateManagerConfig(86400000, false), (Time)new MockTime());
    }

    private <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assertions.assertEquals(s1.next(), s2.next());
        }
        Assertions.assertFalse((boolean)s1.hasNext(), (String)"Iterators have uneven length--first has more");
        Assertions.assertFalse((boolean)s2.hasNext(), (String)"Iterators have uneven length--second has more");
    }

    private void writeNonsenseToFile(File fileName, long position, int size) {
        try (RandomAccessFile file = new RandomAccessFile(fileName, "rw");){
            file.seek(position);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> file.writeByte(TestUtils$.MODULE$.random().nextInt(255)));
        }
    }

    private static final MemoryRecords records$1(long offset, String record) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(offset * 1000L, record.getBytes())});
    }

    private static final MemoryRecords records$2(long offset, int size) {
        return MemoryRecords.withRecords((byte)2, (long)offset, (Compression)Compression.NONE, (TimestampType)TimestampType.CREATE_TIME, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new byte[size])});
    }
}

