/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import kafka.server.BaseClientQuotaManagerTest;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManager$;
import kafka.server.ClientQuotaManagerTest$UserClient$;
import kafka.server.QuotaType;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.network.Session;
import org.apache.kafka.server.config.ClientQuotaManagerConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5c\u0001\u0002\u001c8\u0001qBQ!\u0011\u0001\u0005\u0002\tCq\u0001\u0012\u0001C\u0002\u0013%Q\t\u0003\u0004R\u0001\u0001\u0006IA\u0012\u0005\u0006%\u0002!Ia\u0015\u0005\b\u0003G\u0003A\u0011AAS\u0011\u001d\ti\f\u0001C\u0001\u0003KCq!!1\u0001\t\u0003\t)\u000bC\u0004\u0002F\u0002!\t!!*\t\u000f\u0005%\u0007\u0001\"\u0001\u0002&\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0007bBAy\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0003k\u0004A\u0011AAS\u0011\u001d\tI\u0010\u0001C\u0001\u0003KCq!!@\u0001\t\u0003\t)\u000bC\u0004\u0003\u0002\u0001!\t!!*\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002&\"9!\u0011\u0002\u0001\u0005\u0002\u0005\u0015\u0006b\u0002B\u0007\u0001\u0011\u0005\u0011Q\u0015\u0005\b\u0005#\u0001A\u0011AAS\r\u0011y\u0006\u0001\u00121\t\u0011)$\"Q3A\u0005\u0002-D\u0001b\u001e\u000b\u0003\u0012\u0003\u0006I\u0001\u001c\u0005\tqR\u0011)\u001a!C\u0001W\"A\u0011\u0010\u0006B\tB\u0003%A\u000e\u0003\u0005{)\tU\r\u0011\"\u0001|\u0011!yHC!E!\u0002\u0013a\b\"CA\u0001)\tU\r\u0011\"\u0001|\u0011%\t\u0019\u0001\u0006B\tB\u0003%A\u0010\u0003\u0004B)\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f!B\u0011AA\t\u0011%\t\u0019\u0003FA\u0001\n\u0003\t)\u0003C\u0005\u00020Q\t\n\u0011\"\u0001\u00022!I\u0011q\t\u000b\u0012\u0002\u0013\u0005\u0011\u0011\u0007\u0005\n\u0003\u0013\"\u0012\u0013!C\u0001\u0003\u0017B\u0011\"a\u0014\u0015#\u0003%\t!a\u0013\t\u0013\u0005EC#!A\u0005B\u0005M\u0003\"CA+)\u0005\u0005I\u0011AA,\u0011%\ty\u0006FA\u0001\n\u0003\t\t\u0007C\u0005\u0002nQ\t\t\u0011\"\u0011\u0002p!I\u0011Q\u0010\u000b\u0002\u0002\u0013\u0005\u0011q\u0010\u0005\n\u0003\u0013#\u0012\u0011!C!\u0003\u0017C\u0011\"!$\u0015\u0003\u0003%\t%a$\t\u0013\u0005EE#!A\u0005B\u0005Mu!\u0003B\u000b\u0001\u0005\u0005\t\u0012\u0002B\f\r!y\u0006!!A\t\n\te\u0001BB!.\t\u0003\u00119\u0003C\u0005\u0002\u000e6\n\t\u0011\"\u0012\u0002\u0010\"I!\u0011F\u0017\u0002\u0002\u0013\u0005%1\u0006\u0005\n\u0005ki\u0013\u0013!C\u0001\u0003\u0017B\u0011Ba\u000e.#\u0003%\t!a\u0013\t\u0013\teR&!A\u0005\u0002\nm\u0002\"\u0003B%[E\u0005I\u0011AA&\u0011%\u0011Y%LI\u0001\n\u0003\tYE\u0001\fDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014H+Z:u\u0015\tA\u0014(\u0001\u0004tKJ4XM\u001d\u0006\u0002u\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001>!\tqt(D\u00018\u0013\t\u0001uG\u0001\u000eCCN,7\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002\u0007B\u0011a\bA\u0001\u0007G>tg-[4\u0016\u0003\u0019\u0003\"aR(\u000e\u0003!S!\u0001R%\u000b\u0005aR%B\u0001\u001eL\u0015\taU*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001d\u0006\u0019qN]4\n\u0005AC%\u0001G\"mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u001cuN\u001c4jO\u000691m\u001c8gS\u001e\u0004\u0013\u0001\u0005;fgR\fVo\u001c;b!\u0006\u00148/\u001b8h)%!&lWAL\u00037\u000by\n\u0005\u0002V16\taKC\u0001X\u0003\u0015\u00198-\u00197b\u0013\tIfK\u0001\u0003V]&$\b\"\u0002#\u0005\u0001\u00041\u0005\"\u0002/\u0005\u0001\u0004i\u0016aB2mS\u0016tG/\r\t\u0003=Ri\u0011\u0001\u0001\u0002\u000b+N,'o\u00117jK:$8\u0003\u0002\u000bbI\u001e\u0004\"!\u00162\n\u0005\r4&AB!osJ+g\r\u0005\u0002VK&\u0011aM\u0016\u0002\b!J|G-^2u!\t)\u0006.\u0003\u0002j-\na1+\u001a:jC2L'0\u00192mK\u0006!Qo]3s+\u0005a\u0007CA7u\u001d\tq'\u000f\u0005\u0002p-6\t\u0001O\u0003\u0002rw\u00051AH]8pizJ!a\u001d,\u0002\rA\u0013X\rZ3g\u0013\t)hO\u0001\u0004TiJLgn\u001a\u0006\u0003gZ\u000bQ!^:fe\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\nG2LWM\u001c;JI\u0002\n!bY8oM&<Wk]3s+\u0005a\bcA+~Y&\u0011aP\u0016\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0017\r|gNZ5h+N,'\u000fI\u0001\u000fG>tg-[4DY&,g\u000e^%e\u0003=\u0019wN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012\u0004C#C/\u0002\b\u0005%\u00111BA\u0007\u0011\u0015QW\u00041\u0001m\u0011\u0015AX\u00041\u0001m\u0011\u001dQX\u0004%AA\u0002qD\u0001\"!\u0001\u001e!\u0003\u0005\r\u0001`\u0001\u0018g\u0006t\u0017\u000e^5{K\u0012\u001cuN\u001c4jO\u000ec\u0017.\u001a8u\u0013\u0012,\"!a\u0005\u0011\tUk\u0018Q\u0003\t\u0005\u0003/\t\t#\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0011\u0001\u00026bm\u0006L1!^A\r\u0003\u0011\u0019w\u000e]=\u0015\u0013u\u000b9#!\u000b\u0002,\u00055\u0002b\u00026 !\u0003\u0005\r\u0001\u001c\u0005\bq~\u0001\n\u00111\u0001m\u0011\u001dQx\u0004%AA\u0002qD\u0001\"!\u0001 !\u0003\u0005\r\u0001`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019DK\u0002m\u0003kY#!a\u000e\u0011\t\u0005e\u00121I\u0007\u0003\u0003wQA!!\u0010\u0002@\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u00032\u0016AC1o]>$\u0018\r^5p]&!\u0011QIA\u001e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!\u0014+\u0007q\f)$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002ZA\u0019Q+a\u0017\n\u0007\u0005ucKA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002d\u0005%\u0004cA+\u0002f%\u0019\u0011q\r,\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002l\u0019\n\t\u00111\u0001\u0002Z\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001d\u0011\r\u0005M\u0014\u0011PA2\u001b\t\t)HC\u0002\u0002xY\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tY(!\u001e\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\u000b9\tE\u0002V\u0003\u0007K1!!\"W\u0005\u001d\u0011un\u001c7fC:D\u0011\"a\u001b)\u0003\u0003\u0005\r!a\u0019\u0002\u0011!\f7\u000f[\"pI\u0016$\"!!\u0017\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u0006\u0002\r\u0015\fX/\u00197t)\u0011\t\t)!&\t\u0013\u0005-4&!AA\u0002\u0005\r\u0004BBAM\t\u0001\u0007Q,A\u0004dY&,g\u000e\u001e\u001a\t\r\u0005uE\u00011\u0001^\u00031\u0011\u0018M\u001c3p[\u000ec\u0017.\u001a8u\u0011\u0019\t\t\u000b\u0002a\u0001;\u0006\u0019B-\u001a4bk2$8i\u001c8gS\u001e\u001cE.[3oi\u0006AB/Z:u\u00072LWM\u001c;JIF+x\u000e^1QCJ\u001c\u0018N\\4\u0015\u0003QC3!BAU!\u0011\tY+!/\u000e\u0005\u00055&\u0002BAX\u0003c\u000b1!\u00199j\u0015\u0011\t\u0019,!.\u0002\u000f),\b/\u001b;fe*\u0019\u0011qW'\u0002\u000b),h.\u001b;\n\t\u0005m\u0016Q\u0016\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$Xk]3s#V|G/\u0019)beNLgn\u001a\u0015\u0004\r\u0005%\u0016\u0001\b;fgR,6/\u001a:DY&,g\u000e^%e#V|G/\u0019)beNLgn\u001a\u0015\u0004\u000f\u0005%\u0016\u0001\f;fgR,6/\u001a:Rk>$\u0018\rU1sg&twmV5uQ\u0012+g-Y;mi\u000ec\u0017.\u001a8u\u0013\u0012\fVo\u001c;bQ\rA\u0011\u0011V\u00015i\u0016\u001cH/V:fe\u000ec\u0017.\u001a8u#V|G/\u0019)beNLgnZ%e/&$\b\u000eR3gCVdGo\u00117jK:$\u0018\nZ)v_R\f\u0007fA\u0005\u0002*\u0006Q1\r[3dWF+x\u000e^1\u0015\u001bQ\u000b\t.a7\u0002^\u0006}\u0017\u0011^Aw\u0011\u001d\t\u0019N\u0003a\u0001\u0003+\fA\"];pi\u0006l\u0015M\\1hKJ\u00042APAl\u0013\r\tIn\u000e\u0002\u0013\u00072LWM\u001c;Rk>$\u0018-T1oC\u001e,'\u000fC\u0003k\u0015\u0001\u0007A\u000eC\u0003y\u0015\u0001\u0007A\u000eC\u0004\u0002b*\u0001\r!a9\u0002\u001b\u0015D\b/Z2uK\u0012\u0014u.\u001e8e!\r)\u0016Q]\u0005\u0004\u0003O4&\u0001\u0002'p]\u001eDq!a;\u000b\u0001\u0004\tI&A\u0003wC2,X\rC\u0004\u0002p*\u0001\r!!!\u0002\u001d\u0015D\b/Z2u)\"\u0014x\u000e\u001e;mK\u0006)D/Z:u\u000f\u0016$X*\u0019=WC2,X-\u00138Rk>$\u0018mV5oI><x+\u001b;i\u001d>tG)\u001a4bk2$\u0018+^8uC^Kg\u000eZ8xQ\rY\u0011\u0011V\u0001!i\u0016\u001cHoU3u\u0003:$'+Z7pm\u0016$UMZ1vYR,6/\u001a:Rk>$\u0018\rK\u0002\r\u0003S\u000b\u0011\u0004^3tiN+G/\u00118e%\u0016lwN^3Vg\u0016\u0014\u0018+^8uC\"\u001aQ\"!+\u0002?Q,7\u000f^*fi\u0006sGMU3n_Z,Wk]3s\u00072LWM\u001c;Rk>$\u0018\rK\u0002\u000f\u0003S\u000b\u0011\u0004^3tiF+x\u000e^1D_:4\u0017n\u001a)sK\u000e,G-\u001a8dK\"\u001aq\"!+\u0002%Q,7\u000f^)v_R\fg+[8mCRLwN\u001c\u0015\u0004!\u0005%\u0016\u0001\b;fgR,\u0005\u0010]5sKRC'o\u001c;uY\u0016$\u0016.\\3TK:\u001cxN\u001d\u0015\u0004#\u0005%\u0016A\u0006;fgR,\u0005\u0010]5sKF+x\u000e^1TK:\u001cxN]:)\u0007I\tI+\u0001\ruKN$8\t\\5f]RLEMT8u'\u0006t\u0017\u000e^5{K\u0012D3aEAU\u0003))6/\u001a:DY&,g\u000e\u001e\t\u0003=6\u001aB!\fB\u000eOBI!Q\u0004B\u0012Y2dH0X\u0007\u0003\u0005?Q1A!\tW\u0003\u001d\u0011XO\u001c;j[\u0016LAA!\n\u0003 \t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001b\u0015\u0005\t]\u0011!B1qa2LH#C/\u0003.\t=\"\u0011\u0007B\u001a\u0011\u0015Q\u0007\u00071\u0001m\u0011\u0015A\b\u00071\u0001m\u0011\u001dQ\b\u0007%AA\u0002qD\u0001\"!\u00011!\u0003\u0005\r\u0001`\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$C'A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu\"Q\t\t\u0005+v\u0014y\u0004E\u0004V\u0005\u0003bG\u000e ?\n\u0007\t\rcK\u0001\u0004UkBdW\r\u000e\u0005\t\u0005\u000f\u001a\u0014\u0011!a\u0001;\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0001")
public class ClientQuotaManagerTest
extends BaseClientQuotaManagerTest {
    private volatile ClientQuotaManagerTest$UserClient$ UserClient$module;
    private final ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();

    private ClientQuotaManagerTest$UserClient$ UserClient() {
        if (this.UserClient$module == null) {
            this.UserClient$lzycompute$1();
        }
        return this.UserClient$module;
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private void testQuotaParsing(ClientQuotaManagerConfig config, UserClient client1, UserClient client2, UserClient randomClient, UserClient defaultConfigClient) {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(config, this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota(client2.configUser(), client2.configClientId(), client2.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)Long.MAX_VALUE, (double)clientQuotaManager.quota(randomClient.user(), randomClient.clientId()).bound(), (double)0.0, (String)new StringBuilder(33).append("Default producer quota should be ").append((double)Long.MAX_VALUE).toString());
            Assertions.assertEquals((double)2000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (2000)");
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client2.user(), client2.clientId()).bound(), (double)0.0, (String)"Should return the overridden value (4000)");
            int throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 2500 * config.numQuotaSamples);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(3000.0, true)));
            Assertions.assertEquals((double)3000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (3000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(500.0, true)));
            Assertions.assertEquals((double)500.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the default value (500)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 0.0);
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            clientQuotaManager.updateQuota(client1.configUser(), client1.configClientId(), client1.sanitizedConfigClientId(), (Option)None$.MODULE$);
            clientQuotaManager.updateQuota(defaultConfigClient.configUser(), defaultConfigClient.configClientId(), defaultConfigClient.sanitizedConfigClientId(), (Option)new Some((Object)new Quota(4000.0, true)));
            Assertions.assertEquals((double)4000.0, (double)clientQuotaManager.quota(client1.user(), client1.clientId()).bound(), (double)0.0, (String)"Should return the newly overridden value (4000)");
            throttleTimeMs = this.maybeRecord(clientQuotaManager, client1.user(), client1.clientId(), 1000 * config.numQuotaSamples);
            Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "ANONYMOUS", "p1", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "ANONYMOUS", "p2", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "ANONYMOUS", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"<default>"));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)None$.MODULE$);
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientIdQuotaParsing() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)new Some((Object)"<default>"));
        ClientQuotaManagerConfig config = new ClientQuotaManagerConfig();
        this.testQuotaParsing(config, client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserQuotaParsingWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)None$.MODULE$);
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)None$.MODULE$);
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)None$.MODULE$);
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    @Test
    public void testUserClientQuotaParsingIdWithDefaultClientIdQuota() {
        UserClient client1 = new UserClient(this, "User1", "p1", (Option<String>)new Some((Object)"User1"), (Option<String>)new Some((Object)"p1"));
        UserClient client2 = new UserClient(this, "User2", "p2", (Option<String>)new Some((Object)"User2"), (Option<String>)new Some((Object)"p2"));
        UserClient randomClient = new UserClient(this, "RandomUser", "random-client-id", (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
        UserClient defaultConfigClient = new UserClient(this, "", "", (Option<String>)new Some((Object)"<default>"), (Option<String>)new Some((Object)"<default>"));
        this.testQuotaParsing(this.config(), client1, client2, randomClient, defaultConfigClient);
    }

    private void checkQuota(ClientQuotaManager quotaManager, String user, String clientId, long expectedBound, int value, boolean expectThrottle) {
        Assertions.assertEquals((double)expectedBound, (double)quotaManager.quota(user, clientId).bound(), (double)0.0);
        Session session = new Session(new KafkaPrincipal("User", user), InetAddress.getLocalHost());
        Assertions.assertEquals((double)(expectedBound < Long.MAX_VALUE ? (double)(this.config().quotaWindowSizeSeconds * (this.config().numQuotaSamples - 1)) * (double)expectedBound : Double.MAX_VALUE), (double)quotaManager.getMaxValueInQuotaWindow(session, clientId), (double)0.01);
        int throttleTimeMs = this.maybeRecord(quotaManager, user, clientId, value * this.config().numQuotaSamples);
        if (expectThrottle) {
            Assertions.assertTrue((throttleTimeMs > 0 ? 1 : 0) != 0, (String)new StringBuilder(34).append("throttleTimeMs should be > 0. was ").append(throttleTimeMs).toString());
            return;
        }
        Assertions.assertEquals((int)0, (int)throttleTimeMs, (String)new StringBuilder(32).append("throttleTimeMs should be 0. was ").append(throttleTimeMs).toString());
    }

    @Test
    public void testGetMaxValueInQuotaWindowWithNonDefaultQuotaWindow() {
        int numFullQuotaWindows = 3;
        ClientQuotaManagerConfig nonDefaultConfig = new ClientQuotaManagerConfig(numFullQuotaWindows + 1);
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(nonDefaultConfig, this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        Session userSession = new Session(new KafkaPrincipal("User", "userA"), InetAddress.getLocalHost());
        try {
            Assertions.assertEquals((double)Double.MAX_VALUE, (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            Assertions.assertEquals((double)(10 * numFullQuotaWindows), (double)clientQuotaManager.getMaxValueInQuotaWindow(userSession, "client1"), (double)0.01);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveDefaultUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testSetAndRemoveUserClientQuota() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 10L, 1000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client1", Long.MAX_VALUE, 1000, false);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaConfigPrecedence() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(new ClientQuotaManagerConfig(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(1000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(2000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(3000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(4000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(5000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(6000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(7000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userB"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userC"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(10000.0, true)));
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(9000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 4500, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 4000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client3", 4000L, 0, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 5000L, 0, false);
            this.checkQuota(clientQuotaManager, "userB", "client1", 7000L, 8000, true);
            this.checkQuota(clientQuotaManager, "userB", "client2", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userB", "client3", 8000L, 7000, false);
            this.checkQuota(clientQuotaManager, "userD", "client1", 3000L, 3500, true);
            this.checkQuota(clientQuotaManager, "userD", "client2", 3000L, 2500, false);
            this.checkQuota(clientQuotaManager, "userE", "client1", 3000L, 2500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userD", "client1", 1000L, 0, false);
            this.checkQuota(clientQuotaManager, "userE", "client4", 1000L, 1500, true);
            this.checkQuota(clientQuotaManager, "userF", "client4", 1000L, 800, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 1000L, 800, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"<default>"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userF", "client4", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 0, false);
            this.checkQuota(clientQuotaManager, "userF", "client5", 2000L, 2500, true);
            this.checkQuota(clientQuotaManager, "userG", "client5", 2000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)None$.MODULE$, (Option)None$.MODULE$, (Option)new Some((Object)new Quota(8000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)new Some((Object)new Quota(10000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client2", 8000L, 4500, true);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 0, false);
            this.checkQuota(clientQuotaManager, "userA", "client1", 10000L, 6000, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client1"), (Option)new Some((Object)"client1"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 8000L, 0, true);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)new Some((Object)new Quota(11000.0, true)));
            this.checkQuota(clientQuotaManager, "userA", "client6", 11000L, 8500, false);
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(12000.0, true)));
            clientQuotaManager.updateQuota((Option)new Some((Object)"userA"), (Option)new Some((Object)"client6"), (Option)new Some((Object)"client6"), (Option)None$.MODULE$);
            this.checkQuota(clientQuotaManager, "userA", "client6", 12000L, 4000, true);
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testQuotaViolation() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        KafkaMetric queueSizeMetric = (KafkaMetric)this.metrics().metrics().get(this.metrics().metricName("queue-size", "Produce", ""));
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0));
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            this.time().sleep(500L);
            int throttleTime = this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 2300.0);
            Assertions.assertEquals((int)2100, (int)throttleTime, (String)"Should be throttled");
            this.throttle(clientQuotaManager, "ANONYMOUS", "unknown", throttleTime, this.callback());
            Assertions.assertEquals((int)1, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)this.numCallbacks());
            this.time().sleep((long)throttleTime);
            clientQuotaManager.throttledChannelReaper().doWork();
            Assertions.assertEquals((int)0, (int)((int)BoxesRunTime.unboxToDouble((Object)queueSizeMetric.metricValue())));
            Assertions.assertEquals((int)1, (int)this.numCallbacks());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 400.0);
                this.time().sleep(1000L);
            });
            Assertions.assertEquals((int)0, (int)this.maybeRecord(clientQuotaManager, "ANONYMOUS", "unknown", 0.0), (String)"Should be unthrottled since bursty sample has rolled over");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireThrottleTimeSensor() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Sensor throttleTimeSensor = this.metrics().getSensor("ProduceThrottleTime-:client1");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)throttleTimeSensor, (String)"Throttle time sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testExpireQuotaSensors() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 100.0);
            this.metrics().removeSensor("ProduceThrottleTime-:client1");
            this.metrics().removeSensor("Produce-ANONYMOUS:client1");
            Assertions.assertTrue((this.maybeRecord(clientQuotaManager, "ANONYMOUS", "client1", 10000.0) > 0 ? 1 : 0) != 0, (String)"Should be throttled");
            Assertions.assertNotNull((Object)this.metrics().getSensor("ProduceThrottleTime-:client1"), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor("Produce-:client1"), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    @Test
    public void testClientIdNotSanitized() {
        ClientQuotaManager clientQuotaManager = new ClientQuotaManager(this.config(), this.metrics(), (QuotaType)QuotaType.Produce$.MODULE$, (Time)this.time(), "", ClientQuotaManager$.MODULE$.$lessinit$greater$default$6());
        String clientId = "client@#$%";
        try {
            clientQuotaManager.updateQuota((Option)None$.MODULE$, (Option)new Some((Object)"<default>"), (Option)new Some((Object)"<default>"), (Option)new Some((Object)new Quota(500.0, true)));
            this.maybeRecord(clientQuotaManager, "ANONYMOUS", clientId, 100.0);
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(21).append("ProduceThrottleTime-:").append(clientId).toString()), (String)"Throttle time sensor should exist");
            Assertions.assertNotNull((Object)this.metrics().getSensor(new StringBuilder(9).append("Produce-:").append(clientId).toString()), (String)"Byte rate sensor should exist");
        }
        finally {
            clientQuotaManager.shutdown();
        }
    }

    private final void UserClient$lzycompute$1() {
        synchronized (this) {
            if (this.UserClient$module == null) {
                this.UserClient$module = new ClientQuotaManagerTest$UserClient$(this);
            }
            return;
        }
    }

    private class UserClient
    implements Product,
    scala.Serializable {
        private final String user;
        private final String clientId;
        private final Option<String> configUser;
        private final Option<String> configClientId;
        public final /* synthetic */ ClientQuotaManagerTest $outer;

        public String user() {
            return this.user;
        }

        public String clientId() {
            return this.clientId;
        }

        public Option<String> configUser() {
            return this.configUser;
        }

        public Option<String> configClientId() {
            return this.configClientId;
        }

        public Option<String> sanitizedConfigClientId() {
            return this.configClientId().map((Function1 & Serializable & scala.Serializable)x -> {
                String string = x;
                String string2 = "<default>";
                if (string != null && string.equals(string2)) {
                    return "<default>";
                }
                return Sanitizer.sanitize((String)x);
            });
        }

        public UserClient copy(String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            return new UserClient(this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer(), user, clientId, configUser, configClientId);
        }

        public String copy$default$1() {
            return this.user();
        }

        public String copy$default$2() {
            return this.clientId();
        }

        public Option<String> copy$default$3() {
            return this.configUser();
        }

        public Option<String> copy$default$4() {
            return this.configClientId();
        }

        public String productPrefix() {
            return "UserClient";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.user();
                }
                case 1: {
                    return this.clientId();
                }
                case 2: {
                    return this.configUser();
                }
                case 3: {
                    return this.configClientId();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof UserClient;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof UserClient && ((UserClient)x$1).kafka$server$ClientQuotaManagerTest$UserClient$$$outer() == this.kafka$server$ClientQuotaManagerTest$UserClient$$$outer())) break block3;
                    UserClient userClient = (UserClient)x$1;
                    String string = this.user();
                    String string2 = userClient.user();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.clientId();
                    String string4 = userClient.clientId();
                    if (string3 != null ? !string3.equals(string4) : string4 != null) break block3;
                    Option<String> option = this.configUser();
                    Option<String> option2 = userClient.configUser();
                    if (option != null ? !option.equals(option2) : option2 != null) break block3;
                    Option<String> option3 = this.configClientId();
                    Option<String> option4 = userClient.configClientId();
                    if ((option3 != null ? !option3.equals(option4) : option4 != null) || !userClient.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ ClientQuotaManagerTest kafka$server$ClientQuotaManagerTest$UserClient$$$outer() {
            return this.$outer;
        }

        public UserClient(ClientQuotaManagerTest $outer, String user, String clientId, Option<String> configUser, Option<String> configClientId) {
            this.user = user;
            this.clientId = clientId;
            this.configUser = configUser;
            this.configClientId = configClientId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

