/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogManager;
import kafka.log.remote.RemoteLogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.network.SocketServer$;
import kafka.server.BrokerDynamicThreadPool;
import kafka.server.BrokerReconfigurable;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicMetricsReporters;
import kafka.server.DynamicRemoteLogConfig;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.config.ReplicationConfigs;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.log.remote.storage.RemoteLogManagerConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.util.KafkaScheduler;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.MockMetricsReporter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B!C\u0001\u001dCQA\u0014\u0001\u0005\u0002=CQA\u0015\u0001\u0005\u0002MCQ\u0001\u001a\u0001\u0005\u0002MCQA\u001a\u0001\u0005\u0002MCQ\u0001\u001b\u0001\u0005\u0002MCQA\u001b\u0001\u0005\u0002MCQ\u0001\u001c\u0001\u0005\u0002MCQA\u001c\u0001\u0005\u0002MCQ\u0001\u001d\u0001\u0005\u0002MCQA\u001d\u0001\u0005\u0002MCQ\u0001\u001e\u0001\u0005\nUDq!!\u000b\u0001\t\u0013\tY\u0003\u0003\u0004\u0002V\u0001!\ta\u0015\u0005\u0007\u00033\u0002A\u0011A*\t\r\u0005u\u0003\u0001\"\u0001T\r\u0019\t\t\u0007\u0001\u0001\u0002d!1a\n\u0005C\u0001\u0003\u000bC\u0011\"a#\u0011\u0001\u0004%\t!!$\t\u0013\u0005M\u0005\u00031A\u0005\u0002\u0005U\u0005\u0002CAN!\u0001\u0006K!a$\t\u000f\u0005\u0015\u0006\u0003\"\u0011\u0002(\"9\u0011\u0011\u001d\t\u0005B\u0005\r\bb\u0002B\u0004!\u0011\u0005#\u0011\u0002\u0005\b\u0005g\u0001B\u0011\tB\u001b\u0011\u001d\u0011I\u0006\u0005C!\u00057BaAa\u001a\u0011\t\u0003\u001a\u0006b\u0002B5!\u0011\u0005#1\u000e\u0005\b\u0005\u0007\u0003B\u0011\tBC\u0011\u001d\u0011i\t\u0005C!\u0005\u001fCqA!(\u0011\t\u0003\u0012y\n\u0003\u0004\u0003.\u0002!\ta\u0015\u0005\b\u0005c\u0003A\u0011\u0002BZ\u0011\u0019\u0011\u0019\r\u0001C\u0001'\"9!q\u0019\u0001\u0005\n\t%\u0007B\u0002Bh\u0001\u0011\u00051\u000b\u0003\u0004\u0003T\u0002!\ta\u0015\u0005\u0007\u0005/\u0004A\u0011A*\t\r\tm\u0007\u0001\"\u0001T\u0011\u0019\u0011y\u000e\u0001C\u0001'\"1!1\u001d\u0001\u0005\u0002MCaAa:\u0001\t\u0003\u0019\u0006B\u0002Bv\u0001\u0011\u00051\u000b\u0003\u0004\u0003p\u0002!\ta\u0015\u0005\u0007\u0005g\u0004A\u0011A*\t\r\t]\b\u0001\"\u0001T\u0011\u0019\u0011Y\u0010\u0001C\u0001'\"1!q \u0001\u0005\u0002MCaaa\u0001\u0001\t\u0003\u0019\u0006BBB\u0004\u0001\u0011\u00051\u000b\u0003\u0004\u0004\f\u0001!\ta\u0015\u0005\b\u0007\u001f\u0001A\u0011AB\t\r\u0019\u0019I\u0003\u0001\u0001\u0004,!Q\u0011\u0011\b\u001b\u0003\u0002\u0003\u0006I!a\u000f\t\r9#D\u0011AB\u0017\u0011%\ty\u0003\u000eb\u0001\n\u0003\u0019\u0019\u0004\u0003\u0005\u00046Q\u0002\u000b\u0011BA\u0019\u0011%\u00199\u0004\u000eb\u0001\n\u0003\u0019I\u0004\u0003\u0005\u0004BQ\u0002\u000b\u0011BB\u001e\u0011%\u0019\u0019\u0005\u000eb\u0001\n\u0003\u0019)\u0005\u0003\u0005\u0004TQ\u0002\u000b\u0011BB$\u0011%\u0019)\u0006\u000eb\u0001\n\u0003\u00199\u0006\u0003\u0005\u0004xQ\u0002\u000b\u0011BB-\u0011\u0019\u0019I\b\u0001C\u0001'\"11Q\u0010\u0001\u0005\u0002M\u0013q\u0003R=oC6L7M\u0011:pW\u0016\u00148i\u001c8gS\u001e$Vm\u001d;\u000b\u0005\r#\u0015AB:feZ,'OC\u0001F\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001%\u0011\u0005%cU\"\u0001&\u000b\u0003-\u000bQa]2bY\u0006L!!\u0014&\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u000b\u0005\u0002R\u00015\t!)\u0001\tuKN$8i\u001c8gS\u001e,\u0006\u000fZ1uKR\tA\u000b\u0005\u0002J+&\u0011aK\u0013\u0002\u0005+:LG\u000f\u000b\u0002\u00031B\u0011\u0011LY\u0007\u00025*\u00111\fX\u0001\u0004CBL'BA/_\u0003\u001dQW\u000f]5uKJT!a\u00181\u0002\u000b),h.\u001b;\u000b\u0003\u0005\f1a\u001c:h\u0013\t\u0019'L\u0001\u0003UKN$\u0018A\n;fgR,e.\u00192mK\u0012+g-Y;miVs7\r\\3b]2+\u0017\rZ3s\u000b2,7\r^5p]\"\u00121\u0001W\u0001\u001ci\u0016\u001cH/\u00169eCR,G)\u001f8b[&\u001cG\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005\u0011A\u0016A\n;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bnU8nK&sg/\u00197jI\u000e{gNZ5hg\"\u0012Q\u0001W\u00014i\u0016\u001cHoQ8oM&<W\u000b\u001d3bi\u0016<\u0016\u000e\u001e5SK\u000e|gNZ5hkJ\f'\r\\3WC2LG-\u0019;j_:4\u0015-\u001b7ve\u0016D#A\u0002-\u00029Q,7\u000f\u001e*fG>tg-[4ve\u0006\u0014G.\u001a,bY&$\u0017\r^5p]\"\u0012q\u0001W\u0001\u0014i\u0016\u001cHoU3dkJLG/_\"p]\u001aLwm\u001d\u0015\u0003\u0011a\u000b1\u0003^3ti\u000e{gN\\3di&|g.U;pi\u0006D#!\u0003-\u0002/Q,7\u000f^\"p]:,7\r^5p]J\u000bG/Z)v_R\f\u0007F\u0001\u0006Y\u0003I1XM]5gs\u000e{gNZ5h+B$\u0017\r^3\u0015\u0011Q3\u0018qAA\u000e\u0003KAQa^\u0006A\u0002a\fAA\\1nKB\u0019\u00110!\u0001\u000f\u0005it\bCA>K\u001b\u0005a(BA?G\u0003\u0019a$o\\8u}%\u0011qPS\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0011Q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005}T\u0005bBA\u0005\u0017\u0001\u0007\u00111B\u0001\u0006m\u0006dW/\u001a\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\u0011a\u0017M\\4\u000b\u0005\u0005U\u0011\u0001\u00026bm\u0006LA!!\u0007\u0002\u0010\t1qJ\u00196fGRDq!!\b\f\u0001\u0004\ty\"A\bqKJ\u0014%o\\6fe\u000e{gNZ5h!\rI\u0015\u0011E\u0005\u0004\u0003GQ%a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003OY\u0001\u0019AA\u0010\u00035)\u0007\u0010]3di\u001a\u000b\u0017\u000e\\;sK\u0006\u0019c/\u001a:jMf\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\b.\u00138wC2LGmQ8oM&<G#\u0003+\u0002.\u0005]\u0012qIA)\u0011\u001d\ty\u0003\u0004a\u0001\u0003c\taaY8oM&<\u0007cA)\u00024%\u0019\u0011Q\u0007\"\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0003sa\u0001\u0019AA\u001e\u0003%y'/[4Qe>\u00048\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\u0011\t\t%a\u0005\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u000b\nyD\u0001\u0006Qe>\u0004XM\u001d;jKNDq!!\u0013\r\u0001\u0004\tY%\u0001\u0006wC2LG\r\u0015:paN\u0004R!_A'qbLA!a\u0014\u0002\u0006\t\u0019Q*\u00199\t\u000f\u0005MC\u00021\u0001\u0002L\u0005a\u0011N\u001c<bY&$\u0007K]8qg\u0006aB/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001c'/\u001f9uS>t\u0007FA\u0007Y\u0003\u0015\"Xm\u001d;QCN\u001cxo\u001c:e\u0007>tg-[4F]\u000e|G-\u001a:TK\u000e\u0014X\r^\"iC:<W\r\u000b\u0002\u000f1\u0006IB/Z:u\tft\u0017-\\5d\u0019&\u001cH/\u001a8fe\u000e{gNZ5hQ\ty\u0001L\u0001\bUKN$\u0018)\u001e;i_JL'0\u001a:\u0014\u000fA\tY!!\u001a\u0002zA!\u0011qMA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014AC1vi\"|'/\u001b>fe*\u00191)a\u001c\u000b\u0007\u0015\u000b\tHC\u0002\u0002t\u0001\fa!\u00199bG\",\u0017\u0002BA<\u0003S\u0012!\"Q;uQ>\u0014\u0018N_3s!\u0011\tY(!!\u000e\u0005\u0005u$\u0002BA@\u0003_\naaY8n[>t\u0017\u0002BAB\u0003{\u0012aBU3d_:4\u0017nZ;sC\ndW\r\u0006\u0002\u0002\bB\u0019\u0011\u0011\u0012\t\u000e\u0003\u0001\t!b];qKJ,6/\u001a:t+\t\ty\t\u0005\u0003\u0002\u000e\u0005E\u0015\u0002BA\u0002\u0003\u001f\tab];qKJ,6/\u001a:t?\u0012*\u0017\u000fF\u0002U\u0003/C\u0011\"!'\u0014\u0003\u0003\u0005\r!a$\u0002\u0007a$\u0013'A\u0006tkB,'/V:feN\u0004\u0003f\u0001\u000b\u0002 B\u0019\u0011*!)\n\u0007\u0005\r&J\u0001\u0005w_2\fG/\u001b7f\u0003\u0015\u0019H/\u0019:u)\u0011\tI+a61\t\u0005-\u0016\u0011\u0018\t\t\u0003{\ti+a,\u00026&!\u0011qJA !\u0011\tY(!-\n\t\u0005M\u0016Q\u0010\u0002\t\u000b:$\u0007o\\5oiB!\u0011qWA]\u0019\u0001!1\"a/\u0016\u0003\u0003\u0005\tQ!\u0001\u0002>\n\u0019q\f\n\u001d\u0012\t\u0005}\u0016Q\u0019\t\u0004\u0013\u0006\u0005\u0017bAAb\u0015\n9aj\u001c;iS:<\u0007CBAd\u0003\u001b\f\t.\u0004\u0002\u0002J*!\u00111ZA \u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001f\fIMA\bD_6\u0004H.\u001a;j_:\u001cF/Y4f!\u0011\ti!a5\n\t\u0005U\u0017q\u0002\u0002\u0005->LG\rC\u0004\u0002ZV\u0001\r!a7\u0002\u0015M,'O^3s\u0013:4w\u000e\u0005\u0003\u0002h\u0005u\u0017\u0002BAp\u0003S\u0012A#Q;uQ>\u0014\u0018N_3s'\u0016\u0014h/\u001a:J]\u001a|\u0017!C1vi\"|'/\u001b>f)\u0019\t)/!=\u0002|B1\u0011QHAt\u0003WLA!!;\u0002@\t!A*[:u!\u0011\t9'!<\n\t\u0005=\u0018\u0011\u000e\u0002\u0014\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8SKN,H\u000e\u001e\u0005\b\u0003g4\u0002\u0019AA{\u00039\u0011X-];fgR\u001cuN\u001c;fqR\u0004B!a\u001a\u0002x&!\u0011\u0011`A5\u0005i\tU\u000f\u001e5pe&T\u0018M\u00197f%\u0016\fX/Z:u\u0007>tG/\u001a=u\u0011\u001d\tiP\u0006a\u0001\u0003\u007f\fq!Y2uS>t7\u000f\u0005\u0004\u0002>\u0005\u001d(\u0011\u0001\t\u0005\u0003O\u0012\u0019!\u0003\u0003\u0003\u0006\u0005%$AB!di&|g.\u0001\u0006de\u0016\fG/Z!dYN$bAa\u0003\u0003 \t\u0005\u0002\u0007\u0002B\u0007\u0005#\u0001b!!\u0010\u0002h\n=\u0001\u0003BA\\\u0005#!1Ba\u0005\u0018\u0003\u0003\u0005\tQ!\u0001\u0003\u0016\t\u0019q\fJ\u001d\u0012\t\u0005}&q\u0003\t\u0007\u0003\u000f\fiM!\u0007\u0011\t\u0005\u001d$1D\u0005\u0005\u0005;\tIGA\bBG2\u001c%/Z1uKJ+7/\u001e7u\u0011\u001d\t\u0019p\u0006a\u0001\u0003kDqAa\t\u0018\u0001\u0004\u0011)#A\u0006bG2\u0014\u0015N\u001c3j]\u001e\u001c\bCBA\u001f\u0003O\u00149\u0003\u0005\u0003\u0003*\t=RB\u0001B\u0016\u0015\u0011\u0011i#! \u0002\u0007\u0005\u001cG.\u0003\u0003\u00032\t-\"AC!dY\nKg\u000eZ5oO\u0006QA-\u001a7fi\u0016\f5\r\\:\u0015\r\t]\"1\nB'a\u0011\u0011ID!\u0010\u0011\r\u0005u\u0012q\u001dB\u001e!\u0011\t9L!\u0010\u0005\u0017\t}\u0002$!A\u0001\u0002\u000b\u0005!\u0011\t\u0002\u0005?\u0012\n\u0004'\u0005\u0003\u0002@\n\r\u0003CBAd\u0003\u001b\u0014)\u0005\u0005\u0003\u0002h\t\u001d\u0013\u0002\u0002B%\u0003S\u0012q\"Q2m\t\u0016dW\r^3SKN,H\u000e\u001e\u0005\b\u0003gD\u0002\u0019AA{\u0011\u001d\u0011y\u0005\u0007a\u0001\u0005#\n\u0011#Y2m\u0005&tG-\u001b8h\r&dG/\u001a:t!\u0019\ti$a:\u0003TA!!\u0011\u0006B+\u0013\u0011\u00119Fa\u000b\u0003!\u0005\u001bGNQ5oI&twMR5mi\u0016\u0014\u0018\u0001B1dYN$BA!\u0018\u0003dA1\u0011Q\u0002B0\u0005OIAA!\u0019\u0002\u0010\tA\u0011\n^3sC\ndW\rC\u0004\u0003fe\u0001\rAa\u0015\u0002\r\u0019LG\u000e^3s\u0003\u0015\u0019Gn\\:f\u0003%\u0019wN\u001c4jOV\u0014X\rF\u0002U\u0005[BqAa\u001c\u001c\u0001\u0004\u0011\t(A\u0004d_:4\u0017nZ:1\t\tM$q\u000f\t\b\u0003{\ti\u000b\u001fB;!\u0011\t9La\u001e\u0005\u0019\te$QNA\u0001\u0002\u0003\u0015\tAa\u001f\u0003\t}#\u0013'M\t\u0005\u0003\u007f\u0013i\bE\u0002J\u0005\u007fJ1A!!K\u0005\r\te._\u0001\u0016e\u0016\u001cwN\u001c4jOV\u0014\u0018M\u00197f\u0007>tg-[4t)\t\u00119\tE\u0003\u0002>\t%\u00050\u0003\u0003\u0003\f\u0006}\"aA*fi\u00069b/\u00197jI\u0006$XMU3d_:4\u0017nZ;sCRLwN\u001c\u000b\u0004)\nE\u0005b\u0002B8;\u0001\u0007!1\u0013\u0019\u0005\u0005+\u0013I\nE\u0004\u0002>\u00055\u0006Pa&\u0011\t\u0005]&\u0011\u0014\u0003\r\u00057\u0013\t*!A\u0001\u0002\u000b\u0005!1\u0010\u0002\u0005?\u0012\n$'A\u0006sK\u000e|gNZ5hkJ,Gc\u0001+\u0003\"\"9!q\u000e\u0010A\u0002\t\r\u0006\u0007\u0002BS\u0005S\u0003r!!\u0010\u0002.b\u00149\u000b\u0005\u0003\u00028\n%F\u0001\u0004BV\u0005C\u000b\t\u0011!A\u0003\u0002\tm$\u0001B0%cM\nA\u0003^3ti\u0006+H\u000f[8sSj,'oQ8oM&<\u0007FA\u0010Y\u0003y\u0019'/Z1uK\u000e{WNY5oK\u0012\u001cuN\u001c;s_2dWM]\"p]\u001aLw\r\u0006\u0004\u0002<\tU&q\u0018\u0005\b\u0005o\u0003\u0003\u0019\u0001B]\u0003\u0019qw\u000eZ3JIB\u0019\u0011Ja/\n\u0007\tu&JA\u0002J]RDqA!1!\u0001\u0004\u0011I,\u0001\u0003q_J$\u0018A\n;fgR\u001cu.\u001c2j]\u0016$7i\u001c8ue>dG.\u001a:BkRDwN]5{KJ\u001cuN\u001c4jO\"\u0012\u0011\u0005W\u0001\u001fGJ,\u0017\r^3Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001e$b!a\u000f\u0003L\n5\u0007b\u0002B\\E\u0001\u0007!\u0011\u0018\u0005\b\u0005\u0003\u0014\u0003\u0019\u0001B]\u0003\u0019\"Xm\u001d;Jg>d\u0017\r^3e\u0007>tGO]8mY\u0016\u0014\u0018)\u001e;i_JL'0\u001a:D_:4\u0017n\u001a\u0015\u0003Ga\u000bA\u0002^3tiNKhn\u001c8z[ND#\u0001\n-\u0002cQ,7\u000f\u001e#z]\u0006l\u0017nY\"p]\u001aLw-\u00138ji&\fG.\u001b>bi&|gnV5uQ>,HoQ8oM&<7/\u00138[\u0017\"\u0012Q\u0005W\u0001\u001ei\u0016\u001cH/S7qe>\u0004XM]\"p]\u001aLwm]!sKJ+Wn\u001c<fI\"\u0012a\u0005W\u0001\u001ai\u0016\u001cH/\u00169eCR,W*\u001a;sS\u000e\u0014V\r]8si\u0016\u00148\u000f\u000b\u0002(1\u00061C/Z:u+B$\u0017\r^3NKR\u0014\u0018n\u0019*fa>\u0014H/\u001a:t\u001d>TU\u000e\u001f*fa>\u0014H/\u001a:)\u0005!B\u0016!\r;fgRtuN\\%oi\u0016\u0014h.\u00197WC2,Xm\u001d#pKNtu\u000e^#ya>\u001cX-\u00138uKJt\u0017\r\\\"p]\u001aLwm\u001d\u0015\u0003Sa\u000bA\u0005^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|g.T:D_:4\u0017n\u001a\u0015\u0003Ua\u000ba\u0005^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|gnU5{K\u000e{gNZ5hQ\tY\u0003,\u0001\u0019uKN$H)\u001f8b[&\u001cGj\\4M_\u000e\fGNU3uK:$\u0018n\u001c8TW&\u00048o\u00148J]Z\fG.\u001b3D_:4\u0017n\u001a\u0015\u0003Ya\u000b1\u0007^3ti\u0012Kh.Y7jG2{w\rT8dC2\u0014V\r^3oi&|g\u000e\u00165s_^\u001cxJ\\%oG>\u0014(/Z2u\u0007>tg-[4)\u00055B\u0016!\n;fgR$\u0015P\\1nS\u000e\u0014V-\\8uK\u001a+Go\u00195NCb<\u0016-\u001b;Ng\u000e{gNZ5hQ\tq\u0003,A\u0014uKN$X\u000b\u001d3bi\u0016$\u0015P\\1nS\u000e\u0014V-\\8uK2{w-T1oC\u001e,'oQ8oM&<\u0007FA\u0018Y\u0003\u0011\"Xm\u001d;SK6|G/\u001a'pO6\u000bg.Y4fe\u000e{\u0007/_)v_R\fW\u000b\u001d3bi\u0016\u001c\bF\u0001\u0019Y\u0003\u0015\"Xm\u001d;SK6|G/\u001a'pO6\u000bg.Y4fe\u001a+Go\u00195Rk>$\u0018-\u00169eCR,7\u000f\u000b\u000221\u0006IC/Z:u%\u0016lw\u000e^3M_\u001el\u0015M\\1hKJlU\u000f\u001c;ja2,7i\u001c8gS\u001e,\u0006\u000fZ1uKND#A\r-\u0002KY,'/\u001b4z\u0013:\u001cwN\u001d:fGRdun\u001a'pG\u0006d'+\u001a;f]RLwN\u001c)s_B\u001cH#\u0003+\u0004\u0014\ru1\u0011EB\u0013\u0011\u001d\u0019)b\ra\u0001\u0007/\t1\u0003\\8h\u0019>\u001c\u0017\r\u001c*fi\u0016tG/[8o\u001bN\u00042!SB\r\u0013\r\u0019YB\u0013\u0002\u0005\u0019>tw\rC\u0004\u0004 M\u0002\raa\u0006\u0002\u0017I,G/\u001a8uS>tWj\u001d\u0005\b\u0007G\u0019\u0004\u0019AB\f\u0003Yawn\u001a'pG\u0006d'+\u001a;f]RLwN\u001c\"zi\u0016\u001c\bbBB\u0014g\u0001\u00071qC\u0001\u000fe\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0005]!\u0015P\\1nS\u000edunZ\"p]\u001aLwmQ8oi\u0016DHo\u0005\u00025\u0011R!1qFB\u0019!\r\tI\t\u000e\u0005\b\u0003s1\u0004\u0019AA\u001e+\t\t\t$A\u0004d_:4\u0017n\u001a\u0011\u0002\u0015M,'O^3s\u001b>\u001c7.\u0006\u0002\u0004<A\u0019\u0011k!\u0010\n\u0007\r}\"I\u0001\u0007Ce>\\WM]*feZ,'/A\u0006tKJ4XM]'pG.\u0004\u0013A\u00047pO6\u000bg.Y4fe6{7m[\u000b\u0003\u0007\u000f\u0002Ba!\u0013\u0004P5\u001111\n\u0006\u0004\u0007\u001b\"\u0015a\u00017pO&!1\u0011KB&\u0005)aunZ'b]\u0006<WM]\u0001\u0010Y><W*\u00198bO\u0016\u0014Xj\\2lA\u000592-\u001e:sK:$H)\u001a4bk2$Hj\\4D_:4\u0017nZ\u000b\u0003\u00073\u0002baa\u0017\u0004b\r\u0015TBAB/\u0015\u0011\u0019y&!3\u0002\r\u0005$x.\\5d\u0013\u0011\u0019\u0019g!\u0018\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004Baa\u001a\u0004t5\u00111\u0011\u000e\u0006\u0005\u0007\u001b\u001aYG\u0003\u0003\u0004n\r=\u0014!C5oi\u0016\u0014h.\u00197t\u0015\u0011\u0019\t(a\u001c\u0002\u000fM$xN]1hK&!1QOB5\u0005%aunZ\"p]\u001aLw-\u0001\rdkJ\u0014XM\u001c;EK\u001a\fW\u000f\u001c;M_\u001e\u001cuN\u001c4jO\u0002\nA\u0006^3ti\u0012Kh.Y7jG2{wmQ8oM&<\u0007*\u00198eY\u0016\u001c8+\u001f8p]fl7oQ8se\u0016\u001cG\u000f\\=)\u0005}B\u0016!\u000f;fgRdun\u001a*fi\u0016tG/[8o)&lW-T5okR,7/S:O_R$\u0015P\\1nS\u000e\fG\u000e\\=SK\u000e|gNZ5hkJ\f'\r\\3)\u0005\u0001C\u0006")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        int x$12 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$12, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn((Object)package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(ReplicationConfigs.UNCLEAN_LEADER_ELECTION_ENABLE_CONFIG, "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("num.io.threads", "4");
        origProps.put("num.network.threads", "2");
        origProps.put("num.replica.fetchers", "1");
        origProps.put("num.recovery.threads.per.data.dir", "1");
        origProps.put("background.threads", "3");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new BrokerDynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put("num.io.threads", "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put("num.network.threads", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey("num.network.threads"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get("num.network.threads"));
        props.put("num.replica.fetchers", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put("num.recovery.threads.per.data.dir", "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put("background.threads", "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"zookeeper.connect"), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ServerLogConfigs.LOG_MESSAGE_FORMAT_VERSION_CONFIG), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("log.cleaner.dedupe.buffer.size", "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.cleaner.threads"), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads"}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "broker.id", "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log.cleaner.threads", "log.cleaner.dedupe.buffer.size", "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(validReconfigurableProps));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate("max.connections.per.ip", "100", true, false);
        this.verifyConfigUpdate("max.connections.per.ip", "100", false, false);
        this.verifyConfigUpdate("max.connections.per.ip", "0", false, true);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate("max.connections.per.ip.overrides", "hostName#:100", true, true);
        this.verifyConfigUpdate("max.connections", "100", true, false);
        this.verifyConfigUpdate("max.connections", "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(38).append("listener.name.external.").append("max.connections").toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate("max.connection.creation.rate", "110", true, false);
        this.verifyConfigUpdate("max.connection.creation.rate", "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(51).append("listener.name.external.").append("max.connection.creation.rate").toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        configProps.put("password.encoder.secret", "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                String v = (String)x0$1._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        invalidProps.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                String k = (String)x0$2._1();
                String v = (String)x0$2._2();
                return props.put(k, v);
            }
            throw new MatchError(null);
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        props.put("password.encoder.secret", "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        Properties dynamicProps = new Properties();
        dynamicProps.put("sasl.jaas.config", "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty("sasl.jaas.config").contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty("sasl.jaas.config"));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("sasl.jaas.config", "staticLoginModule required;");
        props.put("password.encoder.secret", "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put("sasl.jaas.config", "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty("sasl.jaas.config").contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get("sasl.jaas.config")).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get("sasl.jaas.config")).value());
        props.put("password.encoder.secret", "new-encoder-secret");
        props.put("password.encoder.old.secret", "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get("sasl.jaas.config")).value());
        props.put("password.encoder.secret", "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get("sasl.jaas.config")).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put("listeners", "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig(kafkaServer).validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2()));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig(kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2())));
    }

    @Test
    public void testAuthorizerConfig() {
        int x$1 = 0;
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        KafkaBroker kafkaServer = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)kafkaServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)kafkaServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)kafkaServer.socketServer()).thenReturn((Object)socketServer);
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        ProducerStateManagerConfig producerStateManagerConfig = (ProducerStateManagerConfig)Mockito.mock(ProducerStateManagerConfig.class);
        Mockito.when((Object)logManager.producerStateManagerConfig()).thenReturn((Object)producerStateManagerConfig);
        Mockito.when((Object)kafkaServer.logManager()).thenReturn((Object)logManager);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        kafkaServer.config().dynamicConfig().addReconfigurables(kafkaServer);
        props.put("super.users", "User:admin");
        DynamicBrokerConfig qual$1 = kafkaServer.config().dynamicConfig();
        int x$22 = 0;
        boolean x$24 = qual$1.updateBrokerConfig$default$3();
        qual$1.updateBrokerConfig(x$22, props, x$24);
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createCombinedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        retval.put("process.roles", "broker,controller");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", new StringBuilder(25).append(retval.get("listeners")).append(",CONTROLLER://localhost:0").toString());
        retval.put("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testCombinedControllerAuthorizerConfig() {
        Properties props = this.createCombinedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    private Properties createIsolatedControllerConfig(int nodeId, int port) {
        Properties retval = TestUtils$.MODULE$.createBrokerConfig(nodeId, null, true, true, port, TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        retval.put("process.roles", "controller");
        retval.remove("advertised.listeners");
        retval.put("controller.listener.names", "CONTROLLER");
        retval.put("listeners", "CONTROLLER://localhost:0");
        retval.put("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        return retval;
    }

    @Test
    public void testIsolatedControllerAuthorizerConfig() {
        Properties props = this.createIsolatedControllerConfig(0, 9092);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        ControllerServer controllerServer = (ControllerServer)Mockito.mock(ControllerServer.class);
        Mockito.when((Object)controllerServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)controllerServer.kafkaYammerMetrics()).thenReturn((Object)KafkaYammerMetrics.INSTANCE);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)controllerServer.metrics()).thenReturn((Object)metrics);
        QuotaFactory.QuotaManagers quotaManagers = (QuotaFactory.QuotaManagers)Mockito.mock(QuotaFactory.QuotaManagers.class);
        Mockito.when((Object)quotaManagers.clientQuotaCallback()).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)controllerServer.quotaManagers()).thenReturn((Object)quotaManagers);
        SocketServer socketServer = (SocketServer)Mockito.mock(SocketServer.class);
        Mockito.when((Object)socketServer.reconfigurableConfigs()).thenReturn((Object)SocketServer$.MODULE$.ReconfigurableConfigs());
        Mockito.when((Object)controllerServer.socketServer()).thenReturn((Object)socketServer);
        TestAuthorizer authorizer = new TestAuthorizer();
        Mockito.when((Object)controllerServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        controllerServer.config().dynamicConfig().addReconfigurables(controllerServer);
        props.put("super.users", "User:admin");
        controllerServer.config().dynamicConfig().updateBrokerConfig(0, props, controllerServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, (List)new .colon.colon((Object)"log.roll.hours", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(ServerLogConfigs.LOG_ROLL_TIME_MILLIS_CONFIG, true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties initialProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        initialProps.remove("background.threads");
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(initialProps);
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient), (Option)None$.MODULE$);
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put("num.io.threads", "10");
        newprops.put("background.threads", "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, null, TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)0x10000C, (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put("max.connections", "9999");
        newProps.put("message.max.bytes", "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put("max.connections", "INVALID_INT");
        newProps.put("message.max.bytes", "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    @Test
    public void testUpdateMetricReporters() {
        int brokerId = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)JmxReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{JmxReporter.class.getName(), MockMetricsReporter.class.getName()})), (Object)m.currentReporters().keySet());
    }

    @Test
    public void testUpdateMetricReportersNoJmxReporter() {
        int brokerId = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(brokerId, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("auto.include.jmx.reporter", "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Metrics metrics = (Metrics)Mockito.mock(Metrics.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        DynamicMetricsReporters m = new DynamicMetricsReporters(brokerId, config, metrics, "clusterId");
        config.dynamicConfig().addReconfigurable((Reconfigurable)m);
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
        Properties props = new Properties();
        props.put("metric.reporters", MockMetricsReporter.class.getName());
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)1, (int)m.currentReporters().size());
        Assertions.assertEquals((Object)MockMetricsReporter.class.getName(), (Object)m.currentReporters().keySet().head());
        props.remove("metric.reporters");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)m.currentReporters().isEmpty());
    }

    @Test
    public void testNonInternalValuesDoesNotExposeInternalConfigs() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("metadata.log.segment.min.bytes", "1024");
        KafkaConfig config = new KafkaConfig((java.util.Map)props);
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
        config.updateCurrentConfig(new KafkaConfig((java.util.Map)props));
        Assertions.assertFalse((boolean)config.nonInternalValues().containsKey("metadata.log.segment.min.bytes"));
    }

    @Test
    public void testDynamicLogLocalRetentionMsConfig() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, "2592000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaBroker.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", "2160000000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)2160000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.ms", "2150000000");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)2150000000L, (long)config.remoteLogManagerConfig().logLocalRetentionMs());
    }

    @Test
    public void testDynamicLogLocalRetentionSizeConfig() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, "4294967296");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaBroker.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.bytes", "4294967295");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)0xFFFFFFFFL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
        config.dynamicConfig().validate(newProps, true);
        newProps.put("log.local.retention.bytes", "4294967294");
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)0xFFFFFFFEL, (long)config.remoteLogManagerConfig().logLocalRetentionBytes());
    }

    @Test
    public void testDynamicLogLocalRetentionSkipsOnInvalidConfig() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put("log.local.retention.ms", "1000");
        props.put("log.local.retention.bytes", "1024");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.ms"), (Object)"-3")}))));
        this.verifyConfigUpdateWithInvalidConfig(config, props, (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"log.local.retention.bytes"), (Object)"-3")}))));
    }

    @Test
    public void testDynamicLogLocalRetentionThrowsOnIncorrectConfig() {
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, 2L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(500L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(-1L, 1000L, 200L, 100L);
        this.verifyIncorrectLogLocalRetentionProps(2000L, 1000L, -1L, 100L);
    }

    @Test
    public void testDynamicRemoteFetchMaxWaitMsConfig() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker kafkaBroker = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        Mockito.when((Object)kafkaBroker.config()).thenReturn((Object)config);
        Mockito.when((Object)kafkaBroker.remoteLogManagerOpt()).thenReturn((Object)None$.MODULE$);
        Assertions.assertEquals((int)500, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        DynamicRemoteLogConfig dynamicRemoteLogConfig = new DynamicRemoteLogConfig(kafkaBroker);
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicRemoteLogConfig);
        Properties newProps = new Properties();
        newProps.put("remote.fetch.max.wait.ms", "30000");
        config.dynamicConfig().validate(newProps, false);
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)30000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        newProps.put("remote.fetch.max.wait.ms", "10000");
        config.dynamicConfig().validate(newProps, true);
        config.dynamicConfig().updateBrokerConfig(0, newProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((int)10000, (int)config.remoteLogManagerConfig().remoteFetchMaxWaitMs());
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, 0}))).foreach((Function1 & Serializable & scala.Serializable)maxWaitMs -> DynamicBrokerConfigTest.$anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(newProps, config, BoxesRunTime.unboxToInt((Object)maxWaitMs)));
    }

    @Test
    public void testUpdateDynamicRemoteLogManagerConfig() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("remote.log.index.file.cache.total.size.bytes", "2");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Properties props = new Properties();
        props.put("remote.log.index.file.cache.total.size.bytes", "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerCopyQuotaUpdates() {
        int x$1 = 0;
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        props.put("remote.log.manager.copy.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        props.put("remote.log.manager.copy.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerFetchQuotaUpdates() {
        int x$1 = 0;
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put("remote.log.manager.fetch.max.bytes.per.second", "100");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(100L);
        props.put("remote.log.manager.fetch.max.bytes.per.second", "200");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    @Test
    public void testRemoteLogManagerMultipleConfigUpdates() {
        String indexFileCacheSizeProp = "remote.log.index.file.cache.total.size.bytes";
        String copyQuotaProp = "remote.log.manager.copy.max.bytes.per.second";
        String fetchQuotaProp = "remote.log.manager.fetch.max.bytes.per.second";
        int x$1 = 0;
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        RemoteLogManager remoteLogManager = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.remoteLogManagerOpt()).thenReturn((Object)new Some((Object)remoteLogManager));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicRemoteLogConfig(serverMock));
        Assertions.assertEquals((long)0x40000000L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_COPY_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((Long)RemoteLogManagerConfig.DEFAULT_REMOTE_LOG_MANAGER_FETCH_MAX_BYTES_PER_SECOND, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        props.put(indexFileCacheSizeProp, "4");
        props.put(copyQuotaProp, "100");
        props.put(fetchQuotaProp, "200");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)4L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)100L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(4L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(100L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(200L);
        props.put(indexFileCacheSizeProp, "8");
        props.put(copyQuotaProp, "200");
        props.put(fetchQuotaProp, "400");
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((long)8L, (long)config.remoteLogManagerConfig().remoteLogIndexFileCacheTotalSizeBytes());
        Assertions.assertEquals((long)200L, (long)config.remoteLogManagerConfig().remoteLogManagerCopyMaxBytesPerSecond());
        Assertions.assertEquals((long)400L, (long)config.remoteLogManagerConfig().remoteLogManagerFetchMaxBytesPerSecond());
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).resizeCacheSize(8L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateCopyQuota(200L);
        ((RemoteLogManager)Mockito.verify((Object)remoteLogManager)).updateFetchQuota(400L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{remoteLogManager});
    }

    public void verifyIncorrectLogLocalRetentionProps(long logLocalRetentionMs, long retentionMs, long logLocalRetentionBytes, long retentionBytes) {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        props.put(ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG, Long.toString(retentionMs));
        props.put(ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG, Long.toString(retentionBytes));
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicLogConfig dynamicLogConfig = new DynamicLogConfig((LogManager)Mockito.mock(LogManager.class), (KafkaBroker)Mockito.mock(KafkaBroker.class));
        config.dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)dynamicLogConfig);
        Properties newProps = new Properties();
        newProps.put("log.local.retention.ms", Long.toString(logLocalRetentionMs));
        newProps.put("log.local.retention.bytes", Long.toString(logLocalRetentionBytes));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, false));
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(newProps, true));
    }

    @Test
    public void testDynamicLogConfigHandlesSynonymsCorrectly() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("log.retention.minutes", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("message.max.bytes", "12345678");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.MINUTES.toMillis(1L), (long)ctx.currentDefaultLogConfig().get().retentionMs);
    }

    @Test
    public void testLogRetentionTimeMinutesIsNotDynamicallyReconfigurable() {
        int x$1 = 0;
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, null, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        origProps.put("log.retention.hours", "1");
        DynamicLogConfigContext ctx = new DynamicLogConfigContext(origProps);
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Properties props = new Properties();
        props.put("log.retention.minutes", "3");
        ctx.config().dynamicConfig().updateDefaultConfig(props, ctx.config().dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((long)TimeUnit.HOURS.toMillis(1L), (long)ctx.config().logRetentionTimeMillis());
        Assertions.assertFalse((boolean)((AbstractConfig)ctx.currentDefaultLogConfig().get()).originals().containsKey("log.retention.minutes"));
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = new StringOps(Predef$.MODULE$.augmentString(configs.get("log.cleaner.threads").toString())).toInt();
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new Reconfigurable(null, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(null, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }

    public static final /* synthetic */ ConfigException $anonfun$testDynamicRemoteFetchMaxWaitMsConfig$1(Properties newProps$1, KafkaConfig config$5, int maxWaitMs) {
        newProps$1.put("remote.fetch.max.wait.ms", Integer.toString(maxWaitMs));
        Assertions.assertThrows(ConfigException.class, () -> config$5.dynamicConfig().validate(newProps$1, true));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> config$5.dynamicConfig().validate(newProps$1, false));
    }

    public class DynamicLogConfigContext {
        private final KafkaConfig config;
        private final BrokerServer serverMock;
        private final LogManager logManagerMock;
        private final AtomicReference<LogConfig> currentDefaultLogConfig;

        public KafkaConfig config() {
            return this.config;
        }

        public BrokerServer serverMock() {
            return this.serverMock;
        }

        public LogManager logManagerMock() {
            return this.logManagerMock;
        }

        public AtomicReference<LogConfig> currentDefaultLogConfig() {
            return this.currentDefaultLogConfig;
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$DynamicLogConfigContext$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public static final /* synthetic */ void $anonfun$new$2(DynamicLogConfigContext $this, InvocationOnMock invocation) {
            $this.currentDefaultLogConfig().set((LogConfig)invocation.getArgument(0));
        }

        public DynamicLogConfigContext(Properties origProps) {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
            this.serverMock = (BrokerServer)Mockito.mock(BrokerServer.class);
            this.logManagerMock = (LogManager)Mockito.mock(LogManager.class);
            Mockito.when((Object)this.serverMock().config()).thenReturn((Object)this.config());
            Mockito.when((Object)this.serverMock().logManager()).thenReturn((Object)this.logManagerMock());
            Mockito.when((Object)this.logManagerMock().allLogs()).thenReturn((Object)package$.MODULE$.Iterable().empty());
            this.currentDefaultLogConfig = new AtomicReference<LogConfig>(new LogConfig((java.util.Map)new Properties()));
            Mockito.when((Object)this.logManagerMock().currentDefaultConfig()).thenAnswer(x$2 -> this.currentDefaultLogConfig().get());
            this.logManagerMock().reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
            Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
                DynamicLogConfigContext.$anonfun$new$2(this, invocation);
                return BoxedUnit.UNIT;
            });
            this.config().dynamicConfig().initialize((Option)None$.MODULE$, (Option)None$.MODULE$);
            this.config().dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(this.logManagerMock(), (KafkaBroker)this.serverMock()));
        }
    }

    public class TestAuthorizer
    implements Authorizer,
    Reconfigurable {
        private volatile String superUsers;

        public int aclCount() {
            return super.aclCount();
        }

        public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
            return super.authorizeByResourceType(x$1, x$2, x$3);
        }

        public String superUsers() {
            return this.superUsers;
        }

        public void superUsers_$eq(String x$1) {
            this.superUsers = x$1;
        }

        public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
            return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
        }

        public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
            return null;
        }

        public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
            return null;
        }

        public Iterable<AclBinding> acls(AclBindingFilter filter) {
            return null;
        }

        public void close() {
        }

        public void configure(java.util.Map<String, ?> configs) {
        }

        public java.util.Set<String> reconfigurableConfigs() {
            return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
        }

        public void validateReconfiguration(java.util.Map<String, ?> configs) {
        }

        public void reconfigure(java.util.Map<String, ?> configs) {
            this.superUsers_$eq(configs.get("super.users").toString());
        }

        public /* synthetic */ DynamicBrokerConfigTest kafka$server$DynamicBrokerConfigTest$TestAuthorizer$$$outer() {
            return DynamicBrokerConfigTest.this;
        }

        public TestAuthorizer() {
            if (DynamicBrokerConfigTest.this == null) {
                throw null;
            }
            this.superUsers = "";
        }
    }
}

