/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.cluster.Partition;
import kafka.log.UnifiedLog;
import kafka.log.remote.RemoteLogManager;
import kafka.server.Constants$;
import kafka.server.IpConfigHandler;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.TopicConfigHandler;
import kafka.utils.CoreUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a2A!\u0003\u0006\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017!)!\u0007\u0001C\u00017!)A\u0007\u0001C\u00017!)a\u0007\u0001C\u00017\tYB)\u001f8b[&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hKVs\u0017\u000e\u001e+fgRT!a\u0003\u0007\u0002\rM,'O^3s\u0015\u0005i\u0011!B6bM.\f7\u0001A\n\u0003\u0001A\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\u000b\u0003\u0001\"Xm\u001d;Ja\"\u000bg\u000e\u001a7feVs'/Z:pYZ\f'\r\\3BI\u0012\u0014Xm]:\u0015\u0003q\u0001\"!E\u000f\n\u0005y\u0011\"\u0001B+oSRD#A\u0001\u0011\u0011\u0005\u0005RS\"\u0001\u0012\u000b\u0005\r\"\u0013aA1qS*\u0011QEJ\u0001\bUV\u0004\u0018\u000e^3s\u0015\t9\u0003&A\u0003kk:LGOC\u0001*\u0003\ry'oZ\u0005\u0003W\t\u0012A\u0001V3ti\u0006)3\u000f[8vY\u0012\u0004\u0016M]:f%\u0016\u0004H.[2bi&|g.U;pi\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u0007\u0001\nQf\u001d5pk2$\u0007+\u0019:tK^KG\u000eZ2be\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018\r\u0015:pa\u0016\u0014H/[3tQ\t!\u0001%A\u0017tQ>,H\u000e\u001a)beN,'+Z4be\u0012dWm]:PM^C\u0017\u000e^3ta\u0006\u001cW-\u0011:pk:$g+\u00197vKND#!\u0002\u0011\u0002AMDw.\u001e7e!\u0006\u00148/\u001a*fa2L7-\u0019;j_:\fVo\u001c;b%\u0016\u001cX\r\u001e\u0015\u0003\r\u0001\n\u0011\u0005^3ti\u0016s\u0017M\u00197f%\u0016lw\u000e^3M_\u001e\u001cFo\u001c:bO\u0016|e\u000eV8qS\u000eD#a\u0002\u0011\u0002mQ,7\u000f^#oC\ndWMU3n_R,Gj\\4Ti>\u0014\u0018mZ3P]R{\u0007/[2P]\u0006c'/Z1es\u0016s\u0017M\u00197fIR{\u0007/[2)\u0005!\u0001\u0003")
public class DynamicConfigChangeUnitTest {
    @Test
    public void testIpHandlerUnresolvableAddress() {
        IpConfigHandler configHandler = new IpConfigHandler(null);
        Properties props = new Properties();
        props.put("connection_creation_rate", "1");
        Assertions.assertThrows(IllegalArgumentException.class, () -> configHandler.processConfigChanges("illegal-hostname", props));
    }

    @Test
    public void shouldParseReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "0:101,0:102,1:101,1:102");
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas"));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)configHandler.parseThrottledPartitions(props, 103, "leader.replication.throttled.replicas"));
    }

    @Test
    public void shouldParseWildcardReplicationQuotaProperties() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put("leader.replication.throttled.replicas", "*");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "leader.replication.throttled.replicas");
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)result);
    }

    @Test
    public void shouldParseRegardlessOfWhitespaceAroundValues() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Assertions.assertEquals((Object)Constants$.MODULE$.AllReplicas(), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "* "));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102"));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, "6:102 "));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6})), (Object)DynamicConfigChangeUnitTest.parse$1(configHandler, " 6:102"));
    }

    @Test
    public void shouldParseReplicationQuotaReset() {
        TopicConfigHandler configHandler = new TopicConfigHandler(null, null, null, null);
        Properties props = new Properties();
        props.put("follower.replication.throttled.replicas", "");
        Seq result = configHandler.parseThrottledPartitions(props, 102, "follower.replication.throttled.replicas");
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)result);
    }

    @Test
    public void testEnableRemoteLogStorageOnTopic() {
        String topic = "test-topic";
        Uuid topicUuid = Uuid.randomUuid();
        RemoteLogManager rlm = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
        Mockito.when((Object)replicaManager.remoteLogManager()).thenReturn((Object)new Some((Object)rlm));
        Mockito.when((Object)replicaManager.metadataCache()).thenReturn((Object)metadataCache);
        Mockito.when((Object)metadataCache.getTopicId(topic)).thenReturn((Object)topicUuid);
        TopicPartition tp0 = new TopicPartition(topic, 0);
        UnifiedLog log0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition0 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)log0.topicPartition()).thenReturn((Object)tp0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition0.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)replicaManager.onlinePartition(tp0)).thenReturn((Object)new Some((Object)partition0));
        Mockito.when((Object)log0.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        TopicPartition tp1 = new TopicPartition(topic, 1);
        UnifiedLog log1 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Partition partition1 = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)log1.topicPartition()).thenReturn((Object)tp1);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log1.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition1.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Mockito.when((Object)replicaManager.onlinePartition(tp1)).thenReturn((Object)new Some((Object)partition1));
        Mockito.when((Object)log1.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        ArgumentCaptor leaderPartitionsArg = ArgumentCaptor.forClass(Set.class);
        ArgumentCaptor followerPartitionsArg = ArgumentCaptor.forClass(Set.class);
        ((RemoteLogManager)Mockito.doNothing().when((Object)rlm)).onLeadershipChange((Set)leaderPartitionsArg.capture(), (Set)followerPartitionsArg.capture(), (Map)ArgumentMatchers.any());
        boolean isRemoteLogEnabledBeforeUpdate = false;
        new TopicConfigHandler(replicaManager, null, null, (Option)None$.MODULE$).maybeUpdateRemoteLogComponents(topic, (Seq)new .colon.colon((Object)log0, (List)new .colon.colon((Object)log1, (List)Nil$.MODULE$)), isRemoteLogEnabledBeforeUpdate, false);
        Assertions.assertEquals(Collections.singleton(partition0), (Object)leaderPartitionsArg.getValue());
        Assertions.assertEquals(Collections.singleton(partition1), (Object)followerPartitionsArg.getValue());
    }

    @Test
    public void testEnableRemoteLogStorageOnTopicOnAlreadyEnabledTopic() {
        String topic = "test-topic";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        RemoteLogManager rlm = (RemoteLogManager)Mockito.mock(RemoteLogManager.class);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        Mockito.when((Object)replicaManager.remoteLogManager()).thenReturn((Object)new Some((Object)rlm));
        Mockito.when((Object)replicaManager.onlinePartition(tp0)).thenReturn((Object)new Some((Object)partition));
        UnifiedLog log0 = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)log0.remoteLogEnabled())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        ((RemoteLogManager)Mockito.doNothing().when((Object)rlm)).onLeadershipChange((Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
        Mockito.when((Object)log0.config()).thenReturn((Object)new LogConfig(Collections.emptyMap()));
        Mockito.when((Object)log0.topicPartition()).thenReturn((Object)tp0);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)partition.isLeader())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        boolean isRemoteLogEnabledBeforeUpdate = true;
        new TopicConfigHandler(replicaManager, null, null, (Option)None$.MODULE$).maybeUpdateRemoteLogComponents(topic, (Seq)new .colon.colon((Object)log0, (List)Nil$.MODULE$), isRemoteLogEnabledBeforeUpdate, false);
        ((RemoteLogManager)Mockito.verify((Object)rlm, (VerificationMode)Mockito.never())).onLeadershipChange((Set)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (Map)ArgumentMatchers.any());
    }

    private static final Seq parse$1(TopicConfigHandler configHandler, String value) {
        return configHandler.parseThrottledPartitions(CoreUtils$.MODULE$.propsWith("leader.replication.throttled.replicas", value), 102, "leader.replication.throttled.replicas");
    }
}

