/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Properties;
import java.util.stream.Collectors;
import kafka.server.ControllerServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.test.ClusterInstance;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ConsumerGroupDescribeRequestData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsRequestData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DescribeGroupsRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ConsumerGroupDescribeRequest;
import org.apache.kafka.common.requests.ConsumerGroupDescribeResponse;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatRequest;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.requests.DeleteGroupsRequest;
import org.apache.kafka.common.requests.DeleteGroupsResponse;
import org.apache.kafka.common.requests.DescribeGroupsRequest;
import org.apache.kafka.common.requests.DescribeGroupsResponse;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.HeartbeatResponse;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.JoinGroupResponse;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.LeaveGroupResponse;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetCommitResponse;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetDeleteResponse;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.OffsetFetchResponse;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.SyncGroupResponse;
import org.junit.jupiter.api.Assertions;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\r}h\u0001B\"E\u0001%C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\u00069\u0002!I!\u0018\u0005\u0006[\u0002!IA\u001c\u0005\u0006g\u0002!\t\u0002\u001e\u0005\u0006q\u0002!\t\"\u001f\u0005\b\u0003'\u0001A\u0011CA\u000b\u0011\u001d\ti\u0002\u0001C\t\u0003+Aq!a\b\u0001\t#\t\t\u0003C\u0004\u0002h\u0001!\t\"!\u001b\t\u000f\u0005\u001d\u0004\u0001\"\u0005\u0002\u001e\"9\u0011q\u0016\u0001\u0005\u0012\u0005E\u0006\"CAb\u0001E\u0005I\u0011CAc\u0011%\tY\u000eAI\u0001\n#\t)\rC\u0004\u0002^\u0002!I!a8\t\u000f\u0005\u0015\b\u0001\"\u0005\u0002h\"I!q\u0006\u0001\u0012\u0002\u0013E!\u0011\u0007\u0005\n\u0005k\u0001\u0011\u0013!C\t\u0005cA\u0011Ba\u000e\u0001#\u0003%\tB!\u000f\t\u0013\tu\u0002!%A\u0005\u0012\tE\u0002\"\u0003B \u0001E\u0005I\u0011\u0003B\u0019\u0011%\u0011\t\u0005AI\u0001\n#\u0011\u0019\u0005C\u0005\u0003H\u0001\t\n\u0011\"\u0005\u0002F\"I!\u0011\n\u0001\u0012\u0002\u0013E!1\n\u0005\b\u0005\u001f\u0002A\u0011\u0003B)\u0011%\u0011Y\u0007AI\u0001\n#\u0011\t\u0004C\u0005\u0003n\u0001\t\n\u0011\"\u0005\u00032!I!q\u000e\u0001\u0012\u0002\u0013E!\u0011\u0007\u0005\n\u0005c\u0002\u0011\u0013!C\t\u0005cA\u0011Ba\u001d\u0001#\u0003%\tBa\u0011\t\u0013\tU\u0004!%A\u0005\u0012\t-\u0003b\u0002B<\u0001\u0011E!\u0011\u0010\u0005\n\u0005\u001b\u0003\u0011\u0013!C\t\u0005\u0007B\u0011Ba$\u0001#\u0003%\tBa\u0011\t\u0013\tE\u0005!%A\u0005\u0012\tM\u0005b\u0002BL\u0001\u0011E!\u0011\u0014\u0005\n\u0005G\u0003\u0011\u0013!C\t\u0005\u0007B\u0011B!*\u0001#\u0003%\tBa%\t\u000f\t\u001d\u0006\u0001\"\u0005\u0003*\"9!Q\u0016\u0001\u0005\u0012\t=\u0006b\u0002B\\\u0001\u0011E!\u0011\u0018\u0005\n\u0005/\u0004\u0011\u0013!C\t\u0005\u0017BqA!7\u0001\t#\u0011Y\u000eC\u0005\u0003t\u0002\t\n\u0011\"\u0005\u0003L!9!Q\u001f\u0001\u0005\u0012\t]\b\"CB\b\u0001E\u0005I\u0011\u0003B&\u0011\u001d\u0019\t\u0002\u0001C\t\u0007'A\u0011ba\n\u0001#\u0003%\tB!\r\t\u0013\r%\u0002!%A\u0005\u0012\u0005\u0015\u0007bBB\u0016\u0001\u0011E1Q\u0006\u0005\n\u0007K\u0002\u0011\u0013!C\t\u0005cA\u0011ba\u001a\u0001#\u0003%\tb!\u001b\t\u0013\r5\u0004!%A\u0005\u0012\tE\u0002\"CB8\u0001E\u0005I\u0011\u0003B\u0019\u0011%\u0019\t\bAI\u0001\n#\u0019I\u0007C\u0005\u0004t\u0001\t\n\u0011\"\u0005\u00032!I1Q\u000f\u0001\u0012\u0002\u0013E1q\u000f\u0005\n\u0007w\u0002\u0011\u0013!C\t\u0007{B\u0011b!!\u0001#\u0003%\t\"!2\t\u000f\r\r\u0005\u0001\"\u0005\u0004\u0006\"911\u0012\u0001\u0005\u0012\r5\u0005\"CBS\u0001E\u0005I\u0011CB<\u0011%\u00199\u000bAI\u0001\n#\u0011Y\u0005C\u0004\u0004*\u0002!\tba+\t\u000f\rU\u0006\u0001\"\u0005\u00048\"91\u0011\u0019\u0001\u0005\u0012\r\r'aH$s_V\u00048i\\8sI&t\u0017\r^8s\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti*\u0011QIR\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u001d\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0015B\u00111JT\u0007\u0002\u0019*\tQ*A\u0003tG\u0006d\u0017-\u0003\u0002P\u0019\n1\u0011I\\=SK\u001a\fqa\u00197vgR,'\u000f\u0005\u0002S+6\t1K\u0003\u0002U\r\u0006!A/Z:u\u0013\t16KA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0011l\u0017\t\u00035\u0002i\u0011\u0001\u0012\u0005\u0006!\n\u0001\r!U\u0001\bEJ|7.\u001a:t)\u0005q\u0006cA0hU:\u0011\u0001-\u001a\b\u0003C\u0012l\u0011A\u0019\u0006\u0003G\"\u000ba\u0001\u0010:p_Rt\u0014\"A'\n\u0005\u0019d\u0015a\u00029bG.\fw-Z\u0005\u0003Q&\u00141aU3r\u0015\t1G\n\u0005\u0002[W&\u0011A\u000e\u0012\u0002\f\u0017\u000647.\u0019\"s_.,'/A\td_:$(o\u001c7mKJ\u001cVM\u001d<feN$\u0012a\u001c\t\u0004?\u001e\u0004\bC\u0001.r\u0013\t\u0011HI\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006\u00112M]3bi\u0016|eMZ:fiN$v\u000e]5d)\u0005)\bCA&w\u0013\t9HJ\u0001\u0003V]&$\u0018aC2sK\u0006$X\rV8qS\u000e$B!\u001e>\u0002\n!)1P\u0002a\u0001y\u0006)Ao\u001c9jGB\u0019Q0a\u0001\u000f\u0005y|\bCA1M\u0013\r\t\t\u0001T\u0001\u0007!J,G-\u001a4\n\t\u0005\u0015\u0011q\u0001\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0005A\nC\u0004\u0002\f\u0019\u0001\r!!\u0004\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t!\rY\u0015qB\u0005\u0004\u0003#a%aA%oi\u0006!\u0012n]+ogR\f'\r\\3Ba&,e.\u00192mK\u0012,\"!a\u0006\u0011\u0007-\u000bI\"C\u0002\u0002\u001c1\u0013qAQ8pY\u0016\fg.\u0001\u000fjg:+wo\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:F]\u0006\u0014G.\u001a3\u0002\u0019\r|W.\\5u\u001f\u001a47/\u001a;\u0015#U\f\u0019#a\n\u0002,\u0005=\u0012\u0011GA\u001b\u0003\u007f\ti\u0006\u0003\u0004\u0002&%\u0001\r\u0001`\u0001\bOJ|W\u000f]%e\u0011\u0019\tI#\u0003a\u0001y\u0006AQ.Z7cKJLE\rC\u0004\u0002.%\u0001\r!!\u0004\u0002\u00175,WNY3s\u000bB|7\r\u001b\u0005\u0006w&\u0001\r\u0001 \u0005\b\u0003gI\u0001\u0019AA\u0007\u0003%\u0001\u0018M\u001d;ji&|g\u000eC\u0004\u00028%\u0001\r!!\u000f\u0002\r=4gm]3u!\rY\u00151H\u0005\u0004\u0003{a%\u0001\u0002'p]\u001eDq!!\u0011\n\u0001\u0004\t\u0019%A\u0007fqB,7\r^3e\u000bJ\u0014xN\u001d\t\u0005\u0003\u000b\nI&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003!\u0001(o\u001c;pG>d'\u0002BA'\u0003\u001f\naaY8n[>t'bA$\u0002R)!\u00111KA+\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qK\u0001\u0004_J<\u0017\u0002BA.\u0003\u000f\u0012a!\u0012:s_J\u001c\bbBA0\u0013\u0001\u0007\u0011\u0011M\u0001\bm\u0016\u00148/[8o!\rY\u00151M\u0005\u0004\u0003Kb%!B*i_J$\u0018\u0001\u00044fi\u000eDwJ\u001a4tKR\u001cHCDA6\u0003\u007f\n\t)a!\u0002\u0006\u0006]\u00151\u0014\t\u0005\u0003[\nIH\u0004\u0003\u0002p\u0005UTBAA9\u0015\u0011\t\u0019(a\u0013\u0002\u000f5,7o]1hK&!\u0011qOA9\u0003]yeMZ:fi\u001a+Go\u00195SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002|\u0005u$\u0001G(gMN,GOR3uG\"\u0014Vm\u001d9p]N,wI]8va*!\u0011qOA9\u0011\u0019\t)C\u0003a\u0001y\"1\u0011\u0011\u0006\u0006A\u0002qDq!!\f\u000b\u0001\u0004\ti\u0001C\u0004\u0002\b*\u0001\r!!#\u0002\u0015A\f'\u000f^5uS>t7\u000fE\u0003`\u0003\u0017\u000by)C\u0002\u0002\u000e&\u0014A\u0001T5tiB!\u0011\u0011SAJ\u001b\t\tY%\u0003\u0003\u0002\u0016\u0006-#A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u00033S\u0001\u0019AA\f\u00035\u0011X-];je\u0016\u001cF/\u00192mK\"9\u0011q\f\u0006A\u0002\u0005\u0005D\u0003CAP\u0003C\u000bY+!,\u0011\u000b}\u000bY)a\u001b\t\u000f\u0005\r6\u00021\u0001\u0002&\u00061qM]8vaN\u0004b!`ATy\u0006%\u0015\u0002BAU\u0003\u000f\u00111!T1q\u0011\u001d\tIj\u0003a\u0001\u0003/Aq!a\u0018\f\u0001\u0004\t\t'\u0001\u0007eK2,G/Z(gMN,G\u000fF\u0007v\u0003g\u000b),a.\u0002:\u0006u\u0016\u0011\u0019\u0005\u0007\u0003Ka\u0001\u0019\u0001?\t\u000bmd\u0001\u0019\u0001?\t\u000f\u0005MB\u00021\u0001\u0002\u000e!I\u00111\u0018\u0007\u0011\u0002\u0003\u0007\u00111I\u0001\u0016Kb\u0004Xm\u0019;fIJ+7\u000f]8og\u0016,%O]8s\u0011%\ty\f\u0004I\u0001\u0002\u0004\t\u0019%\u0001\ffqB,7\r^3e!\u0006\u0014H/\u001b;j_:,%O]8s\u0011\u001d\ty\u0006\u0004a\u0001\u0003C\na\u0003Z3mKR,wJ\u001a4tKR$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u000fTC!a\u0011\u0002J.\u0012\u00111\u001a\t\u0005\u0003\u001b\f9.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003%)hn\u00195fG.,GMC\u0002\u0002V2\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\tI.a4\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\feK2,G/Z(gMN,G\u000f\n3fM\u0006,H\u000e\u001e\u00136\u0003M\u0019xN\u001d;U_BL7\rU1si&$\u0018n\u001c8t)\r)\u0018\u0011\u001d\u0005\b\u0003G|\u0001\u0019AA6\u0003\u00159'o\\;q\u0003a\u0019\u0018P\\2He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u000b\u0019\u0003S\fy/!=\u0002t\u0006]\u00181`A\u0000\u0005'\u00119Ba\u0007\u0003,\t5\u0002\u0003BA8\u0003WLA!!<\u0002r\t)2+\u001f8d\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007BBA\u0013!\u0001\u0007A\u0010\u0003\u0004\u0002*A\u0001\r\u0001 \u0005\b\u0003k\u0004\u0002\u0019AA\u0007\u000319WM\\3sCRLwN\\%e\u0011!\tI\u0010\u0005I\u0001\u0002\u0004a\u0018\u0001\u00049s_R|7m\u001c7UsB,\u0007\u0002CA\u007f!A\u0005\t\u0019\u0001?\u0002\u0019A\u0014x\u000e^8d_2t\u0015-\\3\t\u0013\t\u0005\u0001\u0003%AA\u0002\t\r\u0011aC1tg&<g.\\3oiN\u0004RaXAF\u0005\u000b\u0001BAa\u0002\u0003\u000e9!\u0011q\u000eB\u0005\u0013\u0011\u0011Y!!\u001d\u0002)MKhnY$s_V\u0004(+Z9vKN$H)\u0019;b\u0013\u0011\u0011yA!\u0005\u00035MKhnY$s_V\u0004(+Z9vKN$\u0018i]:jO:lWM\u001c;\u000b\t\t-\u0011\u0011\u000f\u0005\t\u0005+\u0001\u0002\u0013!a\u0001y\u0006!R\r\u001f9fGR,G\r\u0015:pi>\u001cw\u000e\u001c+za\u0016D\u0001B!\u0007\u0011!\u0003\u0005\r\u0001`\u0001\u0015Kb\u0004Xm\u0019;fIB\u0013x\u000e^8d_2t\u0015-\\3\t\u0013\tu\u0001\u0003%AA\u0002\t}\u0011AE3ya\u0016\u001cG/\u001a3BgNLwM\\7f]R\u0004Ra\u0013B\u0011\u0005KI1Aa\tM\u0005\u0015\t%O]1z!\rY%qE\u0005\u0004\u0005Sa%\u0001\u0002\"zi\u0016D\u0011\"!\u0011\u0011!\u0003\u0005\r!a\u0011\t\u0013\u0005}\u0003\u0003%AA\u0002\u0005\u0005\u0014AI:z]\u000e<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$C'\u0006\u0002\u00034)\u001aA0!3\u0002EMLhnY$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00136\u0003\t\u001a\u0018P\\2He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!1\b\u0016\u0005\u0005\u0007\tI-\u0001\u0012ts:\u001cwI]8va^KG\u000f[(mIB\u0013x\u000e^8d_2$C-\u001a4bk2$HeN\u0001#gft7m\u0012:pkB<\u0016\u000e\u001e5PY\u0012\u0004&o\u001c;pG>dG\u0005Z3gCVdG\u000f\n\u001d\u0002EMLhnY$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0011)E\u000b\u0003\u0003 \u0005%\u0017aI:z]\u000e<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$\u0013\u0007M\u0001$gft7m\u0012:pkB<\u0016\u000e\u001e5PY\u0012\u0004&o\u001c;pG>dG\u0005Z3gCVdG\u000fJ\u00192+\t\u0011iE\u000b\u0003\u0002b\u0005%\u0017aD:f]\u0012Tu.\u001b8SKF,Xm\u001d;\u0015!\tM#\u0011\fB.\u0005;\u0012\tGa\u0019\u0003f\t%\u0004\u0003BA8\u0005+JAAa\u0016\u0002r\t)\"j\\5o\u000fJ|W\u000f\u001d*fgB|gn]3ECR\f\u0007BBA\u00133\u0001\u0007A\u0010\u0003\u0005\u0002*e\u0001\n\u00111\u0001}\u0011!\u0011y&\u0007I\u0001\u0002\u0004a\u0018aD4s_V\u0004\u0018J\\:uC:\u001cW-\u00133\t\u0011\u0005e\u0018\u0004%AA\u0002qD\u0001\"!@\u001a!\u0003\u0005\r\u0001 \u0005\n\u0005OJ\u0002\u0013!a\u0001\u0005?\t\u0001\"\\3uC\u0012\fG/\u0019\u0005\n\u0003?J\u0002\u0013!a\u0001\u0003C\n\u0011d]3oI*{\u0017N\u001c*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005I2/\u001a8e\u0015>LgNU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00134\u0003e\u0019XM\u001c3K_&t'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001b\u00023M,g\u000e\u001a&pS:\u0014V-];fgR$C-\u001a4bk2$H%N\u0001\u001ag\u0016tGMS8j]J+\u0017/^3ti\u0012\"WMZ1vYR$c'A\rtK:$'j\\5o%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012:\u0014a\n6pS:$\u0015P\\1nS\u000e\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f[(mIB\u0013x\u000e^8d_2$\"Ba\u001f\u0003\u0002\n\r%Q\u0011BE!\u0019Y%Q\u0010?\u0002\u000e%\u0019!q\u0010'\u0003\rQ+\b\u000f\\33\u0011\u0019\t)\u0003\ta\u0001y\"I!q\r\u0011\u0011\u0002\u0003\u0007!q\u0004\u0005\n\u0005\u000f\u0003\u0003\u0013!a\u0001\u0005?\t!\"Y:tS\u001etW.\u001a8u\u0011%\u0011Y\t\tI\u0001\u0002\u0004\t9\"A\td_6\u0004H.\u001a;f%\u0016\u0014\u0017\r\\1oG\u0016\f\u0011G[8j]\u0012Kh.Y7jG\u000e{gn];nKJ<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$#'A\u0019k_&tG)\u001f8b[&\u001c7i\u001c8tk6,'o\u0012:pkB<\u0016\u000e\u001e5PY\u0012\u0004&o\u001c;pG>dG\u0005Z3gCVdG\u000fJ\u001a\u0002c)|\u0017N\u001c#z]\u0006l\u0017nY\"p]N,X.\u001a:He>,\boV5uQ>cG\r\u0015:pi>\u001cw\u000e\u001c\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!Q\u0013\u0016\u0005\u0003/\tI-\u0001\u0014k_&t7\u000b^1uS\u000e\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f[(mIB\u0013x\u000e^8d_2$\"Ba\u001f\u0003\u001c\nu%q\u0014BQ\u0011\u0019\t)\u0003\na\u0001y\"1!q\f\u0013A\u0002qD\u0011Ba\u001a%!\u0003\u0005\rAa\b\t\u0013\t-E\u0005%AA\u0002\u0005]\u0011\u0001\r6pS:\u001cF/\u0019;jG\u000e{gn];nKJ<%o\\;q/&$\bn\u00147e!J|Go\\2pY\u0012\"WMZ1vYR$3'\u0001\u0019k_&t7\u000b^1uS\u000e\u001cuN\\:v[\u0016\u0014xI]8va^KG\u000f[(mIB\u0013x\u000e^8d_2$C-\u001a4bk2$H\u0005N\u0001!U>LgnQ8ogVlWM]$s_V\u0004x+\u001b;i\u001d\u0016<\bK]8u_\u000e|G\u000e\u0006\u0003\u0003|\t-\u0006BBA\u0013O\u0001\u0007A0A\tk_&t7i\u001c8tk6,'o\u0012:pkB$bAa\u001f\u00032\nM\u0006BBA\u0013Q\u0001\u0007A\u0010C\u0004\u00036\"\u0002\r!a\u0006\u0002\u001dU\u001cXMT3x!J|Go\\2pY\u0006QA.[:u\u000fJ|W\u000f]:\u0015\u0011\tm&1\u001aBi\u0005+\u0004RaXAF\u0005{\u0003BAa0\u0003F:!\u0011q\u000eBa\u0013\u0011\u0011\u0019-!\u001d\u0002-1K7\u000f^$s_V\u00048OU3ta>t7/\u001a#bi\u0006LAAa2\u0003J\nYA*[:uK\u0012<%o\\;q\u0015\u0011\u0011\u0019-!\u001d\t\u000f\t5\u0017\u00061\u0001\u0003P\u0006a1\u000f^1uKN4\u0015\u000e\u001c;feB!q,a#}\u0011\u001d\u0011\u0019.\u000ba\u0001\u0005\u001f\f1\u0002^=qKN4\u0015\u000e\u001c;fe\"I\u0011qL\u0015\u0011\u0002\u0003\u0007\u0011\u0011M\u0001\u0015Y&\u001cHo\u0012:pkB\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001d\u0011,7o\u0019:jE\u0016<%o\\;qgR1!Q\u001cBw\u0005c\u0004RaXAF\u0005?\u0004BA!9\u0003h:!\u0011q\u000eBr\u0013\u0011\u0011)/!\u001d\u00025\u0011+7o\u0019:jE\u0016<%o\\;qgJ+7\u000f]8og\u0016$\u0015\r^1\n\t\t%(1\u001e\u0002\u000f\t\u0016\u001c8M]5cK\u0012<%o\\;q\u0015\u0011\u0011)/!\u001d\t\u000f\t=8\u00061\u0001\u0003P\u0006AqM]8va&#7\u000fC\u0005\u0002`-\u0002\n\u00111\u0001\u0002b\u0005AB-Z:de&\u0014Wm\u0012:pkB\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002+\r|gn];nKJ<%o\\;q\t\u0016\u001c8M]5cKRA!\u0011`B\u0004\u0007\u0013\u0019i\u0001E\u0003`\u0003\u0017\u0013Y\u0010\u0005\u0003\u0003~\u000e\ra\u0002BA8\u0005\u007fLAa!\u0001\u0002r\u0005\t3i\u001c8tk6,'o\u0012:pkB$Um]2sS\n,'+Z:q_:\u001cX\rR1uC&!!\u0011^B\u0003\u0015\u0011\u0019\t!!\u001d\t\u000f\t=X\u00061\u0001\u0003P\"911B\u0017A\u0002\u0005]\u0011aG5oG2,H-Z!vi\"|'/\u001b>fI>\u0003XM]1uS>t7\u000fC\u0005\u0002`5\u0002\n\u00111\u0001\u0002b\u0005y2m\u001c8tk6,'o\u0012:pkB$Um]2sS\n,G\u0005Z3gCVdG\u000fJ\u001a\u0002\u0013!,\u0017M\u001d;cK\u0006$HCDB\u000b\u00077\u0019iba\b\u0004\"\r\r2Q\u0005\t\u0005\u0003_\u001a9\"\u0003\u0003\u0004\u001a\u0005E$!\u0006%fCJ$(-Z1u%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\u0007\u0003Ky\u0003\u0019\u0001?\t\u000f\u0005Ux\u00061\u0001\u0002\u000e!1\u0011\u0011F\u0018A\u0002qD\u0001Ba\u00180!\u0003\u0005\r\u0001 \u0005\n\u0003\u0003z\u0003\u0013!a\u0001\u0003\u0007Bq!a\u00180\u0001\u0004\t\t'A\niK\u0006\u0014HOY3bi\u0012\"WMZ1vYR$C'A\niK\u0006\u0014HOY3bi\u0012\"WMZ1vYR$S'\u0001\fd_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u)Y\u0019yc!\u000e\u00048\re21HB \u0007\u0007\u001a9ea\u0013\u0004P\r\r\u0004\u0003BA8\u0007cIAaa\r\u0002r\t\u00113i\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fGOU3ta>t7/\u001a#bi\u0006Da!!\n3\u0001\u0004a\b\u0002CA\u0015eA\u0005\t\u0019\u0001?\t\u0013\u00055\"\u0007%AA\u0002\u00055\u0001\u0002CB\u001feA\u0005\t\u0019\u0001?\u0002\u0015%t7\u000f^1oG\u0016LE\r\u0003\u0005\u0004BI\u0002\n\u00111\u0001}\u0003\u0019\u0011\u0018mY6JI\"I1Q\t\u001a\u0011\u0002\u0003\u0007\u0011QB\u0001\u0013e\u0016\u0014\u0017\r\\1oG\u0016$\u0016.\\3pkRl5\u000f\u0003\u0005\u0004JI\u0002\n\u00111\u0001}\u00039\u0019XM\u001d<fe\u0006\u001b8/[4o_JD\u0011b!\u00143!\u0003\u0005\rAa4\u0002)M,(m]2sS\n,G\rV8qS\u000et\u0015-\\3t\u0011%\u0019\tF\rI\u0001\u0002\u0004\u0019\u0019&A\bu_BL7\rU1si&$\u0018n\u001c8t!\u0015y\u00161RB+!\u0011\u00199f!\u0018\u000f\t\u0005=4\u0011L\u0005\u0005\u00077\n\t(A\u0011D_:\u001cX/\\3s\u000fJ|W\u000f\u001d%fCJ$(-Z1u%\u0016\fX/Z:u\t\u0006$\u0018-\u0003\u0003\u0004`\r\u0005$a\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\:\u000b\t\rm\u0013\u0011\u000f\u0005\n\u0003\u0003\u0012\u0004\u0013!a\u0001\u0003\u0007\n\u0001eY8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u00013m\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YG\u000b\u0003\u0002\u000e\u0005%\u0017\u0001I2p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;%I\u00164\u0017-\u001e7uIQ\n\u0001eY8ogVlWM]$s_V\u0004\b*Z1si\n,\u0017\r\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u0005\u00013m\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003\u0001\u001awN\\:v[\u0016\u0014xI]8va\"+\u0017M\u001d;cK\u0006$H\u0005Z3gCVdG\u000fJ\u001c\u0002A\r|gn];nKJ<%o\\;q\u0011\u0016\f'\u000f\u001e2fCR$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007sRCAa4\u0002J\u0006\u00013m\u001c8tk6,'o\u0012:pkBDU-\u0019:uE\u0016\fG\u000f\n3fM\u0006,H\u000e\u001e\u0013:+\t\u0019yH\u000b\u0003\u0004T\u0005%\u0017!I2p]N,X.\u001a:He>,\b\u000fS3beR\u0014W-\u0019;%I\u00164\u0017-\u001e7uIE\u0002\u0014!\u00077fCZ,wI]8va^KG\u000f\u001b(foB\u0013x\u000e^8d_2$baa\f\u0004\b\u000e%\u0005BBA\u0013y\u0001\u0007A\u0010\u0003\u0004\u0002*q\u0002\r\u0001`\u0001\u001aY\u0016\fg/Z$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000eF\u0007v\u0007\u001f\u001b\tj!&\u0004\u001a\u000eu51\u0015\u0005\u0007\u0003Ki\u0004\u0019\u0001?\t\u000f\rMU\b1\u0001\u0003P\u0006IQ.Z7cKJLEm\u001d\u0005\n\u0007/k\u0004\u0013!a\u0001\u0005\u001f\f\u0001c\u001a:pkBLen\u001d;b]\u000e,\u0017\nZ:\t\u000f\rmU\b1\u0001\u0002D\u00059R\r\u001f9fGR,G\rT3bm\u0016<%o\\;q\u000bJ\u0014xN\u001d\u0005\b\u0007?k\u0004\u0019ABQ\u0003Q)\u0007\u0010]3di\u0016$W*Z7cKJ,%O]8sgB)q,a#\u0002D!I\u0011qL\u001f\u0011\u0002\u0003\u0007\u0011\u0011M\u0001$Y\u0016\fg/Z$s_V\u0004x+\u001b;i\u001f2$\u0007K]8u_\u000e|G\u000e\n3fM\u0006,H\u000e\u001e\u00134\u0003\rbW-\u0019<f\u000fJ|W\u000f],ji\"|E\u000e\u001a)s_R|7m\u001c7%I\u00164\u0017-\u001e7uIY\n!\u0002\\3bm\u0016<%o\\;q)%)8QVBX\u0007c\u001b\u0019\f\u0003\u0004\u0002&\u0001\u0003\r\u0001 \u0005\u0007\u0003S\u0001\u0005\u0019\u0001?\t\u000f\tU\u0006\t1\u0001\u0002\u0018!9\u0011q\f!A\u0002\u0005\u0005\u0014\u0001\u00043fY\u0016$Xm\u0012:pkB\u001cHcB;\u0004:\u000em6q\u0018\u0005\b\u0005_\f\u0005\u0019\u0001Bh\u0011\u001d\u0019i,\u0011a\u0001\u0007C\u000ba\"\u001a=qK\u000e$X\rZ#se>\u00148\u000fC\u0004\u0002`\u0005\u0003\r!!\u0019\u0002#\r|gN\\3di\u0006sGMU3dK&4X-\u0006\u0003\u0004F\u000e5G\u0003BBd\u0007k$Ba!3\u0004fB!11ZBg\u0019\u0001!qaa4C\u0005\u0004\u0019\tNA\u0001U#\u0011\u0019\u0019n!7\u0011\u0007-\u001b).C\u0002\u0004X2\u0013qAT8uQ&tw\r\u0005\u0003\u0004\\\u000e\u0005XBABo\u0015\u0011\u0019y.a\u0013\u0002\u0011I,\u0017/^3tiNLAaa9\u0004^\n\u0001\u0012IY:ue\u0006\u001cGOU3ta>t7/\u001a\u0005\b\u0007O\u0014\u00059ABu\u0003!\u0019G.Y:t)\u0006<\u0007CBBv\u0007c\u001cI-\u0004\u0002\u0004n*\u00191q\u001e'\u0002\u000fI,g\r\\3di&!11_Bw\u0005!\u0019E.Y:t)\u0006<\u0007bBB|\u0005\u0002\u00071\u0011`\u0001\be\u0016\fX/Z:u!\u0011\u0019Yna?\n\t\ru8Q\u001c\u0002\u0010\u0003\n\u001cHO]1diJ+\u0017/^3ti\u0002")
public class GroupCoordinatorBaseRequestTest {
    private final ClusterInstance cluster;

    private Seq<KafkaBroker> brokers() {
        return ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.cluster.brokers().values().stream().collect(Collectors.toList())).asScala()).toSeq();
    }

    private Seq<ControllerServer> controllerServers() {
        return ((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllers().values()).asScala()).toSeq();
    }

    public void createOffsetsTopic() {
        TestUtils$.MODULE$.createOffsetsTopicWithAdmin(this.cluster.createAdminClient(), this.brokers(), this.controllerServers());
    }

    public void createTopic(String topic, int numPartitions) {
        Admin x$1 = this.cluster.createAdminClient();
        Seq<KafkaBroker> x$2 = this.brokers();
        Seq<ControllerServer> x$3 = this.controllerServers();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        Properties x$8 = TestUtils$.MODULE$.createTopicWithAdmin$default$8();
        TestUtils$.MODULE$.createTopicWithAdmin(x$1, topic, x$2, x$3, numPartitions, x$6, x$7, x$8);
    }

    public boolean isUnstableApiEnabled() {
        String string = this.cluster.config().serverProperties().get("unstable.api.versions.enable");
        String string2 = "true";
        return string != null && string.equals(string2);
    }

    public boolean isNewGroupCoordinatorEnabled() {
        String string = this.cluster.config().serverProperties().get("group.coordinator.new.enable");
        String string2 = "true";
        return string != null && string.equals(string2) || this.cluster.config().serverProperties().get("group.coordinator.rebalance.protocols").contains("consumer");
    }

    public void commitOffset(String groupId, String memberId, int memberEpoch, String topic, int partition, long offset, Errors expectedError, short version) {
        OffsetCommitRequest request = new OffsetCommitRequest.Builder(new OffsetCommitRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationIdOrMemberEpoch(memberEpoch).setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestTopic().setName(topic).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitRequestData.OffsetCommitRequestPartition().setPartitionIndex(partition).setCommittedOffset(offset), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()), this.isUnstableApiEnabled()).build(version);
        OffsetCommitResponseData expectedResponse = new OffsetCommitResponseData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topic).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition).setErrorCode(expectedError.code()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava());
        OffsetCommitResponse response = (OffsetCommitResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetCommitResponse.class));
        Assertions.assertEquals((Object)expectedResponse, (Object)response.data());
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchOffsets(String groupId, String memberId, int memberEpoch, List<TopicPartition> partitions, boolean requireStable, short version) {
        OffsetFetchResponseData.OffsetFetchResponseGroup offsetFetchResponseGroup;
        OffsetFetchRequest request = new OffsetFetchRequest.Builder(groupId, memberId, memberEpoch, requireStable, partitions == null ? null : (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(partitions).asJava(), false).build(version);
        OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetFetchResponse.class));
        if (version >= 8) {
            Assertions.assertEquals((int)1, (int)response.data().groups().size());
            Assertions.assertEquals((Object)groupId, (Object)((OffsetFetchResponseData.OffsetFetchResponseGroup)response.data().groups().get(0)).groupId());
            offsetFetchResponseGroup = (OffsetFetchResponseData.OffsetFetchResponseGroup)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).head();
        } else {
            offsetFetchResponseGroup = new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(groupId).setErrorCode(response.data().errorCode()).setTopics((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().topics()).asScala()).map((Function1 & Serializable & scala.Serializable)topic -> new OffsetFetchResponseData.OffsetFetchResponseTopics().setName(topic.name()).setPartitions((java.util.List)CollectionConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partition -> new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition.partitionIndex()).setErrorCode(partition.errorCode()).setCommittedOffset(partition.committedOffset()).setCommittedLeaderEpoch(partition.committedLeaderEpoch()).setMetadata(partition.metadata()), Buffer$.MODULE$.canBuildFrom())).asJava()), Buffer$.MODULE$.canBuildFrom())).asJava());
        }
        OffsetFetchResponseData.OffsetFetchResponseGroup groupResponse = offsetFetchResponseGroup;
        this.sortTopicPartitions(groupResponse);
        return groupResponse;
    }

    public List<OffsetFetchResponseData.OffsetFetchResponseGroup> fetchOffsets(scala.collection.immutable.Map<String, List<TopicPartition>> groups, boolean requireStable, short version) {
        if (version < 8) {
            Assertions.fail((String)new StringBuilder(54).append("OffsetFetch API version ").append(version).append(" cannot fetch multiple groups.").toString());
        }
        OffsetFetchRequest request = new OffsetFetchRequest.Builder((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)groups.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                String k = (String)x0$1._1();
                List v = (List)x0$1._2();
                return new Tuple2((Object)k, CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)v).asJava());
            }
            throw new MatchError(null);
        }, Map$.MODULE$.canBuildFrom())).asJava(), requireStable, false).build(version);
        OffsetFetchResponse response = (OffsetFetchResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetFetchResponse.class));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).foreach((Function1 & Serializable & scala.Serializable)group -> {
            this.sortTopicPartitions(group);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).toList();
    }

    public void deleteOffset(String groupId, String topic, int partition, Errors expectedResponseError, Errors expectedPartitionError, short version) {
        Errors errors = expectedResponseError;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            Errors errors3 = expectedPartitionError;
            Errors errors4 = Errors.NONE;
            if (errors3 == null ? errors4 != null : !errors3.equals(errors4)) {
                Assertions.fail((String)"deleteOffset: neither expectedResponseError nor expectedTopicError is Errors.NONE.");
            }
        }
        OffsetDeleteRequest request = new OffsetDeleteRequest.Builder(new OffsetDeleteRequestData().setGroupId(groupId).setTopics(new OffsetDeleteRequestData.OffsetDeleteRequestTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestTopic().setName(topic).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteRequestData.OffsetDeleteRequestPartition().setPartitionIndex(partition), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava()).iterator()))).build(version);
        OffsetDeleteResponseData expectedResponse = new OffsetDeleteResponseData();
        Errors errors5 = expectedResponseError;
        Errors errors6 = Errors.NONE;
        if (!(errors5 != null ? !errors5.equals(errors6) : errors6 != null)) {
            expectedResponse.setTopics(new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic).setPartitions(new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition).setErrorCode(expectedPartitionError.code()), (List)Nil$.MODULE$)).asJava()).iterator())), (List)Nil$.MODULE$)).asJava()).iterator()));
        } else {
            expectedResponse.setErrorCode(expectedResponseError.code());
        }
        OffsetDeleteResponse response = (OffsetDeleteResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(OffsetDeleteResponse.class));
        Assertions.assertEquals((Object)expectedResponse, (Object)response.data());
    }

    public Errors deleteOffset$default$4() {
        return Errors.NONE;
    }

    public Errors deleteOffset$default$5() {
        return Errors.NONE;
    }

    private void sortTopicPartitions(OffsetFetchResponseData.OffsetFetchResponseGroup group) {
        group.topics().sort((t1, t2) -> t1.name().compareTo(t2.name()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(group.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            GroupCoordinatorBaseRequestTest.$anonfun$sortTopicPartitions$2(topic);
            return BoxedUnit.UNIT;
        });
    }

    public SyncGroupResponseData syncGroupWithOldProtocol(String groupId, String memberId, int generationId, String protocolType, String protocolName, List<SyncGroupRequestData.SyncGroupRequestAssignment> assignments, String expectedProtocolType, String expectedProtocolName, byte[] expectedAssignment, Errors expectedError, short version) {
        SyncGroupRequestData syncGroupRequestData = new SyncGroupRequestData().setGroupId(groupId).setMemberId(memberId).setGenerationId(generationId).setProtocolType(protocolType).setProtocolName(protocolName).setAssignments((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(assignments).asJava());
        SyncGroupRequest syncGroupRequest = new SyncGroupRequest.Builder(syncGroupRequestData).build(version);
        SyncGroupResponse syncGroupResponse = (SyncGroupResponse)this.connectAndReceive((AbstractRequest)syncGroupRequest, ClassTag$.MODULE$.apply(SyncGroupResponse.class));
        Assertions.assertEquals((Object)new SyncGroupResponseData().setErrorCode(expectedError.code()).setProtocolType(version >= 5 ? expectedProtocolType : null).setProtocolName(version >= 5 ? expectedProtocolName : null).setAssignment(expectedAssignment), (Object)syncGroupResponse.data());
        return syncGroupResponse.data();
    }

    public String syncGroupWithOldProtocol$default$4() {
        return "consumer";
    }

    public String syncGroupWithOldProtocol$default$5() {
        return "consumer-range";
    }

    public List<SyncGroupRequestData.SyncGroupRequestAssignment> syncGroupWithOldProtocol$default$6() {
        return List$.MODULE$.empty();
    }

    public String syncGroupWithOldProtocol$default$7() {
        return "consumer";
    }

    public String syncGroupWithOldProtocol$default$8() {
        return "consumer-range";
    }

    public byte[] syncGroupWithOldProtocol$default$9() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public Errors syncGroupWithOldProtocol$default$10() {
        return Errors.NONE;
    }

    public short syncGroupWithOldProtocol$default$11() {
        return ApiKeys.SYNC_GROUP.latestVersion(this.isUnstableApiEnabled());
    }

    /*
     * WARNING - void declaration
     */
    public JoinGroupResponseData sendJoinRequest(String groupId, String memberId, String groupInstanceId, String protocolType, String protocolName, byte[] metadata, short version) {
        JoinGroupRequestData joinGroupRequestData = new JoinGroupRequestData().setGroupId(groupId).setMemberId(memberId).setGroupInstanceId(groupInstanceId).setRebalanceTimeoutMs(250000).setSessionTimeoutMs(600000).setProtocolType(protocolType).setProtocols(new JoinGroupRequestData.JoinGroupRequestProtocolCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new JoinGroupRequestData.JoinGroupRequestProtocol().setName(protocolName).setMetadata(metadata), (List)Nil$.MODULE$)).asJava()).iterator()));
        JoinGroupRequest joinGroupRequest = new JoinGroupRequest.Builder(joinGroupRequestData).build(version);
        ObjectRef joinGroupResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GroupCoordinatorBaseRequestTest.$anonfun$sendJoinRequest$1(this, joinGroupResponse, joinGroupRequest)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GroupCoordinatorBaseRequestTest.$anonfun$sendJoinRequest$2(joinGroupResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return ((JoinGroupResponse)joinGroupResponse.elem).data();
    }

    public String sendJoinRequest$default$2() {
        return "";
    }

    public String sendJoinRequest$default$3() {
        return null;
    }

    public String sendJoinRequest$default$4() {
        return "consumer";
    }

    public String sendJoinRequest$default$5() {
        return "consumer-range";
    }

    public byte[] sendJoinRequest$default$6() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public short sendJoinRequest$default$7() {
        return ApiKeys.JOIN_GROUP.latestVersion(this.isUnstableApiEnabled());
    }

    public Tuple2<String, Object> joinDynamicConsumerGroupWithOldProtocol(String groupId, byte[] metadata, byte[] assignment, boolean completeRebalance) {
        String x$3 = this.sendJoinRequest$default$2();
        String x$4 = this.sendJoinRequest$default$3();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        JoinGroupResponseData joinGroupResponseData = this.sendJoinRequest(groupId, x$3, x$4, x$5, x$6, metadata, x$7);
        Assertions.assertEquals((short)Errors.MEMBER_ID_REQUIRED.code(), (short)joinGroupResponseData.errorCode());
        String x$9 = joinGroupResponseData.memberId();
        String x$11 = this.sendJoinRequest$default$3();
        String x$12 = this.sendJoinRequest$default$4();
        String x$13 = this.sendJoinRequest$default$5();
        short x$14 = this.sendJoinRequest$default$7();
        JoinGroupResponseData rejoinGroupResponseData = this.sendJoinRequest(groupId, x$9, x$11, x$12, x$13, metadata, x$14);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)rejoinGroupResponseData.errorCode());
        if (completeRebalance) {
            String x$16 = rejoinGroupResponseData.memberId();
            int x$17 = rejoinGroupResponseData.generationId();
            .colon.colon x$18 = new .colon.colon((Object)new SyncGroupRequestData.SyncGroupRequestAssignment().setMemberId(rejoinGroupResponseData.memberId()).setAssignment(assignment), (List)Nil$.MODULE$);
            String x$20 = this.syncGroupWithOldProtocol$default$4();
            String x$21 = this.syncGroupWithOldProtocol$default$5();
            String x$22 = this.syncGroupWithOldProtocol$default$7();
            String x$23 = this.syncGroupWithOldProtocol$default$8();
            Errors x$24 = this.syncGroupWithOldProtocol$default$10();
            short x$25 = this.syncGroupWithOldProtocol$default$11();
            this.syncGroupWithOldProtocol(groupId, x$16, x$17, x$20, x$21, (List<SyncGroupRequestData.SyncGroupRequestAssignment>)x$18, x$22, x$23, assignment, x$24, x$25);
        }
        return new Tuple2((Object)rejoinGroupResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)rejoinGroupResponseData.generationId()));
    }

    public byte[] joinDynamicConsumerGroupWithOldProtocol$default$2() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public byte[] joinDynamicConsumerGroupWithOldProtocol$default$3() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public boolean joinDynamicConsumerGroupWithOldProtocol$default$4() {
        return true;
    }

    public Tuple2<String, Object> joinStaticConsumerGroupWithOldProtocol(String groupId, String groupInstanceId, byte[] metadata, boolean completeRebalance) {
        String x$4 = this.sendJoinRequest$default$2();
        String x$5 = this.sendJoinRequest$default$4();
        String x$6 = this.sendJoinRequest$default$5();
        short x$7 = this.sendJoinRequest$default$7();
        JoinGroupResponseData joinGroupResponseData = this.sendJoinRequest(groupId, x$4, groupInstanceId, x$5, x$6, metadata, x$7);
        if (completeRebalance) {
            this.syncGroupWithOldProtocol(groupId, joinGroupResponseData.memberId(), joinGroupResponseData.generationId(), this.syncGroupWithOldProtocol$default$4(), this.syncGroupWithOldProtocol$default$5(), this.syncGroupWithOldProtocol$default$6(), this.syncGroupWithOldProtocol$default$7(), this.syncGroupWithOldProtocol$default$8(), this.syncGroupWithOldProtocol$default$9(), this.syncGroupWithOldProtocol$default$10(), this.syncGroupWithOldProtocol$default$11());
        }
        return new Tuple2((Object)joinGroupResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)joinGroupResponseData.generationId()));
    }

    public byte[] joinStaticConsumerGroupWithOldProtocol$default$3() {
        return (byte[])Array$.MODULE$.empty(ClassTag$.MODULE$.Byte());
    }

    public boolean joinStaticConsumerGroupWithOldProtocol$default$4() {
        return true;
    }

    public Tuple2<String, Object> joinConsumerGroupWithNewProtocol(String groupId) {
        int x$2 = 300000;
        .colon.colon x$3 = new .colon.colon((Object)"foo", (List)Nil$.MODULE$);
        List x$4 = List$.MODULE$.empty();
        String x$5 = this.consumerGroupHeartbeat$default$2();
        int x$6 = this.consumerGroupHeartbeat$default$3();
        String x$7 = this.consumerGroupHeartbeat$default$4();
        String x$8 = this.consumerGroupHeartbeat$default$5();
        String x$9 = this.consumerGroupHeartbeat$default$7();
        Errors x$10 = this.consumerGroupHeartbeat$default$10();
        ConsumerGroupHeartbeatResponseData consumerGroupHeartbeatResponseData = this.consumerGroupHeartbeat(groupId, x$5, x$6, x$7, x$8, x$2, x$9, (List<String>)x$3, (List<ConsumerGroupHeartbeatRequestData.TopicPartitions>)x$4, x$10);
        return new Tuple2((Object)consumerGroupHeartbeatResponseData.memberId(), (Object)BoxesRunTime.boxToInteger((int)consumerGroupHeartbeatResponseData.memberEpoch()));
    }

    public Tuple2<String, Object> joinConsumerGroup(String groupId, boolean useNewProtocol) {
        if (useNewProtocol) {
            return this.joinConsumerGroupWithNewProtocol(groupId);
        }
        return this.joinDynamicConsumerGroupWithOldProtocol(groupId, this.joinDynamicConsumerGroupWithOldProtocol$default$2(), this.joinDynamicConsumerGroupWithOldProtocol$default$3(), this.joinDynamicConsumerGroupWithOldProtocol$default$4());
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(List<String> statesFilter, List<String> typesFilter, short version) {
        ListGroupsRequest request = new ListGroupsRequest.Builder(new ListGroupsRequestData().setStatesFilter((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(statesFilter).asJava()).setTypesFilter((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(typesFilter).asJava())).build(version);
        ListGroupsResponse response = (ListGroupsResponse)this.connectAndReceive((AbstractRequest)request, ClassTag$.MODULE$.apply(ListGroupsResponse.class));
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().groups()).asScala()).toList();
    }

    public short listGroups$default$3() {
        return ApiKeys.LIST_GROUPS.latestVersion(this.isUnstableApiEnabled());
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(List<String> groupIds, short version) {
        DescribeGroupsRequest describeGroupsRequest = new DescribeGroupsRequest.Builder(new DescribeGroupsRequestData().setGroups((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(groupIds).asJava())).build(version);
        DescribeGroupsResponse describeGroupsResponse = (DescribeGroupsResponse)this.connectAndReceive((AbstractRequest)describeGroupsRequest, ClassTag$.MODULE$.apply(DescribeGroupsResponse.class));
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(describeGroupsResponse.data().groups()).asScala()).toList();
    }

    public short describeGroups$default$2() {
        return ApiKeys.DESCRIBE_GROUPS.latestVersion(this.isUnstableApiEnabled());
    }

    public List<ConsumerGroupDescribeResponseData.DescribedGroup> consumerGroupDescribe(List<String> groupIds, boolean includeAuthorizedOperations, short version) {
        ConsumerGroupDescribeRequest consumerGroupDescribeRequest = new ConsumerGroupDescribeRequest.Builder(new ConsumerGroupDescribeRequestData().setGroupIds((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(groupIds).asJava()).setIncludeAuthorizedOperations(includeAuthorizedOperations)).build(version);
        ConsumerGroupDescribeResponse consumerGroupDescribeResponse = (ConsumerGroupDescribeResponse)this.connectAndReceive((AbstractRequest)consumerGroupDescribeRequest, ClassTag$.MODULE$.apply(ConsumerGroupDescribeResponse.class));
        return ((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(consumerGroupDescribeResponse.data().groups()).asScala()).toList();
    }

    public short consumerGroupDescribe$default$3() {
        return ApiKeys.CONSUMER_GROUP_DESCRIBE.latestVersion(this.isUnstableApiEnabled());
    }

    public HeartbeatResponseData heartbeat(String groupId, int generationId, String memberId, String groupInstanceId, Errors expectedError, short version) {
        HeartbeatRequest heartbeatRequest = new HeartbeatRequest.Builder(new HeartbeatRequestData().setGroupId(groupId).setGenerationId(generationId).setMemberId(memberId).setGroupInstanceId(groupInstanceId)).build(version);
        HeartbeatResponse heartbeatResponse = (HeartbeatResponse)this.connectAndReceive((AbstractRequest)heartbeatRequest, ClassTag$.MODULE$.apply(HeartbeatResponse.class));
        Assertions.assertEquals((short)expectedError.code(), (short)heartbeatResponse.data().errorCode());
        return heartbeatResponse.data();
    }

    public String heartbeat$default$4() {
        return null;
    }

    public Errors heartbeat$default$5() {
        return Errors.NONE;
    }

    /*
     * WARNING - void declaration
     */
    public ConsumerGroupHeartbeatResponseData consumerGroupHeartbeat(String groupId, String memberId, int memberEpoch, String instanceId, String rackId, int rebalanceTimeoutMs, String serverAssignor, List<String> subscribedTopicNames, List<ConsumerGroupHeartbeatRequestData.TopicPartitions> topicPartitions, Errors expectedError) {
        ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest = (ConsumerGroupHeartbeatRequest)new ConsumerGroupHeartbeatRequest.Builder(new ConsumerGroupHeartbeatRequestData().setGroupId(groupId).setMemberId(memberId).setMemberEpoch(memberEpoch).setInstanceId(instanceId).setRackId(rackId).setRebalanceTimeoutMs(rebalanceTimeoutMs).setSubscribedTopicNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(subscribedTopicNames).asJava()).setServerAssignor(serverAssignor).setTopicPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava()), true).build();
        ObjectRef consumerGroupHeartbeatResponse = ObjectRef.create(null);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!GroupCoordinatorBaseRequestTest.$anonfun$consumerGroupHeartbeat$1(this, consumerGroupHeartbeatResponse, consumerGroupHeartbeatRequest, expectedError)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)GroupCoordinatorBaseRequestTest.$anonfun$consumerGroupHeartbeat$2(consumerGroupHeartbeatResponse));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse.elem).data();
    }

    public String consumerGroupHeartbeat$default$2() {
        return "";
    }

    public int consumerGroupHeartbeat$default$3() {
        return 0;
    }

    public String consumerGroupHeartbeat$default$4() {
        return null;
    }

    public String consumerGroupHeartbeat$default$5() {
        return null;
    }

    public int consumerGroupHeartbeat$default$6() {
        return -1;
    }

    public String consumerGroupHeartbeat$default$7() {
        return null;
    }

    public List<String> consumerGroupHeartbeat$default$8() {
        return null;
    }

    public List<ConsumerGroupHeartbeatRequestData.TopicPartitions> consumerGroupHeartbeat$default$9() {
        return null;
    }

    public Errors consumerGroupHeartbeat$default$10() {
        return Errors.NONE;
    }

    public ConsumerGroupHeartbeatResponseData leaveGroupWithNewProtocol(String groupId, String memberId) {
        return this.consumerGroupHeartbeat(groupId, memberId, -1, this.consumerGroupHeartbeat$default$4(), this.consumerGroupHeartbeat$default$5(), this.consumerGroupHeartbeat$default$6(), this.consumerGroupHeartbeat$default$7(), this.consumerGroupHeartbeat$default$8(), this.consumerGroupHeartbeat$default$9(), this.consumerGroupHeartbeat$default$10());
    }

    public void leaveGroupWithOldProtocol(String groupId, List<String> memberIds, List<String> groupInstanceIds, Errors expectedLeaveGroupError, List<Errors> expectedMemberErrors, short version) {
        LeaveGroupRequest leaveGroupRequest = new LeaveGroupRequest.Builder(groupId, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.tabulate(memberIds.length(), (Function1 & Serializable & scala.Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$leaveGroupWithOldProtocol$1(memberIds, groupInstanceIds, BoxesRunTime.unboxToInt((Object)i)))).asJava()).build(version);
        LeaveGroupResponseData expectedResponseData = new LeaveGroupResponseData();
        Errors errors = expectedLeaveGroupError;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            expectedResponseData.setErrorCode(expectedLeaveGroupError.code());
        } else {
            expectedResponseData.setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.tabulate(expectedMemberErrors.length(), (Function1 & Serializable & scala.Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$leaveGroupWithOldProtocol$2(memberIds, groupInstanceIds, expectedMemberErrors, BoxesRunTime.unboxToInt((Object)i)))).asJava());
        }
        LeaveGroupResponse leaveGroupResponse = (LeaveGroupResponse)this.connectAndReceive((AbstractRequest)leaveGroupRequest, ClassTag$.MODULE$.apply(LeaveGroupResponse.class));
        Assertions.assertEquals((Object)expectedResponseData, (Object)leaveGroupResponse.data());
    }

    public void leaveGroup(String groupId, String memberId, boolean useNewProtocol, short version) {
        if (useNewProtocol) {
            this.leaveGroupWithNewProtocol(groupId, memberId);
            return;
        }
        this.leaveGroupWithOldProtocol(groupId, (List<String>)new .colon.colon((Object)memberId, (List)Nil$.MODULE$), null, Errors.NONE, (List<Errors>)new .colon.colon((Object)Errors.NONE, (List)Nil$.MODULE$), version);
    }

    public List<String> leaveGroupWithOldProtocol$default$3() {
        return null;
    }

    public short leaveGroupWithOldProtocol$default$6() {
        return ApiKeys.LEAVE_GROUP.latestVersion(this.isUnstableApiEnabled());
    }

    public void deleteGroups(List<String> groupIds, List<Errors> expectedErrors, short version) {
        if (groupIds.size() != expectedErrors.size()) {
            Assertions.fail((String)"deleteGroups: groupIds and expectedErrors have unmatched sizes.");
        }
        DeleteGroupsRequest deleteGroupsRequest = new DeleteGroupsRequest.Builder(new DeleteGroupsRequestData().setGroupsNames((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(groupIds).asJava())).build(version);
        DeleteGroupsResponseData expectedResponseData = new DeleteGroupsResponseData().setResults(new DeleteGroupsResponseData.DeletableGroupResultCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.tabulate(groupIds.length(), (Function1 & Serializable & scala.Serializable)i -> GroupCoordinatorBaseRequestTest.$anonfun$deleteGroups$1(groupIds, expectedErrors, BoxesRunTime.unboxToInt((Object)i)))).asJava()).iterator()));
        DeleteGroupsResponse deleteGroupsResponse = (DeleteGroupsResponse)this.connectAndReceive((AbstractRequest)deleteGroupsRequest, ClassTag$.MODULE$.apply(DeleteGroupsResponse.class));
        Assertions.assertEquals((Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)expectedResponseData.results()).asScala()).toSet(), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)deleteGroupsResponse.data().results()).asScala()).toSet());
    }

    public <T extends AbstractResponse> T connectAndReceive(AbstractRequest request, ClassTag<T> classTag) {
        return IntegrationTestUtils$.MODULE$.connectAndReceive(request, this.cluster.anyBrokerSocketServer(), this.cluster.clientListener(), classTag);
    }

    public static final /* synthetic */ void $anonfun$sortTopicPartitions$2(OffsetFetchResponseData.OffsetFetchResponseTopics topic) {
        topic.partitions().sort(Comparator.comparingInt(x$1 -> x$1.partitionIndex()));
    }

    public static final /* synthetic */ boolean $anonfun$sendJoinRequest$1(GroupCoordinatorBaseRequestTest $this, ObjectRef joinGroupResponse$1, JoinGroupRequest joinGroupRequest$1) {
        joinGroupResponse$1.elem = (JoinGroupResponse)$this.connectAndReceive((AbstractRequest)joinGroupRequest$1, ClassTag$.MODULE$.apply(JoinGroupResponse.class));
        return (JoinGroupResponse)joinGroupResponse$1.elem != null;
    }

    public static final /* synthetic */ String $anonfun$sendJoinRequest$2(ObjectRef joinGroupResponse$1) {
        return new StringBuilder(54).append("Could not join the group successfully. Last response ").append((JoinGroupResponse)joinGroupResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ boolean $anonfun$consumerGroupHeartbeat$1(GroupCoordinatorBaseRequestTest $this, ObjectRef consumerGroupHeartbeatResponse$1, ConsumerGroupHeartbeatRequest consumerGroupHeartbeatRequest$1, Errors expectedError$1) {
        consumerGroupHeartbeatResponse$1.elem = (ConsumerGroupHeartbeatResponse)$this.connectAndReceive((AbstractRequest)consumerGroupHeartbeatRequest$1, ClassTag$.MODULE$.apply(ConsumerGroupHeartbeatResponse.class));
        return ((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).data().errorCode() == expectedError$1.code();
    }

    public static final /* synthetic */ String $anonfun$consumerGroupHeartbeat$2(ObjectRef consumerGroupHeartbeatResponse$1) {
        return new StringBuilder(49).append("Could not heartbeat successfully. Last response ").append((ConsumerGroupHeartbeatResponse)consumerGroupHeartbeatResponse$1.elem).append(".").toString();
    }

    public static final /* synthetic */ LeaveGroupRequestData.MemberIdentity $anonfun$leaveGroupWithOldProtocol$1(List memberIds$1, List groupInstanceIds$1, int i) {
        return new LeaveGroupRequestData.MemberIdentity().setMemberId((String)memberIds$1.apply(i)).setGroupInstanceId(groupInstanceIds$1 == null ? null : (String)groupInstanceIds$1.apply(i));
    }

    public static final /* synthetic */ LeaveGroupResponseData.MemberResponse $anonfun$leaveGroupWithOldProtocol$2(List memberIds$1, List groupInstanceIds$1, List expectedMemberErrors$1, int i) {
        return new LeaveGroupResponseData.MemberResponse().setMemberId((String)memberIds$1.apply(i)).setGroupInstanceId(groupInstanceIds$1 == null ? null : (String)groupInstanceIds$1.apply(i)).setErrorCode(((Errors)expectedMemberErrors$1.apply(i)).code());
    }

    public static final /* synthetic */ DeleteGroupsResponseData.DeletableGroupResult $anonfun$deleteGroups$1(List groupIds$1, List expectedErrors$1, int i) {
        return new DeleteGroupsResponseData.DeletableGroupResult().setGroupId((String)groupIds$1.apply(i)).setErrorCode(((Errors)expectedErrors$1.apply(i)).code());
    }

    public GroupCoordinatorBaseRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

