/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.network.SocketServer;
import kafka.server.BadAuthorizer;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.DummyClientQuotaCallback;
import kafka.server.DummyClientQuotaCallback$;
import kafka.server.FakeConfigurableAuthorizer;
import kafka.server.FakeConfigurableAuthorizer$;
import kafka.server.HostedPartition;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.testkit.KafkaClusterTestKit;
import kafka.testkit.TestKitNodes;
import kafka.utils.TestUtils$;
import org.apache.commons.io.FileUtils;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeMetadataQuorumOptions;
import org.apache.kafka.clients.admin.FeatureMetadata;
import org.apache.kafka.clients.admin.FeatureUpdate;
import org.apache.kafka.clients.admin.FinalizedVersionRange;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.QuorumInfo;
import org.apache.kafka.clients.admin.SupportedVersionRange;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.UpdateFeaturesOptions;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.DescribeClusterRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.ConfigRecord;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.quota.ClientQuotaAlteration;
import org.apache.kafka.common.quota.ClientQuotaEntity;
import org.apache.kafka.common.quota.ClientQuotaFilter;
import org.apache.kafka.common.quota.ClientQuotaFilterComponent;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeClusterRequest;
import org.apache.kafka.common.requests.DescribeClusterResponse;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.controller.QuorumController;
import org.apache.kafka.controller.QuorumControllerIntegrationTestUtils;
import org.apache.kafka.image.ClusterImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.BrokerState;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.concurrent.duration.FiniteDuration;
import scala.jdk.CollectionConverters$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@Timeout(value=120L)
@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\ruf\u0001\u0002\u001f>\u0001\tCQ!\u0013\u0001\u0005\u0002)Cq!\u0014\u0001C\u0002\u0013\u0005a\n\u0003\u0004X\u0001\u0001\u0006Ia\u0014\u0005\b1\u0002\u0011\r\u0011\"\u0001O\u0011\u0019I\u0006\u0001)A\u0005\u001f\")!\f\u0001C\u00017\")!\u000e\u0001C\u00017\")A\u000e\u0001C\u00017\")a\u000e\u0001C\u00017\")\u0001\u000f\u0001C\u00017\")!\u000f\u0001C\u00017\")A\u000f\u0001C\u00017\")a\u000f\u0001C\u0001o\"9\u0011q\u0005\u0001\u0005\u0002\u0005%\u0002BBA\"\u0001\u0011\u00051\f\u0003\u0004\u0002H\u0001!\ta\u0017\u0005\u0007\u0003\u0017\u0002A\u0011A.\t\r\u0005=\u0003\u0001\"\u0001\\\u0011\u001d\t\u0019\u0006\u0001C\u0005\u0003+Bq!!\u001f\u0001\t\u0013\tY\bC\u0004\u00024\u0002!I!!.\t\u000f\u0005}\u0007\u0001\"\u0003\u0002b\"9\u0011q\u001e\u0001\u0005\n\u0005E\bB\u0002B\u0001\u0001\u0011\u00051\fC\u0004\u0003\u0006\u0001!IAa\u0002\t\u000f\t\r\u0002\u0001\"\u0003\u0003&!9!Q\t\u0001\u0005\n\t\u001d\u0003b\u0002B.\u0001\u0011%!Q\f\u0005\b\u0005\u000b\u0003A\u0011\u0002BD\u0011%\u0011y\nAI\u0001\n\u0013\u0011\t\u000b\u0003\u0004\u00038\u0002!\ta\u0017\u0005\u0007\u0005w\u0003A\u0011A.\t\u000f\t}\u0006\u0001\"\u0001\u0003B\"1!1\u001b\u0001\u0005\u0002mCqAa6\u0001\t\u0003\u0011I\u000eC\u0004\u0004\b\u0001!Ia!\u0003\t\u000f\ru\u0001\u0001\"\u0003\u0004 !91Q\u0005\u0001\u0005\n\r\u001d\u0002BBB\u0017\u0001\u0011\u00051\fC\u0004\u00042\u0001!\taa\r\t\r\r]\u0002\u0001\"\u0001\\\u0011\u0019\u0019Y\u0004\u0001C\u00017\"91q\b\u0001\u0005\u0002\r\u0005\u0003BBB*\u0001\u0011\u00051\f\u0003\u0004\u0004X\u0001!\ta\u0017\u0005\u0007\u00077\u0002A\u0011A.\t\r\r}\u0003\u0001\"\u0001\\\u0011\u0019\u0019\u0019\u0007\u0001C\u00017\"91q\r\u0001\u0005\u0002\r%\u0004bBB;\u0001\u0011\u00051q\u000f\u0005\u0007\u0007\u0007\u0003A\u0011A.\t\r\r\u001d\u0005\u0001\"\u0001\\\u0011\u0019\u0019Y\t\u0001C\u00017\"11q\u0012\u0001\u0005\u0002mCaaa%\u0001\t\u0003Y\u0006BBBL\u0001\u0011\u00051\f\u0003\u0004\u0004\u001c\u0002!\ta\u0017\u0005\u0007\u0007?\u0003A\u0011A.\t\r\r\r\u0006\u0001\"\u0001\\\u0005AY%+\u00194u\u00072,8\u000f^3s)\u0016\u001cHO\u0003\u0002?\u007f\u000511/\u001a:wKJT\u0011\u0001Q\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\t\u0005\u0002E\u000f6\tQIC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAUI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\u0003\"\u0001\u0014\u0001\u000e\u0003u\n1\u0001\\8h+\u0005y\u0005C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u0015\u0019HN\u001a\u001bk\u0015\u0005!\u0016aA8sO&\u0011a+\u0015\u0002\u0007\u0019><w-\u001a:\u0002\t1|w\rI\u0001\u0005Y><''A\u0003m_\u001e\u0014\u0004%A\ruKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000eZ\"m_N,G#\u0001/\u0011\u0005\u0011k\u0016B\u00010F\u0005\u0011)f.\u001b;)\u0005\u0019\u0001\u0007CA1i\u001b\u0005\u0011'BA2e\u0003\r\t\u0007/\u001b\u0006\u0003K\u001a\fqA[;qSR,'O\u0003\u0002h'\u0006)!.\u001e8ji&\u0011\u0011N\u0019\u0002\u0005)\u0016\u001cH/A\u0013uKN$8I]3bi\u0016\u001cE.^:uKJ\fe\u000e\u001a*fgR\f'\u000f\u001e\"s_.,'OT8eK\"\u0012q\u0001Y\u0001*i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3SKN$\u0018M\u001d;D_:$(o\u001c7mKJtu\u000eZ3)\u0005!\u0001\u0017a\f;fgR\u001c%/Z1uK\u000ecWo\u001d;fe\u0006sGmV1ji\u001a{'O\u0011:pW\u0016\u0014\u0018J\u001c*v]:LgnZ*uCR,\u0007FA\u0005a\u0003%\"Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f\u0019&\u001cH\u000fR3mKR,Gk\u001c9jG\"\u0012!\u0002Y\u0001(i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014\u0018I\u001c3De\u0016\fG/Z!oI6\u000bg.\u001f+pa&\u001c7\u000f\u000b\u0002\fA\u0006\u0001B/Z:u\u00072LWM\u001c;Rk>$\u0018m\u001d\u0015\u0003\u0019\u0001\f1c]3u\u0007>t7/^7fe\nKH/\u001a*bi\u0016$b\u0001\u0018=\u0002\n\u0005u\u0001\"B=\u000e\u0001\u0004Q\u0018!B1e[&t\u0007cA>\u0002\u00065\tAP\u0003\u0002z{*\u0011ap`\u0001\bG2LWM\u001c;t\u0015\r\u0001\u0015\u0011\u0001\u0006\u0004\u0003\u0007\u0019\u0016AB1qC\u000eDW-C\u0002\u0002\bq\u0014Q!\u00113nS:Dq!a\u0003\u000e\u0001\u0004\ti!\u0001\u0004f]RLG/\u001f\t\u0005\u0003\u001f\tI\"\u0004\u0002\u0002\u0012)!\u00111CA\u000b\u0003\u0015\tXo\u001c;b\u0015\r\t9b`\u0001\u0007G>lWn\u001c8\n\t\u0005m\u0011\u0011\u0003\u0002\u0012\u00072LWM\u001c;Rk>$\u0018-\u00128uSRL\bbBA\u0010\u001b\u0001\u0007\u0011\u0011E\u0001\u0006m\u0006dW/\u001a\t\u0004\t\u0006\r\u0012bAA\u0013\u000b\n!Aj\u001c8h\u0003Q9W\r^\"p]N,X.\u001a:CsR,'+\u0019;fgR!\u00111FA!!!\ti#a\u000f\u0002\u000e\u0005\u0005b\u0002BA\u0018\u0003o\u00012!!\rF\u001b\t\t\u0019DC\u0002\u00026\u0005\u000ba\u0001\u0010:p_Rt\u0014bAA\u001d\u000b\u00061\u0001K]3eK\u001aLA!!\u0010\u0002@\t\u0019Q*\u00199\u000b\u0007\u0005eR\tC\u0003z\u001d\u0001\u0007!0A\fuKN$H)\u001a4bk2$8\t\\5f]R\fVo\u001c;bg\"\u0012q\u0002Y\u0001(i\u0016\u001cHo\u0011:fCR,7\t\\;ti\u0016\u0014x+\u001b;i\u0003\u00124XM\u001d;jg\u0016$\u0007k\u001c:u5\u0016\u0014x\u000e\u000b\u0002\u0011A\u0006\u0019E/Z:u\u0007J,\u0017\r^3DYV\u001cH/\u001a:XSRD\u0017\t\u001a<feRL7/\u001a3I_N$\u0018I\u001c3Q_J$H)\u001b4gKJ,g\u000e\u001e$s_6\u001cvnY6fiN+'O^3sQ\t\t\u0002-A\u0014uKN$8I]3bi\u0016\u001cE.^:uKJLeN^1mS\u0012lU\r^1eCR\fg+\u001a:tS>t\u0007F\u0001\na\u0003]!wn\u00148Ti\u0006\u0014H/\u001a3LC\u001a\\\u0017m\u00117vgR,'\u000f\u0006\u0003\u0002X\u0005=Dc\u0001/\u0002Z!9\u00111L\nA\u0002\u0005u\u0013AB1di&|g\u000e\u0005\u0004E\u0003?\n\u0019\u0007X\u0005\u0004\u0003C*%!\u0003$v]\u000e$\u0018n\u001c82!\u0011\t)'a\u001b\u000e\u0005\u0005\u001d$bAA5\u007f\u00059A/Z:uW&$\u0018\u0002BA7\u0003O\u00121cS1gW\u0006\u001cE.^:uKJ$Vm\u001d;LSRDq!!\u001d\u0014\u0001\u0004\t\u0019(A\u0003o_\u0012,7\u000f\u0005\u0003\u0002f\u0005U\u0014\u0002BA<\u0003O\u0012A\u0002V3ti.KGOT8eKN\fah]3oI\u0012+7o\u0019:jE\u0016\u001cE.^:uKJ\u0014V-];fgR$vNQ8v]\u0012\u0004vN\u001d;V]RLG.\u00117m\u0005J|7.\u001a:t!J|\u0007/Y4bi\u0016$GCBA?\u0003\u001f\u000by\n\u0006\u0003\u0002\u0000\u0005-\u0005\u0003BAA\u0003\u000fk!!a!\u000b\t\u0005\u0015\u0015QC\u0001\te\u0016\fX/Z:ug&!\u0011\u0011RAB\u0005]!Um]2sS\n,7\t\\;ti\u0016\u0014(+Z:q_:\u001cX\rC\u0004\u0002\u000eR\u0001\u001d!a\u0019\u0002\u000f\rdWo\u001d;fe\"9\u0011\u0011\u0013\u000bA\u0002\u0005M\u0015\u0001\u00047jgR,g.\u001a:OC6,\u0007\u0003BAK\u00037k!!a&\u000b\t\u0005e\u0015QC\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ti*a&\u0003\u00191K7\u000f^3oKJt\u0015-\\3\t\u000f\u0005\u0005F\u00031\u0001\u0002$\u0006Aq/Y5u)&lW\r\u0005\u0003\u0002&\u0006=VBAAT\u0015\u0011\tI+a+\u0002\u0011\u0011,(/\u0019;j_:T1!!,F\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003c\u000b9K\u0001\bGS:LG/\u001a#ve\u0006$\u0018n\u001c8\u0002+]\f\u0017\u000e\u001e$peJ+hN\\5oO\n\u0013xn[3sgR1\u0011qWAj\u0003;$B!!/\u0002RB1\u00111XAc\u0003\u0017tA!!0\u0002B:!\u0011\u0011GA`\u0013\u00051\u0015bAAb\u000b\u00069\u0001/Y2lC\u001e,\u0017\u0002BAd\u0003\u0013\u00141aU3r\u0015\r\t\u0019-\u0012\t\u0004\u0019\u00065\u0017bAAh{\ta!I]8lKJ\u001cVM\u001d<fe\"9\u0011QR\u000bA\u0004\u0005\r\u0004bBAk+\u0001\u0007\u0011q[\u0001\u0006G>,h\u000e\u001e\t\u0004\t\u0006e\u0017bAAn\u000b\n\u0019\u0011J\u001c;\t\u000f\u0005\u0005V\u00031\u0001\u0002$\u0006Y4/\u001a8e\t\u0016\u001c8M]5cK\u000ecWo\u001d;feJ+\u0017/^3tiR{'i\\;oIB{'\u000f^+oi&d'I]8lKJ\u001c\bK]8qC\u001e\fG/\u001a3\u0015\u0015\u0005}\u00141]At\u0003S\fi\u000fC\u0004\u0002fZ\u0001\r!a3\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u0005\b\u0003#3\u0002\u0019AAJ\u0011\u001d\tYO\u0006a\u0001\u0003/\f1#\u001a=qK\u000e$X\r\u001a\"s_.,'oQ8v]RDq!!)\u0017\u0001\u0004\t\u0019+A\u0013tK:$G)Z:de&\u0014Wm\u00117vgR,'OU3rk\u0016\u001cH\u000fV8C_VtG\rU8siR1\u0011qPAz\u0003\u007fDq!!:\u0018\u0001\u0004\t)\u0010\u0005\u0003\u0002x\u0006mXBAA}\u0015\r\tIjP\u0005\u0005\u0003{\fIP\u0001\u0007T_\u000e\\W\r^*feZ,'\u000fC\u0004\u0002\u0012^\u0001\r!a%\u0002OQ,7\u000f^\"sK\u0006$Xm\u00117vgR,'/\u00118e!\u0016\u0014hm\u001c:n%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u00031\u0001\f1c\u00195fG.\u0014V\r\u001d7jG\u0006l\u0015M\\1hKJ$R\u0001\u0018B\u0005\u0005\u0017Aq!!$\u001a\u0001\u0004\t\u0019\u0007C\u0004\u0003\u000ee\u0001\rAa\u0004\u0002\u001f\u0015D\b/Z2uK\u0012Dun\u001d;j]\u001e\u0004b!a/\u0003\u0012\tU\u0011\u0002\u0002B\n\u0003\u0013\u0014A\u0001T5tiB9AIa\u0006\u0002X\nm\u0011b\u0001B\r\u000b\n1A+\u001e9mKJ\u0002b!a/\u0003\u0012\tu\u0001c\u0001#\u0003 %\u0019!\u0011E#\u0003\u000f\t{w\u000e\\3b]\u0006YBO]1og2\fG/\u001a)beRLG/[8o\u0013:4w\u000eV8TKF$BAa\n\u0003,A1\u00111XAc\u0005S\u0001b!a/\u0002F\u0006]\u0007b\u0002B\u00175\u0001\u0007!qF\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\bC\u0002B\u0019\u0005w\u0011i$\u0004\u0002\u00034)!!Q\u0007B\u001c\u0003\u0011)H/\u001b7\u000b\u0005\te\u0012\u0001\u00026bm\u0006LAAa\u0005\u00034A!!q\bB!\u001b\t\t)\"\u0003\u0003\u0003D\u0005U!A\u0005+pa&\u001c\u0007+\u0019:uSRLwN\\%oM>\f1c^1ji\u001a{'\u000fV8qS\u000ed\u0015n\u001d;j]\u001e$r\u0001\u0018B%\u0005\u0017\u00129\u0006C\u0003z7\u0001\u0007!\u0010C\u0004\u0003Nm\u0001\rAa\u0014\u0002\u001f\u0015D\b/Z2uK\u0012\u0004&/Z:f]R\u0004b!a/\u0002F\nE\u0003\u0003BA\u0017\u0005'JAA!\u0016\u0002@\t11\u000b\u001e:j]\u001eDqA!\u0017\u001c\u0001\u0004\u0011y%\u0001\bfqB,7\r^3e\u0003\n\u001cXM\u001c;\u0002!%t7M]3nK:$\u0018\r\\!mi\u0016\u0014HC\u0002B0\u0005O\u0012I\u0007\u0005\u0004\u0002<\u0006\u0015'\u0011\r\t\u0005\u0003\u0003\u0013\u0019'\u0003\u0003\u0003f\u0005\r%\u0001C!qS\u0016\u0013(o\u001c:\t\u000bed\u0002\u0019\u0001>\t\u000f\t-D\u00041\u0001\u0003n\u000591\r[1oO\u0016\u001c\bCBA^\u0003\u000b\u0014y\u0007E\u0004E\u0005/\u0011\tH! \u0011\t\tM$\u0011P\u0007\u0003\u0005kRAAa\u001e\u0002\u0016\u000511m\u001c8gS\u001eLAAa\u001f\u0003v\tq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0007CBA^\u0003\u000b\u0014y\bE\u0002|\u0005\u0003K1Aa!}\u00055\tE\u000e^3s\u0007>tg-[4Pa\u0006ya/\u00197jI\u0006$XmQ8oM&<7\u000f\u0006\u0005\u0003\n\n=%\u0011\u0013BN!!\ti#a\u000f\u0003r\t-\u0005\u0003\u0003B\u0019\u0005\u001b\u0013\tF!\u0015\n\t\u0005u\"1\u0007\u0005\u0006sv\u0001\rA\u001f\u0005\b\u0005'k\u0002\u0019\u0001BK\u0003!)\u0007\u0010]3di\u0016$\u0007\u0003CA\u0017\u0003w\u0011\tHa&\u0011\r\u0005m\u0016Q\u0019BM!\u001d!%q\u0003B)\u0005#B\u0011B!(\u001e!\u0003\u0005\rA!\b\u0002\u0015\u0015D\b.Y;ti&4X-A\rwC2LG-\u0019;f\u0007>tg-[4tI\u0011,g-Y;mi\u0012\u001aTC\u0001BRU\u0011\u0011iB!*,\u0005\t\u001d\u0006\u0003\u0002BU\u0005gk!Aa+\u000b\t\t5&qV\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!-F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005k\u0013YKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bFA\u0010a\u0003i!Xm\u001d;TKRdun\u001a\u001bk\u0007>tg-[4ve\u0006$\u0018n\u001c8tQ\t\u0001\u0003-A\u0006mK\u001e\f7-_!mi\u0016\u0014HC\u0002B0\u0005\u0007\u0014)\rC\u0003zC\u0001\u0007!\u0010C\u0004\u0003H\u0006\u0002\rA!3\u0002\u0013I,7o\\;sG\u0016\u001c\b\u0003CA\u0017\u0003w\u0011\tHa3\u0011\r\u0005m\u0016Q\u0019Bg!\rY(qZ\u0005\u0004\u0005#d(aC\"p]\u001aLw-\u00128uef\fa\u0003^3ti2+w-Y2z\u00032$XM]\"p]\u001aLwm\u001d\u0015\u0003E\u0001\fA\u0003^3ti\u000e\u0013X-\u0019;f!\u0006\u0014H/\u001b;j_:\u001cHc\u0001/\u0003\\\"9!Q\\\u0012A\u0002\tE\u0013!F7fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8TiJLgn\u001a\u0015\bG\t\u0005(\u0011\u001fBz!\u0011\u0011\u0019O!<\u000e\u0005\t\u0015(\u0002\u0002Bt\u0005S\f\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0004\u0005W$\u0017A\u00029be\u0006l7/\u0003\u0003\u0003p\n\u0015(a\u0003,bYV,7k\\;sG\u0016\fqa\u001d;sS:<7\u000f\f\u0003\u0003v\ne\u0018E\u0001B|\u0003\u001d\u0019dfN\u0017J-B\n#Aa?\u0002\u000fMrs'L%We!\u001a1Ea@\u0011\t\r\u000511A\u0007\u0003\u0005SLAa!\u0002\u0003j\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\u0019\rdWo\u001d;fe&k\u0017mZ3\u0015\r\r-1qCB\r!\u0011\u0019iaa\u0005\u000e\u0005\r=!bAB\t\u007f\u0006)\u0011.\\1hK&!1QCB\b\u00051\u0019E.^:uKJLU.Y4f\u0011\u001d\ti\t\na\u0001\u0003GBqaa\u0007%\u0001\u0004\t9.\u0001\u0005ce>\\WM]%e\u0003A\u0011'o\\6fe&\u001bXK\u001c4f]\u000e,G\r\u0006\u0004\u0003\u001e\r\u000521\u0005\u0005\b\u0007#)\u0003\u0019AB\u0006\u0011\u001d\u0019Y\"\na\u0001\u0003/\faB\u0019:pW\u0016\u0014\u0018j]!cg\u0016tG\u000f\u0006\u0004\u0003\u001e\r%21\u0006\u0005\b\u0007#1\u0003\u0019AB\u0006\u0011\u001d\u0019YB\na\u0001\u0003/\fA\u0003^3tiVs'/Z4jgR,'O\u0011:pW\u0016\u0014\bFA\u0014a\u0003E\u0019'/Z1uK\u0006#W.\u001b8DY&,g\u000e\u001e\u000b\u0004u\u000eU\u0002bBAGQ\u0001\u0007\u00111M\u0001#i\u0016\u001cH\u000fR3tGJL'-Z)v_J,XNU3rk\u0016\u001cH\u000fV8Ce>\\WM]:)\u0005%\u0002\u0017!\u0007;fgR,\u0006\u000fZ1uK6+G/\u00193bi\u00064VM]:j_:D#A\u000b1\u00021Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3L%\u00064GOV3sg&|g\u000eF\u0002]\u0007\u0007Bqa!\u0012,\u0001\u0004\u0011i\"\u0001\rvg&twMQ8piN$(/\u00199D_:$(o\u001c7feNDsa\u000bBq\u0007\u0013\u001aY%\u0001\u0005c_>dW-\u00198tY\u0011\u0019iea\u0014\u001a\u0003\u0001I\u0012!\u0001\u0015\u0004W\t}\u0018!\t;fgR\u0014V-\\8uK2{w-T1oC\u001e,'/\u00138ti\u0006tG/[1uS>t\u0007F\u0001\u0017a\u0003\u0001#Xm\u001d;De\u0016\fG/Z\"mkN$XM]!oI\u000e\u0013X-\u0019;f)>\u0004\u0018nY,ji\"\u0014V-\\8uK2{w-T1oC\u001e,'/\u00138ti\u0006tG/[1uS>t\u0007FA\u0017a\u0003E!Xm\u001d;T]\u0006\u00048\u000f[8u\u0007>,h\u000e\u001e\u0015\u0003]\u0001\fQ\u0006^3ti\u0006+H\u000f[8sSj,'OR1jYV\u0014XMR8v]\u0012LenQ8oiJ|G\u000e\\3s'R\f'\u000f^;qQ\ty\u0003-A\u0014uKN$8+\u001b8hY\u0016\u001cuN\u001c;s_2dWM]*j]\u001edWM\u0011:pW\u0016\u00148\t\\;ti\u0016\u0014\bF\u0001\u0019a\u0003\u0015\"Xm\u001d;SK\u000e|gNZ5hkJ,7i\u001c8ue>dG.\u001a:DY&,g\u000e^)v_R\f7\u000fF\u0002]\u0007WBqa!\u001c2\u0001\u0004\u0011i\"\u0001\nd_6\u0014\u0017N\\3e\u0007>tGO]8mY\u0016\u0014\bfB\u0019\u0003b\u000e%3\u0011\u000f\u0017\u0005\u0007\u001b\u001ay\u0005K\u00022\u0005\u007f\f1\u0005^3tiJ+7m\u001c8gS\u001e,(/Z\"p]R\u0014x\u000e\u001c7fe\u0006+H\u000f[8sSj,'\u000fF\u0002]\u0007sBqaa\u001f3\u0001\u0004\u0011i\"\u0001\u0007d_6\u0014\u0017N\\3e\u001b>$W\rK\u00043\u0005C\u001cIea -\t\r53q\n\u0015\u0004e\t}\u0018a\u0007;fgR|e/\u001a:ms2\u000b'oZ3De\u0016\fG/\u001a+pa&\u001c7\u000f\u000b\u00024A\u00061B/Z:u)&lW\rZ(vi\"+\u0017M\u001d;cK\u0006$8\u000f\u000b\u00025A\u0006\tC/Z:u%\u0016<\u0017n\u001d;fe\u0016$7i\u001c8ue>dG.\u001a:F]\u0012\u0004x.\u001b8ug\"\u0012Q\u0007Y\u0001?i\u0016\u001cH\u000fR5sK\u000e$Hk\\\"p]R\u0014x\u000e\u001c7fe\u000e{W.\\;oS\u000e\fG/[8o\r\u0006LGn](o\u001f2$WM]'fi\u0006$\u0017\r^1WKJ\u001c\u0018n\u001c8)\u0005Y\u0002\u0017\u0001\u000f;fgR\u001cF/\u0019:ukB<\u0016\u000e\u001e5O_:$UMZ1vYR\\5i\u001c8ue>dG.\u001a:Es:\fW.[2D_:4\u0017nZ;sCRLwN\u001c\u0015\u0003o\u0001\fQ\u0006^3tiR{\u0007/[2EK2,G/\u001a3B]\u0012\u0014Vm\u0019:fCR,Gm\u00165jY\u0016\u0014%o\\6fe&\u001bHi\\<oQ\tA\u0004-\u0001 uKN$\u0018IY1oI>tW\r\u001a$viV\u0014XMU3qY&\u001c\u0017MU3d_Z,'/\u001a3`[\u0006LgNU3qY&\u001c\u0017-\u00138PM\u001ad\u0017N\\3M_\u001e$\u0015N\u001d\u0015\u0003s\u0001\fQ\b^3ti\u0006\u0013\u0017M\u001c3p]\u0016$g)\u001e;ve\u0016\u0014V\r\u001d7jG\u0006\u0014VmY8wKJ,GmX7bS:\u0014V\r\u001d7jG\u0006Len\u00148mS:,Gj\\4ESJD#A\u000f1\u0002-Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe\u001a\u000b\u0017\u000e\\8wKJD#a\u000f1)\u000f\u0001\u0019I+a\b\u00040B\u0019\u0011ma+\n\u0007\r5&MA\u0002UC\u001e\f#a!-\u0002\u0017%tG/Z4sCRLwN\u001c\u0015\b\u0001\rU\u0016qDB^!\r\t7qW\u0005\u0004\u0007s\u0013'a\u0002+j[\u0016|W\u000f\u001e\u0010\u0002q\u0002")
public class KRaftClusterTest {
    private final Logger log = LoggerFactory.getLogger(KRaftClusterTest.class);
    private final Logger log2 = LoggerFactory.getLogger((String)new StringBuilder(1).append(KRaftClusterTest.class.getCanonicalName()).append("2").toString());

    public Logger log() {
        return this.log;
    }

    public Logger log2() {
        return this.log2;
    }

    @Test
    public void testCreateClusterAndClose() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
        }
    }

    @Test
    public void testCreateClusterAndRestartBrokerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            BrokerServer broker = cluster.brokers().values().iterator().next();
            broker.shutdown();
            broker.startup();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndRestartControllerNode() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = (ControllerServer)((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(cluster.controllers().values().iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$1(x$1))).next();
            int port = controller.socketServer().boundPort(((EndPoint)controller.config().controllerListeners().head()).listenerName());
            controller.shutdown();
            java.util.Map config = controller.sharedServer().controllerConfig().props();
            ((HashMap)config).put("listeners", new StringBuilder(23).append("CONTROLLER://localhost:").append(port).toString());
            controller.sharedServer().controllerConfig().updateCurrentConfig(new KafkaConfig(config));
            controller.sharedServer().metrics_$eq(new Metrics());
            controller.startup();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$2(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndWaitForBrokerInRunningState() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndWaitForBrokerInRunningState$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)cluster.nodes().clusterId().toString(), (Object)admin.describeCluster().clusterId().get());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateListDeleteTopic() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$3(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateListDeleteTopic$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (Seq<String>)Nil$.MODULE$, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateAndManyTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$3(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateAndManyTopics$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList<NewTopic> newTopic = new ArrayList<NewTopic>();
                newTopic.add(new NewTopic("test-topic-1", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-2", 2, (short)3));
                newTopic.add(new NewTopic("test-topic-3", 2, (short)3));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic-1", (List)new .colon.colon((Object)"test-topic-2", (List)new .colon.colon((Object)"test-topic-3", (List)Nil$.MODULE$))), (Seq<String>)Nil$.MODULE$);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClientQuotas() {
        block16: {
            try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
                cluster.format();
                cluster.startup();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testClientQuotas$1(cluster)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)KRaftClusterTest.$anonfun$testClientQuotas$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                    void var21_16;
                    Tuple2 tuple2;
                    ClientQuotaEntity entity = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit")}))).asJava());
                    ObjectRef filter = ObjectRef.create((Object)ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava())));
                    java.util.Map describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.99)), (List)Nil$.MODULE$), (ClientQuotaFilter)filter.elem, 1, admin);
                    Assertions.assertEquals((double)0.99, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                    describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.97)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(10000.0)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double(10001.0)), (List)Nil$.MODULE$))), (ClientQuotaFilter)filter.elem, 3, admin);
                    Assertions.assertEquals((double)0.97, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                    Assertions.assertEquals((double)10000.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                    Assertions.assertEquals((double)10001.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("consumer_byte_rate")), (double)1.0E-6);
                    describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", Predef$.MODULE$.double2Double(0.95)), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", null), (List)new .colon.colon((Object)new ClientQuotaAlteration.Op("consumer_byte_rate", null), (List)Nil$.MODULE$))), (ClientQuotaFilter)filter.elem, 1, admin);
                    Assertions.assertEquals((double)0.95, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("request_percentage")), (double)1.0E-6);
                    KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("request_percentage", null), (List)Nil$.MODULE$), (ClientQuotaFilter)filter.elem, 0, admin);
                    describeResult = null;
                    describeResult = KRaftClusterTest.alterThenDescribe$1(entity, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9999.0)), (List)Nil$.MODULE$), (ClientQuotaFilter)filter.elem, 1, admin);
                    Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                    ClientQuotaEntity entity2 = new ClientQuotaEntity((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"user"), (Object)"testkit"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"client-id"), (Object)"some-client")}))).asJava());
                    filter.elem = ClientQuotaFilter.containsOnly((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"client-id", (String)"some-client"), (List)Nil$.MODULE$))).asJava()));
                    describeResult = KRaftClusterTest.alterThenDescribe$1(entity2, (Seq)new .colon.colon((Object)new ClientQuotaAlteration.Op("producer_byte_rate", Predef$.MODULE$.double2Double(9998.0)), (List)Nil$.MODULE$), (ClientQuotaFilter)filter.elem, 1, admin);
                    Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)describeResult.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                    filter.elem = ClientQuotaFilter.contains((Collection)((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ClientQuotaFilterComponent.ofEntity((String)"user", (String)"testkit"), (List)Nil$.MODULE$)).asJava()));
                    JFunction0.mcV.sp & Serializable & scala.Serializable intersect = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                        java.util.Map results = (java.util.Map)admin.describeClientQuotas((ClientQuotaFilter)filter$2.elem).entities().get();
                        Assertions.assertEquals((int)2, (int)results.size(), (String)"Broker did not see two client quotas");
                        Assertions.assertEquals((double)9999.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity)).get("producer_byte_rate")), (double)1.0E-6);
                        Assertions.assertEquals((double)9998.0, (double)Predef$.MODULE$.Double2double((Double)((java.util.Map)results.get(entity2)).get("producer_byte_rate")), (double)1.0E-6);
                    };
                    long l3 = TestUtils$.MODULE$.tryUntilNoAssertionError$default$2();
                    long l4 = TestUtils$.MODULE$.tryUntilNoAssertionError$default$1();
                    if (TestUtils$.MODULE$ == null) {
                        throw null;
                    }
                    long tryUntilNoAssertionError_computeUntilTrue_startTime = System.currentTimeMillis();
                    while (true) {
                        void tryUntilNoAssertionError_pause;
                        void tryUntilNoAssertionError_waitTime;
                        void tryUntilNoAssertionError_assertions;
                        Either tryUntilNoAssertionError_computeUntilTrue_result;
                        if (TestUtils$.$anonfun$tryUntilNoAssertionError$2(tryUntilNoAssertionError_computeUntilTrue_result = TestUtils$.$anonfun$tryUntilNoAssertionError$1((Function0)tryUntilNoAssertionError_assertions))) {
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                            break;
                        }
                        if (System.currentTimeMillis() > tryUntilNoAssertionError_computeUntilTrue_startTime + tryUntilNoAssertionError_waitTime) {
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tryUntilNoAssertionError_computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                            break;
                        }
                        Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)tryUntilNoAssertionError_waitTime), (long)tryUntilNoAssertionError_pause));
                    }
                    Tuple2 tuple22 = tuple2;
                    if (tuple22 == null) {
                        throw new MatchError(null);
                    }
                    Either tryUntilNoAssertionError_either = (Either)tuple22._1();
                    if (var21_16 instanceof Left) {
                        ((Left)var21_16).value();
                        break block16;
                    }
                    if (var21_16 instanceof Right) {
                        throw (AssertionError)((Right)var21_16).value();
                    }
                    throw new MatchError((Object)var21_16);
                }
            }
        }
    }

    public void setConsumerByteRate(Admin admin, ClientQuotaEntity entity, long value) {
        admin.alterClientQuotas(Collections.singletonList(new ClientQuotaAlteration(entity, Collections.singletonList(new ClientQuotaAlteration.Op("consumer_byte_rate", Predef$.MODULE$.double2Double((double)value)))))).all().get();
    }

    public scala.collection.immutable.Map<ClientQuotaEntity, Object> getConsumerByteRates(Admin admin) {
        ClientQuotaFilter allFilter = ClientQuotaFilter.contains(Collections.emptyList());
        HashMap results = new HashMap();
        ((java.util.Map)admin.describeClientQuotas(allFilter).entities().get()).forEach((x0$1, x1$1) -> {
            ClientQuotaEntity entity = x0$1;
            java.util.Map entityMap = x1$1;
            Option$.MODULE$.apply(entityMap.get("consumer_byte_rate")).foreach((Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToLong((long)KRaftClusterTest.$anonfun$getConsumerByteRates$2(results, entity, value)));
        });
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(results).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDefaultClientQuotas() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testDefaultClientQuotas$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testDefaultClientQuotas$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ClientQuotaEntity defaultUser = new ClientQuotaEntity(Collections.singletonMap("user", null));
                ClientQuotaEntity bobUser = new ClientQuotaEntity(Collections.singletonMap("user", "bob"));
                TestUtils$ testUtils$ = TestUtils$.MODULE$;
                long l3 = 30000L;
                if (testUtils$ == null) {
                    throw null;
                }
                TestUtils$ retry_this = testUtils$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$3(this, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                this.setConsumerByteRate(admin, defaultUser, 100L);
                TestUtils$ testUtils$2 = TestUtils$.MODULE$;
                long l4 = 30000L;
                if (testUtils$2 == null) {
                    throw null;
                }
                TestUtils$ retry_this2 = testUtils$2;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$4(this, defaultUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                this.setConsumerByteRate(admin, bobUser, 1000L);
                TestUtils$ testUtils$3 = TestUtils$.MODULE$;
                long l5 = 30000L;
                if (testUtils$3 == null) {
                    throw null;
                }
                TestUtils$ retry_this3 = testUtils$3;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testDefaultClientQuotas$5(this, defaultUser, bobUser, admin);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    @Test
    public void testCreateClusterWithAdvertisedPortZero() {
        HashMap<Integer, java.util.Map<String, String>> brokerPropertyOverrides = new HashMap<Integer, java.util.Map<String, String>>();
        ((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)3), (Integral)Numeric.IntIsIntegral$.MODULE$)).asJava()).forEach(brokerId -> KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$1(brokerPropertyOverrides, BoxesRunTime.unboxToInt((Object)brokerId)));
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(1).setNumBrokerNodes(3).setPerServerProperties(brokerPropertyOverrides).build();
        this.doOnStartedKafkaCluster(nodes, (Function1<KafkaClusterTestKit, BoxedUnit>)(Function1 & Serializable & scala.Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedPortZero$2(this, cluster);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer() {
        HashMap<Integer, java.util.Map<String, String>> brokerPropertyOverrides = new HashMap<Integer, java.util.Map<String, String>>();
        ((Iterable)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)3), (Integral)Numeric.IntIsIntegral$.MODULE$)).asJava()).forEach(brokerId -> KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$1(brokerPropertyOverrides, BoxesRunTime.unboxToInt((Object)brokerId)));
        TestKitNodes nodes = new TestKitNodes.Builder().setNumControllerNodes(1).setNumBrokerNodes(3).setNumDisksPerBroker(1).setPerServerProperties(brokerPropertyOverrides).build();
        this.doOnStartedKafkaCluster(nodes, (Function1<KafkaClusterTestKit, BoxedUnit>)(Function1 & Serializable & scala.Serializable)cluster -> {
            KRaftClusterTest.$anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(this, cluster);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCreateClusterInvalidMetadataVersion() {
        Assertions.assertEquals((Object)"Bootstrap metadata.version before 3.3-IV0 are not supported. Can't load metadata from testkit", (Object)Assertions.assertThrows(RuntimeException.class, () -> new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_2_7_IV0).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build()).getMessage());
    }

    private void doOnStartedKafkaCluster(TestKitNodes nodes, Function1<KafkaClusterTestKit, BoxedUnit> action) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(nodes).build();){
            cluster.format();
            cluster.startup();
            action.apply((Object)cluster);
        }
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(ListenerName listenerName, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        long startTime = System.currentTimeMillis();
        Seq<BrokerServer> runningBrokerServers = this.waitForRunningBrokers(1, waitTime, cluster);
        FiniteDuration remainingWaitTime = waitTime.$minus(scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)), (Object)TimeUnit.MILLISECONDS)));
        return this.sendDescribeClusterRequestToBoundPortUntilBrokersPropagated((BrokerServer)runningBrokerServers.head(), listenerName, cluster.nodes().brokerNodes().size(), remainingWaitTime);
    }

    /*
     * WARNING - void declaration
     */
    private Seq<BrokerServer> waitForRunningBrokers(int count, FiniteDuration waitTime, KafkaClusterTestKit cluster) {
        void var5_9;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = waitTime.toMillis();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            Seq computeUntilTrue_result;
            if ((computeUntilTrue_result = KRaftClusterTest.getRunningBrokerServers$1(cluster)).nonEmpty()) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        Seq runningBrokerServers = (Seq)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(82).append("After ").append(waitTime.toMillis()).append(" ms at least ").append(count).append(" broker(s) should be in RUNNING state, ").append("but only ").append(var5_9.size()).append(" broker(s) are.").toString());
        return var5_9;
    }

    /*
     * WARNING - void declaration
     */
    private DescribeClusterResponse sendDescribeClusterRequestToBoundPortUntilBrokersPropagated(BrokerServer destination, ListenerName listenerName, int expectedBrokerCount, FiniteDuration waitTime) {
        void var6_10;
        Tuple2 tuple2;
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = waitTime.toMillis();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            DescribeClusterResponse computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount, computeUntilTrue_result = this.sendDescribeClusterRequestToBoundPort(destination.socketServer(), listenerName))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        DescribeClusterResponse describeClusterResponse = (DescribeClusterResponse)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)new StringBuilder(62).append("After ").append(waitTime.toMillis()).append(" ms Broker is only aware of ").append(var6_10.nodes().size()).append(" brokers, ").append("but ").append(expectedBrokerCount).append(" are expected.").toString());
        return var6_10;
    }

    private DescribeClusterResponse sendDescribeClusterRequestToBoundPort(SocketServer destination, ListenerName listenerName) {
        return (DescribeClusterResponse)IntegrationTestUtils$.MODULE$.connectAndReceive(new DescribeClusterRequest.Builder(new DescribeClusterRequestData()).build(), destination, listenerName, ClassTag$.MODULE$.apply(DescribeClusterResponse.class));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndPerformReassignment() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                HashMap<Integer, java.util.List<Object>> assignments = new HashMap<Integer, java.util.List<Object>>();
                assignments.put(Predef$.MODULE$.int2Integer(0), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}));
                assignments.put(Predef$.MODULE$.int2Integer(1), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}));
                assignments.put(Predef$.MODULE$.int2Integer(2), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)}));
                assignments.put(Predef$.MODULE$.int2Integer(3), Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)}));
                admin.createTopics(Collections.singletonList(new NewTopic("foo", assignments))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"foo", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                Assertions.assertEquals(Collections.emptyMap(), (Object)admin.listPartitionReassignments().reassignments().get());
                HashMap<TopicPartition, Optional<NewPartitionReassignment>> reassignments = new HashMap<TopicPartition, Optional<NewPartitionReassignment>>();
                reassignments.put(new TopicPartition("foo", 0), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)}))));
                reassignments.put(new TopicPartition("foo", 1), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))));
                reassignments.put(new TopicPartition("foo", 2), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3)}))));
                reassignments.put(new TopicPartition("foo", 3), Optional.of(new NewPartitionReassignment(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))));
                admin.alterPartitionReassignments(reassignments).all().get();
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$1(admin)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$2());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                ObjectRef currentMapping = ObjectRef.create((Object)Nil$.MODULE$);
                .colon.colon expectedMapping = new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1, 0}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3}))), (List)new .colon.colon((Object)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))), (List)Nil$.MODULE$))));
                long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime2 = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$3(this, admin, currentMapping, (Seq)expectedMapping)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndPerformReassignment$4((Seq)expectedMapping, currentMapping));
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
                TestUtils$ testUtils$ = TestUtils$.MODULE$;
                long l5 = 60000L;
                if (testUtils$ == null) {
                    throw null;
                }
                TestUtils$ retry_this = testUtils$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        this.checkReplicaManager(cluster, (List<Tuple2<Object, List<Object>>>)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)0), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, true, false, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, true, true, true}))), (List)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, false, true, true}))), (List)Nil$.MODULE$)))));
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    private void checkReplicaManager(KafkaClusterTestKit cluster, List<Tuple2<Object, List<Object>>> expectedHosting) {
        expectedHosting.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            KRaftClusterTest.$anonfun$checkReplicaManager$2(cluster, x$8);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<Seq<Object>> translatePartitionInfoToSeq(java.util.List<TopicPartitionInfo> partitions) {
        return ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitions).asScala()).map((Function1 & Serializable & scala.Serializable)partition -> ((SeqLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partition.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()), Buffer$.MODULE$.canBuildFrom())).toSeq(), Buffer$.MODULE$.canBuildFrom())).toSeq();
    }

    /*
     * WARNING - void declaration
     */
    private void waitForTopicListing(Admin admin, Seq<String> expectedPresent, Seq<String> expectedAbsent) {
        HashSet topicsNotFound = new HashSet();
        ObjectRef extraTopics = ObjectRef.create(null);
        expectedPresent.foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsNotFound.add(x$1)));
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KRaftClusterTest.$anonfun$waitForTopicListing$2(admin, topicsNotFound, extraTopics, expectedAbsent)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KRaftClusterTest.$anonfun$waitForTopicListing$5(topicsNotFound, extraTopics));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private Seq<ApiError> incrementalAlter(Admin admin, Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>> changes) {
        HashMap configs = new HashMap();
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Seq ops = (Seq)x0$1._2();
                return (Collection)configs.put(resource, CollectionConverters$.MODULE$.seqAsJavaListConverter(ops).asJava());
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.incrementalAlterConfigs(configs).values();
        return (Seq)changes.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> validateConfigs(Admin admin, scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>> expected, boolean exhaustive) {
        scala.collection.mutable.HashMap results = new scala.collection.mutable.HashMap();
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$validateConfigs$1(this, admin, expected, results, exhaustive);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
        return results.toMap(Predef$.MODULE$.$conforms());
    }

    private boolean validateConfigs$default$3() {
        return false;
    }

    @Test
    public void testIncrementalAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, ""), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("log.roll.ms", "1234567"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "60"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "")), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"60"), (List)Nil$.MODULE$)))}))), true);
                admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3)})).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cluster.brokers().values()).asScala()).toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cluster.brokers().values()).asScala()).toSeq(), "bar", 2);
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)Nil$.MODULE$)}))), this.validateConfigs$default$3());
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "345"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("not.a.real.topic.config", "789"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("segment.jitter.ms", "678"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), this.validateConfigs$default$3());
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)new ConfigResource(ConfigResource.Type.BROKER, "2"), (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("max.connections.per.ip", "7"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.BROKER, "2")), (Object)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"7"), (List)Nil$.MODULE$))}))), this.validateConfigs$default$3());
            }
        }
    }

    @Test
    public void testSetLog4jConfigurations() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                new .colon.colon((Object)this.log(), (List)new .colon.colon((Object)this.log2(), (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
                    x$11.debug("setting log4j");
                    return BoxedUnit.UNIT;
                });
                ConfigResource broker2 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "2");
                ConfigResource broker3 = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "3");
                scala.collection.immutable.Map<ConfigResource, java.util.Map<String, String>> initialLog4j = this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)Nil$.MODULE$)}))), this.validateConfigs$default$3());
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "APPEND operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.APPEND), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), (Object)"TRACE"), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), (Object)"TRACE"), (List)Nil$.MODULE$)))}))), this.validateConfigs$default$3());
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_REQUEST, "SUBTRACT operation is not allowed for the BROKER_LOGGER resource"), (List)Nil$.MODULE$)), this.incrementalAlter(admin, (Seq<Tuple2<ConfigResource, Seq<AlterConfigOp>>>)new .colon.colon((Object)new Tuple2((Object)broker2, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (List)new .colon.colon((Object)new Tuple2((Object)broker3, (Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(this.log2().getName(), "TRACE"), AlterConfigOp.OpType.SUBTRACT), (List)Nil$.MODULE$))), (List)Nil$.MODULE$))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)broker2), (Object)new .colon.colon((Object)new Tuple2((Object)this.log().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log().getName())), (List)new .colon.colon((Object)new Tuple2((Object)this.log2().getName(), ((java.util.Map)initialLog4j.apply((Object)broker2)).get(this.log2().getName())), (List)Nil$.MODULE$)))}))), this.validateConfigs$default$3());
            }
        }
    }

    public Seq<ApiError> legacyAlter(Admin admin, scala.collection.immutable.Map<ConfigResource, Seq<ConfigEntry>> resources) {
        HashMap configs = new HashMap();
        resources.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                Seq entries = (Seq)x0$1._2();
                return configs.put(resource, new Config((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(entries).asJava()));
            }
            throw new MatchError(null);
        });
        java.util.Map values = admin.alterConfigs(configs).values();
        return ((TraversableOnce)resources.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 != null) {
                ConfigResource resource = (ConfigResource)x0$2._1();
                try {
                    ((KafkaFuture)values.get(resource)).get();
                    return ApiError.NONE;
                }
                catch (ExecutionException executionException) {
                    return ApiError.fromThrowable((Throwable)executionException.getCause());
                }
                catch (Throwable throwable) {
                    return ApiError.fromThrowable((Throwable)throwable);
                }
            }
            throw new MatchError(null);
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    @Test
    public void testLegacyAlterConfigs() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ConfigResource defaultBroker = new ConfigResource(ConfigResource.Type.BROKER, "");
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)new .colon.colon((Object)new ConfigEntry("max.connections.per.ip", "6"), (List)Nil$.MODULE$)))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)new .colon.colon((Object)new Tuple2((Object)"max.connections.per.ip", (Object)"6"), (List)Nil$.MODULE$)))}))), true);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)Nil$.MODULE$), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new ConfigEntry("log.roll.ms", "1234567"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultBroker), (Object)new .colon.colon((Object)new Tuple2((Object)"log.roll.ms", (Object)"1234567"), (List)Nil$.MODULE$))}))), true);
                admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 2, (short)3), new NewTopic("bar", 2, (short)3)})).all().get();
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cluster.brokers().values()).asScala()).toSeq(), "foo", 2);
                TestUtils$.MODULE$.waitForAllPartitionsMetadata(((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cluster.brokers().values()).asScala()).toSeq(), "bar", 2);
                Assertions.assertEquals((Object)new .colon.colon((Object)ApiError.NONE, (List)new .colon.colon((Object)new ApiError(Errors.INVALID_CONFIG, "Unknown topic config name: not.a.real.topic.config"), (List)new .colon.colon((Object)new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, "The topic 'baz' does not exist."), (List)Nil$.MODULE$))), this.legacyAlter(admin, (scala.collection.immutable.Map<ConfigResource, Seq<ConfigEntry>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "345"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "bar")), (Object)new .colon.colon((Object)new ConfigEntry("not.a.real.topic.config", "789"), (List)Nil$.MODULE$)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "baz")), (Object)new .colon.colon((Object)new ConfigEntry("segment.jitter.ms", "678"), (List)Nil$.MODULE$))})))));
                this.validateConfigs(admin, (scala.collection.immutable.Map<ConfigResource, Seq<Tuple2<String, String>>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new ConfigResource(ConfigResource.Type.TOPIC, "foo")), (Object)new .colon.colon((Object)new Tuple2((Object)"segment.jitter.ms", (Object)"345"), (List)Nil$.MODULE$))}))), this.validateConfigs$default$3());
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"3.7-IV0", "3.7-IV2"})
    public void testCreatePartitions(String metadataVersionString) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setBootstrapMetadataVersion(MetadataVersion.fromVersionString((String)metadataVersionString)).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.Map createResults = admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 1, (short)3), new NewTopic("bar", 2, (short)3)})).values();
                ((KafkaFuture)createResults.get("foo")).get();
                ((KafkaFuture)createResults.get("bar")).get();
                java.util.Map increaseResults = admin.createPartitions((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"foo"), (Object)NewPartitions.increaseTo((int)3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bar"), (Object)NewPartitions.increaseTo((int)2))}))).asJava()).values();
                ((KafkaFuture)increaseResults.get("foo")).get();
                Assertions.assertEquals(InvalidPartitionsException.class, Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)increaseResults.get("bar")).get()).getCause().getClass());
            }
        }
    }

    private ClusterImage clusterImage(KafkaClusterTestKit cluster, int brokerId) {
        return cluster.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)).metadataCache().currentImage().cluster();
    }

    private boolean brokerIsUnfenced(ClusterImage image, int brokerId) {
        Option option = Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId)));
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        if (option instanceof Some) {
            return !((BrokerRegistration)((Some)option).value()).fenced();
        }
        throw new MatchError((Object)option);
    }

    private boolean brokerIsAbsent(ClusterImage image, int brokerId) {
        return Option$.MODULE$.apply(image.brokers().get(BoxesRunTime.boxToInteger((int)brokerId))).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUnregisterBroker() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!this.brokerIsUnfenced(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testUnregisterBroker$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ((KafkaBroker)cluster.brokers().get(BoxesRunTime.boxToInteger((int)0))).shutdown();
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUnregisterBroker$3(this, cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testUnregisterBroker$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.unregisterBroker(0);
            }
            long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime3 = System.currentTimeMillis();
            while (!this.brokerIsAbsent(this.clusterImage(cluster, 1), 0)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testUnregisterBroker$6());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    public Admin createAdminClient(KafkaClusterTestKit cluster) {
        Properties props = cluster.clientProperties();
        props.put("client.id", this.getClass().getName());
        return Admin.create((Properties)props);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeQuorumRequestToBrokers() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long waitUntilTrue_startTime = System.currentTimeMillis();
                while (!KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$2(cluster, i)) {
                    void waitUntilTrue_pause;
                    void waitUntilTrue_waitTimeMs;
                    if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                        Assertions.fail((String)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$3());
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
                }
            });
            try (Admin admin = this.createAdminClient(cluster);){
                void var7_15;
                Tuple2 tuple2;
                void var5_9;
                Tuple2 tuple22;
                QuorumInfo quorumInfo = (QuorumInfo)admin.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get();
                Assertions.assertEquals((Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(cluster.controllers()).asScala()).keySet(), (Object)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(quorumInfo.voters()).asScala()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.replicaId()), Buffer$.MODULE$.canBuildFrom())).toSet());
                Assertions.assertTrue((boolean)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(cluster.controllers()).asScala()).keySet().contains((Object)Predef$.MODULE$.int2Integer(quorumInfo.leaderId())), (String)new StringBuilder(35).append("Leader ID ").append(quorumInfo.leaderId()).append(" was not a controller ID.").toString());
                long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
                long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long computeUntilTrue_startTime = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    void computeUntilTrue_waitTime;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$5(admin))) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                        tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) {
                    throw new MatchError(null);
                }
                java.util.List voters = (java.util.List)tuple23._1();
                Assertions.assertTrue((boolean)tuple23._2$mcZ$sp(), (String)new StringBuilder(111).append("At least one voter did not return the expected state within timeout.").append("The responses gathered for all the voters: ").append(var5_9.toString()).toString());
                long l3 = TestUtils$.MODULE$.computeUntilTrue$default$3();
                long l4 = TestUtils$.MODULE$.computeUntilTrue$default$2();
                if (TestUtils$.MODULE$ == null) {
                    throw null;
                }
                long computeUntilTrue_startTime2 = System.currentTimeMillis();
                while (true) {
                    void computeUntilTrue_pause;
                    void computeUntilTrue_waitTime;
                    java.util.List computeUntilTrue_result;
                    if (KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster, computeUntilTrue_result = KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$8(admin))) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                        break;
                    }
                    if (System.currentTimeMillis() > computeUntilTrue_startTime2 + computeUntilTrue_waitTime) {
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                        break;
                    }
                    Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
                }
                Tuple2 tuple24 = tuple2;
                if (tuple24 == null) {
                    throw new MatchError(null);
                }
                java.util.List observers = (java.util.List)tuple24._1();
                Assertions.assertTrue((boolean)tuple24._2$mcZ$sp(), (String)new StringBuilder(117).append("At least one observer did not return the expected state within timeout.").append("The responses gathered for all the observers: ").append(var7_15.toString()).toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUpdateMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(4).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.updateFeatures((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metadata.version"), (Object)new FeatureUpdate(MetadataVersion.latestTesting().featureLevel(), FeatureUpdate.UpgradeType.UPGRADE))}))).asJava(), new UpdateFeaturesOptions());
                Assertions.assertEquals((Object)new SupportedVersionRange(0, 1), ((FeatureMetadata)admin.describeFeatures().featureMetadata().get()).supportedFeatures().get("kraft.version"));
            }
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testUpdateMetadataVersion$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testUpdateMetadataVersion$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testDescribeKRaftVersion(boolean usingBootstrapControlers) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).setFeature("kraft.version", (short)1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(usingBootstrapControlers).build());){
                FeatureMetadata featureMetadata = (FeatureMetadata)admin.describeFeatures().featureMetadata().get();
                Assertions.assertEquals((Object)new SupportedVersionRange(0, 1), featureMetadata.supportedFeatures().get("kraft.version"));
                Assertions.assertEquals((Object)new FinalizedVersionRange((short)1, (short)1), featureMetadata.finalizedFeatures().get("kraft.version"));
            }
        }
    }

    @Test
    public void testRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.brokers().forEach((x$16, server) -> {
                Option option = server.remoteLogManagerOpt();
                if (option instanceof Some) {
                    return;
                }
                if (None$.MODULE$.equals(option)) {
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"RemoteLogManager should be initialized");
                    return;
                }
                throw new MatchError((Object)option);
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).setConfigProp("remote.log.storage.system.enable", Boolean.toString(true)).setConfigProp("remote.log.metadata.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteLogMetadataManager").setConfigProp("remote.log.storage.manager.class.name", "org.apache.kafka.server.log.remote.storage.NoOpRemoteStorageManager").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                java.util.List<NewTopic> newTopic = Collections.singletonList(new NewTopic("test-topic", 1, (short)1));
                admin.createTopics(newTopic).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                admin.deleteTopics(Collections.singletonList("test-topic")).all().get();
                this.waitForTopicListing(admin, (Seq<String>)Nil$.MODULE$, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSnapshotCount() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(0).setNumControllerNodes(1).build()).setConfigProp("metadata.log.max.snapshot.interval.ms", "500").setConfigProp("metadata.max.idle.interval.ms", "50").build();){
            cluster.format();
            cluster.startup();
            Path metaLog = FileSystems.getDefault().getPath(cluster.controllers().get(BoxesRunTime.boxToInteger((int)3000)).config().metadataLogDir(), "__cluster_metadata-0");
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$2(metaLog)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testSnapshotCount$3());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            Thread.sleep(5000L);
            long countAfterTenIntervals = KRaftClusterTest.snapshotCounter$1(metaLog);
            Assertions.assertTrue((countAfterTenIntervals > 1L ? 1 : 0) != 0, (String)new StringBuilder(48).append("Expected to see at least one more snapshot, saw ").append(countAfterTenIntervals).toString());
            Assertions.assertTrue((countAfterTenIntervals < 20L ? 1 : 0) != 0, (String)new StringBuilder(83).append("Did not expect to see more than twice as many snapshots as snapshot intervals, saw ").append(countAfterTenIntervals).toString());
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testSnapshotCount$4(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testSnapshotCount$5());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
    }

    @Test
    public void testAuthorizerFailureFoundInControllerStartup() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumControllerNodes(3).build()).setConfigProp("authorizer.class.name", BadAuthorizer.class.getName()).build();){
            cluster.format();
            ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> cluster.startup());
            Assertions.assertEquals((Object)"java.lang.IllegalStateException: test authorizer exception", (Object)exception.getMessage());
            cluster.fatalFaultHandler().setIgnore(true);
        }
    }

    @Test
    public void testSingleControllerSingleBrokerCluster() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.MINIMUM_BOOTSTRAP_VERSION).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerClientQuotas(boolean combinedController) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedController).setNumControllerNodes(1).build()).setConfigProp("client.quota.callback.class", DummyClientQuotaCallback.class.getName()).setConfigProp(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "0").build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertConfigValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(DummyClientQuotaCallback$.MODULE$.dummyClientQuotaCallbackValueConfigKey(), "1"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertConfigValue$1(1, cluster);
        }
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testReconfigureControllerAuthorizer(boolean combinedMode) {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setCombined(combinedMode).setNumControllerNodes(1).build()).setConfigProp("authorizer.class.name", FakeConfigurableAuthorizer.class.getName()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            KRaftClusterTest.assertFoobarValue$1(0, cluster);
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.incrementalAlterConfigs(Collections.singletonMap(new ConfigResource(ConfigResource.Type.BROKER, ""), Collections.singletonList(new AlterConfigOp(new ConfigEntry(FakeConfigurableAuthorizer$.MODULE$.foobarConfigKey(), "123"), AlterConfigOp.OpType.SET)))).all().get();
            }
            KRaftClusterTest.assertFoobarValue$1(123, cluster);
        }
    }

    @Test
    public void testOverlyLargeCreateTopics() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                ArrayList newTopics = new ArrayList();
                RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 10000).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> newTopics.add(new NewTopic(new StringBuilder(3).append("foo").append(i).toString(), 100000, (short)1)));
                ExecutionException executionException = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.createTopics((Collection)newTopics).all().get());
                Assertions.assertNotNull((Object)executionException.getCause());
                Assertions.assertEquals(PolicyViolationException.class, executionException.getCause().getClass());
                Assertions.assertEquals((Object)"Excessively large number of partitions per request.", (Object)executionException.getCause().getMessage());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTimedOutHeartbeats() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(3).setNumControllerNodes(1).build()).setConfigProp("broker.heartbeat.interval.ms", Integer.toString(10)).setConfigProp("broker.session.timeout.ms", Integer.toString(1000)).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            controller.controller().waitForReadyBrokers(3).get();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testTimedOutHeartbeats$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRegisteredControllerEndpoints() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(3).build()).build();){
            cluster.format();
            cluster.startup();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testRegisteredControllerEndpoints$1(cluster);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testDirectToControllerCommunicationFailsOnOlderMetadataVersion() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.newClientPropertiesBuilder().setUsingBootstrapControllers(true).build());){
                ExecutionException exception = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> admin.describeCluster().clusterId().get(1L, TimeUnit.MINUTES));
                Assertions.assertNotNull((Object)exception.getCause());
                Assertions.assertEquals(UnsupportedVersionException.class, exception.getCause().getClass());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testStartupWithNonDefaultKControllerDynamicConfiguration() {
        java.util.List<Object> bootstrapRecords = Arrays.asList((Object[])new ApiMessageAndVersion[]{new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(MetadataVersion.IBP_3_7_IV0.featureLevel()), (short)0), new ApiMessageAndVersion((ApiMessage)new ConfigRecord().setResourceType(ConfigResource.Type.BROKER.id()).setResourceName("").setName("num.io.threads").setValue("9"), (short)0)});
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadata(BootstrapMetadata.fromRecords(bootstrapRecords, (String)"testRecords")).setNumBrokerNodes(1).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            ControllerServer controller = cluster.controllers().values().iterator().next();
            TestUtils$ testUtils$ = TestUtils$.MODULE$;
            long l = 60000L;
            if (testUtils$ == null) {
                throw null;
            }
            TestUtils$ retry_this = testUtils$;
            LongRef retry_wait = LongRef.create((long)1L);
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KRaftClusterTest.$anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(controller);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                    }
                    Thread.sleep(retry_wait.elem);
                    retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicDeletedAndRecreatedWhileBrokerIsDown() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_6_IV2).setNumBrokerNodes(3).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 3, (short)3)})).all().get();
                TestUtils$ testUtils$ = TestUtils$.MODULE$;
                long l = 60000L;
                if (testUtils$ == null) {
                    throw null;
                }
                TestUtils$ retry_this = testUtils$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                broker0.shutdown();
                TestUtils$ testUtils$2 = TestUtils$.MODULE$;
                long l2 = 60000L;
                if (testUtils$2 == null) {
                    throw null;
                }
                TestUtils$ retry_this2 = testUtils$2;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                File logDir = ((UnifiedLog)qual$2.getLog(foo0, x$4).get()).dir();
                Files.write(new File(logDir, "partition.metadata").toPath(), "version: 0\ntopic_id: AAAAAAAAAAAAA7SrBWaJ7g\n".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                broker0.startup();
                TestUtils$ testUtils$3 = TestUtils$.MODULE$;
                long l3 = 60000L;
                if (testUtils$3 == null) {
                    throw null;
                }
                TestUtils$ retry_this3 = testUtils$3;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setNumBrokerNodes(3).setNumDisksPerBroker(2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 3, (short)3)})).all().get();
                TestUtils$ testUtils$ = TestUtils$.MODULE$;
                long l = 60000L;
                if (testUtils$ == null) {
                    throw null;
                }
                TestUtils$ retry_this = testUtils$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                broker0.shutdown();
                TestUtils$ testUtils$2 = TestUtils$.MODULE$;
                long l2 = 60000L;
                if (testUtils$2 == null) {
                    throw null;
                }
                TestUtils$ retry_this2 = testUtils$2;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                ((UnifiedLog)qual$2.getLog(foo0, x$4).get()).renameDir(UnifiedLog$.MODULE$.logFutureDirName(foo0), false);
                broker0.startup();
                TestUtils$ testUtils$3 = TestUtils$.MODULE$;
                long l3 = 60000L;
                if (testUtils$3 == null) {
                    throw null;
                }
                TestUtils$ retry_this3 = testUtils$3;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(broker1, broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setBootstrapMetadataVersion(MetadataVersion.IBP_3_7_IV2).setNumBrokerNodes(3).setNumDisksPerBroker(2).setNumControllerNodes(1).build()).build();){
            cluster.format();
            cluster.startup();
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                BrokerServer broker0 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)0));
                BrokerServer broker1 = cluster.brokers().get(BoxesRunTime.boxToInteger((int)1));
                TopicPartition foo0 = new TopicPartition("foo", 0);
                admin.createTopics(Arrays.asList((Object[])new NewTopic[]{new NewTopic("foo", 3, (short)3)})).all().get();
                TestUtils$ testUtils$ = TestUtils$.MODULE$;
                long l = 60000L;
                if (testUtils$ == null) {
                    throw null;
                }
                TestUtils$ retry_this = testUtils$;
                LongRef retry_wait = LongRef.create((long)1L);
                long retry_startTime = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(broker0, foo0);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this.logger().underlying().isInfoEnabled()) {
                            retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                        }
                        Thread.sleep(retry_wait.elem);
                        retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                        continue;
                    }
                    break;
                }
                broker0.shutdown();
                TestUtils$ testUtils$2 = TestUtils$.MODULE$;
                long l2 = 60000L;
                if (testUtils$2 == null) {
                    throw null;
                }
                TestUtils$ retry_this2 = testUtils$2;
                LongRef retry_wait2 = LongRef.create((long)1L);
                long retry_startTime2 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(broker1);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime2 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this2.logger().underlying().isInfoEnabled()) {
                            retry_this2.logger().underlying().info(retry_this2.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait2)));
                        }
                        Thread.sleep(retry_wait2.elem);
                        retry_wait2.elem += package$.MODULE$.min(retry_wait2.elem, 1000L);
                        continue;
                    }
                    break;
                }
                LogManager qual$2 = broker0.logManager();
                boolean x$4 = qual$2.getLog$default$2();
                UnifiedLog log = (UnifiedLog)qual$2.getLog(foo0, x$4).get();
                String parentDir = log.parentDir();
                String targetParentDir = (String)((IterableLike)broker0.config().logDirs().filter((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$3(parentDir, x$18)))).head();
                File targetDirFile = new File(targetParentDir, log.dir().getName());
                FileUtils.copyDirectory((File)log.dir(), (File)targetDirFile);
                Assertions.assertTrue((boolean)targetDirFile.exists());
                File originalLogFile = log.dir();
                log.renameDir(UnifiedLog$.MODULE$.logFutureDirName(foo0), false);
                Assertions.assertFalse((boolean)originalLogFile.exists());
                broker0.startup();
                TestUtils$ testUtils$3 = TestUtils$.MODULE$;
                long l3 = 60000L;
                if (testUtils$3 == null) {
                    throw null;
                }
                TestUtils$ retry_this3 = testUtils$3;
                LongRef retry_wait3 = LongRef.create((long)1L);
                long retry_startTime3 = System.currentTimeMillis();
                while (true) {
                    try {
                        KRaftClusterTest.$anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(broker1, broker0, foo0, targetDirFile, originalLogFile);
                    }
                    catch (AssertionError retry_e) {
                        void retry_maxWaitMs;
                        if (System.currentTimeMillis() - retry_startTime3 > retry_maxWaitMs) {
                            throw retry_e;
                        }
                        if (retry_this3.logger().underlying().isInfoEnabled()) {
                            retry_this3.logger().underlying().info(retry_this3.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait3)));
                        }
                        Thread.sleep(retry_wait3.elem);
                        retry_wait3.elem += package$.MODULE$.min(retry_wait3.elem, 1000L);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testControllerFailover() {
        try (KafkaClusterTestKit cluster = new KafkaClusterTestKit.Builder(new TestKitNodes.Builder().setNumBrokerNodes(1).setNumControllerNodes(5).build()).build();){
            cluster.format();
            cluster.startup();
            cluster.waitForReadyBrokers();
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testControllerFailover$1(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testControllerFailover$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!KRaftClusterTest.$anonfun$testControllerFailover$3(cluster)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)KRaftClusterTest.$anonfun$testControllerFailover$4());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            try (Admin admin = Admin.create((Properties)cluster.clientProperties());){
                admin.createTopics(Collections.singletonList(new NewTopic("test-topic", 1, (short)1))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
                Controller active = cluster.waitForActiveController();
                cluster.raftManagers().get(BoxesRunTime.boxToInteger((int)((QuorumController)active).nodeId())).shutdown();
                admin.createTopics(Collections.singletonList(new NewTopic("test-topic2", 1, (short)1))).all().get();
                this.waitForTopicListing(admin, (Seq<String>)new .colon.colon((Object)"test-topic2", (List)Nil$.MODULE$), (Seq<String>)Nil$.MODULE$);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$1(ControllerServer x$1) {
        return x$1.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$3(ControllerServer x$2) {
        return x$2.controller().isActive();
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndRestartControllerNode$2(KafkaClusterTestKit cluster$1) {
        return ((Iterator)CollectionConverters$.MODULE$.asScalaIteratorConverter(cluster$1.controllers().values().iterator()).asScala()).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testCreateClusterAndRestartControllerNode$3(x$2)));
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndRestartControllerNode$4() {
        return "Timeout waiting for new controller election";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$1(KafkaClusterTestKit cluster$2) {
        BrokerState brokerState = cluster$2.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndWaitForBrokerInRunningState$3(KafkaClusterTestKit cluster$2) {
        return cluster$2.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndWaitForBrokerInRunningState$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$1(KafkaClusterTestKit cluster$3) {
        BrokerState brokerState = cluster$3.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateListDeleteTopic$3(KafkaClusterTestKit cluster$3) {
        return cluster$3.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateListDeleteTopic$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$1(KafkaClusterTestKit cluster$4) {
        BrokerState brokerState = cluster$4.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateAndManyTopics$3(KafkaClusterTestKit cluster$4) {
        return cluster$4.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateAndManyTopics$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$1(KafkaClusterTestKit cluster$5) {
        BrokerState brokerState = cluster$5.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    private static final java.util.Map describeOrFail$1(ClientQuotaFilter filter, Admin admin$1) {
        try {
            return (java.util.Map)admin$1.describeClientQuotas(filter).entities().get();
        }
        catch (Throwable t) {
            return (java.util.Map)Assertions.fail((String)"DescribeClientQuotas request failed", (Throwable)t);
        }
    }

    public static final /* synthetic */ boolean $anonfun$testClientQuotas$4(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return results.getOrDefault(entity$1, Collections.emptyMap()).size() == expectCount$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final java.util.Map alterThenDescribe$1(ClientQuotaEntity entity, Seq quotas, ClientQuotaFilter filter, int expectCount, Admin admin$1) {
        void var7_11;
        Tuple2 tuple2;
        try {
            admin$1.alterClientQuotas((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ClientQuotaAlteration(entity, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(quotas).asJava()), (List)Nil$.MODULE$)).asJava()).all().get();
        }
        catch (Throwable t) {
            Assertions.fail((String)"AlterClientQuotas request failed", (Throwable)t);
        }
        long l = TestUtils$.MODULE$.computeUntilTrue$default$3();
        long l2 = TestUtils$.MODULE$.computeUntilTrue$default$2();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            void computeUntilTrue_pause;
            void computeUntilTrue_waitTime;
            java.util.Map computeUntilTrue_result;
            if (KRaftClusterTest.$anonfun$testClientQuotas$4(entity, expectCount, computeUntilTrue_result = KRaftClusterTest.describeOrFail$1(filter, admin$1))) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)true));
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + computeUntilTrue_waitTime) {
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)computeUntilTrue_result), (Object)BoxesRunTime.boxToBoolean((boolean)false));
                break;
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)computeUntilTrue_waitTime), (long)computeUntilTrue_pause));
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        java.util.Map describeResult = (java.util.Map)tuple22._1();
        Assertions.assertTrue((boolean)tuple22._2$mcZ$sp(), (String)"Broker never saw new client quotas");
        return var7_11;
    }

    public static final /* synthetic */ long $anonfun$getConsumerByteRates$2(HashMap results$1, ClientQuotaEntity entity$3, Double value) {
        return BoxesRunTime.unboxToLong((Object)results$1.put(entity$3, BoxesRunTime.boxToLong((long)value.longValue())));
    }

    public static final /* synthetic */ boolean $anonfun$testDefaultClientQuotas$1(KafkaClusterTestKit cluster$6) {
        BrokerState brokerState = cluster$6.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDefaultClientQuotas$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$3(KRaftClusterTest $this, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$4(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testDefaultClientQuotas$5(KRaftClusterTest $this, ClientQuotaEntity defaultUser$1, ClientQuotaEntity bobUser$1, Admin admin$2) {
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)defaultUser$1), (Object)BoxesRunTime.boxToLong((long)100L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)bobUser$1), (Object)BoxesRunTime.boxToLong((long)1000L))})), $this.getConsumerByteRates(admin$2));
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$1(java.util.Map brokerPropertyOverrides$1, int brokerId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "EXTERNAL://localhost:0");
        props.put("advertised.listeners", "EXTERNAL://localhost:0");
        brokerPropertyOverrides$1.put(Predef$.MODULE$.int2Integer(brokerId), props);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedPortZero$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)"localhost", (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)cluster.brokers().get(BoxesRunTime.boxToInteger((int)broker.id())).socketServer().boundPort(cluster.nodes().externalListenerName()), (int)broker.port(), (String)"Did not advertise bound socket port");
        });
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$1(java.util.Map brokerPropertyOverrides$2, int brokerId) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("listeners", "EXTERNAL://localhost:0");
        props.put("advertised.listeners", new StringBuilder(28).append("EXTERNAL://advertised-host-").append(brokerId).append(":").append(brokerId + 100).toString());
        brokerPropertyOverrides$2.put(Predef$.MODULE$.int2Integer(brokerId), props);
    }

    public static final /* synthetic */ void $anonfun$testCreateClusterWithAdvertisedHostAndPortDifferentFromSocketServer$2(KRaftClusterTest $this, KafkaClusterTestKit cluster) {
        $this.sendDescribeClusterRequestToBoundPortUntilAllBrokersPropagated(cluster.nodes().externalListenerName(), scala.concurrent.duration.package$.MODULE$.pairLongToDuration(new Tuple2((Object)BoxesRunTime.boxToLong((long)15L), (Object)TimeUnit.SECONDS)), cluster).nodes().values().forEach(broker -> {
            Assertions.assertEquals((Object)new StringBuilder(16).append("advertised-host-").append(broker.id()).toString(), (Object)broker.host(), (String)"Did not advertise configured advertised host");
            Assertions.assertEquals((int)(broker.id() + 100), (int)broker.port(), (String)"Did not advertise configured advertised port");
        });
    }

    public static final /* synthetic */ boolean $anonfun$waitForRunningBrokers$1(BrokerServer brokerServer) {
        BrokerState brokerState = brokerServer.brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    private static final Seq getRunningBrokerServers$1(KafkaClusterTestKit cluster$8) {
        return (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(cluster$8.brokers().values()).asScala()).toSeq().filter((Function1 & Serializable & scala.Serializable)brokerServer -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$waitForRunningBrokers$1(brokerServer)));
    }

    public static final /* synthetic */ boolean $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return response.nodes().size() == expectedBrokerCount$1;
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$1(Admin admin$3) {
        return ((java.util.Map)admin$3.listPartitionReassignments().reassignments().get()).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$2() {
        return "The reassignment never completed.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndPerformReassignment$3(KRaftClusterTest $this, Admin admin$3, ObjectRef currentMapping$1, Seq expectedMapping$1) {
        java.util.Map topicInfoMap = (java.util.Map)admin$3.describeTopics(Collections.singleton("foo")).allTopicNames().get();
        if (topicInfoMap.containsKey("foo")) {
            currentMapping$1.elem = $this.translatePartitionInfoToSeq(((TopicDescription)topicInfoMap.get("foo")).partitions());
            return expectedMapping$1.equals((Object)((Seq)currentMapping$1.elem));
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndPerformReassignment$4(Seq expectedMapping$1, ObjectRef currentMapping$1) {
        return new StringBuilder(72).append("Timed out waiting for replica assignments for topic foo. ").append("Wanted: ").append(expectedMapping$1).append(". Got: ").append((Seq)currentMapping$1.elem).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$1(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$checkReplicaManager$3(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$4(BrokerServer broker$1, Tuple2 x$7) {
        if (x$7 != null) {
            boolean isHosted = x$7._1$mcZ$sp();
            int partitionId = x$7._2$mcI$sp();
            TopicPartition topicPartition = new TopicPartition("foo", partitionId);
            if (isHosted) {
                Assertions.assertNotEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
                return;
            }
            Assertions.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker$1.replicaManager().getPartition(topicPartition), (String)new StringBuilder(17).append("topicPartition = ").append(topicPartition).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$checkReplicaManager$2(KafkaClusterTestKit cluster$10, Tuple2 x$8) {
        if (x$8 != null) {
            int brokerId = x$8._1$mcI$sp();
            List partitionsIsHosted = (List)x$8._2();
            BrokerServer broker = cluster$10.brokers().get(BoxesRunTime.boxToInteger((int)brokerId));
            ((TraversableLike)partitionsIsHosted.zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$checkReplicaManager$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                KRaftClusterTest.$anonfun$checkReplicaManager$4(broker, x$7);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$waitForTopicListing$2(Admin admin$4, HashSet topicsNotFound$1, ObjectRef extraTopics$1, Seq expectedAbsent$1) {
        ((Iterable)admin$4.listTopics().names().get()).forEach(name -> topicsNotFound$1.remove(name));
        extraTopics$1.elem = (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)admin$4.listTopics().names().get()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)expectedAbsent$1.contains((Object)x$10)));
        return topicsNotFound$1.isEmpty() && ((scala.collection.mutable.Set)extraTopics$1.elem).isEmpty();
    }

    public static final /* synthetic */ String $anonfun$waitForTopicListing$5(HashSet topicsNotFound$1, ObjectRef extraTopics$1) {
        return new StringBuilder(49).append("Failed to find topic(s): ").append(CollectionConverters$.MODULE$.asScalaSetConverter((java.util.Set)topicsNotFound$1).asScala()).append(" and NOT find topic(s): ").append((scala.collection.mutable.Set)extraTopics$1.elem).toString();
    }

    public static final /* synthetic */ void $anonfun$validateConfigs$1(KRaftClusterTest $this, Admin admin$5, scala.collection.immutable.Map expected$1, scala.collection.mutable.HashMap results$2, boolean exhaustive$1) {
        try {
            java.util.Map values = admin$5.describeConfigs((Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)expected$1.keySet()).asJava()).values();
            results$2.clear();
            Assertions.assertEquals((Object)expected$1.keySet(), (Object)CollectionConverters$.MODULE$.asScalaSetConverter(values.keySet()).asScala());
            expected$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    ConfigResource resource = (ConfigResource)x0$1._1();
                    Seq pairs = (Seq)x0$1._2();
                    Config config = (Config)((KafkaFuture)values.get(resource)).get();
                    TreeMap actual = new TreeMap();
                    TreeMap expected = new TreeMap();
                    config.entries().forEach(entry -> {
                        actual.put(entry.name(), entry.value());
                        if (!exhaustive$1) {
                            expected.put(entry.name(), entry.value());
                            return;
                        }
                    });
                    pairs.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        if (x0$2 != null) {
                            String k = (String)x0$2._1();
                            String v = (String)x0$2._2();
                            return expected.put(k, v);
                        }
                        throw new MatchError(null);
                    });
                    Assertions.assertEquals(expected, actual);
                    return results$2.put((Object)resource, actual);
                }
                throw new MatchError(null);
            });
            return;
        }
        catch (Throwable t) {
            $this.log().warn(new StringBuilder(27).append("Unable to describeConfigs(").append(CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)expected$1.keySet()).asJava()).append(")").toString(), t);
            throw t;
        }
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$2() {
        return "Timed out waiting for broker 0 to be unfenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testUnregisterBroker$3(KRaftClusterTest $this, KafkaClusterTestKit cluster$11) {
        return !$this.brokerIsUnfenced($this.clusterImage(cluster$11, 1), 0);
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$4() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ String $anonfun$testUnregisterBroker$6() {
        return "Timed out waiting for broker 0 to be fenced.";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$2(KafkaClusterTestKit cluster$12, int i$1) {
        BrokerState brokerState = cluster$12.brokers().get(BoxesRunTime.boxToInteger((int)i$1)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testDescribeQuorumRequestToBrokers$3() {
        return "Broker Never started up";
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$5(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).voters();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$6(java.util.List voters) {
        return voters.stream().allMatch(voter -> {
            if (voter.logEndOffset() > 0L) {
                OptionalLong optionalLong = voter.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = voter.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ java.util.List $anonfun$testDescribeQuorumRequestToBrokers$8(Admin admin$6) {
        return ((QuorumInfo)admin$6.describeMetadataQuorum(new DescribeMetadataQuorumOptions()).quorumInfo().get()).observers();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeQuorumRequestToBrokers$9(KafkaClusterTestKit cluster$12, java.util.List observers) {
        Set set = ((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(cluster$12.brokers()).asScala()).keySet();
        scala.collection.immutable.Set set2 = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(observers).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.replicaId()), Buffer$.MODULE$.canBuildFrom())).toSet();
        return !(set != null ? !set.equals(set2) : set2 != null) && observers.stream().allMatch(observer -> {
            if (observer.logEndOffset() > 0L) {
                OptionalLong optionalLong = observer.lastFetchTimestamp();
                OptionalLong optionalLong2 = OptionalLong.empty();
                if (optionalLong == null ? optionalLong2 != null : !((Object)optionalLong).equals(optionalLong2)) {
                    OptionalLong optionalLong3 = observer.lastCaughtUpTimestamp();
                    OptionalLong optionalLong4 = OptionalLong.empty();
                    if (optionalLong3 == null ? optionalLong4 != null : !((Object)optionalLong3).equals(optionalLong4)) {
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testUpdateMetadataVersion$1(KafkaClusterTestKit cluster$13) {
        return cluster$13.brokers().get(BoxesRunTime.boxToInteger((int)0)).metadataCache().currentImage().features().metadataVersion().equals((Object)MetadataVersion.latestTesting());
    }

    public static final /* synthetic */ String $anonfun$testUpdateMetadataVersion$2() {
        return "Timed out waiting for metadata.version update";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$1(KafkaClusterTestKit cluster$14) {
        BrokerState brokerState = cluster$14.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$3(KafkaClusterTestKit cluster$14) {
        return cluster$14.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testCreateClusterAndCreateTopicWithRemoteLogManagerInstantiation$4() {
        return "RaftManager was not initialized.";
    }

    private static final long snapshotCounter$1(Path path) {
        return path.toFile().listFiles((x$17, name) -> name.toLowerCase().endsWith("checkpoint")).length;
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$2(Path metaLog$1) {
        return KRaftClusterTest.snapshotCounter$1(metaLog$1) > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$3() {
        return "Failed to see at least one snapshot";
    }

    public static final /* synthetic */ boolean $anonfun$testSnapshotCount$4(KafkaClusterTestKit cluster$15) {
        return cluster$15.controllers().values().iterator().next().sharedServer().snapshotEmitter().metrics().latestSnapshotGeneratedBytes() > 0L;
    }

    public static final /* synthetic */ String $anonfun$testSnapshotCount$5() {
        return "Failed to see latestSnapshotGeneratedBytes > 0";
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerClientQuotas$1(int expected$3, KafkaClusterTestKit cluster$17) {
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$17.controllers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
        Assertions.assertEquals((int)expected$3, (int)((DummyClientQuotaCallback)cluster$17.brokers().values().iterator().next().quotaManagers().clientQuotaCallback().get()).value());
    }

    /*
     * WARNING - void declaration
     */
    private static final void assertConfigValue$1(int expected, KafkaClusterTestKit cluster$17) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerClientQuotas$1(expected, cluster$17);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testReconfigureControllerAuthorizer$1(int expected$4, KafkaClusterTestKit cluster$18) {
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$18.controllers().values().iterator().next().authorizer().get()).foobar().get());
        Assertions.assertEquals((int)expected$4, (int)((FakeConfigurableAuthorizer)cluster$18.brokers().values().iterator().next().authorizer().get()).foobar().get());
    }

    /*
     * WARNING - void declaration
     */
    private static final void assertFoobarValue$1(int expected, KafkaClusterTestKit cluster$18) {
        TestUtils$ testUtils$ = TestUtils$.MODULE$;
        long l = 60000L;
        if (testUtils$ == null) {
            throw null;
        }
        TestUtils$ retry_this = testUtils$;
        LongRef retry_wait = LongRef.create((long)1L);
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                KRaftClusterTest.$anonfun$testReconfigureControllerAuthorizer$1(expected, cluster$18);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    retry_this.logger().underlying().info(retry_this.msgWithLogIdent(TestUtils$.$anonfun$retry$1(retry_wait)));
                }
                Thread.sleep(retry_wait.elem);
                retry_wait.elem += package$.MODULE$.min(retry_wait.elem, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$testTimedOutHeartbeats$1(ControllerServer controller$1) {
        CountDownLatch latch = QuorumControllerIntegrationTestUtils.pause((QuorumController)((QuorumController)controller$1.controller()));
        Thread.sleep(1001L);
        latch.countDown();
        Assertions.assertEquals((int)0, (int)controller$1.sharedServer().controllerServerMetrics().fencedBrokerCount());
        Assertions.assertTrue((controller$1.quorumControllerMetrics().timedOutHeartbeats() > 0L ? 1 : 0) != 0, (String)"Expected timedOutHeartbeats to be greater than 0.");
    }

    public static final /* synthetic */ void $anonfun$testRegisteredControllerEndpoints$1(KafkaClusterTestKit cluster$19) {
        java.util.Map registeredControllers = cluster$19.controllers().values().iterator().next().registrationsPublisher().controllers();
        Assertions.assertEquals((int)3, (int)registeredControllers.size(), (String)"Expected 3 controller registrations");
        registeredControllers.values().forEach(registration -> {
            Assertions.assertNotNull(registration.listeners().get("CONTROLLER"));
            Assertions.assertNotEquals((int)0, (int)((Endpoint)registration.listeners().get("CONTROLLER")).port());
        });
    }

    public static final /* synthetic */ void $anonfun$testStartupWithNonDefaultKControllerDynamicConfiguration$1(ControllerServer controller$2) {
        Assertions.assertNotNull((Object)controller$2.controllerApisHandlerPool());
        Assertions.assertEquals((int)9, (int)controller$2.controllerApisHandlerPool().threadPoolSize().get());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$1(BrokerServer broker0$1, TopicPartition foo0$1) {
        LogManager qual$1 = broker0$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$1, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$2(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
    }

    public static final /* synthetic */ void $anonfun$testTopicDeletedAndRecreatedWhileBrokerIsDown$3(BrokerServer broker1$1) {
        Option info = broker1$1.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$1(BrokerServer broker0$2, TopicPartition foo0$2) {
        LogManager qual$1 = broker0$2.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$2, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$2(BrokerServer broker1$2) {
        Option info = broker1$2.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOfflineLogDir$3(BrokerServer broker1$2, BrokerServer broker0$2, TopicPartition foo0$2) {
        Option info = broker1$2.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
        Assertions.assertTrue((boolean)broker0$2.logManager().getLog(foo0$2, true).isEmpty());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$1(BrokerServer broker0$3, TopicPartition foo0$3) {
        LogManager qual$1 = broker0$3.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assertions.assertTrue((boolean)qual$1.getLog(foo0$3, x$2).isDefined());
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$2(BrokerServer broker1$3) {
        Option info = broker1$3.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
    }

    public static final /* synthetic */ boolean $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$3(String parentDir$1, String x$18) {
        String string = x$18;
        return string == null ? parentDir$1 != null : !string.equals(parentDir$1);
    }

    public static final /* synthetic */ void $anonfun$testAbandonedFutureReplicaRecovered_mainReplicaInOnlineLogDir$4(BrokerServer broker1$3, BrokerServer broker0$3, TopicPartition foo0$3, File targetDirFile$1, File originalLogFile$1) {
        Option info = broker1$3.metadataCache().getPartitionInfo("foo", 0);
        Assertions.assertTrue((boolean)info.isDefined());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(((UpdateMetadataRequestData.UpdateMetadataPartitionState)info.get()).isr()).asScala()).toSet());
        Assertions.assertTrue((boolean)broker0$3.logManager().getLog(foo0$3, true).isEmpty());
        Assertions.assertFalse((boolean)targetDirFile$1.exists());
        Assertions.assertTrue((boolean)originalLogFile$1.exists());
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailover$1(KafkaClusterTestKit cluster$20) {
        BrokerState brokerState = cluster$20.brokers().get(BoxesRunTime.boxToInteger((int)0)).brokerState();
        BrokerState brokerState2 = BrokerState.RUNNING;
        return !(brokerState != null ? !brokerState.equals(brokerState2) : brokerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$testControllerFailover$2() {
        return "Broker never made it to RUNNING state.";
    }

    public static final /* synthetic */ boolean $anonfun$testControllerFailover$3(KafkaClusterTestKit cluster$20) {
        return cluster$20.raftManagers().get(BoxesRunTime.boxToInteger((int)0)).client().leaderAndEpoch().leaderId().isPresent();
    }

    public static final /* synthetic */ String $anonfun$testControllerFailover$4() {
        return "RaftManager was not initialized.";
    }

    public static final /* synthetic */ Object $anonfun$waitForRunningBrokers$3$adapted(Seq x$4) {
        return BoxesRunTime.boxToBoolean((boolean)x$4.nonEmpty());
    }

    public static final /* synthetic */ Object $anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2$adapted(int expectedBrokerCount$1, DescribeClusterResponse response) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$sendDescribeClusterRequestToBoundPortUntilBrokersPropagated$2(expectedBrokerCount$1, response));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$6$adapted(java.util.List voters) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$6(voters));
    }

    public static final /* synthetic */ Object $anonfun$testDescribeQuorumRequestToBrokers$9$adapted(KafkaClusterTestKit cluster$12, java.util.List observers) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testDescribeQuorumRequestToBrokers$9(cluster$12, observers));
    }

    public static final /* synthetic */ Object $anonfun$testClientQuotas$4$adapted(ClientQuotaEntity entity$1, int expectCount$1, java.util.Map results) {
        return BoxesRunTime.boxToBoolean((boolean)KRaftClusterTest.$anonfun$testClientQuotas$4(entity$1, expectCount$1, results));
    }
}

