/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh\u0001B\n\u0015\u0001eAQA\b\u0001\u0005\u0002}Aq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001.\u0011\u0019I\u0004\u0001)A\u0005]!)!\b\u0001C!w!)\u0001\u000b\u0001C\u0001#\")a\u000f\u0001C\u0001o\")1\u0010\u0001C\u0001y\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002\u0002CA\u0019\u0001\u0001&I!a\r\t\u0011\u0005M\u0004\u0001)C\u0005\u0003kB\u0001\"a!\u0001A\u0013%\u0011Q\u0011\u0005\b\u0003'\u0003A\u0011AAK\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a+\u0001\t\u0013\ti\u000bC\u0004\u00022\u0001!I!a1\t\u000f\u0005E\u0007\u0001\"\u0001\u0002T\n1B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u0016-\u000511/\u001a:wKJT\u0011aF\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c95\tA#\u0003\u0002\u001e)\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002AA\u00111\u0004A\u0001\u0006i>\u0004\u0018nY\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0005Y\u0006twMC\u0001)\u0003\u0011Q\u0017M^1\n\u0005)*#AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\na\u0006\u0014H/\u001b;j_:,\u0012A\f\t\u0003_]j\u0011\u0001\r\u0006\u0003cI\naaY8n[>t'BA\f4\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\u0002$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013!D7pI&4\u0017pQ8oM&<7\u000f\u0006\u0002=\u0005B\u0011Q\bQ\u0007\u0002})\tq(A\u0003tG\u0006d\u0017-\u0003\u0002B}\t!QK\\5u\u0011\u0015\u0019e\u00011\u0001E\u0003\u0015\u0001(o\u001c9t!\r)\u0005JS\u0007\u0002\r*\u0011qIP\u0001\u000bG>dG.Z2uS>t\u0017BA%G\u0005\r\u0019V-\u001d\t\u0003\u0017:k\u0011\u0001\u0014\u0006\u0003\u001b\u001e\nA!\u001e;jY&\u0011q\n\u0014\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u0007;fgRd\u0015n\u001d;PM\u001a\u001cX\r^:FeJ|'oQ8eKN$\"\u0001\u0010*\t\u000bM;\u0001\u0019\u0001+\u0002\rE,xN];n!\t)FL\u0004\u0002W5B\u0011qKP\u0007\u00021*\u0011\u0011\fG\u0001\u0007yI|w\u000e\u001e \n\u0005ms\u0014A\u0002)sK\u0012,g-\u0003\u0002+;*\u00111L\u0010\u0015\u0005\u000f}[G\u000e\u0005\u0002aS6\t\u0011M\u0003\u0002cG\u0006A\u0001O]8wS\u0012,'O\u0003\u0002eK\u00061\u0001/\u0019:b[NT!AZ4\u0002\u000f),\b/\u001b;fe*\u0011\u0001.N\u0001\u0006UVt\u0017\u000e^\u0005\u0003U\u0006\u00141BV1mk\u0016\u001cv.\u001e:dK\u000691\u000f\u001e:j]\u001e\u001cHFA7pC\u0005q\u0017A\u0001>lC\u0005\u0001\u0018!B6sC\u001a$\bFA\u0004s!\t\u0019H/D\u0001d\u0013\t)8MA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f1\u0005^3ti2K7\u000f^(gMN,Go\u001d*fcV,7\u000f^(mI\u0016\u001cHOV3sg&|g\u000eF\u0001=Q\u0011Aql[=-\u00055|\u0007F\u0001\u0005s\u0003m\t7o]3siJ+7\u000f]8og\u0016,%O]8s\r>\u0014X\t]8dQR1A(`A\u0006\u0003+AQA`\u0005A\u0002}\fQ!\u001a:s_J\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b\u0001\u0014\u0001\u00039s_R|7m\u001c7\n\t\u0005%\u00111\u0001\u0002\u0007\u000bJ\u0014xN]:\t\u000f\u00055\u0011\u00021\u0001\u0002\u0010\u0005A!M]8lKJLE\rE\u0002>\u0003#I1!a\u0005?\u0005\rIe\u000e\u001e\u0005\b\u0003/I\u0001\u0019AA\r\u0003I\u0019WO\u001d:f]RdU-\u00193fe\u0016\u0003xn\u00195\u0011\u000b-\u000bY\"a\b\n\u0007\u0005uAJ\u0001\u0005PaRLwN\\1m!\r!\u0013\u0011E\u0005\u0004\u0003G)#aB%oi\u0016<WM]\u0001\u001bi\u0016\u001cHoQ;se\u0016tG/\u00129pG\"4\u0016\r\\5eCRLwN\u001c\u000b\u0004y\u0005%\u0002\"B*\u000b\u0001\u0004!\u0006&\u0002\u0006`W\u00065BFA7pQ\tQ!/A\u0006tK:$'+Z9vKN$H\u0003CA\u001b\u00037\ny&!\u001b\u0011\t\u0005]\u0012Q\u000b\b\u0005\u0003s\tyE\u0004\u0003\u0002<\u0005-c\u0002BA\u001f\u0003\u0013rA!a\u0010\u0002H9!\u0011\u0011IA#\u001d\r9\u00161I\u0005\u0002m%\u0011A'N\u0005\u0003/MJ!!\r\u001a\n\u0007\u00055\u0003'A\u0004nKN\u001c\u0018mZ3\n\t\u0005E\u00131K\u0001\u0018\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a#bi\u0006T1!!\u00141\u0013\u0011\t9&!\u0017\u000391K7\u000f^(gMN,Go\u001d)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!\u0011\u0011KA*\u0011\u001d\tif\u0003a\u0001\u0003\u001f\t\u0001b]3sm\u0016\u0014\u0018\n\u001a\u0005\b\u0003CZ\u0001\u0019AA2\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002>\u0003KJ1!a\u001a?\u0005\u0011auN\\4\t\u000f\u0005-4\u00021\u0001\u0002n\u00059a/\u001a:tS>t\u0007cA\u001f\u0002p%\u0019\u0011\u0011\u000f \u0003\u000bMCwN\u001d;\u0002'\u0019,Go\u00195PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0015\u0011\u0005]\u0014QPA@\u0003\u0003\u0003r!PA=\u0003G\ny!C\u0002\u0002|y\u0012a\u0001V;qY\u0016\u0014\u0004bBA/\u0019\u0001\u0007\u0011q\u0002\u0005\b\u0003Cb\u0001\u0019AA2\u0011\u001d\tY\u0007\u0004a\u0001\u0003[\nADZ3uG\"|eMZ:fi\u0006sG-\u00129pG\"<\u0016\u000e\u001e5FeJ|'\u000f\u0006\u0005\u0002\b\u00065\u0015qRAI!%i\u0014\u0011RA2\u0003\u001f\ti'C\u0002\u0002\fz\u0012a\u0001V;qY\u0016\u001c\u0004bBA/\u001b\u0001\u0007\u0011q\u0002\u0005\b\u0003Cj\u0001\u0019AA2\u0011\u001d\tY'\u0004a\u0001\u0003[\nq\u0004^3tiJ+7\u000f]8og\u0016Len\u00197vI\u0016\u001cH*Z1eKJ,\u0005o\\2i)\ra\u0014q\u0013\u0005\u0006':\u0001\r\u0001\u0016\u0015\u0006\u001d}[\u00171\u0014\u0017\u0003[>D#A\u0004:\u0002kQ,7\u000f\u001e*fgB|gn]3EK\u001a\fW\u000f\u001c;PM\u001a\u001cX\r^!oI2+\u0017\rZ3s\u000bB|7\r\u001b$pe\u0006cGNV3sg&|gn\u001d\u000b\u0004y\u0005\r\u0006\"B*\u0010\u0001\u0004!\u0006&B\b`W\u0006\u001dFFA7pQ\ty!/A\nbgN,'\u000f\u001e*fgB|gn]3FeJ|'\u000fF\u0004=\u0003_\u000b\t,a-\t\u000by\u0004\u0002\u0019A@\t\u000f\u00055\u0001\u00031\u0001\u0002\u0010!9\u0011Q\u0017\tA\u0002\u0005]\u0016a\u0002:fcV,7\u000f\u001e\t\u0005\u0003s\u000by,\u0004\u0002\u0002<*\u0019\u0011Q\u0018\u0019\u0002\u0011I,\u0017/^3tiNLA!!1\u0002<\n\u0011B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:u)\u0019\t)-a3\u0002PB!\u0011\u0011XAd\u0013\u0011\tI-a/\u0003'1K7\u000f^(gMN,Go\u001d*fgB|gn]3\t\u000f\u00055\u0017\u00031\u0001\u0002\u0010\u0005AA.Z1eKJLE\rC\u0004\u00026F\u0001\r!a.\u0002\u0017\r\u0014X-\u0019;f)>\u0004\u0018n\u0019\u000b\u0007\u0003+\fY.a8\u0011\u000fU\u000b9.a\u0004\u0002\u0010%\u0019\u0011\u0011\\/\u0003\u00075\u000b\u0007\u000fC\u0004\u0002^J\u0001\r!a\u0004\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\t\tO\u0005a\u0001\u0003\u001f\t\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0001")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Override
    public void modifyConfigs(Seq<Properties> props) {
        super.modifyConfigs(props);
        props.foreach((Function1 & Serializable & scala.Serializable)p -> p.put("unstable.api.versions.enable", "true"));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsErrorCodes(String quorum) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest consumerRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetsRequest replicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaBroker)this.brokers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetsRequest debugReplicaRequest = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(1, 2);
        Map topicDescription = (Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.partition().topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)topicDescription.get(this.partition().topic())).partitions().get(this.partition().partition())).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$3(x$3)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testListOffsetsRequestOldestVersion() {
        ListOffsetsRequest.Builder consumerRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED);
        ListOffsetsRequest.Builder requireTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)true, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED);
        ListOffsetsRequest.Builder requestCommittedRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_COMMITTED);
        ListOffsetsRequest.Builder maxTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)true, (boolean)false, (boolean)false);
        ListOffsetsRequest.Builder requireEarliestLocalTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)true, (boolean)false);
        ListOffsetsRequest.Builder requireTieredStorageTimestampRequestBuilder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false, (boolean)false, (boolean)true);
        Assertions.assertEquals((short)((short)0), (short)consumerRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)1), (short)requireTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)2), (short)requestCommittedRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)7), (short)maxTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)8), (short)requireEarliestLocalTimestampRequestBuilder.oldestAllowedVersion());
        Assertions.assertEquals((short)((short)9), (short)requireTieredStorageTimestampRequestBuilder.oldestAllowedVersion());
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetsRequestData.ListOffsetsPartition listOffsetPartition = new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(Predef$.MODULE$.Integer2int(currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCurrentEpochValidation(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), TestUtils$.MODULE$.awaitLeaderChange$default$4(), TestUtils$.MODULE$.awaitLeaderChange$default$5());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)));
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse sendRequest(int serverId, long timestamp, short version) {
        java.util.List targetTimes = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(this.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetsRequest.Builder builder = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes);
        ListOffsetsRequest request = version == -1 ? (ListOffsetsRequest)builder.build() : builder.build(version);
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((ListOffsetsResponseData.ListOffsetsTopicResponse)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(this.sendRequest(serverId, request).topics()).asScala()).find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$1(this, x$5))).get()).partitions()).asScala()).find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$sendRequest$2(this, x$6))).get();
    }

    /*
     * WARNING - void declaration
     */
    private Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        void var8_6;
        void var6_5;
        Tuple3<Object, Object, Object> tuple3 = this.fetchOffsetAndEpochWithError(serverId, timestamp, version);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        long offset = BoxesRunTime.unboxToLong((Object)tuple3._1());
        int leaderEpoch = BoxesRunTime.unboxToInt((Object)tuple3._2());
        return new Tuple2.mcJI.sp((long)var6_5, (int)var8_6);
    }

    private Tuple3<Object, Object, Object> fetchOffsetAndEpochWithError(int serverId, long timestamp, short version) {
        ListOffsetsResponseData.ListOffsetsPartitionResponse partitionData = this.sendRequest(serverId, timestamp, version);
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
            }
            return new Tuple3((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long((Long)((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionData.oldStyleOffsets()).asScala()).head())), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
        }
        return new Tuple3((Object)BoxesRunTime.boxToLong((long)partitionData.offset()), (Object)BoxesRunTime.boxToInteger((int)partitionData.leaderEpoch()), (Object)BoxesRunTime.boxToShort((short)partitionData.errorCode()));
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testResponseIncludesLeaderEpoch(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        int firstLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(firstLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, firstLeaderEpoch), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), this.partition(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), TestUtils$.MODULE$.awaitLeaderChange$default$4(), TestUtils$.MODULE$.awaitLeaderChange$default$5());
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$1(this, secondLeaderId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ListOffsetsRequestTest.$anonfun$testResponseIncludesLeaderEpoch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaBroker>)this.brokers());
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -4L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, firstLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)10L), (Object)BoxesRunTime.boxToInteger((int)secondLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -1L, (short)-1));
        Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)9L), (Object)BoxesRunTime.boxToInteger((int)firstLeaderEpoch), (Object)BoxesRunTime.boxToShort((short)Errors.NONE.code())), this.fetchOffsetAndEpochWithError(secondLeaderId, -3L, (short)-1));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions(String quorum) {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(1, 3).apply((Object)BoxesRunTime.boxToInteger((int)this.partition().partition())));
        TestUtils$.MODULE$.generateAndProduceMessages(this.brokers(), this.topic(), 9, TestUtils$.MODULE$.generateAndProduceMessages$default$4());
        TestUtils$.MODULE$.produceMessage(this.brokers(), this.topic(), "test-10", Predef$.MODULE$.long2Long(System.currentTimeMillis() + 10L), TestUtils$.MODULE$.produceMessage$default$5(), TestUtils$.MODULE$.produceMessage$default$6());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.LIST_OFFSETS.oldestVersion()), (int)ApiKeys.LIST_OFFSETS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            if (version == 0) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 1 && version <= 3) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 4 && version <= 6) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version == 7) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToShort((short)Errors.UNSUPPORTED_VERSION.code())), this.fetchOffsetAndEpochWithError(firstLeaderId, -4L, (short)version));
                return;
            }
            if (version >= 8) {
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(9L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -3L, (short)version));
                Assertions.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -4L, (short)version));
                return;
            }
        });
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetsRequest request) {
        ListOffsetsResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.topics().size(), (int)response.topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(response.topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetsResponse sendRequest(int leaderId, ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class));
    }

    public scala.collection.immutable.Map<Object, Object> createTopic(int numPartitions, int replicationFactor) {
        return super.createTopic(this.topic(), numPartitions, replicationFactor, super.createTopic$default$4(), super.createTopic$default$5(), super.createTopic$default$6());
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$1(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsTopicResponse x$5) {
        String string = x$5.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$sendRequest$2(ListOffsetsRequestTest $this, ListOffsetsResponseData.ListOffsetsPartitionResponse x$6) {
        return x$6.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ boolean $anonfun$testResponseIncludesLeaderEpoch$1(ListOffsetsRequestTest $this, int secondLeaderId$1) {
        return $this.sendRequest(secondLeaderId$1, -1L, (short)-1).errorCode() != Errors.OFFSET_NOT_AVAILABLE.code();
    }

    public static final /* synthetic */ String $anonfun$testResponseIncludesLeaderEpoch$2() {
        return "the second leader does not sync to follower";
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetsResponseData.ListOffsetsPartitionResponse partition) {
        Assertions.assertEquals((short)error$1.code(), (short)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetsResponseData.ListOffsetsTopicResponse topic) {
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

