/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0004\t\u00015AQA\u0005\u0001\u0005\u0002MAQ!\u0006\u0001\u0005\u0002YAQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0013\u0001\u0005\n-CQ!\u001d\u0001\u0005\nIDq!a\u0003\u0001\t\u0013\tiA\u0001\u0011PM\u001a\u001cX\r^:G_JdU-\u00193fe\u0016\u0003xn\u00195SKF,Xm\u001d;UKN$(BA\u0005\u000b\u0003\u0019\u0019XM\u001d<fe*\t1\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0011\u001b\u0005A\u0011BA\t\t\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0015!\ty\u0001!A\u0012uKN$xJ\u001a4tKR\u001chi\u001c:MK\u0006$WM]#q_\u000eDWI\u001d:pe\u000e{G-Z:\u0015\u0005]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"\u0001B+oSRDQA\b\u0002A\u0002}\ta!];peVl\u0007C\u0001\u0011(\u001d\t\tS\u0005\u0005\u0002#35\t1E\u0003\u0002%\u0019\u00051AH]8pizJ!AJ\r\u0002\rA\u0013X\rZ3g\u0013\tA\u0013F\u0001\u0004TiJLgn\u001a\u0006\u0003MeACAA\u0016:uA\u0011AfN\u0007\u0002[)\u0011afL\u0001\taJ|g/\u001b3fe*\u0011\u0001'M\u0001\u0007a\u0006\u0014\u0018-\\:\u000b\u0005I\u001a\u0014a\u00026va&$XM\u001d\u0006\u0003iU\nQA[;oSRT\u0011AN\u0001\u0004_J<\u0017B\u0001\u001d.\u0005-1\u0016\r\\;f'>,(oY3\u0002\u000fM$(/\u001b8hg2\u00121(P\u0011\u0002y\u0005\u0011!p[\u0011\u0002}\u0005)1N]1gi\"\u0012!\u0001\u0011\t\u0003\u0003\nk\u0011aL\u0005\u0003\u0007>\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003i!Xm\u001d;DkJ\u0014XM\u001c;Fa>\u001c\u0007NV1mS\u0012\fG/[8o)\t9b\tC\u0003\u001f\u0007\u0001\u0007q\u0004\u000b\u0003\u0004WeBEFA\u001e>Q\t\u0019\u0001)A\u0011pM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s)>\u0004\u0018nY\"pY2,7\r^5p]\u001a{'\u000f\u0006\u0003MI*|\u0007CA'b\u001d\tqeL\u0004\u0002P7:\u0011\u0001\u000b\u0017\b\u0003#Zs!A\u0015+\u000f\u0005\t\u001a\u0016\"\u0001\u001c\n\u0005U+\u0014AB1qC\u000eDW-\u0003\u0002\f/*\u0011Q+N\u0005\u00033j\u000baaY8n[>t'BA\u0006X\u0013\taV,A\u0004nKN\u001c\u0018mZ3\u000b\u0005eS\u0016BA0a\u0003}yeMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u00039vK!AY2\u0003==3gm]3u\r>\u0014H*Z1eKJ$v\u000e]5d\u0007>dG.Z2uS>t'BA0a\u0011\u0015)G\u00011\u0001g\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"a\u001a5\u000e\u0003uK!![/\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")1\u000e\u0002a\u0001Y\u0006YA.Z1eKJ,\u0005o\\2i!\tAR.\u0003\u0002o3\t\u0019\u0011J\u001c;\t\u000bA$\u0001\u0019\u00017\u0002%\r,(O]3oi2+\u0017\rZ3s\u000bB|7\r[\u0001\u0014CN\u001cXM\u001d;SKN\u0004xN\\:f\u000bJ\u0014xN\u001d\u000b\u0005/M\\X\u0010C\u0003u\u000b\u0001\u0007Q/A\u0003feJ|'\u000f\u0005\u0002ws6\tqO\u0003\u0002y;\u0006A\u0001O]8u_\u000e|G.\u0003\u0002{o\n1QI\u001d:peNDQ\u0001`\u0003A\u00021\f\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\u0006}\u0016\u0001\ra`\u0001\be\u0016\fX/Z:u!\u0011\t\t!a\u0002\u000e\u0005\u0005\r!bAA\u0003;\u0006A!/Z9vKN$8/\u0003\u0003\u0002\n\u0005\r!\u0001H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fcV,7\u000f^\u0001\fg\u0016tGMU3rk\u0016\u001cH\u000f\u0006\u0004\u0002\u0010\u0005U\u0011q\u0003\t\u0005\u0003\u0003\t\t\"\u0003\u0003\u0002\u0014\u0005\r!!H(gMN,Go\u001d$pe2+\u0017\rZ3s\u000bB|7\r\u001b*fgB|gn]3\t\u000bq4\u0001\u0019\u00017\t\u000by4\u0001\u0019A@")
public class OffsetsForLeaderEpochRequestTest
extends BaseRequestTest {
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testOffsetsForLeaderEpochErrorCodes(String quorum) {
        String topic = "topic";
        TopicPartition partition = new TopicPartition(topic, 0);
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(partition, 0, -1);
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        int randomBrokerId = ((KafkaBroker)this.brokers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, request);
        int x$22 = 2;
        int x$32 = this.createTopic$default$2();
        Properties x$42 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        scala.collection.immutable.Map<Object, Object> partitionToLeader = this.createTopic(topic, x$32, x$22, x$42, x$5, x$6);
        Map topicDescription = (Map)this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2()).describeTopics((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)partition.topic(), (List)Nil$.MODULE$)).asJava()).allTopicNames().get();
        Set replicas = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)((TopicDescription)topicDescription.get(partition.topic())).partitions().get(partition.partition())).replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)BoxesRunTime.boxToInteger((int)partition.partition())));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableLike)this.brokers().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)OffsetsForLeaderEpochRequestTest.$anonfun$testOffsetsForLeaderEpochErrorCodes$3(x$3)), Buffer$.MODULE$.canBuildFrom())).find((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> !replicas.contains((Object)BoxesRunTime.boxToInteger((int)x$4))).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, request);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, request);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCurrentEpochValidation(String quorum) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int x$2 = 3;
        int x$3 = this.createTopic$default$2();
        Properties x$4 = this.createTopic$default$4();
        ListenerName x$5 = this.createTopic$default$5();
        Properties x$6 = this.createTopic$default$6();
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)this.createTopic(topic, x$3, x$2, x$4, x$5, x$6).apply((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange(this.brokers(), topicPartition, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)firstLeaderId)), TestUtils$.MODULE$.awaitLeaderChange$default$4(), TestUtils$.MODULE$.awaitLeaderChange$default$5());
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NONE, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaBroker>)this.brokers());
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty(), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch + 1)), topicPartition);
        this.assertResponseErrorForEpoch$1(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(Predef$.MODULE$.int2Integer(secondLeaderEpoch - 1)), topicPartition);
    }

    private OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection offsetForLeaderTopicCollectionFor(TopicPartition topicPartition, int leaderEpoch, int currentLeaderEpoch) {
        return new OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection((Iterator)CollectionConverters$.MODULE$.asJavaIteratorConverter(new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderTopic().setTopic(topicPartition.topic()).setPartitions((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(topicPartition.partition()).setLeaderEpoch(leaderEpoch).setCurrentLeaderEpoch(currentLeaderEpoch), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$).iterator()).asJava());
    }

    private void assertResponseError(Errors error, int brokerId, OffsetsForLeaderEpochRequest request) {
        OffsetsForLeaderEpochResponse response = this.sendRequest(brokerId, request);
        Assertions.assertEquals((int)request.data().topics().size(), (int)response.data().topics().size());
        ((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().topics()).asScala()).foreach((Function1 & Serializable & scala.Serializable)offsetForLeaderTopic -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$1(request, error, offsetForLeaderTopic);
            return BoxedUnit.UNIT;
        });
    }

    private OffsetsForLeaderEpochResponse sendRequest(int brokerId, OffsetsForLeaderEpochRequest request) {
        return (OffsetsForLeaderEpochResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(brokerId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(OffsetsForLeaderEpochResponse.class));
    }

    public static final /* synthetic */ int $anonfun$testOffsetsForLeaderEpochErrorCodes$3(KafkaBroker x$3) {
        return x$3.config().brokerId();
    }

    private final void assertResponseErrorForEpoch$1(Errors error, int brokerId, Optional currentLeaderEpoch, TopicPartition topicPartition$1) {
        OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection epochs = this.offsetForLeaderTopicCollectionFor(topicPartition$1, 0, Predef$.MODULE$.Integer2int(currentLeaderEpoch.orElse(Predef$.MODULE$.int2Integer(-1))));
        OffsetsForLeaderEpochRequest request = (OffsetsForLeaderEpochRequest)OffsetsForLeaderEpochRequest.Builder.forFollower((short)ApiKeys.OFFSET_FOR_LEADER_EPOCH.latestVersion(), (OffsetForLeaderEpochRequestData.OffsetForLeaderTopicCollection)epochs, (int)1).build();
        this.assertResponseError(error, brokerId, request);
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, OffsetForLeaderEpochResponseData.EpochEndOffset offsetForLeaderPartition) {
        Assertions.assertEquals((short)error$1.code(), (short)offsetForLeaderPartition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(OffsetsForLeaderEpochRequest request$1, Errors error$1, OffsetForLeaderEpochResponseData.OffsetForLeaderTopicResult offsetForLeaderTopic) {
        Assertions.assertEquals((int)request$1.data().topics().find(offsetForLeaderTopic.topic()).partitions().size(), (int)offsetForLeaderTopic.partitions().size());
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(offsetForLeaderTopic.partitions()).asScala()).foreach((Function1 & Serializable & scala.Serializable)offsetForLeaderPartition -> {
            OffsetsForLeaderEpochRequestTest.$anonfun$assertResponseError$2(error$1, offsetForLeaderPartition);
            return BoxedUnit.UNIT;
        });
    }
}

