/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.AdminZkClient$;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.consumer.GroupProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t\u0015h!\u0002\u001f>\u0003\u0003\u0011\u0005\"B(\u0001\t\u0003\u0001\u0006bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u0001)\"1!\f\u0001Q\u0001\nUCqa\u0017\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004]\u0001\u0001\u0006I!\u0016\u0005\u0006;\u0002!\tB\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0005g\u0011\u00191\b\u0001)A\u0005O\")q\u000f\u0001C\tq\"9\u0011q\u0005\u0001\u0005\u0012\u0005%\u0002bCA\t\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"!\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002<!Y\u0011q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\n\u0011-\tI\u0005\u0001a\u0001\u0002\u0004%\t\"a\u0013\t\u0017\u0005M\u0003\u00011AA\u0002\u0013E\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\ti\u0005C\u0004\u0002\\\u0001!\t!!\u0018\t\u000f\u0005}\u0003\u0001\"\u0001\u0002^!9\u0011\u0011\r\u0001\u0005\u0002\u0005u\u0003bBA2\u0001\u0011\u0005\u0011Q\r\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\ty\b\u0001C\u0001\u0003{Bq!!!\u0001\t\u0013\t\u0019\tC\u0004\u0002\f\u0002!I!!$\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011Q\u0015\u0001\u0005\u0002\u0005\u001d\u0006bBAX\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003c\u0003A\u0011AAZ\u0011\u0019\tY\f\u0001C\u0001)\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAl\u0001\u0011\u0005\u0011q\u0018\u0005\b\u00033\u0004A\u0011AAn\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KD\u0011\"!;\u0001\u0005\u0004%\t!a;\t\u0011\u0005M\b\u0001)A\u0005\u0003[D\u0011\"!>\u0001\u0005\u0004%\t!a>\t\u0011\t\u0015\u0001\u0001)A\u0005\u0003sDqAa\u0002\u0001\t\u0003\u0011I\u0001C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u0013\t\u0005\u0003!%A\u0005\u0002\t\r\u0003\"\u0003B-\u0001E\u0005I\u0011\u0001B.\u0011%\u0011y\u0006AI\u0001\n\u0003\u0011\t\u0007C\u0004\u0003f\u0001!\t!! \t\u000f\t\u001d\u0004\u0001\"\u0001\u0002~!9!\u0011\u000e\u0001\u0005\u0002\t-\u0004b\u0002BA\u0001\u0011%!1\u0011\u0005\b\u0005\u0003\u0003A\u0011\u0003BD\u0011\u001d\u0011i\t\u0001C\u0005\u0003\u0007CqAa$\u0001\t\u0003\ti\bC\u0004\u0003\u001a\u0002!\tAa'\b\u000f\teV\b#\u0001\u0003<\u001a1A(\u0010E\u0001\u0005{Caa\u0014\u001c\u0005\u0002\t}\u0006\"\u0003Bam\t\u0007I\u0011\u0001Bb\u0011!\u0011yM\u000eQ\u0001\n\t\u0015\u0007b\u0002Bim\u0011\u0005\u0011Q\u0010\u0005\b\u000574D\u0011AA?\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\u0006\u0003}}\naa]3sm\u0016\u0014(\"\u0001!\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001aQ%\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\r\u0005s\u0017PU3g!\tQU*D\u0001L\u0015\tau(A\u0003vi&d7/\u0003\u0002O\u0017\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001R!\t\u0011\u0006!D\u0001>\u0003MQ8nQ8o]\u0016\u001cG/[8o)&lWm\\;u+\u0005)\u0006C\u0001#W\u0013\t9VIA\u0002J]R\fAC_6D_:tWm\u0019;j_:$\u0016.\\3pkR\u0004\u0013\u0001\u0005>l'\u0016\u001c8/[8o)&lWm\\;u\u0003EQ8nU3tg&|g\u000eV5nK>,H\u000fI\u0001\u0016u.l\u0015\r_%o\r2Lw\r\u001b;SKF,Xm\u001d;t\u0003YQ8.T1y\u0013:4E.[4iiJ+\u0017/^3tiN\u0004\u0013!\u0004>l\u0003\u000ed7/\u00128bE2,G-F\u0001`!\r!\u0005MY\u0005\u0003C\u0016\u0013aa\u00149uS>t\u0007C\u0001#d\u0013\t!WIA\u0004C_>dW-\u00198\u0002E\r|g\u000e\u001e:pY2,'\u000fT5ti\u0016tWM]*fGV\u0014\u0018\u000e^=Qe>$xnY8m+\u00059\u0007C\u00015u\u001b\u0005I'B\u00016l\u0003\u0011\tW\u000f\u001e5\u000b\u00051l\u0017\u0001C:fGV\u0014\u0018\u000e^=\u000b\u00059|\u0017AB2p[6|gN\u0003\u0002Aa*\u0011\u0011O]\u0001\u0007CB\f7\r[3\u000b\u0003M\f1a\u001c:h\u0013\t)\u0018N\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\u0006\u00193m\u001c8ue>dG.\u001a:MSN$XM\\3s'\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\u0013AF6sC\u001a$8i\u001c8ue>dG.\u001a:D_:4\u0017nZ:\u0015\u0007e\fy\u0001E\u0002{{~l\u0011a\u001f\u0006\u0003y\u0016\u000b!bY8mY\u0016\u001cG/[8o\u0013\tq8PA\u0002TKF\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0003vi&d'BAA\u0005\u0003\u0011Q\u0017M^1\n\t\u00055\u00111\u0001\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBA\t\u0017\u0001\u0007\u00111C\u0001\ti\u0016\u001cH/\u00138g_B!\u0011QCA\u0012\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011aA1qS*!\u0011QDA\u0010\u0003\u001dQW\u000f]5uKJT1!!\ts\u0003\u0015QWO\\5u\u0013\u0011\t)#a\u0006\u0003\u0011Q+7\u000f^%oM>\fq\"\\3uC\u0012\fG/\u0019,feNLwN\\\u000b\u0003\u0003W\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004]\u0006E\"B\u0001 p\u0013\u0011\t)$a\f\u0003\u001f5+G/\u00193bi\u00064VM]:j_:,\"!a\u0005\u0002\u0019Q,7\u000f^%oM>|F%Z9\u0015\t\u0005u\u00121\t\t\u0004\t\u0006}\u0012bAA!\u000b\n!QK\\5u\u0011%\t)EDA\u0001\u0002\u0004\t\u0019\"A\u0002yIE\n\u0011\u0002^3ti&sgm\u001c\u0011\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]V\u0011\u0011Q\n\t\u0004%\u0006=\u0013bAA){\t!\u0012+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\f!#[7qY\u0016lWM\u001c;bi&|gn\u0018\u0013fcR!\u0011QHA,\u0011%\t)%EA\u0001\u0002\u0004\ti%A\bj[BdW-\\3oi\u0006$\u0018n\u001c8!\u0003-I7o\u0013*bMR$Vm\u001d;\u0015\u0003\t\f\u0011#[:[W6KwM]1uS>tG+Z:u\u0003qI7OT3x\u000fJ|W\u000f]\"p_J$\u0017N\\1u_J,e.\u00192mK\u0012\f1$\\1zE\u0016<%o\\;q!J|Go\\2pYN\u0003XmY5gS\u0016$G\u0003BA4\u0003s\u0002B\u0001\u00121\u0002jA!\u00111NA;\u001b\t\tiG\u0003\u0003\u0002p\u0005E\u0014\u0001C2p]N,X.\u001a:\u000b\u0007\u0005Mt.A\u0004dY&,g\u000e^:\n\t\u0005]\u0014Q\u000e\u0002\u000e\u000fJ|W\u000f\u001d)s_R|7m\u001c7\t\u000f\u0005Ea\u00031\u0001\u0002\u0014\u0005i1\r[3dW&\u001b(l\u0013+fgR$\"!!\u0010\u0002!\rDWmY6Jg.\u0013\u0016M\u001a;UKN$\u0018\u0001B1t5.$\"!!\"\u0011\u0007I\u000b9)C\u0002\u0002\nv\u0012QDW8p\u0017\u0016,\u0007/\u001a:Rk>\u0014X/\\%na2,W.\u001a8uCRLwN\\\u0001\bCN\\%+\u00194u)\t\ty\tE\u0002S\u0003#K1!a%>\u0005eY%+\u00194u#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002\u0013i|wn[3fa\u0016\u0014XCAAM!\u0011\tY*!)\u000e\u0005\u0005u%bAAP\u007f\u0005\u0011!p[\u0005\u0005\u0003G\u000biJA\tF[\n,G\rZ3e5>|7.Z3qKJ\f\u0001B_6DY&,g\u000e^\u000b\u0003\u0003S\u0003B!a'\u0002,&!\u0011QVAO\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006q!p[\"mS\u0016tGo\u0014:Ok2d\u0017!D1e[&t'l[\"mS\u0016tG/\u0006\u0002\u00026B!\u00111TA\\\u0013\u0011\tI,!(\u0003\u001b\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u\u0003\u0019Q8\u000eU8si\u0006I!p[\"p]:,7\r^\u000b\u0003\u0003\u0003\u0004B!a1\u0002R:!\u0011QYAg!\r\t9-R\u0007\u0003\u0003\u0013T1!a3B\u0003\u0019a$o\\8u}%\u0019\u0011qZ#\u0002\rA\u0013X\rZ3g\u0013\u0011\t\u0019.!6\u0003\rM#(/\u001b8h\u0015\r\ty-R\u0001\u0010u.\u001cuN\u001c8fGR|%OT;mY\u0006\u00012m\u001c8ue>dG.\u001a:TKJ4XM]\u000b\u0003\u0003;\u00042AUAp\u0013\r\t\t/\u0010\u0002\u0011\u0007>tGO]8mY\u0016\u00148+\u001a:wKJ\f\u0011cY8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:t+\t\t9\u000f\u0005\u0003{{\u0006u\u0017a\u00054bk2$\b*\u00198eY\u0016\u0014h)Y2u_JLXCAAw!\r\u0011\u0016q^\u0005\u0004\u0003cl$\u0001J)v_J,X\u000eV3ti\"\u000b'O\\3tg\u001a\u000bW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=\u0002)\u0019\fW\u000f\u001c;IC:$G.\u001a:GC\u000e$xN]=!\u000311\u0017-\u001e7u\u0011\u0006tG\r\\3s+\t\tI\u0010\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0!\r\u0002\u000b\u0019\fW\u000f\u001c;\n\t\t\r\u0011Q \u0002\u0011\u001b>\u001c7NR1vYRD\u0015M\u001c3mKJ\fQBZ1vYRD\u0015M\u001c3mKJ\u0004\u0013!B:fiV\u0003H\u0003BA\u001f\u0005\u0017Aq!!\u0005)\u0001\u0004\t\u0019\u0002K\u0002)\u0005\u001f\u0001B!!\u0006\u0003\u0012%!!1CA\f\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\rGJ,\u0017\r^3Ce>\\WM\u001d\u000b\u000b\u00053\u0011yB!\u000b\u00038\tm\u0002c\u0001*\u0003\u001c%\u0019!QD\u001f\u0003\u0017-\u000bgm[1Ce>\\WM\u001d\u0005\b\u0005CI\u0003\u0019\u0001B\u0012\u0003\u0019\u0019wN\u001c4jOB\u0019!K!\n\n\u0007\t\u001dRHA\u0006LC\u001a\\\u0017mQ8oM&<\u0007\"\u0003B\u0016SA\u0005\t\u0019\u0001B\u0017\u0003\u0011!\u0018.\\3\u0011\t\t=\"1G\u0007\u0003\u0005cQ!\u0001T7\n\t\tU\"\u0011\u0007\u0002\u0005)&lW\r\u0003\u0005\u0003:%\u0002\n\u00111\u0001c\u0003\u001d\u0019H/\u0019:ukBD\u0011B!\u0010*!\u0003\u0005\rAa\u0010\u0002!QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b\u0003\u0002#a\u0003\u0003\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bRCA!\f\u0003H-\u0012!\u0011\n\t\u0005\u0005\u0017\u0012)&\u0004\u0002\u0003N)!!q\nB)\u0003%)hn\u00195fG.,GMC\u0002\u0003T\u0015\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119F!\u0014\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fde\u0016\fG/\u001a\"s_.,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011iFK\u0002c\u0005\u000f\nac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005GRCAa\u0010\u0003H\u0005\t2\u000f[;uI><hNW8p\u0017\u0016,\u0007/\u001a:\u0002/MDW\u000f\u001e3po:\\%+\u00194u\u0007>tGO]8mY\u0016\u0014\u0018\u0001F1eI\u001a{'/\\1ui\u0016\u00148+\u001a;uS:<7\u000f\u0006\u0003\u0002>\t5\u0004b\u0002B8_\u0001\u0007!\u0011O\u0001\nM>\u0014X.\u0019;uKJ\u0004BAa\u001d\u0003~5\u0011!Q\u000f\u0006\u0005\u0005o\u0012I(A\u0004ti>\u0014\u0018mZ3\u000b\u0007\tmt.\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0011yH!\u001e\u0003\u0013\u0019{'/\\1ui\u0016\u0014\u0018A\u00048fo.\u0013\u0016M\u001a;Rk>\u0014X/\u001c\u000b\u0005\u0003\u001f\u0013)\tC\u0004\u0002\u0012A\u0002\r!a\u0005\u0015\t\u0005=%\u0011\u0012\u0005\u0007\u0005\u0017\u000b\u0004\u0019A@\u0002\u001f=4XM\u001d:jI&tw\r\u0015:paN\f!C\\3x5>|7*Z3qKJ\fVo\u001c:v[\u0006AA/Z1s\t><h\u000eK\u00024\u0005'\u0003B!!\u0006\u0003\u0016&!!qSA\f\u0005%\te\r^3s\u000b\u0006\u001c\u0007.A\u0016de\u0016\fG/\u001a.p_.+W\r]3s\u00072LWM\u001c;U_R\u0013\u0018nZ4feN+7o]5p]\u0016C\b/\u001b:z)\u0011\u0011iJa*\u0011\t\t}%1U\u0007\u0003\u0005CS1!!&q\u0013\u0011\u0011)K!)\u0003\u0013i{wnS3fa\u0016\u0014\bb\u0002BUi\u0001\u0007!QT\u0001\nu>|7*Z3qKJDs\u0001\u0001BW\u0005g\u0013)\f\u0005\u0003\u0002\u0016\t=\u0016\u0002\u0002BY\u0003/\u00111\u0001V1h\u0003\u00151\u0018\r\\;fC\t\u00119,A\u0006j]R,wM]1uS>t\u0017!E)v_J,X\u000eV3ti\"\u000b'O\\3tgB\u0011!KN\n\u0003m\r#\"Aa/\u00023i[7\t\\5f]R,e/\u001a8u)\"\u0014X-\u00193Tk\u001a4\u0017\u000e_\u000b\u0003\u0005\u000b\u0004BAa2\u0003N6\u0011!\u0011\u001a\u0006\u0005\u0005\u0017\f9!\u0001\u0003mC:<\u0017\u0002BAj\u0005\u0013\f!DW6DY&,g\u000e^#wK:$H\u000b\u001b:fC\u0012\u001cVO\u001a4jq\u0002\n!b]3u+B\u001cE.Y:tQ\rQ$Q\u001b\t\u0005\u0003+\u00119.\u0003\u0003\u0003Z\u0006]!!\u0003\"fM>\u0014X-\u00117m\u00035!X-\u0019:E_^t7\t\\1tg\"\u001a1Ha8\u0011\t\u0005U!\u0011]\u0005\u0005\u0005G\f9B\u0001\u0005BMR,'/\u00117m\u0001")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final SecurityProtocol controllerListenerSecurityProtocol;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory;
    private final MockFaultHandler faultHandler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs(TestInfo testInfo) {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latestTesting();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    public QuorumImplementation implementation() {
        return this.implementation;
    }

    public void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public boolean isNewGroupCoordinatorEnabled() {
        return TestInfoUtils$.MODULE$.isNewGroupCoordinatorEnabled(this.testInfo());
    }

    public Option<GroupProtocol> maybeGroupProtocolSpecified(TestInfo testInfo) {
        return TestInfoUtils$.MODULE$.maybeGroupProtocolSpecified(testInfo);
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    public void addFormatterSettings(Formatter formatter) {
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        return this.newKRaftQuorum(new Properties());
    }

    public KRaftQuorumImplementation newKRaftQuorum(Properties overridingProps) {
        Seq<Properties> propsList = this.kraftControllerConfigs(this.testInfo());
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.head();
        props.putAll((Map<?, ?>)overridingProps);
        props.setProperty("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty("process.roles", "controller");
        props.setProperty("unstable.feature.versions.enable", "true");
        if (props.getProperty("node.id") == null) {
            props.setProperty("node.id", "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty("node.id"));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        props.setProperty("metadata.log.dir", metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty("listener.security.protocol.map", new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty("listeners", "CONTROLLER://localhost:0");
        props.setProperty("controller.listener.names", "CONTROLLER");
        props.setProperty("controller.quorum.voters", new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        props.setProperty(ServerLogConfigs.LOG_DELETE_DELAY_MS_CONFIG, "1000");
        KafkaConfig config = new KafkaConfig((Map)props);
        Formatter formatter = new Formatter().setClusterId(Uuid.randomUuid().toString()).setNodeId(nodeId);
        formatter.addDirectory(metadataDir.getAbsolutePath());
        formatter.setReleaseVersion(this.metadataVersion());
        formatter.setUnstableFeatureVersionsEnabled(true);
        formatter.setControllerListenerName((String)config.controllerListenerNames().head());
        formatter.setMetadataLogDirectory(config.metadataLogDir());
        this.addFormatterSettings(formatter);
        formatter.run();
        BootstrapMetadata bootstrapMetadata = formatter.bootstrapMetadata();
        CompletableFuture<Map<Integer, InetSocketAddress>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, InetSocketAddress>>();
        MetaPropertiesEnsemble metaPropertiesEnsemble = new MetaPropertiesEnsemble.Loader().addMetadataLogDir(metadataDir.getAbsolutePath()).load();
        metaPropertiesEnsemble.verify(Optional.of(formatter.clusterId()), OptionalInt.of(nodeId), EnumSet.of(MetaPropertiesEnsemble.VerificationFlag.REQUIRE_AT_LEAST_ONE_VALID, MetaPropertiesEnsemble.VerificationFlag.REQUIRE_METADATA_LOG_DIR));
        SharedServer sharedServer = new SharedServer(config, metaPropertiesEnsemble, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, Collections.emptyList(), (FaultHandlerFactory)this.faultHandlerFactory());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sharedServer.stopForController(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, formatter.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            boolean x$2 = BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled()));
            int x$3 = this.zkSessionTimeout();
            int x$4 = this.zkConnectionTimeout();
            int x$5 = this.zkMaxInFlightRequests();
            Time x$6 = Time.SYSTEM;
            String x$7 = "ZooKeeperTestHarness";
            ZKClientConfig x$8 = new ZKClientConfig();
            boolean x$9 = false;
            String x$10 = KafkaZkClient$.MODULE$.apply$default$9();
            String x$11 = KafkaZkClient$.MODULE$.apply$default$10();
            boolean x$12 = KafkaZkClient$.MODULE$.apply$default$11();
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$10, x$11, x$12, x$9);
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem, AdminZkClient$.MODULE$.$lessinit$greater$default$2());
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return anotherZkClient;
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
        this.faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
        this.faultHandler = this.faultHandlerFactory().faultHandler();
    }
}

