/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.OptionalInt;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.zookeeper.KeeperException;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dB\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u0016\t\u0013M\u0002\u0001\u0019!a\u0001\n\u0003!\u0004\"C\u001f\u0001\u0001\u0004\u0005\t\u0015)\u0003,\u0011%q\u0004\u00011AA\u0002\u0013\u0005q\bC\u0005D\u0001\u0001\u0007\t\u0019!C\u0001\t\"Ia\t\u0001a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\n\u000f\u0002\u0001\r\u00111A\u0005\u0002)B\u0011\u0002\u0013\u0001A\u0002\u0003\u0007I\u0011A%\t\u0013-\u0003\u0001\u0019!A!B\u0013Y\u0003\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0001@\u0011%i\u0005\u00011AA\u0002\u0013\u0005a\nC\u0005Q\u0001\u0001\u0007\t\u0011)Q\u0005\u0001\"9\u0011\u000b\u0001a\u0001\n\u0003\u0011\u0006b\u0002/\u0001\u0001\u0004%\t!\u0018\u0005\u0007?\u0002\u0001\u000b\u0015B*\t\u000b\u0001\u0004A\u0011I1\t\u000bQ\u0004A\u0011I;\t\u000bi\u0004A\u0011A;\t\u000b}\u0004A\u0011A;\t\r\u0005\r\u0001\u0001\"\u0001v\u0011\u0019\t9\u0001\u0001C\u0001k\"1\u00111\u0002\u0001\u0005\u0002UDa!a\u0004\u0001\t\u0003)\bbBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003\u0007\u0002A\u0011BA#\u0005i\u0019VM\u001d<fe\u001e+g.\u001a:bi\u0016\u0014%o\\6fe&#G+Z:u\u0015\tib$\u0001\u0004tKJ4XM\u001d\u0006\u0002?\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u001d\u0013\t)CDA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005\r\u0002\u0011A\u00029s_B\u001c\u0018'F\u0001,!\ta\u0013'D\u0001.\u0015\tqs&\u0001\u0003vi&d'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003)\u0001(o\u001c9tc}#S-\u001d\u000b\u0003km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012A!\u00168ji\"9AhAA\u0001\u0002\u0004Y\u0013a\u0001=%c\u00059\u0001O]8qgF\u0002\u0013aB2p]\u001aLw-M\u000b\u0002\u0001B\u00111%Q\u0005\u0003\u0005r\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Y1m\u001c8gS\u001e\ft\fJ3r)\t)T\tC\u0004=\r\u0005\u0005\t\u0019\u0001!\u0002\u0011\r|gNZ5hc\u0001\na\u0001\u001d:paN\u0014\u0014A\u00039s_B\u001c(g\u0018\u0013fcR\u0011QG\u0013\u0005\by%\t\t\u00111\u0001,\u0003\u001d\u0001(o\u001c9te\u0001\nqaY8oM&<''A\u0006d_:4\u0017n\u001a\u001a`I\u0015\fHCA\u001bP\u0011\u001daD\"!AA\u0002\u0001\u000b\u0001bY8oM&<'\u0007I\u0001\bg\u0016\u0014h/\u001a:t+\u0005\u0019\u0006c\u0001+X36\tQK\u0003\u0002Wo\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005a+&aA*fcB\u00111EW\u0005\u00037r\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t)d\fC\u0004=\u001f\u0005\u0005\t\u0019A*\u0002\u0011M,'O^3sg\u0002\nQa]3u+B$\"!\u000e2\t\u000b\r\f\u0002\u0019\u00013\u0002\u0011Q,7\u000f^%oM>\u0004\"!\u001a8\u000e\u0003\u0019T!a\u001a5\u0002\u0007\u0005\u0004\u0018N\u0003\u0002jU\u00069!.\u001e9ji\u0016\u0014(BA6m\u0003\u0015QWO\\5u\u0015\u0005i\u0017aA8sO&\u0011qN\u001a\u0002\t)\u0016\u001cH/\u00138g_\"\u0012\u0011#\u001d\t\u0003KJL!a\u001d4\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005)\u0004F\u0001\nx!\t)\u00070\u0003\u0002zM\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0019i\u0016\u001cH/Q;u_\u001e+g.\u001a:bi\u0016\u0014%o\\6fe&#\u0007FA\n}!\t)W0\u0003\u0002\u007fM\n!A+Z:u\u0003\t\"Xm\u001d;Vg\u0016\u00148i\u001c8gS\u001e\fe\u000eZ$f]\u0016\u0014\u0018\r^3e\u0005J|7.\u001a:JI\"\u0012A\u0003`\u0001\u001di\u0016\u001cH\u000fR5tC\ndWmR3oKJ\fG/\u001a3Ce>\\WM]%eQ\t)B0\u0001\u000fuKN$X*\u001e7uSBdW\rT8h\t&\u00148/T3uCB\u0013x\u000e]:)\u0005Ya\u0018\u0001\r;fgR\u001cuN\\:jgR,g\u000e\u001e\"s_.,'/\u00133Ge>lWk]3s\u0007>tg-[4B]\u0012lU\r^1Qe>\u00048\u000f\u000b\u0002\u0018y\u0006yB/Z:u\u0005J|7.\u001a:NKR\fG-\u0019;b\u001f:LEmQ8mY&\u001c\u0018n\u001c8)\u0005aa\u0018\u0001\u0006<fe&4\u0017P\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018\r\u0006\u0004\u0002\u0018\u0005u\u0011\u0011\b\t\u0004m\u0005e\u0011bAA\u000eo\t9!i\\8mK\u0006t\u0007bBA\u00103\u0001\u0007\u0011\u0011E\u0001\bY><G)\u001b:t!\u0011!v+a\t\u0011\t\u0005\u0015\u00121\u0007\b\u0005\u0003O\ty\u0003E\u0002\u0002*]j!!a\u000b\u000b\u0007\u00055\u0002%\u0001\u0004=e>|GOP\u0005\u0004\u0003c9\u0014A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0005]\"AB*ue&twMC\u0002\u00022]Bq!a\u000f\u001a\u0001\u0004\ti$\u0001\u0005ce>\\WM]%e!\r1\u0014qH\u0005\u0004\u0003\u0003:$aA%oi\u0006a1M]3bi\u0016\u001cVM\u001d<feR)\u0011,a\u0012\u0002L!1\u0011\u0011\n\u000eA\u0002\u0001\u000baaY8oM&<\u0007bBA'5\u0001\u0007\u0011qJ\u0001\u0011i\"\u0014X-\u00193OC6,\u0007K]3gSb\u0004RANA)\u0003GI1!a\u00158\u0005\u0019y\u0005\u000f^5p]\u0002")
public class ServerGenerateBrokerIdTest
extends QuorumTestHarness {
    private Properties props1;
    private KafkaConfig config1;
    private Properties props2;
    private KafkaConfig config2;
    private Seq<KafkaServer> servers = Nil$.MODULE$;

    public Properties props1() {
        return this.props1;
    }

    public void props1_$eq(Properties x$1) {
        this.props1 = x$1;
    }

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public Properties props2() {
        return this.props2;
    }

    public void props2_$eq(Properties x$1) {
        this.props2 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.props1_$eq(TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        this.props2_$eq(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21()));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(this.props2()));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateBrokerId() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        server1 = this.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testUserConfigAndGeneratedBrokerId() {
        KafkaConfig x$12 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$12, x$3, x$2, x$4);
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server2 = new KafkaServer(x$5, x$7, x$6, x$8);
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(-1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(props3);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$122 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server3 = new KafkaServer(x$9, x$11, x$10, x$122);
        server1.startup();
        Assertions.assertEquals((int)server1.config().brokerId(), (int)1001);
        server2.startup();
        Assertions.assertEquals((int)server2.config().brokerId(), (int)0);
        server3.startup();
        Assertions.assertEquals((int)server3.config().brokerId(), (int)1002);
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server1.config().logDirs(), 1001));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server2.config().logDirs(), 0));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 1002));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testDisableGeneratedBrokerId() {
        Properties props3 = TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props3.put("broker.id.generation.enable", "false");
        props3.put("reserved.broker.max.id", "0");
        KafkaConfig config3 = KafkaConfig$.MODULE$.fromProps(props3);
        KafkaServer server3 = this.createServer(config3, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server3, (List)Nil$.MODULE$));
        Assertions.assertEquals((int)server3.config().brokerId(), (int)3);
        server3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testMultipleLogDirsMetaProps() {
        String logDirs = new StringBuilder(2).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", logDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        String newLogDirs = new StringBuilder(1).append(this.props1().getProperty("log.dir")).append(",").append(TestUtils$.MODULE$.tempDir().getAbsolutePath()).toString();
        this.props1().setProperty("log.dir", newLogDirs);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(this.props1()));
        KafkaConfig x$5 = this.config1();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)this.config1().logDirs(), 1001));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentBrokerIdFromUserConfigAndMetaProps() {
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server1 = new KafkaServer(x$1, x$3, x$2, x$4);
        server1.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        server1.shutdown();
        KafkaConfig x$5 = this.config2();
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        server1 = new KafkaServer(x$5, x$7, x$6, x$8);
        server1.startup();
        server1.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testBrokerMetadataOnIdCollision() {
        Properties propsA = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig configA = KafkaConfig$.MODULE$.fromProps(propsA);
        KafkaServer serverA = this.createServer(configA, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        Properties propsB = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        KafkaConfig configB = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer serverB = new KafkaServer(configB, x$3, x$2, x$4);
        Assertions.assertThrows(KeeperException.NodeExistsException.class, () -> serverB.startup());
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)Nil$.MODULE$));
        propsB.setProperty("broker.id", "2");
        KafkaConfig x$5 = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$6 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$7 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$8 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer serverB2 = new KafkaServer(x$5, x$7, x$6, x$8);
        RuntimeException startupException = (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> serverB2.startup());
        Assertions.assertTrue((boolean)startupException.getMessage().startsWith("Stored node id 1 doesn't match previous node id 2"), (String)new StringBuilder(29).append("Unexpected exception message ").append(startupException.getMessage()).toString());
        serverB2.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerGenerateBrokerIdTest.$anonfun$testBrokerMetadataOnIdCollision$3(logDir);
            return BoxedUnit.UNIT;
        });
        propsB.setProperty("broker.id", "3");
        KafkaConfig x$9 = KafkaConfig$.MODULE$.fromProps(propsB);
        Option x$10 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$11 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$12 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer serverB3 = new KafkaServer(x$9, x$11, x$10, x$12);
        serverB3.startup();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)serverA, (List)new .colon.colon((Object)serverB3, (List)Nil$.MODULE$)));
        serverA.shutdown();
        serverB3.shutdown();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverA.config().logDirs(), 1));
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)serverB3.config().logDirs(), 3));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, int brokerId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateBrokerIdTest.$anonfun$verifyBrokerMetadata$1(brokerId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    private KafkaServer createServer(KafkaConfig config, Option<String> threadNamePrefix) {
        return TestUtils$.MODULE$.createServer(config, Time.SYSTEM, threadNamePrefix);
    }

    public static final /* synthetic */ void $anonfun$testBrokerMetadataOnIdCollision$3(String logDir) {
        Utils.delete((File)new File(logDir));
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(int brokerId$1, Object nonLocalReturnKey1$1, String logDir) {
        Properties properties = PropertiesUtils.readPropertiesFile((String)new File(logDir, "meta.properties").getAbsolutePath());
        if (!new MetaProperties.Builder(properties).build().nodeId().equals(OptionalInt.of(brokerId$1))) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }
}

