/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import kafka.tools.ConsoleProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.KafkaException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ee\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\n-BQ\u0001\u000e\u0001\u0005\u0002UBQA\u0012\u0001\u0005\u0002UBQ\u0001\u0013\u0001\u0005\u0002UBQA\u0013\u0001\u0005\u0002UBQ\u0001\u0014\u0001\u0005\u0002UBQA\u0014\u0001\u0005\u0002UBQ\u0001\u0015\u0001\u0005\u0002UBQA\u0015\u0001\u0005\u0002UBQ\u0001\u0016\u0001\u0005\u0002UBQA\u0016\u0001\u0005\u0002UBQ\u0001\u0017\u0001\u0005\u0002UBQA\u0017\u0001\u0005\nmCQa\u001b\u0001\u0005\u0002UBQ!\u001c\u0001\u0005\u0002UBQa\u001c\u0001\u0005\u0002UBQ!\u001d\u0001\u0005\u0002UBQa\u001d\u0001\u0005\u0002UBQ!\u001e\u0001\u0005\u0002UBQa\u001e\u0001\u0005\u0002aDq!!\u0007\u0001\t\u0013\tY\u0002C\u0004\u0002T\u0001!I!!\u0016\t\u000f\u0005M\u0003\u0001\"\u0003\u0002\b\n)B*\u001b8f\u001b\u0016\u001c8/Y4f%\u0016\fG-\u001a:UKN$(BA\u000e\u001d\u0003\u0015!xn\u001c7t\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0003\u0001\u0001\u0002\"!\t\u0013\u000e\u0003\tR\u0011aI\u0001\u0006g\u000e\fG.Y\u0005\u0003K\t\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u0003A!WMZ1vYR$Vm\u001d;Qe>\u00048/F\u0001-!\ti#'D\u0001/\u0015\ty\u0003'\u0001\u0003vi&d'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u00039!Xm\u001d;MS:,'+Z1eKJ$\u0012A\u000e\t\u0003C]J!\u0001\u000f\u0012\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0007i\u0002\"a\u000f#\u000e\u0003qR!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@\u0001\u00069!.\u001e9ji\u0016\u0014(BA!C\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0015aA8sO&\u0011Q\t\u0010\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$H*\u001b8f%\u0016\fG-\u001a:IK\u0006$WM\u001d\u0015\u0003\ti\n!\u0006^3ti6Kg.[7bYZ\u000bG.\u001b3J]B,HoV5uQ\"+\u0017\rZ3s\u0017\u0016L\u0018I\u001c3WC2,X\r\u000b\u0002\u0006u\u0005\u0019B/Z:u\u0017\u0016LX*[:tS:<g+\u00197vK\"\u0012aAO\u0001\u001ei\u0016\u001cH\u000fR3nCJ\u001c\u0017\r^5p]NduN\\4feRC\u0017M\\(oK\"\u0012qAO\u0001\u001ai\u0016\u001cH\u000fT5oKJ+\u0017\rZ3s\u0011\u0016\fG-\u001a:O_.+\u0017\u0010\u000b\u0002\tu\u00059B/Z:u\u0019&tWMU3bI\u0016\u0014xJ\u001c7z-\u0006dW/\u001a\u0015\u0003\u0013i\na\n^3tiB\u000b'o]3IK\u0006$WM]#oC\ndW\rZ,ji\"\u001cUo\u001d;p[\u0012+G.[7ji\u0016\u0014\u0018I\u001c3WCJL\u0018N\\4Ok6\u0014WM](g\u0017\u0016Lh+\u00197vK\"+\u0017\rZ3s!\u0006L'o\u001d\u0015\u0003\u0015i\nq\u0003^3ti6K7o]5oO.+\u0017pU3qCJ\fGo\u001c:)\u0005-Q\u0014!\b;fgRl\u0015n]:j]\u001eDU-\u00193fe.+\u0017pU3qCJ\fGo\u001c:)\u00051Q\u0014A\b;fgRDU-\u00193fe\u0012+W.\u0019:dCRLwN\\\"pY2L7/[8oQ\ti!(\u0001\u0012bgN,'\u000f\u001e+ie><8o\u00148J]Z\fG.\u001b3QCR$XM\u001d8D_:4\u0017n\u001a\u000b\u0004mqs\u0006\"B/\u000f\u0001\u0004a\u0013!\u00029s_B\u001c\b\"B0\u000f\u0001\u0004\u0001\u0017aD3ya\u0016\u001cG/\u001a3NKN\u001c\u0018mZ3\u0011\u0005\u0005DgB\u00012g!\t\u0019'%D\u0001e\u0015\t)g$\u0001\u0004=e>|GOP\u0005\u0003O\n\na\u0001\u0015:fI\u00164\u0017BA5k\u0005\u0019\u0019FO]5oO*\u0011qMI\u0001\u0017i\u0016\u001cH/S4o_J,WI\u001d:pe&s\u0017J\u001c9vi\"\u0012qBO\u0001\u001fi\u0016\u001cH/T1mM>\u0014X.\u001a3IK\u0006$WM]%h]>\u0014X-\u0012:s_JD#\u0001\u0005\u001e\u0002\u001dQ,7\u000f\u001e(vY2l\u0015M]6fe\"\u0012\u0011CO\u0001\u001ai\u0016\u001cHOT;mY6\u000b'o[3s/&$\b\u000eS3bI\u0016\u00148\u000f\u000b\u0002\u0013u\u0005iB/Z:u\u001dVdG.T1sW\u0016\u0014\b*Z1eKJ\\U-\u001f+ie><8\u000f\u000b\u0002\u0014u\u0005)B/Z:u\u0013:4\u0018\r\\5e\u001dVdG.T1sW\u0016\u0014\bF\u0001\u000b;\u0003\u001d\u0011XO\u001c+fgR$BAN={y\")Q,\u0006a\u0001Y!)10\u0006a\u0001A\u0006)\u0011N\u001c9vi\")Q0\u0006a\u0001}\u0006yQ\r\u001f9fGR,GMU3d_J$7\u000f\u0005\u0003\"\u007f\u0006\r\u0011bAA\u0001E\tQAH]3qK\u0006$X\r\u001a \u0011\r\u0005\u0015\u0011Q\u00031a\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011\u0001\u00039s_\u0012,8-\u001a:\u000b\t\u00055\u0011qB\u0001\bG2LWM\u001c;t\u0015\ri\u0012\u0011\u0003\u0006\u0004\u0003'\u0011\u0015AB1qC\u000eDW-\u0003\u0003\u0002\u0018\u0005\u001d!A\u0004)s_\u0012,8-\u001a:SK\u000e|'\u000fZ\u0001\u0013CN\u001cXM\u001d;SK\u000e|'\u000fZ#rk\u0006d7/\u0006\u0004\u0002\u001e\u0005%\u0012Q\b\u000b\u0006m\u0005}\u0011\u0011\t\u0005\b\u0003C1\u0002\u0019AA\u0012\u0003!)\u0007\u0010]3di\u0016$\u0007\u0003CA\u0003\u0003+\t)#a\u000f\u0011\t\u0005\u001d\u0012\u0011\u0006\u0007\u0001\t\u001d\tYC\u0006b\u0001\u0003[\u0011\u0011aS\t\u0005\u0003_\t)\u0004E\u0002\"\u0003cI1!a\r#\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!IA\u001c\u0013\r\tID\t\u0002\u0004\u0003:L\b\u0003BA\u0014\u0003{!q!a\u0010\u0017\u0005\u0004\tiCA\u0001W\u0011\u001d\t\u0019E\u0006a\u0001\u0003\u000b\na!Y2uk\u0006d\u0007\u0003CA\u0003\u0003+\t9%a\u0012\u0011\u000b\u0005\nI%!\u0014\n\u0007\u0005-#EA\u0003BeJ\f\u0017\u0010E\u0002\"\u0003\u001fJ1!!\u0015#\u0005\u0011\u0011\u0015\u0010^3\u0002\rI,7m\u001c:e+\u0019\t9&!\u0018\u0002bQA\u0011\u0011LA2\u0003O\nY\u0007\u0005\u0005\u0002\u0006\u0005U\u00111LA0!\u0011\t9#!\u0018\u0005\u000f\u0005-rC1\u0001\u0002.A!\u0011qEA1\t\u001d\tyd\u0006b\u0001\u0003[Aq!!\u001a\u0018\u0001\u0004\tY&A\u0002lKfDq!!\u001b\u0018\u0001\u0004\ty&A\u0003wC2,X\rC\u0004\u0002n]\u0001\r!a\u001c\u0002\u000f!,\u0017\rZ3sgB1\u0011\u0011OA>\u0003\u0003sA!a\u001d\u0002x9\u00191-!\u001e\n\u0003\rJ1!!\u001f#\u0003\u001d\u0001\u0018mY6bO\u0016LA!! \u0002\u0000\t!A*[:u\u0015\r\tIH\t\t\u0006C\u0005\r\u0005\rY\u0005\u0004\u0003\u000b\u0013#A\u0002+va2,''\u0006\u0004\u0002\n\u0006=\u00151\u0013\u000b\u0007\u0003\u0017\u000b)*a&\u0011\u0011\u0005\u0015\u0011QCAG\u0003#\u0003B!a\n\u0002\u0010\u00129\u00111\u0006\rC\u0002\u00055\u0002\u0003BA\u0014\u0003'#q!a\u0010\u0019\u0005\u0004\ti\u0003C\u0004\u0002fa\u0001\r!!$\t\u000f\u0005%\u0004\u00041\u0001\u0002\u0012\u0002")
public class LineMessageReaderTest {
    private Properties defaultTestProps() {
        Properties props = new Properties();
        props.put("topic", "topic");
        props.put("parse.key", "true");
        props.put("parse.headers", "true");
        return props;
    }

    @Test
    public void testLineReader() {
        String input = "key0\tvalue0\nkey1\tvalue1";
        Properties props = this.defaultTestProps();
        props.put("parse.headers", "false");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key0", "value0"), this.record("key1", "value1")}));
    }

    @Test
    public void testLineReaderHeader() {
        String input = "headerKey0:headerValue0,headerKey1:headerValue1\tkey0\tvalue0\n";
        ProducerRecord<String, String> expected = this.record("key0", "value0", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey0"), (Object)"headerValue0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey1"), (Object)"headerValue1"), (List)Nil$.MODULE$)));
        this.runTest(this.defaultTestProps(), input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{expected}));
    }

    @Test
    public void testMinimalValidInputWithHeaderKeyAndValue() {
        this.runTest(this.defaultTestProps(), ":\t\t", (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("", "", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)""), (Object)""), (List)Nil$.MODULE$))}));
    }

    @Test
    public void testKeyMissingValue() {
        Properties props = this.defaultTestProps();
        props.put("parse.headers", "false");
        this.runTest(props, "key\t", (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key", "")}));
    }

    @Test
    public void testDemarcationsLongerThanOne() {
        Properties props = this.defaultTestProps();
        props.put("key.separator", "\t\t");
        props.put("headers.delimiter", "\t\t");
        props.put("headers.separator", "---");
        props.put("headers.key.separator", "::::");
        this.runTest(props, "headerKey0.0::::headerValue0.0---headerKey1.0::::\t\tkey\t\tvalue", (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key", "value", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey0.0"), (Object)"headerValue0.0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey1.0"), (Object)""), (List)Nil$.MODULE$)))}));
    }

    @Test
    public void testLineReaderHeaderNoKey() {
        String input = "headerKey:headerValue\tvalue\n";
        Properties props = this.defaultTestProps();
        props.put("parse.key", "false");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record(null, "value", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey"), (Object)"headerValue"), (List)Nil$.MODULE$))}));
    }

    @Test
    public void testLineReaderOnlyValue() {
        Properties props = this.defaultTestProps();
        props.put("parse.key", "false");
        props.put("parse.headers", "false");
        this.runTest(props, "value\n", (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record(null, "value")}));
    }

    @Test
    public void testParseHeaderEnabledWithCustomDelimiterAndVaryingNumberOfKeyValueHeaderPairs() {
        Properties props = this.defaultTestProps();
        props.put("key.separator", "#");
        props.put("headers.delimiter", "!");
        props.put("headers.separator", "&");
        props.put("headers.key.separator", ":");
        String input = "headerKey0.0:headerValue0.0&headerKey0.1:headerValue0.1!key0#value0\nheaderKey1.0:headerValue1.0!key1#value1";
        ProducerRecord<String, String> record0 = this.record("key0", "value0", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey0.0"), (Object)"headerValue0.0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey0.1"), (Object)"headerValue0.1"), (List)Nil$.MODULE$)));
        ProducerRecord<String, String> record1 = this.record("key1", "value1", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey1.0"), (Object)"headerValue1.0"), (List)Nil$.MODULE$));
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{record0, record1}));
    }

    @Test
    public void testMissingKeySeparator() {
        ConsoleProducer.LineMessageReader lineReader = new ConsoleProducer.LineMessageReader();
        String input = "headerKey0.0:headerValue0.0,headerKey0.1:headerValue0.1\tkey0\tvalue0\nheaderKey1.0:headerValue1.0\tkey1[MISSING-DELIMITER]value1";
        lineReader.configure((Map)this.defaultTestProps());
        Iterator iter = lineReader.readRecords((InputStream)new ByteArrayInputStream(input.getBytes()));
        iter.next();
        KafkaException expectedException = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> iter.next());
        Assertions.assertEquals((Object)"No key separator found on line number 2: 'headerKey1.0:headerValue1.0\tkey1[MISSING-DELIMITER]value1'", (Object)expectedException.getMessage());
    }

    @Test
    public void testMissingHeaderKeySeparator() {
        ConsoleProducer.LineMessageReader lineReader = new ConsoleProducer.LineMessageReader();
        String input = "key[MISSING-DELIMITER]val\tkey0\tvalue0\n";
        lineReader.configure((Map)this.defaultTestProps());
        Iterator iter = lineReader.readRecords((InputStream)new ByteArrayInputStream(input.getBytes()));
        KafkaException expectedException = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> iter.next());
        Assertions.assertEquals((Object)"No header key separator found in pair 'key[MISSING-DELIMITER]val' on line number 1", (Object)expectedException.getMessage());
    }

    @Test
    public void testHeaderDemarcationCollision() {
        Properties props = this.defaultTestProps();
        props.put("headers.delimiter", "\t");
        props.put("headers.separator", "\t");
        props.put("headers.key.separator", "\t");
        this.assertThrowsOnInvalidPatternConfig(props, "headers.delimiter and headers.separator may not be equal");
        props.put("headers.separator", ",");
        this.assertThrowsOnInvalidPatternConfig(props, "headers.delimiter and headers.key.separator may not be equal");
        props.put("headers.key.separator", ",");
        this.assertThrowsOnInvalidPatternConfig(props, "headers.separator and headers.key.separator may not be equal");
    }

    private void assertThrowsOnInvalidPatternConfig(Properties props, String expectedMessage) {
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> new ConsoleProducer.LineMessageReader().configure((Map)props));
        Assertions.assertEquals((Object)expectedMessage, (Object)exception.getMessage());
    }

    @Test
    public void testIgnoreErrorInInput() {
        String input = "headerKey0.0:headerValue0.0\tkey0\tvalue0\nheaderKey1.0:headerValue1.0,headerKey1.1:headerValue1.1[MISSING-HEADER-DELIMITER]key1\tvalue1\nheaderKey2.0:headerValue2.0\tkey2[MISSING-KEY-DELIMITER]value2\nheaderKey3.0:headerValue3.0[MISSING-HEADER-DELIMITER]key3[MISSING-KEY-DELIMITER]value3\n";
        Properties props = this.defaultTestProps();
        props.put("ignore.error", "true");
        ProducerRecord<String, String> validRecord = this.record("key0", "value0", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey0.0"), (Object)"headerValue0.0"), (List)Nil$.MODULE$));
        ProducerRecord<Object, String> missingHeaderDelimiter = this.record(null, "value1", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey1.0"), (Object)"headerValue1.0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey1.1"), (Object)"headerValue1.1[MISSING-HEADER-DELIMITER]key1"), (List)Nil$.MODULE$)));
        ProducerRecord<Object, String> missingKeyDelimiter = this.record(null, "key2[MISSING-KEY-DELIMITER]value2", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"headerKey2.0"), (Object)"headerValue2.0"), (List)Nil$.MODULE$));
        ProducerRecord<Object, String> missingKeyHeaderDelimiter = this.record(null, "headerKey3.0:headerValue3.0[MISSING-HEADER-DELIMITER]key3[MISSING-KEY-DELIMITER]value3", (List<Tuple2<String, String>>)Nil$.MODULE$);
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{validRecord, missingHeaderDelimiter, missingKeyDelimiter, missingKeyHeaderDelimiter}));
    }

    @Test
    public void testMalformedHeaderIgnoreError() {
        String input = "key-val\tkey0\tvalue0\n";
        Properties props = this.defaultTestProps();
        props.put("ignore.error", "true");
        ProducerRecord<String, String> expected = this.record("key0", "value0", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key-val"), null), (List)Nil$.MODULE$));
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{expected}));
    }

    @Test
    public void testNullMarker() {
        String input = "key\t\nkey\t<NULL>\nkey\t<NULL>value\n<NULL>\tvalue\n<NULL>\t<NULL>";
        Properties props = this.defaultTestProps();
        props.put("null.marker", "<NULL>");
        props.put("parse.headers", "false");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key", ""), this.record("key", null), this.record("key", "<NULL>value"), this.record(null, "value"), this.record(null, null)}));
        props.remove("null.marker");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key", ""), this.record("key", "<NULL>"), this.record("key", "<NULL>value"), this.record("<NULL>", "value"), this.record("<NULL>", "<NULL>")}));
    }

    @Test
    public void testNullMarkerWithHeaders() {
        String input = "h0:v0,h1:v1\t<NULL>\tvalue\n<NULL>\tkey\t<NULL>\nh0:,h1:v1\t<NULL>\t<NULL>\nh0:<NULL>,h1:v1\tkey\t<NULL>\nh0:<NULL>,h1:<NULL>value\tkey\t<NULL>\n";
        Tuple2 header = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h1"), (Object)"v1");
        Properties props = this.defaultTestProps();
        props.put("null.marker", "<NULL>");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record(null, "value", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)"v0"), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), this.record("key", null), this.record(null, null, (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)""), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), this.record("key", null, (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), null), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), this.record("key", null, (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), null), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h1"), (Object)"<NULL>value"), (List)Nil$.MODULE$)))}));
        ConsoleProducer.LineMessageReader lineReader = new ConsoleProducer.LineMessageReader();
        props.remove("null.marker");
        lineReader.configure((Map)props);
        Iterator iter = lineReader.readRecords((InputStream)new ByteArrayInputStream(input.getBytes()));
        this.assertRecordEquals(this.record("<NULL>", "value", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)"v0"), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()));
        KafkaException expectedException = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> iter.next());
        Assertions.assertEquals((Object)"No header key separator found in pair '<NULL>' on line number 2", (Object)expectedException.getMessage());
        this.assertRecordEquals(this.record("<NULL>", "<NULL>", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)""), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()));
        this.assertRecordEquals(this.record("key", "<NULL>", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)"<NULL>"), (List)new .colon.colon((Object)header, (List)Nil$.MODULE$))), (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()));
        this.assertRecordEquals(this.record("key", "<NULL>", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h0"), (Object)"<NULL>"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h1"), (Object)"<NULL>value"), (List)Nil$.MODULE$))), (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()));
    }

    @Test
    public void testNullMarkerHeaderKeyThrows() {
        String input = "<NULL>:v0,h1:v1\tkey\tvalue\n";
        Properties props = this.defaultTestProps();
        props.put("null.marker", "<NULL>");
        ConsoleProducer.LineMessageReader lineReader = new ConsoleProducer.LineMessageReader();
        lineReader.configure((Map)props);
        Iterator iter = lineReader.readRecords((InputStream)new ByteArrayInputStream(input.getBytes()));
        KafkaException expectedException = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> iter.next());
        Assertions.assertEquals((Object)"Header keys should not be equal to the null marker '<NULL>' as they can't be null", (Object)expectedException.getMessage());
        props.remove("null.marker");
        this.runTest(props, input, (Seq<ProducerRecord<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new ProducerRecord[]{this.record("key", "value", (List<Tuple2<String, String>>)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"<NULL>"), (Object)"v0"), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"h1"), (Object)"v1"), (List)Nil$.MODULE$)))}));
    }

    @Test
    public void testInvalidNullMarker() {
        Properties props = this.defaultTestProps();
        props.put("headers.delimiter", "-");
        props.put("headers.separator", ":");
        props.put("headers.key.separator", "/");
        props.put("null.marker", "-");
        this.assertThrowsOnInvalidPatternConfig(props, "null.marker and headers.delimiter may not be equal");
        props.put("null.marker", ":");
        this.assertThrowsOnInvalidPatternConfig(props, "null.marker and headers.separator may not be equal");
        props.put("null.marker", "/");
        this.assertThrowsOnInvalidPatternConfig(props, "null.marker and headers.key.separator may not be equal");
    }

    public void runTest(Properties props, String input, Seq<ProducerRecord<String, String>> expectedRecords) {
        ConsoleProducer.LineMessageReader lineReader = new ConsoleProducer.LineMessageReader();
        lineReader.configure((Map)props);
        Iterator iter = lineReader.readRecords((InputStream)new ByteArrayInputStream(input.getBytes()));
        expectedRecords.foreach((Function1 & Serializable & scala.Serializable)r -> {
            this.assertRecordEquals(r, (ProducerRecord<byte[], byte[]>)((ProducerRecord)iter.next()));
            return BoxedUnit.UNIT;
        });
        Assertions.assertFalse((boolean)iter.hasNext());
        Assertions.assertThrows(NoSuchElementException.class, () -> iter.next());
    }

    private <K, V> void assertRecordEquals(ProducerRecord<K, V> expected, ProducerRecord<byte[], byte[]> actual) {
        Assertions.assertEquals((Object)expected.key(), (Object)(actual.key() == null ? null : new String((byte[])actual.key())));
        Assertions.assertEquals((Object)expected.value(), (Object)(actual.value() == null ? null : new String((byte[])actual.value())));
        Assertions.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])expected.headers().toArray())).toList(), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])actual.headers().toArray())).toList());
    }

    private <K, V> ProducerRecord<K, V> record(K key, V value, List<Tuple2<String, String>> headers) {
        ProducerRecord record = new ProducerRecord("topic", key, value);
        headers.foreach((Function1 & Serializable & scala.Serializable)h -> record.headers().add((String)h._1(), h._2() != null ? ((String)h._2()).getBytes() : null));
        return record;
    }

    private <K, V> ProducerRecord<K, V> record(K key, V value) {
        return new ProducerRecord("topic", key, value);
    }
}

