/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.tools.StorageTool$;
import kafka.tools.TerseFailure;
import kafka.utils.TestUtils$;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import org.apache.kafka.common.metadata.UserScramCredentialRecord;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.metadata.bootstrap.BootstrapDirectory;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.PropertiesUtils;
import org.apache.kafka.metadata.storage.FormatterException;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.Features;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Timeout(value=40L)
@ScalaSignature(bytes="\u0006\u0001\tMb\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBQa\u0010\u0001\u0005\n\u0001Cq!\u0013\u0001C\u0002\u0013\u0005!\n\u0003\u0004`\u0001\u0001\u0006Ia\u0013\u0005\u0006A\u0002!\t!\u0019\u0005\u0006a\u0002!\t!\u0019\u0005\u0006e\u0002!\t!\u0019\u0005\u0006i\u0002!\t!\u0019\u0005\u0006m\u0002!\t!\u0019\u0005\u0006q\u0002!\t!\u0019\u0005\u0006u\u0002!\t!\u0019\u0005\by\u0002\u0011\r\u0011\"\u0001~\u0011\u0019q\b\u0001)A\u0005\u0003\"9q\u0010\u0001b\u0001\n\u0003i\bbBA\u0001\u0001\u0001\u0006I!\u0011\u0005\b\u0003\u0007\u0001A\u0011BA\u0003\u0011%\t\t\u0006AI\u0001\n\u0013\t\u0019\u0006C\u0005\u0002j\u0001\t\n\u0011\"\u0003\u0002l!1\u0011q\u000e\u0001\u0005\u0002\u0005Da!a\u001d\u0001\t\u0003\t\u0007BBA<\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002|\u0001!\t!\u0019\u0005\u0007\u0003\u007f\u0002A\u0011A1\t\r\u0005\r\u0005\u0001\"\u0001b\u0011\u0019\t9\t\u0001C\u0001C\"1\u00111\u0012\u0001\u0005\u0002\u0005Da!a$\u0001\t\u0003\t\u0007BBAJ\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002\u0018\u0002!\t!\u0019\u0005\u0007\u00037\u0003A\u0011A1\t\r\u0005}\u0005\u0001\"\u0001b\u0011\u0019\t\u0019\u000b\u0001C\u0001C\"9\u0011q\u0015\u0001\u0005\u0002\u0005%\u0006BBAj\u0001\u0011\u0005\u0011\rC\u0004\u0002X\u0002!\t!!7\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u00111 \u0001\u0005\u0002\u0005u\bB\u0002B\u0004\u0001\u0011\u0005\u0011\r\u0003\u0004\u0003\f\u0001!\t!\u0019\u0005\u0007\u0005\u001f\u0001A\u0011A1\t\r\tM\u0001\u0001\"\u0001b\u0011\u0019\u00119\u0002\u0001C\u0001C\"1!1\u0004\u0001\u0005\u0002\u0005DaAa\b\u0001\t\u0003\t\u0007B\u0002B\u0012\u0001\u0011\u0005\u0011MA\bTi>\u0014\u0018mZ3U_>dG+Z:u\u0015\t\u0001\u0014'A\u0003u_>d7OC\u00013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0003a\nQa]2bY\u0006L!AO\u001c\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\b\u0005\u0002?\u00015\tq&\u0001\roK^\u001cV\r\u001c4NC:\fw-\u001a3Qe>\u0004XM\u001d;jKN$\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005)\u0001&o\u001c9feRLWm]\u0001\fC2dg)Z1ukJ,7/F\u0001L!\rauJ\u0015\b\u0003m5K!AT\u001c\u0002\u000fA\f7m[1hK&\u0011\u0001+\u0015\u0002\u0005\u0019&\u001cHO\u0003\u0002OoA\u00111+X\u0007\u0002)*\u0011QKV\u0001\u0007G>lWn\u001c8\u000b\u0005]C\u0016AB:feZ,'O\u0003\u000233*\u0011!lW\u0001\u0007CB\f7\r[3\u000b\u0003q\u000b1a\u001c:h\u0013\tqFK\u0001\u0005GK\u0006$XO]3t\u00031\tG\u000e\u001c$fCR,(/Z:!\u0003i!Xm\u001d;D_:4\u0017n\u001a+p\u0019><G)\u001b:fGR|'/[3t)\u0005\u0011\u0007C\u0001\u001cd\u0013\t!wG\u0001\u0003V]&$\bFA\u0003g!\t9g.D\u0001i\u0015\tI'.A\u0002ba&T!a\u001b7\u0002\u000f),\b/\u001b;fe*\u0011QnW\u0001\u0006UVt\u0017\u000e^\u0005\u0003_\"\u0014A\u0001V3ti\u0006AC/Z:u\u0007>tg-[4U_2{w\rR5sK\u000e$xN]5fg^KG\u000f['fi\u0006dun\u001a#je\"\u0012aAZ\u0001 i\u0016\u001cH/\u00138g_\u000e{W.\\1oI>sW)\u001c9us\u0012K'/Z2u_JL\bFA\u0004g\u0003\u0005\"Xm\u001d;J]\u001a|7i\\7nC:$wJ\\'jgNLgn\u001a#je\u0016\u001cGo\u001c:zQ\tAa-\u0001\u0011uKN$\u0018J\u001c4p\u0007>lW.\u00198e\u001f:$\u0015N]3di>\u0014\u00180Q:GS2,\u0007FA\u0005g\u0003\u001d\"Xm\u001d;J]\u001a|w+\u001b;i\u001b&\u001cX.\u0019;dQ\u0016$G*Z4bGf\\\u0015MZ6b\u0007>tg-[4)\u0005)1\u0017!\t;fgRLeNZ8XSRDW*[:nCR\u001c\u0007.\u001a3L%\u00064GoQ8oM&<\u0007FA\u0006g\u0003u!WMZ1vYR\u001cF/\u0019;jGF+xN];n!J|\u0007/\u001a:uS\u0016\u001cX#A!\u0002=\u0011,g-Y;miN#\u0018\r^5d#V|'/^7Qe>\u0004XM\u001d;jKN\u0004\u0013A\b3fM\u0006,H\u000e\u001e#z]\u0006l\u0017nY)v_J,X\u000e\u0015:pa\u0016\u0014H/[3t\u0003}!WMZ1vYR$\u0015P\\1nS\u000e\fVo\u001c:v[B\u0013x\u000e]3si&,7\u000fI\u0001\u0011eVtgi\u001c:nCR\u001cu.\\7b]\u0012$\"\"a\u0002\u0002\u000e\u0005u\u0011\u0011EA$!\r1\u0014\u0011B\u0005\u0004\u0003\u00179$aA%oi\"9\u0011q\u0002\tA\u0002\u0005E\u0011AB:ue\u0016\fW\u000e\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\r\t9\"R\u0001\u0003S>LA!a\u0007\u0002\u0016\t)\")\u001f;f\u0003J\u0014\u0018-_(viB,Ho\u0015;sK\u0006l\u0007BBA\u0010!\u0001\u0007\u0011)\u0001\u0006qe>\u0004XM\u001d;jKND\u0011\"a\t\u0011!\u0003\u0005\r!!\n\u0002\u001d\u0015DHO]1Be\u001e,X.\u001a8ugB1\u0011qEA\u001a\u0003oq1!!\u000bN\u001d\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018g\u00051AH]8pizJ\u0011\u0001O\u0005\u0004\u0003k\t&aA*fcB!\u0011\u0011HA!\u001d\u0011\tY$!\u0010\u0011\u0007\u0005-r'C\u0002\u0002@]\na\u0001\u0015:fI\u00164\u0017\u0002BA\"\u0003\u000b\u0012aa\u0015;sS:<'bAA o!I\u0011\u0011\n\t\u0011\u0002\u0003\u0007\u00111J\u0001\u0010S\u001etwN]3G_Jl\u0017\r\u001e;fIB\u0019a'!\u0014\n\u0007\u0005=sGA\u0004C_>dW-\u00198\u00025I,hNR8s[\u0006$8i\\7nC:$G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005U#\u0006BA\u0013\u0003/Z#!!\u0017\u0011\t\u0005m\u0013QM\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003G:\u0014AC1o]>$\u0018\r^5p]&!\u0011qMA/\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001beVtgi\u001c:nCR\u001cu.\\7b]\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[RC!a\u0013\u0002X\u0005qC/Z:u\r>\u0014X.\u0019;Tk\u000e\u001cW-\u001a3t\u0013\u001a\fE\u000e\u001c#je\u0016\u001cGo\u001c:jKN\f%/Z!wC&d\u0017M\u00197fQ\t\u0019b-\u0001\u001auKN$hi\u001c:nCR\u001cVoY2fK\u0012\u001c\u0018JZ!u\u0019\u0016\f7\u000f^(oK\u0012K'/Z2u_JL\u0018j]!wC&d\u0017M\u00197fQ\t!b-A\u0011uKN$hi\u001c:nCR4\u0015-\u001b7t\u001f:\fEN]3bIf4uN]7biR,G\r\u000b\u0002\u0016M\u0006\u0019B/Z:u\u0013\u001etwN]3G_Jl\u0017\r\u001e;fI\"\u0012aCZ\u0001.i\u0016\u001cHOR8s[\u0006$h)Y5mg&3\u0017\t\u001c7ESJ,7\r^8sS\u0016\u001c\u0018I]3V]\u00064\u0018-\u001b7bE2,\u0007FA\fg\u0003]!Xm\u001d;G_Jl\u0017\r\u001e$bS2\u001c\u0018J\u001c.l\u001b>$W\r\u000b\u0002\u0019M\u0006aB/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>t\u0007FA\rg\u0003\u0015\"Xm\u001d;G_Jl\u0017\r^,ji\"\u0014V\r\\3bg\u00164VM]:j_:\f5OR3biV\u0014X\r\u000b\u0002\u001bM\u0006aB/Z:u\r>\u0014X.\u0019;XSRD\u0017J\u001c<bY&$g)Z1ukJ,\u0007FA\u000eg\u0003\u0019\"Xm\u001d;G_Jl\u0017\r^,ji\"LeN^1mS\u0012\\%+\u00194u-\u0016\u00148/[8o\u0019\u00164X\r\u001c\u0015\u00039\u0019\f1\u0006^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g.\u00118e\u0017J\u000bg\r\u001e,feNLwN\u001c\u0015\u0003;\u0019\f1\u0005^3ti\u001a{'/\\1u/&$\bNU3mK\u0006\u001cXMV3sg&|g\u000eR3gCVdG\u000f\u000b\u0002\u001fM\u0006!D/Z:u\r>\u0014X.\u0019;XSRD'+\u001a7fCN,g+\u001a:tS>tG)\u001a4bk2$\u0018I\u001c3SK2,\u0017m]3WKJ\u001c\u0018n\u001c8)\u0005}1\u0017!\u000b;fgR4uN]7bi^KG\u000f[*uC:$\u0017\r\\8oK\u001ac\u0017mZ(o\u0005J|7.\u001a:GC&d7\u000f\u000b\u0002!M\u0006aB/Z:u\r>\u0014X.\u0019;XSRD7\u000b^1oI\u0006dwN\\3GY\u0006<Gc\u00012\u0002,\"9\u0011QV\u0011A\u0002\u0005-\u0013AF:fi.\u0013\u0018M\u001a;WKJ\u001c\u0018n\u001c8GK\u0006$XO]3)\u000f\u0005\n\t,!1\u0002DB!\u00111WA_\u001b\t\t)L\u0003\u0003\u00028\u0006e\u0016\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005m&.\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u007f\u000b)LA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\t\u0005\u0015\u0017qY\r\u0002\u0001e\t\u0011\u0001K\u0002\"\u0003\u0017\u0004B!!4\u0002P6\u0011\u0011\u0011X\u0005\u0005\u0003#\fILA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\f!\b^3ti\u001a{'/\\1u/&$\bn\u0015;b]\u0012\fGn\u001c8f\r2\fw-\u00118e\u0013:LG/[1m\u0007>tGO]8mY\u0016\u00148O\u00127bO\u001a\u000b\u0017\u000e\\:)\u0005\t2\u0017\u0001\n;fgR4uN]7bi^KG\u000f[%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN4E.Y4\u0015\u0007\t\fY\u000eC\u0004\u0002.\u000e\u0002\r!a\u0013)\u000f\r\n\t,!1\u0002`2\"\u0011QYAdQ\r\u0019\u00131Z\u0001Hi\u0016\u001cHOR8s[\u0006$x+\u001b;i_V$8\u000b^1uS\u000e\fVo\u001c:v[\u001a\u000b\u0017\u000e\\:XSRDw.\u001e;J]&$\u0018.\u00197D_:$(o\u001c7mKJ\u001cxJ\\\"p]R\u0014x\u000e\u001c7feR\u0019!-a:\t\u000f\u0005%H\u00051\u0001\u00028\u0005a\u0001O]8dKN\u001c(k\u001c7fg\":A%!-\u0002n\u0006=\u0018aB:ue&twm\u001d\u0017\u0005\u0003c\f)0\t\u0002\u0002t\u0006Q1m\u001c8ue>dG.\u001a:\"\u0005\u0005]\u0018!\u00052s_.,'\u000fL2p]R\u0014x\u000e\u001c7fe\"\u001aA%a3\u0002mQ,7\u000f\u001e$pe6\fGoV5uQ:{\u0017J\\5uS\u0006d7i\u001c8ue>dG.\u001a:t'V\u001c7-Z3eg>s7i\u001c8ue>dG.\u001a:\u0015\u0007\t\fy\u0010C\u0004\u0002.\u0016\u0002\r!a\u0013)\u000f\u0015\n\t,!1\u0003\u00041\"\u0011QYAdQ\r)\u00131Z\u0001=i\u0016\u001cHOR8s[\u0006$x+\u001b;i\u001d>Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<\u0017I\u001c3Ti\u0006tG-\u00197p]\u00164E.Y4GC&d7\u000f\u000b\u0002'M\u0006!E/Z:u\r>\u0014X.\u0019;XSRDgj\\%oSRL\u0017\r\\\"p]R\u0014x\u000e\u001c7feN4E.Y4B]\u0012Le.\u001b;jC2\u001cuN\u001c;s_2dWM]:GY\u0006<g)Y5mg\"\u0012qEZ\u0001Gi\u0016\u001cHOR8s[\u0006$x+\u001b;i_V$8\u000b^1uS\u000e\fVo\u001c:v[N+8mY3fIN<\u0016\u000e\u001e5pkRLe.\u001b;jC2\u001cuN\u001c;s_2dWM]:P]\n\u0013xn[3sQ\tAc-A\ruKN$(i\\8ugR\u0014\u0018\r]*de\u0006l'+Z2pe\u0012\u001c\bFA\u0015g\u0003\u0005\"Xm\u001d;TGJ\fWNU3d_J$7o\u00147e%\u0016dW-Y:f-\u0016\u00148/[8oQ\tQc-A\u000buKN$\b+\u0019:tK:\u000bW.Z!oI2+g/\u001a7)\u0005-2\u0017!\t;fgR\u0004\u0016M]:f\u001d\u0006lW-\u00118e\u0019\u00164X\r\\,ji\"tu.R9vC2\u001c\bF\u0001\u0017g\u0003\u0005\"Xm\u001d;QCJ\u001cXMT1nK\u0006sG\rT3wK2<\u0016\u000e\u001e5O_:+XNY3sQ\tic\rK\u0004\u0001\u0005S\u0011yC!\r\u0011\u0007\u001d\u0014Y#C\u0002\u0003.!\u0014q\u0001V5nK>,H/A\u0003wC2,XMH\u0001)\u0001")
public class StorageToolTest {
    private final List<Features> allFeatures = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Features.FEATURES)).toList();
    private final Properties defaultStaticQuorumProperties = new Properties();
    private final Properties defaultDynamicQuorumProperties;

    private Properties newSelfManagedProperties() {
        Properties properties = new Properties();
        properties.setProperty("log.dirs", "/tmp/foo,/tmp/bar");
        properties.setProperty("process.roles", "controller");
        properties.setProperty("node.id", "2");
        properties.setProperty("controller.quorum.voters", "2@localhost:9092");
        properties.setProperty("controller.listener.names", "PLAINTEXT");
        return properties;
    }

    public List<Features> allFeatures() {
        return this.allFeatures;
    }

    @Test
    public void testConfigToLogDirectories() {
        KafkaConfig config = new KafkaConfig((Map)this.newSelfManagedProperties());
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$)), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testConfigToLogDirectoriesWithMetaLogDir() {
        Properties properties = this.newSelfManagedProperties();
        properties.setProperty("metadata.log.dir", "/tmp/baz");
        KafkaConfig config = new KafkaConfig((Map)properties);
        Assertions.assertEquals((Object)new .colon.colon((Object)"/tmp/bar", (List)new .colon.colon((Object)"/tmp/baz", (List)new .colon.colon((Object)"/tmp/foo", (List)Nil$.MODULE$))), (Object)StorageTool$.MODULE$.configToLogDirectories(config));
    }

    @Test
    public void testInfoCommandOnEmptyDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(62).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound problem:\n  ").append(tempDir.toString()).append(" is not formatted.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnMissingDirectory() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        tempDir.delete();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(34).append("Found problem:\n  ").append(tempDir.toString()).append(" does not exist\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoCommandOnDirectoryAsFile() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempFile = TestUtils$.MODULE$.tempFile();
        try {
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempFile.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(38).append("Found problem:\n  ").append(tempFile.toString()).append(" is not a directory\n\n").toString(), (Object)stream.toString());
        }
        finally {
            tempFile.delete();
        }
    }

    @Test
    public void testInfoWithMismatchedLegacyKafkaConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=1", "node.id=1", "cluster.id=XcZZOzUqS4yHOjhMQB6JLQ"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), false, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(246).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {cluster.id=XcZZOzUqS4yHOjhMQB6JLQ, node.id=1, version=1}\n\nFound problem:\n  The kafka configuration file appears to be for a legacy cluster, but the directories are formatted for a cluster in KRaft mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    @Test
    public void testInfoWithMismatchedKRaftConfig() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            Files.write(tempDir.toPath().resolve("meta.properties"), String.join((CharSequence)"\n", Arrays.asList((Object[])new String[]{"version=0", "broker.id=1", "cluster.id=26c36907-4158-4a35-919d-6534229f5241"})).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            Assertions.assertEquals((int)1, (int)StorageTool$.MODULE$.infoCommand(new PrintStream(stream), true, (Seq)new .colon.colon((Object)tempDir.toString(), (List)Nil$.MODULE$)));
            Assertions.assertEquals((Object)new StringBuilder(257).append("Found log directory:\n  ").append(tempDir.toString()).append("\n\nFound metadata: {broker.id=1, cluster.id=26c36907-4158-4a35-919d-6534229f5241, version=0}\n\nFound problem:\n  The kafka configuration file appears to be for a cluster in KRaft mode, but the directories are formatted for legacy mode.\n\n").toString(), (Object)stream.toString());
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    public Properties defaultStaticQuorumProperties() {
        return this.defaultStaticQuorumProperties;
    }

    public Properties defaultDynamicQuorumProperties() {
        return this.defaultDynamicQuorumProperties;
    }

    private int runFormatCommand(ByteArrayOutputStream stream, Properties properties, Seq<String> extraArguments, boolean ignoreFormatted) {
        int n;
        File tempDir = TestUtils$.MODULE$.tempDir();
        try {
            String configPathString = new File(tempDir.getAbsolutePath(), "format.props").toString();
            PropertiesUtils.writePropertiesFile((Properties)properties, (String)configPathString, (boolean)true);
            ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ"}));
            if (ignoreFormatted) {
                arguments.$plus$eq((Object)"--ignore-formatted");
            }
            arguments.$plus$eq((Object)"--config");
            arguments.$plus$eq((Object)configPathString);
            extraArguments.foreach((Function1 & Serializable & scala.Serializable)x$1 -> arguments.$plus$eq(x$1));
            n = StorageTool$.MODULE$.execute((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class)), new PrintStream(stream));
        }
        finally {
            Utils.delete((File)tempDir);
        }
        return n;
    }

    private Seq<String> runFormatCommand$default$3() {
        return Nil$.MODULE$;
    }

    private boolean runFormatCommand$default$4() {
        return false;
    }

    @Test
    public void testFormatSucceedsIfAllDirectoriesAreAvailable() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        ((IterableLike)availableDirs.tail()).foreach((Function1 & Serializable & scala.Serializable)dir -> {
            StorageToolTest.$anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(stream, dir);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFormatSucceedsIfAtLeastOneDirectoryIsAvailable() {
        File availableDir1 = TestUtils$.MODULE$.tempDir();
        File unavailableDir1 = TestUtils$.MODULE$.tempFile();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(availableDir1).append(",").append(unavailableDir1).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertFalse((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting log directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsOnAlreadyFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertTrue((boolean)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream2, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage().contains("already formatted. Use --ignore-formatted to ignore this directory and format the others"));
    }

    @Test
    public void testIgnoreFormatted() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$)));
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", String.valueOf(availableDirs.apply(0)));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream2 = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream2, properties, (Seq<String>)Nil$.MODULE$, true));
    }

    @Test
    public void testFormatFailsIfAllDirectoriesAreUnavailable() {
        File unavailableDir1 = TestUtils$.MODULE$.tempFile();
        File unavailableDir2 = TestUtils$.MODULE$.tempFile();
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", new StringBuilder(1).append(unavailableDir1).append(",").append(unavailableDir2).toString());
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"No available log directories to format.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir1}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("I/O error trying to read log directory %s. Ignoring...")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unavailableDir2}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatFailsInZkMode() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("zookeeper.connect", "localhost:2181");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((Object)"The kafka configuration file appears to be for a legacy cluster. Formatting is only supported for clusters in KRaft mode.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.8-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionAsFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"metadata.version=20", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.8-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithInvalidFeature() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Unsupported feature: non.existent.feature. Supported features are: kraft.version, transaction.version", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"non.existent.feature=20", (List)Nil$.MODULE$)), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithInvalidKRaftVersionLevel() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"No feature:kraft.version with feature level 999", (Object)Assertions.assertThrows(IllegalArgumentException.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=999", (List)new .colon.colon((Object)"--standalone", (List)Nil$.MODULE$))), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testFormatWithReleaseVersionAndKRaftVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.7-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefault() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, this.runFormatCommand$default$3(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.7-IV4"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithReleaseVersionDefaultAndReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        properties.setProperty("inter.broker.protocol.version", "3.7");
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.6-IV0", (List)new .colon.colon((Object)"--feature", (List)new .colon.colon((Object)"kraft.version=0", (List)Nil$.MODULE$)))), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains("3.6-IV0"), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagOnBrokerFails() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        Assertions.assertEquals((Object)"You can only use --standalone on a controller.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4())).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithStandaloneFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithStandaloneFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--standalone", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithInitialControllersFlag(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting dynamic metadata voter directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @ParameterizedTest
    @ValueSource(strings={"controller", "broker,controller"})
    public void testFormatWithoutStaticQuorumFailsWithoutInitialControllersOnController(String processRoles) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        if (processRoles.contains("broker")) {
            properties.setProperty("listeners", "PLAINTEXT://:9092,CONTROLLER://:9093");
            properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092,CONTROLLER://127.0.0.1:9093");
        }
        properties.setProperty("process.roles", processRoles);
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        Assertions.assertEquals((Object)"Because controller.quorum.voters is not set on this controller, you must specify one of the following: --standalone, --initial-controllers, or --no-initial-controllers.", (Object)Assertions.assertThrows(TerseFailure.class, () -> this.runFormatCommand(new ByteArrayOutputStream(), properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4())).getMessage());
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testFormatWithNoInitialControllersSucceedsOnController(boolean setKraftVersionFeature) {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--no-initial-controllers"}));
        if (setKraftVersionFeature) {
            arguments.$plus$eq((Object)"--feature");
            arguments.$plus$eq((Object)"kraft.version=1");
        }
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndStandaloneFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--standalone"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --standalone/-s: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithNoInitialControllersFlagAndInitialControllersFlagFails() {
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"format", "--cluster-id", "XcZZOzUqS4yHOjhMQB6JLQ", "--release-version", "3.9-IV0", "--no-initial-controllers", "--initial-controllers", "0@localhost:8020:K90IZ-0DRNazJ49kCZ1EMQ,1@localhost:8030:aUARLskQTCW4qCZDtS_cwA,2@localhost:8040:2ggvsS4kQb-fSJ_-zC_Ang"}));
        ArgumentParserException exception = (ArgumentParserException)Assertions.assertThrows(ArgumentParserException.class, () -> StorageTool$.MODULE$.parseArguments((String[])arguments.toArray(ClassTag$.MODULE$.apply(String.class))));
        Assertions.assertEquals((Object)"argument --initial-controllers/-I: not allowed with argument --no-initial-controllers/-N", (Object)exception.getMessage());
    }

    @Test
    public void testFormatWithoutStaticQuorumSucceedsWithoutInitialControllersOnBroker() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultDynamicQuorumProperties());
        properties.setProperty("listeners", "PLAINTEXT://:9092");
        properties.setProperty("advertised.listeners", "PLAINTEXT://127.0.0.1:9092");
        properties.setProperty("process.roles", "broker");
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)new .colon.colon((Object)"--release-version", (List)new .colon.colon((Object)"3.9-IV0", (List)Nil$.MODULE$)), this.runFormatCommand$default$4()));
        Assertions.assertTrue((boolean)stream.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting metadata directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{availableDirs.head()}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream.toString()).toString());
    }

    @Test
    public void testBootstrapScramRecords() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.9-IV0", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((int)0, (int)this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4()));
        BootstrapMetadata bootstrapMetadata = new BootstrapDirectory(((File)availableDirs.head()).toString(), Optional.empty()).read();
        List scramRecords = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(bootstrapMetadata.records()).asScala()).filter((Function1 & Serializable & scala.Serializable)apiMessageAndVersion -> BoxesRunTime.boxToBoolean((boolean)StorageToolTest.$anonfun$testBootstrapScramRecords$1(apiMessageAndVersion)))).map((Function1 & Serializable & scala.Serializable)apiMessageAndVersion -> (UserScramCredentialRecord)apiMessageAndVersion.message(), Buffer$.MODULE$.canBuildFrom())).toList();
        Assertions.assertEquals((int)2, (int)scramRecords.size());
        Assertions.assertEquals((Object)"alice", (Object)((UserScramCredentialRecord)scramRecords.head()).name());
        Assertions.assertEquals((Object)"bob", (Object)((UserScramCredentialRecord)scramRecords.last()).name());
    }

    @Test
    public void testScramRecordsOldReleaseVersion() {
        .colon.colon availableDirs = new .colon.colon((Object)TestUtils$.MODULE$.tempDir(), (List)Nil$.MODULE$);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.defaultStaticQuorumProperties());
        properties.setProperty("log.dirs", availableDirs.mkString(","));
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ListBuffer arguments = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"--release-version", "3.4", "--add-scram", "SCRAM-SHA-512=[name=alice,password=changeit]", "--add-scram", "SCRAM-SHA-512=[name=bob,password=changeit]"}));
        Assertions.assertEquals((Object)"SCRAM is only supported in metadata.version 3.5-IV2 or later.", (Object)Assertions.assertThrows(FormatterException.class, () -> this.runFormatCommand(stream, properties, (Seq<String>)arguments.toSeq(), this.runFormatCommand$default$4())).getMessage());
    }

    @Test
    public void testParseNameAndLevel() {
        Assertions.assertEquals((Object)new Tuple2((Object)"foo.bar", (Object)BoxesRunTime.boxToShort((short)((short)56))), (Object)StorageTool$.MODULE$.parseNameAndLevel("foo.bar=56"));
    }

    @Test
    public void testParseNameAndLevelWithNoEquals() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version5: equals sign not found.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version5")).getMessage());
    }

    @Test
    public void testParseNameAndLevelWithNoNumber() {
        Assertions.assertEquals((Object)"Can't parse feature=level string kraft.version=foo: unable to parse foo as a short.", (Object)Assertions.assertThrows(RuntimeException.class, () -> StorageTool$.MODULE$.parseNameAndLevel("kraft.version=foo")).getMessage());
    }

    public static final /* synthetic */ void $anonfun$testFormatSucceedsIfAllDirectoriesAreAvailable$1(ByteArrayOutputStream stream$1, File dir) {
        Assertions.assertTrue((boolean)stream$1.toString().contains(new StringOps(Predef$.MODULE$.augmentString("Formatting data directory %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dir}))), (String)new StringBuilder(34).append("Failed to find content in output: ").append(stream$1.toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testBootstrapScramRecords$1(ApiMessageAndVersion apiMessageAndVersion) {
        return apiMessageAndVersion.message() instanceof UserScramCredentialRecord;
    }

    public StorageToolTest() {
        this.defaultStaticQuorumProperties().setProperty("process.roles", "broker");
        this.defaultStaticQuorumProperties().setProperty("node.id", "0");
        this.defaultStaticQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultStaticQuorumProperties().setProperty("controller.quorum.voters", "100@localhost:9093");
        this.defaultDynamicQuorumProperties = new Properties();
        this.defaultDynamicQuorumProperties().setProperty("process.roles", "controller");
        this.defaultDynamicQuorumProperties().setProperty("node.id", "0");
        this.defaultDynamicQuorumProperties().setProperty("controller.listener.names", "CONTROLLER");
        this.defaultDynamicQuorumProperties().setProperty("controller.quorum.bootstrap.servers", "localhost:9093");
        this.defaultDynamicQuorumProperties().setProperty("listeners", "CONTROLLER://:9093");
        this.defaultDynamicQuorumProperties().setProperty("advertised.listeners", "CONTROLLER://127.0.0.1:9093");
        this.defaultDynamicQuorumProperties().setProperty("unstable.api.versions.enable", "true");
        this.defaultDynamicQuorumProperties().setProperty("unstable.feature.versions.enable", "true");
    }
}

