/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.InetAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.cluster.EndPoint;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.ControlPlaneAcceptor;
import kafka.network.ControlPlaneAcceptor$;
import kafka.network.DataPlaneAcceptor;
import kafka.network.DataPlaneAcceptor$;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.server.ApiVersionManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.security.CredentialProvider;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.FutureUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\reb\u0001\u0002%J\u00019C\u0001\"\u0019\u0001\u0003\u0006\u0004%\tA\u0019\u0005\tM\u0002\u0011\t\u0011)A\u0005G\"Aq\r\u0001BC\u0002\u0013\u0005\u0001\u000e\u0003\u0005v\u0001\t\u0005\t\u0015!\u0003j\u0011!1\bA!b\u0001\n\u00039\b\u0002C?\u0001\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0011y\u0004!Q1A\u0005\u0002}D!\"!\u0004\u0001\u0005\u0003\u0005\u000b\u0011BA\u0001\u0011)\ty\u0001\u0001BC\u0002\u0013\u0005\u0011\u0011\u0003\u0005\u000b\u00033\u0001!\u0011!Q\u0001\n\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\n\u0003[\u0001!\u0019!C\u0005\u0003_A\u0001\"!\u0010\u0001A\u0003%\u0011\u0011\u0007\u0005\n\u0003\u007f\u0001!\u0019!C\u0005\u0003\u0003B\u0001\"a\u0015\u0001A\u0003%\u00111\t\u0005\n\u0003+\u0002!\u0019!C\t\u0003/B\u0001\"a\u0018\u0001A\u0003%\u0011\u0011\f\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003GB\u0001\"a\u001b\u0001A\u0003%\u0011Q\r\u0005\n\u0003[\u0002!\u0019!C\u0005\u0003_B\u0001\"a\u001e\u0001A\u0003%\u0011\u0011\u000f\u0005\n\u0003s\u0002!\u0019!C\u0005\u0003wB\u0001\"!\"\u0001A\u0003%\u0011Q\u0010\u0005\n\u0003\u000f\u0003!\u0019!C\u0005\u0003wB\u0001\"!#\u0001A\u0003%\u0011Q\u0010\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001bC\u0001\"a'\u0001A\u0003%\u0011q\u0012\u0005\u000b\u0003;\u0003!\u0019!C\u0001\u0013\u0006}\u0005\u0002CAb\u0001\u0001\u0006I!!)\t\u0013\u0005\u0015\u0007A1A\u0005\u0002\u0005\u001d\u0007\u0002CAh\u0001\u0001\u0006I!!3\t\u0015\u0005E\u0007\u00011A\u0005\u0002%\u000b\u0019\u000e\u0003\u0006\u0002b\u0002\u0001\r\u0011\"\u0001J\u0003GD\u0001\"a<\u0001A\u0003&\u0011Q\u001b\u0005\n\u0003c\u0004!\u0019!C\u0001\u0003gD\u0001\"a>\u0001A\u0003%\u0011Q\u001f\u0005\t\u0003s\u0004\u0001\u0015!\u0003\u0002|\"I!q\u0001\u0001C\u0002\u0013\u0005!\u0011\u0002\u0005\t\u0005#\u0001\u0001\u0015!\u0003\u0003\f!I!1\u0003\u0001C\u0002\u0013%!Q\u0003\u0005\t\u0005G\u0001\u0001\u0015!\u0003\u0003\u0018!I!Q\u0005\u0001A\u0002\u0013%!q\u0005\u0005\n\u0005_\u0001\u0001\u0019!C\u0005\u0005cA\u0001B!\u000e\u0001A\u0003&!\u0011\u0006\u0005\b\u0003s\u0004A\u0011\u0001B\u001c\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005wAqAa\u0015\u0001\t\u0013\u0011)\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t\u0005\u0004\u0001\"\u0003\u0003d!9!\u0011\u0010\u0001\u0005\u0012\tm\u0004b\u0002BE\u0001\u0011%!1\u0012\u0005\b\u0005#\u0003A\u0011\u0001BJ\u0011\u001d\u0011)\n\u0001C\u0001\u0005'CqAa&\u0001\t\u0003\u0011I\nC\u0004\u0003 \u0002!\tA!)\t\u000f\t5\u0006\u0001\"\u0001\u00030\"9!Q\u0017\u0001\u0005B\t]\u0006b\u0002Bk\u0001\u0011\u0005#q\u001b\u0005\b\u0005;\u0004A\u0011\tBp\u0011!\u00119\u000f\u0001C\u0001\u0013\n%\bb\u0002B~\u0001\u0011\u0005!Q`\u0004\b\u0007\u0007I\u0005\u0012AB\u0003\r\u0019A\u0015\n#\u0001\u0004\b!9\u00111D \u0005\u0002\r%\u0001\"CB\u0006\u007f\t\u0007I\u0011AB\u0007\u0011!\u0019\u0019b\u0010Q\u0001\n\r=\u0001\"CB\u000b\u007f\t\u0007I\u0011\u0001B\\\u0011!\u00199b\u0010Q\u0001\n\te\u0006\"CB\r\u007f\t\u0007I\u0011\u0001B\\\u0011!\u0019Yb\u0010Q\u0001\n\te\u0006bBB\u000f\u007f\u0011\u00051q\u0004\u0002\r'>\u001c7.\u001a;TKJ4XM\u001d\u0006\u0003\u0015.\u000bqA\\3uo>\u00148NC\u0001M\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001A(V7B\u0011\u0001kU\u0007\u0002#*\t!+A\u0003tG\u0006d\u0017-\u0003\u0002U#\n1\u0011I\\=SK\u001a\u0004\"AV-\u000e\u0003]S!\u0001W&\u0002\u000bU$\u0018\u000e\\:\n\u0005i;&a\u0002'pO\u001eLgn\u001a\t\u00039~k\u0011!\u0018\u0006\u0003=.\u000baa]3sm\u0016\u0014\u0018B\u00011^\u0005Q\u0011%o\\6feJ+7m\u001c8gS\u001e,(/\u00192mK\u000611m\u001c8gS\u001e,\u0012a\u0019\t\u00039\u0012L!!Z/\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003\u001diW\r\u001e:jGN,\u0012!\u001b\t\u0003UNl\u0011a\u001b\u0006\u0003O2T!!\u001c8\u0002\r\r|W.\\8o\u0015\tauN\u0003\u0002qc\u00061\u0011\r]1dQ\u0016T\u0011A]\u0001\u0004_J<\u0017B\u0001;l\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u0005i&lW-F\u0001y!\tI80D\u0001{\u0015\tAF.\u0003\u0002}u\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003I\u0019'/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\u0016\u0005\u0005\u0005\u0001\u0003BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001da.\u0001\u0005tK\u000e,(/\u001b;z\u0013\u0011\tY!!\u0002\u0003%\r\u0013X\rZ3oi&\fG\u000e\u0015:pm&$WM]\u0001\u0014GJ,G-\u001a8uS\u0006d\u0007K]8wS\u0012,'\u000fI\u0001\u0012CBLg+\u001a:tS>tW*\u00198bO\u0016\u0014XCAA\n!\ra\u0016QC\u0005\u0004\u0003/i&!E!qSZ+'o]5p]6\u000bg.Y4fe\u0006\u0011\u0012\r]5WKJ\u001c\u0018n\u001c8NC:\fw-\u001a:!\u0003\u0019a\u0014N\\5u}Qa\u0011qDA\u0012\u0003K\t9#!\u000b\u0002,A\u0019\u0011\u0011\u0005\u0001\u000e\u0003%CQ!Y\u0006A\u0002\rDQaZ\u0006A\u0002%DQA^\u0006A\u0002aDaA`\u0006A\u0002\u0005\u0005\u0001bBA\b\u0017\u0001\u0007\u00111C\u0001\r[\u0016$(/[2t\u000fJ|W\u000f]\u000b\u0003\u0003c\u0001B!a\r\u0002:5\u0011\u0011Q\u0007\u0006\u0004O\u0006]\"B\u00010o\u0013\u0011\tY$!\u000e\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cXCAA\"!\u0011\t)%a\u0014\u000e\u0005\u0005\u001d#\u0002BA%\u0003\u0017\nA\u0001\\1oO*\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u001d#aB%oi\u0016<WM]\u0001\u0013[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001c\b%\u0001\u0004o_\u0012,\u0017\nZ\u000b\u0003\u00033\u00022\u0001UA.\u0013\r\ti&\u0015\u0002\u0004\u0013:$\u0018a\u00028pI\u0016LE\rI\u0001\u000bY><7i\u001c8uKb$XCAA3!\rI\u0018qM\u0005\u0004\u0003SR(A\u0003'pO\u000e{g\u000e^3yi\u0006YAn\\4D_:$X\r\u001f;!\u0003AiW-\\8ssB{w\u000e\\*f]N|'/\u0006\u0002\u0002rA\u0019!.a\u001d\n\u0007\u0005U4N\u0001\u0004TK:\u001cxN]\u0001\u0012[\u0016lwN]=Q_>d7+\u001a8t_J\u0004\u0013aI7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012\u0004VM]2f]RlU\r\u001e:jG:\u000bW.Z\u000b\u0003\u0003{\u0002B!a \u0002\u00026\tA.C\u0002\u0002\u00042\u0014!\"T3ue&\u001cg*Y7f\u0003\u0011jW-\\8ssB{w\u000e\u001c#fa2,G/\u001a3QKJ\u001cWM\u001c;NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0013\u0001I7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\f\u0011%\\3n_JL\bk\\8m\t\u0016\u0004H.\u001a;fIRKW.Z'fiJL7MT1nK\u0002\n!\"\\3n_JL\bk\\8m+\t\ty\t\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)\n\\\u0001\u0007[\u0016lwN]=\n\t\u0005e\u00151\u0013\u0002\u000b\u001b\u0016lwN]=Q_>d\u0017aC7f[>\u0014\u0018\u0010U8pY\u0002\n!\u0003Z1uCBc\u0017M\\3BG\u000e,\u0007\u000f^8sgV\u0011\u0011\u0011\u0015\t\t\u0003G\u000bi+!-\u0002>6\u0011\u0011Q\u0015\u0006\u0005\u0003O\u000bI+\u0001\u0006d_:\u001cWO\u001d:f]RTA!a+\u0002L\u0005!Q\u000f^5m\u0013\u0011\ty+!*\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0003\u00024\u0006eVBAA[\u0015\r\t9lS\u0001\bG2,8\u000f^3s\u0013\u0011\tY,!.\u0003\u0011\u0015sG\rU8j]R\u0004B!!\t\u0002@&\u0019\u0011\u0011Y%\u0003#\u0011\u000bG/\u0019)mC:,\u0017iY2faR|'/A\neCR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J\u001c\b%A\feCR\f\u0007\u000b\\1oKJ+\u0017/^3ti\u000eC\u0017M\u001c8fYV\u0011\u0011\u0011\u001a\t\u0005\u0003C\tY-C\u0002\u0002N&\u0013aBU3rk\u0016\u001cHo\u00115b]:,G.\u0001\reCR\f\u0007\u000b\\1oKJ+\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nqcY8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014x\n\u001d;\u0016\u0005\u0005U\u0007#\u0002)\u0002X\u0006m\u0017bAAm#\n1q\n\u001d;j_:\u0004B!!\t\u0002^&\u0019\u0011q\\%\u0003)\r{g\u000e\u001e:pYBc\u0017M\\3BG\u000e,\u0007\u000f^8s\u0003m\u0019wN\u001c;s_2\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;pe>\u0003Ho\u0018\u0013fcR!\u0011Q]Av!\r\u0001\u0016q]\u0005\u0004\u0003S\f&\u0001B+oSRD\u0011\"!<\"\u0003\u0003\u0005\r!!6\u0002\u0007a$\u0013'\u0001\rd_:$(o\u001c7QY\u0006tW-Q2dKB$xN](qi\u0002\nQdY8oiJ|G\u000e\u00157b]\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2|\u0005\u000f^\u000b\u0003\u0003k\u0004R\u0001UAl\u0003\u0013\fadY8oiJ|G\u000e\u00157b]\u0016\u0014V-];fgR\u001c\u0005.\u00198oK2|\u0005\u000f\u001e\u0011\u0002\u001f9,\u0007\u0010\u001e)s_\u000e,7o]8s\u0013\u0012\u0004B!!@\u0003\u00045\u0011\u0011q \u0006\u0005\u0005\u0003\t)+\u0001\u0004bi>l\u0017nY\u0005\u0005\u0005\u000b\tyPA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\u0011G>tg.Z2uS>t\u0017+^8uCN,\"Aa\u0003\u0011\t\u0005\u0005\"QB\u0005\u0004\u0005\u001fI%\u0001E\"p]:,7\r^5p]F+x\u000e^1t\u0003E\u0019wN\u001c8fGRLwN\\)v_R\f7\u000fI\u0001\u001dC2d\u0017)\u001e;i_JL'0\u001a:GkR,(/Z:D_6\u0004H.\u001a;f+\t\u00119\u0002\u0005\u0004\u0002$\ne!QD\u0005\u0005\u00057\t)KA\tD_6\u0004H.\u001a;bE2,g)\u001e;ve\u0016\u0004B!!\u0012\u0003 %!!\u0011EA$\u0005\u00111v.\u001b3\u0002;\u0005dG.Q;uQ>\u0014\u0018N_3s\rV$XO]3t\u0007>l\u0007\u000f\\3uK\u0002\nqa\u001d;paB,G-\u0006\u0002\u0003*A\u0019\u0001Ka\u000b\n\u0007\t5\u0012KA\u0004C_>dW-\u00198\u0002\u0017M$x\u000e\u001d9fI~#S-\u001d\u000b\u0005\u0003K\u0014\u0019\u0004C\u0005\u0002n.\n\t\u00111\u0001\u0003*\u0005A1\u000f^8qa\u0016$\u0007\u0005\u0006\u0002\u0002Z\u00059RM\\1cY\u0016\u0014V-];fgR\u0004&o\\2fgNLgn\u001a\u000b\u0005\u0005/\u0011i\u0004C\u0004\u0003@9\u0002\rA!\u0011\u0002#\u0005,H\u000f[8sSj,'OR;ukJ,7\u000f\u0005\u0005\u0003D\t%#Q\nB\f\u001b\t\u0011)EC\u0002\u0003HE\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YE!\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0000\t=\u0013b\u0001B)Y\nAQI\u001c3q_&tG/\u0001\u0013de\u0016\fG/\u001a#bi\u0006\u0004F.\u00198f\u0003\u000e\u001cW\r\u001d;pe\u0006sG\r\u0015:pG\u0016\u001c8o\u001c:t)\u0011\t)Oa\u0016\t\u000f\tes\u00061\u0001\u00022\u0006AQM\u001c3q_&tG/\u0001\u0014de\u0016\fG/Z\"p]R\u0014x\u000e\u001c)mC:,\u0017iY2faR|'/\u00118e!J|7-Z:t_J$B!!:\u0003`!9!\u0011\f\u0019A\u0002\u0005E\u0016!C3oIB|\u0017N\u001c;t+\t\u0011)\u0007\u0005\u0005\u0003h\t5$qNAY\u001b\t\u0011IG\u0003\u0003\u0003l\t\u0015\u0013!C5n[V$\u0018M\u00197f\u0013\u0011\u0011YE!\u001b\u0011\t\tE$QO\u0007\u0003\u0005gR!A\u00137\n\t\t]$1\u000f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0018GJ,\u0017\r^3ECR\f\u0007\u000b\\1oK\u0006\u001b7-\u001a9u_J$\u0002\"!0\u0003~\t\u0005%Q\u0011\u0005\b\u0005\u007f\u0012\u0004\u0019AAY\u0003!)g\u000e\u001a)pS:$\bb\u0002BBe\u0001\u0007!\u0011F\u0001\u0015SN\u0004&/\u001b<jY\u0016<W\r\u001a'jgR,g.\u001a:\t\u000f\t\u001d%\u00071\u0001\u0002J\u0006q!/Z9vKN$8\t[1o]\u0016d\u0017AG2sK\u0006$XmQ8oiJ|G\u000e\u00157b]\u0016\f5mY3qi>\u0014HCBAn\u0005\u001b\u0013y\tC\u0004\u0003\u0000M\u0002\r!!-\t\u000f\t\u001d5\u00071\u0001\u0002J\u000612\u000f^8q!J|7-Z:tS:<'+Z9vKN$8\u000f\u0006\u0002\u0002f\u0006A1\u000f[;uI><h.A\u0005c_VtG\rU8siR!\u0011\u0011\fBN\u0011\u001d\u0011iJ\u000ea\u0001\u0005_\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\fA\"\u00193e\u0019&\u001cH/\u001a8feN$B!!:\u0003$\"9!QU\u001cA\u0002\t\u001d\u0016A\u00047jgR,g.\u001a:t\u0003\u0012$W\r\u001a\t\u0007\u0005\u0007\u0012I+!-\n\t\t-&Q\t\u0002\u0004'\u0016\f\u0018a\u0004:f[>4X\rT5ti\u0016tWM]:\u0015\t\u0005\u0015(\u0011\u0017\u0005\b\u0005gC\u0004\u0019\u0001BT\u0003Aa\u0017n\u001d;f]\u0016\u00148OU3n_Z,G-A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0016\u0005\te\u0006C\u0002B\"\u0005w\u0013y,\u0003\u0003\u0003>\n\u0015#aA*fiB!!\u0011\u0019Bh\u001d\u0011\u0011\u0019Ma3\u0011\u0007\t\u0015\u0017+\u0004\u0002\u0003H*\u0019!\u0011Z'\u0002\rq\u0012xn\u001c;?\u0013\r\u0011i-U\u0001\u0007!J,G-\u001a4\n\t\tE'1\u001b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\t5\u0017+A\fwC2LG-\u0019;f%\u0016\u001cwN\u001c4jOV\u0014\u0018\r^5p]R!\u0011Q\u001dBm\u0011\u0019\u0011YN\u000fa\u0001G\u0006Ia.Z<D_:4\u0017nZ\u0001\fe\u0016\u001cwN\u001c4jOV\u0014X\r\u0006\u0004\u0002f\n\u0005(Q\u001d\u0005\u0007\u0005G\\\u0004\u0019A2\u0002\u0013=dGmQ8oM&<\u0007B\u0002Bnw\u0001\u00071-A\bd_:tWm\u0019;j_:\u001cu.\u001e8u)\u0011\tIFa;\t\u000f\t5H\b1\u0001\u0003p\u00069\u0011\r\u001a3sKN\u001c\b\u0003\u0002By\u0005ol!Aa=\u000b\t\tU\u00181J\u0001\u0004]\u0016$\u0018\u0002\u0002B}\u0005g\u00141\"\u00138fi\u0006#GM]3tg\u0006\tB-\u0019;b!2\fg.Z!dG\u0016\u0004Ho\u001c:\u0015\t\t}8\u0011\u0001\t\u0006!\u0006]\u0017Q\u0018\u0005\b\u0005;k\u0004\u0019\u0001B`\u00031\u0019vnY6fiN+'O^3s!\r\t\tcP\n\u0003\u007f=#\"a!\u0002\u0002\u00195+GO]5dg\u001e\u0013x.\u001e9\u0016\u0005\r=\u0001\u0003BA#\u0007#IAA!5\u0002H\u0005iQ*\u001a;sS\u000e\u001cxI]8va\u0002\nQCU3d_:4\u0017nZ;sC\ndWmQ8oM&<7/\u0001\fSK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u0003ua\u0015n\u001d;f]\u0016\u0014(+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\u0018A\b'jgR,g.\u001a:SK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:!\u0003-\u0019Gn\\:f'>\u001c7.\u001a;\u0015\r\u0005\u00158\u0011EB\u001b\u0011\u001d\u0019\u0019c\u0012a\u0001\u0007K\tqa\u00195b]:,G\u000e\u0005\u0003\u0004(\rERBAB\u0015\u0015\u0011\u0019Yc!\f\u0002\u0011\rD\u0017M\u001c8fYNTAaa\f\u0002L\u0005\u0019a.[8\n\t\rM2\u0011\u0006\u0002\u000e'>\u001c7.\u001a;DQ\u0006tg.\u001a7\t\r\r]r\t1\u0001V\u0003\u001dawnZ4j]\u001e\u0004")
public class SocketServer
implements Logging,
BrokerReconfigurable {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final ApiVersionManager apiVersionManager;
    private final KafkaMetricsGroup metricsGroup;
    private final Integer maxQueuedRequests;
    private final int nodeId;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool memoryPool;
    private final ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors;
    private final RequestChannel dataPlaneRequestChannel;
    private Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt;
    private final Option<RequestChannel> controlPlaneRequestChannelOpt;
    private final AtomicInteger nextProcessorId;
    private final ConnectionQuotas connectionQuotas;
    private final CompletableFuture<Void> allAuthorizerFuturesComplete;
    private boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void closeSocket(SocketChannel socketChannel, Logging logging) {
        SocketServer$.MODULE$.closeSocket(socketChannel, logging);
    }

    public static Set<String> ListenerReconfigurableConfigs() {
        return SocketServer$.MODULE$.ListenerReconfigurableConfigs();
    }

    public static Set<String> ReconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    public static String MetricsGroup() {
        return SocketServer$.MODULE$.MetricsGroup();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public ApiVersionManager apiVersionManager() {
        return this.apiVersionManager;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public int nodeId() {
        return this.nodeId;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    private MemoryPool memoryPool() {
        return this.memoryPool;
    }

    public ConcurrentHashMap<EndPoint, DataPlaneAcceptor> dataPlaneAcceptors() {
        return this.dataPlaneAcceptors;
    }

    public RequestChannel dataPlaneRequestChannel() {
        return this.dataPlaneRequestChannel;
    }

    public Option<ControlPlaneAcceptor> controlPlaneAcceptorOpt() {
        return this.controlPlaneAcceptorOpt;
    }

    public void controlPlaneAcceptorOpt_$eq(Option<ControlPlaneAcceptor> x$1) {
        this.controlPlaneAcceptorOpt = x$1;
    }

    public Option<RequestChannel> controlPlaneRequestChannelOpt() {
        return this.controlPlaneRequestChannelOpt;
    }

    public ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private CompletableFuture<Void> allAuthorizerFuturesComplete() {
        return this.allAuthorizerFuturesComplete;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    public int nextProcessorId() {
        return this.nextProcessorId.getAndIncrement();
    }

    public synchronized CompletableFuture<Void> enableRequestProcessing(Map<Endpoint, CompletableFuture<Void>> authorizerFutures) {
        if (this.stopped()) {
            throw new RuntimeException("Can't enable request processing: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Enabling request processing.");
        this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)acceptor -> {
            this.chainAcceptorFuture$1(acceptor, authorizerFutures);
            return BoxedUnit.UNIT;
        });
        this.dataPlaneAcceptors().values().forEach(acceptor -> this.chainAcceptorFuture$1((Acceptor)acceptor, (Map)authorizerFutures));
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])authorizerFutures.values().toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), this.allAuthorizerFuturesComplete());
        Seq allAcceptors = (Seq)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.dataPlaneAcceptors().values()).asScala()).toSeq().$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.controlPlaneAcceptorOpt()), Seq$.MODULE$.canBuildFrom());
        CompletableFuture<Void> enableFuture = new CompletableFuture<Void>();
        FutureUtils.chainFuture(CompletableFuture.allOf((CompletableFuture[])((TraversableOnce)allAcceptors.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.startedFuture(), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(CompletableFuture.class))), enableFuture);
        return enableFuture;
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void createDataPlaneAcceptorAndProcessors(EndPoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new data plane acceptor and processors: SocketServer is stopped.");
        }
        parsedConfigs = this.config().valuesFromThisConfigWithPrefixOverride(endpoint.listenerName().configPrefix());
        this.connectionQuotas().addListener(this.config(), endpoint.listenerName());
        if (!this.controlPlaneRequestChannelOpt().isEmpty()) ** GOTO lbl-1000
        v0 = this.config().interBrokerListenerName();
        var4_3 = endpoint.listenerName();
        if (!(v0 != null ? v0.equals(var4_3) == false : var4_3 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        isPrivilegedListener = v1;
        dataPlaneAcceptor = this.createDataPlaneAcceptor(endpoint, isPrivilegedListener, this.dataPlaneRequestChannel());
        this.config().addReconfigurable((Reconfigurable)dataPlaneAcceptor);
        dataPlaneAcceptor.configure(parsedConfigs);
        this.dataPlaneAcceptors().put(endpoint, dataPlaneAcceptor);
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$createDataPlaneAcceptorAndProcessors$1(kafka.cluster.EndPoint ), ()Ljava/lang/String;)((EndPoint)endpoint));
    }

    private synchronized void createControlPlaneAcceptorAndProcessor(EndPoint endpoint) {
        if (this.stopped()) {
            throw new RuntimeException("Can't create new control plane acceptor and processor: SocketServer is stopped.");
        }
        this.connectionQuotas().addListener(this.config(), endpoint.listenerName());
        ControlPlaneAcceptor controlPlaneAcceptor = this.createControlPlaneAcceptor(endpoint, (RequestChannel)this.controlPlaneRequestChannelOpt().get());
        controlPlaneAcceptor.addProcessors(1);
        this.controlPlaneAcceptorOpt_$eq((Option<ControlPlaneAcceptor>)new Some((Object)controlPlaneAcceptor));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(60).append("Created control-plane acceptor and processor for endpoint : ").append(endpoint.listenerName()).toString());
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((TraversableOnce)this.config().listeners().map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public DataPlaneAcceptor createDataPlaneAcceptor(EndPoint endPoint, boolean isPrivilegedListener, RequestChannel requestChannel) {
        return new DataPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), isPrivilegedListener, requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    private ControlPlaneAcceptor createControlPlaneAcceptor(EndPoint endPoint, RequestChannel requestChannel) {
        return new ControlPlaneAcceptor(this, endPoint, this.config(), this.nodeId(), this.connectionQuotas(), this.time(), requestChannel, this.metrics(), this.credentialProvider(), this.logContext(), this.memoryPool(), this.apiVersionManager());
    }

    public synchronized void stopProcessingRequests() {
        if (!this.stopped()) {
            this.stopped_$eq(true);
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping socket server request processors");
            ((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.beginShutdown();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.beginShutdown();
                return BoxedUnit.UNIT;
            });
            ((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
                x$6.close();
                return BoxedUnit.UNIT;
            });
            this.controlPlaneAcceptorOpt().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
                x$7.close();
                return BoxedUnit.UNIT;
            });
            this.dataPlaneRequestChannel().clear();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.clear();
                return BoxedUnit.UNIT;
            });
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped socket server request processors");
            return;
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down socket server");
        this.allAuthorizerFuturesComplete().completeExceptionally(new TimeoutException("The socket server was shut down before the Authorizer could be completely initialized."));
        synchronized (this) {
            this.stopProcessingRequests();
            this.dataPlaneRequestChannel().shutdown();
            this.controlPlaneRequestChannelOpt().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
                x$9.shutdown();
                return BoxedUnit.UNIT;
            });
            this.connectionQuotas().close();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(this.endpoints().apply((Object)listenerName));
            if (acceptor == null) {
                return BoxesRunTime.unboxToInt((Object)this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.localPort())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new KafkaException(new StringBuilder(61).append("Could not find listenerName : ").append(listenerName).append(" in data-plane or control-plane").toString());
                }));
            }
            n = acceptor.localPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check for port of non-existing protocol", (Throwable)e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        if (this.stopped()) {
            throw new RuntimeException("can't add new listeners: SocketServer is stopped.");
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Adding data-plane listeners for endpoints ").append(listenersAdded).toString());
        listenersAdded.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors((EndPoint)endpoint);
            DataPlaneAcceptor acceptor = this.dataPlaneAcceptors().get(endpoint);
            return this.allAuthorizerFuturesComplete().whenComplete((x$11, e) -> {
                if (e != null) {
                    acceptor.startedFuture().completeExceptionally((Throwable)e);
                    return;
                }
                acceptor.start();
            });
        });
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Removing data-plane listeners for endpoints ").append(listenersRemoved).toString());
        listenersRemoved.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SocketServer$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        Integer maxConnectionRate;
        Integer maxConnections;
        Map<String, Object> maxConnectionsPerIpOverrides;
        Integer maxConnectionsPerIp;
        Integer n = maxConnectionsPerIp = newConfig.maxConnectionsPerIp();
        Integer n2 = oldConfig.maxConnectionsPerIp();
        if (n == null ? n2 != null : !((Object)n).equals(n2)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Updating maxConnectionsPerIp: ").append(maxConnectionsPerIp).toString());
            this.connectionQuotas().updateMaxConnectionsPerIp(Predef$.MODULE$.Integer2int(maxConnectionsPerIp));
        }
        Map<String, Object> map = maxConnectionsPerIpOverrides = newConfig.maxConnectionsPerIpOverrides();
        Map<String, Object> map2 = oldConfig.maxConnectionsPerIpOverrides();
        if (map == null ? map2 != null : !map.equals(map2)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Updating maxConnectionsPerIpOverrides: ").append(((TraversableOnce)maxConnectionsPerIpOverrides.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 != null) {
                    String k = (String)x0$1._1();
                    int v = x0$1._2$mcI$sp();
                    return new StringBuilder(1).append(k).append("=").append(v).toString();
                }
                throw new MatchError(null);
            }, Iterable$.MODULE$.canBuildFrom())).mkString(",")).toString());
            this.connectionQuotas().updateMaxConnectionsPerIpOverride(maxConnectionsPerIpOverrides);
        }
        Integer n3 = maxConnections = newConfig.maxConnections();
        Integer n4 = oldConfig.maxConnections();
        if (n3 == null ? n4 != null : !((Object)n3).equals(n4)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating broker-wide maxConnections: ").append(maxConnections).toString());
            this.connectionQuotas().updateBrokerMaxConnections(Predef$.MODULE$.Integer2int(maxConnections));
        }
        Integer n5 = maxConnectionRate = newConfig.maxConnectionCreationRate();
        Integer n6 = oldConfig.maxConnectionCreationRate();
        if (n5 == null ? n6 != null : !((Object)n5).equals(n6)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Updating broker-wide maxConnectionCreationRate: ").append(maxConnectionRate).toString());
            this.connectionQuotas().updateBrokerMaxConnectionRate(Predef$.MODULE$.Integer2int(maxConnectionRate));
            return;
        }
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.get(address))));
    }

    public Option<DataPlaneAcceptor> dataPlaneAcceptor(String listenerName) {
        Object object = new Object();
        try {
            ((IterableLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.dataPlaneAcceptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SocketServer.$anonfun$dataPlaneAcceptor$1(listenerName, object, x0$1);
                return BoxedUnit.UNIT;
            });
            return None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return (Option)ex.value();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ double $anonfun$new$6(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$4(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$6(m))));
    }

    public static final /* synthetic */ double $anonfun$new$1(SocketServer $this) {
        synchronized ($this) {
            Iterable dataPlaneProcessors = (Iterable)((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.dataPlaneAcceptors()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)a -> a.processors(), Iterable$.MODULE$.canBuildFrom());
            Iterable ioWaitRatioMetricNames = (Iterable)dataPlaneProcessors.map((Function1 & Serializable & scala.Serializable)p -> $this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()), Iterable$.MODULE$.canBuildFrom());
            double d = dataPlaneProcessors.isEmpty() ? 1.0 : BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ioWaitRatioMetricNames.map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$4($this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)dataPlaneProcessors.size();
            return d;
        }
    }

    public static final /* synthetic */ double $anonfun$new$12(KafkaMetric m) {
        return Math.min(BoxesRunTime.unboxToDouble((Object)m.metricValue()), 1.0);
    }

    public static final /* synthetic */ double $anonfun$new$10(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$12(m))));
    }

    public static final /* synthetic */ double $anonfun$new$7(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)$this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)a -> (Processor)a.processors().apply(0)).map((Function1 & Serializable & scala.Serializable)p -> $this.metrics().metricName("io-wait-ratio", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$10($this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN));
            return d;
        }
    }

    public static final /* synthetic */ long $anonfun$new$14(SocketServer $this) {
        return $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ long $anonfun$new$15(SocketServer $this) {
        return $this.memoryPool().size() - $this.memoryPool().availableMemory();
    }

    public static final /* synthetic */ double $anonfun$new$21(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$19(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$21(m))));
    }

    public static final /* synthetic */ double $anonfun$new$16(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((Iterable)((Iterable)((MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.dataPlaneAcceptors()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)a -> a.processors(), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)p -> $this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags()), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$19($this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            return d;
        }
    }

    public static final /* synthetic */ double $anonfun$new$27(KafkaMetric m) {
        return BoxesRunTime.unboxToDouble((Object)m.metricValue());
    }

    public static final /* synthetic */ double $anonfun$new$25(SocketServer $this, MetricName metricName) {
        return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$27(m))));
    }

    public static final /* synthetic */ double $anonfun$new$22(SocketServer $this) {
        synchronized ($this) {
            double d = BoxesRunTime.unboxToDouble((Object)$this.controlPlaneAcceptorOpt().map((Function1 & Serializable & scala.Serializable)a -> (Processor)a.processors().apply(0)).map((Function1 & Serializable & scala.Serializable)p -> $this.metrics().metricName("expired-connections-killed-count", SocketServer$.MODULE$.MetricsGroup(), p.metricTags())).map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$25($this, metricName))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0));
            return d;
        }
    }

    public static final /* synthetic */ boolean $anonfun$enableRequestProcessing$1(Acceptor acceptor$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            Endpoint endpoint = (Endpoint)x0$1._1();
            return acceptor$1.endPoint().listenerName().value().equals(endpoint.listenerName().get());
        }
        throw new MatchError(null);
    }

    private final void chainAcceptorFuture$1(Acceptor acceptor, Map authorizerFutures$1) {
        Tuple2 tuple2;
        CompletableFuture completableFuture;
        Option option = authorizerFutures$1.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SocketServer.$anonfun$enableRequestProcessing$1(acceptor, x0$1)));
        if (None$.MODULE$.equals(option)) {
            completableFuture = this.allAuthorizerFuturesComplete();
        } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
            completableFuture = (CompletableFuture)tuple2._2();
        } else {
            throw new MatchError((Object)option);
        }
        completableFuture.whenComplete((x$2, e) -> {
            if (e != null) {
                acceptor.startedFuture().completeExceptionally((Throwable)e);
                return;
            }
            acceptor.start();
        });
    }

    public static final /* synthetic */ String $anonfun$createDataPlaneAcceptorAndProcessors$1(EndPoint endpoint$1) {
        return new StringBuilder(58).append("Created data-plane acceptor and processors for endpoint : ").append(endpoint$1.listenerName()).toString();
    }

    public static final /* synthetic */ void $anonfun$removeListeners$3(SocketServer $this, DataPlaneAcceptor acceptor) {
        acceptor.beginShutdown();
        acceptor.close();
        $this.config().removeReconfigurable((Reconfigurable)acceptor);
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        $this.connectionQuotas().removeListener($this.config(), endpoint.listenerName());
        ((scala.collection.mutable.MapLike)CollectionConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.dataPlaneAcceptors()).asScala()).remove((Object)endpoint).foreach((Function1 & Serializable & scala.Serializable)acceptor -> {
            SocketServer.$anonfun$removeListeners$3($this, acceptor);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$dataPlaneAcceptor$1(String listenerName$2, Object nonLocalReturnKey1$1, Tuple2 x0$1) {
        block5: {
            block8: {
                DataPlaneAcceptor acceptor;
                block7: {
                    String string;
                    block6: {
                        if (x0$1 == null) break block5;
                        EndPoint endPoint = (EndPoint)x0$1._1();
                        acceptor = (DataPlaneAcceptor)x0$1._2();
                        string = endPoint.listenerName().value();
                        if (string != null) break block6;
                        if (listenerName$2 != null) {
                            return;
                        }
                        break block7;
                    }
                    if (!string.equals(listenerName$2)) break block8;
                }
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)acceptor));
            }
            return;
        }
        throw new MatchError(null);
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider, ApiVersionManager apiVersionManager) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        this.apiVersionManager = apiVersionManager;
        Logging.$init$(this);
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.nodeId = config.brokerId();
        this.logContext = new LogContext(new StringBuilder(38).append("[SocketServer listenerType=").append(apiVersionManager.listenerType()).append(", nodeId=").append(this.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", SocketServer$.MODULE$.MetricsGroup());
        this.memoryPoolSensor().add((CompoundStat)new Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.dataPlaneAcceptors = new ConcurrentHashMap();
        this.dataPlaneRequestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()), DataPlaneAcceptor$.MODULE$.MetricPrefix(), time, apiVersionManager.newRequestMetrics());
        this.controlPlaneAcceptorOpt = None$.MODULE$;
        this.controlPlaneRequestChannelOpt = config.controlPlaneListenerName().map((Function1 & Serializable & scala.Serializable)x$1 -> new RequestChannel(20, ControlPlaneAcceptor$.MODULE$.MetricPrefix(), this.time(), this.apiVersionManager().newRequestMetrics()));
        this.nextProcessorId = new AtomicInteger(0);
        this.connectionQuotas = new ConnectionQuotas(config, time, metrics);
        this.allAuthorizerFuturesComplete = new CompletableFuture();
        this.stopped = false;
        this.metricsGroup().newGauge(new StringBuilder(30).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$1(this)));
        if (config.requiresZookeeper()) {
            this.metricsGroup().newGauge(new StringBuilder(30).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("NetworkProcessorAvgIdlePercent").toString(), () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$7(this)));
        }
        this.metricsGroup().newGauge("MemoryPoolAvailable", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$14(this)));
        this.metricsGroup().newGauge("MemoryPoolUsed", () -> BoxesRunTime.boxToLong((long)SocketServer.$anonfun$new$15(this)));
        this.metricsGroup().newGauge(new StringBuilder(29).append(DataPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$16(this)));
        if (config.requiresZookeeper()) {
            this.metricsGroup().newGauge(new StringBuilder(29).append(ControlPlaneAcceptor$.MODULE$.MetricPrefix()).append("ExpiredConnectionsKilledCount").toString(), () -> BoxesRunTime.boxToDouble((double)SocketServer.$anonfun$new$22(this)));
        }
        if (apiVersionManager.listenerType().equals((Object)ApiMessageType.ListenerType.CONTROLLER)) {
            config.controllerListeners().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
                this.createDataPlaneAcceptorAndProcessors(endpoint);
                return BoxedUnit.UNIT;
            });
            return;
        }
        config.controlPlaneListener().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            this.createControlPlaneAcceptorAndProcessor(endpoint);
            return BoxedUnit.UNIT;
        });
        config.dataPlaneListeners().foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            this.createDataPlaneAcceptorAndProcessors(endpoint);
            return BoxedUnit.UNIT;
        });
    }
}

