/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import joptsimple.OptionException;
import joptsimple.OptionSpec;
import kafka.admin.ConfigCommand;
import kafka.log.LogConfig$;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicConfig$Broker$;
import kafka.server.KafkaConfig$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Sanitizer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.matching.Regex;

public final class ConfigCommand$
implements kafka.common.Config {
    public static final ConfigCommand$ MODULE$ = new ConfigCommand$();
    private static final String BrokerLoggerConfigType;
    private static final Seq<String> BrokerSupportedConfigTypes;
    private static final int DefaultScramIterations;
    private static final Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$(MODULE$);
        kafka.common.Config.$init$(MODULE$);
        BrokerLoggerConfigType = "broker-loggers";
        BrokerSupportedConfigTypes = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{ConfigType$.MODULE$.Broker(), MODULE$.BrokerLoggerConfigType()}));
        DefaultScramIterations = 4096;
        BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning = (Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{DynamicConfig$Broker$.MODULE$.LeaderReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.FollowerReplicationThrottledRateProp(), DynamicConfig$Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp()}));
    }

    @Override
    public void validateChars(String prop, String value) {
        kafka.common.Config.validateChars$(this, prop, value);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        ConfigCommand$ configCommand$ = this;
        synchronized (configCommand$) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        return !bitmap$0 ? this.logger$lzycompute() : logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public String BrokerLoggerConfigType() {
        return BrokerLoggerConfigType;
    }

    public Seq<String> BrokerSupportedConfigTypes() {
        return BrokerSupportedConfigTypes;
    }

    public int DefaultScramIterations() {
        return DefaultScramIterations;
    }

    public Set<String> BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning() {
        return BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning;
    }

    public void main(String[] args) {
        try {
            ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions(args);
            CommandLineUtils$.MODULE$.printHelpAndExitIfNeeded(opts, "This tool helps to manipulate and describe entity config for a topic, client, user or broker");
            opts.checkArgs();
            if (opts.options().has(opts.zkConnectOpt())) {
                this.processCommandWithZk((String)opts.options().valueOf(opts.zkConnectOpt()), opts);
            } else {
                this.processBrokerConfig(opts);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : (throwable2 instanceof InvalidConfigurationException ? true : throwable2 instanceof OptionException);
            if (bl) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(34).append("Failed config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString(), throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(throwable2.getMessage());
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            if (throwable2 != null) {
                BoxedUnit boxedUnit;
                Throwable throwable3 = throwable2;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug(new StringBuilder(49).append("Error while executing config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString(), throwable3);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                System.err.println(new StringBuilder(49).append("Error while executing config command with args '").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).append("'").toString());
                throwable3.printStackTrace(System.err);
                throw Exit$.MODULE$.exit(1, Exit$.MODULE$.exit$default$2());
            }
            throw throwable;
        }
    }

    private void processCommandWithZk(String zkConnectString, ConfigCommand.ConfigCommandOptions opts) {
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply(zkConnectString, JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, Time.SYSTEM, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8(), KafkaZkClient$.MODULE$.apply$default$9());
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterConfig(zkClient, opts, adminZkClient);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeConfig(zkClient, opts, adminZkClient);
            }
        }
        finally {
            zkClient.close();
        }
    }

    public void alterConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        Properties configsToBeAdded = this.parseConfigsToBeAdded(opts);
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        ConfigCommand.ConfigEntity entity = this.parseEntity(opts);
        String entityType = entity.root().entityType();
        String entityName = entity.fullSanitizedName();
        String string = entityType;
        String string2 = ConfigType$.MODULE$.User();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.preProcessScramCredentials(configsToBeAdded);
        } else {
            Set dynamicBrokerConfigs;
            String string3 = entityType;
            String string4 = ConfigType$.MODULE$.Broker();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && (dynamicBrokerConfigs = (Set)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterConfig$1(elem)))).nonEmpty()) {
                String string5 = entityName;
                String string6 = ConfigEntityName$.MODULE$.Default();
                boolean perBrokerConfig = string5 == null ? string6 != null : !string5.equals(string6);
                String errorMessage = new StringBuilder(70).append("--bootstrap-server option must be specified to update broker configs ").append(dynamicBrokerConfigs).append(".").toString();
                String info = "Broker configuration updates using ZooKeeper are supported for bootstrapping before brokers are started to enable encrypted password configs to be stored in ZooKeeper.";
                if (perBrokerConfig) {
                    adminZkClient.parseBroker(entityName).foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> Predef$.MODULE$.require(zkClient.getBroker(brokerId).isEmpty(), (Function0 & Serializable)() -> new StringBuilder(26).append(errorMessage).append(" when broker ").append(entityName).append(" is running. ").append(info).toString()));
                } else {
                    Predef$.MODULE$.require(zkClient.getAllBrokersInCluster().isEmpty(), (Function0 & Serializable)() -> new StringBuilder(47).append(errorMessage).append(" for default cluster if any broker is running. ").append(info).toString());
                }
                this.preProcessBrokerConfigs(configsToBeAdded, perBrokerConfig);
            }
        }
        Properties configs = adminZkClient.fetchEntityConfig(entityType, entityName);
        Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)configs.containsKey(x$1)));
        if (invalidConfigs.nonEmpty()) {
            throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
        }
        Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
        configsToBeDeleted.foreach((Function1 & Serializable)x$2 -> configs.remove(x$2));
        adminZkClient.changeConfigs(entityType, entityName, configs);
        Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed Updating config for entity: ").append(entity).append(".").toString());
    }

    private void preProcessScramCredentials(Properties configsToBeAdded) {
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])ScramMechanism.values()), (Function1 & Serializable)mechanism -> {
            String string = configsToBeAdded.getProperty(mechanism.mechanismName());
            Object object = string == null ? BoxedUnit.UNIT : configsToBeAdded.setProperty(mechanism.mechanismName(), this.scramCredential$1((ScramMechanism)mechanism, string));
            return object;
        });
    }

    public PasswordEncoder createPasswordEncoder(Map<String, String> encoderConfigs) {
        encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp());
        String encoderSecret = (String)encoderConfigs.getOrElse((Object)KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), (Function0 & Serializable)() -> {
            throw new IllegalArgumentException("Password encoder secret not specified");
        });
        return new PasswordEncoder(new Password(encoderSecret), (Option<String>)None$.MODULE$, (String)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp()).getOrElse((Function0 & Serializable)() -> Defaults$.MODULE$.PasswordEncoderCipherAlgorithm()), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.PasswordEncoderKeyLength())), BoxesRunTime.unboxToInt((Object)encoderConfigs.get((Object)KafkaConfig$.MODULE$.PasswordEncoderIterationsProp()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> Defaults$.MODULE$.PasswordEncoderIterations())));
    }

    private void preProcessBrokerConfigs(Properties configsToBeAdded, boolean perBrokerConfig) {
        block1: {
            Properties passwordEncoderConfigs = new Properties();
            Implicits$.MODULE$.PropertiesOps(passwordEncoderConfigs).$plus$plus$eq((Map<String, Object>)((Map)((IterableOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$preProcessBrokerConfigs$1(x0$1)))));
            if (!passwordEncoderConfigs.isEmpty()) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append(new StringBuilder(53).append("Password encoder configs ").append(passwordEncoderConfigs.keySet()).append(" will be used for encrypting").toString()).append(" passwords, but will not be stored in ZooKeeper.").toString());
                ((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()).keySet().foreach((Function1 & Serializable)x$1 -> configsToBeAdded.remove(x$1));
            }
            DynamicBrokerConfig$.MODULE$.validateConfigs(configsToBeAdded, perBrokerConfig);
            Set passwordConfigs = (Set)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configsToBeAdded).asScala()).keySet().filter((Function1 & Serializable)name -> BoxesRunTime.boxToBoolean((boolean)DynamicBrokerConfig$.MODULE$.isPasswordConfig(name)));
            if (!passwordConfigs.nonEmpty()) break block1;
            Predef$.MODULE$.require(passwordEncoderConfigs.containsKey(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()), (Function0 & Serializable)() -> new StringBuilder(196).append(new StringBuilder(30).append(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()).append(" must be specified to update ").append(passwordConfigs).append(".").toString()).append(" Other password encoder configs like cipher algorithm and iterations may also be specified").append(" to override the default encoding parameters. Password encoder configs will not be persisted").append(" in ZooKeeper.").toString());
            PasswordEncoder passwordEncoder = this.createPasswordEncoder((Map<String, String>)((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(passwordEncoderConfigs).asScala()));
            passwordConfigs.foreach((Function1 & Serializable)configName -> {
                String encodedValue = passwordEncoder.encode(new Password(configsToBeAdded.getProperty((String)configName)));
                return configsToBeAdded.setProperty((String)configName, encodedValue);
            });
        }
    }

    /*
     * Unable to fully structure code
     */
    private void describeConfig(KafkaZkClient zkClient, ConfigCommand.ConfigCommandOptions opts, AdminZkClient adminZkClient) {
        configEntity = this.parseEntity(opts);
        v0 = configEntity.root().entityType();
        var6_5 = ConfigType$.MODULE$.User();
        if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
        if (!configEntity.root().sanitizedName().isDefined() && !configEntity.child().isDefined()) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        describeAllUsers = v1;
        entities = configEntity.getAllEntities(zkClient);
        entities.foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$describeConfig$1$adapted(kafka.zk.AdminZkClient boolean kafka.admin.ConfigCommand$ConfigEntity ), (Lkafka/admin/ConfigCommand$ConfigEntity;)Ljava/lang/Object;)((AdminZkClient)adminZkClient, (boolean)describeAllUsers));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseConfigsToBeAdded(ConfigCommand.ConfigCommandOptions opts) {
        void var2_2;
        block1: {
            Properties props = new Properties();
            if (!opts.options().has(opts.addConfig())) break block1;
            String pattern = "(?=[^\\]]*(?:\\[|$))";
            String[][] configsToBeAdded = (String[][])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)opts.options().valueOf(opts.addConfig())).split(new StringBuilder(1).append(",").append(pattern).toString())), (Function1 & Serializable)x$6 -> x$6.split(new StringBuilder(7).append("\\s*=\\s*").append(pattern).toString(), -1), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
            Predef$.MODULE$.require(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1 & Serializable)config -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$parseConfigsToBeAdded$2(config))), (Function0 & Serializable)() -> "Invalid entity config: all configs to be added must be in the format \"key=val\".");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])configsToBeAdded), (Function1 & Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].replaceAll("\\[?\\]?", "").trim()));
            if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
                Predef$.MODULE$.println((Object)new StringBuilder(0).append(new StringBuilder(43).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").toString()).append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker.").toString());
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseConfigsToBeDeleted(ConfigCommand.ConfigCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfig())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfig())).asScala()).map((Function1 & Serializable)x$7 -> x$7.trim());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    private void processBrokerConfig(ConfigCommand.ConfigCommandOptions opts) {
        Properties props = opts.options().has(opts.commandConfigOpt()) ? Utils.loadProps((String)((String)opts.options().valueOf(opts.commandConfigOpt()))) : new Properties();
        props.put("bootstrap.servers", opts.options().valueOf(opts.bootstrapServerOpt()));
        AdminClient adminClient = AdminClient.create((Properties)props);
        String entityName = opts.options().has(opts.entityName()) ? (String)opts.options().valueOf(opts.entityName()) : "";
        Buffer entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        if (entityTypes.size() != 1) {
            throw new IllegalArgumentException(new StringBuilder(77).append("Exactly one --entity-type (out of ").append(this.BrokerSupportedConfigTypes().mkString(",")).append(") must be specified with --bootstrap-server").toString());
        }
        try {
            if (opts.options().has((OptionSpec)opts.alterOpt())) {
                this.alterBrokerConfig((Admin)adminClient, opts, (String)entityTypes.head(), entityName);
            } else if (opts.options().has((OptionSpec)opts.describeOpt())) {
                this.describeBrokerConfig((Admin)adminClient, opts, (String)entityTypes.head(), entityName);
            }
        }
        finally {
            adminClient.close();
        }
    }

    public void alterBrokerConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts, String entityType, String entityName) {
        Object object;
        scala.collection.mutable.Map configsToBeAdded = (scala.collection.mutable.Map)((MapOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(this.parseConfigsToBeAdded(opts)).asScala()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)k, (Object)new ConfigEntry(k, v));
            return tuple22;
        });
        Seq<String> configsToBeDeleted = this.parseConfigsToBeDeleted(opts);
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Broker();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
            scala.collection.immutable.Map oldConfig = ((IterableOnceOps)this.brokerConfig(adminClient, entityName, false).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), entry))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Seq invalidConfigs = (Seq)configsToBeDeleted.filterNot((Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)oldConfig.contains((Object)key)));
            if (invalidConfigs.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(19).append("Invalid config(s): ").append(invalidConfigs.mkString(",")).toString());
            }
            scala.collection.immutable.Map newEntries = (scala.collection.immutable.Map)((scala.collection.immutable.MapOps)oldConfig.$plus$plus((IterableOnce)configsToBeAdded)).$minus$minus(configsToBeDeleted);
            scala.collection.immutable.Map sensitiveEntries = (scala.collection.immutable.Map)newEntries.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$alterBrokerConfig$4(x$9)));
            if (sensitiveEntries.nonEmpty()) {
                throw new InvalidConfigurationException(new StringBuilder(84).append("All sensitive broker config entries must be specified for --alter, missing entries: ").append(sensitiveEntries.keySet()).toString());
            }
            Config newConfig = new Config(((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)newEntries).asJava()).values());
            AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
            object = adminClient.alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)newConfig)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
        } else {
            String string3 = entityType;
            String string4 = this.BrokerLoggerConfigType();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
                Seq validLoggers = (Seq)this.brokerLoggerConfigs(adminClient, entityName).map((Function1 & Serializable)x$10 -> x$10.name());
                Seq invalidBrokerLoggers = (Seq)((IterableOps)configsToBeDeleted.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem)))).$plus$plus((IterableOnce)configsToBeAdded.keys().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)validLoggers.contains(elem))));
                if (invalidBrokerLoggers.nonEmpty()) {
                    throw new InvalidConfigurationException(new StringBuilder(26).append("Invalid broker logger(s): ").append(invalidBrokerLoggers.mkString(",")).toString());
                }
                AlterConfigsOptions alterOptions = new AlterConfigsOptions().timeoutMs(Predef$.MODULE$.int2Integer(30000)).validateOnly(false);
                Collection alterLogLevelEntries = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((IterableOps)configsToBeAdded.values().map((Function1 & Serializable)x$11 -> new AlterConfigOp(x$11, AlterConfigOp.OpType.SET))).$plus$plus((IterableOnce)configsToBeDeleted.map((Function1 & Serializable)k -> new AlterConfigOp(new ConfigEntry(k, ""), AlterConfigOp.OpType.DELETE)))).asJavaCollection();
                object = adminClient.incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configResource), (Object)alterLogLevelEntries)}))).asJava(), alterOptions).all().get(60L, TimeUnit.SECONDS);
            } else {
                object = BoxedUnit.UNIT;
            }
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
            Predef$.MODULE$.println((Object)new StringBuilder(39).append("Completed updating config for broker: ").append(entityName).append(".").toString());
        } else {
            Predef$.MODULE$.println((Object)"Completed updating default config for brokers in the cluster,");
        }
    }

    private void describeBrokerConfig(Admin adminClient, ConfigCommand.ConfigCommandOptions opts, String entityType, String entityName) {
        Seq<ConfigEntry> configs;
        String string = entityType;
        String string2 = ConfigType$.MODULE$.Broker();
        Seq<ConfigEntry> seq = !(string != null ? !string.equals(string2) : string2 != null) ? this.brokerConfig(adminClient, entityName, true) : (configs = this.brokerLoggerConfigs(adminClient, entityName));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(entityName))) {
            Predef$.MODULE$.println((Object)new StringBuilder(24).append("Configs for broker ").append(entityName).append(" are:").toString());
        } else {
            Predef$.MODULE$.println((Object)"Default config for brokers in the cluster are:");
        }
        configs.foreach((Function1 & Serializable)config -> {
            ConfigCommand$.$anonfun$describeBrokerConfig$1(config);
            return BoxedUnit.UNIT;
        });
    }

    private Seq<ConfigEntry> brokerConfig(Admin adminClient, String entityName, boolean includeSynonyms) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER, entityName);
        ConfigEntry.ConfigSource configSource = !entityName.isEmpty() ? ConfigEntry.ConfigSource.DYNAMIC_BROKER_CONFIG : ConfigEntry.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
        DescribeConfigsOptions describeOpts = new DescribeConfigsOptions().includeSynonyms(includeSynonyms);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource), describeOpts).all().get(30L, TimeUnit.SECONDS);
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$brokerConfig$1(configSource, entry)))).toSeq();
    }

    private Seq<ConfigEntry> brokerLoggerConfigs(Admin adminClient, String entityName) {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, entityName);
        java.util.Map configs = (java.util.Map)adminClient.describeConfigs(Collections.singleton(configResource)).all().get(30L, TimeUnit.SECONDS);
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)configs.get(configResource)).entries()).asScala()).toSeq();
    }

    /*
     * Enabled aggressive block sorting
     */
    public ConfigCommand.ConfigEntity parseEntity(ConfigCommand.ConfigCommandOptions opts) {
        Object object;
        ConfigCommand.ConfigEntity configEntity;
        Buffer entityTypes;
        block6: {
            block5: {
                entityTypes = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
                Object object2 = entityTypes.head();
                String string = ConfigType$.MODULE$.User();
                if (!(object2 == null ? string != null : !object2.equals(string))) break block5;
                Object object3 = entityTypes.head();
                String string2 = ConfigType$.MODULE$.Client();
                if (object3 != null ? !object3.equals(string2) : string2 != null) break block6;
            }
            configEntity = this.parseQuotaEntity(opts);
            return configEntity;
        }
        if (opts.options().has(opts.entityName())) {
            object = new Some(opts.options().valueOf(opts.entityName()));
        } else {
            Object object4 = entityTypes.head();
            String string = ConfigType$.MODULE$.Broker();
            object = !(object4 != null ? !object4.equals(string) : string != null) && opts.options().has((OptionSpec)opts.entityDefault()) ? new Some((Object)ConfigEntityName$.MODULE$.Default()) : None$.MODULE$;
        }
        Some name = object;
        configEntity = new ConfigCommand.ConfigEntity(new ConfigCommand.Entity((String)entityTypes.head(), (Option<String>)name), (Option<ConfigCommand.Entity>)None$.MODULE$);
        return configEntity;
    }

    private Seq<String> entityNames(ConfigCommand.ConfigCommandOptions opts) {
        java.util.Iterator namesIterator = opts.options().valuesOf(opts.entityName()).iterator();
        return (Seq)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().specs()).asScala()).filter((Function1 & Serializable)spec -> BoxesRunTime.boxToBoolean((boolean)ConfigCommand$.$anonfun$entityNames$1(spec)))).map((Function1 & Serializable)spec -> spec.options().contains("entity-name") ? (String)namesIterator.next() : "");
    }

    /*
     * Unable to fully structure code
     */
    private ConfigCommand.ConfigEntity parseQuotaEntity(ConfigCommand.ConfigCommandOptions opts) {
        types = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.entityType())).asScala();
        names = this.entityNames(opts);
        if (opts.options().has((OptionSpec)opts.alterOpt()) && names.size() != types.size()) {
            throw new IllegalArgumentException("--entity-name or --entity-default must be specified with each --entity-type for --alter");
        }
        if (types.size() != 2) ** GOTO lbl-1000
        v0 = types.head();
        var5_4 = ConfigType$.MODULE$.Client();
        if (!(v0 != null ? v0.equals(var5_4) == false : var5_4 != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        reverse = v1;
        entityTypes = reverse != false ? (Buffer)types.reverse() : types;
        sortedNames = ((IterableOnce)(reverse != false && names.length() == 2 ? names.reverse() : names)).iterator();
        entities = (Buffer)entityTypes.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseQuotaEntity$1(scala.collection.Iterator java.lang.String ), (Ljava/lang/String;)Lkafka/admin/ConfigCommand$Entity;)((Iterator)sortedNames));
        return new ConfigCommand.ConfigEntity((ConfigCommand.Entity)entities.head(), (Option<ConfigCommand.Entity>)(entities.size() > 1 ? new Some(entities.apply(1)) : None$.MODULE$));
    }

    public static final /* synthetic */ boolean $anonfun$alterConfig$1(String elem) {
        return MODULE$.BrokerConfigsUpdatableUsingZooKeeperWhileBrokerRunning().contains((Object)elem);
    }

    private final String scramCredential$1(ScramMechanism mechanism, String credentialStr) {
        Option option;
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(?:iterations=([0-9]*),)?password=(.*)"));
        String string = credentialStr;
        if (string == null || (option = pattern.unapplySeq((CharSequence)string)).isEmpty() || option.get() == null || ((List)option.get()).lengthCompare(2) != 0) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid credential property ").append(mechanism).append("=").append(credentialStr).toString());
        }
        String iterations = (String)((LinearSeqOps)option.get()).apply(0);
        String password = (String)((LinearSeqOps)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)(iterations != null ? BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(iterations))) : BoxesRunTime.boxToInteger((int)this.DefaultScramIterations())), (Object)password);
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        int iterations2 = tuple22._1$mcI$sp();
        String password2 = (String)tuple22._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)iterations2), (Object)password2);
        Tuple2 tuple24 = tuple23;
        int iterations3 = tuple24._1$mcI$sp();
        String password3 = (String)tuple24._2();
        if (iterations3 < mechanism.minIterations()) {
            throw new IllegalArgumentException(new StringBuilder(51).append("Iterations ").append(iterations3).append(" is less than the minimum ").append(mechanism.minIterations()).append(" required for ").append(mechanism).toString());
        }
        ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password3, iterations3);
        return ScramCredentialUtils.credentialToString((ScramCredential)credential);
    }

    public static final /* synthetic */ boolean $anonfun$preProcessBrokerConfigs$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("password.encoder.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$describeConfig$1(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        block0: {
            Properties configs = adminZkClient$1.fetchEntityConfig(entity.root().entityType(), entity.fullSanitizedName());
            if (configs.isEmpty() && describeAllUsers$1) break block0;
            Predef$.MODULE$.println((Object)StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Configs for %s are %s"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{entity, ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(configs).asScala()).map((Function1 & Serializable)kv -> new StringBuilder(1).append((String)kv._1()).append("=").append(kv._2()).toString())).mkString(",")})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseConfigsToBeAdded$2(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerConfig$4(Tuple2 x$9) {
        return ((ConfigEntry)x$9._2()).value() == null;
    }

    public static final /* synthetic */ void $anonfun$describeBrokerConfig$1(ConfigEntry config) {
        String synonyms = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(config.synonyms()).asScala()).map((Function1 & Serializable)synonym -> new StringBuilder(2).append(synonym.source()).append(":").append(synonym.name()).append("=").append(synonym.value()).toString())).mkString(", ");
        Predef$.MODULE$.println((Object)new StringBuilder(26).append("  ").append(config.name()).append("=").append(config.value()).append(" sensitive=").append(config.isSensitive()).append(" synonyms={").append(synonyms).append("}").toString());
    }

    public static final /* synthetic */ boolean $anonfun$brokerConfig$1(ConfigEntry.ConfigSource configSource$1, ConfigEntry entry) {
        ConfigEntry.ConfigSource configSource = entry.source();
        ConfigEntry.ConfigSource configSource2 = configSource$1;
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$entityNames$1(OptionSpec spec) {
        return spec.options().contains("entity-name") || spec.options().contains("entity-default");
    }

    private static final String sanitizeName$1(String entityType, String name) {
        String string;
        if (name.isEmpty()) {
            string = ConfigEntityName$.MODULE$.Default();
        } else {
            boolean bl;
            String string2 = entityType;
            String string3 = ConfigType$.MODULE$.User();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                bl = true;
            } else {
                String string5 = ConfigType$.MODULE$.Client();
                String string6 = string2;
                bl = !(string5 != null ? !string5.equals(string6) : string6 != null);
            }
            if (!bl) {
                throw new IllegalArgumentException(new StringBuilder(20).append("Invalid entity type ").append(entityType).toString());
            }
            String string7 = Sanitizer.sanitize((String)name);
            string = string7;
        }
        return string;
    }

    public static final /* synthetic */ ConfigCommand.Entity $anonfun$parseQuotaEntity$1(Iterator sortedNames$1, String t) {
        return new ConfigCommand.Entity(t, (Option<String>)(sortedNames$1.hasNext() ? new Some((Object)ConfigCommand$.sanitizeName$1(t, (String)sortedNames$1.next())) : None$.MODULE$));
    }

    private ConfigCommand$() {
    }

    public static final /* synthetic */ Object $anonfun$describeConfig$1$adapted(AdminZkClient adminZkClient$1, boolean describeAllUsers$1, ConfigCommand.ConfigEntity entity) {
        ConfigCommand$.$anonfun$describeConfig$1(adminZkClient$1, describeAllUsers$1, entity);
        return BoxedUnit.UNIT;
    }
}

