/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_0_10_0_IV0$;
import kafka.api.KAFKA_0_10_0_IV1$;
import kafka.api.KAFKA_0_10_1_IV0$;
import kafka.api.KAFKA_0_10_1_IV1$;
import kafka.api.KAFKA_0_10_1_IV2$;
import kafka.api.KAFKA_0_10_2_IV0$;
import kafka.api.KAFKA_0_11_0_IV0$;
import kafka.api.KAFKA_0_11_0_IV1$;
import kafka.api.KAFKA_0_11_0_IV2$;
import kafka.api.KAFKA_0_8_0$;
import kafka.api.KAFKA_0_8_1$;
import kafka.api.KAFKA_0_8_2$;
import kafka.api.KAFKA_0_9_0$;
import kafka.api.KAFKA_1_0_IV0$;
import kafka.api.KAFKA_1_1_IV0$;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_1_IV0$;
import kafka.api.KAFKA_2_1_IV1$;
import kafka.api.KAFKA_2_1_IV2$;
import kafka.api.KAFKA_2_2_IV0$;
import kafka.api.KAFKA_2_2_IV1$;
import kafka.api.KAFKA_2_3_IV0$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.api.KAFKA_2_4_IV0$;
import kafka.api.KAFKA_2_4_IV1$;
import org.apache.kafka.common.record.RecordVersion;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ApiVersion$ {
    public static final ApiVersion$ MODULE$ = new ApiVersion$();
    private static final Seq<ApiVersion> allVersions = (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApiVersion[]{KAFKA_0_8_0$.MODULE$, KAFKA_0_8_1$.MODULE$, KAFKA_0_8_2$.MODULE$, KAFKA_0_9_0$.MODULE$, KAFKA_0_10_0_IV0$.MODULE$, KAFKA_0_10_0_IV1$.MODULE$, KAFKA_0_10_1_IV0$.MODULE$, KAFKA_0_10_1_IV1$.MODULE$, KAFKA_0_10_1_IV2$.MODULE$, KAFKA_0_10_2_IV0$.MODULE$, KAFKA_0_11_0_IV0$.MODULE$, KAFKA_0_11_0_IV1$.MODULE$, KAFKA_0_11_0_IV2$.MODULE$, KAFKA_1_0_IV0$.MODULE$, KAFKA_1_1_IV0$.MODULE$, KAFKA_2_0_IV0$.MODULE$, KAFKA_2_0_IV1$.MODULE$, KAFKA_2_1_IV0$.MODULE$, KAFKA_2_1_IV1$.MODULE$, KAFKA_2_1_IV2$.MODULE$, KAFKA_2_2_IV0$.MODULE$, KAFKA_2_2_IV1$.MODULE$, KAFKA_2_3_IV0$.MODULE$, KAFKA_2_3_IV1$.MODULE$, KAFKA_2_4_IV0$.MODULE$, KAFKA_2_4_IV1$.MODULE$}));
    private static final Map<String, ApiVersion> versionMap = (Map)((IterableOnceOps)MODULE$.allVersions().map((Function1 & Serializable)v -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)v.version()), v))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).$plus$plus((IterableOnce)MODULE$.allVersions().groupBy((Function1 & Serializable)x$2 -> x$2.shortVersion()).map((Function1 & Serializable)x0$1 -> {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        Seq v = (Seq)tuple2._2();
        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)k), v.last());
        return tuple22;
    }));

    public <A extends ApiVersion> Ordering<A> orderingByVersion() {
        return package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<ApiVersion> allVersions() {
        return allVersions;
    }

    private Map<String, ApiVersion> versionMap() {
        return versionMap;
    }

    public ApiVersion apply(String versionString) {
        Seq versionSegments = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(versionString), '.')));
        int numSegments = versionString.startsWith("0.") ? 3 : 2;
        String key = ((IterableOnceOps)versionSegments.take(numSegments)).mkString(".");
        return (ApiVersion)this.versionMap().getOrElse((Object)key, (Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(33).append("Version `").append(versionString).append("` is not a valid version").toString());
        });
    }

    public ApiVersion latestVersion() {
        return (ApiVersion)this.allVersions().last();
    }

    public ApiVersion minSupportedFor(RecordVersion recordVersion) {
        Product product;
        RecordVersion recordVersion2 = recordVersion;
        if (RecordVersion.V0.equals(recordVersion2)) {
            product = KAFKA_0_8_0$.MODULE$;
        } else if (RecordVersion.V1.equals(recordVersion2)) {
            product = KAFKA_0_10_0_IV0$.MODULE$;
        } else if (RecordVersion.V2.equals(recordVersion2)) {
            product = KAFKA_0_11_0_IV0$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(31).append("Invalid message format version ").append(recordVersion).toString());
        }
        return product;
    }

    private ApiVersion$() {
    }
}

