/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiUtils$;
import kafka.cluster.BrokerEndPoint;
import org.apache.kafka.common.KafkaException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;

public final class BrokerEndPoint$
implements Serializable {
    public static final BrokerEndPoint$ MODULE$ = new BrokerEndPoint$();
    private static final Regex uriParseExp = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("\\[?([0-9a-zA-Z\\-%._:]*)\\]?:([0-9]+)"));

    private Regex uriParseExp() {
        return uriParseExp;
    }

    public Option<Tuple2<String, Object>> parseHostPort(String connectionString) {
        None$ none$;
        Option option;
        String string = connectionString;
        if (string != null && !(option = this.uriParseExp().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(2) == 0) {
            Some some;
            String host = (String)((LinearSeqOps)option.get()).apply(0);
            String port = (String)((LinearSeqOps)option.get()).apply(1);
            try {
                some = new Some((Object)new Tuple2((Object)host, (Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(port)))));
            }
            catch (NumberFormatException numberFormatException) {
                some = None$.MODULE$;
            }
            none$ = some;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public BrokerEndPoint createBrokerEndPoint(int brokerId, String connectionString) {
        return (BrokerEndPoint)this.parseHostPort(connectionString).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String host = (String)tuple2._1();
            int port = tuple2._2$mcI$sp();
            BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, host, port);
            return brokerEndPoint;
        }).getOrElse((Function0 & Serializable)() -> {
            throw new KafkaException(new StringBuilder(37).append("Unable to parse ").append(connectionString).append(" to a broker endpoint").toString());
        });
    }

    public BrokerEndPoint readFrom(ByteBuffer buffer) {
        int brokerId = buffer.getInt();
        String host = ApiUtils$.MODULE$.readShortString(buffer);
        int port = buffer.getInt();
        return new BrokerEndPoint(brokerId, host, port);
    }

    public BrokerEndPoint apply(int id, String host, int port) {
        return new BrokerEndPoint(id, host, port);
    }

    public Option<Tuple3<Object, String, Object>> unapply(BrokerEndPoint x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)x$0.id()), (Object)x$0.host(), (Object)BoxesRunTime.boxToInteger((int)x$0.port())));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BrokerEndPoint$.class);
    }

    private BrokerEndPoint$() {
    }
}

