/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t\u0005w!B\u0012%\u0011\u0003Yc!B\u0017%\u0011\u0003q\u0003\"B\u001b\u0002\t\u00031\u0004\"B\u001c\u0002\t\u0003A\u0004b\u0002BZ\u0003\u0011%!Q\u0017\u0005\b\u0005w\u000bA\u0011\u0002B_\r\u0011iC\u0005\u0001\u001e\t\u0011\u00053!\u0011!Q\u0001\n\tC\u0001\"\u0012\u0004\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0013\u001a\u0011\t\u0011)A\u0005\u0015\"AQJ\u0002B\u0001B\u0003%a\n\u0003\u0005R\r\t\u0005\t\u0015!\u0003S\u0011!)fA!A!\u0002\u00131\u0006\u0002C-\u0007\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011\u00194!\u0011!Q\u0001\n\u001dDQ!\u000e\u0004\u0005\u0002),Aa\u001d\u0004\u0001i\u0016!QP\u0002\u0001\u007f\u000b\u0015\tYA\u0002\u0001\u007f\u000b\u0019\tiA\u0002\u0001\u0002\u0010!I\u0011q\b\u0004C\u0002\u0013%\u0011\u0011\t\u0005\t\u000372\u0001\u0015!\u0003\u0002D!9\u0011Q\f\u0004\u0005\u0002\u0005}\u0003bBAA\r\u0011%\u00111\u0011\u0005\b\u0003K3A\u0011AAT\u0011\u001d\tYN\u0002C\u0001\u0003;Dq!!:\u0007\t\u0003\t9\u000fC\u0004\u0002t\u001a!I!!>\t\u000f\tua\u0001\"\u0001\u0003 !9!q\u0006\u0004\u0005\u0002\tE\u0002b\u0002B\u001e\r\u0011\u0005!Q\b\u0005\b\u0005\u00032A\u0011\u0002B\"\u0011\u001d\u0011)E\u0002C\u0001\u0005\u000fB\u0011Ba\u0015\u0007#\u0003%\tA!\u0016\t\u000f\t-d\u0001\"\u0001\u0003D\u00051BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'O\u0003\u0002&M\u0005YAO]1og\u0006\u001cG/[8o\u0015\t9\u0003&A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0015\u0002\u000b-\fgm[1\u0004\u0001A\u0011A&A\u0007\u0002I\t1BK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'o\u0005\u0002\u0002_A\u0011\u0001gM\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u0016\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001fe\u0012iG! \u0003\b\n%%\u0011\u0014BT\u0005c\u0003\"\u0001\f\u0004\u0014\u0007\u0019y3\b\u0005\u0002=\u007f5\tQH\u0003\u0002?Q\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003!\u0011'o\\6fe&#\u0007C\u0001\u0019D\u0013\t!\u0015GA\u0002J]R\f\u0011\u0002\u001e=o\u0007>tg-[4\u0011\u00051:\u0015B\u0001%%\u0005E!&/\u00198tC\u000e$\u0018n\u001c8D_:4\u0017nZ\u0001\ng\u000eDW\rZ;mKJ\u0004\"\u0001P&\n\u00051k$!C*dQ\u0016$W\u000f\\3s\u0003E\u0001(o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM\u001d\t\u0003Y=K!\u0001\u0015\u0013\u0003#A\u0013x\u000eZ;dKJLE-T1oC\u001e,'/\u0001\u0006uq:l\u0015M\\1hKJ\u0004\"\u0001L*\n\u0005Q##a\u0006+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u001b\u0006t\u0017mZ3s\u0003]!\bP\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0005\u0002-/&\u0011\u0001\f\n\u0002 )J\fgn]1di&|g.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018\u0001\u0002;j[\u0016\u0004\"a\u00173\u000e\u0003qS!AP/\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002*A*\u0011\u0011MY\u0001\u0007CB\f7\r[3\u000b\u0003\r\f1a\u001c:h\u0013\t)GL\u0001\u0003US6,\u0017A\u00037pO\u000e{g\u000e^3yiB\u00111\f[\u0005\u0003Sr\u0013!\u0002T8h\u0007>tG/\u001a=u)%I4\u000e\\7o_B\f(\u000fC\u0003B\u001f\u0001\u0007!\tC\u0003F\u001f\u0001\u0007a\tC\u0003J\u001f\u0001\u0007!\nC\u0003N\u001f\u0001\u0007a\nC\u0003R\u001f\u0001\u0007!\u000bC\u0003V\u001f\u0001\u0007a\u000bC\u0003Z\u001f\u0001\u0007!\fC\u0003g\u001f\u0001\u0007qM\u0001\fJ]&$\bK]8ek\u000e,'/\u00133DC2d'-Y2l!\u0011\u0001To\u001e>\n\u0005Y\f$!\u0003$v]\u000e$\u0018n\u001c82!\ta\u00030\u0003\u0002zI\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u0004\"\u0001M>\n\u0005q\f$\u0001B+oSR\u0014Q#\u00113e!\u0006\u0014H/\u001b;j_:\u001c8)\u00197mE\u0006\u001c7\u000e\u0005\u00031k~T\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015Q,\u0001\u0005qe>$xnY8m\u0013\u0011\tI!a\u0001\u0003\r\u0015\u0013(o\u001c:t\u00059)e\u000e\u001a+y]\u000e\u000bG\u000e\u001c2bG.\u0014\u0011\"\u00119j%\u0016\u001cX\u000f\u001c;\u0016\t\u0005E\u0011Q\u0006\t\b\u0003'\t\u0019c`A\u0015\u001d\u0011\t)\"a\b\u000f\t\u0005]\u0011QD\u0007\u0003\u00033Q1!a\u0007+\u0003\u0019a$o\\8u}%\t!'C\u0002\u0002\"E\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002&\u0005\u001d\"AB#ji\",'OC\u0002\u0002\"E\u0002B!a\u000b\u0002.1\u0001AaBA\u0018'\t\u0007\u0011\u0011\u0007\u0002\u0002)F!\u00111GA\u001d!\r\u0001\u0014QG\u0005\u0004\u0003o\t$a\u0002(pi\"Lgn\u001a\t\u0004a\u0005m\u0012bAA\u001fc\t\u0019\u0011I\\=\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!a\u0011\u0011\t\u0005\u0015\u0013qK\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u00051\u0011\r^8nS\u000eTA!!\u0014\u0002P\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005E\u00131K\u0001\u0005kRLGN\u0003\u0002\u0002V\u0005!!.\u0019<b\u0013\u0011\tI&a\u0012\u0003\u001b\u0005#x.\\5d\u0005>|G.Z1o\u0003%I7/Q2uSZ,\u0007%\u0001\u000biC:$G.Z%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\u000b\bu\u0006\u0005\u0014QOA=\u0011\u001d\t\u0019G\u0006a\u0001\u0003K\nq\u0002\u001e:b]N\f7\r^5p]\u0006d\u0017\n\u001a\t\u0005\u0003O\nyG\u0004\u0003\u0002j\u0005-\u0004cAA\fc%\u0019\u0011QN\u0019\u0002\rA\u0013X\rZ3g\u0013\u0011\t\t(a\u001d\u0003\rM#(/\u001b8h\u0015\r\ti'\r\u0005\u0007\u0003o2\u0002\u0019\u0001\"\u0002)Q\u0014\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'t\u0011\u001d\tYH\u0006a\u0001\u0003{\n\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\u0005}\u0004#D\u0001\u0007\u0003m\u0001(/\u001a9be\u0016Le.\u001b;Qe>$WoY3JIR\u0013\u0018M\\:jiRQ\u0011QQAJ\u0003+\u000b9*a'\u0011\u000b\u0005}4#a\"\u0011\rA\nIIQAG\u0013\r\tY)\r\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u00071\ny)C\u0002\u0002\u0012\u0012\u0012!\u0003\u0016=o)J\fgn]5u\u001b\u0016$\u0018\rZ1uC\"9\u00111M\fA\u0002\u0005\u0015\u0004BBA</\u0001\u0007!\t\u0003\u0004\u0002\u001a^\u0001\rAQ\u0001\u0011G>|'\u000fZ5oCR|'/\u00129pG\"Dq!!(\u0018\u0001\u0004\ty*A\u0006uq:lU\r^1eCR\f\u0007c\u0001\u0017\u0002\"&\u0019\u00111\u0015\u0013\u0003'Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0002A!\fg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_R\u0013\u0018M\\:bGRLwN\u001c\u000b\fu\u0006%\u00161VA[\u0003\u007f\u000b9\u000eC\u0004\u0002da\u0001\r!!\u001a\t\u000f\u00055\u0006\u00041\u0001\u00020\u0006Q\u0001O]8ek\u000e,'/\u00133\u0011\u0007A\n\t,C\u0002\u00024F\u0012A\u0001T8oO\"9\u0011q\u0017\rA\u0002\u0005e\u0016!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u00021\u0003wK1!!02\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\t\t\r\u0007a\u0001\u0003\u0007\f!\u0002]1si&$\u0018n\u001c8t!\u0019\t)-a3\u0002P6\u0011\u0011q\u0019\u0006\u0004\u0003\u0013\f\u0014AC2pY2,7\r^5p]&!\u0011QZAd\u0005\r\u0019V\r\u001e\t\u0005\u0003#\f\u0019.D\u0001^\u0013\r\t).\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u001d\tY\b\u0007a\u0001\u00033\u00042!a \u0012\u0003)yg.\u00127fGRLwN\u001c\u000b\u0006u\u0006}\u00171\u001d\u0005\u0007\u0003CL\u0002\u0019\u0001\"\u0002'QDh\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g.\u00133\t\r\u0005e\u0015\u00041\u0001C\u00035ygNU3tS\u001et\u0017\r^5p]R)!0!;\u0002l\"1\u0011\u0011\u001d\u000eA\u0002\tCq!!'\u001b\u0001\u0004\ti\u000f\u0005\u00031\u0003_\u0014\u0015bAAyc\t1q\n\u001d;j_:\fq\u0005\\8h\u0013:4\u0018\r\\5e'R\fG/\u001a+sC:\u001c\u0018\u000e^5p]\u0006sGMU3ukJtWI\u001d:peRA\u0011q\u001fB\u0001\u0005\u0007\u0011i\u0001E\u0004\u0002z\u0006ux0a\r\u000e\u0005\u0005m(bAA)c%!\u0011q`A~\u0005\u0011aUM\u001a;\t\u000f\u0005\r4\u00041\u0001\u0002f!9!QA\u000eA\u0002\t\u001d\u0011\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f!\ra#\u0011B\u0005\u0004\u0005\u0017!#\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0011\u001d\u0011ya\u0007a\u0001\u0005#\t\u0011\u0003\u001e:b]N\f7\r^5p]J+7/\u001e7u!\u0011\u0011\u0019B!\u0007\u000e\u0005\tU!b\u0001B\f;\u0006A!/Z9vKN$8/\u0003\u0003\u0003\u001c\tU!!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\u0006!\u0002.\u00198eY\u0016,e\u000e\u001a+sC:\u001c\u0018m\u0019;j_:$2B\u001fB\u0011\u0005G\u0011)Ca\n\u0003,!9\u00111\r\u000fA\u0002\u0005\u0015\u0004bBAW9\u0001\u0007\u0011q\u0016\u0005\b\u0003oc\u0002\u0019AA]\u0011\u001d\u0011I\u0003\ba\u0001\u0005#\tq\u0002\u001e=o\u001b\u0006\u00148.\u001a:SKN,H\u000e\u001e\u0005\b\u0003wb\u0002\u0019\u0001B\u0017!\r\tyHE\u0001\u0018iJ\fgn]1di&|g\u000eV8qS\u000e\u001cuN\u001c4jON,\"Aa\r\u0011\t\tU\"qG\u0007\u0003\u0003\u001fJAA!\u000f\u0002P\tQ\u0001K]8qKJ$\u0018.Z:\u0002\u0019A\f'\u000f^5uS>tgi\u001c:\u0015\u0007\t\u0013y\u0004C\u0004\u0002dy\u0001\r!!\u001a\u00023\u0005\u0014wN\u001d;US6,GmT;u)J\fgn]1di&|gn\u001d\u000b\u0002u\u000691\u000f^1siV\u0004Hc\u0001>\u0003J!I!1\n\u0011\u0011\u0002\u0003\u0007!QJ\u0001 K:\f'\r\\3Ue\u0006t7/Y2uS>t\u0017\r\\%e\u000bb\u0004\u0018N]1uS>t\u0007c\u0001\u0019\u0003P%\u0019!\u0011K\u0019\u0003\u000f\t{w\u000e\\3b]\u0006\t2\u000f^1siV\u0004H\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t]#\u0006\u0002B'\u00053Z#Aa\u0017\u0011\t\tu#qM\u0007\u0003\u0005?RAA!\u0019\u0003d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005K\n\u0014AC1o]>$\u0018\r^5p]&!!\u0011\u000eB0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\tg\",H\u000fZ8x]\"9!qN\u0002A\u0002\tE\u0014AB2p]\u001aLw\r\u0005\u0003\u0003t\teTB\u0001B;\u0015\r\u00119\bK\u0001\u0007g\u0016\u0014h/\u001a:\n\t\tm$Q\u000f\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u0003\u0000\r\u0001\rA!!\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feB!!1\u000fBB\u0013\u0011\u0011)I!\u001e\u0003\u001dI+\u0007\u000f\\5dC6\u000bg.Y4fe\")\u0011j\u0001a\u0001\u0015\"9!1R\u0002A\u0002\t5\u0015\u0001\u0003>l\u00072LWM\u001c;\u0011\t\t=%QS\u0007\u0003\u0005#S1Aa%)\u0003\tQ8.\u0003\u0003\u0003\u0018\nE%!D&bM.\f'l[\"mS\u0016tG\u000fC\u0004\u0003\u001c\u000e\u0001\rA!(\u0002\u000f5,GO]5dgB!!q\u0014BR\u001b\t\u0011\tKC\u0002\u0003\u001cvKAA!*\u0003\"\n9Q*\u001a;sS\u000e\u001c\bb\u0002BU\u0007\u0001\u0007!1V\u0001\u000e[\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u0011\t\tM$QV\u0005\u0005\u0005_\u0013)HA\u0007NKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a\u0005\u00063\u000e\u0001\rAW\u0001\u0015S:LG\u000f\u0016:b]N\f7\r^5p]\u0016\u0013(o\u001c:\u0015\u0007]\u00149\f\u0003\u0004\u0003:\u0012\u0001\ra`\u0001\u0006KJ\u0014xN]\u0001\u0018S:LG\u000f\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$2a\u001eB`\u0011\u001d\ti*\u0002a\u0001\u0003\u001b\u0003")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final ProducerIdManager producerIdManager;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig kafkaConfig, ReplicaManager replicaManager, Scheduler scheduler, KafkaZkClient kafkaZkClient, Metrics metrics, MetadataCache metadataCache, Time time) {
        return TransactionCoordinator$.MODULE$.apply(kafkaConfig, replicaManager, scheduler, kafkaZkClient, metrics, metadataCache, time);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionCoordinator transactionCoordinator = this;
        synchronized (transactionCoordinator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Function1<InitProducerIdResult, BoxedUnit> responseCallback) {
        if (transactionalId == null) {
            long producerId = this.producerIdManager.generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
        } else if (transactionalId.isEmpty()) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_REQUEST));
        } else if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.INVALID_TRANSACTION_TIMEOUT));
        } else {
            Right right;
            Tuple2 tuple2;
            Either coordinatorEpochAndMetadata = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable)x0$1 -> {
                Either<Errors, CoordinatorEpochAndTxnMetadata> either;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    long producerId = $this.producerIdManager.generateProducerId();
                    String x$1 = transactionalId;
                    long x$2 = producerId;
                    int x$3 = -1;
                    int x$4 = transactionTimeoutMs;
                    Empty$ x$5 = Empty$.MODULE$;
                    scala.collection.mutable.Set x$6 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
                    long x$7 = $this.time.milliseconds();
                    long x$8 = TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
                    TransactionMetadata createdMetadata = new TransactionMetadata(x$1, x$2, -1, x$4, x$5, (scala.collection.mutable.Set<TopicPartition>)x$6, x$8, x$7);
                    either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
                } else {
                    throw new MatchError((Object)option);
                }
                return either;
            });
            Either result = coordinatorEpochAndMetadata.right().flatMap((Function1 & Serializable)existingEpochAndMetadata -> {
                int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
                return (Either)txnMetadata.inLock((Function0 & Serializable)() -> this.prepareInitProduceIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata));
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors error2 = (Errors)left.value();
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error2));
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                BoxedUnit boxedUnit;
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                TransactionState transactionState = newMetadata.txnState();
                PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                if (!(transactionState != null ? !transactionState.equals(prepareEpochFence$) : prepareEpochFence$ != null)) {
                    this.handleEndTransaction(transactionalId, newMetadata.producerId(), newMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
                        TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                        return BoxedUnit.UNIT;
                    });
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
                        this.sendPidResponseCallback$1(error, transactionalId, newMetadata, responseCallback);
                        return BoxedUnit.UNIT;
                    }, this.txnManager.appendTransactionToLog$default$5());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProduceIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            Left left2;
            TransactionState transactionState = txnMetadata.state();
            boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
            if (bl) {
                left2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
            } else {
                boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
                if (bl2) {
                    TxnTransitMetadata txnTransitMetadata;
                    if (txnMetadata.isProducerEpochExhausted()) {
                        long newProducerId = this.producerIdManager.generateProducerId();
                        txnTransitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds());
                    } else {
                        txnTransitMetadata = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, this.time.milliseconds());
                    }
                    TxnTransitMetadata transitMetadata = txnTransitMetadata;
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (Ongoing$.MODULE$.equals(transactionState)) {
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
                } else {
                    boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                    if (bl3) {
                        String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                        this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                        throw new IllegalStateException(errorMsg);
                    }
                    throw new MatchError((Object)transactionState);
                }
            }
            left = left2;
        }
        return left;
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either result = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable)x0$1 -> {
                Left left;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                    TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                        Left left;
                        block8: {
                            block7: {
                                if (txnMetadata.producerId() != producerId) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                                    return left;
                                }
                                if (txnMetadata.producerEpoch() != producerEpoch) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                                    return left;
                                }
                                if (txnMetadata.pendingTransitionInProgress()) {
                                    left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                    return left;
                                }
                                TransactionState transactionState = txnMetadata.state();
                                PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                                if (!(transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$))) break block7;
                                TransactionState transactionState2 = txnMetadata.state();
                                PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                                if (transactionState2 != null ? !transactionState2.equals(prepareAbort$) : prepareAbort$ != null) break block8;
                            }
                            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            return left;
                        }
                        TransactionState transactionState = txnMetadata.state();
                        Ongoing$ ongoing$ = Ongoing$.MODULE$;
                        if (!(transactionState != null ? !transactionState.equals(ongoing$) : ongoing$ != null) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                            left = package$.MODULE$.Left().apply((Object)Errors.NONE);
                            return left;
                        }
                        left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                        return left;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = result;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function5<String, Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function5 & Serializable)(transactionalId, coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        Option<Object> option = coordinatorEpoch;
        if (option instanceof Some) {
            Some some = (Some)option;
            int epoch = BoxesRunTime.unboxToInt((Object)some.value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").toString()).append(new StringBuilder(23).append("marker result to send: ").append(transactionResult).toString()).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback) {
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
        } else {
            Right right;
            Tuple2 tuple2;
            Either preAppendResult = this.txnManager.getTransactionState(transactionalId).right().flatMap((Function1 & Serializable)x0$1 -> {
                Left left;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                    int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                    left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                        Right right;
                        TransactionState transactionState;
                        Right right2;
                        if (txnMetadata.producerId() != producerId) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            return right2;
                        }
                        if (producerEpoch < txnMetadata.producerEpoch()) {
                            right2 = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            return right2;
                        }
                        if (txnMetadata.pendingTransitionInProgress()) {
                            Object object = txnMetadata.pendingState().get();
                            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                            if (object == null ? prepareEpochFence$ != null : !object.equals(prepareEpochFence$)) {
                                right2 = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                                return right2;
                            }
                        }
                        if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                            Product nextState;
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult2 = TransactionResult.COMMIT;
                            Product product = nextState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : PrepareAbort$.MODULE$;
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (!(product != null ? !product.equals(prepareAbort$) : prepareAbort$ != null) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                                txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                                txnMetadata.producerEpoch_$eq(producerEpoch);
                            }
                            right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                        } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult3 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult4 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult5 = TransactionResult.COMMIT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                            TransactionResult transactionResult = txnMarkerResult;
                            TransactionResult transactionResult6 = TransactionResult.ABORT;
                            right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else if (Empty$.MODULE$.equals(transactionState)) {
                            right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                        } else {
                            boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                            if (!bl) throw new MatchError((Object)transactionState);
                            String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        right2 = right;
                        return right2;
                    });
                } else {
                    throw new MatchError((Object)option);
                }
                return left;
            });
            Either either = preAppendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback.apply((Object)err);
            } else if (either instanceof Right && (tuple2 = (Tuple2)(right = (Right)either).value()) != null) {
                int coordinatorEpoch = tuple2._1$mcI$sp();
                TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
                this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
                    this.sendTxnMarkersCallback$1(error, transactionalId, coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, newMetadata);
                    return BoxedUnit.UNIT;
                }, this.txnManager.appendTransactionToLog$default$5());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)either);
            }
        }
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void abortTimedOutTransactions() {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable)txnIdAndPidEpoch -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$4(this, txnIdAndPidEpoch);
            return BoxedUnit.UNIT;
        });
    }

    public void startup(boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.abortTimedOutTransactions(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        if (enableTransactionalIdExpiration) {
            this.txnManager.enableTransactionalIdExpiration();
        }
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$1() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager.shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        } else {
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(Errors.CONCURRENT_TRANSACTIONS));
        }
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(59).append("Initialized transactionalId ").append(transactionalId$1).append(" with producerId ").append(newMetadata$1.producerId()).append(" and producer ").toString()).append(new StringBuilder(20).append("epoch ").append(newMetadata$1.producerEpoch()).append(" on partition ").toString()).append(new StringBuilder(20).append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId$1)).toString()).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
        } else {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId$1).append("'s InitProducerId request").toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError(error));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$4, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$4).right().flatMap((Function1 & Serializable)x0$1 -> {
                Left left;
                Option option = x0$1;
                if (None$.MODULE$.equals(option)) {
                    String errorMsg = new StringBuilder(0).append(new StringBuilder(72).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").toString()).append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (option instanceof Some) {
                    Some some = (Some)option;
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$4) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId$2) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            } else if (txnMetadata.producerEpoch() != producerEpoch$2) {
                                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_EPOCH);
                            } else if (txnMetadata.pendingTransitionInProgress()) {
                                left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            } else {
                                Left<Errors, Nothing$> left2;
                                TransactionState transactionState = txnMetadata.state();
                                boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                                if (bl) {
                                    left2 = this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                                } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                    left2 = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                    TransactionResult transactionResult = txnMarkerResult$1;
                                    TransactionResult transactionResult3 = TransactionResult.ABORT;
                                    left2 = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                                } else {
                                    boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                    if (bl2) {
                                        String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                                        this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                                        throw new IllegalStateException(errorMsg);
                                    }
                                    throw new MatchError((Object)transactionState);
                                }
                                left = left2;
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(61).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").toString()).append(new StringBuilder(53).append("successfully appended to the log for ").append(transactionalId$4).append(" with old epoch ").append(coordinatorEpoch$4).toString()).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError((Object)option);
                }
                Left left2 = left;
                return left2;
            });
            Either either = preSendResult;
            if (either instanceof Left) {
                Left left = (Left)either;
                Errors err = (Errors)left.value();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult$1).append(" to transaction log and returning ").append(err).append(" error to client for ").append(transactionalId$4).append("'s EndTransaction request").toString());
                BoxedUnit boxedUnit = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            } else {
                Right right;
                Tuple2 tuple2;
                if (!(either instanceof Right) || (tuple2 = (Tuple2)(right = (Right)either).value()) == null) throw new MatchError((Object)either);
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(transactionalId$4, coordinatorEpoch$4, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        } else {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(106).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId$4).append("'s EndTransaction request of ").append(txnMarkerResult$1).append(", ").toString()).append(new StringBuilder(66).append("since appending ").append(newMetadata$2).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch$4).append(" failed").toString()).toString());
            responseCallback$2.apply((Object)error);
        }
    }

    private final void onComplete$1(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        Errors errors = error;
        if (Errors.NONE.equals(errors)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Completed rollback of ongoing transaction for transactionalId ").append(new StringBuilder(15).append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(errors) ? true : (Errors.INVALID_PRODUCER_EPOCH.equals(errors) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(errors));
            if (bl) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").toString()).append(new StringBuilder(32).append("has been cancelled due to error ").append(errors).toString()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").toString()).append(new StringBuilder(20).append("failed due to error ").append(errors).toString()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$5(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Option x0$1) {
        Option option = x0$1;
        if (None$.MODULE$.equals(option)) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
            TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
            Option transitMetadataOpt = (Option)txnMetadata.inLock((Function0 & Serializable)() -> {
                Some some;
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").toString()).append(new StringBuilder(41).append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)txnMetadata.producerId()))).toString());
                    some = None$.MODULE$;
                } else if (txnMetadata.pendingTransitionInProgress()) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append(new StringBuilder(58).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").toString()).append("pending state transition").toString());
                    some = None$.MODULE$;
                } else {
                    some = new Some((Object)txnMetadata.prepareFenceProducerEpoch());
                }
                return some;
            });
            transitMetadataOpt.foreach((Function1 & Serializable)txnTransitMetadata -> {
                $this.handleEndTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, (Function1<Errors, BoxedUnit>)(Function1 & Serializable)error -> {
                    $this.onComplete$1(txnIdAndPidEpoch$2, error);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$4(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).right().foreach((Function1 & Serializable)x0$1 -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$5($this, txnIdAndPidEpoch, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, ProducerIdManager producerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.producerIdManager = producerIdManager;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        Logging.$init$(this);
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
    }
}

