/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import kafka.log.BatchMetadata;
import kafka.log.CorruptSnapshotException;
import kafka.log.Log$;
import kafka.log.ProducerStateEntry;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.SchemaException;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.Crc32C;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ProducerStateManager$ {
    public static final ProducerStateManager$ MODULE$ = new ProducerStateManager$();
    private static final short ProducerSnapshotVersion = 1;
    private static final String VersionField = "version";
    private static final String CrcField = "crc";
    private static final String ProducerIdField = "producer_id";
    private static final String LastSequenceField = "last_sequence";
    private static final String ProducerEpochField = "epoch";
    private static final String LastOffsetField = "last_offset";
    private static final String OffsetDeltaField = "offset_delta";
    private static final String TimestampField = "timestamp";
    private static final String ProducerEntriesField = "producer_entries";
    private static final String CoordinatorEpochField = "coordinator_epoch";
    private static final String CurrentTxnFirstOffsetField = "current_txn_first_offset";
    private static final int VersionOffset = 0;
    private static final int CrcOffset = MODULE$.VersionOffset() + 2;
    private static final int ProducerEntriesOffset = MODULE$.CrcOffset() + 4;
    private static final Schema ProducerSnapshotEntrySchema = new Schema(new Field[]{new Field(MODULE$.ProducerIdField(), (Type)Type.INT64, "The producer ID"), new Field(MODULE$.ProducerEpochField(), (Type)Type.INT16, "Current epoch of the producer"), new Field(MODULE$.LastSequenceField(), (Type)Type.INT32, "Last written sequence of the producer"), new Field(MODULE$.LastOffsetField(), (Type)Type.INT64, "Last written offset of the producer"), new Field(MODULE$.OffsetDeltaField(), (Type)Type.INT32, "The difference of the last sequence and first sequence in the last written batch"), new Field(MODULE$.TimestampField(), (Type)Type.INT64, "Max timestamp from the last written entry"), new Field(MODULE$.CoordinatorEpochField(), (Type)Type.INT32, "The epoch of the last transaction coordinator to send an end transaction marker"), new Field(MODULE$.CurrentTxnFirstOffsetField(), (Type)Type.INT64, "The first offset of the on-going transaction (-1 if there is none)")});
    private static final Schema PidSnapshotMapSchema = new Schema(new Field[]{new Field(MODULE$.VersionField(), (Type)Type.INT16, "Version of the snapshot file"), new Field(MODULE$.CrcField(), (Type)Type.UNSIGNED_INT32, "CRC of the snapshot data"), new Field(MODULE$.ProducerEntriesField(), (Type)new ArrayOf((Type)MODULE$.ProducerSnapshotEntrySchema()), "The entries in the producer table")});

    public int $lessinit$greater$default$3() {
        return 3600000;
    }

    private short ProducerSnapshotVersion() {
        return ProducerSnapshotVersion;
    }

    private String VersionField() {
        return VersionField;
    }

    private String CrcField() {
        return CrcField;
    }

    private String ProducerIdField() {
        return ProducerIdField;
    }

    private String LastSequenceField() {
        return LastSequenceField;
    }

    private String ProducerEpochField() {
        return ProducerEpochField;
    }

    private String LastOffsetField() {
        return LastOffsetField;
    }

    private String OffsetDeltaField() {
        return OffsetDeltaField;
    }

    private String TimestampField() {
        return TimestampField;
    }

    private String ProducerEntriesField() {
        return ProducerEntriesField;
    }

    private String CoordinatorEpochField() {
        return CoordinatorEpochField;
    }

    private String CurrentTxnFirstOffsetField() {
        return CurrentTxnFirstOffsetField;
    }

    private int VersionOffset() {
        return VersionOffset;
    }

    private int CrcOffset() {
        return CrcOffset;
    }

    private int ProducerEntriesOffset() {
        return ProducerEntriesOffset;
    }

    public Schema ProducerSnapshotEntrySchema() {
        return ProducerSnapshotEntrySchema;
    }

    public Schema PidSnapshotMapSchema() {
        return PidSnapshotMapSchema;
    }

    public Iterable<ProducerStateEntry> readSnapshot(File file) {
        ArraySeq.ofRef ofRef2;
        try {
            long computedCrc;
            byte[] buffer = Files.readAllBytes(file.toPath());
            Struct struct = this.PidSnapshotMapSchema().read(ByteBuffer.wrap(buffer));
            Short version = struct.getShort(this.VersionField());
            if (!BoxesRunTime.equalsNumObject((Number)version, (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()))) {
                throw new CorruptSnapshotException(new StringBuilder(43).append("Snapshot contained an unknown file version ").append(version).toString());
            }
            Long crc = struct.getUnsignedInt(this.CrcField());
            if (!BoxesRunTime.equalsNumObject((Number)crc, (Object)BoxesRunTime.boxToLong((long)(computedCrc = Crc32C.compute((byte[])buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.length - this.ProducerEntriesOffset())))))) {
                throw new CorruptSnapshotException(new StringBuilder(0).append("Snapshot is corrupt (CRC is no longer valid). ").append(new StringBuilder(28).append("Stored crc: ").append(crc).append(". Computed crc: ").append(computedCrc).toString()).toString());
            }
            ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(struct.getArray(this.ProducerEntriesField())), (Function1 & Serializable)producerEntryObj -> {
                Struct producerEntryStruct = (Struct)producerEntryObj;
                Long producerId = producerEntryStruct.getLong(MODULE$.ProducerIdField());
                Short producerEpoch = producerEntryStruct.getShort(MODULE$.ProducerEpochField());
                Integer seq = producerEntryStruct.getInt(MODULE$.LastSequenceField());
                Long offset = producerEntryStruct.getLong(MODULE$.LastOffsetField());
                Long timestamp = producerEntryStruct.getLong(MODULE$.TimestampField());
                Integer offsetDelta = producerEntryStruct.getInt(MODULE$.OffsetDeltaField());
                Integer coordinatorEpoch = producerEntryStruct.getInt(MODULE$.CoordinatorEpochField());
                Long currentTxnFirstOffset = producerEntryStruct.getLong(MODULE$.CurrentTxnFirstOffsetField());
                Queue lastAppendedDataBatches = Queue$.MODULE$.empty();
                Object object = Predef$.MODULE$.Long2long(offset) >= 0L ? lastAppendedDataBatches.$plus$eq((Object)new BatchMetadata(Predef$.MODULE$.Integer2int(seq), Predef$.MODULE$.Long2long(offset), Predef$.MODULE$.Integer2int(offsetDelta), Predef$.MODULE$.Long2long(timestamp))) : BoxedUnit.UNIT;
                ProducerStateEntry newEntry = new ProducerStateEntry(Predef$.MODULE$.Long2long(producerId), (Queue<BatchMetadata>)lastAppendedDataBatches, Predef$.MODULE$.Short2short(producerEpoch), Predef$.MODULE$.Integer2int(coordinatorEpoch), Predef$.MODULE$.Long2long(timestamp), (Option<Object>)(Predef$.MODULE$.Long2long(currentTxnFirstOffset) >= 0L ? new Some((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(currentTxnFirstOffset))) : None$.MODULE$));
                return newEntry;
            }, ClassTag$.MODULE$.apply(ProducerStateEntry.class)));
        }
        catch (SchemaException e) {
            throw new CorruptSnapshotException(new StringBuilder(35).append("Snapshot failed schema validation: ").append(e.getMessage()).toString());
        }
        return ofRef2;
    }

    public void kafka$log$ProducerStateManager$$writeSnapshot(File file, Map<Object, ProducerStateEntry> entries) {
        Struct struct = new Struct(this.PidSnapshotMapSchema());
        struct.set(this.VersionField(), (Object)BoxesRunTime.boxToShort((short)this.ProducerSnapshotVersion()));
        struct.set(this.CrcField(), (Object)BoxesRunTime.boxToLong((long)0L));
        Struct[] entriesArray = (Struct[])((IterableOnceOps)entries.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long producerId = tuple2._1$mcJ$sp();
            ProducerStateEntry entry = (ProducerStateEntry)tuple2._2();
            Struct producerEntryStruct = struct.instance(MODULE$.ProducerEntriesField());
            producerEntryStruct.set(MODULE$.ProducerIdField(), (Object)BoxesRunTime.boxToLong((long)producerId)).set(MODULE$.ProducerEpochField(), (Object)BoxesRunTime.boxToShort((short)entry.producerEpoch())).set(MODULE$.LastSequenceField(), (Object)BoxesRunTime.boxToInteger((int)entry.lastSeq())).set(MODULE$.LastOffsetField(), (Object)BoxesRunTime.boxToLong((long)entry.lastDataOffset())).set(MODULE$.OffsetDeltaField(), (Object)BoxesRunTime.boxToInteger((int)entry.lastOffsetDelta())).set(MODULE$.TimestampField(), (Object)BoxesRunTime.boxToLong((long)entry.lastTimestamp())).set(MODULE$.CoordinatorEpochField(), (Object)BoxesRunTime.boxToInteger((int)entry.coordinatorEpoch())).set(MODULE$.CurrentTxnFirstOffsetField(), entry.currentTxnFirstOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            Struct struct = producerEntryStruct;
            return struct;
        })).toArray(ClassTag$.MODULE$.apply(Struct.class));
        struct.set(this.ProducerEntriesField(), (Object)entriesArray);
        ByteBuffer buffer = ByteBuffer.allocate(struct.sizeOf());
        struct.writeTo(buffer);
        buffer.flip();
        long crc = Crc32C.compute((ByteBuffer)buffer, (int)this.ProducerEntriesOffset(), (int)(buffer.limit() - this.ProducerEntriesOffset()));
        ByteUtils.writeUnsignedInt((ByteBuffer)buffer, (int)this.CrcOffset(), (long)crc);
        try (FileChannel fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            fileChannel.write(buffer);
        }
    }

    private boolean isSnapshotFile(File file) {
        return file.getName().endsWith(Log$.MODULE$.ProducerSnapshotFileSuffix());
    }

    public Seq<File> listSnapshotFiles(File dir) {
        return dir.exists() && dir.isDirectory() ? (Seq)Option$.MODULE$.apply((Object)dir.listFiles()).map((Function1 & Serializable)files -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])files), (Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager$.$anonfun$listSnapshotFiles$2(f)))))).getOrElse((Function0 & Serializable)() -> (Seq)Seq$.MODULE$.empty()) : (Seq)Seq$.MODULE$.empty();
    }

    public void deleteSnapshotsBefore(File dir, long offset) {
        this.kafka$log$ProducerStateManager$$deleteSnapshotFiles(dir, (Function1<Object, Object>)(JFunction1.mcZJ.sp & Serializable)x$1 -> x$1 < offset);
    }

    public void kafka$log$ProducerStateManager$$deleteSnapshotFiles(File dir, Function1<Object, Object> predicate) {
        ((IterableOnceOps)this.listSnapshotFiles(dir).filter((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)predicate.apply$mcZJ$sp(Log$.MODULE$.offsetFromFile(file))))).foreach((Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)ProducerStateManager$.$anonfun$deleteSnapshotFiles$2(file)));
    }

    public Function1<Object, Object> kafka$log$ProducerStateManager$$deleteSnapshotFiles$default$2() {
        return (JFunction1.mcZJ.sp & Serializable)x$2 -> true;
    }

    public static final /* synthetic */ boolean $anonfun$listSnapshotFiles$2(File f) {
        return f.isFile() && MODULE$.isSnapshotFile(f);
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$2(File file) {
        return Files.deleteIfExists(file.toPath());
    }

    private ProducerStateManager$() {
    }
}

