/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import kafka.log.AbortedTxn;
import kafka.log.AbortedTxn$;
import kafka.log.CorruptIndexException;
import kafka.log.TxnIndexSearchResult;
import kafka.utils.Logging;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Utils;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001B\u000e\u001d\u0001\u0005B\u0001B\f\u0001\u0003\u0006\u0004%\ta\f\u0005\tg\u0001\u0011\t\u0011)A\u0005a!AA\u0007\u0001BA\u0002\u0013\u0005Q\u0007\u0003\u0005?\u0001\t\u0005\r\u0011\"\u0001@\u0011!)\u0005A!A!B\u00131\u0004\"\u0002&\u0001\t\u0003Y\u0005b\u0002)\u0001\u0001\u0004%I!\u0015\u0005\b;\u0002\u0001\r\u0011\"\u0003_\u0011\u0019\u0001\u0007\u0001)Q\u0005%\"9!\r\u0001a\u0001\n\u0013\u0019\u0007bB3\u0001\u0001\u0004%IA\u001a\u0005\u0007Q\u0002\u0001\u000b\u0015\u00023\t\u000b%\u0004A\u0011\u00016\t\u000bA\u0004A\u0011A9\t\u000bI\u0004A\u0011A:\t\u000b]\u0004A\u0011\u0002=\t\u000be\u0004A\u0011\u0002=\t\u000bi\u0004A\u0011A9\t\u000bm\u0004A\u0011A9\t\u000bq\u0004A\u0011A?\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0001\"CA\"\u0001E\u0005I\u0011BA#\u0011\u001d\tY\u0006\u0001C\u0001\u0003;Bq!!\u001a\u0001\t\u0003\t9\u0007\u0003\u0004\u0002x\u0001!\t!\u001d\u0002\u0011)J\fgn]1di&|g.\u00138eKbT!!\b\u0010\u0002\u00071|wMC\u0001 \u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0012)!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0006L\u0007\u0002U)\u00111FH\u0001\u0006kRLGn]\u0005\u0003[)\u0012q\u0001T8hO&tw-A\u0006ti\u0006\u0014Ho\u00144gg\u0016$X#\u0001\u0019\u0011\u0005\r\n\u0014B\u0001\u001a%\u0005\u0011auN\\4\u0002\u0019M$\u0018M\u001d;PM\u001a\u001cX\r\u001e\u0011\u0002\t\u0019LG.Z\u000b\u0002mA\u0011q\u0007P\u0007\u0002q)\u0011\u0011HO\u0001\u0003S>T\u0011aO\u0001\u0005U\u00064\u0018-\u0003\u0002>q\t!a)\u001b7f\u0003!1\u0017\u000e\\3`I\u0015\fHC\u0001!D!\t\u0019\u0013)\u0003\u0002CI\t!QK\\5u\u0011\u001d!E!!AA\u0002Y\n1\u0001\u001f\u00132\u0003\u00151\u0017\u000e\\3!Q\t)q\t\u0005\u0002$\u0011&\u0011\u0011\n\n\u0002\tm>d\u0017\r^5mK\u00061A(\u001b8jiz\"2\u0001\u0014(P!\ti\u0005!D\u0001\u001d\u0011\u0015qc\u00011\u00011\u0011\u0015!d\u00011\u00017\u00031i\u0017-\u001f2f\u0007\"\fgN\\3m+\u0005\u0011\u0006cA\u0012T+&\u0011A\u000b\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016\u0001C2iC:tW\r\\:\u000b\u0005iS\u0014a\u00018j_&\u0011Al\u0016\u0002\f\r&dWm\u00115b]:,G.\u0001\tnCf\u0014Wm\u00115b]:,Gn\u0018\u0013fcR\u0011\u0001i\u0018\u0005\b\t\"\t\t\u00111\u0001S\u00035i\u0017-\u001f2f\u0007\"\fgN\\3mA!\u0012\u0011bR\u0001\u000bY\u0006\u001cHo\u00144gg\u0016$X#\u00013\u0011\u0007\r\u001a\u0006'\u0001\bmCN$xJ\u001a4tKR|F%Z9\u0015\u0005\u0001;\u0007b\u0002#\f\u0003\u0003\u0005\r\u0001Z\u0001\fY\u0006\u001cHo\u00144gg\u0016$\b%\u0001\u0004baB,g\u000e\u001a\u000b\u0003\u0001.DQ\u0001\\\u0007A\u00025\f!\"\u00192peR,G\r\u0016=o!\tie.\u0003\u0002p9\tQ\u0011IY8si\u0016$G\u000b\u001f8\u0002\u000b\u0019dWo\u001d5\u0015\u0003\u0001\u000ba\u0002Z3mKR,\u0017JZ#ySN$8\u000fF\u0001u!\t\u0019S/\u0003\u0002wI\t9!i\\8mK\u0006t\u0017aB2iC:tW\r\u001c\u000b\u0002+\u0006Yq\u000e]3o\u0007\"\fgN\\3m\u0003\u0015\u0011Xm]3u\u0003\u0015\u0019Gn\\:f\u0003!\u0011XM\\1nKR{GC\u0001!\u007f\u0011\u0015yH\u00031\u00017\u0003\u00051\u0017A\u0003;sk:\u001c\u0017\r^3U_R\u0019\u0001)!\u0002\t\r\u0005\u001dQ\u00031\u00011\u0003\u0019ygMZ:fi\u0006A\u0011\u000e^3sCR|'\u000f\u0006\u0003\u0002\u000e\u0005E\u0002CBA\b\u0003?\t)C\u0004\u0003\u0002\u0012\u0005ma\u0002BA\n\u00033i!!!\u0006\u000b\u0007\u0005]\u0001%\u0001\u0004=e>|GOP\u0005\u0002K%\u0019\u0011Q\u0004\u0013\u0002\u000fA\f7m[1hK&!\u0011\u0011EA\u0012\u0005!IE/\u001a:bi>\u0014(bAA\u000fIA11%a\nn\u0003WI1!!\u000b%\u0005\u0019!V\u000f\u001d7feA\u00191%!\f\n\u0007\u0005=BEA\u0002J]RD\u0011\"a\r\u0017!\u0003\u0005\r!!\u000e\u0002\u0011\u0005dGn\\2bi\u0016\u0004RaIA\u001c\u0003wI1!!\u000f%\u0005%1UO\\2uS>t\u0007\u0007\u0005\u0003\u0002>\u0005}R\"A-\n\u0007\u0005\u0005\u0013L\u0001\u0006CsR,')\u001e4gKJ\f!#\u001b;fe\u0006$xN\u001d\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u0005\u0003k\tIe\u000b\u0002\u0002LA!\u0011QJA,\u001b\t\tyE\u0003\u0003\u0002R\u0005M\u0013!C;oG\",7m[3e\u0015\r\t)\u0006J\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA-\u0003\u001f\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\tG\u000e\\!c_J$X\r\u001a+y]N,\"!a\u0018\u0011\u000b\u0005=\u0011\u0011M7\n\t\u0005\r\u00141\u0005\u0002\u0005\u0019&\u001cH/\u0001\nd_2dWm\u0019;BE>\u0014H/\u001a3Uq:\u001cHCBA5\u0003_\n\u0019\bE\u0002N\u0003WJ1!!\u001c\u001d\u0005Q!\u0006P\\%oI\u0016D8+Z1sG\"\u0014Vm];mi\"1\u0011\u0011O\rA\u0002A\n1BZ3uG\"|eMZ:fi\"1\u0011QO\rA\u0002A\n\u0001#\u001e9qKJ\u0014u.\u001e8e\u001f\u001a47/\u001a;\u0002\u0017M\fg.\u001b;z\u0007\",7m\u001b\u0015\u0004\u0001\u0005m\u0004cA\u0015\u0002~%\u0019\u0011q\u0010\u0016\u0003\u001b9|g\u000e\u001e5sK\u0006$7/\u00194f\u0001")
public class TransactionIndex
implements Logging {
    private final long startOffset;
    private volatile File file;
    private volatile Option<FileChannel> maybeChannel;
    private Option<Object> lastOffset;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TransactionIndex transactionIndex = this;
        synchronized (transactionIndex) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public File file() {
        return this.file;
    }

    public void file_$eq(File x$1) {
        this.file = x$1;
    }

    private Option<FileChannel> maybeChannel() {
        return this.maybeChannel;
    }

    private void maybeChannel_$eq(Option<FileChannel> x$1) {
        this.maybeChannel = x$1;
    }

    private Option<Object> lastOffset() {
        return this.lastOffset;
    }

    private void lastOffset_$eq(Option<Object> x$1) {
        this.lastOffset = x$1;
    }

    public void append(AbortedTxn abortedTxn) {
        this.lastOffset().foreach((Function1)(JFunction1.mcVJ.sp & Serializable)offset -> {
            if (offset >= abortedTxn.lastOffset()) {
                throw new IllegalArgumentException(new java.lang.StringBuilder(0).append("The last offset of appended transactions must increase sequentially, but ").append(new java.lang.StringBuilder(51).append(abortedTxn.lastOffset()).append(" is not greater than current last offset ").append(offset).append(" of index ").append(this.file().getAbsolutePath()).toString()).toString());
            }
        });
        this.lastOffset_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)abortedTxn.lastOffset())));
        Utils.writeFully((FileChannel)this.channel(), (ByteBuffer)abortedTxn.buffer().duplicate());
    }

    public void flush() {
        this.maybeChannel().foreach((Function1 & Serializable)x$1 -> {
            x$1.force(true);
            return BoxedUnit.UNIT;
        });
    }

    public boolean deleteIfExists() {
        this.close();
        return Files.deleteIfExists(this.file().toPath());
    }

    private FileChannel channel() {
        FileChannel fileChannel;
        Option<FileChannel> option = this.maybeChannel();
        if (option instanceof Some) {
            FileChannel channel;
            Some some = (Some)option;
            fileChannel = channel = (FileChannel)some.value();
        } else if (None$.MODULE$.equals(option)) {
            fileChannel = this.openChannel();
        } else {
            throw new MatchError(option);
        }
        return fileChannel;
    }

    /*
     * WARNING - void declaration
     */
    private FileChannel openChannel() {
        void var1_1;
        FileChannel channel = FileChannel.open(this.file().toPath(), StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.maybeChannel_$eq((Option<FileChannel>)new Some((Object)channel));
        channel.position(channel.size());
        return var1_1;
    }

    public void reset() {
        this.maybeChannel().foreach((Function1 & Serializable)x$2 -> x$2.truncate(0L));
        this.lastOffset_$eq((Option<Object>)None$.MODULE$);
    }

    public void close() {
        this.maybeChannel().foreach((Function1 & Serializable)x$3 -> {
            x$3.close();
            return BoxedUnit.UNIT;
        });
        this.maybeChannel_$eq((Option<FileChannel>)None$.MODULE$);
    }

    public void renameTo(File f) {
        try {
            if (this.file().exists()) {
                Utils.atomicMoveWithFallback((Path)this.file().toPath(), (Path)f.toPath());
            }
        }
        finally {
            this.file_$eq(f);
        }
    }

    public void truncateTo(long offset) {
        Object object = new Object();
        try {
            ByteBuffer buffer = ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
            ObjectRef newLastOffset = ObjectRef.create((Object)None$.MODULE$);
            this.iterator((Function0<ByteBuffer>)(Function0 & Serializable)() -> buffer).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionIndex.$anonfun$truncateTo$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$4 -> {
                TransactionIndex.$anonfun$truncateTo$3(this, offset, newLastOffset, object, x$4);
                return BoxedUnit.UNIT;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    private Iterator<Tuple2<AbortedTxn, Object>> iterator(Function0<ByteBuffer> allocate) {
        Iterator iterator;
        Option<FileChannel> option = this.maybeChannel();
        if (None$.MODULE$.equals(option)) {
            iterator = package$.MODULE$.Iterator().empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            FileChannel channel = (FileChannel)some.value();
            IntRef position = IntRef.create((int)0);
            iterator = new Iterator<Tuple2<AbortedTxn, Object>>(this, channel, position, allocate){
                private final /* synthetic */ TransactionIndex $outer;
                private final FileChannel channel$1;
                private final IntRef position$1;
                private final Function0 allocate$1;

                public final boolean hasDefiniteSize() {
                    return Iterator.hasDefiniteSize$((Iterator)this);
                }

                public final Iterator<Tuple2<AbortedTxn, Object>> iterator() {
                    return Iterator.iterator$((Iterator)this);
                }

                public Option<Tuple2<AbortedTxn, Object>> nextOption() {
                    return Iterator.nextOption$((Iterator)this);
                }

                public boolean contains(Object elem) {
                    return Iterator.contains$((Iterator)this, (Object)elem);
                }

                public BufferedIterator<Tuple2<AbortedTxn, Object>> buffered() {
                    return Iterator.buffered$((Iterator)this);
                }

                public <B> Iterator<B> padTo(int len, B elem) {
                    return Iterator.padTo$((Iterator)this, (int)len, elem);
                }

                public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> partition(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.partition$((Iterator)this, p);
                }

                public <B> Iterator.GroupedIterator<B> grouped(int size) {
                    return Iterator.grouped$((Iterator)this, (int)size);
                }

                public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                    return Iterator.sliding$((Iterator)this, (int)size, (int)step);
                }

                public <B> int sliding$default$2() {
                    return Iterator.sliding$default$2$((Iterator)this);
                }

                public <B> Iterator<B> scanLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                    return Iterator.scanLeft$((Iterator)this, z, op);
                }

                public <B> Iterator<B> scanRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                    return Iterator.scanRight$((Iterator)this, z, op);
                }

                public int indexWhere(Function1<Tuple2<AbortedTxn, Object>, Object> p, int from) {
                    return Iterator.indexWhere$((Iterator)this, p, (int)from);
                }

                public int indexWhere$default$2() {
                    return Iterator.indexWhere$default$2$((Iterator)this);
                }

                public <B> int indexOf(B elem) {
                    return Iterator.indexOf$((Iterator)this, elem);
                }

                public <B> int indexOf(B elem, int from) {
                    return Iterator.indexOf$((Iterator)this, elem, (int)from);
                }

                public final int length() {
                    return Iterator.length$((Iterator)this);
                }

                public boolean isEmpty() {
                    return Iterator.isEmpty$((Iterator)this);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> filter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.filter$((Iterator)this, p);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> filterNot(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.filterNot$((Iterator)this, p);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> filterImpl(Function1<Tuple2<AbortedTxn, Object>, Object> p, boolean isFlipped) {
                    return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> withFilter(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.withFilter$((Iterator)this, p);
                }

                public <B> Iterator<B> collect(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                    return Iterator.collect$((Iterator)this, pf);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> distinct() {
                    return Iterator.distinct$((Iterator)this);
                }

                public <B> Iterator<Tuple2<AbortedTxn, Object>> distinctBy(Function1<Tuple2<AbortedTxn, Object>, B> f) {
                    return Iterator.distinctBy$((Iterator)this, f);
                }

                public <B> Iterator<B> map(Function1<Tuple2<AbortedTxn, Object>, B> f) {
                    return Iterator.map$((Iterator)this, f);
                }

                public <B> Iterator<B> flatMap(Function1<Tuple2<AbortedTxn, Object>, IterableOnce<B>> f) {
                    return Iterator.flatMap$((Iterator)this, f);
                }

                public <B> Iterator<B> flatten(Function1<Tuple2<AbortedTxn, Object>, IterableOnce<B>> ev) {
                    return Iterator.flatten$((Iterator)this, ev);
                }

                public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                    return Iterator.concat$((Iterator)this, xs);
                }

                public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                    return Iterator.$plus$plus$((Iterator)this, xs);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> take(int n) {
                    return Iterator.take$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> takeWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.takeWhile$((Iterator)this, p);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> drop(int n) {
                    return Iterator.drop$((Iterator)this, (int)n);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> dropWhile(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.dropWhile$((Iterator)this, p);
                }

                public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> span(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return Iterator.span$((Iterator)this, p);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> slice(int from, int until) {
                    return Iterator.slice$((Iterator)this, (int)from, (int)until);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> sliceIterator(int from, int until) {
                    return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
                }

                public <B> Iterator<Tuple2<Tuple2<AbortedTxn, Object>, B>> zip(IterableOnce<B> that) {
                    return Iterator.zip$((Iterator)this, that);
                }

                public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                    return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
                }

                public Iterator<Tuple2<Tuple2<AbortedTxn, Object>, Object>> zipWithIndex() {
                    return Iterator.zipWithIndex$((Iterator)this);
                }

                public <B> boolean sameElements(IterableOnce<B> that) {
                    return Iterator.sameElements$((Iterator)this, that);
                }

                public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> duplicate() {
                    return Iterator.duplicate$((Iterator)this);
                }

                public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                    return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
                }

                public <U> Iterator<Tuple2<AbortedTxn, Object>> tapEach(Function1<Tuple2<AbortedTxn, Object>, U> f) {
                    return Iterator.tapEach$((Iterator)this, f);
                }

                public String toString() {
                    return Iterator.toString$((Iterator)this);
                }

                public Iterator<Tuple2<AbortedTxn, Object>> seq() {
                    return Iterator.seq$((Iterator)this);
                }

                public Tuple2<Iterator<Tuple2<AbortedTxn, Object>>, Iterator<Tuple2<AbortedTxn, Object>>> splitAt(int n) {
                    return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
                }

                public boolean isTraversableAgain() {
                    return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
                }

                public <U> void foreach(Function1<Tuple2<AbortedTxn, Object>, U> f) {
                    IterableOnceOps.foreach$((IterableOnceOps)this, f);
                }

                public boolean forall(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return IterableOnceOps.forall$((IterableOnceOps)this, p);
                }

                public boolean exists(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return IterableOnceOps.exists$((IterableOnceOps)this, p);
                }

                public int count(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return IterableOnceOps.count$((IterableOnceOps)this, p);
                }

                public Option<Tuple2<AbortedTxn, Object>> find(Function1<Tuple2<AbortedTxn, Object>, Object> p) {
                    return IterableOnceOps.find$((IterableOnceOps)this, p);
                }

                public <B> B foldLeft(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                    return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                }

                public <B> B foldRight(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                    return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                }

                public final <B> B $div$colon(B z, Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                    return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                }

                public final <B> B $colon$bslash(B z, Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                    return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                }

                public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                    return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                }

                public <B> B reduce(Function2<B, B, B> op) {
                    return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                    return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                }

                public <B> B reduceLeft(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                    return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                }

                public <B> B reduceRight(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                    return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceLeftOption(Function2<B, Tuple2<AbortedTxn, Object>, B> op) {
                    return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                }

                public <B> Option<B> reduceRightOption(Function2<Tuple2<AbortedTxn, Object>, B, B> op) {
                    return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                }

                public boolean nonEmpty() {
                    return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                }

                public int size() {
                    return IterableOnceOps.size$((IterableOnceOps)this);
                }

                public final <B> void copyToBuffer(Buffer<B> dest) {
                    IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                }

                public <B> int copyToArray(Object xs) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                }

                public <B> int copyToArray(Object xs, int start) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                }

                public <B> int copyToArray(Object xs, int start, int len) {
                    return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                }

                public <B> B sum(Numeric<B> num) {
                    return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                }

                public <B> B product(Numeric<B> num) {
                    return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                }

                public Object min(Ordering ord) {
                    return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Tuple2<AbortedTxn, Object>> minOption(Ordering<B> ord) {
                    return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                }

                public Object max(Ordering ord) {
                    return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                }

                public <B> Option<Tuple2<AbortedTxn, Object>> maxOption(Ordering<B> ord) {
                    return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                }

                public Object maxBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B> Option<Tuple2<AbortedTxn, Object>> maxByOption(Function1<Tuple2<AbortedTxn, Object>, B> f, Ordering<B> cmp) {
                    return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                }

                public Object minBy(Function1 f, Ordering cmp) {
                    return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                }

                public <B> Option<Tuple2<AbortedTxn, Object>> minByOption(Function1<Tuple2<AbortedTxn, Object>, B> f, Ordering<B> cmp) {
                    return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                }

                public <B> Option<B> collectFirst(PartialFunction<Tuple2<AbortedTxn, Object>, B> pf) {
                    return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                }

                public <B> B aggregate(Function0<B> z, Function2<B, Tuple2<AbortedTxn, Object>, B> seqop, Function2<B, B, B> combop) {
                    return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                }

                public <B> boolean corresponds(IterableOnce<B> that, Function2<Tuple2<AbortedTxn, Object>, B, Object> p) {
                    return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                }

                public final String mkString(String start, String sep, String end) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                }

                public final String mkString(String sep) {
                    return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                }

                public final String mkString() {
                    return IterableOnceOps.mkString$((IterableOnceOps)this);
                }

                public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                }

                public final StringBuilder addString(StringBuilder b, String sep) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                }

                public final StringBuilder addString(StringBuilder b) {
                    return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                }

                public <C1> C1 to(Factory<Tuple2<AbortedTxn, Object>, C1> factory) {
                    return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                }

                public final Iterator<Tuple2<AbortedTxn, Object>> toIterator() {
                    return IterableOnceOps.toIterator$((IterableOnceOps)this);
                }

                public List<Tuple2<AbortedTxn, Object>> toList() {
                    return IterableOnceOps.toList$((IterableOnceOps)this);
                }

                public Vector<Tuple2<AbortedTxn, Object>> toVector() {
                    return IterableOnceOps.toVector$((IterableOnceOps)this);
                }

                public <K$, V$> Map<K$, V$> toMap(.less.colon.less<Tuple2<AbortedTxn, Object>, Tuple2<K$, V$>> ev) {
                    return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                }

                public <B> Set<B> toSet() {
                    return IterableOnceOps.toSet$((IterableOnceOps)this);
                }

                public Seq<Tuple2<AbortedTxn, Object>> toSeq() {
                    return IterableOnceOps.toSeq$((IterableOnceOps)this);
                }

                public IndexedSeq<Tuple2<AbortedTxn, Object>> toIndexedSeq() {
                    return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                }

                public final Stream<Tuple2<AbortedTxn, Object>> toStream() {
                    return IterableOnceOps.toStream$((IterableOnceOps)this);
                }

                public final <B> Buffer<B> toBuffer() {
                    return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                }

                public <B> Object toArray(ClassTag<B> evidence$2) {
                    return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                }

                public Iterable<Tuple2<AbortedTxn, Object>> reversed() {
                    return IterableOnceOps.reversed$((IterableOnceOps)this);
                }

                public <S extends Stepper<?>> S stepper(StepperShape<Tuple2<AbortedTxn, Object>, S> shape) {
                    return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                }

                public int knownSize() {
                    return IterableOnce.knownSize$((IterableOnce)this);
                }

                public boolean hasNext() {
                    return this.channel$1.position() - (long)this.position$1.elem >= (long)AbortedTxn$.MODULE$.TotalSize();
                }

                /*
                 * WARNING - void declaration
                 */
                public Tuple2<AbortedTxn, Object> next() {
                    void v0;
                    try {
                        void var3_3;
                        ByteBuffer buffer = (ByteBuffer)this.allocate$1.apply();
                        Utils.readFully((FileChannel)this.channel$1, (ByteBuffer)buffer, (long)this.position$1.elem);
                        buffer.flip();
                        AbortedTxn abortedTxn = new AbortedTxn(buffer);
                        if (abortedTxn.version() > AbortedTxn$.MODULE$.CurrentVersion()) {
                            throw new KafkaException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(40).append("Unexpected aborted transaction version ").append(abortedTxn.version()).append(" ").toString()).append(new java.lang.StringBuilder(42).append("in transaction index ").append(this.$outer.file().getAbsolutePath()).append(", current version is ").append(AbortedTxn$.MODULE$.CurrentVersion()).toString()).toString());
                        }
                        Tuple2 nextEntry = new Tuple2((Object)abortedTxn, (Object)BoxesRunTime.boxToInteger((int)this.position$1.elem));
                        this.position$1.elem += AbortedTxn$.MODULE$.TotalSize();
                        v0 = var3_3;
                    }
                    catch (IOException e) {
                        throw new KafkaException(new java.lang.StringBuilder(42).append("Failed to read from the transaction index ").append(this.$outer.file().getAbsolutePath()).toString(), (Throwable)e);
                    }
                    return v0;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.channel$1 = channel$1;
                    this.position$1 = position$1;
                    this.allocate$1 = allocate$1;
                    IterableOnce.$init$((IterableOnce)this);
                    IterableOnceOps.$init$((IterableOnceOps)this);
                    Iterator.$init$((Iterator)this);
                }
            };
        } else {
            throw new MatchError(option);
        }
        return iterator;
    }

    private Function0<ByteBuffer> iterator$default$1() {
        return (Function0 & Serializable)() -> ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
    }

    public List<AbortedTxn> allAbortedTxns() {
        return this.iterator(this.iterator$default$1()).map((Function1 & Serializable)x$5 -> (AbortedTxn)x$5._1()).toList();
    }

    public TxnIndexSearchResult collectAbortedTxns(long fetchOffset, long upperBoundOffset) {
        TxnIndexSearchResult txnIndexSearchResult;
        Object object = new Object();
        try {
            ListBuffer abortedTransactions = ListBuffer$.MODULE$.empty();
            this.iterator(this.iterator$default$1()).withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionIndex.$anonfun$collectAbortedTxns$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$6 -> {
                TransactionIndex.$anonfun$collectAbortedTxns$2(fetchOffset, upperBoundOffset, abortedTransactions, object, x$6);
                return BoxedUnit.UNIT;
            });
            txnIndexSearchResult = new TxnIndexSearchResult((List<AbortedTxn>)abortedTransactions.toList(), false);
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                txnIndexSearchResult = (TxnIndexSearchResult)ex.value();
            }
            throw ex;
        }
        return txnIndexSearchResult;
    }

    public void sanityCheck() {
        ByteBuffer buffer = ByteBuffer.allocate(AbortedTxn$.MODULE$.TotalSize());
        this.iterator((Function0<ByteBuffer>)(Function0 & Serializable)() -> buffer).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionIndex.$anonfun$sanityCheck$2(check$ifrefutable$3))).foreach((Function1 & Serializable)x$7 -> {
            TransactionIndex.$anonfun$sanityCheck$3(this, x$7);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$truncateTo$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$truncateTo$3(TransactionIndex $this, long offset$1, ObjectRef newLastOffset$1, Object nonLocalReturnKey1$1, Tuple2 x$4) {
        AbortedTxn abortedTxn;
        Tuple2 tuple2 = x$4;
        if (tuple2 != null) {
            abortedTxn = (AbortedTxn)tuple2._1();
            int position = tuple2._2$mcI$sp();
            if (abortedTxn.lastOffset() >= offset$1) {
                $this.channel().truncate(position);
                $this.lastOffset_$eq((Option<Object>)((Option)newLastOffset$1.elem));
                throw new NonLocalReturnControl.mcV.sp(nonLocalReturnKey1$1, BoxedUnit.UNIT);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        newLastOffset$1.elem = new Some((Object)BoxesRunTime.boxToLong((long)abortedTxn.lastOffset()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$collectAbortedTxns$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$collectAbortedTxns$2(long fetchOffset$1, long upperBoundOffset$1, ListBuffer abortedTransactions$1, Object nonLocalReturnKey2$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)tuple2._1();
            Object object = abortedTxn.lastOffset() >= fetchOffset$1 && abortedTxn.firstOffset() < upperBoundOffset$1 ? abortedTransactions$1.$plus$eq((Object)abortedTxn) : BoxedUnit.UNIT;
            if (abortedTxn.lastStableOffset() >= upperBoundOffset$1) {
                throw new NonLocalReturnControl(nonLocalReturnKey2$1, (Object)new TxnIndexSearchResult((List<AbortedTxn>)abortedTransactions$1.toList(), true));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$sanityCheck$2(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$sanityCheck$3(TransactionIndex $this, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            AbortedTxn abortedTxn = (AbortedTxn)tuple2._1();
            if (abortedTxn.lastOffset() < $this.startOffset()) {
                throw new CorruptIndexException(new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(45).append("Last offset of aborted transaction ").append(abortedTxn).append(" in index ").toString()).append(new java.lang.StringBuilder(27).append($this.file().getAbsolutePath()).append(" is less than start offset ").append($this.startOffset()).toString()).toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TransactionIndex(long startOffset, File file) {
        this.startOffset = startOffset;
        this.file = file;
        Logging.$init$(this);
        this.maybeChannel = None$.MODULE$;
        this.lastOffset = None$.MODULE$;
        Object object = this.file().exists() ? this.openChannel() : BoxedUnit.UNIT;
    }
}

