/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.network.ConnectionQuotas;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.network.ListenerName;
import org.slf4j.event.Level;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005m4a!\u0005\n\u0002\u0002Q1\u0002\u0002\u0003\u0015\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0016\t\u000b9\u0002A\u0011A\u0018\t\u000fI\u0002!\u0019!C\u0005g!1A\b\u0001Q\u0001\nQBq!\u0010\u0001A\u0002\u0013%1\u0007C\u0004?\u0001\u0001\u0007I\u0011B \t\r!\u0003\u0001\u0015)\u00035\u0011\u001di\u0005A1A\u0005\n9Ca!\u0016\u0001!\u0002\u0013y\u0005\"\u0002,\u0001\r\u00039\u0006\"\u0002-\u0001\t\u00039\u0006\"B-\u0001\t\u00039\u0006\"\u0002.\u0001\t#9\u0006\"B.\u0001\t#9\u0006\"\u0002/\u0001\t#i\u0006\"B1\u0001\t\u0003\u0011'\u0001F!cgR\u0014\u0018m\u0019;TKJ4XM\u001d+ie\u0016\fGM\u0003\u0002\u0014)\u00059a.\u001a;x_J\\'\"A\u000b\u0002\u000b-\fgm[1\u0014\t\u00019rD\t\t\u00031ui\u0011!\u0007\u0006\u00035m\tA\u0001\\1oO*\tA$\u0001\u0003kCZ\f\u0017B\u0001\u0010\u001a\u0005\u0019y%M[3diB\u0011\u0001\u0004I\u0005\u0003Ce\u0011\u0001BU;o]\u0006\u0014G.\u001a\t\u0003G\u0019j\u0011\u0001\n\u0006\u0003KQ\tQ!\u001e;jYNL!a\n\u0013\u0003\u000f1{wmZ5oO\u0006\u00012m\u001c8oK\u000e$\u0018n\u001c8Rk>$\u0018m]\u0002\u0001!\tYC&D\u0001\u0013\u0013\ti#C\u0001\tD_:tWm\u0019;j_:\fVo\u001c;bg\u00061A(\u001b8jiz\"\"\u0001M\u0019\u0011\u0005-\u0002\u0001\"\u0002\u0015\u0003\u0001\u0004Q\u0013\u0001D:uCJ$X\u000f\u001d'bi\u000eDW#\u0001\u001b\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014AC2p]\u000e,(O]3oi*\u0011\u0011hG\u0001\u0005kRLG.\u0003\u0002<m\tq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0017!D:uCJ$X\u000f\u001d'bi\u000eD\u0007%A\u0007tQV$Hm\\<o\u0019\u0006$8\r[\u0001\u0012g\",H\u000fZ8x]2\u000bGo\u00195`I\u0015\fHC\u0001!G!\t\tE)D\u0001C\u0015\u0005\u0019\u0015!B:dC2\f\u0017BA#C\u0005\u0011)f.\u001b;\t\u000f\u001d3\u0011\u0011!a\u0001i\u0005\u0019\u0001\u0010J\u0019\u0002\u001dMDW\u000f\u001e3po:d\u0015\r^2iA!\u0012qA\u0013\t\u0003\u0003.K!\u0001\u0014\"\u0003\u0011Y|G.\u0019;jY\u0016\fQ!\u00197jm\u0016,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%Z\na!\u0019;p[&\u001c\u0017B\u0001+R\u00055\tEo\\7jG\n{w\u000e\\3b]\u00061\u0011\r\\5wK\u0002\naa^1lKV\u0004H#\u0001!\u0002\u0011MDW\u000f\u001e3po:\fA\"Y<bSR\u001cF/\u0019:ukB\fqb\u001d;beR,\boQ8na2,G/Z\u0001\u0011g\",H\u000fZ8x]\u000e{W\u000e\u001d7fi\u0016\f\u0011\"[:Sk:t\u0017N\\4\u0016\u0003y\u0003\"!Q0\n\u0005\u0001\u0014%a\u0002\"p_2,\u0017M\\\u0001\u0006G2|7/\u001a\u000b\u0004\u0001\u000e\f\b\"\u00023\u0011\u0001\u0004)\u0017\u0001\u00047jgR,g.\u001a:OC6,\u0007C\u00014p\u001b\u00059'BA\ni\u0015\tI'.\u0001\u0004d_6lwN\u001c\u0006\u0003+-T!\u0001\\7\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0017aA8sO&\u0011\u0001o\u001a\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\u0006eB\u0001\ra]\u0001\bG\"\fgN\\3m!\t!\u00180D\u0001v\u0015\t1x/\u0001\u0005dQ\u0006tg.\u001a7t\u0015\tA8$A\u0002oS>L!A_;\u0003\u001bM{7m[3u\u0007\"\fgN\\3m\u0001")
public abstract class AbstractServerThread
implements Runnable,
Logging {
    private final ConnectionQuotas connectionQuotas;
    private final CountDownLatch startupLatch;
    private volatile CountDownLatch shutdownLatch;
    private final AtomicBoolean alive;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        AbstractServerThread abstractServerThread = this;
        synchronized (abstractServerThread) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private CountDownLatch startupLatch() {
        return this.startupLatch;
    }

    private CountDownLatch shutdownLatch() {
        return this.shutdownLatch;
    }

    private void shutdownLatch_$eq(CountDownLatch x$1) {
        this.shutdownLatch = x$1;
    }

    private AtomicBoolean alive() {
        return this.alive;
    }

    public abstract void wakeup();

    public void shutdown() {
        if (this.alive().getAndSet(false)) {
            this.wakeup();
        }
        this.shutdownLatch().await();
    }

    public void awaitStartup() {
        this.startupLatch().await();
    }

    public void startupComplete() {
        this.shutdownLatch_$eq(new CountDownLatch(1));
        this.startupLatch().countDown();
    }

    public void shutdownComplete() {
        this.shutdownLatch().countDown();
    }

    public boolean isRunning() {
        return this.alive().get();
    }

    public void close(ListenerName listenerName, SocketChannel channel) {
        block0: {
            if (channel == null) break block0;
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append("Closing connection from ").append(channel.socket().getRemoteSocketAddress()).toString());
            this.connectionQuotas.dec(listenerName, channel.socket().getInetAddress());
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.socket().close(), this, Level.ERROR);
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> channel.close(), this, Level.ERROR);
        }
    }

    public AbstractServerThread(ConnectionQuotas connectionQuotas) {
        this.connectionQuotas = connectionQuotas;
        Logging.$init$(this);
        this.startupLatch = new CountDownLatch(1);
        this.shutdownLatch = new CountDownLatch(0);
        this.alive = new AtomicBoolean(true);
    }
}

