/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsReporter;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;

public final class KafkaServer$ {
    public static final KafkaServer$ MODULE$ = new KafkaServer$();
    private static final long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS = 120000L;

    public Time $lessinit$greater$default$2() {
        return Time.SYSTEM;
    }

    public Option<String> $lessinit$greater$default$3() {
        return None$.MODULE$;
    }

    public Seq<KafkaMetricsReporter> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> copyKafkaConfigToLog(KafkaConfig kafkaConfig) {
        void var2_2;
        HashMap<String, Object> logProps = new HashMap<String, Object>();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), kafkaConfig.logSegmentBytes());
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), kafkaConfig.logRollTimeMillis());
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), kafkaConfig.logRollTimeJitterMillis());
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), kafkaConfig.logIndexSizeMaxBytes());
        logProps.put(LogConfig$.MODULE$.FlushMessagesProp(), kafkaConfig.logFlushIntervalMessages());
        logProps.put(LogConfig$.MODULE$.FlushMsProp(), kafkaConfig.logFlushIntervalMs());
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), kafkaConfig.logRetentionBytes());
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logRetentionTimeMillis()));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), kafkaConfig.messageMaxBytes());
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), kafkaConfig.logIndexIntervalBytes());
        logProps.put(LogConfig$.MODULE$.DeleteRetentionMsProp(), kafkaConfig.logCleanerDeleteRetentionMs());
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), kafkaConfig.logCleanerMinCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.MaxCompactionLagMsProp(), kafkaConfig.logCleanerMaxCompactionLagMs());
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), kafkaConfig.logDeleteDelayMs());
        logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), kafkaConfig.logCleanerMinCleanRatio());
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), kafkaConfig.logCleanupPolicy());
        logProps.put(LogConfig$.MODULE$.MinInSyncReplicasProp(), kafkaConfig.minInSyncReplicas());
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), kafkaConfig.compressionType());
        logProps.put(LogConfig$.MODULE$.UncleanLeaderElectionEnableProp(), kafkaConfig.uncleanLeaderElectionEnable());
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), kafkaConfig.logPreAllocateEnable());
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), kafkaConfig.logMessageFormatVersion().version());
        logProps.put(LogConfig$.MODULE$.MessageTimestampTypeProp(), kafkaConfig.logMessageTimestampType().name);
        logProps.put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), Predef$.MODULE$.long2Long(kafkaConfig.logMessageTimestampDifferenceMaxMs()));
        logProps.put(LogConfig$.MODULE$.MessageDownConversionEnableProp(), Predef$.MODULE$.boolean2Boolean(kafkaConfig.logMessageDownConversionEnable()));
        return var2_2;
    }

    public MetricConfig metricConfig(KafkaConfig kafkaConfig) {
        return new MetricConfig().samples(Predef$.MODULE$.Integer2int(kafkaConfig.metricNumSamples())).recordLevel(Sensor.RecordingLevel.forName((String)kafkaConfig.metricRecordingLevel())).timeWindow(Predef$.MODULE$.Long2long(kafkaConfig.metricSampleWindowMs()), TimeUnit.MILLISECONDS);
    }

    public long MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS() {
        return MIN_INCREMENTAL_FETCH_SESSION_EVICTION_MS;
    }

    private KafkaServer$() {
    }
}

