/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.;
import scala.$less$colon$less$;
import scala.DummyImplicit$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\r-f\u0001B A\u0001\u0015C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0011\u0019I\u0007\u0001)A\u0005;\"9!\u000e\u0001a\u0001\n\u0013Y\u0007\"\u0003B\u0017\u0001\u0001\u0007I\u0011\u0002B\u0018\u0011\u001d\u0011I\u0004\u0001Q!\n1D\u0011Ba\u0011\u0001\u0005\u0004%IA!\u0012\t\u0011\tM\u0003\u0001)A\u0005\u0005\u000fBqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003|\u0001!IA! \t\u000f\t\u001d\u0006\u0001\"\u0003\u0003*\"9!1\u0017\u0001\u0005\u0002\tU\u0006\"\u0003Bh\u0001E\u0005I\u0011\u0001Bi\u0011%\u0011)\u000eAI\u0001\n\u0003\u0011\t\u000eC\u0004\u0003X\u0002!\tA!7\t\u000f\tm\u0007\u0001\"\u0001\u0003^\"9!q\u001b\u0001\u0005\n\t\u001d\bb\u0002Bn\u0001\u0011%!1\u001e\u0005\b\u0005g\u0004A\u0011\u0001B{\u0011\u001d\u0011I\u0010\u0001C\u0001\u0005wDqa!\u0001\u0001\t\u0003\u0019\u0019\u0001C\u0004\u0004\b\u0001!Ia!\u0003\t\u000f\r]\u0001\u0001\"\u0001\u0004\u001a!91\u0011\u0005\u0001\u0005\u0002\r\r\u0002bBB\u0016\u0001\u0011\u00051Q\u0006\u0005\b\u0007o\u0001A\u0011AA1\u0011\u001d\u0019I\u0004\u0001C\u0001\u0007wAqa!\u0013\u0001\t\u0003\u0019Y\u0005C\u0004\u0004^\u0001!\taa\u0018\t\u000f\ru\u0003\u0001\"\u0001\u0004d!91q\r\u0001\u0005\n\r%d\u0001\u00028\u0001\u0001>D\u0011b`\u0011\u0003\u0016\u0004%\t!!\u0001\t\u0015\u0005u\u0013E!E!\u0002\u0013\t\u0019\u0001\u0003\u0006\u0002`\u0005\u0012)\u001a!C\u0001\u0003CB!\"!\u001b\"\u0005#\u0005\u000b\u0011BA2\u0011)\tY'\tBK\u0002\u0013\u0005\u0011Q\u000e\u0005\u000b\u0003{\n#\u0011#Q\u0001\n\u0005=\u0004BCA@C\tU\r\u0011\"\u0001\u0002\u0002\"Q\u0011\u0011U\u0011\u0003\u0012\u0003\u0006I!a!\t\rY\u000bC\u0011AAR\u0011%\ti+IA\u0001\n\u0003\ty\u000bC\u0005\u0002:\u0006\n\n\u0011\"\u0001\u0002<\"I\u0011\u0011[\u0011\u0012\u0002\u0013\u0005\u00111\u001b\u0005\n\u0003/\f\u0013\u0013!C\u0001\u00033D\u0011\"!8\"#\u0003%\t!a8\t\u0013\u0005\r\u0018%!A\u0005B\u0005\u0015\b\"CAyC\u0005\u0005I\u0011AAz\u0011%\t)0IA\u0001\n\u0003\t9\u0010C\u0005\u0003\u0004\u0005\n\t\u0011\"\u0011\u0003\u0006!I!QB\u0011\u0002\u0002\u0013\u0005!q\u0002\u0005\n\u00053\t\u0013\u0011!C!\u00057A\u0011Ba\b\"\u0003\u0003%\tE!\t\t\u0013\t\r\u0012%!A\u0005B\t\u0015\u0002\"\u0003B\u0014C\u0005\u0005I\u0011\tB\u0015\u000f%\u0019\t\bAA\u0001\u0012\u0003\u0019\u0019H\u0002\u0005o\u0001\u0005\u0005\t\u0012AB;\u0011\u00191&\b\"\u0001\u0004\u000e\"I!1\u0005\u001e\u0002\u0002\u0013\u0015#Q\u0005\u0005\n\u0007\u001fS\u0014\u0011!CA\u0007#C\u0011ba';\u0003\u0003%\ti!(\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f\u0015\t\t%)\u0001\u0004tKJ4XM\u001d\u0006\u0002\u0007\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001G\u0019B\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n1\u0011I\\=SK\u001a\u0004\"!\u0014)\u000e\u00039S!a\u0014\"\u0002\u000bU$\u0018\u000e\\:\n\u0005Es%a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011q\tV\u0005\u0003+\"\u00131!\u00138u\u0003\u0019a\u0014N\\5u}Q\u0011\u0001L\u0017\t\u00033\u0002i\u0011\u0001\u0011\u0005\u0006%\n\u0001\raU\u0001\u0016a\u0006\u0014H/\u001b;j_:lU\r^1eCR\fGj\\2l+\u0005i\u0006C\u00010h\u001b\u0005y&B\u00011b\u0003\u0015awnY6t\u0015\t\u00117-\u0001\u0006d_:\u001cWO\u001d:f]RT!\u0001Z3\u0002\tU$\u0018\u000e\u001c\u0006\u0002M\u0006!!.\u0019<b\u0013\tAwL\u0001\fSK\u0016tGO]1oiJ+\u0017\rZ,sSR,Gj\\2l\u0003Y\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.\u0004\u0013\u0001E7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u+\u0005a\u0007CA7\"\u001b\u0005\u0001!\u0001E'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u'\u0011\tc\t]:\u0011\u0005\u001d\u000b\u0018B\u0001:I\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u001e?\u000f\u0005UThB\u0001<z\u001b\u00059(B\u0001=E\u0003\u0019a$o\\8u}%\t\u0011*\u0003\u0002|\u0011\u00069\u0001/Y2lC\u001e,\u0017BA?\u007f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tY\b*A\bqCJ$\u0018\u000e^5p]N#\u0018\r^3t+\t\t\u0019\u0001\u0005\u0005\u0002\u0006\u0005=\u00111CA\u0012\u001b\t\t9A\u0003\u0003\u0002\n\u0005-\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001bA\u0015AC2pY2,7\r^5p]&!\u0011\u0011CA\u0004\u0005%\te.\u001f*fM6\u000b\u0007\u000f\u0005\u0003\u0002\u0016\u0005ua\u0002BA\f\u00033\u0001\"A\u001e%\n\u0007\u0005m\u0001*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037A\u0005CBA\u0003\u0003K\tI#\u0003\u0003\u0002(\u0005\u001d!a\u0002'p]\u001el\u0015\r\u001d\t\u0005\u0003W\t9F\u0004\u0003\u0002.\u0005Ec\u0002BA\u0018\u0003\u0017rA!!\r\u0002F9!\u00111GA!\u001d\u0011\t)$a\u000f\u000f\u0007Y\f9$\u0003\u0002\u0002:\u0005\u0019qN]4\n\t\u0005u\u0012qH\u0001\u0007CB\f7\r[3\u000b\u0005\u0005e\u0012bA\"\u0002D)!\u0011QHA \u0013\u0011\t9%!\u0013\u0002\r\r|W.\\8o\u0015\r\u0019\u00151I\u0005\u0005\u0003\u001b\ny%A\u0004nKN\u001c\u0018mZ3\u000b\t\u0005\u001d\u0013\u0011J\u0005\u0005\u0003'\n)&A\rVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;ECR\f'\u0002BA'\u0003\u001fJA!!\u0017\u0002\\\taR\u000b\u001d3bi\u0016lU\r^1eCR\f\u0007+\u0019:uSRLwN\\*uCR,'\u0002BA*\u0003+\n\u0001\u0003]1si&$\u0018n\u001c8Ti\u0006$Xm\u001d\u0011\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0005\u0005\r\u0004\u0003B$\u0002fMK1!a\u001aI\u0005\u0019y\u0005\u000f^5p]\u0006i1m\u001c8ue>dG.\u001a:JI\u0002\nA\"\u00197jm\u0016\u0014%o\\6feN,\"!a\u001c\u0011\r\u0005\u0015\u0011QEA9!\u0011\t\u0019(!\u001f\u000e\u0005\u0005U$bAA<\u0005\u000691\r\\;ti\u0016\u0014\u0018\u0002BA>\u0003k\u0012aA\u0011:pW\u0016\u0014\u0018!D1mSZ,'I]8lKJ\u001c\b%\u0001\u0006bY&4XMT8eKN,\"!a!\u0011\r\u0005\u0015\u0011QEAC!!\t9)!#\u0002\u000e\u0006eUBAA\u0006\u0013\u0011\tY)a\u0003\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0010\u0006UUBAAI\u0015\u0011\t\u0019*a\u0014\u0002\u000f9,Go^8sW&!\u0011qSAI\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f!\u0011\tY*!(\u000e\u0005\u0005=\u0013\u0002BAP\u0003\u001f\u0012AAT8eK\u0006Y\u0011\r\\5wK:{G-Z:!)%a\u0017QUAT\u0003S\u000bY\u000b\u0003\u0004\u0000U\u0001\u0007\u00111\u0001\u0005\b\u0003?R\u0003\u0019AA2\u0011\u001d\tYG\u000ba\u0001\u0003_Bq!a +\u0001\u0004\t\u0019)\u0001\u0003d_BLH#\u00037\u00022\u0006M\u0016QWA\\\u0011!y8\u0006%AA\u0002\u0005\r\u0001\"CA0WA\u0005\t\u0019AA2\u0011%\tYg\u000bI\u0001\u0002\u0004\ty\u0007C\u0005\u0002\u0000-\u0002\n\u00111\u0001\u0002\u0004\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA_U\u0011\t\u0019!a0,\u0005\u0005\u0005\u0007\u0003BAb\u0003\u001bl!!!2\u000b\t\u0005\u001d\u0017\u0011Z\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a3I\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\f)MA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002V*\"\u00111MA`\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!a7+\t\u0005=\u0014qX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\t\tO\u000b\u0003\u0002\u0004\u0006}\u0016!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002hB!\u0011\u0011^Ax\u001b\t\tYOC\u0002\u0002n\u0016\fA\u0001\\1oO&!\u0011qDAv\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0019\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003s\fy\u0010E\u0002H\u0003wL1!!@I\u0005\r\te.\u001f\u0005\t\u0005\u0003\u0011\u0014\u0011!a\u0001'\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"Aa\u0002\u0011\r\u0005\u001d%\u0011BA}\u0013\u0011\u0011Y!a\u0003\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005#\u00119\u0002E\u0002H\u0005'I1A!\u0006I\u0005\u001d\u0011un\u001c7fC:D\u0011B!\u00015\u0003\u0003\u0005\r!!?\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003O\u0014i\u0002\u0003\u0005\u0003\u0002U\n\t\u00111\u0001T\u0003!A\u0017m\u001d5D_\u0012,G#A*\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a:\u0002\r\u0015\fX/\u00197t)\u0011\u0011\tBa\u000b\t\u0013\t\u0005\u0001(!AA\u0002\u0005e\u0018\u0001F7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u?\u0012*\u0017\u000f\u0006\u0003\u00032\t]\u0002cA$\u00034%\u0019!Q\u0007%\u0003\tUs\u0017\u000e\u001e\u0005\t\u0005\u00031\u0011\u0011!a\u0001Y\u0006\tR.\u001a;bI\u0006$\u0018m\u00158baNDw\u000e\u001e\u0011)\u0007\u001d\u0011i\u0004E\u0002H\u0005\u007fI1A!\u0011I\u0005!1x\u000e\\1uS2,\u0017!E:uCR,7\t[1oO\u0016dunZ4feV\u0011!q\t\t\u0005\u0005\u0013\u0012y%\u0004\u0002\u0003L)\u0019!Q\n\"\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0003\u0003\u0003R\t-#!E*uCR,7\t[1oO\u0016dunZ4fe\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u000319W\r^#oIB|\u0017N\u001c;t))\u0011IFa\u0018\u0003d\tM$q\u000f\t\u0007\u0003\u000f\u0013Y&!'\n\t\tu\u00131\u0002\u0002\u0004'\u0016\f\bB\u0002B1\u0015\u0001\u0007A.\u0001\u0005t]\u0006\u00048\u000f[8u\u0011\u001d\u0011)G\u0003a\u0001\u0005O\nqA\u0019:pW\u0016\u00148\u000fE\u0003u\u0005S\u0012i'C\u0002\u0003ly\u0014\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\u0005\u0003S\u0014y'\u0003\u0003\u0003r\u0005-(aB%oi\u0016<WM\u001d\u0005\b\u0005kR\u0001\u0019AAG\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f\u0011\u001d\u0011IH\u0003a\u0001\u0005#\t!DZ5mi\u0016\u0014XK\\1wC&d\u0017M\u00197f\u000b:$\u0007o\\5oiN\fAcZ3u!\u0006\u0014H/\u001b;j_:lU\r^1eCR\fG\u0003\u0004B@\u0005/\u0013IJ!(\u0003 \n\r\u0006#B$\u0002f\t\u0005\u0005#\u0002;\u0003j\t\r\u0005\u0003\u0002BC\u0005#sAAa\"\u0003\u000e6\u0011!\u0011\u0012\u0006\u0005\u0005\u0017\u000by%\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011yI!#\u0002!5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,\u0017\u0002\u0002BJ\u0005+\u0013\u0011\u0003U1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0015\u0011\u0011yI!#\t\r\t\u00054\u00021\u0001m\u0011\u001d\u0011Yj\u0003a\u0001\u0003'\tQ\u0001^8qS\u000eDqA!\u001e\f\u0001\u0004\ti\tC\u0004\u0003\".\u0001\rA!\u0005\u00023\u0015\u0014(o\u001c:V]\u00064\u0018-\u001b7bE2,WI\u001c3q_&tGo\u001d\u0005\b\u0005K[\u0001\u0019\u0001B\t\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0002!\u001d,G/\u00117jm\u0016,e\u000e\u001a9pS:$H\u0003\u0003BV\u0005[\u0013yK!-\u0011\u000b\u001d\u000b)'!'\t\r\t\u0005D\u00021\u0001m\u0011\u0015\u0011F\u00021\u0001T\u0011\u001d\u0011)\b\u0004a\u0001\u0003\u001b\u000b\u0001cZ3u)>\u0004\u0018nY'fi\u0006$\u0017\r^1\u0015\u0015\t]&q\u0018Be\u0005\u0017\u0014i\r\u0005\u0004\u0002\b\nm#\u0011\u0018\t\u0005\u0005\u000b\u0013Y,\u0003\u0003\u0003>\nU%!\u0004+pa&\u001cW*\u001a;bI\u0006$\u0018\rC\u0004\u0003B6\u0001\rAa1\u0002\rQ|\u0007/[2t!\u0019\t9I!2\u0002\u0014%!!qYA\u0006\u0005\r\u0019V\r\u001e\u0005\b\u0005kj\u0001\u0019AAG\u0011%\u0011\t+\u0004I\u0001\u0002\u0004\u0011\t\u0002C\u0005\u0003&6\u0001\n\u00111\u0001\u0003\u0012\u0005Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%gU\u0011!1\u001b\u0016\u0005\u0005#\ty,\u0001\u000ehKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$C'\u0001\u0007hKR\fE\u000e\u001c+pa&\u001c7\u000f\u0006\u0002\u0003D\u0006\u0001r-\u001a;BY2\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0003\u0005?\u0004b!a\"\u0003F\n\u0005\b\u0003BAN\u0005GLAA!:\u0002P\tqAk\u001c9jGB\u000b'\u000f^5uS>tG\u0003\u0002Bb\u0005SDaA!\u0019\u0013\u0001\u0004aG\u0003\u0002Bw\u0005c\u0004\u0002\"!\u0006\u0003p\n\u0005\u0018\u0011F\u0005\u0005\u0003\u0017\u000b\t\u0003\u0003\u0004\u0003bM\u0001\r\u0001\\\u0001\u0015O\u0016$hj\u001c8Fq&\u001cH/\u001b8h)>\u0004\u0018nY:\u0015\t\t\r'q\u001f\u0005\b\u0005\u0003$\u0002\u0019\u0001Bb\u000399W\r^!mSZ,'I]8lKJ$BA!@\u0003\u0000B)q)!\u001a\u0002r!)!+\u0006a\u0001'\u0006yq-\u001a;BY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0004\u0006A1\u0011q\u0011B.\u0003c\n\u0001$\u00193e\u001fJ,\u0006\u000fZ1uKB\u000b'\u000f^5uS>t\u0017J\u001c4p))\u0011\tda\u0003\u0004\u000e\r=11\u0003\u0005\u0007\u007f^\u0001\r!a\u0001\t\u000f\tmu\u00031\u0001\u0002\u0014!11\u0011C\fA\u0002M\u000b1\u0002]1si&$\u0018n\u001c8JI\"91QC\fA\u0002\u0005%\u0012!C:uCR,\u0017J\u001c4p\u0003A9W\r\u001e)beRLG/[8o\u0013:4w\u000e\u0006\u0004\u0004\u001c\ru1q\u0004\t\u0006\u000f\u0006\u0015\u0014\u0011\u0006\u0005\b\u00057C\u0002\u0019AA\n\u0011\u0019\u0019\t\u0002\u0007a\u0001'\u0006Qr-\u001a;QCJ$\u0018\u000e^5p]2+\u0017\rZ3s\u000b:$\u0007o\\5oiRA!1VB\u0013\u0007O\u0019I\u0003C\u0004\u0003\u001cf\u0001\r!a\u0005\t\r\rE\u0011\u00041\u0001T\u0011\u001d\u0011)(\u0007a\u0001\u0003\u001b\u000bAdZ3u!\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006,e\u000e\u001a9pS:$8\u000f\u0006\u0004\u00040\rE2Q\u0007\t\b\u0003+\u0011yoUAM\u0011\u001d\u0019\u0019D\u0007a\u0001\u0005C\f!\u0001\u001e9\t\u000f\tU$\u00041\u0001\u0002\u000e\u0006yq-\u001a;D_:$(o\u001c7mKJLE-\u0001\nhKR\u001cE.^:uKJlU\r^1eCR\fGCBB\u001f\u0007\u0007\u001a9\u0005\u0005\u0003\u0002\u001c\u000e}\u0012\u0002BB!\u0003\u001f\u0012qa\u00117vgR,'\u000fC\u0004\u0004Fq\u0001\r!a\u0005\u0002\u0013\rdWo\u001d;fe&#\u0007b\u0002B;9\u0001\u0007\u0011QR\u0001\u000fkB$\u0017\r^3NKR\fG-\u0019;b)\u0019\u0019iea\u0014\u0004TA1\u0011q\u0011B.\u0005CDaa!\u0015\u001e\u0001\u0004\u0019\u0016!D2peJ,G.\u0019;j_:LE\rC\u0004\u0004Vu\u0001\raa\u0016\u0002+U\u0004H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiB!!qQB-\u0013\u0011\u0019YF!#\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3ti\u0006A1m\u001c8uC&t7\u000f\u0006\u0003\u0003\u0012\r\u0005\u0004b\u0002BN=\u0001\u0007\u00111\u0003\u000b\u0005\u0005#\u0019)\u0007C\u0004\u00044}\u0001\rA!9\u0002'I,Wn\u001c<f!\u0006\u0014H/\u001b;j_:LeNZ8\u0015\u0011\tE11NB7\u0007_Baa \u0011A\u0002\u0005\r\u0001b\u0002BNA\u0001\u0007\u00111\u0003\u0005\u0007\u0007#\u0001\u0003\u0019A*\u0002!5+G/\u00193bi\u0006\u001cf.\u00199tQ>$\bCA7;'\u0015Q4qOBB!5\u0019Iha \u0002\u0004\u0005\r\u0014qNABY6\u001111\u0010\u0006\u0004\u0007{B\u0015a\u0002:v]RLW.Z\u0005\u0005\u0007\u0003\u001bYHA\tBEN$(/Y2u\rVt7\r^5p]R\u0002Ba!\"\u0004\f6\u00111q\u0011\u0006\u0004\u0007\u0013+\u0017AA5p\u0013\ri8q\u0011\u000b\u0003\u0007g\nQ!\u00199qYf$\u0012\u0002\\BJ\u0007+\u001b9j!'\t\r}l\u0004\u0019AA\u0002\u0011\u001d\ty&\u0010a\u0001\u0003GBq!a\u001b>\u0001\u0004\ty\u0007C\u0004\u0002\u0000u\u0002\r!a!\u0002\u000fUt\u0017\r\u001d9msR!1qTBT!\u00159\u0015QMBQ!-951UA\u0002\u0003G\ny'a!\n\u0007\r\u0015\u0006J\u0001\u0004UkBdW\r\u000e\u0005\t\u0007Ss\u0014\u0011!a\u0001Y\u0006\u0019\u0001\u0010\n\u0019")
public class MetadataCache
implements Logging {
    private volatile MetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public MetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private Seq<Node> getEndpoints(MetadataSnapshot snapshot, Iterable<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        ArrayBuffer result = new ArrayBuffer(package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        brokers.foreach((Function1 & Serializable)brokerId -> {
            MetadataCache.$anonfun$getEndpoints$1(this, snapshot, listenerName, filterUnavailableEndpoints, result, brokerId);
            return BoxedUnit.UNIT;
        });
        return result;
    }

    private Option<Iterable<MetadataResponse.PartitionMetadata>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable)partitions -> (scala.collection.mutable.Iterable)partitions.map((Function1 & Serializable)x0$1 -> {
            MetadataResponse.PartitionMetadata partitionMetadata;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            long partitionId = tuple2._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            Buffer replicas = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.replicas()).asScala();
            Seq<Node> replicaInfo = this.getEndpoints(snapshot, (Iterable<Integer>)replicas, listenerName, errorUnavailableEndpoints);
            Seq<Node> offlineReplicaInfo = this.getEndpoints(snapshot, (Iterable<Integer>)((Iterable)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.offlineReplicas()).asScala()), listenerName, errorUnavailableEndpoints);
            Buffer isr = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(partitionState.isr()).asScala();
            Seq<Node> isrInfo = this.getEndpoints(snapshot, (Iterable<Integer>)isr, listenerName, errorUnavailableEndpoints);
            Option<Node> option = maybeLeader;
            if (None$.MODULE$.equals(option)) {
                Errors errors;
                if (!snapshot.aliveBrokers().contains((long)$this.brokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" not found on leader ").append(leaderBrokerId).toString());
                    errors = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors;
                partitionMetadata = new MetadataResponse.PartitionMetadata(error, (int)partitionId, Node.noNode(), Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                return partitionMetadata;
            } else {
                MetadataResponse.PartitionMetadata partitionMetadata2;
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                Node leader = (Node)some.value();
                if (replicaInfo.size() < replicas.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> {
                        Seq seq = (Seq)replicaInfo.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id()));
                        return new StringBuilder(0).append(new StringBuilder(74).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)replicas.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else if (isrInfo.size() < isr.size()) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> {
                        Seq seq = (Seq)isrInfo.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.id()));
                        return new StringBuilder(0).append(new StringBuilder(82).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").toString()).append(new StringBuilder(18).append("following brokers ").append(((IterableOnceOps)isr.filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)seq.contains(elem)))).mkString(",")).toString()).toString();
                    });
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.REPLICA_NOT_AVAILABLE, (int)partitionId, leader, Optional.empty(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                } else {
                    partitionMetadata2 = new MetadataResponse.PartitionMetadata(Errors.NONE, (int)partitionId, leader, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(replicaInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(isrInfo).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(offlineReplicaInfo).asJava());
                }
                partitionMetadata = partitionMetadata2;
            }
            return partitionMetadata;
        }));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    public Seq<MetadataResponse.TopicMetadata> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable)topic -> this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable)partitionMetadata -> new MetadataResponse.TopicMetadata(Errors.NONE, topic, Topic.isInternal((String)topic), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava())));
    }

    public boolean getTopicMetadata$default$3() {
        return false;
    }

    public boolean getTopicMetadata$default$4() {
        return false;
    }

    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    public Set<TopicPartition> getAllPartitions() {
        return ((IterableOnceOps)this.metadataSnapshot().partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topicName = (String)tuple2._1();
            LongMap partitionsAndStates = (LongMap)tuple2._2();
            Iterable iterable = (Iterable)partitionsAndStates.keys().map((Function1 & Serializable)partitionId -> MetadataCache.$anonfun$getAllPartitions$2(topicName, BoxesRunTime.unboxToLong((Object)partitionId)));
            return iterable;
        })).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String topic = (String)tuple2._1();
            LongMap partitionStates = (LongMap)tuple2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)partitionStates.map((Function1 & Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long partition = tuple2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple22;
            });
            return map;
        }, DummyImplicit$.MODULE$.dummyImplicit()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return (Set)topics.$minus$minus((IterableOnce)this.metadataSnapshot().partitionStates().keySet());
    }

    public Option<Broker> getAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId);
    }

    public Seq<Broker> getAliveBrokers() {
        return this.metadataSnapshot().aliveBrokers().values().toBuffer();
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        LongMap infos = (LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable)() -> LongMap$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$));
        infos.update((long)partitionId, (Object)stateInfo);
    }

    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$4 -> x$4.get((long)partitionId));
    }

    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable)x$5 -> x$5.get((long)partitionId)).map((Function1 & Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                Some some = (Some)option;
                Map nodeMap = (Map)some.value();
                node = (Node)nodeMap.getOrElse((Object)listenerName, (Function0 & Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable)x$6 -> x$6.get((long)tp.partition())).map((Function1 & Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    Broker broker = (Broker)some.value();
                    node = (Node)broker.getNode(listenerName).getOrElse((Function0 & Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).filter((Function1 & Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = snapshot.aliveNodes().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            Map nodes = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)id), nodes.get((Object)listenerName).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return tuple22;
        });
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((IterableOps)this.getAllPartitions(snapshot).filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$2(x0$2)))).map((Function1 & Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), MetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable)id -> MetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable)id -> MetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable)id -> MetadataCache.node$1(id, nodes))).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        });
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$7(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(((IterableOnceOps)nodes.values().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$getClusterMetadata$8(x$7)))).toBuffer()).asJava(), (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable)id -> MetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        return (Seq)CoreUtils$.MODULE$.inWriteLock(this.partitionMetadataLock(), (Function0 & Serializable)() -> {
            LongMap aliveBrokers = new LongMap(this.metadataSnapshot().aliveBrokers().size());
            LongMap aliveNodes = new LongMap(this.metadataSnapshot().aliveNodes().size());
            int n = updateMetadataRequest.controllerId();
            switch (n) {
                default: 
            }
            None$ controllerId = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest.liveBrokers()).asScala()).foreach((Function1 & Serializable)broker -> {
                MetadataCache.$anonfun$updateMetadata$2(aliveBrokers, aliveNodes, broker);
                return BoxedUnit.UNIT;
            });
            aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable)listenerMap -> {
                MetadataCache.$anonfun$updateMetadata$4(this, aliveNodes, listenerMap);
                return BoxedUnit.UNIT;
            });
            ArrayBuffer deletedPartitions = new ArrayBuffer();
            if (!updateMetadataRequest.partitionStates().iterator().hasNext()) {
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, this.metadataSnapshot().partitionStates(), (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            } else {
                AnyRefMap partitionStates = new AnyRefMap(this.metadataSnapshot().partitionStates().size());
                this.metadataSnapshot().partitionStates().foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String topic = (String)tuple2._1();
                    LongMap oldPartitionStates = (LongMap)tuple2._2();
                    LongMap copy = new LongMap(oldPartitionStates.size());
                    copy.$plus$plus$eq((IterableOnce)oldPartitionStates);
                    AnyRefMap anyRefMap = (AnyRefMap)partitionStates.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topic), (Object)copy));
                    return anyRefMap;
                });
                ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest.partitionStates()).asScala()).foreach((Function1 & Serializable)info -> {
                    BoxedUnit boxedUnit;
                    int controllerId = updateMetadataRequest.controllerId();
                    int controllerEpoch = updateMetadataRequest.controllerEpoch();
                    TopicPartition tp = new TopicPartition(info.topicName(), info.partitionIndex());
                    if (info.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                        this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition());
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(69).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").toString()).append(new StringBuilder(55).append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = deletedPartitions.$plus$eq((Object)tp);
                    } else {
                        this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)info);
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Cached leader info ").append(info).append(" for partition ").append(tp).append(" in response to ").toString()).append(new StringBuilder(70).append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId).toString()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                });
                this.metadataSnapshot_$eq(new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (Option<Object>)controllerId, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
            }
            return deletedPartitions;
        });
    }

    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        MetadataCache metadataCache = this;
        synchronized (metadataCache) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new MetadataCache$MetadataSnapshot$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$getEndpoints$1(MetadataCache $this, MetadataSnapshot snapshot$1, ListenerName listenerName$1, boolean filterUnavailableEndpoints$1, ArrayBuffer result$1, Integer brokerId) {
        None$ none$;
        Option<Node> option = $this.getAliveEndpoint(snapshot$1, Predef$.MODULE$.Integer2int(brokerId), listenerName$1);
        if (None$.MODULE$.equals(option)) {
            none$ = !filterUnavailableEndpoints$1 ? new Some((Object)new Node(Predef$.MODULE$.Integer2int(brokerId), "", -1)) : None$.MODULE$;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            Node node = (Node)some.value();
            none$ = new Some((Object)node);
        } else {
            throw new MatchError(option);
        }
        None$ endpoint = none$;
        endpoint.foreach((Function1 & Serializable)elem -> (ArrayBuffer)result$1.$plus$eq(elem));
    }

    public static final /* synthetic */ TopicPartition $anonfun$getAllPartitions$2(String topicName$1, long partitionId) {
        return new TopicPartition(topicName$1, (int)partitionId);
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        Tuple2 tuple2 = pair;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Node node = (Node)tuple2._2();
        boolean bl = !node.isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.get((long)Predef$.MODULE$.Integer2int(id)).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)tuple2._2();
        boolean bl = state.leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$7(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$8(Node x$7) {
        return x$7 != null;
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$2(LongMap aliveBrokers$1, LongMap aliveNodes$1, UpdateMetadataRequestData.UpdateMetadataBroker broker) {
        HashMap nodes = new HashMap();
        ArrayBuffer endPoints = new ArrayBuffer();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(broker.endpoints()).asScala()).foreach((Function1 & Serializable)ep -> {
            ListenerName listenerName = new ListenerName(ep.listener());
            endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
            return nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
        });
        aliveBrokers$1.update((long)broker.id(), (Object)new Broker(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
        aliveNodes$1.update((long)broker.id(), JavaConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$8) {
        Set set = x$8.keySet();
        Set set2 = listeners$1;
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(MetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        block0: {
            Set listeners = listenerMap.keySet();
            if (aliveNodes$1.values().forall((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)MetadataCache.$anonfun$updateMetadata$5(listeners, x$8)))) break block0;
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        Object object = infos.isEmpty() ? partitionStates$2.remove((Object)topic$4) : BoxedUnit.UNIT;
        return true;
    }

    public MetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ MetadataCache $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$MetadataCache$MetadataSnapshot$$$outer(), partitionStates, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public Option<Object> copy$default$2() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$3() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$4() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.partitionStates();
                    break;
                }
                case 1: {
                    object = this.controllerId();
                    break;
                }
                case 2: {
                    object = this.aliveBrokers();
                    break;
                }
                case 3: {
                    object = this.aliveNodes();
                    break;
                }
                default: {
                    object = Statics.ioobe((int)x$1);
                    break;
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public String productElementName(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                case 0: {
                    string = "partitionStates";
                    break;
                }
                case 1: {
                    string = "controllerId";
                    break;
                }
                case 2: {
                    string = "aliveBrokers";
                    break;
                }
                case 3: {
                    string = "aliveNodes";
                    break;
                }
                default: {
                    string = (String)Statics.ioobe((int)x$1);
                    break;
                }
            }
            return string;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)object).kafka$server$MetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$MetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MetadataCache kafka$server$MetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(MetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

