/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import kafka.api.Request$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.QuotaFactory$UnboundedQuota$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicationQuotaManager;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Growable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t]c\u0001B\u0011#\u0001\u001dB\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\nu\u0001\u0011\t\u0011)A\u0005w\u0005C\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\"\u0002,\u0001\t\u00039\u0006b\u00021\u0001\u0005\u0004%I!\u0019\u0005\u0007M\u0002\u0001\u000b\u0011\u00022\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1\u0011\u000f\u0001Q\u0001\n%DqA\u001d\u0001C\u0002\u0013%\u0001\u000e\u0003\u0004t\u0001\u0001\u0006I!\u001b\u0005\bi\u0002\u0001\r\u0011\"\u0003v\u0011%\tI\u0001\u0001a\u0001\n\u0013\tY\u0001C\u0004\u0002\u0018\u0001\u0001\u000b\u0015\u0002<\t\u000f\u0005e\u0001\u0001\"\u0015\u0002\u001c!9\u00111\u0005\u0001\u0005R\u0005\u0015\u0002bBA\u0018\u0001\u0011E\u0013\u0011\u0007\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0011\u001d\t9\b\u0001C!\u0003sBq!!1\u0001\t#\n\u0019\rC\u0004\u0002L\u0002!\t&!4\t\u000f\u0005M\u0007\u0001\"\u0011\u0002V\"9\u0011q\u001e\u0001\u0005R\u0005E\bbBA}\u0001\u0011\u0005\u00131 \u0005\b\u0005\u0013\u0001A\u0011\u000bB\u0006\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\n\u0001\t\u0013\u0011I\u0003C\u0004\u0003.\u0001!IAa\f\t\u000f\tE\u0003\u0001\"\u0001\u0003T\tI\"+\u001a9mS\u000e\f\u0017\t\u001c;fe2{w\rR5sgRC'/Z1e\u0015\t\u0019C%\u0001\u0004tKJ4XM\u001d\u0006\u0002K\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001)!\tI#&D\u0001#\u0013\tY#EA\u000bBEN$(/Y2u\r\u0016$8\r[3s)\"\u0014X-\u00193\u0002\t9\fW.\u001a\t\u0003]]r!aL\u001b\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I2\u0013A\u0002\u001fs_>$hHC\u00015\u0003\u0015\u00198-\u00197b\u0013\t14'\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c4\u00031\u0019x.\u001e:dK\n\u0013xn[3s!\tat(D\u0001>\u0015\tqD%A\u0004dYV\u001cH/\u001a:\n\u0005\u0001k$A\u0004\"s_.,'/\u00128e!>Lg\u000e^\u0005\u0003u)\nAB\u0019:pW\u0016\u00148i\u001c8gS\u001e\u0004\"!\u000b#\n\u0005\u0015\u0013#aC&bM.\f7i\u001c8gS\u001e\f\u0001CZ1jY\u0016$\u0007+\u0019:uSRLwN\\:\u0011\u0005%B\u0015BA%#\u0005A1\u0015-\u001b7fIB\u000b'\u000f^5uS>t7/\u0001\u0006sKBd\u0017nY1NOJ\u0004\"!\u000b'\n\u00055\u0013#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0006cV|G/\u0019\t\u0003SAK!!\u0015\u0012\u0003/I+\u0007\u000f\\5dCRLwN\\)v_R\fW*\u00198bO\u0016\u0014\u0018\u0001\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;t!\tIC+\u0003\u0002VE\t\u0001\"I]8lKJ$v\u000e]5d'R\fGo]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011aK&l\u0017/^=~\u0003\"!\u000b\u0001\t\u000b1B\u0001\u0019A\u0017\t\u000biB\u0001\u0019A\u001e\t\u000b\tC\u0001\u0019A\"\t\u000b\u0019C\u0001\u0019A$\t\u000b)C\u0001\u0019A&\t\u000b9C\u0001\u0019A(\t\u000bIC\u0001\u0019A*\u0002\u0013I,\u0007\u000f\\5dC&#W#\u00012\u0011\u0005\r$W\"A\u001a\n\u0005\u0015\u001c$aA%oi\u0006Q!/\u001a9mS\u000e\f\u0017\n\u001a\u0011\u0002\u00115\f\u0007PQ=uKN,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\fA\u0001\\1oO*\ta.\u0001\u0003kCZ\f\u0017B\u00019l\u0005\u001dIe\u000e^3hKJ\f\u0011\"\\1y\u0005f$Xm\u001d\u0011\u0002\u0013\u0019,Go\u00195TSj,\u0017A\u00034fi\u000eD7+\u001b>fA\u0005\u0019\u0012N\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]V\ta\u000fE\u0002dofL!\u0001_\u001a\u0003\r=\u0003H/[8o!\rQ\u0018QA\u0007\u0002w*\u0011A0`\u0001\u0007G>lWn\u001c8\u000b\u0005\u0015r(bA@\u0002\u0002\u00051\u0011\r]1dQ\u0016T!!a\u0001\u0002\u0007=\u0014x-C\u0002\u0002\bm\u0014a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.A\fj]B\u0013xn\u001a:fgN\u0004\u0016M\u001d;ji&|gn\u0018\u0013fcR!\u0011QBA\n!\r\u0019\u0017qB\u0005\u0004\u0003#\u0019$\u0001B+oSRD\u0001\"!\u0006\u0011\u0003\u0003\u0005\rA^\u0001\u0004q\u0012\n\u0014\u0001F5o!J|wM]3tgB\u000b'\u000f^5uS>t\u0007%A\u0006mCR,7\u000f^#q_\u000eDG\u0003BA\u000f\u0003?\u00012aY<c\u0011\u0019\t\tC\u0005a\u0001s\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0001\u00047pO\u0016sGm\u00144gg\u0016$H\u0003BA\u0014\u0003[\u00012aYA\u0015\u0013\r\tYc\r\u0002\u0005\u0019>tw\r\u0003\u0004\u0002\"M\u0001\r!_\u0001\u0012K:$wJ\u001a4tKR4uN]#q_\u000eDGCBA\u001a\u0003w\ti\u0004\u0005\u0003do\u0006U\u0002cA\u0015\u00028%\u0019\u0011\u0011\b\u0012\u0003\u001d=3gm]3u\u0003:$W\t]8dQ\"1\u0011\u0011\u0005\u000bA\u0002eDa!a\u0010\u0015\u0001\u0004\u0011\u0017!B3q_\u000eD\u0017a\u00044fi\u000eDgI]8n\u0019\u0016\fG-\u001a:\u0015\t\u0005\u0015\u0013q\f\t\u0007\u0003\u000f\ni%!\u0015\u000e\u0005\u0005%#bAA&g\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0013\u0011\n\u0002\u0004'\u0016\f\bCB2\u0002Te\f9&C\u0002\u0002VM\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BA-\u00037j\u0011\u0001A\u0005\u0004\u0003;R#!\u0003$fi\u000eDG)\u0019;b\u0011\u001d\t\t'\u0006a\u0001\u0003G\nABZ3uG\"\u0014V-];fgR\u0004B!!\u001a\u0002r9!\u0011qMA7\u001b\t\tIGC\u0002\u0002lm\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003_\nI'\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0002t\u0005U$a\u0002\"vS2$WM\u001d\u0006\u0005\u0003_\nI'\u0001\u000bqe>\u001cWm]:QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u000b\t\u0003w\nI)a#\u0002\u0010B!1m^A?!\u0011\ty(!\"\u000e\u0005\u0005\u0005%bAABI\u0005\u0019An\\4\n\t\u0005\u001d\u0015\u0011\u0011\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\r\u0005\u0005b\u00031\u0001z\u0011\u001d\tiI\u0006a\u0001\u0003O\t1BZ3uG\"|eMZ:fi\"9\u0011\u0011\u0013\fA\u0002\u0005M\u0015!\u00049beRLG/[8o\t\u0006$\u0018\r\u0005\u0004\u0002\u0016\u0006=\u0016Q\u0017\b\u0005\u0003/\u000bYK\u0004\u0003\u0002\u001a\u0006%f\u0002BAN\u0003OsA!!(\u0002&:!\u0011qTAR\u001d\r\u0001\u0014\u0011U\u0005\u0003\u0003\u0007I1a`A\u0001\u0013\t)c0\u0003\u0002}{&\u0019\u00111N>\n\t\u00055\u0016\u0011N\u0001\u000e\r\u0016$8\r\u001b*fgB|gn]3\n\t\u0005E\u00161\u0017\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u00055\u0016\u0011\u000e\t\u0005\u0003o\u000bi,\u0004\u0002\u0002:*\u0019\u00111X>\u0002\rI,7m\u001c:e\u0013\u0011\ty,!/\u0003\u000fI+7m\u001c:eg\u0006ib-\u001a;dQ\u0016\u000b'\u000f\\5fgR|eMZ:fi\u001a\u0013x.\u001c'fC\u0012,'\u000f\u0006\u0004\u0002(\u0005\u0015\u0017q\u0019\u0005\u0007\u0003C9\u0002\u0019A=\t\r\u0005%w\u00031\u0001c\u0003-aW-\u00193fe\u0016\u0003xn\u00195\u00027\u0019,Go\u00195MCR,7\u000f^(gMN,GO\u0012:p[2+\u0017\rZ3s)\u0019\t9#a4\u0002R\"1\u0011\u0011\u0005\rA\u0002eDa!!3\u0019\u0001\u0004\u0011\u0017\u0001\u00064fi\u000eDW\t]8dQ\u0016sGm\u00144gg\u0016$8\u000f\u0006\u0003\u0002X\u0006\r\bcBA$\u00033L\u0018Q\\\u0005\u0005\u00037\fIEA\u0002NCB\u0004B!a\u001a\u0002`&!\u0011\u0011]A5\u00059)\u0005o\\2i\u000b:$wJ\u001a4tKRDq!!:\u001a\u0001\u0004\t9/\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004r!a\u0012\u0002Zf\fI\u000f\u0005\u0003\u0002Z\u0005-\u0018bAAwU\tIQ\t]8dQ\u0012\u000bG/Y\u0001 SN|eMZ:fi\u001a{'\u000fT3bI\u0016\u0014X\t]8dQN+\b\u000f]8si\u0016$WCAAz!\r\u0019\u0017Q_\u0005\u0004\u0003o\u001c$a\u0002\"p_2,\u0017M\\\u0001\tiJ,hnY1uKR1\u0011QBA\u007f\u0003\u007fDa!!\t\u001c\u0001\u0004I\bb\u0002B\u00017\u0001\u0007!1A\u0001\u0010iJ,hnY1uS>t7\u000b^1uKB\u0019\u0011F!\u0002\n\u0007\t\u001d!EA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#HCBA\u0007\u0005\u001b\u0011y\u0001\u0003\u0004\u0002\"q\u0001\r!\u001f\u0005\b\u0005#a\u0002\u0019AA\u0014\u0003\u0019ygMZ:fi\u0006\u0011b.\u001a=u%\u0016\fG-\u001f)beRLG/[8o)\u0011\u00119B!\t\u0011\t\r<(\u0011\u0004\t\u0007G\u0006M\u0013Pa\u0007\u0011\u0007%\u0012i\"C\u0002\u0003 \t\u00121\u0003U1si&$\u0018n\u001c8GKR\u001c\u0007n\u0015;bi\u0016DqAa\t\u001e\u0001\u0004\u0011)#\u0001\u0007qCJ$\u0018\u000e^5p]6\u000b\u0007\u000fE\u0004\u0002H\u0005e\u0017Pa\u0007\u0002-M,G.Z2u!\u0006\u0014H/\u001b;j_:$vNR3uG\"$BAa\u0006\u0003,!9!1\u0005\u0010A\u0002\t\u0015\u0012A\u00062vS2$g)\u001a;dQ\u001a{'\u000fU1si&$\u0018n\u001c8\u0015\r\tE\"\u0011\nB'!\u0019\u0011\u0019D!\u0011\u0003H9!!Q\u0007B\u001f\u001d\u0011\u00119Da\u000f\u000f\u0007A\u0012I$C\u0001&\u0013\t\u0019C%C\u0002\u0003@\t\nQ#\u00112tiJ\f7\r\u001e$fi\u000eDWM\u001d+ie\u0016\fG-\u0003\u0003\u0003D\t\u0015#\u0001\u0006*fgVdGoV5uQB\u000b'\u000f^5uS>t7OC\u0002\u0003@\t\u0002BaY<\u0002d!1!1J\u0010A\u0002e\f!\u0001\u001e9\t\u000f\t=s\u00041\u0001\u0003\u001c\u0005Qa-\u001a;dQN#\u0018\r^3\u0002\u0015\t,\u0018\u000e\u001c3GKR\u001c\u0007\u000e\u0006\u0003\u00032\tU\u0003b\u0002B\u0012A\u0001\u0007!Q\u0005")
public class ReplicaAlterLogDirsThread
extends AbstractFetcherThread {
    private final ReplicaManager replicaMgr;
    private final ReplicationQuotaManager quota;
    private final int replicaId;
    private final Integer maxBytes;
    private final Integer fetchSize;
    private Option<TopicPartition> inProgressPartition;

    private int replicaId() {
        return this.replicaId;
    }

    private Integer maxBytes() {
        return this.maxBytes;
    }

    private Integer fetchSize() {
        return this.fetchSize;
    }

    private Option<TopicPartition> inProgressPartition() {
        return this.inProgressPartition;
    }

    private void inProgressPartition_$eq(Option<TopicPartition> x$1) {
        this.inProgressPartition = x$1;
    }

    @Override
    public Option<Object> latestEpoch(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).latestEpoch();
    }

    @Override
    public long logEndOffset(TopicPartition topicPartition) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).logEndOffset();
    }

    @Override
    public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
        return this.replicaMgr.futureLocalLogOrException(topicPartition).endOffsetForEpoch(epoch);
    }

    @Override
    public Seq<Tuple2<TopicPartition, FetchResponse.PartitionData<Records>>> fetchFromLeader(FetchRequest.Builder fetchRequest) {
        ObjectRef partitionData = ObjectRef.create(null);
        FetchRequest request = (FetchRequest)fetchRequest.build();
        this.replicaMgr.fetchMessages(0L, Request$.MODULE$.FutureLocalReplicaId(), request.minBytes(), request.maxBytes(), request.version() <= 2, (Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>>)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.fetchData()).asScala()).toSeq(), QuotaFactory$UnboundedQuota$.MODULE$, (Function1<Seq<Tuple2<TopicPartition, FetchPartitionData>>, BoxedUnit>)(Function1 & Serializable)responsePartitionData -> {
            ReplicaAlterLogDirsThread.processResponseCallback$1(responsePartitionData, partitionData);
            return BoxedUnit.UNIT;
        }, request.isolationLevel(), (Option<ClientMetadata>)None$.MODULE$);
        if ((Seq)partitionData.elem == null) {
            throw new IllegalStateException(new StringBuilder(36).append("Failed to fetch data for partitions ").append(Predef$.MODULE$.wrapRefArray(request.fetchData().keySet().toArray()).mkString(",")).toString());
        }
        return (Seq)partitionData.elem;
    }

    @Override
    public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponse.PartitionData<Records> partitionData) {
        Partition partition = (Partition)this.replicaMgr.nonOfflinePartition(topicPartition).get();
        Log futureLog = partition.futureLocalLogOrException();
        MemoryRecords records = this.toMemoryRecords((Records)partitionData.records);
        if (fetchOffset != futureLog.logEndOffset()) {
            throw new IllegalStateException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Offset mismatch for the future replica %s: fetched offset = %d, log end offset = %d."), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, BoxesRunTime.boxToLong((long)fetchOffset), BoxesRunTime.boxToLong((long)futureLog.logEndOffset())})));
        }
        Option<LogAppendInfo> logAppendInfo = partition.appendRecordsToFollowerOrFutureReplica(records, true);
        futureLog.updateHighWatermark(partitionData.highWatermark);
        futureLog.maybeIncrementLogStartOffset(partitionData.logStartOffset);
        if (partition.maybeReplaceCurrentWithFutureReplica()) {
            this.removePartitions((Set<TopicPartition>)((Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{topicPartition}))));
        }
        this.quota.record(records.sizeInBytes());
        return logAppendInfo;
    }

    @Override
    public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.localLogOrException().logStartOffset();
    }

    @Override
    public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int leaderEpoch) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        return partition.localLogOrException().logEndOffset();
    }

    @Override
    public Map<TopicPartition, EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetsForLeaderEpochRequest.PartitionData> partitions) {
        return (Map)partitions.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                TopicPartition tp = (TopicPartition)tuple22._1();
                OffsetsForLeaderEpochRequest.PartitionData epochData = (OffsetsForLeaderEpochRequest.PartitionData)tuple22._2();
                try {
                    EpochEndOffset epochEndOffset;
                    if (epochData.leaderEpoch == -1) {
                        epochEndOffset = new EpochEndOffset(-1, -1L);
                    } else {
                        Partition partition = $this.replicaMgr.getPartitionOrException(tp, false);
                        epochEndOffset = partition.lastOffsetForLeaderEpoch(epochData.currentLeaderEpoch, epochData.leaderEpoch, false);
                    }
                    EpochEndOffset endOffset = epochEndOffset;
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)endOffset);
                }
                catch (Throwable t) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error when getting EpochEndOffset for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
                    tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new EpochEndOffset(Errors.forException((Throwable)t), -1, -1L));
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        });
    }

    @Override
    public boolean isOffsetForLeaderEpochSupported() {
        return true;
    }

    @Override
    public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateTo(truncationState.offset(), true);
    }

    @Override
    public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        Partition partition = this.replicaMgr.getPartitionOrException(topicPartition, false);
        partition.truncateFullyAndStartAt(offset, true);
    }

    private Option<Tuple2<TopicPartition, PartitionFetchState>> nextReadyPartition(Map<TopicPartition, PartitionFetchState> partitionMap) {
        return ((IterableOnceOps)partitionMap.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaAlterLogDirsThread.$anonfun$nextReadyPartition$1(x0$1)))).reduceLeftOption((Function2 & Serializable)(left, right) -> {
            Tuple2 tuple2;
            block3: {
                block2: {
                    if (StringOps$.MODULE$.$less$extension(Predef$.MODULE$.augmentString(((TopicPartition)left._1()).topic()), ((TopicPartition)right._1()).topic())) break block2;
                    String string = ((TopicPartition)left._1()).topic();
                    String string2 = ((TopicPartition)right._1()).topic();
                    if ((string != null ? !string.equals(string2) : string2 != null) || ((TopicPartition)left._1()).partition() >= ((TopicPartition)right._1()).partition()) break block3;
                }
                tuple2 = left;
                return tuple2;
            }
            tuple2 = right;
            return tuple2;
        });
    }

    /*
     * WARNING - void declaration
     */
    private Option<Tuple2<TopicPartition, PartitionFetchState>> selectPartitionToFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        Option option;
        Object object = new Object();
        try {
            void var3_3;
            this.inProgressPartition().foreach((Function1 & Serializable)tp -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$1(partitionMap, object, tp);
                return BoxedUnit.UNIT;
            });
            this.inProgressPartition_$eq((Option<TopicPartition>)None$.MODULE$);
            Option<Tuple2<TopicPartition, PartitionFetchState>> nextPartitionOpt = this.nextReadyPartition(partitionMap);
            nextPartitionOpt.foreach((Function1 & Serializable)x0$1 -> {
                ReplicaAlterLogDirsThread.$anonfun$selectPartitionToFetch$4(this, partitionMap, x0$1);
                return BoxedUnit.UNIT;
            });
            option = var3_3;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    private AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetchForPartition(TopicPartition tp, PartitionFetchState fetchState) {
        Growable growable;
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> requestMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        scala.collection.mutable.Set partitionsWithError = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        try {
            long logStartOffset = this.replicaMgr.futureLocalLogOrException(tp).logStartOffset();
            growable = requestMap.put(tp, new FetchRequest.PartitionData(fetchState.fetchOffset(), logStartOffset, Predef$.MODULE$.Integer2int(this.fetchSize()), Optional.of(Predef$.MODULE$.int2Integer(fetchState.currentLeaderEpoch()))));
        }
        catch (KafkaStorageException e) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Failed to build fetch for ").append(tp).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            growable = partitionsWithError.$plus$eq((Object)tp);
        }
        None$ fetchRequestOpt = requestMap.isEmpty() ? None$.MODULE$ : new Some((Object)FetchRequest.Builder.forReplica((short)ApiKeys.FETCH.latestVersion(), (int)this.replicaId(), (int)0, (int)0, requestMap).setMaxBytes(Predef$.MODULE$.Integer2int(this.maxBytes())));
        return new AbstractFetcherThread.ResultWithPartitions<None$>(fetchRequestOpt, (Set<TopicPartition>)partitionsWithError);
    }

    @Override
    public AbstractFetcherThread.ResultWithPartitions<Option<FetchRequest.Builder>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
        AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions;
        if (this.quota.isQuotaExceeded()) {
            resultWithPartitions = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
        } else {
            AbstractFetcherThread.ResultWithPartitions<None$> resultWithPartitions2;
            Some some;
            Tuple2 tuple2;
            Option<Tuple2<TopicPartition, PartitionFetchState>> option = this.selectPartitionToFetch(partitionMap);
            if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
                TopicPartition tp = (TopicPartition)tuple2._1();
                PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
                resultWithPartitions2 = this.buildFetchForPartition(tp, fetchState);
            } else if (None$.MODULE$.equals(option)) {
                resultWithPartitions2 = new AbstractFetcherThread.ResultWithPartitions<None$>(None$.MODULE$, (Set<TopicPartition>)((Set)Set$.MODULE$.empty()));
            } else {
                throw new MatchError(option);
            }
            resultWithPartitions = resultWithPartitions2;
        }
        return resultWithPartitions;
    }

    private static final void processResponseCallback$1(Seq responsePartitionData, ObjectRef partitionData$1) {
        partitionData$1.elem = (Seq)responsePartitionData.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            FetchPartitionData data = (FetchPartitionData)tuple2._2();
            List abortedTransactions = (List)data.abortedTransactions().map((Function1 & Serializable)x$1 -> (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)x$1).asJava()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            long lastStableOffset = BoxesRunTime.unboxToLong((Object)data.lastStableOffset().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)new FetchResponse.PartitionData(data.error(), data.highWatermark(), lastStableOffset, data.logStartOffset(), abortedTransactions, (BaseRecords)data.records()));
            return tuple22;
        });
    }

    public static final /* synthetic */ boolean $anonfun$nextReadyPartition$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        PartitionFetchState partitionFetchState = (PartitionFetchState)tuple2._2();
        boolean bl = partitionFetchState.isReadyForFetch();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$1(Map partitionMap$1, Object nonLocalReturnKey1$1, TopicPartition tp) {
        Option fetchStateOpt = partitionMap$1.get((Object)tp);
        fetchStateOpt.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isReadyForFetch())).foreach((Function1 & Serializable)fetchState -> {
            throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)new Tuple2((Object)tp, fetchState)));
        });
    }

    public static final /* synthetic */ void $anonfun$selectPartitionToFetch$4(ReplicaAlterLogDirsThread $this, Map partitionMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        PartitionFetchState fetchState = (PartitionFetchState)tuple2._2();
        $this.inProgressPartition_$eq((Option<TopicPartition>)new Some((Object)tp));
        $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(52).append("Beginning/resuming copy of partition ").append(tp).append(" from offset ").append(fetchState.fetchOffset()).append(". ").toString()).append(new StringBuilder(81).append("Including this partition, there are ").append(partitionMap$1.size()).append(" remaining partitions to copy by this thread.").toString()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ReplicaAlterLogDirsThread(String name, BrokerEndPoint sourceBroker, KafkaConfig brokerConfig, FailedPartitions failedPartitions, ReplicaManager replicaMgr, ReplicationQuotaManager quota, BrokerTopicStats brokerTopicStats) {
        this.replicaMgr = replicaMgr;
        this.quota = quota;
        super(name, name, sourceBroker, failedPartitions, Predef$.MODULE$.Integer2int(brokerConfig.replicaFetchBackoffMs()), false);
        this.replicaId = brokerConfig.brokerId();
        this.maxBytes = brokerConfig.replicaFetchResponseMaxBytes();
        this.fetchSize = brokerConfig.replicaFetchMaxBytes();
        this.inProgressPartition = None$.MODULE$;
    }
}

