/*
 * Decompiled with CFR 0.152.
 */
package kafka;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import kafka.ReplicationQuotasTestRig$;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.TestUtils$;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\rUv!B-[\u0011\u0003if!B0[\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007bB5\u0002\u0005\u0004%IA\u001b\u0005\u0007g\u0006\u0001\u000b\u0011B6\t\u000fQ\f!\u0019!C\u0001k\"1\u00110\u0001Q\u0001\nYDQA_\u0001\u0005\u0002mDq!!\b\u0002\t\u0003\tyB\u0002\u0004\u0002*\u0005\u0001\u00151\u0006\u0005\u000b\u0003\u000bJ!Q3A\u0005\u0002\u0005\u001d\u0003BCA%\u0013\tE\t\u0015!\u0003\u0002\n!I\u00111J\u0005\u0003\u0016\u0004%\t!\u001e\u0005\n\u0003\u001bJ!\u0011#Q\u0001\nYD\u0011\"a\u0014\n\u0005+\u0007I\u0011A;\t\u0013\u0005E\u0013B!E!\u0002\u00131\bBCA*\u0013\tU\r\u0011\"\u0001\u0002V!Q\u0011QL\u0005\u0003\u0012\u0003\u0006I!a\u0016\t\u0013\u0005}\u0013B!f\u0001\n\u0003)\b\"CA1\u0013\tE\t\u0015!\u0003w\u0011%\t\u0019'\u0003BK\u0002\u0013\u0005Q\u000fC\u0005\u0002f%\u0011\t\u0012)A\u0005m\"1q-\u0003C\u0001\u0003OB\u0011\"!\u001e\n\u0005\u0004%\t!!\u0016\t\u0011\u0005]\u0014\u0002)A\u0005\u0003/B\u0011\"!\u001f\n\u0003\u0003%\t!a\u001f\t\u0013\u0005%\u0015\"%A\u0005\u0002\u0005-\u0005\"CAQ\u0013E\u0005I\u0011AAR\u0011%\t9+CI\u0001\n\u0003\t\u0019\u000bC\u0005\u0002*&\t\n\u0011\"\u0001\u0002,\"I\u0011qV\u0005\u0012\u0002\u0013\u0005\u00111\u0015\u0005\n\u0003cK\u0011\u0013!C\u0001\u0003GC\u0001\"a-\n\u0003\u0003%\tE\u001b\u0005\t\u0003kK\u0011\u0011!C\u0001k\"I\u0011qW\u0005\u0002\u0002\u0013\u0005\u0011\u0011\u0018\u0005\n\u0003\u000bL\u0011\u0011!C!\u0003\u000fD\u0011\"!6\n\u0003\u0003%\t!a6\t\u0013\u0005\u0005\u0018\"!A\u0005B\u0005\r\b\"CAt\u0013\u0005\u0005I\u0011IAu\u0011%\tY/CA\u0001\n\u0003\ni\u000fC\u0005\u0002p&\t\t\u0011\"\u0011\u0002r\u001eI!\u0011H\u0001\u0002\u0002#\u0005!1\b\u0004\n\u0003S\t\u0011\u0011!E\u0001\u0005{Aaa\u001a\u0016\u0005\u0002\t=\u0003\"CAvU\u0005\u0005IQIAw\u0011%\u0011\tFKA\u0001\n\u0003\u0013\u0019\u0006C\u0005\u0003b)\n\t\u0011\"!\u0003d!I!Q\u000f\u0016\u0002\u0002\u0013%!q\u000f\u0004\u0007\u0005\u007f\n\u0001A!!\t\r\u001d\u0004D\u0011\u0001BN\u0011!\u0011y\n\rb\u0001\n\u0003Q\u0007b\u0002BQa\u0001\u0006Ia\u001b\u0005\t\u0005G\u0003\u0004\u0019!C\u0001U\"I!Q\u0015\u0019A\u0002\u0013\u0005!q\u0015\u0005\b\u0005W\u0003\u0004\u0015)\u0003l\u0011!\u0011i\u000b\rb\u0001\n\u0003)\bb\u0002BXa\u0001\u0006IA\u001e\u0005\n\u0005c\u0003\u0004\u0019!C\u0001\u0005gC\u0011Ba21\u0001\u0004%\tA!3\t\u0011\t5\u0007\u0007)Q\u0005\u0005kC\u0011Ba41\u0005\u0004%\tA!5\t\u0011\t\u001d\b\u0007)A\u0005\u0005'D\u0011B!;1\u0005\u0004%\tA!5\t\u0011\t-\b\u0007)A\u0005\u0005'DqA!<1\t\u0003\u0011y\u000fC\u0004\u0003xB\"\tEa\n\t\u000f\u0005u\u0001\u0007\"\u0001\u0003z\"91\u0011\u0001\u0019\u0005\u0002\r\r\u0001bBB\u0004a\u0011\u00051\u0011\u0002\u0005\b\u0007c\u0001D\u0011\u0001B\u0014\u0011\u001d\u0019\u0019\u0004\rC\u0001\u0007kAqa!\u00111\t\u0003\u0019\u0019\u0005C\u0004\u0004ZA\"\taa\u0017\t\u000f\r\r\u0004\u0007\"\u0001\u0004f!911\u0010\u0019\u0005\u0002\ru\u0004bBBAa\u0011\u000511\u0011\u0005\b\u0007'\u0003D\u0011\u0001B\u0014\u0011\u001d\u0019)\n\rC\u0005\u0007/Cqaa*1\t\u0003\u0019IK\u0002\u0004\u0002|\u0006\u0001\u0011Q \u0005\u0007O>#\t!a@\t\u0013\t\u0005qJ1A\u0005\n\t\r\u0001\u0002\u0003B\t\u001f\u0002\u0006IA!\u0002\t\u000f\tMq\n\"\u0001\u0003\u0016!9!\u0011D(\u0005\u0002\tm\u0001b\u0002B\u0013\u001f\u0012\u0005!q\u0005\u0005\b\u0005SyE\u0011\u0001B\u0014\u0011\u001d\u0011Yc\u0014C\u0001\u0005[AqAa\bP\t\u0003\u0011\u0019$\u0001\rSKBd\u0017nY1uS>t\u0017+^8uCN$Vm\u001d;SS\u001eT\u0011aW\u0001\u0006W\u000647.Y\u0002\u0001!\tq\u0016!D\u0001[\u0005a\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018m\u001d+fgR\u0014\u0016nZ\n\u0003\u0003\u0005\u0004\"AY3\u000e\u0003\rT\u0011\u0001Z\u0001\u0006g\u000e\fG.Y\u0005\u0003M\u000e\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001^\u0003\r!\u0017N]\u000b\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\u0005Y\u0006twMC\u0001q\u0003\u0011Q\u0017M^1\n\u0005Il'AB*ue&tw-\u0001\u0003eSJ\u0004\u0013!A6\u0016\u0003Y\u0004\"AY<\n\u0005a\u001c'aA%oi\u0006\u00111\u000eI\u0001\u0005[\u0006Lg\u000e\u0006\u0002}\u007fB\u0011!-`\u0005\u0003}\u000e\u0014A!\u00168ji\"9\u0011\u0011A\u0004A\u0002\u0005\r\u0011\u0001B1sON\u0004RAYA\u0003\u0003\u0013I1!a\u0002d\u0005\u0015\t%O]1z!\u0011\tY!!\u0007\u000f\t\u00055\u0011Q\u0003\t\u0004\u0003\u001f\u0019WBAA\t\u0015\r\t\u0019\u0002X\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005]1-\u0001\u0004Qe\u0016$WMZ\u0005\u0004e\u0006m!bAA\fG\u0006\u0019!/\u001e8\u0015\u000fq\f\t#!>\u00036!9\u00111\u0005\u0005A\u0002\u0005\u0015\u0012AB2p]\u001aLw\rE\u0002\u0002(%i\u0011!\u0001\u0002\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0014\r%\t\u0017QFA\u001a!\r\u0011\u0017qF\u0005\u0004\u0003c\u0019'a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003k\tyD\u0004\u0003\u00028\u0005mb\u0002BA\b\u0003sI\u0011\u0001Z\u0005\u0004\u0003{\u0019\u0017a\u00029bG.\fw-Z\u0005\u0005\u0003\u0003\n\u0019E\u0001\u0007TKJL\u0017\r\\5{C\ndWMC\u0002\u0002>\r\fAA\\1nKV\u0011\u0011\u0011B\u0001\u0006]\u0006lW\rI\u0001\bEJ|7.\u001a:t\u0003!\u0011'o\\6feN\u0004\u0013A\u00039beRLG/[8og\u0006Y\u0001/\u0019:uSRLwN\\:!\u0003!!\bN]8ui2,WCAA,!\r\u0011\u0017\u0011L\u0005\u0004\u00037\u001a'\u0001\u0002'p]\u001e\f\u0011\u0002\u001e5s_R$H.\u001a\u0011\u0002!5\u001cxm\u001d)feB\u000b'\u000f^5uS>t\u0017!E7tON\u0004VM\u001d)beRLG/[8oA\u00059Qn]4TSj,\u0017\u0001C7tONK'0\u001a\u0011\u0015\u001d\u0005\u0015\u0012\u0011NA6\u0003[\ny'!\u001d\u0002t!9\u0011Q\t\fA\u0002\u0005%\u0001BBA&-\u0001\u0007a\u000f\u0003\u0004\u0002PY\u0001\rA\u001e\u0005\b\u0003'2\u0002\u0019AA,\u0011\u0019\tyF\u0006a\u0001m\"1\u00111\r\fA\u0002Y\fa\u0003^1sO\u0016$()\u001f;fgB+'O\u0011:pW\u0016\u0014XJQ\u0001\u0018i\u0006\u0014x-\u001a;CsR,7\u000fU3s\u0005J|7.\u001a:N\u0005\u0002\nAaY8qsRq\u0011QEA?\u0003\u007f\n\t)a!\u0002\u0006\u0006\u001d\u0005\"CA#3A\u0005\t\u0019AA\u0005\u0011!\tY%\u0007I\u0001\u0002\u00041\b\u0002CA(3A\u0005\t\u0019\u0001<\t\u0013\u0005M\u0013\u0004%AA\u0002\u0005]\u0003\u0002CA03A\u0005\t\u0019\u0001<\t\u0011\u0005\r\u0014\u0004%AA\u0002Y\fabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u000e*\"\u0011\u0011BAHW\t\t\t\n\u0005\u0003\u0002\u0014\u0006uUBAAK\u0015\u0011\t9*!'\u0002\u0013Ut7\r[3dW\u0016$'bAANG\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0015Q\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003KS3A^AH\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM\nabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002.*\"\u0011qKAH\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY,!1\u0011\u0007\t\fi,C\u0002\u0002@\u000e\u00141!\u00118z\u0011!\t\u0019MIA\u0001\u0002\u00041\u0018a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002JB1\u00111ZAi\u0003wk!!!4\u000b\u0007\u0005=7-\u0001\u0006d_2dWm\u0019;j_:LA!a5\u0002N\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\tI.a8\u0011\u0007\t\fY.C\u0002\u0002^\u000e\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002D\u0012\n\t\u00111\u0001\u0002<\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\rY\u0017Q\u001d\u0005\t\u0003\u0007,\u0013\u0011!a\u0001m\u0006A\u0001.Y:i\u0007>$W\rF\u0001w\u0003!!xn\u0015;sS:<G#A6\u0002\r\u0015\fX/\u00197t)\u0011\tI.a=\t\u0013\u0005\r\u0007&!AA\u0002\u0005m\u0006bBA|\u0011\u0001\u0007\u0011\u0011`\u0001\bU>,(O\\1m!\r\t9c\u0014\u0002\b\u0015>,(O\\1m'\ty\u0015\r\u0006\u0002\u0002z\u0006\u0019An\\4\u0016\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005\u001bi!A!\u0003\u000b\u0007\t-q.\u0001\u0002j_&!!q\u0002B\u0005\u0005\u00111\u0015\u000e\\3\u0002\t1|w\rI\u0001\u0010CB\u0004XM\u001c3U_*{WO\u001d8bYR\u0019APa\u0006\t\u000f\u0005\r2\u000b1\u0001\u0002&\u0005Y\u0011\r\u001d9f]\u0012\u001c\u0005.\u0019:u)\u0015a(Q\u0004B\u0011\u0011\u001d\u0011y\u0002\u0016a\u0001\u0003\u0013\tA\u0001]1uQ\"9!1\u0005+A\u0002\u0005e\u0017!\u00024jeN$\u0018A\u00025fC\u0012,'\u000fF\u0001}\u0003\u00191wn\u001c;fe\u00061\u0011\r\u001d9f]\u0012$2\u0001 B\u0018\u0011\u001d\u0011\td\u0016a\u0001\u0003\u0013\tq!\\3tg\u0006<W\r\u0006\u0002\u0002\n!9!q\u0007\u0005A\u0002\u0005e\u0017!\u00063jgBd\u0017-_\"iCJ$8o\u00148TGJ,WM\\\u0001\u000e\u000bb\u0004XM]5nK:$H)\u001a4\u0011\u0007\u0005\u001d\"fE\u0003+\u0005\u007f\u0011Y\u0005\u0005\b\u0003B\t\u001d\u0013\u0011\u0002<w\u0003/2h/!\n\u000e\u0005\t\r#b\u0001B#G\u00069!/\u001e8uS6,\u0017\u0002\u0002B%\u0005\u0007\u0012\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87!\u0011\u00119A!\u0014\n\t\u0005\u0005#\u0011\u0002\u000b\u0003\u0005w\tQ!\u00199qYf$b\"!\n\u0003V\t]#\u0011\fB.\u0005;\u0012y\u0006C\u0004\u0002F5\u0002\r!!\u0003\t\r\u0005-S\u00061\u0001w\u0011\u0019\ty%\fa\u0001m\"9\u00111K\u0017A\u0002\u0005]\u0003BBA0[\u0001\u0007a\u000f\u0003\u0004\u0002d5\u0002\rA^\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011)G!\u001d\u0011\u000b\t\u00149Ga\u001b\n\u0007\t%4M\u0001\u0004PaRLwN\u001c\t\fE\n5\u0014\u0011\u0002<w\u0003/2h/C\u0002\u0003p\r\u0014a\u0001V;qY\u00164\u0004\"\u0003B:]\u0005\u0005\t\u0019AA\u0013\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005s\u00022\u0001\u001cB>\u0013\r\u0011i(\u001c\u0002\u0007\u001f\nTWm\u0019;\u0003\u0015\u0015C\b/\u001a:j[\u0016tGoE\u00031\u0005\u0007\u0013y\t\u0005\u0003\u0003\u0006\n-UB\u0001BD\u0015\r\u0011IIW\u0001\u0003u.LAA!$\u0003\b\n!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004BA!%\u0003\u00186\u0011!1\u0013\u0006\u0004\u0005+S\u0016!B;uS2\u001c\u0018\u0002\u0002BM\u0005'\u0013q\u0001T8hO&tw\r\u0006\u0002\u0003\u001eB\u0019\u0011q\u0005\u0019\u0002\u0013Q|\u0007/[2OC6,\u0017A\u0003;pa&\u001cg*Y7fA\u0005qQ\r\u001f9fe&lWM\u001c;OC6,\u0017AE3ya\u0016\u0014\u0018.\\3oi:\u000bW.Z0%KF$2\u0001 BU\u0011!\t\u0019-NA\u0001\u0002\u0004Y\u0017aD3ya\u0016\u0014\u0018.\\3oi:\u000bW.\u001a\u0011\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\ra\u0006\u0014H/\u001b;j_:LE\rI\u0001\bg\u0016\u0014h/\u001a:t+\t\u0011)\f\u0005\u0004\u0002L\n]&1X\u0005\u0005\u0005s\u000biMA\u0002TKF\u0004BA!0\u0003D6\u0011!q\u0018\u0006\u0004\u0005\u0003T\u0016AB:feZ,'/\u0003\u0003\u0003F\n}&aC&bM.\f7+\u001a:wKJ\f1b]3sm\u0016\u00148o\u0018\u0013fcR\u0019APa3\t\u0013\u0005\r'(!AA\u0002\tU\u0016\u0001C:feZ,'o\u001d\u0011\u0002\u00171,\u0017\rZ3s%\u0006$Xm]\u000b\u0003\u0005'\u0004rA!6\u0003\\Z\u0014y.\u0004\u0002\u0003X*!!\u0011\\Ag\u0003\u001diW\u000f^1cY\u0016LAA!8\u0003X\n\u0019Q*\u00199\u0011\u000b\t\f)A!9\u0011\u0007\t\u0014\u0019/C\u0002\u0003f\u000e\u0014a\u0001R8vE2,\u0017\u0001\u00047fC\u0012,'OU1uKN\u0004\u0013!\u00044pY2|w/\u001a:SCR,7/\u0001\bg_2dwn^3s%\u0006$Xm\u001d\u0011\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0007q\u0014\t\u0010C\u0004\u0003t\u0002\u0003\rA!>\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\b#BAf\u0005o3\u0018\u0001\u0003;fCJ$un\u001e8\u0015\u000fq\u0014YP!@\u0003\u0000\"9\u00111\u0005\"A\u0002\u0005\u0015\u0002bBA|\u0005\u0002\u0007\u0011\u0011 \u0005\b\u0005o\u0011\u0005\u0019AAm\u0003]1\u0018\r\\5eCR,\u0017\t\u001c7PM\u001a\u001cX\r^:NCR\u001c\u0007\u000eF\u0002}\u0007\u000bAq!a\tD\u0001\u0004\t)#A\u0005m_\u001e|U\u000f\u001e9viR9Apa\u0003\u0004\u000e\rU\u0001bBA\u0012\t\u0002\u0007\u0011Q\u0005\u0005\b\u0007\u001f!\u0005\u0019AB\t\u0003!\u0011X\r\u001d7jG\u0006\u001c\bcBAf\u0007'1(Q_\u0005\u0005\u0005;\fi\rC\u0004\u0004\u0018\u0011\u0003\ra!\u0007\u0002\u001b9,w/Q:tS\u001etW.\u001a8u!!\tYma\u0005\u0004\u001c\tU\b\u0003BB\u000f\u0007[i!aa\b\u000b\t\r\u000521E\u0001\u0007G>lWn\u001c8\u000b\u0007m\u001b)C\u0003\u0003\u0004(\r%\u0012AB1qC\u000eDWM\u0003\u0002\u0004,\u0005\u0019qN]4\n\t\r=2q\u0004\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003u9\u0018-\u001b;G_J\u0014V-Y:tS\u001etW.\u001a8u)>\u001cu.\u001c9mKR,\u0017a\u0003:f]\u0012,'o\u00115beR$\u0012\u0002`B\u001c\u0007w\u0019ida\u0010\t\u000f\reb\t1\u0001\u0003T\u0006!A-\u0019;b\u0011\u001d\t)E\u0012a\u0001\u0003\u0013Aq!a>G\u0001\u0004\tI\u0010C\u0004\u00038\u0019\u0003\r!!7\u0002)5\f\u0017PY3ESN\u0004H.Y=P]N\u001b'/Z3o)\u0015a8QIB$\u0011\u001d\u00119d\u0012a\u0001\u00033Dqa!\u0013H\u0001\u0004\u0019Y%A\u0003dQ\u0006\u0014H\u000f\u0005\u0003\u0004N\rUSBAB(\u0015\u0011\u0019Ie!\u0015\u000b\t\rM3\u0011F\u0001\u0006U\u001a\u0014X-Z\u0005\u0005\u0007/\u001ayE\u0001\u0006K\rJ,Wm\u00115beR\f1b\u001e:ji\u0016$vNR5mKR9Ap!\u0018\u0004`\r\u0005\u0004bBA#\u0011\u0002\u0007\u0011\u0011\u0002\u0005\b\u0003oD\u0005\u0019AA}\u0011\u001d\u0019I\u0005\u0013a\u0001\u0007\u0017\n1b\u0019:fCR,7\t[1siR111JB4\u0007SBq!!\u0012J\u0001\u0004\tI\u0001C\u0004\u0004l%\u0003\ra!\u001c\u0002\u000f\u0011\fG/Y:fiB!1qNB<\u001b\t\u0019\tH\u0003\u0003\u0004t\rU\u0014A\u0001=z\u0015\u0011\u0019Id!\u0015\n\t\re4\u0011\u000f\u0002\u00131f\u001bVM]5fg\u000e{G\u000e\\3di&|g.\u0001\bbI\u0012$\u0015\r^1U_\u000eC\u0017M\u001d;\u0015\t\r54q\u0010\u0005\b\u0007sQ\u0005\u0019\u0001Bj\u0003\u0019\u0011XmY8sIRA1QQBD\u0007\u0017\u001by\tE\u0003c\u0005O\u0012y\u000eC\u0004\u0004\n.\u0003\rAa5\u0002\u000bI\fG/Z:\t\r\r55\n1\u0001w\u0003!\u0011'o\\6fe&#\u0007bBBI\u0017\u0002\u0007!\u0011]\u0001\fGV\u0014(/\u001a8u%\u0006$X-\u0001\tqe&tGOU1uK6+GO]5dg\u0006aQ.Z1tkJ,GMU1uKR1!\u0011]BM\u0007;Cqaa'N\u0001\u0004\u0011Y,\u0001\u0004ce>\\WM\u001d\u0005\b\u0007?k\u0005\u0019ABQ\u0003\u001d\u0011X\r\u001d+za\u0016\u0004BA!0\u0004$&!1Q\u0015B`\u0005%\tVo\u001c;b)f\u0004X-\u0001\u0003kg>tG\u0003BA\u0005\u0007WCqa!,O\u0001\u0004\u0019y+A\u0003u_BL7\rE\u0003c\u0007c\u000bI!C\u0002\u00044\u000e\u0014!\u0002\u0010:fa\u0016\fG/\u001a3?\u0001")
public final class ReplicationQuotasTestRig {
    public static void run(ExperimentDef experimentDef, Journal journal, boolean bl) {
        ReplicationQuotasTestRig$.MODULE$.run(experimentDef, journal, bl);
    }

    public static void main(String[] stringArray) {
        ReplicationQuotasTestRig$.MODULE$.main(stringArray);
    }

    public static int k() {
        return ReplicationQuotasTestRig$.MODULE$.k();
    }

    public static class Experiment
    extends ZooKeeperTestHarness {
        private final String topicName;
        private String experimentName = "unset";
        private final int partitionId;
        private Seq<KafkaServer> servers = null;
        private final scala.collection.mutable.Map<Object, double[]> leaderRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        private final scala.collection.mutable.Map<Object, double[]> followerRates = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

        public String topicName() {
            return this.topicName;
        }

        public String experimentName() {
            return this.experimentName;
        }

        public void experimentName_$eq(String x$1) {
            this.experimentName = x$1;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public Seq<KafkaServer> servers() {
            return this.servers;
        }

        public void servers_$eq(Seq<KafkaServer> x$1) {
            this.servers = x$1;
        }

        public scala.collection.mutable.Map<Object, double[]> leaderRates() {
            return this.leaderRates;
        }

        public scala.collection.mutable.Map<Object, double[]> followerRates() {
            return this.followerRates;
        }

        public void startBrokers(Seq<Object> brokerIds) {
            String println_x = "Starting Brokers";
            Console$.MODULE$.println((Object)println_x);
            Object var2_2 = null;
            this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)brokerIds.map((Function1 & Serializable)i -> TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)i), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1))).map((Function1 & Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), Time.SYSTEM, (Option<String>)None$.MODULE$))));
        }

        @Override
        public void tearDown() {
            TestUtils$.MODULE$.shutdownServers(this.servers());
            super.tearDown();
        }

        /*
         * WARNING - void declaration
         */
        public void run(ExperimentDef config, Journal journal, boolean displayChartsOnScreen) {
            Tuple2 tuple2;
            Range.Inclusive inclusive;
            this.experimentName_$eq(config.name());
            int n = 100;
            int to$extension_end = 100 + config.brokers();
            Range.Inclusive inclusive2 = inclusive = new Range.Inclusive(n, to$extension_end, 1);
            inclusive = null;
            Range.Inclusive brokers = inclusive2;
            int n2 = 0;
            int shift = Math.round(config.brokers() / 2);
            int n3 = 0;
            int to$extension_end2 = config.partitions();
            Range.Inclusive map_this = new Range.Inclusive(n3, to$extension_end2, 1);
            map_this.scala$collection$immutable$Range$$validateMaxLength();
            Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
            Iterator map_strictOptimizedMap_it = map_this.iterator();
            while (map_strictOptimizedMap_it.hasNext()) {
                void map_strictOptimizedMap_$plus$eq_elem;
                Tuple2 tuple22;
                Tuple2 tuple23;
                void $anonfun$run$1_$minus$greater$extension_y;
                Tuple2 tuple24;
                int $anonfun$run$1_partition = BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next());
                SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100 + (++n2 + shift) % config.brokers()}));
                Integer $anonfun$run$1_$minus$greater$extension_$this = $anonfun$run$1_partition;
                Tuple2 tuple25 = tuple24 = new Tuple2((Object)$anonfun$run$1_$minus$greater$extension_$this, (Object)$anonfun$run$1_$minus$greater$extension_y);
                Object var30_20 = null;
                seqOps = null;
                tuple24 = null;
                Tuple2 tuple26 = tuple23 = tuple25;
                tuple23 = null;
                Tuple2 tuple27 = tuple22 = tuple26;
                tuple22 = null;
                tuple2 = tuple27;
                if (map_strictOptimizedMap_b == null) {
                    throw null;
                }
                map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                tuple2 = null;
            }
            Object var14_12 = null;
            Object var15_13 = null;
            Object var16_14 = null;
            tuple2 = null;
            scala.collection.immutable.Map replicas = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            this.startBrokers((Seq<Object>)brokers);
            TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)replicas, this.servers());
            String println_x = "Writing Data";
            Console$.MODULE$.println((Object)println_x);
            Object var24_23 = null;
            KafkaProducer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), SecurityProtocol.PLAINTEXT), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false);
            int n4 = 0;
            int until$extension_end = config.msgsPerPartition();
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n4, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$run$2(this, config, producer, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
            Object var18_27 = null;
            String println_x2 = "Starting Reassignment";
            Console$.MODULE$.println((Object)println_x2);
            Object var25_29 = null;
            Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)brokers, this.json((scala.collection.immutable.Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
            long start = System.currentTimeMillis();
            ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, new String(ReassignPartitionsZNode$.MODULE$.encode(newAssignment), StandardCharsets.UTF_8), new ReassignPartitionsCommand.Throttle(config.throttle(), -1L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), 10000L);
            this.waitForReassignmentToComplete();
            String println_x3 = new java.lang.StringBuilder(19).append("Reassignment took ").append((System.currentTimeMillis() - start) / 1000L).append("s").toString();
            Console$.MODULE$.println((Object)println_x3);
            Object var26_32 = null;
            this.validateAllOffsetsMatch(config);
            journal.appendToJournal(config);
            this.renderChart(this.leaderRates(), "Leader", journal, displayChartsOnScreen);
            this.renderChart(this.followerRates(), "Follower", journal, displayChartsOnScreen);
            this.logOutput(config, (Map<Object, Seq<Object>>)replicas, (Map<TopicPartition, Seq<Object>>)newAssignment);
            String println_x4 = new java.lang.StringBuilder(26).append("Output can be found here: ").append(journal.path()).toString();
            Console$.MODULE$.println((Object)println_x4);
        }

        public void validateAllOffsetsMatch(ExperimentDef config) {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$validateAllOffsetsMatch$1(this, config, broker);
                return BoxedUnit.UNIT;
            });
        }

        /*
         * WARNING - void declaration
         */
        public void logOutput(ExperimentDef config, Map<Object, Seq<Object>> replicas, Map<TopicPartition, Seq<Object>> newAssignment) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Map actual = (Map)this.zkClient().getPartitionAssignmentForTopics((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).apply((Object)this.topicName());
            String println_x = new java.lang.StringBuilder(17).append("The replicas are ").append(((IterableOps)replicas.toSeq().sortBy((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).map((Function1 & Serializable)x$4 -> new java.lang.StringBuilder(1).append("\n").append(x$4).toString())).toString();
            Console$.MODULE$.println((Object)println_x);
            Object var6_6 = null;
            String println_x2 = new java.lang.StringBuilder(40).append("This is the current replica assignment:\n").append(actual.mapValues((Function1 & Serializable)x$5 -> x$5.replicas()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq()).toString();
            Console$.MODULE$.println((Object)println_x2);
            Object var7_7 = null;
            String println_x3 = new java.lang.StringBuilder(25).append("proposed assignment is: \n").append(newAssignment).toString();
            Console$.MODULE$.println((Object)println_x3);
            Object var8_8 = null;
            String println_x4 = new java.lang.StringBuilder(39).append("This is the assignment we ended up with").append(actual.mapValues((Function1 & Serializable)x$6 -> x$6.replicas()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).toString();
            Console$.MODULE$.println((Object)println_x4);
            Object var9_9 = null;
            String println_x5 = new java.lang.StringBuilder(12).append("numBrokers: ").append(config.brokers()).toString();
            Console$.MODULE$.println((Object)println_x5);
            Object var10_10 = null;
            String println_x6 = new java.lang.StringBuilder(15).append("numPartitions: ").append(config.partitions()).toString();
            Console$.MODULE$.println((Object)println_x6);
            Object var11_11 = null;
            String println_x7 = new java.lang.StringBuilder(10).append("throttle: ").append(config.throttle()).toString();
            Console$.MODULE$.println((Object)println_x7);
            Object var12_12 = null;
            String println_x8 = new java.lang.StringBuilder(25).append("numMessagesPerPartition: ").append(config.msgsPerPartition()).toString();
            Console$.MODULE$.println((Object)println_x8);
            Object var13_13 = null;
            String println_x9 = new java.lang.StringBuilder(9).append("msgSize: ").append(config.msgSize()).toString();
            Console$.MODULE$.println((Object)println_x9);
            Object var14_14 = null;
            String println_x10 = new java.lang.StringBuilder(35).append("We will write ").append(config.targetBytesPerBrokerMB()).append("MB of data per broker").toString();
            Console$.MODULE$.println((Object)println_x10);
            Object var15_15 = null;
            String println_x11 = new java.lang.StringBuilder(23).append("Worst case duration is ").append(config.targetBytesPerBrokerMB() * 1000L * 1000L / config.throttle()).toString();
            Console$.MODULE$.println((Object)println_x11);
        }

        public void waitForReassignmentToComplete() {
            long waitUntilTrue_pause = 1000L;
            long waitUntilTrue_waitTimeMs = 3600000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!Experiment.$anonfun$waitForReassignmentToComplete$1(this)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    throw Assertions$.MODULE$.fail(Experiment.$anonfun$waitForReassignmentToComplete$2(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, waitUntilTrue_pause));
            }
        }

        public void renderChart(scala.collection.mutable.Map<Object, double[]> data, String name, Journal journal, boolean displayChartsOnScreen) {
            XYSeriesCollection dataset = this.addDataToChart(data);
            JFreeChart chart = this.createChart(name, dataset);
            this.writeToFile(name, journal, chart);
            this.maybeDisplayOnScreen(displayChartsOnScreen, chart);
            String println_x = new java.lang.StringBuilder(20).append("Chart generated for ").append(name).toString();
            Console$.MODULE$.println((Object)println_x);
        }

        public void maybeDisplayOnScreen(boolean displayChartsOnScreen, JFreeChart chart) {
            if (displayChartsOnScreen) {
                ChartFrame frame = new ChartFrame(this.experimentName(), chart);
                frame.pack();
                frame.setVisible(true);
            }
        }

        public void writeToFile(String name, Journal journal, JFreeChart chart) {
            File file = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), new java.lang.StringBuilder(5).append(this.experimentName()).append("-").append(name).append(".png").toString());
            ImageIO.write((RenderedImage)chart.createBufferedImage(1000, 700), "png", file);
            journal.appendChart(file.getAbsolutePath(), name == "Leader");
        }

        public JFreeChart createChart(String name, XYSeriesCollection dataset) {
            return ChartFactory.createXYLineChart((String)new java.lang.StringBuilder(26).append(this.experimentName()).append(" - ").append(name).append(" Throttling Performance").toString(), (String)"Time (s)", (String)"Throttle Throughput (B/s)", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        }

        /*
         * WARNING - void declaration
         */
        public XYSeriesCollection addDataToChart(scala.collection.mutable.Map<Object, double[]> data) {
            void var2_2;
            XYSeriesCollection dataset = new XYSeriesCollection();
            data.foreach((Function1 & Serializable)x0$1 -> {
                Experiment.$anonfun$addDataToChart$1(dataset, x0$1);
                return BoxedUnit.UNIT;
            });
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public Option<double[]> record(scala.collection.mutable.Map<Object, double[]> rates, int brokerId, double currentRate) {
            void $plus$plus$extension_evidence$25;
            double[] leaderRatesBroker = (double[])rates.getOrElse((Object)brokerId, (Function0 & Serializable)() -> (double[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double()));
            ManifestFactory.DoubleManifest doubleManifest = ClassTag$.MODULE$.Double();
            double[] $plus$plus$extension_xs = new double[]{currentRate};
            Object var6_6 = null;
            doubleManifest = null;
            leaderRatesBroker = (double[])ArrayOps$.MODULE$.appendedAll$extension((Object)leaderRatesBroker, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25);
            return rates.put((Object)brokerId, (Object)leaderRatesBroker);
        }

        public void printRateMetrics() {
            this.servers().foreach((Function1 & Serializable)broker -> {
                Experiment.$anonfun$printRateMetrics$1(this, broker);
                return BoxedUnit.UNIT;
            });
        }

        private double measuredRate(KafkaServer broker, QuotaType repType) {
            MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
            if (((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).contains((Object)metricName)) {
                return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
            }
            return -1.0;
        }

        /*
         * WARNING - void declaration
         */
        public String json(scala.collection.immutable.Seq<String> topic) {
            void mkString_sep;
            String string;
            IterableOnceOps iterableOnceOps = (IterableOnceOps)topic.map((Function1 & Serializable)t -> new java.lang.StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString());
            String string2 = ",";
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps mkString_this = iterableOnceOps;
            String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
            Object var3_3 = null;
            string2 = null;
            string = null;
            String topicStr = string3;
            return new java.lang.StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
        }

        private static final int nextReplicaRoundRobin$1(IntRef count$1, int shift$1, ExperimentDef config$1) {
            ++count$1.elem;
            return 100 + (count$1.elem + shift$1) % config$1.brokers();
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Tuple2 $anonfun$run$1(IntRef count$1, int shift$1, ExperimentDef config$1, int partition) {
            void $minus$greater$extension_y;
            int[] nArray = new int[1];
            ++count$1.elem;
            nArray[0] = 100 + (count$1.elem + shift$1) % config$1.brokers();
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(nArray));
            Integer $minus$greater$extension_$this = partition;
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }

        public static final /* synthetic */ Future $anonfun$run$3(Experiment $this, KafkaProducer producer$1, ExperimentDef config$1, int partition) {
            Integer n;
            Integer n2 = n = Integer.valueOf(partition);
            n = null;
            return producer$1.send(new ProducerRecord($this.topicName(), n2, null, (Object)new byte[config$1.msgSize()]));
        }

        public static final /* synthetic */ void $anonfun$run$2(Experiment $this, ExperimentDef config$1, KafkaProducer producer$1, int x) {
            int n = 0;
            int until$extension_end = config$1.partitions();
            Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    Experiment.$anonfun$run$3($this, producer$1, config$1, foreach_i);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public static final /* synthetic */ long $anonfun$validateAllOffsetsMatch$4() {
            return -1L;
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$2(Experiment $this, KafkaServer broker$1, ExperimentDef config$2, int partitionId) {
            Object object;
            LogManager qual$1 = broker$1.getLogManager();
            TopicPartition x$1 = new TopicPartition($this.topicName(), partitionId);
            boolean x$2 = qual$1.getLog$default$2();
            Option option = qual$1.getLog(x$1, x$2);
            if (option == null) {
                throw null;
            }
            Option map_this = option;
            Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Log)map_this.get()).logEndOffset());
            None$ none$ = object2;
            Object var9_7 = null;
            object2 = null;
            None$ getOrElse_this = none$;
            if (getOrElse_this.isEmpty()) {
                Long l;
                Long l2 = l = Long.valueOf(-1L);
                l = null;
                object = l2;
            } else {
                object = getOrElse_this.get();
            }
            Object object3 = object;
            Object var11_9 = null;
            object = null;
            long offset = BoxesRunTime.unboxToLong((Object)object3);
            if (offset >= 0L && offset != (long)config$2.msgsPerPartition()) {
                throw new RuntimeException(new java.lang.StringBuilder(82).append("Run failed as offsets did not match for partition ").append(partitionId).append(" on broker ").append(broker$1.config().brokerId()).append(". Expected ").append(config$2.msgsPerPartition()).append(" but was ").append(offset).append(".").toString());
            }
        }

        public static final /* synthetic */ void $anonfun$validateAllOffsetsMatch$1(Experiment $this, ExperimentDef config$2, KafkaServer broker) {
            int n = 0;
            int until$extension_end = config$2.partitions();
            Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach$mVc$sp_this.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
                while (true) {
                    Experiment.$anonfun$validateAllOffsetsMatch$2($this, broker, config$2, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this.step();
                }
            }
        }

        public static final /* synthetic */ boolean $anonfun$waitForReassignmentToComplete$1(Experiment $this) {
            $this.printRateMetrics();
            return !$this.zkClient().reassignPartitionsInProgress();
        }

        public static final /* synthetic */ String $anonfun$waitForReassignmentToComplete$2() {
            return new java.lang.StringBuilder(21).append("Znode ").append(ReassignPartitionsZNode$.MODULE$.path()).append(" wasn't deleted").toString();
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$2(XYSeries series$1, IntRef x$7, double value) {
            series$1.add((double)x$7.elem, value);
            ++x$7.elem;
        }

        public static final /* synthetic */ void $anonfun$addDataToChart$1(XYSeriesCollection dataset$1, Tuple2 x0$1) {
            if (x0$1 != null) {
                int broker = x0$1._1$mcI$sp();
                double[] values = (double[])x0$1._2();
                XYSeries series = new XYSeries((Comparable)((Object)new java.lang.StringBuilder(7).append("Broker:").append(broker).toString()));
                int n = 0;
                for (double d : values) {
                    series.add((double)n, d);
                    ++n;
                }
                dataset$1.addSeries(series);
                return;
            }
            throw new MatchError(null);
        }

        public static final /* synthetic */ void $anonfun$printRateMetrics$1(Experiment $this, KafkaServer broker) {
            double leaderRate = $this.measuredRate(broker, (QuotaType)QuotaType.LeaderReplication$.MODULE$);
            if (broker.config().brokerId() == 100) {
                $this.info((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(33).append("waiting... Leader rate on 101 is ").append(leaderRate).toString());
            }
            $this.record($this.leaderRates(), broker.config().brokerId(), leaderRate);
            if (leaderRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(19).append("Leader Rate on ").append(broker.config().brokerId()).append(" is ").append(leaderRate).toString());
            }
            double followerRate = $this.measuredRate(broker, (QuotaType)QuotaType.FollowerReplication$.MODULE$);
            $this.record($this.followerRates(), broker.config().brokerId(), followerRate);
            if (followerRate > 0.0) {
                $this.trace((Function0<String>)(Function0 & Serializable)() -> new java.lang.StringBuilder(21).append("Follower Rate on ").append(broker.config().brokerId()).append(" is ").append(followerRate).toString());
            }
        }

        public Experiment() {
            this.topicName = "my-topic";
            this.partitionId = 0;
        }

        public static final /* synthetic */ Tuple2 $anonfun$run$1$adapted(IntRef count$1, int shift$1, ExperimentDef config$1, Object partition) {
            return Experiment.$anonfun$run$1(count$1, shift$1, config$1, BoxesRunTime.unboxToInt((Object)partition));
        }

        public static final /* synthetic */ Future $anonfun$run$3$adapted(Experiment $this, KafkaProducer producer$1, ExperimentDef config$1, Object partition) {
            return Experiment.$anonfun$run$3($this, producer$1, config$1, BoxesRunTime.unboxToInt((Object)partition));
        }

        public static final /* synthetic */ Object $anonfun$validateAllOffsetsMatch$3$adapted(Log x$2) {
            return BoxesRunTime.boxToLong((long)x$2.logEndOffset());
        }
    }

    public static class ExperimentDef
    implements Product,
    Serializable {
        private final String name;
        private final int brokers;
        private final int partitions;
        private final long throttle;
        private final int msgsPerPartition;
        private final int msgSize;
        private final long targetBytesPerBrokerMB;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String name() {
            return this.name;
        }

        public int brokers() {
            return this.brokers;
        }

        public int partitions() {
            return this.partitions;
        }

        public long throttle() {
            return this.throttle;
        }

        public int msgsPerPartition() {
            return this.msgsPerPartition;
        }

        public int msgSize() {
            return this.msgSize;
        }

        public long targetBytesPerBrokerMB() {
            return this.targetBytesPerBrokerMB;
        }

        public ExperimentDef copy(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            return new ExperimentDef(name, brokers, partitions, throttle, msgsPerPartition, msgSize);
        }

        public String copy$default$1() {
            return this.name();
        }

        public int copy$default$2() {
            return this.brokers();
        }

        public int copy$default$3() {
            return this.partitions();
        }

        public long copy$default$4() {
            return this.throttle();
        }

        public int copy$default$5() {
            return this.msgsPerPartition();
        }

        public int copy$default$6() {
            return this.msgSize();
        }

        public String productPrefix() {
            return "ExperimentDef";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.name();
                }
                case 1: {
                    return this.brokers();
                }
                case 2: {
                    return this.partitions();
                }
                case 3: {
                    return this.throttle();
                }
                case 4: {
                    return this.msgsPerPartition();
                }
                case 5: {
                    return this.msgSize();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return new /* Unavailable Anonymous Inner Class!! */;
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ExperimentDef;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "name";
                }
                case 1: {
                    return "brokers";
                }
                case 2: {
                    return "partitions";
                }
                case 3: {
                    return "throttle";
                }
                case 4: {
                    return "msgsPerPartition";
                }
                case 5: {
                    return "msgSize";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.name()));
            n = Statics.mix((int)n, (int)this.brokers());
            n = Statics.mix((int)n, (int)this.partitions());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.throttle()));
            n = Statics.mix((int)n, (int)this.msgsPerPartition());
            n = Statics.mix((int)n, (int)this.msgSize());
            int finalizeHash_length = 6;
            return Statics.avalanche((int)(n ^ finalizeHash_length));
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof ExperimentDef)) return false;
            boolean bl = true;
            if (!bl) return false;
            ExperimentDef experimentDef = (ExperimentDef)x$1;
            if (this.brokers() != experimentDef.brokers()) return false;
            if (this.partitions() != experimentDef.partitions()) return false;
            if (this.throttle() != experimentDef.throttle()) return false;
            if (this.msgsPerPartition() != experimentDef.msgsPerPartition()) return false;
            if (this.msgSize() != experimentDef.msgSize()) return false;
            String string = this.name();
            String string2 = experimentDef.name();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!experimentDef.canEqual(this)) return false;
            return true;
        }

        public ExperimentDef(String name, int brokers, int partitions, long throttle, int msgsPerPartition, int msgSize) {
            this.name = name;
            this.brokers = brokers;
            this.partitions = partitions;
            this.throttle = throttle;
            this.msgsPerPartition = msgsPerPartition;
            this.msgSize = msgSize;
            this.targetBytesPerBrokerMB = (long)msgsPerPartition * (long)msgSize * (long)partitions / (long)brokers / 1000000L;
        }
    }

    public static class Journal {
        private final File log = new File(ReplicationQuotasTestRig$.MODULE$.kafka$ReplicationQuotasTestRig$$dir(), "Log.html");

        private File log() {
            return this.log;
        }

        public void appendToJournal(ExperimentDef config) {
            double arg$macro$1 = config.throttle();
            double arg$macro$2 = config.msgsPerPartition();
            double arg$macro$3 = config.msgSize();
            String message = new java.lang.StringBuilder(0).append(new java.lang.StringBuilder(11).append("\n\n<h3>").append(config.name()).append("</h3>").toString()).append(new java.lang.StringBuilder(18).append("<p>- BrokerCount: ").append(config.brokers()).toString()).append(new java.lang.StringBuilder(21).append("<p>- PartitionCount: ").append(config.partitions()).toString()).append(StringOps$.MODULE$.format$extension("<p>- Throttle: %,.0f MB/s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1}))).append(StringOps$.MODULE$.format$extension("<p>- MsgCount: %,.0f ", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$2}))).append(StringOps$.MODULE$.format$extension("<p>- MsgSize: %,.0f", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3}))).append(new java.lang.StringBuilder(32).append("<p>- TargetBytesPerBrokerMB: ").append(config.targetBytesPerBrokerMB()).append("<p>").toString()).toString();
            this.append(message);
        }

        public void appendChart(String path, boolean first) {
            StringBuilder message = new StringBuilder();
            if (first) {
                message.append("<p><p>");
            }
            message.append(new java.lang.StringBuilder(72).append("<img src=\"").append(path).append("\" alt=\"Chart\" style=\"width:600px;height:400px;align=\"middle\"\">").toString());
            if (!first) {
                message.append("<p><p>");
            }
            this.append(message.result());
        }

        public void header() {
            this.append("<html><head><h1>Replication Quotas Test Rig</h1></head><body>");
        }

        public void footer() {
            this.append("</body></html>");
        }

        public void append(String message) {
            OutputStream stream = Files.newOutputStream(this.log().toPath(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
            new PrintWriter(null, stream, message){
                {
                    this.append(message$1);
                    this.close();
                }
            };
        }

        public String path() {
            return this.log().getAbsolutePath();
        }

        public Journal() {
            this.header();
        }
    }
}

