/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import joptsimple.OptionSpec;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function2;
import scala.Option;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005e4A\u0001G\r\u0001=!)Q\u0005\u0001C\u0001M!)\u0011\u0006\u0001C\u0001U!)q\u0007\u0001C\u0001U!)A\b\u0001C\u0001U!)\u0011\t\u0001C\u0001U!)1\t\u0001C\u0001U!)Q\t\u0001C\u0001U!)q\t\u0001C\u0001U!)\u0011\n\u0001C\u0001U!)1\n\u0001C\u0001U!)Q\n\u0001C\u0001U!)q\n\u0001C\u0001U!)\u0011\u000b\u0001C\u0001U!)1\u000b\u0001C\u0001U!)Q\u000b\u0001C\u0001U!)q\u000b\u0001C\u0001U!)\u0011\f\u0001C\u0001U!)1\f\u0001C\u0001U!)Q\f\u0001C\u0001U!)q\f\u0001C\u0001U!)\u0011\r\u0001C\u0001U!)1\r\u0001C\u0001U!)Q\r\u0001C\u0001M\n\t#+Z1tg&<g\u000eU1si&$\u0018n\u001c8t\u0007>lW.\u00198e\u0003J<7\u000fV3ti*\u0011!dG\u0001\u0006C\u0012l\u0017N\u001c\u0006\u00029\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001 !\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\n\t\u0003Q\u0001i\u0011!G\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002WA\u0011\u0001\u0005L\u0005\u0003[\u0005\u0012A!\u00168ji\"\u0012!a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\nQA[;oSRT\u0011\u0001N\u0001\u0004_J<\u0017B\u0001\u001c2\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0004sA\u0011\u0001GO\u0005\u0003wE\u0012Q!\u00114uKJ\fqf\u001d5pk2$7i\u001c:sK\u000e$H.\u001f)beN,g+\u00197jI6Kg.[7v[\u001e+g.\u001a:bi\u0016|\u0005\u000f^5p]ND#\u0001\u0002 \u0011\u0005Az\u0014B\u0001!2\u0005\u0011!Vm\u001d;\u0002]MDw.\u001e7e\u0007>\u0014(/Z2uYf\u0004\u0016M]:f-\u0006d\u0017\u000eZ'j]&lW/\\#yK\u000e,H/Z(qi&|gn\u001d\u0015\u0003\u000by\nQf\u001d5pk2$7i\u001c:sK\u000e$H.\u001f)beN,g+\u00197jI6Kg.[7v[Z+'/\u001b4z\u001fB$\u0018n\u001c8tQ\t1a(\u0001\u0012tQ>,H\u000eZ!mY><H\u000b\u001b:piRdWm\u00149uS>twJ\\#yK\u000e,H/\u001a\u0015\u0003\u000fy\n!d\u001d5pk2$Wk]3EK\u001a\fW\u000f\u001c;t\u0013\u001a,e.\u00192mK\u0012D#\u0001\u0003 \u0002%MDw.\u001e7e\r\u0006LG.\u00134O_\u0006\u0013xm\u001d\u0015\u0003\u0013y\nAc\u001d5pk2$g)Y5m\u0013\u001a\u0014E.\u00198l\u0003J<\u0007F\u0001\u0006?\u0003\u0015\u001a\bn\\;mI:{G/\u00117m_^,\u00050Z2vi\u0016<\u0016\u000e\u001e5U_BL7m](qi&|g\u000e\u000b\u0002\f}\u0005\u00013\u000f[8vY\u0012tu\u000e^!mY><X\t_3dkR,w+\u001b;i\u0005J|7.\u001a:tQ\taa(\u0001\u0018tQ>,H\u000e\u001a(pi\u0006cGn\\<Fq\u0016\u001cW\u000f^3XSRDw.\u001e;SK\u0006\u001c8/[4o[\u0016tGo\u00149uS>t\u0007FA\u0007?\u0003Q\u001a\bn\\;mI:{G/\u00117m_^<UM\\3sCR,w+\u001b;i_V$(I]8lKJ\u001c\u0018I\u001c3U_BL7m](qi&|gn\u001d\u0015\u0003\u001dy\n!f\u001d5pk2$gj\u001c;BY2|woR3oKJ\fG/Z,ji\"|W\u000f\u001e\"s_.,'o](qi&|g\u000e\u000b\u0002\u0010}\u0005I3\u000f[8vY\u0012tu\u000e^!mY><x)\u001a8fe\u0006$XmV5uQ>,H\u000fV8qS\u000e\u001cx\n\u001d;j_:D#\u0001\u0005 \u0002QMDw.\u001e7e\u001d>$\u0018\t\u001c7po\u001e+g.\u001a:bi\u0016<\u0016\u000e\u001e5UQJ|G\u000f\u001e7f\u001fB$\u0018n\u001c8)\u0005Eq\u0014\u0001L:i_VdGMT8u\u00032dwn^$f]\u0016\u0014\u0018\r^3XSRD'+Z1tg&<g.\\3oi>\u0003H/[8oQ\t\u0011b(A\u0017tQ>,H\u000e\u001a(pi\u0006cGn\\<WKJLg-_,ji\"|W\u000f\u001e*fCN\u001c\u0018n\u001a8nK:$x\n\u001d;j_:D#a\u0005 \u0002SMDw.\u001e7e\u001d>$\u0018\t\u001c7po\n\u0013xn[3sg2K7\u000f^,ji\"4VM]5gs>\u0003H/[8oQ\t!b(\u0001\u0014tQ>,H\u000e\u001a(pi\u0006cGn\\<UQJ|G\u000f\u001e7f/&$\bNV3sS\u001aLx\n\u001d;j_:D#!\u0006 \u0002IMDw.\u001e7e\u001d>$\u0018\t\u001c7poR{\u0007/[2t\u001fB$\u0018n\u001c8XSRDg+\u001a:jMfD#A\u0006 \u0002\u001dMDw.\u001e7e\r\u0006LGnV5uQR\u00191f\u001a;\t\u000b!<\u0002\u0019A5\u0002\u00075\u001cx\r\u0005\u0002kc:\u00111n\u001c\t\u0003Y\u0006j\u0011!\u001c\u0006\u0003]v\ta\u0001\u0010:p_Rt\u0014B\u00019\"\u0003\u0019\u0001&/\u001a3fM&\u0011!o\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A\f\u0003\"B;\u0018\u0001\u00041\u0018\u0001B1sON\u00042\u0001I<j\u0013\tA\u0018EA\u0003BeJ\f\u0017\u0010")
public class ReassignPartitionsCommandArgsTest {
    @Before
    public void setUp() {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(x$1, message) -> ReassignPartitionsCommandArgsTest.$anonfun$setUp$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
    }

    @After
    public void tearDown() {
        Exit.resetExitProcedure();
    }

    @Test
    public void shouldCorrectlyParseValidMinimumGenerateOptions() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json"};
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumExecuteOptions() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldCorrectlyParseValidMinimumVerifyOptions() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldAllowThrottleOptionOnExecute() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute", "--throttle", "100", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
    }

    @Test
    public void shouldUseDefaultsIfEnabled() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json"};
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
        Assert.assertEquals((long)10000L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.timeoutOpt())));
        Assert.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)opts.options().valueOf((OptionSpec)opts.interBrokerThrottleOpt())));
    }

    @Test
    public void shouldFailIfNoArgs() {
        String[] args = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        this.shouldFailWith(ReassignPartitionsCommand$.MODULE$.helpText(), args);
    }

    @Test
    public void shouldFailIfBlankArg() {
        String[] args = new String[]{" "};
        this.shouldFailWith("Command must include exactly one action: --generate, --execute or --verify", args);
    }

    @Test
    public void shouldNotAllowExecuteWithTopicsOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithBrokers() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute", "--reassignment-json-file", "myfile.json", "--broker-list", "101,102"};
        this.shouldFailWith("Option \"[execute]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowExecuteWithoutReassignmentOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--execute"};
        this.shouldFailWith("If --execute option is used, command must include --reassignment-json-file that was output during the --generate option", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersAndTopicsOptions() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--generate"};
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutBrokersOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--topics-to-move-json-file", "myfile.json", "--generate"};
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithoutTopicsOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--broker-list", "101,102", "--generate"};
        this.shouldFailWith("If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options", args);
    }

    @Test
    public void shouldNotAllowGenerateWithThrottleOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--throttle", "100", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowGenerateWithReassignmentOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--generate", "--broker-list", "101,102", "--topics-to-move-json-file", "myfile.json", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[generate]\" can't be used with option \"[reassignment-json-file]\"", args);
    }

    @Test
    public void shouldNotAllowVerifyWithoutReassignmentOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--verify"};
        this.shouldFailWith("If --verify option is used, command must include --reassignment-json-file that was used during the --execute option", args);
    }

    @Test
    public void shouldNotAllowBrokersListWithVerifyOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--verify", "--broker-list", "100,101", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[broker-list]\"", args);
    }

    @Test
    public void shouldNotAllowThrottleWithVerifyOption() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--verify", "--throttle", "100", "--reassignment-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[throttle]\"", args);
    }

    @Test
    public void shouldNotAllowTopicsOptionWithVerify() {
        String[] args = new String[]{"--zookeeper", "localhost:1234", "--verify", "--reassignment-json-file", "myfile.json", "--topics-to-move-json-file", "myfile.json"};
        this.shouldFailWith("Option \"[verify]\" can't be used with option \"[topics-to-move-json-file]\"", args);
    }

    public void shouldFailWith(String msg, String[] args) {
        try {
            ReassignPartitionsCommand$.MODULE$.validateAndParseArgs(args);
            Assert.fail((String)new StringBuilder(51).append("Should have failed with [").append(msg).append("] but no failure occurred.").toString());
            return;
        }
        catch (Exception e) {
            Assert.assertTrue((String)new StringBuilder(46).append("Expected exception with message:\n[").append(msg).append("]\nbut was\n[").append(e.getMessage()).append("]").toString(), (boolean)e.getMessage().startsWith(msg));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Nothing$ $anonfun$setUp$1(int x$1, Option message) {
        void orNull_ev;
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (message == null) {
            throw null;
        }
        Object object = message.isEmpty() ? orNull_ev.apply(null) : message.get();
        Object object2 = object;
        eq2 = null;
        object = null;
        throw new IllegalArgumentException((String)object2);
    }
}

