/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import kafka.admin.AclCommand$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclEntry$;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.JaasTestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.GroupAuthorizationException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.server.authorizer.Authorizer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Builder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r-b!\u0002/^\u0003\u0003\u0011\u0007\"\u00026\u0001\t\u0003Y\u0007bB7\u0001\u0005\u0004%\tE\u001c\u0005\u0007k\u0002\u0001\u000b\u0011B8\t\u000bY\u0004A\u0011I<\t\u000fm\u0004!\u0019!C\u0001]\"1A\u0010\u0001Q\u0001\n=Dq! \u0001C\u0002\u0013\u0005a\u0010C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B@\t\u0013\u0005E\u0001A1A\u0005\u0002\u0005M\u0001\u0002CA\u0015\u0001\u0001\u0006I!!\u0006\t\u0011\u0005-\u0002A1A\u0005\u0002yDq!!\f\u0001A\u0003%q\u0010C\u0005\u00020\u0001\u0011\r\u0011\"\u0001\u0002\u0014!A\u0011\u0011\u0007\u0001!\u0002\u0013\t)\u0002\u0003\u0005\u00024\u0001\u0011\r\u0011\"\u0001\u007f\u0011\u001d\t)\u0004\u0001Q\u0001\n}D\u0001\"a\u000e\u0001\u0005\u0004%\tA\u001c\u0005\b\u0003s\u0001\u0001\u0015!\u0003p\u0011%\tY\u0004\u0001b\u0001\n\u0003\ti\u0004\u0003\u0005\u0002V\u0001\u0001\u000b\u0011BA \u0011%\t9\u0006\u0001b\u0001\u000e\u0003\t\u0019\u0002C\u0005\u0002Z\u0001\u0011\rQ\"\u0001\u0002\u0014!Q\u00111\f\u0001\t\u0006\u0004%\t&!\u0018\t\u000f\u0005E\u0004\u0001\"\u0005\u0002t!I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011Q\u0015\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003O\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011\u0011\u0016\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003W\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011Q\u0016\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003_\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011\u0011\u0017\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003g\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011Q\u0017\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011\u0011\u0018\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002\u0018\"9\u0011Q\u0018\u0001\u0005\u0002\u0005M\u0001bBA`\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\tY\r\u0001C\u0001\u0003\u0007Dq!!4\u0001\t\u0003\ty\rC\u0004\u0002T\u0002!\t!a1\t\u000f\u0005U\u0007\u0001\"\u0001\u0002D\"9\u0011q\u001b\u0001\u0005\u0002\u0005\r\u0007bBAm\u0001\u0011\u0005\u00111\u001c\u0005\b\u0003?\u0004A\u0011AAb\u0011\u001d\t\t\u000f\u0001C\u0001\u0003\u0007Dq!a9\u0001\t\u0003\t\u0019\rC\u0004\u0002f\u0002!\t!a:\t\u000f\t\u0015\u0001\u0001\"\u0001\u0002h\"9!q\u0001\u0001\u0005\u0002\u0005\u001d\bb\u0002B\u0005\u0001\u0011\u0005\u0011q\u001d\u0005\b\u0005\u0017\u0001A\u0011AAt\u0011\u001d\u0011i\u0001\u0001C\u0001\u0003ODqAa\u0004\u0001\t\u0003\t9\u000f\u0003\u0004\u0003\u0012\u0001!\te\u001e\u0005\u0007\u0005C\u0001A\u0011I<\t\r\t-\u0002\u0001\"\u0001x\u0011\u0019\u0011)\u0004\u0001C\to\"9!q\u0007\u0001\u0005\n\te\u0002B\u0002B/\u0001\u0011\u0005q\u000f\u0003\u0004\u0003b\u0001!\ta\u001e\u0005\u0007\u0005K\u0002A\u0011A<\t\r\t%\u0004\u0001\"\u0001x\u0011\u0019\u0011i\u0007\u0001C\u0005o\"1!q\u000e\u0001\u0005\n]DqA!\u001d\u0001\t\u0013\u0011\u0019\bC\u0004\u0003x\u0001!\tB!\u001f\t\r\tu\u0004\u0001\"\u0003x\u0011\u0019\u0011y\b\u0001C\u0001o\"1!1\u0011\u0001\u0005\u0002]DaAa\"\u0001\t\u00039\bB\u0002BK\u0001\u0011\u0005q\u000f\u0003\u0004\u0003\u001a\u0002!Ia\u001e\u0005\u0007\u00057\u0003A\u0011A<\t\r\t}\u0005\u0001\"\u0001x\u0011\u0019\u0011\u0019\u000b\u0001C\u0005o\"1!Q\u0015\u0001\u0005\u0002]DqA!+\u0001\t+\u0011Y\u000bC\u0004\u0003L\u0002!)B!4\t\u0013\tE\b!%A\u0005\u0016\tM\b\"CB\u0005\u0001E\u0005IQ\u0003Bz\u0011%\u0019Y\u0001AI\u0001\n+\u0019i\u0001C\u0005\u0004\u0012\u0001\t\n\u0011\"\u0006\u0003t\"I11\u0003\u0001\u0012\u0002\u0013U1Q\u0003\u0005\b\u00073\u0001A\u0011BB\u000e\u0011%\u0019)\u0003AI\u0001\n\u0013\u0011\u0019\u0010C\u0005\u0004(\u0001\t\n\u0011\"\u0003\u0003t\"I1\u0011\u0006\u0001\u0012\u0002\u0013%1Q\u0002\u0002\u001a\u000b:$Gk\\#oI\u0006+H\u000f[8sSj\fG/[8o)\u0016\u001cHO\u0003\u0002_?\u0006\u0019\u0011\r]5\u000b\u0003\u0001\fQa[1gW\u0006\u001c\u0001aE\u0002\u0001G\u001e\u0004\"\u0001Z3\u000e\u0003uK!AZ/\u0003-%sG/Z4sCRLwN\u001c+fgRD\u0015M\u001d8fgN\u0004\"\u0001\u001a5\n\u0005%l&!C*bg2\u001cV\r^;q\u0003\u0019a\u0014N\\5u}Q\tA\u000e\u0005\u0002e\u0001\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005y\u0007C\u00019t\u001b\u0005\t(\"\u0001:\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\f(aA%oi\u0006a!M]8lKJ\u001cu.\u001e8uA\u0005\u00193m\u001c8gS\u001e,(/Z*fGV\u0014\u0018\u000e^=CK\u001a|'/Z*feZ,'o]*uCJ$H#\u0001=\u0011\u0005AL\u0018B\u0001>r\u0005\u0011)f.\u001b;\u0002\u00159,XNU3d_J$7/A\u0006ok6\u0014VmY8sIN\u0004\u0013aC4s_V\u0004\bK]3gSb,\u0012a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003\u0011a\u0017M\\4\u000b\u0005\u0005%\u0011\u0001\u00026bm\u0006LA!!\u0004\u0002\u0004\t11\u000b\u001e:j]\u001e\fAb\u001a:pkB\u0004&/\u001a4jq\u0002\nQa\u001a:pkB,\"!!\u0006\u0011\t\u0005]\u0011Q\u0005\b\u0005\u00033\t\t\u0003E\u0002\u0002\u001cEl!!!\b\u000b\u0007\u0005}\u0011-\u0001\u0004=e>|GOP\u0005\u0004\u0003G\t\u0018A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005\u001d\"bAA\u0012c\u00061qM]8va\u0002\n1\u0002^8qS\u000e\u0004&/\u001a4jq\u0006aAo\u001c9jGB\u0013XMZ5yA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\n\u0001b^5mI\u000e\f'\u000fZ\u0001\no&dGmY1sI\u0002\nA\u0001]1si\u0006)\u0001/\u0019:uA\u0005\u0011A\u000f]\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002R5\u0011\u00111\t\u0006\u0005\u0003\u000b\n9%\u0001\u0004d_6lwN\u001c\u0006\u0004A\u0006%#\u0002BA&\u0003\u001b\na!\u00199bG\",'BAA(\u0003\ry'oZ\u0005\u0005\u0003'\n\u0019E\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0007Q\u0004\b%A\bdY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m\u00039Y\u0017MZ6b!JLgnY5qC2\fa\u0002\u001e:vgR\u001cFo\u001c:f\r&dW-\u0006\u0002\u0002`A)\u0001/!\u0019\u0002f%\u0019\u00111M9\u0003\tM{W.\u001a\t\u0005\u0003O\ni'\u0004\u0002\u0002j)!\u00111NA\u0004\u0003\tIw.\u0003\u0003\u0002p\u0005%$\u0001\u0002$jY\u0016\fq\"Y;uQ>\u0014\u0018N_3s\u00072\f7o]\u000b\u0003\u0003k\u0002D!a\u001e\u0002\u0002B1\u0011qCA=\u0003{JA!a\u001f\u0002(\t)1\t\\1tgB!\u0011qPAA\u0019\u0001!1\"a!\u0019\u0003\u0003\u0005\tQ!\u0001\u0002\u0006\n\u0019q\fJ\u0019\u0012\t\u0005\u001d\u0015Q\u0012\t\u0004a\u0006%\u0015bAAFc\n9aj\u001c;iS:<\u0007c\u00019\u0002\u0010&\u0019\u0011\u0011S9\u0003\u0007\u0005s\u00170A\u0007u_BL7MU3t_V\u00148-Z\u000b\u0003\u0003/\u0003B!!'\u0002 6\u0011\u00111\u0014\u0006\u0005\u0003;\u000b\u0019%\u0001\u0005sKN|WO]2f\u0013\u0011\t\t+a'\u0003\u001fI+7o\\;sG\u0016\u0004\u0016\r\u001e;fe:\fa\u0002^8qS\u000e\u0014Vm]8ve\u000e,\u0007%A\u0007he>,\bOU3t_V\u00148-Z\u0001\u000fOJ|W\u000f\u001d*fg>,(oY3!\u0003=\u0019G.^:uKJ\u0014Vm]8ve\u000e,\u0017\u0001E2mkN$XM\u001d*fg>,(oY3!\u0003U\u0001(/\u001a4jq\u0016$Gk\u001c9jGJ+7o\\;sG\u0016\fa\u0003\u001d:fM&DX\r\u001a+pa&\u001c'+Z:pkJ\u001cW\rI\u0001\u0016aJ,g-\u001b=fI\u001e\u0013x.\u001e9SKN|WO]2f\u0003Y\u0001(/\u001a4jq\u0016$wI]8vaJ+7o\\;sG\u0016\u0004\u0013!F<jY\u0012\u001c\u0017M\u001d3U_BL7MU3t_V\u00148-Z\u0001\u0017o&dGmY1sIR{\u0007/[2SKN|WO]2fA\u0005)r/\u001b7eG\u0006\u0014Hm\u0012:pkB\u0014Vm]8ve\u000e,\u0017AF<jY\u0012\u001c\u0017M\u001d3He>,\bOU3t_V\u00148-\u001a\u0011\u0002#-\fgm[1Qe&t7-\u001b9bYN#(/\u0001\ndY&,g\u000e\u001e)sS:\u001c\u0017\u000e]1m'R\u0014\u0018!E2mkN$XM]!di&|g.\u0011:hgV\u0011\u0011Q\u0019\t\u0006a\u0006\u001d\u0017QC\u0005\u0004\u0003\u0013\f(!B!se\u0006L\u0018A\u0006;pa&\u001c'I]8lKJ\u0014V-\u00193BG2\f%oZ:\u0002\u001dA\u0014x\u000eZ;dK\u0006\u001bG.\u0011:hgR!\u0011QYAi\u0011\u001d\tyc\u000ba\u0001\u0003+\tq\u0002Z3tGJL'-Z!dY\u0006\u0013xm]\u0001\u0016I\u0016dW\r^3EKN\u001c'/\u001b2f\u0003\u000ed\u0017I]4t\u0003I!W\r\\3uK^\u0013\u0018\u000e^3BG2\f%oZ:\u0002\u001d\r|gn];nK\u0006\u001bG.\u0011:hgR!\u0011QYAo\u0011\u001d\tyc\fa\u0001\u0003+\tAb\u001a:pkB\f5\r\\!sON\fQ\u0004\u001d:pIV\u001cWmQ8ogVlWmV5mI\u000e\f'\u000fZ!dY\u0006\u0013xm]\u0001\u001faJ|G-^2f\u0007>t7/^7f!J,g-\u001b=fI\u0006\u001bGn]!sON\f\u0001c\u00117vgR,'/Q2uS>t\u0017i\u00197\u0016\u0005\u0005%\bCBAv\u0003k\fI0\u0004\u0002\u0002n*!\u0011q^Ay\u0003%IW.\\;uC\ndWMC\u0002\u0002tF\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\t90!<\u0003\u0007M+G\u000f\u0005\u0003\u0002|\n\u0005QBAA\u007f\u0015\u0011\ty0a\u0011\u0002\u0007\u0005\u001cG.\u0003\u0003\u0003\u0004\u0005u(AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\f!\u0003V8qS\u000e\u0014%o\\6feJ+\u0017\rZ!dY\u0006aqI]8vaJ+\u0017\rZ!dY\u0006aAk\u001c9jGJ+\u0017\rZ!dY\u0006iAk\u001c9jG^\u0013\u0018\u000e^3BG2\f\u0001\u0003V8qS\u000e$Um]2sS\n,\u0017i\u00197\u0002\u001dQ{\u0007/[2De\u0016\fG/Z!dY\u0006)1/\u001a;Va\"\u001a!H!\u0006\u0011\t\t]!QD\u0007\u0003\u00053QAAa\u0007\u0002N\u0005)!.\u001e8ji&!!q\u0004B\r\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002<\u0005K\u0001BAa\u0006\u0003(%!!\u0011\u0006B\r\u0005\u0015\te\r^3s\u0003m!Xm\u001d;Qe>$WoY3D_:\u001cX/\\3WS\u0006\f5o]5h]\"\u001aAHa\f\u0011\t\t]!\u0011G\u0005\u0005\u0005g\u0011IB\u0001\u0003UKN$\u0018AH2p]\u001aL'/\u001c*fCV$\b.\u001a8uS\u000e\fG/[8o\u001b\u0016$(/[2t\u0003!9W\r^$bk\u001e,G\u0003\u0002B\u001e\u00053\u0002bA!\u0010\u0003P\tMSB\u0001B \u0015\u0011\u0011\tEa\u0011\u0002\t\r|'/\u001a\u0006\u0005\u0005\u000b\u00129%A\u0004nKR\u0014\u0018nY:\u000b\t\t%#1J\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\t5\u0013aA2p[&!!\u0011\u000bB \u0005\u00159\u0015-^4f!\r\u0001(QK\u0005\u0004\u0005/\n(A\u0002#pk\ndW\rC\u0004\u0003\\y\u0002\r!!\u0006\u0002\u00155,GO]5d\u001d\u0006lW-\u0001\u0010uKN$\bK]8ek\u000e,7i\u001c8tk6,g+[1Tk\n\u001c8M]5cK\"\u001aqHa\f\u0002EQ,7\u000f\u001e)s_\u0012,8-Z\"p]N,X.Z,ji\"<\u0016\u000e\u001c3dCJ$\u0017i\u00197tQ\r\u0001%qF\u0001#i\u0016\u001cH\u000f\u0015:pIV\u001cWmQ8ogVlWmV5uQB\u0013XMZ5yK\u0012\f5\r\\:)\u0007\u0005\u0013y#A\u0018uKN$\bK]8ek\u000e,7i\u001c8tk6,Gk\u001c9jG\u0006+Ho\\\"sK\u0006$X\rV8qS\u000e\u001c%/Z1uK\u0006\u001bG\u000eK\u0002C\u0005_\tqc]3u/&dGmY1sIJ+7o\\;sG\u0016\f5\r\\:\u0002/M,G\u000f\u0015:fM&DX\r\u001a*fg>,(oY3BG2\u001c\u0018aE:fiJ+\u0017\rZ!oI^\u0013\u0018\u000e^3BG2\u001cHc\u0001=\u0003v!9\u00111H#A\u0002\u0005}\u0012!E:fi\u0006\u001bGn]!oIB\u0013x\u000eZ;dKR\u0019\u0001Pa\u001f\t\u000f\u0005mb\t1\u0001\u0002@\u0005!2/\u001a;D_:\u001cX/\\3s\u000fJ|W\u000f]!dYN\fQ\u0007^3ti:{G)Z:de&\u0014W\r\u0015:pIV\u001cWm\u0014:D_:\u001cX/\\3XSRDw.\u001e;U_BL7\rR3tGJL'-Z!dY\"\u001a\u0001Ja\f\u00029Q,7\u000f\u001e(p!J|G-^2f/&$\b\u000eR3tGJL'-Z!dY\"\u001a\u0011Ja\f\u0002QQ,7\u000f\u001e(p\u0007>t7/^7f/&$\bn\\;u\t\u0016\u001c8M]5cK\u0006\u001bGNV5b\u0003N\u001c\u0018n\u001a8)\u000f)\u0013yCa#\u0003\u000e\u0006AQ\r\u001f9fGR,Gm\t\u0002\u0003\u0010B!\u0011\u0011\tBI\u0013\u0011\u0011\u0019*a\u0011\u0003\u001d-\u000bgm[1Fq\u000e,\u0007\u000f^5p]\u0006YC/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5pkR$Um]2sS\n,\u0017i\u00197WS\u0006\u001cVOY:de&\u0014W\rK\u0002L\u0005_\t\u0001E\\8D_:\u001cX/\\3XSRDw.\u001e;EKN\u001c'/\u001b2f\u0003\u000ed7+\u001a;va\u0006)C/Z:u\u001d>\u001cuN\\:v[\u0016<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0003\u000edg+[1BgNLwM\u001c\u0015\u0004\u001b\n=\u0012\u0001\u000b;fgRtunQ8ogVlWmV5uQ\u0012+7o\u0019:jE\u0016\f5\r\u001c,jCN+(m]2sS\n,\u0007f\u0001(\u00030\u0005ibn\\\"p]N,X.Z,ji\"$Um]2sS\n,\u0017i\u00197TKR,\b/\u0001\buKN$hj\\$s_V\u0004\u0018i\u00197)\u0007A\u0013y#A\u0006tK:$'+Z2pe\u0012\u001cHc\u0002=\u0003.\n\u001d'\u0011\u001a\u0005\b\u0005_\u000b\u0006\u0019\u0001BY\u0003!\u0001(o\u001c3vG\u0016\u0014\b\u0003\u0003BZ\u0005w\u0013yLa0\u000e\u0005\tU&\u0002\u0002BX\u0005oSAA!/\u0002H\u000591\r\\5f]R\u001c\u0018\u0002\u0002B_\u0005k\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b#\u00029\u0002H\n\u0005\u0007c\u00019\u0003D&\u0019!QY9\u0003\t\tKH/\u001a\u0005\u0006wF\u0003\ra\u001c\u0005\b\u0003w\t\u0006\u0019AA \u00039\u0019wN\\:v[\u0016\u0014VmY8sIN$R\u0002\u001fBh\u0005;\u0014yNa9\u0003f\n\u001d\bb\u0002Bi%\u0002\u0007!1[\u0001\tG>t7/^7feBA!Q\u001bBm\u0005\u007f\u0013y,\u0004\u0002\u0003X*!!\u0011\u001bB\\\u0013\u0011\u0011YNa6\u0003\u0011\r{gn];nKJDqa\u001f*\u0011\u0002\u0003\u0007q\u000e\u0003\u0005\u0003bJ\u0003\n\u00111\u0001p\u00039\u0019H/\u0019:uS:<wJ\u001a4tKRD\u0011\"a\fS!\u0003\u0005\r!!\u0006\t\u0011\u0005]\"\u000b%AA\u0002=D\u0011B!;S!\u0003\u0005\rAa;\u0002\u000fQLW.Z8viB\u0019\u0001O!<\n\u0007\t=\u0018O\u0001\u0003M_:<\u0017\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!Q\u001f\u0016\u0004_\n]8F\u0001B}!\u0011\u0011Yp!\u0002\u000e\u0005\tu(\u0002\u0002B\u0000\u0007\u0003\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r\r\u0011/\u0001\u0006b]:|G/\u0019;j_:LAaa\u0002\u0003~\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00021\r|gn];nKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0001\rd_:\u001cX/\\3SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIQ*\"aa\u0004+\t\u0005U!q_\u0001\u0019G>t7/^7f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012*\u0014\u0001G2p]N,X.\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u00111q\u0003\u0016\u0005\u0005W\u001490A\u0017d_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$\u0012\u0002_B\u000f\u0007?\u0019\tca\t\t\u000f\tE\u0007\f1\u0001\u0003T\"91\u0010\u0017I\u0001\u0002\u0004y\u0007\u0002\u0003Bq1B\u0005\t\u0019A8\t\u0013\u0005=\u0002\f%AA\u0002\u0005U\u0011aN2p]N,X.\u001a*fG>\u0014Hm]%h]>\u0014Xm\u00148f\u0003V$\bn\u001c:ju\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\u0012\"WMZ1vYR$#'A\u001cd_:\u001cX/\\3SK\u000e|'\u000fZ:JO:|'/Z(oK\u0006+H\u000f[8sSj\fG/[8o\u000bb\u001cW\r\u001d;j_:$C-\u001a4bk2$HeM\u00018G>t7/^7f%\u0016\u001cwN\u001d3t\u0013\u001etwN]3P]\u0016\fU\u000f\u001e5pe&T\u0018\r^5p]\u0016C8-\u001a9uS>tG\u0005Z3gCVdG\u000f\n\u001b")
public abstract class EndToEndAuthorizationTest
extends IntegrationTestHarness
implements SaslSetup {
    private Some<File> trustStoreFile;
    private final int brokerCount;
    private final int numRecords;
    private final String groupPrefix;
    private final String group;
    private final String topicPrefix;
    private final String topic;
    private final String wildcard;
    private final int part;
    private final TopicPartition tp;
    private final ResourcePattern topicResource;
    private final ResourcePattern groupResource;
    private final ResourcePattern clusterResource;
    private final ResourcePattern prefixedTopicResource;
    private final ResourcePattern prefixedGroupResource;
    private final ResourcePattern wildcardTopicResource;
    private final ResourcePattern wildcardGroupResource;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;
    private volatile boolean bitmap$0;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        AclCommand$.MODULE$.main(this.clusterActionArgs());
        AclCommand$.MODULE$.main(this.topicBrokerReadAclArgs());
    }

    public int numRecords() {
        return this.numRecords;
    }

    public String groupPrefix() {
        return this.groupPrefix;
    }

    public String group() {
        return this.group;
    }

    public String topicPrefix() {
        return this.topicPrefix;
    }

    public String topic() {
        return this.topic;
    }

    public String wildcard() {
        return this.wildcard;
    }

    public int part() {
        return this.part;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    public abstract String clientPrincipal();

    public abstract String kafkaPrincipal();

    private Some<File> trustStoreFile$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.trustStoreFile = new Some((Object)File.createTempFile("truststore", ".jks"));
                this.bitmap$0 = true;
            }
        }
        return this.trustStoreFile;
    }

    public Some<File> trustStoreFile() {
        if (!this.bitmap$0) {
            return this.trustStoreFile$lzycompute();
        }
        return this.trustStoreFile;
    }

    public Class<?> authorizerClass() {
        return AclAuthorizer.class;
    }

    public ResourcePattern topicResource() {
        return this.topicResource;
    }

    public ResourcePattern groupResource() {
        return this.groupResource;
    }

    public ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    public ResourcePattern prefixedTopicResource() {
        return this.prefixedTopicResource;
    }

    public ResourcePattern prefixedGroupResource() {
        return this.prefixedGroupResource;
    }

    public ResourcePattern wildcardTopicResource() {
        return this.wildcardTopicResource;
    }

    public ResourcePattern wildcardGroupResource() {
        return this.wildcardGroupResource;
    }

    public String kafkaPrincipalStr() {
        return new StringBuilder(1).append(this.kafkaPrincipalType()).append(":").append(this.kafkaPrincipal()).toString();
    }

    public String clientPrincipalStr() {
        return new StringBuilder(1).append(this.kafkaPrincipalType()).append(":").append(this.clientPrincipal()).toString();
    }

    public String[] clusterActionArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", "--cluster", "--operation=ClusterAction", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipalStr()).toString()};
    }

    public String[] topicBrokerReadAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.kafkaPrincipalStr()).toString()};
    }

    public String[] produceAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] describeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] deleteDescribeAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Describe", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] deleteWriteAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--remove", "--force", new StringBuilder(8).append("--topic=").append(this.topic()).toString(), "--operation=Write", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] consumeAclArgs(String topic) {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(topic).toString(), new StringBuilder(8).append("--group=").append(this.group()).toString(), "--consumer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] groupAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--group=").append(this.group()).toString(), "--operation=Read", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] produceConsumeWildcardAclArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.wildcard()).toString(), new StringBuilder(8).append("--group=").append(this.wildcard()).toString(), "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    public String[] produceConsumePrefixedAclsArgs() {
        return new String[]{"--authorizer-properties", new StringBuilder(18).append("zookeeper.connect=").append(this.zkConnect()).toString(), "--add", new StringBuilder(8).append("--topic=").append(this.topicPrefix()).toString(), new StringBuilder(8).append("--group=").append(this.groupPrefix()).toString(), "--resource-pattern-type=prefixed", "--consumer", "--producer", new StringBuilder(18).append("--allow-principal=").append(this.clientPrincipalStr()).toString()};
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> ClusterActionAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CLUSTER_ACTION, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicBrokerReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.kafkaPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> GroupReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicReadAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicWriteAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicDescribeAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<AccessControlEntry> TopicCreateAcl() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(this.clientPrincipalStr(), AclEntry$.MODULE$.WildcardHost(), AclOperation.CREATE, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setUp$1(this, s);
            return BoxedUnit.UNIT;
        });
        this.createTopic(this.topic(), 1, 3, this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProduceConsumeViaAssign() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    public void confirmReauthenticationMetrics() {
        double expiredConnectionsKilledCountTotal = BoxesRunTime.unboxToDouble((Object)this.getGauge("ExpiredConnectionsKilledCount").value());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$1(expiredConnectionsKilledCountTotal, s);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)"Should have been zero expired connections killed total", (double)0.0, (double)expiredConnectionsKilledCountTotal, (double)0.0);
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$confirmReauthenticationMetrics$2(s);
            return BoxedUnit.UNIT;
        });
    }

    private Gauge<Object> getGauge(String metricName) {
        Option option = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable)k -> BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.$anonfun$getGauge$1(metricName, k))).headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail(new StringBuilder(22).append("Unable to find metric ").append(metricName).toString(), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }
        Object var2_2 = null;
        return (Gauge)((Tuple2)getOrElse_this.get())._2();
    }

    @Test
    public void testProduceConsumeViaSubscribe() {
        this.setAclsAndProduce(this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithWildcardAcls() {
        this.setWildcardResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeWithPrefixedAcls() {
        this.setPrefixedResourceAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testProduceConsumeTopicAutoCreateTopicCreateAcl() {
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        this.setAclsAndProduce(tp2);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$2 = this.numRecords();
        String x$3 = tp2.topic();
        int n = 0;
        int n2 = this.part();
        long l = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, n, x$3, n2, l);
        this.confirmReauthenticationMetrics();
    }

    private void setWildcardResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumeWildcardAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setWildcardResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setPrefixedResourceAcls() {
        AclCommand$.MODULE$.main(this.produceConsumePrefixedAclsArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setPrefixedResourceAcls$1(this, s);
            return BoxedUnit.UNIT;
        });
    }

    private void setReadAndWriteAcls(TopicPartition tp) {
        AclCommand$.MODULE$.main(this.produceAclArgs(tp.topic()));
        AclCommand$.MODULE$.main(this.consumeAclArgs(tp.topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$setReadAndWriteAcls$1(this, tp, s);
            return BoxedUnit.UNIT;
        });
    }

    public void setAclsAndProduce(TopicPartition tp) {
        this.setReadAndWriteAcls(tp);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), tp);
    }

    private void setConsumerGroupAcls() {
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl() {
        void apply_elems;
        BooleanRef booleanRef;
        void apply_elems2;
        this.setConsumerGroupAcls();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, this.numRecords(), this.tp()), ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 335));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            int x$2 = this.numRecords();
            String x$3 = this.tp().topic();
            int n = 0;
            int n2 = this.part();
            long l = 10000L;
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$2, n, x$3, n2, l);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
        Admin adminClient = this.createAdminClient(this.createAdminClient$default$1());
        ExecutionException e1 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            return (Map)adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).asJava()).all().get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e1.getCause()).toString(), (boolean)(e1.getCause() instanceof TopicAuthorizationException));
        String topic2 = "topic2";
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        this.setReadAndWriteAcls(tp2);
        this.sendRecords(producer, this.numRecords(), tp2);
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)).asJava());
        int x$8 = this.numRecords();
        int n = 0;
        int n2 = this.part();
        long l = 10000L;
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, x$8, n, topic2, n2, l);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map describeResults = adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults.get(topic2)).get()).partitions().size());
        ExecutionException e2 = (ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            return (Map)adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).asJava()).all().get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e2.getCause()).toString(), (boolean)(e2.getCause() instanceof TopicAuthorizationException));
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$))).asJava());
        this.sendRecords(producer, this.numRecords(), tp2);
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef topic2RecordConsumed = booleanRef2;
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long l = 15000L;
            long pollRecordsUntilTrue_waitUntilTrue_pause = 0L;
            long pollRecordsUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                ConsumerRecords consumerRecords = consumer.poll(Duration.ofMillis(100L));
                Assert.assertEquals((String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(consumerRecords).toString(), Collections.singleton(tp2), (Object)consumerRecords.partitions());
                topic2RecordConsumed$1.elem = true;
                if (System.currentTimeMillis() > pollRecordsUntilTrue_waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail("Consumer didn't fail with authorization exception within timeout", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                Thread.sleep(Math.min(l, pollRecordsUntilTrue_waitUntilTrue_pause));
            }
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
        this.setReadAndWriteAcls(this.tp());
        if (!topic2RecordConsumed.elem) {
            this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 1, topic2);
        }
        this.sendRecords(producer, this.numRecords(), this.tp());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, this.numRecords(), 0, this.topic());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic(), topic2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Map describeResults2 = adminClient.describeTopics((Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)).asJava()).values();
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(this.topic())).get()).partitions().size());
        Assert.assertEquals((long)1L, (long)((TopicDescription)((KafkaFuture)describeResults2.get(topic2)).get()).partitions().size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoProduceWithDescribeAcl() {
        AclCommand$.MODULE$.main(this.describeAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.TopicDescribeAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.topicResource());
            return BoxedUnit.UNIT;
        });
        try {
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            this.sendRecords(producer, this.numRecords(), this.tp());
            throw Assertions$.MODULE$.fail("exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 391));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    @Test(expected=KafkaException.class)
    public void testNoConsumeWithoutDescribeAclViaAssign() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
        this.confirmReauthenticationMetrics();
    }

    @Test
    public void testNoConsumeWithoutDescribeAclViaSubscribe() {
        this.noConsumeWithoutDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String string;
            int n = 1;
            int n2 = 0;
            String string2 = string = this.topic();
            string = null;
            String x$5 = string2;
            int n3 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, n, n2, x$5, n3, 3000L);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.setReadAndWriteAcls(this.tp());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)new .colon.colon((Object)"topic2", (List)Nil$.MODULE$))).asJava());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            String string;
            int n = 1;
            int n2 = 0;
            String string2 = string = this.topic();
            string = null;
            String x$11 = string2;
            int n3 = this.part();
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, n, n2, x$11, n3, 3000L);
        }, ClassTag$.MODULE$.apply(TopicAuthorizationException.class), new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 424));
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.consumeRecordsIgnoreOneAuthorizationException((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic());
    }

    private void noConsumeWithoutDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithoutDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        AclCommand$.MODULE$.main(this.deleteDescribeAclArgs());
        AclCommand$.MODULE$.main(this.deleteWriteAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            TestUtils$.MODULE$.waitAndVerifyAcls(this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), this.groupResource());
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoConsumeWithDescribeAclViaAssign() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 457));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testNoConsumeWithDescribeAclViaSubscribe() {
        this.noConsumeWithDescribeAclSetup();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
        }
        catch (TopicAuthorizationException e) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).asJava(), (Object)e.unauthorizedTopics());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    private void noConsumeWithDescribeAclSetup() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        AclCommand$.MODULE$.main(this.groupAclArgs());
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$noConsumeWithDescribeAclSetup$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
    }

    @Test
    public void testNoGroupAcl() {
        AclCommand$.MODULE$.main(this.produceAclArgs(this.tp().topic()));
        this.servers().foreach((Function1 & Serializable)s -> {
            EndToEndAuthorizationTest.$anonfun$testNoGroupAcl$1(this, s);
            return BoxedUnit.UNIT;
        });
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, this.numRecords(), this.tp());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        try {
            this.consumeRecords((Consumer<byte[], byte[]>)consumer, 1, 0, this.topic(), this.part(), 10000L);
            throw Assertions$.MODULE$.fail("Topic authorization exception expected", new Position("EndToEndAuthorizationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 509));
        }
        catch (GroupAuthorizationException e) {
            Assert.assertEquals((Object)this.group(), (Object)e.groupId());
            this.confirmReauthenticationMetrics();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition tp) {
        Future future;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3 = future2 = EndToEndAuthorizationTest.$anonfun$sendRecords$1(this, tp, producer, BoxesRunTime.unboxToInt((Object)object));
            future2 = null;
            future = future3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        future = null;
        try {
            ((IndexedSeq)map_strictOptimizedMap_b.result()).foreach((Function1 & Serializable)x$1 -> (RecordMetadata)x$1.get());
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public final void consumeRecords(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic, int part, long timeout) {
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.consumeRecords(consumer, numRecords, timeout);
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, numRecords, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                EndToEndAuthorizationTest.$anonfun$consumeRecords$1(records, startingOffset, topic, part, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public final int consumeRecords$default$2() {
        return 1;
    }

    public final int consumeRecords$default$3() {
        return 0;
    }

    public final String consumeRecords$default$4() {
        return this.topic();
    }

    public final int consumeRecords$default$5() {
        return this.part();
    }

    public final long consumeRecords$default$6() {
        return 10000L;
    }

    private void consumeRecordsIgnoreOneAuthorizationException(Consumer<byte[], byte[]> consumer, int numRecords, int startingOffset, String topic) {
        try {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
        catch (TopicAuthorizationException topicAuthorizationException) {
            this.consumeRecords(consumer, numRecords, startingOffset, topic, this.part(), 10000L);
            return;
        }
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$2() {
        return 1;
    }

    private int consumeRecordsIgnoreOneAuthorizationException$default$3() {
        return 0;
    }

    private String consumeRecordsIgnoreOneAuthorizationException$default$4() {
        return this.topic();
    }

    public static final /* synthetic */ void $anonfun$setUp$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        TestUtils$.MODULE$.waitAndVerifyAcls($this.ClusterActionAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.clusterResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.TopicBrokerReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL));
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$1(double expiredConnectionsKilledCountTotal$1, KafkaServer s) {
        long numExpiredKilled = TestUtils$.MODULE$.totalMetricValue(s, "expired-connections-killed-count");
        Assert.assertTrue((String)new StringBuilder(58).append("Should have been zero expired connections killed: ").append(numExpiredKilled).append("(total=").append(expiredConnectionsKilledCountTotal$1).append(")").toString(), (numExpiredKilled == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$confirmReauthenticationMetrics$2(KafkaServer s) {
        Assert.assertTrue((String)"failed re-authentications not 0", (TestUtils$.MODULE$.totalMetricValue(s, "failed-reauthentication-total") == 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(String metricName$1, MetricName k) {
        String string = k.getName();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setWildcardResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        void $plus$plus_that4;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that4);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that3);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        SetOps setOps3 = setOps2.concat((IterableOnce)$plus$plus_that2);
        set4 = null;
        scala.collection.immutable.Set<AccessControlEntry> set5 = $this.TopicBrokerReadAcl();
        if (setOps3 == null) {
            throw null;
        }
        set5 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps3.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.wildcardGroupResource());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setPrefixedResourceAcls$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that3);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that2);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        set4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps2.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedTopicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.prefixedGroupResource());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$setReadAndWriteAcls$1(EndToEndAuthorizationTest $this, TopicPartition tp$1, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        void $plus$plus_that3;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicReadAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicWriteAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that3);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicDescribeAcl();
        if (setOps == null) {
            throw null;
        }
        SetOps setOps2 = setOps.concat((IterableOnce)$plus$plus_that2);
        set3 = null;
        scala.collection.immutable.Set<AccessControlEntry> set4 = $this.TopicCreateAcl();
        if (setOps2 == null) {
            throw null;
        }
        set4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps2.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), new ResourcePattern(ResourceType.TOPIC, tp$1.topic(), PatternType.LITERAL));
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    private static final boolean verifyNoRecords$1(ConsumerRecords records, TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1) {
        Assert.assertEquals((String)new StringBuilder(45).append("Consumed records with unexpected partitions: ").append(records).toString(), Collections.singleton(tp2$1), (Object)records.partitions());
        topic2RecordConsumed$1.elem = true;
        return false;
    }

    public static final /* synthetic */ String $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$7() {
        return "Consumer didn't fail with authorization exception within timeout";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$noConsumeWithoutDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$noConsumeWithDescribeAclSetup$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
        TestUtils$.MODULE$.waitAndVerifyAcls($this.GroupReadAcl(), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.groupResource());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testNoGroupAcl$1(EndToEndAuthorizationTest $this, KafkaServer s) {
        void $plus$plus_that;
        void $plus$plus_that2;
        scala.collection.immutable.Set<AccessControlEntry> set = $this.TopicWriteAcl();
        scala.collection.immutable.Set<AccessControlEntry> set2 = $this.TopicDescribeAcl();
        if (set == null) {
            throw null;
        }
        SetOps setOps = set.concat((IterableOnce)$plus$plus_that2);
        set2 = null;
        scala.collection.immutable.Set<AccessControlEntry> set3 = $this.TopicCreateAcl();
        if (setOps == null) {
            throw null;
        }
        set3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((scala.collection.immutable.Set<AccessControlEntry>)((scala.collection.immutable.Set)setOps.concat((IterableOnce)$plus$plus_that)), (Authorizer)s.dataPlaneRequestProcessor().authorizer().get(), $this.topicResource());
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, int i) {
        ProducerRecord record = new ProducerRecord(tp$2.topic(), Integer.valueOf(tp$2.partition()), (Object)String.valueOf((Object)i).getBytes(), (Object)String.valueOf((Object)i).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$2.send(record);
    }

    public static final /* synthetic */ void $anonfun$consumeRecords$1(Seq records$1, int startingOffset$1, String topic$1, int part$1, int i) {
        ConsumerRecord record = (ConsumerRecord)records$1.apply(i);
        int offset = startingOffset$1 + i;
        Assert.assertEquals((Object)topic$1, (Object)record.topic());
        Assert.assertEquals((long)part$1, (long)record.partition());
        Assert.assertEquals((long)offset, (long)record.offset());
    }

    public EndToEndAuthorizationTest() {
        SaslSetup.$init$(this);
        this.brokerCount = 3;
        this.numRecords = 1;
        this.groupPrefix = "gr";
        this.group = new StringBuilder(3).append(this.groupPrefix()).append("oup").toString();
        this.topicPrefix = "e2e";
        this.topic = new StringBuilder(5).append(this.topicPrefix()).append("topic").toString();
        this.wildcard = "*";
        this.part = 0;
        this.tp = new TopicPartition(this.topic(), this.part());
        this.topicResource = new ResourcePattern(ResourceType.TOPIC, this.topic(), PatternType.LITERAL);
        this.groupResource = new ResourcePattern(ResourceType.GROUP, this.group(), PatternType.LITERAL);
        this.clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        this.prefixedTopicResource = new ResourcePattern(ResourceType.TOPIC, this.topicPrefix(), PatternType.PREFIXED);
        this.prefixedGroupResource = new ResourcePattern(ResourceType.GROUP, this.groupPrefix(), PatternType.PREFIXED);
        this.wildcardTopicResource = new ResourcePattern(ResourceType.TOPIC, this.wildcard(), PatternType.LITERAL);
        this.wildcardGroupResource = new ResourcePattern(ResourceType.GROUP, this.wildcard(), PatternType.LITERAL);
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ZkEnableSecureAclsProp(), "true");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.AuthorizerClassNameProp(), this.authorizerClass().getName());
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "3");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ConnectionsMaxReauthMsProp(), "1500");
        this.consumerConfig().setProperty("group.id", "group");
        this.consumerConfig().setProperty("metadata.max.age.ms", "1500");
        Statics.releaseFence();
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(EndToEndAuthorizationTest $this, TopicPartition tp$2, KafkaProducer producer$2, Object i) {
        return EndToEndAuthorizationTest.$anonfun$sendRecords$1($this, tp$2, producer$2, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testNoDescribeProduceOrConsumeWithoutTopicDescribeAcl$6$adapted(TopicPartition tp2$1, BooleanRef topic2RecordConsumed$1, ConsumerRecords records) {
        return BoxesRunTime.boxToBoolean((boolean)EndToEndAuthorizationTest.verifyNoRecords$1(records, tp2$1, topic2RecordConsumed$1));
    }
}

