/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.admin.ConsumerGroupCommand;
import kafka.api.Both$;
import kafka.api.IntegrationTestHarness;
import kafka.api.SaslSetup;
import kafka.api.SaslSetupMode;
import kafka.security.minikdc.MiniKdc;
import kafka.server.KafkaConfig$;
import kafka.utils.JaasTestUtils;
import kafka.utils.JaasTestUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Mh\u0001B\u0016-\u0001EBQ!\u000f\u0001\u0005\u0002iBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u0019\u0019\u0006\u0001)A\u0005\u0013\"9A\u000b\u0001b\u0001\n#*\u0006BB3\u0001A\u0003%a\u000bC\u0004g\u0001\t\u0007I\u0011K4\t\rI\u0004\u0001\u0015!\u0003i\u0011\u001d\u0019\bA1A\u0005R\u001dDa\u0001\u001e\u0001!\u0002\u0013A\u0007bB;\u0001\u0005\u0004%\tA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0001m\"1A\u0010\u0001Q\u0001\n]Dq! \u0001C\u0002\u0013\u0005a\u000f\u0003\u0004\u007f\u0001\u0001\u0006Ia\u001e\u0005\b\u007f\u0002\u0011\r\u0011\"\u0001>\u0011\u001d\t\t\u0001\u0001Q\u0001\nyB\u0001\"a\u0001\u0001\u0005\u0004%\tA\u001e\u0005\b\u0003\u000b\u0001\u0001\u0015!\u0003x\u0011%\t9\u0001\u0001b\u0001\n\u0003\tI\u0001\u0003\u0005\u0002\u0014\u0001\u0001\u000b\u0011BA\u0006\u0011\u001d\t)\u0002\u0001C!\u0003/Aq!a\b\u0001\t\u0003\n9\u0002C\u0004\u00020\u0001!\t%a\u0006\t\u000f\u0005e\u0002\u0001\"\u0001\u0002\u0018!9\u00111\t\u0001\u0005\u0002\u0005]\u0001bBA$\u0001\u0011\u0005\u0011q\u0003\u0005\b\u0003\u0017\u0002A\u0011AA\f\u0011\u001d\ty\u0005\u0001C\u0001\u0003/Aq!a\u0015\u0001\t\u0013\t)\u0006C\u0004\u0002v\u0001!\t!a\u0006\t\u000f\u0005e\u0004\u0001\"\u0001\u0002\u0018!9\u0011Q\u0010\u0001\u0005\u0002\u0005]\u0001bBAA\u0001\u0011%\u00111\u0011\u0005\b\u0003K\u0003A\u0011BA\f\u0011\u001d\t9\u000b\u0001C\u0005\u0003SC\u0011\"a1\u0001#\u0003%I!!2\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\"9\u0011\u0011\u001e\u0001\u0005\n\u0005-\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0002&'\u0006\u001cHn\u00117jK:$8oV5uQ&sg/\u00197jI\u000e\u0013X\rZ3oi&\fGn\u001d+fgRT!!\f\u0018\u0002\u0007\u0005\u0004\u0018NC\u00010\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u001a7!\t\u0019D'D\u0001-\u0013\t)DF\u0001\fJ]R,wM]1uS>tG+Z:u\u0011\u0006\u0014h.Z:t!\t\u0019t'\u0003\u00029Y\tI1+Y:m'\u0016$X\u000f]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0002\"a\r\u0001\u00021-\fgm[1DY&,g\u000e^*bg2lUm\u00195b]&\u001cX.F\u0001?!\tyD)D\u0001A\u0015\t\t%)\u0001\u0003mC:<'\"A\"\u0002\t)\fg/Y\u0005\u0003\u000b\u0002\u0013aa\u0015;sS:<\u0017!G6bM.\f7\t\\5f]R\u001c\u0016m\u001d7NK\u000eD\u0017M\\5t[\u0002\n\u0011d[1gW\u0006\u001cVM\u001d<feN\u000b7\u000f\\'fG\"\fg.[:ngV\t\u0011\nE\u0002K#zj\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00059{\u0015AC2pY2,7\r^5p]*\t\u0001+A\u0003tG\u0006d\u0017-\u0003\u0002S\u0017\n!A*[:u\u0003iY\u0017MZ6b'\u0016\u0014h/\u001a:TCNdW*Z2iC:L7/\\:!\u0003A\u0019XmY;sSRL\bK]8u_\u000e|G.F\u0001W!\t96-D\u0001Y\u0015\tI&,\u0001\u0003bkRD'BA.]\u0003!\u0019XmY;sSRL(BA/_\u0003\u0019\u0019w.\\7p]*\u0011qf\u0018\u0006\u0003A\u0006\fa!\u00199bG\",'\"\u00012\u0002\u0007=\u0014x-\u0003\u0002e1\n\u00012+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u0001\u0012g\u0016\u001cWO]5usB\u0013x\u000e^8d_2\u0004\u0013\u0001F:feZ,'oU1tYB\u0013x\u000e]3si&,7/F\u0001i!\rI'\u000e\\\u0007\u0002\u001f&\u00111n\u0014\u0002\u0005'>lW\r\u0005\u0002na6\taN\u0003\u0002p\u0005\u0006!Q\u000f^5m\u0013\t\thN\u0001\u0006Qe>\u0004XM\u001d;jKN\fQc]3sm\u0016\u00148+Y:m!J|\u0007/\u001a:uS\u0016\u001c\b%\u0001\u000bdY&,g\u000e^*bg2\u0004&o\u001c9feRLWm]\u0001\u0016G2LWM\u001c;TCNd\u0007K]8qKJ$\u0018.Z:!\u00035\u0019wN\\:v[\u0016\u00148i\\;oiV\tq\u000f\u0005\u0002jq&\u0011\u0011p\u0014\u0002\u0004\u0013:$\u0018AD2p]N,X.\u001a:D_VtG\u000fI\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\u0002\u001dA\u0014x\u000eZ;dKJ\u001cu.\u001e8uA\u0005Y!M]8lKJ\u001cu.\u001e8u\u00031\u0011'o\\6fe\u000e{WO\u001c;!\u0003\u0015!x\u000e]5d\u0003\u0019!x\u000e]5dA\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u0002uaV\u0011\u00111\u0002\t\u0005\u0003\u001b\ty!D\u0001]\u0013\r\t\t\u0002\u0018\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003\r!\b\u000fI\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\t\tI\u0002E\u0002j\u00037I1!!\bP\u0005\u0011)f.\u001b;\u0002\u000bM,G/\u00169)\u0007e\t\u0019\u0003\u0005\u0003\u0002&\u0005-RBAA\u0014\u0015\r\tI#Y\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003[\t9C\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001a!$a\r\u0011\t\u0005\u0015\u0012QG\u0005\u0005\u0003o\t9CA\u0003BMR,'/A\u0013uKN$\bK]8ek\u000e,'oV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001a1$!\u0010\u0011\t\u0005\u0015\u0012qH\u0005\u0005\u0003\u0003\n9C\u0001\u0003UKN$\u0018A\r;fgR$&/\u00198tC\u000e$\u0018n\u001c8bYB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5BkRDWM\u001c;jG\u0006$\u0018n\u001c8GC&dWO]3)\u0007q\ti$A\u0013uKN$8i\u001c8tk6,'oV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001aQ$!\u0010\u0002kQ,7\u000f^'b]V\fG.Q:tS\u001etW.\u001a8u\u0007>t7/^7fe^KG\u000f[!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u0004=\u0005u\u0012a\u0013;fgRl\u0015M\\;bY\u0006\u001b8/[4o[\u0016tGoQ8ogVlWM],ji\"\fU\u000f^8D_6l\u0017\u000e\u001e#jg\u0006\u0014G.\u001a3XSRD\u0017)\u001e;iK:$\u0018nY1uS>tg)Y5mkJ,\u0007fA\u0010\u0002>\u00059c/\u001a:jMf\u001cuN\\:v[\u0016\u0014x+\u001b;i\u0003V$\b.\u001a8uS\u000e\fG/[8o\r\u0006LG.\u001e:f)\u0011\tI\"a\u0016\t\u000f\u0005e\u0003\u00051\u0001\u0002\\\u0005A1m\u001c8tk6,'\u000f\u0005\u0005\u0002^\u0005\u0015\u0014\u0011NA5\u001b\t\tyF\u0003\u0003\u0002Z\u0005\u0005$bAA2=\u000691\r\\5f]R\u001c\u0018\u0002BA4\u0003?\u0012QbS1gW\u0006\u001cuN\\:v[\u0016\u0014\b#B5\u0002l\u0005=\u0014bAA7\u001f\n)\u0011I\u001d:bsB\u0019\u0011.!\u001d\n\u0007\u0005MtJ\u0001\u0003CsR,\u0017!\f;fgR\\\u0015MZ6b\u0003\u0012l\u0017N\\\"mS\u0016tGoV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001a\u0011%!\u0010\u0002cQ,7\u000f^\"p]N,X.\u001a:He>,\boU3sm&\u001cWmV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]\u001a\u000b\u0017\u000e\\;sK\"\u001a!%!\u0010\u0002cQ,7\u000f^\"p]N,X.\u001a:He>,\boU3sm&\u001cWmV5uQ\u0006+H\u000f[3oi&\u001c\u0017\r^5p]N+8mY3tg\"\u001a1%!\u0010\u00027A\u0014X\r]1sK\u000e{gn];nKJ<%o\\;q'\u0016\u0014h/[2f+\t\t)\t\u0005\u0003\u0002\b\u0006}e\u0002BAE\u00033sA!a#\u0002\u0016:!\u0011QRAJ\u001b\t\tyIC\u0002\u0002\u0012B\na\u0001\u0010:p_Rt\u0014\"A\u0018\n\u0007\u0005]e&A\u0003bI6Lg.\u0003\u0003\u0002\u001c\u0006u\u0015\u0001F\"p]N,X.\u001a:He>,\boQ8n[\u0006tGMC\u0002\u0002\u0018:JA!!)\u0002$\n!2i\u001c8tk6,'o\u0012:pkB\u001cVM\u001d<jG\u0016TA!a'\u0002\u001e\u000612M]3bi\u0016\u001cE.[3oi\u000e\u0013X\rZ3oi&\fG.A\u0007tK:$wJ\\3SK\u000e|'\u000f\u001a\u000b\u0007\u00033\tY+!/\t\u000f\u00055f\u00051\u0001\u00020\u0006A\u0001O]8ek\u000e,'\u000f\u0005\u0005\u00022\u0006U\u0016\u0011NA5\u001b\t\t\u0019L\u0003\u0003\u0002.\u0006\u0005\u0014\u0002BA\\\u0003g\u0013QbS1gW\u0006\u0004&o\u001c3vG\u0016\u0014\b\"CA^MA\u0005\t\u0019AA_\u0003%i\u0017\r_,bSRl5\u000fE\u0002j\u0003\u007fK1!!1P\u0005\u0011auN\\4\u0002/M,g\u000eZ(oKJ+7m\u001c:eI\u0011,g-Y;mi\u0012\u0012TCAAdU\u0011\ti,!3,\u0005\u0005-\u0007\u0003BAg\u0003/l!!a4\u000b\t\u0005E\u00171[\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!6P\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\fyMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQD^3sS\u001aL\u0018)\u001e;iK:$\u0018nY1uS>tW\t_2faRLwN\u001c\u000b\u0005\u00033\ty\u000e\u0003\u0005\u0002b\"\"\t\u0019AAr\u0003\u0019\t7\r^5p]B)\u0011.!:\u0002\u001a%\u0019\u0011q](\u0003\u0011q\u0012\u0017P\\1nKz\nqB^3sS\u001aLx+\u001b;i%\u0016$(/\u001f\u000b\u0005\u00033\ti\u000f\u0003\u0005\u0002b&\"\t\u0019AAr\u0003m\u0019'/Z1uKR\u0013\u0018M\\:bGRLwN\\1m!J|G-^2feR\u0011\u0011q\u0016")
public class SaslClientsWithInvalidCredentialsTest
extends IntegrationTestHarness
implements SaslSetup {
    private final String kafkaClientSaslMechanism;
    private final List<String> kafkaServerSaslMechanisms;
    private final SecurityProtocol securityProtocol;
    private final Some<Properties> serverSaslProperties;
    private final Some<Properties> clientSaslProperties;
    private final int consumerCount;
    private final int producerCount;
    private final int brokerCount;
    private final String topic;
    private final int numPartitions;
    private final TopicPartition tp;
    private File kafka$api$SaslSetup$$workDir;
    private Properties kafka$api$SaslSetup$$kdcConf;
    private MiniKdc kafka$api$SaslSetup$$kdc;
    private Option<File> kafka$api$SaslSetup$$serverKeytabFile;
    private Option<File> kafka$api$SaslSetup$$clientKeytabFile;

    @Override
    public void startSasl(Seq<JaasTestUtils.JaasSection> jaasSections) {
        SaslSetup.startSasl$(this, jaasSections);
    }

    @Override
    public void initializeKerberos() {
        SaslSetup.initializeKerberos$(this);
    }

    @Override
    public Tuple2<File, File> maybeCreateEmptyKeytabFiles() {
        return SaslSetup.maybeCreateEmptyKeytabFiles$(this);
    }

    @Override
    public Seq<JaasTestUtils.JaasSection> jaasSections(Seq<String> kafkaServerSaslMechanisms, Option<String> kafkaClientSaslMechanism, SaslSetupMode mode, String kafkaServerEntryName) {
        return SaslSetup.jaasSections$(this, kafkaServerSaslMechanisms, kafkaClientSaslMechanism, mode, kafkaServerEntryName);
    }

    @Override
    public SaslSetupMode jaasSections$default$3() {
        return SaslSetup.jaasSections$default$3$(this);
    }

    @Override
    public String jaasSections$default$4() {
        return SaslSetup.jaasSections$default$4$(this);
    }

    @Override
    public void closeSasl() {
        SaslSetup.closeSasl$(this);
    }

    @Override
    public Properties kafkaServerSaslProperties(Seq<String> serverSaslMechanisms, String interBrokerSaslMechanism) {
        return SaslSetup.kafkaServerSaslProperties$(this, serverSaslMechanisms, interBrokerSaslMechanism);
    }

    @Override
    public Properties kafkaClientSaslProperties(String clientSaslMechanism, boolean dynamicJaasConfig) {
        return SaslSetup.kafkaClientSaslProperties$(this, clientSaslMechanism, dynamicJaasConfig);
    }

    @Override
    public boolean kafkaClientSaslProperties$default$2() {
        return SaslSetup.kafkaClientSaslProperties$default$2$(this);
    }

    @Override
    public String jaasClientLoginModule(String clientSaslMechanism, Option<String> serviceName) {
        return SaslSetup.jaasClientLoginModule$(this, clientSaslMechanism, serviceName);
    }

    @Override
    public Option<String> jaasClientLoginModule$default$2() {
        return SaslSetup.jaasClientLoginModule$default$2$(this);
    }

    @Override
    public void createScramCredentials(String zkConnect, String userName, String password) {
        SaslSetup.createScramCredentials$(this, zkConnect, userName, password);
    }

    @Override
    public File kafka$api$SaslSetup$$workDir() {
        return this.kafka$api$SaslSetup$$workDir;
    }

    @Override
    public Properties kafka$api$SaslSetup$$kdcConf() {
        return this.kafka$api$SaslSetup$$kdcConf;
    }

    @Override
    public MiniKdc kafka$api$SaslSetup$$kdc() {
        return this.kafka$api$SaslSetup$$kdc;
    }

    @Override
    public void kafka$api$SaslSetup$$kdc_$eq(MiniKdc x$1) {
        this.kafka$api$SaslSetup$$kdc = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$serverKeytabFile() {
        return this.kafka$api$SaslSetup$$serverKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$serverKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$serverKeytabFile = x$1;
    }

    @Override
    public Option<File> kafka$api$SaslSetup$$clientKeytabFile() {
        return this.kafka$api$SaslSetup$$clientKeytabFile;
    }

    @Override
    public void kafka$api$SaslSetup$$clientKeytabFile_$eq(Option<File> x$1) {
        this.kafka$api$SaslSetup$$clientKeytabFile = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$workDir_$eq(File x$1) {
        this.kafka$api$SaslSetup$$workDir = x$1;
    }

    @Override
    public final void kafka$api$SaslSetup$_setter_$kafka$api$SaslSetup$$kdcConf_$eq(Properties x$1) {
        this.kafka$api$SaslSetup$$kdcConf = x$1;
    }

    private String kafkaClientSaslMechanism() {
        return this.kafkaClientSaslMechanism;
    }

    private List<String> kafkaServerSaslMechanisms() {
        return this.kafkaServerSaslMechanisms;
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return this.securityProtocol;
    }

    public Some<Properties> serverSaslProperties() {
        return this.serverSaslProperties;
    }

    public Some<Properties> clientSaslProperties() {
        return this.clientSaslProperties;
    }

    public int consumerCount() {
        return this.consumerCount;
    }

    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int brokerCount() {
        return this.brokerCount;
    }

    public String topic() {
        return this.topic;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public TopicPartition tp() {
        return this.tp;
    }

    @Override
    public void configureSecurityBeforeServersStart() {
        super.configureSecurityBeforeServersStart();
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramAdmin(), JaasTestUtils$.MODULE$.KafkaScramAdminPassword());
    }

    @Override
    @Before
    public void setUp() {
        this.startSasl(this.jaasSections((Seq<String>)this.kafkaServerSaslMechanisms(), (Option<String>)new Some((Object)this.kafkaClientSaslMechanism()), Both$.MODULE$, JaasTestUtils$.MODULE$.KafkaServerContextName()));
        super.setUp();
        this.createTopic(this.topic(), this.numPartitions(), this.brokerCount(), this.createTopic$default$4());
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        this.closeSasl();
    }

    @Test
    public void testProducerWithAuthenticationFailure() {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 10000L);
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        try {
            producer.partitionsFor(this.topic());
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    @Test
    public void testTransactionalProducerWithAuthenticationFailure() {
        KafkaProducer<byte[], byte[]> txProducer = this.createTransactionalProducer();
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            txProducer.initTransactions();
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        try {
            txProducer.initTransactions();
            Assert.fail((String)"Transaction initialization should fail after authentication failure");
            return;
        }
        catch (KafkaException kafkaException) {
            return;
        }
    }

    @Test
    public void testConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAuthenticationFailure() {
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    @Test
    public void testManualAssignmentConsumerWithAutoCommitDisabledWithAuthenticationFailure() {
        this.consumerConfig().setProperty("enable.auto.commit", ((Object)false).toString());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        consumer.seek(this.tp(), 0L);
        this.verifyConsumerWithAuthenticationFailure(consumer);
    }

    private void verifyConsumerWithAuthenticationFailure(KafkaConsumer<byte[], byte[]> consumer) {
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            consumer.poll(Duration.ofMillis(1000L));
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        long verifyAuthenticationException_startMs2 = System.currentTimeMillis();
        try {
            consumer.partitionsFor(this.topic());
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs2;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        this.createClientCredential();
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                this.sendOneRecord((KafkaProducer<byte[], byte[]>)producer, 15000L);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        int n2 = 0;
        long l3 = 15000L;
        long l4 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n2;
                SaslClientsWithInvalidCredentialsTest.$anonfun$verifyConsumerWithAuthenticationFailure$4(consumer);
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n2).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
    }

    @Test
    public void testKafkaAdminClientWithAuthenticationFailure() {
        Properties props = TestUtils$.MODULE$.adminClientSecurityConfigs(this.securityProtocol(), this.trustStoreFile(), (Option<Properties>)this.clientSaslProperties());
        props.put("bootstrap.servers", this.brokerList());
        try (Admin adminClient = Admin.create((Properties)props);){
            long verifyAuthenticationException_startMs = System.currentTimeMillis();
            try {
                this.describeTopic$1(adminClient);
                Assert.fail((String)"Expected an authentication exception");
            }
            catch (Exception exception) {
                long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
                Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
            }
            this.createClientCredential();
            int n = 0;
            long l = 15000L;
            long l2 = 100L;
            long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                boolean bl;
                try {
                    ++n;
                    this.describeTopic$1(adminClient);
                    bl = true;
                }
                catch (SaslAuthenticationException saslAuthenticationException) {
                    bl = false;
                }
                if (!bl) {
                    if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                        throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                    }
                    Thread.sleep(Math.min(l, l2));
                    continue;
                }
                break;
            }
        }
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationFailure() {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
        this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4()).subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        long verifyAuthenticationException_startMs = System.currentTimeMillis();
        try {
            consumerGroupService.listGroups();
            Assert.fail((String)"Expected an authentication exception");
        }
        catch (Exception exception) {
            long verifyAuthenticationException_elapsedMs = System.currentTimeMillis() - verifyAuthenticationException_startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(verifyAuthenticationException_elapsedMs).toString(), (verifyAuthenticationException_elapsedMs <= 5000L ? 1 : 0) != 0);
        }
        consumerGroupService.close();
    }

    @Test
    public void testConsumerGroupServiceWithAuthenticationSuccess() {
        this.createClientCredential();
        ConsumerGroupCommand.ConsumerGroupService consumerGroupService = this.prepareConsumerGroupService();
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long verifyWithRetry_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                consumer.poll(Duration.ofMillis(1000L));
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > verifyWithRetry_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        List list = consumerGroupService.listGroups();
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)list));
        consumerGroupService.close();
    }

    private ConsumerGroupCommand.ConsumerGroupService prepareConsumerGroupService() {
        File propsFile = TestUtils.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("security.protocol=SASL_PLAINTEXT\n".getBytes());
        propsStream.write(new StringBuilder(15).append("sasl.mechanism=").append(this.kafkaClientSaslMechanism()).toString().getBytes());
        propsStream.close();
        String[] cgcArgs = new String[]{"--bootstrap-server", this.brokerList(), "--describe", "--group", "test.group", "--command-config", propsFile.getAbsolutePath()};
        ConsumerGroupCommand.ConsumerGroupCommandOptions opts = new ConsumerGroupCommand.ConsumerGroupCommandOptions(cgcArgs);
        return new ConsumerGroupCommand.ConsumerGroupService(opts, (Map)Map$.MODULE$.empty());
    }

    private void createClientCredential() {
        this.createScramCredentials(this.zkConnect(), JaasTestUtils$.MODULE$.KafkaScramUser2(), JaasTestUtils$.MODULE$.KafkaScramPassword2());
    }

    private void sendOneRecord(KafkaProducer<byte[], byte[]> producer, long maxWaitMs) {
        ProducerRecord record = new ProducerRecord(this.tp().topic(), Integer.valueOf(this.tp().partition()), Long.valueOf(0L), (Object)"key".getBytes(), (Object)"value".getBytes());
        Future future = producer.send(record);
        producer.flush();
        try {
            RecordMetadata recordMetadata = (RecordMetadata)future.get(maxWaitMs, TimeUnit.MILLISECONDS);
            Assert.assertTrue((String)new StringBuilder(15).append("Invalid offset ").append(recordMetadata).toString(), (recordMetadata.offset() >= 0L ? 1 : 0) != 0);
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    private long sendOneRecord$default$2() {
        return 15000L;
    }

    private void verifyAuthenticationException(Function0<BoxedUnit> action) {
        long startMs = System.currentTimeMillis();
        try {
            action.apply$mcV$sp();
            Assert.fail((String)"Expected an authentication exception");
            return;
        }
        catch (Exception exception) {
            long elapsedMs = System.currentTimeMillis() - startMs;
            Assert.assertTrue((String)new StringBuilder(28).append("Poll took too long, elapsed=").append(elapsedMs).toString(), (elapsedMs <= 5000L ? 1 : 0) != 0);
            return;
        }
    }

    private void verifyWithRetry(Function0<BoxedUnit> action) {
        int n = 0;
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            boolean bl;
            try {
                ++n;
                action.apply$mcV$sp();
                bl = true;
            }
            catch (SaslAuthenticationException saslAuthenticationException) {
                bl = false;
            }
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(new StringBuilder(47).append("Operation did not succeed within timeout after ").append(n).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private KafkaProducer<byte[], byte[]> createTransactionalProducer() {
        this.producerConfig().setProperty("transactional.id", "txclient-1");
        this.producerConfig().put("enable.idempotence", "true");
        return this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
    }

    public static final /* synthetic */ void $anonfun$testTransactionalProducerWithAuthenticationFailure$1(KafkaProducer txProducer$1) {
        txProducer$1.initTransactions();
    }

    public static final /* synthetic */ void $anonfun$verifyConsumerWithAuthenticationFailure$4(KafkaConsumer consumer$1) {
        Assert.assertEquals((long)1L, (long)consumer$1.poll(Duration.ofMillis(1000L)).count());
    }

    public static final /* synthetic */ void $anonfun$testKafkaAdminClientWithAuthenticationFailure$1(SaslClientsWithInvalidCredentialsTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicDescription description = (TopicDescription)x0$1._2();
            Assert.assertEquals((long)$this.numPartitions(), (long)description.partitions().size());
            return;
        }
        throw new MatchError(null);
    }

    private final void describeTopic$1(Admin adminClient$1) {
        try {
            java.util.Map response = (java.util.Map)adminClient$1.describeTopics(Collections.singleton(this.topic())).all().get();
            Assert.assertEquals((long)1L, (long)response.size());
            ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(response).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                SaslClientsWithInvalidCredentialsTest.$anonfun$testKafkaAdminClientWithAuthenticationFailure$1(this, x0$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (ExecutionException executionException) {
            throw executionException.getCause();
        }
    }

    public static final /* synthetic */ void $anonfun$testConsumerGroupServiceWithAuthenticationFailure$1(ConsumerGroupCommand.ConsumerGroupService consumerGroupService$1) {
        consumerGroupService$1.listGroups();
    }

    public static final /* synthetic */ boolean $anonfun$verifyWithRetry$1(IntRef attempts$1, Function0 action$1) {
        try {
            ++attempts$1.elem;
            action$1.apply$mcV$sp();
            return true;
        }
        catch (SaslAuthenticationException saslAuthenticationException) {
            return false;
        }
    }

    public static final /* synthetic */ String $anonfun$verifyWithRetry$2(IntRef attempts$1) {
        return new StringBuilder(47).append("Operation did not succeed within timeout after ").append(attempts$1.elem).toString();
    }

    public SaslClientsWithInvalidCredentialsTest() {
        SaslSetup.$init$(this);
        this.kafkaClientSaslMechanism = "SCRAM-SHA-256";
        this.kafkaServerSaslMechanisms = new .colon.colon((Object)this.kafkaClientSaslMechanism(), (List)Nil$.MODULE$);
        this.securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        this.serverSaslProperties = new Some((Object)this.kafkaServerSaslProperties((Seq<String>)this.kafkaServerSaslMechanisms(), this.kafkaClientSaslMechanism()));
        this.clientSaslProperties = new Some((Object)this.kafkaClientSaslProperties(this.kafkaClientSaslMechanism(), this.kafkaClientSaslProperties$default$2()));
        this.consumerCount = 1;
        this.producerCount = 1;
        this.brokerCount = 1;
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), "1");
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.topic = "topic";
        this.numPartitions = 1;
        this.tp = new TopicPartition(this.topic(), 0);
        Statics.releaseFence();
    }
}

