/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.AutoPreferredReplicaLeaderElection$;
import kafka.controller.BrokerChange$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.TopicChange$;
import kafka.controller.UpdateMetadataResponseReceived;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005-4A!\u0004\b\u0001'!)!\u0004\u0001C\u00017!Ia\u0004\u0001a\u0001\u0002\u0004%Ia\b\u0005\nG\u0001\u0001\r\u00111A\u0005\n\u0011B\u0011B\u000b\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0011\t\u000b-\u0002A\u0011\u0001\u0017\t\u000bY\u0002A\u0011\u0001\u0017\t\u000bm\u0002A\u0011\u0001\u0017\t\u000bu\u0002A\u0011\u0001\u0017\t\u000b}\u0002A\u0011\u0001\u0017\t\u000b\u0005\u0003A\u0011\u0001\u0017\t\u000b\r\u0003A\u0011\u0002#\t\u000bq\u0003A\u0011B/\u00035\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005=\u0001\u0012AC2p]R\u0014x\u000e\u001c7fe*\t\u0011#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u001d\u000512m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/F\u0001!!\ti\u0012%\u0003\u0002#\u001d\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/\u0001\u000ed_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002&QA\u0011QCJ\u0005\u0003OY\u0011A!\u00168ji\"9\u0011fAA\u0001\u0002\u0004\u0001\u0013a\u0001=%c\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\tQ\u0005\u000b\u0002\u0006]A\u0011q\u0006N\u0007\u0002a)\u0011\u0011GM\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002g\u0005\u0019qN]4\n\u0005U\u0002$!B!gi\u0016\u0014\u0018!\u0007;fgRlU\r\u001e:jGN\u001cE.Z1oK\u0012|en\u00117pg\u0016D#A\u0002\u001d\u0011\u0005=J\u0014B\u0001\u001e1\u0005\u0011!Vm\u001d;\u00027Q,7\u000f^#wK:$x+\u001b;i_V$(+\u0019;f\u001b\u0016$(/[2tQ\t9\u0001(\u0001\nuKN$XI^3oiF+X-^3US6,\u0007F\u0001\u00059\u0003M!Xm\u001d;Tk\u000e\u001cWm]:gk2,e/\u001a8uQ\tI\u0001(\u0001\u000fuKN$XI^3oiRC\u0017\r\u001e+ie><8/\u0012=dKB$\u0018n\u001c8)\u0005)A\u0014!B2iK\u000e\\G\u0003B\u0013F%^CQAR\u0006A\u0002\u001d\u000b!\"\\3ue&\u001cg*Y7f!\tAuJ\u0004\u0002J\u001bB\u0011!JF\u0007\u0002\u0017*\u0011AJE\u0001\u0007yI|w\u000e\u001e \n\u000593\u0012A\u0002)sK\u0012,g-\u0003\u0002Q#\n11\u000b\u001e:j]\u001eT!A\u0014\f\t\u000bM[\u0001\u0019\u0001+\u0002\u000b\u00154XM\u001c;\u0011\u0005u)\u0016B\u0001,\u000f\u0005=\u0019uN\u001c;s_2dWM]#wK:$\b\"\u0002-\f\u0001\u0004I\u0016\u0001\u00024v]\u000e\u00042!\u0006.&\u0013\tYfCA\u0005Gk:\u001cG/[8oa\u0005)A/[7feR\u0011aL\u001b\t\u0003?\"l\u0011\u0001\u0019\u0006\u0003C\n\fAaY8sK*\u00111\rZ\u0001\b[\u0016$(/[2t\u0015\t)g-\u0001\u0004zC6lWM\u001d\u0006\u0002O\u0006\u00191m\\7\n\u0005%\u0004'!\u0002+j[\u0016\u0014\b\"\u0002$\r\u0001\u00049\u0005")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        if (this.controllerEventManager() != null) {
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testMetricsCleanedOnClose() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null){

            public void process(ControllerEvent event) {
            }

            public void preempt(ControllerEvent event) {
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().nonEmpty());
        this.controllerEventManager().close();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().isEmpty());
    }

    @Test
    public void testEventWithoutRateMetrics() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        Set processedEvents = (Set)Set$.MODULE$.empty();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, processedEvents){
            private final Set processedEvents$1;

            public void process(ControllerEvent event) {
                Set set = this.processedEvents$1;
                if (set == null) {
                    throw null;
                }
                set.addOne((Object)event);
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.processedEvents$1 = processedEvents$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        UpdateMetadataResponse updateMetadataResponse = new UpdateMetadataResponse(new UpdateMetadataResponseData().setErrorCode(Errors.NONE.code()));
        UpdateMetadataResponseReceived updateMetadataResponseEvent = new UpdateMetadataResponseReceived(updateMetadataResponse, 1);
        this.controllerEventManager().put((ControllerEvent)updateMetadataResponseEvent);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventWithoutRateMetrics$1(processedEvents)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Failed to process expected event before timing out", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertEquals((Object)updateMetadataResponseEvent, (Object)processedEvents.head());
    }

    @Test
    public void testEventQueueTime() {
        Object object;
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, latch, time, processedEvents){
            private final CountDownLatch latch$1;
            private final MockTime time$1;
            private final AtomicInteger processedEvents$2;

            public void process(ControllerEvent event) {
                this.latch$1.await();
                this.time$1.sleep(500L);
                this.processedEvents$2.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$1 = latch$1;
                this.time$1 = time$1;
                this.processedEvents$2 = processedEvents$2;
            }
        };
        Assert.assertTrue((boolean)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$1(metricName, x$3))).values().isEmpty());
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        latch.countDown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventQueueTime$2(processedEvents)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Timed out waiting for processing of all events", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Option option = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$4(metricName, x$4))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$testEventQueueTime$5(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var8_10 = null;
        object = null;
        Histogram queueTimeHistogram = (Histogram)object2;
        Assert.assertEquals((long)2L, (long)queueTimeHistogram.count());
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.01);
        Assert.assertEquals((double)500.0, (double)queueTimeHistogram.max(), (double)0.01);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulEvent() {
        void check_func;
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> {};
        AutoPreferredReplicaLeaderElection$ check_event = AutoPreferredReplicaLeaderElection$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new ControllerEventProcessor(null, check_latch, check_eventProcessedListenerCount, (Function0)check_func){
            private final CountDownLatch latch$2;
            private final AtomicInteger eventProcessedListenerCount$1;
            private final Function0 func$1;

            public void process(ControllerEvent event) {
                this.latch$2.await();
                this.eventProcessedListenerCount$1.incrementAndGet();
                this.func$1.apply$mcV$sp();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$2 = latch$2;
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
                this.func$1 = func$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = 15000L;
        long l2 = 100L;
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        check_latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventThatThrowsException() {
        void check_func;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> {
            throw new NullPointerException();
        };
        BrokerChange$ check_event = BrokerChange$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = 15000L;
        long l2 = 100L;
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        check_latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    private void check(String metricName, ControllerEvent event, Function0<BoxedUnit> func) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventProcessor eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)new MockTime(), controllerStats.rateAndTimeMetrics()));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        this.controllerEventManager().put(event);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, event)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2(event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        Object object;
        Option option = ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x$5))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$timer$2(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        return (Timer)object;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsCleanedOnClose$1(MetricName x$2) {
        return x$2.getMBeanName().startsWith("kafka.controller:type=ControllerEventManager");
    }

    private static final scala.collection.immutable.Set allEventManagerMetrics$1() {
        return ((IterableOnceOps)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(Metrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testMetricsCleanedOnClose$1(x$2)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testEventWithoutRateMetrics$1(Set processedEvents$1) {
        return processedEvents$1.size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testEventWithoutRateMetrics$2() {
        return "Failed to process expected event before timing out";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$1(String metricName$1, MetricName x$3) {
        String string = x$3.getMBeanName();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$2(AtomicInteger processedEvents$2) {
        return processedEvents$2.get() == 2;
    }

    public static final /* synthetic */ String $anonfun$testEventQueueTime$3() {
        return "Timed out waiting for processing of all events";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$4(String metricName$1, MetricName x$4) {
        String string = x$4.getMBeanName();
        return !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testEventQueueTime$5(String metricName$1) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$check$1(ControllerEventManagerTest $this, ControllerEvent event$1) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState controllerState2 = event$1.state();
        return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$check$2(ControllerEvent event$1) {
        return new StringBuilder(24).append("Controller state is not ").append(event$1.state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$check$3(ControllerEventManagerTest $this) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$check$4() {
        return "Controller state has not changed back to Idle";
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$2, MetricName x$5) {
        String string = x$5.getMBeanName();
        return !(string != null ? !string.equals(metricName$2) : metricName$2 != null);
    }

    public static final /* synthetic */ void $anonfun$timer$2(String metricName$2) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$2).toString());
    }
}

