/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_4_IV1$;
import kafka.common.RequestAndCompletionHandler;
import kafka.coordinator.AbstractCoordinatorConcurrencyTest;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator;
import kafka.coordinator.transaction.TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionStateManager$;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.server.Defaults$;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.FetchDataInfo;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.utils.Pool;
import kafka.utils.Scheduler;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\u0011mb\u0001\u00027n\u0001QDq!!\b\u0001\t\u0003\t\t\fC\u0005\u00026\u0002\u0011\r\u0011\"\u0003\u00028\"A\u0011q\u0018\u0001!\u0002\u0013\tI\fC\u0005\u0002B\u0002\u0011\r\u0011\"\u0003\u00028\"A\u00111\u0019\u0001!\u0002\u0013\tI\fC\u0005\u0002F\u0002\u0011\r\u0011\"\u0003\u00028\"A\u0011q\u0019\u0001!\u0002\u0013\tI\fC\u0005\u0002J\u0002\u0011\r\u0011\"\u0003\u0002L\"A\u00111\u001b\u0001!\u0002\u0013\ti\rC\u0006\u0002V\u0002\u0001\r\u00111A\u0005\n\u0005]\u0007bCAp\u0001\u0001\u0007\t\u0019!C\u0005\u0003CD1\"!:\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002Z\"Y\u0011q\u001d\u0001A\u0002\u0003\u0007I\u0011BAu\u0011-\t\t\u0010\u0001a\u0001\u0002\u0004%I!a=\t\u0017\u0005]\b\u00011A\u0001B\u0003&\u00111\u001e\u0005\f\u0003s\u0004\u0001\u0019!a\u0001\n\u0013\tY\u0010C\u0006\u0003\u0004\u0001\u0001\r\u00111A\u0005\n\t\u0015\u0001b\u0003B\u0005\u0001\u0001\u0007\t\u0011)Q\u0005\u0003{D\u0011Ba\u0003\u0001\u0005\u0004%IA!\u0004\t\u0011\t\u001d\u0006\u0001)A\u0005\u0005\u001fA\u0011B!+\u0001\u0005\u0004%IAa+\t\u0011\te\u0006\u0001)A\u0005\u0005[C\u0011Ba/\u0001\u0005\u0004%IA!0\t\u0011\te\u0007\u0001)A\u0005\u0005\u007fC\u0011\"!\u0013\u0001\u0005\u0004%\t!a.\t\u0011\tm\u0007\u0001)A\u0005\u0003sC\u0011B!8\u0001\u0001\u0004%I!!$\t\u0013\t}\u0007\u00011A\u0005\n\t\u0005\b\u0002\u0003Bs\u0001\u0001\u0006K!a$\t\u000f\t\u001d\b\u0001\"\u0011\u0003j\"9!\u0011 \u0001\u0005B\t%\bbBB\u0002\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0007\u001b\u0001A\u0011\u0001Bu\u0011\u001d\u0019\t\u0002\u0001C\u0001\u0005SDqa!\u0006\u0001\t\u0003\u0011I\u000fC\u0004\u0004\u001a\u0001!\tA!;\t\u000f\ru\u0001\u0001\"\u0001\u0003j\"91\u0011\u0005\u0001\u0005\u0002\t%\bbBB\u0013\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0007S\u0001A\u0011\u0001Bu\u0011\u001d\u0019i\u0003\u0001C\u0001\u0005SDqa!\r\u0001\t\u0003\u0012I\u000fC\u0004\u00044\u0001!Ia!\u000e\t\u000f\r-\u0003\u0001\"\u0003\u0004N!91Q\u000b\u0001\u0005\n\r]\u0003bBB4\u0001\u0011%1\u0011\u000e\u0005\b\u0007k\u0002A\u0011BB<\u0011\u001d\u0019Y\b\u0001C\u0005\u0007{Bqaa!\u0001\t\u0013\u0019)IB\u0004\u0003&\u0001\t\tAa\n\t\u000f\u0005u!\u0007\"\u0001\u00032!I!1\n\u001aA\u0002\u0013\u0005!Q\n\u0005\n\u0005+\u0012\u0004\u0019!C\u0001\u0005/B\u0001Ba\u00173A\u0003&!q\n\u0005\b\u0005?\u0012D\u0011\u0001B1\r\u0019\u0019I\t\u0001\u0001\u0004\f\"Q1q\u0012\u001d\u0003\u0006\u0004%\ta!%\t\u0015\rm\u0005H!A!\u0002\u0013\u0019\u0019\nC\u0004\u0002\u001ea\"\ta!(\t\u000f\r\r\u0006\b\"\u0011\u0004&\"91\u0011\u0016\u001d\u0005B\r-v!CBX\u0001\u0005\u0005\t\u0012ABY\r%\u0019I\tAA\u0001\u0012\u0003\u0019\u0019\fC\u0004\u0002\u001e}\"\ta!.\t\u0013\r]v(%A\u0005\u0002\refABBh\u0001\u0001\u0019\t\u000e\u0003\u0006\u0004V\n\u0013\t\u0011)A\u0005\u0007/Dq!!\bC\t\u0003\u0019\t\u000fC\u0004\u0004$\n#\tea:\t\u000f\r%&\t\"\u0011\u0004l\u001a11q\u001e\u0001\u0001\u0007cDq!!\bH\t\u0003\u0019\u0019\u0010C\u0004\u0004$\u001e#\tea>\t\u000f\r%v\t\"\u0011\u0004|\"91q`$\u0005\n\u0011\u0005aA\u0002C\t\u0001\u0001!\u0019\u0002\u0003\u0006\u0005\u00161\u0013\t\u0011)A\u0005\u0003sCq!!\bM\t\u0003!9\u0002C\u0004\u0004$2#\tE!;\t\u000f\u0011uA\n\"\u0011\u0003j\u001a1Aq\u0004\u0001\u0001\tCA!\u0002\"\u0006R\u0005\u0003\u0005\u000b\u0011BA]\u0011\u001d\ti\"\u0015C\u0001\tGA\u0011\u0002\"\u000bR\u0005\u0004%\t\u0001b\u000b\t\u0011\u00115\u0012\u000b)A\u0005\u0005\u000fDqaa)R\t\u0003\u0012I\u000fC\u0004\u0005\u001eE#\tE!;\u0007\r\u0011=\u0002\u0001\u0001C\u0019\u0011)!\u0019\u0004\u0017B\u0001B\u0003%1q\n\u0005\b\u0003;AF\u0011\u0001C\u001b\u0011\u001d\u0019\u0019\u000b\u0017C!\u0005SDq\u0001\"\bY\t\u0003\u0012IoB\u0004\u0002\n5D\t!a\u0003\u0007\r1l\u0007\u0012AA\b\u0011\u001d\tiB\u0018C\u0001\u0003?1a!!\t_\u0001\u0005\r\u0002BCA\u001aA\n\u0015\r\u0011\"\u0001\u00026!Q\u0011q\t1\u0003\u0002\u0003\u0006I!a\u000e\t\u0015\u0005%\u0003M!A!\u0002\u0013\tY\u0005\u0003\u0006\u0002R\u0001\u0014\t\u0011)A\u0005\u0003'Bq!!\ba\t\u0003\ti\u0007C\u0005\u0002z\u0001\u0014\r\u0011\"\u0001\u0002|!A\u0011\u0011\u00121!\u0002\u0013\ti\bC\u0005\u0002\f\u0002\u0004\r\u0011\"\u0001\u0002\u000e\"I\u0011Q\u00131A\u0002\u0013\u0005\u0011q\u0013\u0005\t\u0003G\u0003\u0007\u0015)\u0003\u0002\u0010\"9\u0011Q\u00161\u0005B\u0005=&!\n+sC:\u001c\u0018m\u0019;j_:\u001cun\u001c:eS:\fGo\u001c:D_:\u001cWO\u001d:f]\u000eLH+Z:u\u0015\tqw.A\u0006ue\u0006t7/Y2uS>t'B\u00019r\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003I\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001kB\u0019ao^=\u000e\u0003=L!\u0001_8\u0003E\u0005\u00137\u000f\u001e:bGR\u001cun\u001c:eS:\fGo\u001c:D_:\u001cWO\u001d:f]\u000eLH+Z:u!\tQ\bM\u0004\u0002|;:\u0019A0a\u0002\u000f\u0007u\f)AD\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003\u0019\u0018A\u0002\u001fs_>$h(C\u0001s\u0013\t\u0001\u0018/\u0003\u0002o_\u0006)CK]1og\u0006\u001cG/[8o\u0007>|'\u000fZ5oCR|'oQ8oGV\u0014(/\u001a8dsR+7\u000f\u001e\t\u0004\u0003\u001bqV\"A7\u0014\u0007y\u000b\t\u0002\u0005\u0003\u0002\u0014\u0005eQBAA\u000b\u0015\t\t9\"A\u0003tG\u0006d\u0017-\u0003\u0003\u0002\u001c\u0005U!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0003\u0003\u0017\u00111\u0002\u0016:b]N\f7\r^5p]N)\u0001-!\u0005\u0002&A!\u0011qEA\u0017\u001d\ra\u0018\u0011F\u0005\u0004\u0003Wy\u0017AI!cgR\u0014\u0018m\u0019;D_>\u0014H-\u001b8bi>\u00148i\u001c8dkJ\u0014XM\\2z)\u0016\u001cH/\u0003\u0003\u00020\u0005E\"!E\"p_J$\u0017N\\1u_JlU-\u001c2fe*\u0019\u00111F8\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012,\"!a\u000e\u0011\t\u0005e\u0012\u0011\t\b\u0005\u0003w\ti\u0004E\u0002\u007f\u0003+IA!a\u0010\u0002\u0016\u00051\u0001K]3eK\u001aLA!a\u0011\u0002F\t11\u000b\u001e:j]\u001eTA!a\u0010\u0002\u0016\u0005\u0001BO]1og\u0006\u001cG/[8oC2LE\rI\u0001\u000baJ|G-^2fe&#\u0007\u0003BA\n\u0003\u001bJA!a\u0014\u0002\u0016\t!Aj\u001c8h\u0003\u0011!\u0018.\\3\u0011\t\u0005U\u0013\u0011N\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)Q\u000f^5mg*!\u0011QLA0\u0003\u0019\u0019w.\\7p]*\u0019!/!\u0019\u000b\t\u0005\r\u0014QM\u0001\u0007CB\f7\r[3\u000b\u0005\u0005\u001d\u0014aA8sO&!\u00111NA,\u0005!iunY6US6,G\u0003CA8\u0003g\n)(a\u001e\u0011\u0007\u0005E\u0004-D\u0001_\u0011\u001d\t\u0019$\u001aa\u0001\u0003oAq!!\u0013f\u0001\u0004\tY\u0005C\u0004\u0002R\u0015\u0004\r!a\u0015\u0002%QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u000b\u0003\u0003{\u0002b!a\u0005\u0002\u0000\u0005\r\u0015\u0002BAA\u0003+\u0011Q!\u0011:sCf\u0004B!a\u0005\u0002\u0006&!\u0011qQA\u000b\u0005\u0011\u0011\u0015\u0010^3\u0002'QDh.T3tg\u0006<WmS3z\u0005f$Xm\u001d\u0011\u0002\u000b\u0015tG-\u001a3\u0016\u0005\u0005=\u0005\u0003BA\n\u0003#KA!a%\u0002\u0016\t9!i\\8mK\u0006t\u0017!C3oI\u0016$w\fJ3r)\u0011\tI*a(\u0011\t\u0005M\u00111T\u0005\u0005\u0003;\u000b)B\u0001\u0003V]&$\b\"CAQS\u0006\u0005\t\u0019AAH\u0003\rAH%M\u0001\u0007K:$W\r\u001a\u0011)\u0007)\f9\u000b\u0005\u0003\u0002\u0014\u0005%\u0016\u0002BAV\u0003+\u0011\u0001B^8mCRLG.Z\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u0007\u000b\u0003\u0003g\u00032!!\u0004\u0001\u00035qGK]1og\u0006\u001cG/[8ogV\u0011\u0011\u0011\u0018\t\u0005\u0003'\tY,\u0003\u0003\u0002>\u0006U!aA%oi\u0006qa\u000e\u0016:b]N\f7\r^5p]N\u0004\u0013\u0001E2p_J$\u0017N\\1u_J,\u0005o\\2i\u0003E\u0019wn\u001c:eS:\fGo\u001c:Fa>\u001c\u0007\u000eI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005IA\u000f\u001f8D_:4\u0017nZ\u000b\u0003\u0003\u001b\u0004B!!\u0004\u0002P&\u0019\u0011\u0011[7\u0003#Q\u0013\u0018M\\:bGRLwN\\\"p]\u001aLw-\u0001\u0006uq:\u001cuN\u001c4jO\u0002\na\u0003\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]\u000b\u0003\u00033\u0004B!!\u0004\u0002\\&\u0019\u0011Q\\7\u0003-Q\u0013\u0018M\\:bGRLwN\\\"p_J$\u0017N\\1u_J\f!\u0004\u001e:b]N\f7\r^5p]\u000e{wN\u001d3j]\u0006$xN]0%KF$B!!'\u0002d\"I\u0011\u0011U\u0006\u0002\u0002\u0003\u0007\u0011\u0011\\\u0001\u0018iJ\fgn]1di&|gnQ8pe\u0012Lg.\u0019;pe\u0002\nq\u0002\u001e=o'R\fG/Z'b]\u0006<WM]\u000b\u0003\u0003W\u0004B!!\u0004\u0002n&\u0019\u0011q^7\u0003/Q\u0013\u0018M\\:bGRLwN\\*uCR,W*\u00198bO\u0016\u0014\u0018a\u0005;y]N#\u0018\r^3NC:\fw-\u001a:`I\u0015\fH\u0003BAM\u0003kD\u0011\"!)\u000f\u0003\u0003\u0005\r!a;\u0002!QDhn\u0015;bi\u0016l\u0015M\\1hKJ\u0004\u0013a\u0006;y]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s+\t\ti\u0010\u0005\u0003\u0002\u000e\u0005}\u0018b\u0001B\u0001[\nyBK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\u00027QDh.T1sW\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014x\fJ3r)\u0011\tIJa\u0002\t\u0013\u0005\u0005\u0016#!AA\u0002\u0005u\u0018\u0001\u0007;y]6\u000b'o[3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3sA\u0005i\u0011\r\u001c7Pa\u0016\u0014\u0018\r^5p]N,\"Aa\u0004\u0011\r\tE!1\u0004B\u0010\u001b\t\u0011\u0019B\u0003\u0003\u0003\u0016\t]\u0011!C5n[V$\u0018M\u00197f\u0015\u0011\u0011I\"!\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u001e\tM!aA*fcB\"!\u0011\u0005B5!\u0015\u0011\u0019C\rB4\u001b\u0005\u0001!\u0001\u0004+y]>\u0003XM]1uS>tW\u0003\u0002B\u0015\u0005s\u00192A\rB\u0016!\u0011\u0011\u0019C!\f\n\u0007\t=rOA\u0005Pa\u0016\u0014\u0018\r^5p]R\u0011!1\u0007\t\u0006\u0005G\u0011$Q\u0007\t\u0005\u0005o\u0011I\u0004\u0004\u0001\u0005\u000f\tm\"G1\u0001\u0003>\t\t!+\u0005\u0003\u0003@\t\u0015\u0003\u0003BA\n\u0005\u0003JAAa\u0011\u0002\u0016\t9aj\u001c;iS:<\u0007\u0003BA\n\u0005\u000fJAA!\u0013\u0002\u0016\t\u0019\u0011I\\=\u0002\rI,7/\u001e7u+\t\u0011y\u0005\u0005\u0004\u0002\u0014\tE#QG\u0005\u0005\u0005'\n)B\u0001\u0004PaRLwN\\\u0001\u000be\u0016\u001cX\u000f\u001c;`I\u0015\fH\u0003BAM\u00053B\u0011\"!)6\u0003\u0003\u0005\rAa\u0014\u0002\u000fI,7/\u001e7uA!\u001aa'a*\u0002\u001dI,7/\u001e7u\u0007\u0006dGNY1dWR!\u0011\u0011\u0014B2\u0011\u001d\u0011)g\u000ea\u0001\u0005k\t\u0011A\u001d\t\u0005\u0005o\u0011I\u0007B\u0006\u0003l\u0001\t\t\u0011!A\u0003\u0002\t5$AA02#\u0011\u0011yGa\"\u0013\r\tE$Q\u000fBA\r\u0019\u0011\u0019\b\u0001\u0001\u0003p\taAH]3gS:,W.\u001a8u}A!!q\u000fB?\u001b\t\u0011IH\u0003\u0003\u0003|\u0005m\u0013\u0001\u00039s_R|7m\u001c7\n\t\t}$\u0011\u0010\u0002\u0007\u000bJ\u0014xN]:\u0011\t\u00055!1Q\u0005\u0004\u0005\u000bk'\u0001F%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fgVdGO\u0005\u0004\u0003\n\n-%1\u0014\u0004\u0007\u0005g\u0002\u0001Aa\"\u0011\t\t5%qS\u0007\u0003\u0005\u001fSAA!%\u0003\u0014\u0006!A.\u00198h\u0015\t\u0011)*\u0001\u0003kCZ\f\u0017\u0002\u0002BM\u0005\u001f\u0013aa\u00142kK\u000e$\b\u0003\u0002BO\u0005Gk!Aa(\u000b\t\t\u0005&1S\u0001\u0003S>LAA!*\u0003 \na1+\u001a:jC2L'0\u00192mK\u0006q\u0011\r\u001c7Pa\u0016\u0014\u0018\r^5p]N\u0004\u0013aD1mYR\u0013\u0018M\\:bGRLwN\\:\u0016\u0005\t5\u0006#\u0002BX\u0005kKXB\u0001BY\u0015\u0011\u0011\u0019La\u0006\u0002\u000f5,H/\u00192mK&!!q\u0017BY\u0005\r\u0019V\r^\u0001\u0011C2dGK]1og\u0006\u001cG/[8og\u0002\nQ\u0003\u001e=o%\u0016\u001cwN\u001d3t\u0005f\u0004\u0016M\u001d;ji&|g.\u0006\u0002\u0003@BA!\u0011\u0019Bb\u0003s\u00139-\u0004\u0002\u0003\u0018%!!Q\u0019B\f\u0005\ri\u0015\r\u001d\t\u0007\u0005_\u0013IM!4\n\t\t-'\u0011\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'\u000f\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\u0011\u0011\u0019.a\u0017\u0002\rI,7m\u001c:e\u0013\u0011\u00119N!5\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\u0002-QDhNU3d_J$7OQ=QCJ$\u0018\u000e^5p]\u0002\n1\u0002\u001d:pIV\u001cWM]%eA\u0005q!-^7q!J|G-^2fe&#\u0017A\u00052v[B\u0004&o\u001c3vG\u0016\u0014\u0018\nZ0%KF$B!!'\u0003d\"I\u0011\u0011\u0015\u000f\u0002\u0002\u0003\u0007\u0011qR\u0001\u0010EVl\u0007\u000f\u0015:pIV\u001cWM]%eA\u0005)1/\u001a;VaR\u0011\u0011\u0011\u0014\u0015\u0004=\t5\b\u0003\u0002Bx\u0005kl!A!=\u000b\t\tM\u0018QM\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005o\u0014\tP\u0001\u0004CK\u001a|'/Z\u0001\ti\u0016\f'\u000fR8x]\"\u001aqD!@\u0011\t\t=(q`\u0005\u0005\u0007\u0003\u0011\tPA\u0003BMR,'/\u0001\u0010uKN$8i\u001c8dkJ\u0014XM\u001c;H_>$\u0007+\u0019;i'\u0016\fX/\u001a8dK\"\u001a\u0001ea\u0002\u0011\t\t=8\u0011B\u0005\u0005\u0007\u0017\u0011\tP\u0001\u0003UKN$\u0018!\b;fgR\u001cuN\\2veJ,g\u000e\u001e*b]\u0012|WnU3rk\u0016t7-Z:)\u0007\u0005\u001a9!\u0001\u0012uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u0006$WK\u001c7pC\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004E\r\u001d\u0011a\t;fgR\u001cuN\\2veJ,g\u000e\u001e+sC:\u001c\u0018m\u0019;j_:,\u0005\u0010]5sCRLwN\u001c\u0015\u0004G\r\u001d\u0011a\n;fgR\u001cuN\\2veJ,g\u000e\u001e(fo&s\u0017\u000e\u001e)s_\u0012,8-\u001a:JIJ+\u0017/^3tiND3\u0001JB\u0004\u0003]\"Xm\u001d;D_:\u001cWO\u001d:f]RLe.\u001b;Qe>$WoY3s\u0013\u0012\u0014V-];fgR\u001cxJ\\3OK^|e.Z\"p]RLg.^5oO\"\u001aQea\u0002\u0002]Q,7\u000f^\"p]\u000e,(O]3oi\u000e{g\u000e^5ok&tw-\u00138jiB\u0013x\u000eZ;dKJLEMU3rk\u0016\u001cHo\u001d\u0015\u0004M\r\u001d\u0011!\f;fgR\u001cuN\\2veJ,g\u000e^%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a*fcV,7\u000f^:XSRD'+\u001a;ss\"\u001aqea\u0002\u0002_Q,7\u000f^\"p]\u000e,(O]3oi&s\u0017\u000e\u001e)s_\u0012,8-\u001a:SKF,Xm\u001d;t\u0003R\u0004\u0016\u000e\u001a\"pk:$\u0017M]=)\u0007!\u001a9!\u0001\u001duKN$8i\u001c8dkJ\u0014XM\u001c;J]&$\bK]8ek\u000e,'OU3rk\u0016\u001cHo],ji\"\u0014V\r\u001e:z\u0003R\u0004\u0016\u000e\u001a\"pk:$\u0017M]=)\u0007%\u001a9!\u0001\tf]\u0006\u0014G.Z\"p[BdW\r^5p]\u0006\tBn\\1e+:dw.\u00193BGRLwN\\:\u0015\r\r]2\u0011IB$!\u0019\tId!\u000f\u0004<%!!qWA#!\u0011\t9c!\u0010\n\t\r}\u0012\u0011\u0007\u0002\u0007\u0003\u000e$\u0018n\u001c8\t\u000f\r\r3\u00061\u0001\u0004F\u0005\u0001\u0002/\u0019:uSRLwN\\:U_2{\u0017\r\u001a\t\u0007\u0003s\u0019I$!/\t\u000f\r%3\u00061\u0001\u0004F\u0005\u0011\u0002/\u0019:uSRLwN\\:U_VsGn\\1e\u0003I\u0019'/Z1uKR\u0013\u0018M\\:bGRLwN\\:\u0015\t\r=3\u0011\u000b\t\u0006\u0003s\u0019I$\u001f\u0005\b\u0007'b\u0003\u0019AA\u001c\u0003%!\bP\u001c)sK\u001aL\u00070A\twKJLg-\u001f+sC:\u001c\u0018m\u0019;j_:$b!!'\u0004Z\ru\u0003BBB.[\u0001\u0007\u00110A\u0002uq:Dqaa\u0018.\u0001\u0004\u0019\t'A\u0007fqB,7\r^3e'R\fG/\u001a\t\u0005\u0003\u001b\u0019\u0019'C\u0002\u0004f5\u0014\u0001\u0003\u0016:b]N\f7\r^5p]N#\u0018\r^3\u0002'Q\u0014\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1\u0015\t\r-41\u000f\t\u0007\u0003'\u0011\tf!\u001c\u0011\t\u000551qN\u0005\u0004\u0007cj'a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007BBB.]\u0001\u0007\u00110\u0001\nqe\u0016\u0004\u0018M]3Ue\u0006t7/Y2uS>tG\u0003BAM\u0007sBaaa\u00170\u0001\u0004I\u0018!\u00049sKB\f'/\u001a+y]2{w\r\u0006\u0003\u0002\u001a\u000e}\u0004bBBAa\u0001\u0007\u0011\u0011X\u0001\fa\u0006\u0014H/\u001b;j_:LE-\u0001\u0011qe\u0016\u0004\u0018M]3Fq\"\fWo\u001d;fI\u0016\u0003xn\u00195Uq:lU\r^1eCR\fG\u0003BB7\u0007\u000fCaaa\u00172\u0001\u0004I(aF%oSR\u0004&o\u001c3vG\u0016\u0014\u0018\nZ(qKJ\fG/[8o'\rA4Q\u0012\t\u0006\u0005G\u0011$\u0011Q\u0001\u0013aJ|G-^2fe&#\u0017I\u001c3Fa>\u001c\u0007.\u0006\u0002\u0004\u0014B1\u00111\u0003B)\u0007+\u0003B!!\u0016\u0004\u0018&!1\u0011TA,\u0005I\u0001&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0002'A\u0014x\u000eZ;dKJLE-\u00118e\u000bB|7\r\u001b\u0011\u0015\t\r}5\u0011\u0015\t\u0004\u0005GA\u0004\"CBHwA\u0005\t\u0019ABJ\u0003\r\u0011XO\u001c\u000b\u0005\u00033\u001b9\u000b\u0003\u0004\u0004\\q\u0002\r!_\u0001\u000fC^\f\u0017\u000e^!oIZ+'/\u001b4z)\u0011\tIj!,\t\r\rmS\b1\u0001z\u0003]Ie.\u001b;Qe>$WoY3s\u0013\u0012|\u0005/\u001a:bi&|g\u000eE\u0002\u0003$}\u001a2aPA\t)\t\u0019\t,A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u000b\u0003\u0007wSCaa%\u0004>.\u00121q\u0018\t\u0005\u0007\u0003\u001cY-\u0004\u0002\u0004D*!1QYBd\u0003%)hn\u00195fG.,GM\u0003\u0003\u0004J\u0006U\u0011AC1o]>$\u0018\r^5p]&!1QZBb\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0002\u001c\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_RChn\u00149fe\u0006$\u0018n\u001c8\u0014\u0007\t\u001b\u0019\u000eE\u0003\u0003$I\u0012)(\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004b!!\u000f\u0004:\re\u0007\u0003BBn\u0007;l!!a\u0017\n\t\r}\u00171\f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o)\u0011\u0019\u0019o!:\u0011\u0007\t\r\"\tC\u0004\u0004V\u0012\u0003\raa6\u0015\t\u0005e5\u0011\u001e\u0005\u0007\u00077*\u0005\u0019A=\u0015\t\u0005e5Q\u001e\u0005\u0007\u000772\u0005\u0019A=\u0003\u001f\u0015sG\r\u0016=o\u001fB,'/\u0019;j_:\u001c2aRBj)\t\u0019)\u0010E\u0002\u0003$\u001d#B!!'\u0004z\"111L%A\u0002e$B!!'\u0004~\"111\f&A\u0002e\f\u0011\u0003\u001e:b]N\f7\r^5p]J+7/\u001e7u)\u0011!\u0019\u0001b\u0004\u0011\t\u0011\u0015A1B\u0007\u0003\t\u000fQA\u0001\"\u0003\u0002\\\u0005A!/Z9vKN$8/\u0003\u0003\u0005\u000e\u0011\u001d!!\u0005+sC:\u001c\u0018m\u0019;j_:\u0014Vm];mi\"111L&A\u0002e\u0014a\u0003T8bIRCh\u000eU1si&$\u0018n\u001c8BGRLwN\\\n\u0006\u0019\n-51H\u0001\u0014ibtGk\u001c9jGB\u000b'\u000f^5uS>t\u0017\n\u001a\u000b\u0005\t3!Y\u0002E\u0002\u0003$1Cq\u0001\"\u0006O\u0001\u0004\tI,A\u0003bo\u0006LGO\u0001\rV]2|\u0017\r\u001a+y]B\u000b'\u000f^5uS>t\u0017i\u0019;j_:\u001cR!\u0015BF\u0007w!B\u0001\"\n\u0005(A\u0019!1E)\t\u000f\u0011U1\u000b1\u0001\u0002:\u0006QA\u000f\u001f8SK\u000e|'\u000fZ:\u0016\u0005\t\u001d\u0017a\u0003;y]J+7m\u001c:eg\u0002\u0012\u0001$\u0012=qSJ,GK]1og\u0006\u001cG/[8og\u0006\u001bG/[8o'\u0015A&1RB\u001e\u00031!(/\u00198tC\u000e$\u0018n\u001c8t)\u0011!9\u0004\"\u000f\u0011\u0007\t\r\u0002\fC\u0004\u00054i\u0003\raa\u0014")
public class TransactionCoordinatorConcurrencyTest
extends AbstractCoordinatorConcurrencyTest<Transaction> {
    private volatile TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$ InitProducerIdOperation$module;
    private final int nTransactions = this.nThreads() * 10;
    private final int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    private final int numPartitions = this.nThreads() * 5;
    private final TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig = new TransactionConfig(TransactionStateManager$.MODULE$.DefaultTransactionalIdExpirationMs(), TransactionStateManager$.MODULE$.DefaultTransactionsMaxTimeoutMs(), TransactionLog$.MODULE$.DefaultNumPartitions(), TransactionLog$.MODULE$.DefaultReplicationFactor(), TransactionLog$.MODULE$.DefaultSegmentBytes(), TransactionLog$.MODULE$.DefaultLoadBufferSize(), TransactionLog$.MODULE$.DefaultMinInSyncReplicas(), TransactionStateManager$.MODULE$.DefaultAbortTimedOutTransactionsIntervalMs(), TransactionStateManager$.MODULE$.DefaultRemoveExpiredTransactionalIdsIntervalMs(), Defaults$.MODULE$.RequestTimeoutMs());
    private TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    private TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    private TransactionMarkerChannelManager txnMarkerChannelManager;
    private final scala.collection.immutable.Seq<TxnOperation<? extends Object>> allOperations;
    private final scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    private final Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition;
    private final int producerId;
    private boolean bumpProducerId;

    public TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$ InitProducerIdOperation() {
        if (this.InitProducerIdOperation$module == null) {
            this.InitProducerIdOperation$lzycompute$1();
        }
        return this.InitProducerIdOperation$module;
    }

    private int nTransactions() {
        return this.nTransactions;
    }

    public int kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch;
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    public TransactionConfig kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig;
    }

    public TransactionCoordinator kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(TransactionCoordinator x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator = x$1;
    }

    public TransactionStateManager kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager;
    }

    private void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(TransactionStateManager x$1) {
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager = x$1;
    }

    private TransactionMarkerChannelManager txnMarkerChannelManager() {
        return this.txnMarkerChannelManager;
    }

    private void txnMarkerChannelManager_$eq(TransactionMarkerChannelManager x$1) {
        this.txnMarkerChannelManager = x$1;
    }

    private scala.collection.immutable.Seq<TxnOperation<? extends Object>> allOperations() {
        return this.allOperations;
    }

    public scala.collection.mutable.Set<Transaction> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions() {
        return this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions;
    }

    private Map<Object, ArrayBuffer<SimpleRecord>> txnRecordsByPartition() {
        return this.txnRecordsByPartition;
    }

    public int producerId() {
        return this.producerId;
    }

    private boolean bumpProducerId() {
        return this.bumpProducerId;
    }

    private void bumpProducerId_$eq(boolean x$1) {
        this.bumpProducerId = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)this.numPartitions())).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager_$eq(new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), (ReplicaManager)this.replicaManager(), this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Time)this.time(), new Metrics(), (ApiVersion)KAFKA_2_4_IV1$.MODULE$));
        int n = 0;
        int until$extension_end = this.numPartitions();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                TransactionCoordinatorConcurrencyTest.$anonfun$setUp$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var8_3 = null;
        ProducerIdManager pidManager = (ProducerIdManager)EasyMock.createNiceMock(ProducerIdManager.class);
        EasyMock.expect((Object)pidManager.generateProducerId()).andAnswer(() -> BoxesRunTime.boxToLong((long)TransactionCoordinatorConcurrencyTest.$anonfun$setUp$2(this))).anyTimes();
        MockTimer x$2 = new MockTimer();
        int n2 = 0;
        int n3 = 1000;
        boolean bl = true;
        DelayedOperationPurgatory txnMarkerPurgatory = new DelayedOperationPurgatory("txn-purgatory-name", (Timer)x$2, n2, n3, false, bl);
        Node brokerNode = new Node(0, "host", 10);
        MetadataCache metadataCache = (MetadataCache)EasyMock.createNiceMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getPartitionLeaderEndpoint(EasyMock.anyString(), EasyMock.anyInt(), (ListenerName)EasyMock.anyObject())).andReturn((Object)new Some((Object)brokerNode)).anyTimes();
        NetworkClient networkClient = (NetworkClient)EasyMock.createNiceMock(NetworkClient.class);
        this.txnMarkerChannelManager_$eq(new TransactionMarkerChannelManager(this, metadataCache, networkClient, txnMarkerPurgatory){
            private final DelayedOperationPurgatory txnMarkerPurgatory$1;

            public void shutdown() {
                this.txnMarkerPurgatory$1.shutdown();
            }
            {
                this.txnMarkerPurgatory$1 = txnMarkerPurgatory$1;
                super(KafkaConfig$.MODULE$.fromProps($outer.serverProps()), metadataCache$1, networkClient$1, $outer.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), txnMarkerPurgatory$1, (Time)$outer.time());
            }
        });
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator_$eq(new TransactionCoordinator(0, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig(), (Scheduler)this.scheduler(), pidManager, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager(), this.txnMarkerChannelManager(), (Time)this.time(), new LogContext()));
        EasyMock.replay((Object[])new Object[]{pidManager});
        EasyMock.replay((Object[])new Object[]{metadataCache});
        EasyMock.replay((Object[])new Object[]{networkClient});
    }

    @Override
    @After
    public void tearDown() {
        try {
            EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().shutdown();
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    public void testConcurrentGoodPathSequence() {
        this.verifyConcurrentOperations((Function1 & Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentRandomSequences() {
        this.verifyConcurrentRandomSequences((Function1 & Serializable)txnPrefix -> this.createTransactions((String)txnPrefix), (Seq<AbstractCoordinatorConcurrencyTest.Operation>)this.allOperations());
    }

    @Test
    public void testConcurrentLoadUnloadPartitions() {
        int n = 0;
        int until$extension_end = this.numPartitions() / 2;
        scala.collection.immutable.Set partitionsToLoad = new Range.Exclusive(n, until$extension_end, 1).toSet();
        int n2 = this.numPartitions() / 2;
        int until$extension_end2 = this.numPartitions();
        scala.collection.immutable.Set partitionsToUnload = new Range.Exclusive(n2, until$extension_end2, 1).toSet();
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload));
    }

    @Test
    public void testConcurrentTransactionExpiration() {
        int n = 0;
        int until$extension_end = this.numPartitions() / 3;
        scala.collection.immutable.Set partitionsToLoad = new Range.Exclusive(n, until$extension_end, 1).toSet();
        int n2 = this.numPartitions() / 3;
        int until$extension_end2 = this.numPartitions() * 2 / 3;
        scala.collection.immutable.Set partitionsToUnload = new Range.Exclusive(n2, until$extension_end2, 1).toSet();
        int n3 = this.numPartitions() * 2 / 3;
        int until$extension_end3 = this.numPartitions();
        scala.collection.immutable.Set partitionsWithExpiringTxn = new Range.Exclusive(n3, until$extension_end3, 1).toSet();
        scala.collection.immutable.Set expiringTransactions = ((IterableOnceOps)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().filter((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)partitionsWithExpiringTxn.contains((Object)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()))))).toSet();
        ExpireTransactionsAction expireAction = new ExpireTransactionsAction(this, (scala.collection.immutable.Set<Transaction>)expiringTransactions);
        scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> set = this.loadUnloadActions((scala.collection.immutable.Set<Object>)partitionsToLoad, (scala.collection.immutable.Set<Object>)partitionsToUnload);
        if (set == null) {
            throw null;
        }
        this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)set.incl((Object)expireAction)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentNewInitProducerIdRequests() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 100;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var5_4 = null;
        Object var6_5 = null;
        set = null;
        Object var3_3 = null;
        IndexedSeq transactions = (IndexedSeq)flatMap_strictOptimizedFlatMap_b.result();
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentNewInitProducerIdRequests$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentInitProducerIdRequestsOneNewOneContinuing() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 10;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        set = null;
        Object var2_3 = null;
        ((IndexedSeq)flatMap_strictOptimizedFlatMap_b.result()).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerIdRequestsOneNewOneContinuing$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentContinuingInitProducerIdRequests() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 100;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        set = null;
        Object var2_3 = null;
        ((IndexedSeq)flatMap_strictOptimizedFlatMap_b.result()).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentContinuingInitProducerIdRequests$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentInitProducerIdRequestsWithRetry() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 10;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        set = null;
        Object var2_3 = null;
        ((IndexedSeq)flatMap_strictOptimizedFlatMap_b.result()).foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerIdRequestsWithRetry$2(this, txn);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentInitProducerRequestsAtPidBoundary() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 10;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var5_4 = null;
        Object var6_5 = null;
        set = null;
        Object var3_3 = null;
        IndexedSeq transactions = (IndexedSeq)flatMap_strictOptimizedFlatMap_b.result();
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerRequestsAtPidBoundary$2(this, txn);
            return BoxedUnit.UNIT;
        });
        this.bumpProducerId_$eq(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConcurrentInitProducerRequestsWithRetryAtPidBoundary() {
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 10;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var5_4 = null;
        Object var6_5 = null;
        set = null;
        Object var3_3 = null;
        IndexedSeq transactions = (IndexedSeq)flatMap_strictOptimizedFlatMap_b.result();
        this.bumpProducerId_$eq(true);
        transactions.foreach((Function1 & Serializable)txn -> {
            TransactionCoordinatorConcurrencyTest.$anonfun$testConcurrentInitProducerRequestsWithRetryAtPidBoundary$2(this, txn);
            return BoxedUnit.UNIT;
        });
        this.bumpProducerId_$eq(false);
    }

    @Override
    public void enableCompletion() {
        super.enableCompletion();
        synchronized (this) {
            this.txnMarkerChannelManager().generateRequests().foreach((Function1 & Serializable)requestAndHandler -> {
                TransactionCoordinatorConcurrencyTest.$anonfun$enableCompletion$3(requestAndHandler);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<AbstractCoordinatorConcurrencyTest.Action> loadUnloadActions(scala.collection.immutable.Set<Object> partitionsToLoad, scala.collection.immutable.Set<Object> partitionsToUnload) {
        void $plus$plus_suffix;
        scala.collection.immutable.Set set;
        int n = 1;
        int to$extension_end = 10;
        Range.Inclusive flatMap_this = new Range.Inclusive(n, to$extension_end, 1);
        Builder flatMap_strictOptimizedFlatMap_b = IndexedSeq.iterableFactory$((IndexedSeq)flatMap_this).newBuilder();
        for (Object object : flatMap_this) {
            void flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs;
            scala.collection.immutable.Set set2;
            scala.collection.immutable.Set set3 = set2 = this.createTransactions(new StringBuilder(35).append("testConcurrentLoadUnloadPartitions").append(BoxesRunTime.unboxToInt((Object)object)).append("-").toString());
            set2 = null;
            set = set3;
            if (flatMap_strictOptimizedFlatMap_b == null) {
                throw null;
            }
            flatMap_strictOptimizedFlatMap_b.addAll((IterableOnce)flatMap_strictOptimizedFlatMap_$plus$plus$eq_xs);
            set = null;
        }
        Object var8_6 = null;
        Object var9_7 = null;
        set = null;
        Object var6_5 = null;
        ((IterableOnceOps)flatMap_strictOptimizedFlatMap_b.result()).toSet().foreach((Function1 & Serializable)txn -> {
            this.prepareTransaction(txn);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Set unload = (scala.collection.immutable.Set)partitionsToLoad.map((Function1 & Serializable)x$10 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$3(this, BoxesRunTime.unboxToInt((Object)x$10)));
        unload.foreach((Function1 & Serializable)x$11 -> {
            x$11.run();
            return BoxedUnit.UNIT;
        });
        unload.foreach((Function1 & Serializable)x$12 -> {
            x$12.await();
            return BoxedUnit.UNIT;
        });
        IterableOps iterableOps = (IterableOps)partitionsToLoad.map((Function1 & Serializable)x$13 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$6(this, BoxesRunTime.unboxToInt((Object)x$13)));
        IterableOnce iterableOnce = (IterableOnce)partitionsToUnload.map((Function1 & Serializable)x$14 -> TransactionCoordinatorConcurrencyTest.$anonfun$loadUnloadActions$7(this, BoxesRunTime.unboxToInt((Object)x$14)));
        if (iterableOps == null) {
            throw null;
        }
        return (scala.collection.immutable.Set)iterableOps.concat((IterableOnce)$plus$plus_suffix);
    }

    /*
     * WARNING - void declaration
     */
    private scala.collection.immutable.Set<Transaction> createTransactions(String txnPrefix) {
        IndexedSeq indexedSeq;
        Transaction transaction;
        int n = 0;
        int until$extension_end = this.nTransactions();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Transaction transaction2;
            Transaction transaction3 = transaction2 = TransactionCoordinatorConcurrencyTest.$anonfun$createTransactions$1(this, txnPrefix, BoxesRunTime.unboxToInt((Object)object));
            transaction2 = null;
            transaction = transaction3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            transaction = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        transaction = null;
        indexedSeq = null;
        IndexedSeq transactions = indexedSeq2;
        scala.collection.mutable.Set<Transaction> set = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions();
        if (set == null) {
            throw null;
        }
        set.addAll((IterableOnce)transactions);
        return transactions.toSet();
    }

    public void kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(Transaction txn, TransactionState expectedState) {
        boolean bl;
        Option option;
        long l = 15000L;
        long l2 = 100L;
        long computeUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            Option computeUntilTrue_result;
            option = computeUntilTrue_result = TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$1(this, txn);
            if (TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState, computeUntilTrue_result)) {
                bl = true;
                break;
            }
            if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                bl = false;
                break;
            }
            Thread.sleep(Math.min(l, l2));
        }
        Object var5_6 = null;
        Assert.assertTrue((String)new StringBuilder(23).append("Invalid metadata state ").append(option).toString(), (boolean)bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<TransactionMetadata> kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(Transaction txn) {
        boolean bl = false;
        Right right = null;
        Either either = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().getTransactionState(txn.transactionalId());
        if (either instanceof Left) {
            Errors error;
            Errors errors = error = (Errors)((Left)either).value();
            Errors errors2 = Errors.NOT_COORDINATOR;
            if (errors == null) {
                if (errors2 == null) return None$.MODULE$;
                throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            }
            if (!errors.equals(errors2)) throw new AssertionError((Object)new StringBuilder(34).append("Unexpected transaction error ").append(error).append(" for ").append(txn).toString());
            return None$.MODULE$;
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (option instanceof Some) {
                CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)((Some)option).value();
                return new Some((Object)metadata.transactionMetadata());
            }
        }
        if (!bl) throw new MatchError((Object)either);
        Option option = (Option)right.value();
        if (!None$.MODULE$.equals(option)) throw new MatchError((Object)either);
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private void prepareTransaction(Transaction txn) {
        void $plus$eq_elem;
        void apply_elems;
        int partitionId = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId());
        ArrayBuffer txnRecords = (ArrayBuffer)this.txnRecordsByPartition().apply((Object)partitionId);
        if (this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation initPidOp = new InitProducerIdOperation(this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        AddPartitionsToTxnOperation addPartitionsOp = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        initPidOp.run(txn);
        initPidOp.awaitAndVerify(txn);
        addPartitionsOp.run(txn);
        addPartitionsOp.awaitAndVerify(txn);
        Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
        if (option == null) {
            throw null;
        }
        Option<TransactionMetadata> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw TransactionCoordinatorConcurrencyTest.$anonfun$prepareTransaction$1(txn);
        }
        Object var7_7 = null;
        TransactionMetadata txnMetadata = (TransactionMetadata)getOrElse_this.get();
        SimpleRecord simpleRecord = new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()));
        if (txnRecords == null) {
            throw null;
        }
        txnRecords.addOne((Object)$plus$eq_elem);
        simpleRecord = null;
        txnMetadata.state_$eq((TransactionState)PrepareCommit$.MODULE$);
        SimpleRecord $plus$eq_elem2 = new SimpleRecord(txn.txnMessageKeyBytes(), TransactionLog$.MODULE$.valueToBytes(txnMetadata.prepareNoTransit()));
        txnRecords.addOne((Object)$plus$eq_elem2);
        Object var9_10 = null;
        this.prepareTxnLog(partitionId);
    }

    /*
     * WARNING - void declaration
     */
    private void prepareTxnLog(int partitionId) {
        MemoryRecords memoryRecords;
        void withRecords_records;
        MemoryRecords memoryRecords2;
        Object object;
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        TopicPartition topicPartition = new TopicPartition("__transaction_state", partitionId);
        Option<Object> option = this.replicaManager().getLogEndOffset(topicPartition);
        if (option == null) {
            throw null;
        }
        Option<Object> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            Long l;
            Long l2 = l = Long.valueOf(20L);
            l = null;
            object = l2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var11_5 = null;
        object = null;
        long startOffset = BoxesRunTime.unboxToLong((Object)object2);
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])((IterableOnceOps)this.txnRecordsByPartition().apply((Object)partitionId)).toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        TimestampType withRecords_timestampType = TimestampType.CREATE_TIME;
        MemoryRecords memoryRecords3 = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)startOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
        Object var16_11 = null;
        memoryRecords2 = null;
        MemoryRecords memoryRecords4 = memoryRecords = memoryRecords3;
        Object var13_10 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords4;
        long endOffset = startOffset + (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)logMock.logStartOffset()).andStubReturn((Object)startOffset);
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (FetchIsolation)EasyMock.eq((Object)FetchLogEnd$.MODULE$), EasyMock.eq((boolean)true))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), (Records)fileRecordsMock, false, (Option)None$.MODULE$));
        EasyMock.expect((Object)fileRecordsMock.sizeInBytes()).andStubReturn((Object)records.sizeInBytes());
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock});
        synchronized (this) {
            this.replicaManager().updateLog(topicPartition, logMock, endOffset);
            return;
        }
    }

    private TransactionMetadata prepareExhaustedEpochTxnMetadata(Transaction txn) {
        String x$1 = txn.transactionalId();
        long x$2 = this.producerId();
        short x$4 = (short)32766;
        Empty$ x$7 = Empty$.MODULE$;
        scala.collection.mutable.Set x$8 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long l = -1L;
        return new TransactionMetadata(x$1, x$2, -1L, x$4, -1, 60000, (TransactionState)x$7, x$8, l, x$9);
    }

    private final void InitProducerIdOperation$lzycompute$1() {
        synchronized (this) {
            if (this.InitProducerIdOperation$module == null) {
                this.InitProducerIdOperation$module = new TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ Tuple2 $anonfun$txnRecordsByPartition$1(int i) {
        return new Tuple2((Object)i, IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)Nil$.MODULE$));
    }

    public static final /* synthetic */ void $anonfun$setUp$1(TransactionCoordinatorConcurrencyTest $this, int i) {
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().addLoadedTransactionsToCache(i, $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch(), new Pool((Option)None$.MODULE$));
    }

    public static final /* synthetic */ long $anonfun$setUp$2(TransactionCoordinatorConcurrencyTest $this) {
        if ($this.bumpProducerId()) {
            return $this.producerId() + 1;
        }
        return $this.producerId();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentNewInitProducerIdRequests$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp1 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp2 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{newProducerOp1, newProducerOp2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$4 -> x$4.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp2.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)newProducerOp1.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.assertNotEquals((long)((InitProducerIdResult)newProducerOp1.result().get()).producerEpoch(), (long)((InitProducerIdResult)newProducerOp2.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)newProducerOp1.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)newProducerOp2.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"One of two InitProducerId requests should succeed");
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerIdRequestsOneNewOneContinuing$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation firstInitReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        firstInitReq.run(txn);
        firstInitReq.awaitAndVerify(txn);
        ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)firstInitReq.result().get()).producerId(), ((InitProducerIdResult)firstInitReq.result().get()).producerEpoch());
        InitProducerIdOperation bumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp, newProducerOp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$5 -> x$5.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)(producerIdAndEpoch.epoch + 2), (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)(producerIdAndEpoch.epoch + 1), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)(producerIdAndEpoch.epoch + 1), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)(producerIdAndEpoch.epoch + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"One of two InitProducerId requests should succeed");
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentContinuingInitProducerIdRequests$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        ProducerIdAndEpoch producerIdAndEpoch = new ProducerIdAndEpoch((long)$this.producerId(), 10);
        InitProducerIdOperation bumpEpochOp1 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        InitProducerIdOperation bumpEpochOp2 = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)producerIdAndEpoch));
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp1, bumpEpochOp2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$6 -> x$6.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)bumpEpochOp2.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp1.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.fail((String)"One of two InitProducerId requests should fail due to concurrent requests or non-matching epochs");
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)bumpEpochOp1.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)bumpEpochOp2.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"One of two InitProducerId requests should succeed");
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerIdRequestsWithRetry$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation firstInitReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        firstInitReq.run(txn);
        firstInitReq.awaitAndVerify(txn);
        ProducerIdAndEpoch initialProducerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)firstInitReq.result().get()).producerId(), ((InitProducerIdResult)firstInitReq.result().get()).producerEpoch());
        InitProducerIdOperation bumpEpochReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)initialProducerIdAndEpoch));
        bumpEpochReq.run(txn);
        bumpEpochReq.awaitAndVerify(txn);
        ProducerIdAndEpoch bumpedProducerIdAndEpoch = new ProducerIdAndEpoch(((InitProducerIdResult)bumpEpochReq.result().get()).producerId(), ((InitProducerIdResult)bumpEpochReq.result().get()).producerEpoch());
        InitProducerIdOperation retryBumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)initialProducerIdAndEpoch));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{retryBumpEpochOp, newProducerOp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$7 -> x$7.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)retryBumpEpochOp.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)(bumpedProducerIdAndEpoch.epoch + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)bumpedProducerIdAndEpoch.epoch, (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)bumpedProducerIdAndEpoch.epoch, (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)(bumpedProducerIdAndEpoch.epoch + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"At least one InitProducerId request should succeed");
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerRequestsAtPidBoundary$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        InitProducerIdOperation bumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch((long)$this.producerId(), (short)32766)));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{bumpEpochOp, newProducerOp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$8 -> x$8.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)bumpEpochOp.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerId());
            Assert.assertEquals((long)1L, (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)bumpEpochOp.result().get()).producerId());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"One of two InitProducerId requests should succeed");
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testConcurrentInitProducerRequestsWithRetryAtPidBoundary$2(TransactionCoordinatorConcurrencyTest $this, Transaction txn) {
        void apply_elems;
        TransactionMetadata txnMetadata = $this.prepareExhaustedEpochTxnMetadata(txn);
        $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().putTransactionStateIfNotExists(txnMetadata);
        InitProducerIdOperation bumpEpochReq = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch((long)$this.producerId(), (short)32766)));
        bumpEpochReq.run(txn);
        bumpEpochReq.awaitAndVerify(txn);
        InitProducerIdOperation retryBumpEpochOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)new Some((Object)new ProducerIdAndEpoch((long)$this.producerId(), (short)32766)));
        if ($this.InitProducerIdOperation() == null) {
            throw null;
        }
        InitProducerIdOperation newProducerOp = new InitProducerIdOperation($this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InitProducerIdOperation[]{retryBumpEpochOp, newProducerOp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        $this.verifyConcurrentActions((Set<AbstractCoordinatorConcurrencyTest.Action>)((Set)((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x$9 -> x$9.actionNoVerify(txn))));
        Errors errors = ((InitProducerIdResult)newProducerOp.result().get()).error();
        Errors errors2 = ((InitProducerIdResult)retryBumpEpochOp.result().get()).error();
        Tuple2 tuple2 = new Tuple2((Object)errors2, (Object)errors);
        if (Errors.NONE.equals(errors2) && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerId());
            Assert.assertEquals((long)1L, (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (Errors.NONE.equals(errors2)) {
            Assert.assertEquals((long)0L, (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)retryBumpEpochOp.result().get()).producerId());
            return;
        }
        if (tuple2 != null && Errors.NONE.equals(errors)) {
            Assert.assertEquals((long)1L, (long)((InitProducerIdResult)newProducerOp.result().get()).producerEpoch());
            Assert.assertEquals((long)($this.producerId() + 1), (long)((InitProducerIdResult)newProducerOp.result().get()).producerId());
            return;
        }
        if (tuple2 != null) {
            Assert.fail((String)"One of two InitProducerId requests should succeed");
            return;
        }
        throw new MatchError(null);
    }

    private static final WriteTxnMarkersResponse createResponse$1(WriteTxnMarkersRequest request) {
        java.util.Map pidErrorMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(request.markers()).asScala()).map((Function1 & Serializable)marker -> new Tuple2((Object)marker.producerId(), JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(marker.partitions()).asScala()).map((Function1 & Serializable)tp -> new Tuple2(tp, (Object)Errors.NONE))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava();
        return new WriteTxnMarkersResponse(pidErrorMap);
    }

    public static final /* synthetic */ void $anonfun$enableCompletion$3(RequestAndCompletionHandler requestAndHandler) {
        WriteTxnMarkersResponse response = TransactionCoordinatorConcurrencyTest.createResponse$1((WriteTxnMarkersRequest)((WriteTxnMarkersRequest.Builder)requestAndHandler.request()).build());
        requestAndHandler.handler().onComplete(new ClientResponse(new RequestHeader(ApiKeys.PRODUCE, 0, "client", 1), null, null, 0L, 0L, false, null, null, (AbstractResponse)response));
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$3(TransactionCoordinatorConcurrencyTest $this, int x$10) {
        return new UnloadTxnPartitionAction($this, x$10);
    }

    public static final /* synthetic */ LoadTxnPartitionAction $anonfun$loadUnloadActions$6(TransactionCoordinatorConcurrencyTest $this, int x$13) {
        return new LoadTxnPartitionAction($this, x$13);
    }

    public static final /* synthetic */ UnloadTxnPartitionAction $anonfun$loadUnloadActions$7(TransactionCoordinatorConcurrencyTest $this, int x$14) {
        return new UnloadTxnPartitionAction($this, x$14);
    }

    public static final /* synthetic */ Transaction $anonfun$createTransactions$1(TransactionCoordinatorConcurrencyTest $this, String txnPrefix$1, int i) {
        return new Transaction(new StringBuilder(0).append(txnPrefix$1).append(i).toString(), i, $this.time());
    }

    public static final /* synthetic */ Option $anonfun$verifyTransaction$1(TransactionCoordinatorConcurrencyTest $this, Transaction txn$7) {
        $this.enableCompletion();
        return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn$7);
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$3(TransactionState expectedState$1, TransactionMetadata m) {
        TransactionState transactionState = m.state();
        return !(transactionState != null ? !transactionState.equals(expectedState$1) : expectedState$1 != null) && m.pendingState().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$verifyTransaction$2(TransactionState expectedState$1, Option metadata) {
        TransactionMetadata transactionMetadata;
        boolean bl;
        if (metadata == null) {
            throw null;
        }
        return metadata.isDefined() && (bl = metadata.isEmpty() || TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, transactionMetadata = (TransactionMetadata)metadata.get()));
    }

    public static final /* synthetic */ Nothing$ $anonfun$prepareTransaction$1(Transaction txn$8) {
        throw new IllegalStateException(new StringBuilder(22).append("Transaction not found ").append(txn$8).toString());
    }

    public static final /* synthetic */ long $anonfun$prepareTxnLog$1() {
        return 20L;
    }

    /*
     * WARNING - void declaration
     */
    public TransactionCoordinatorConcurrencyTest() {
        Tuple2 tuple2;
        void apply_elems;
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch = 10;
        Object[] objectArray = new TxnOperation[3];
        if (this.InitProducerIdOperation() == null) {
            throw null;
        }
        objectArray[0] = new InitProducerIdOperation(this, (Option<ProducerIdAndEpoch>)None$.MODULE$);
        scala.collection.immutable.Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic", 0)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        objectArray[1] = new AddPartitionsToTxnOperation(this, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)));
        objectArray[2] = new EndTxnOperation(this);
        this.allOperations = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions = (scala.collection.mutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        int n = 0;
        int until$extension_end = this.numPartitions();
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Tuple2 tuple22;
            Tuple2 tuple23 = tuple22 = TransactionCoordinatorConcurrencyTest.$anonfun$txnRecordsByPartition$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            tuple22 = null;
            tuple2 = tuple23;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            tuple2 = null;
        }
        Object var3_4 = null;
        Object var4_5 = null;
        Object var5_6 = null;
        tuple2 = null;
        this.txnRecordsByPartition = ((IndexedSeq)map_strictOptimizedMap_b.result()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        this.producerId = 11;
        this.bumpProducerId = false;
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentNewInitProducerIdRequests$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentInitProducerIdRequestsOneNewOneContinuing$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentContinuingInitProducerIdRequests$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentInitProducerIdRequestsWithRetry$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentInitProducerRequestsAtPidBoundary$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$testConcurrentInitProducerRequestsWithRetryAtPidBoundary$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(29).append("testConcurrentInitProducerID").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ scala.collection.immutable.Set $anonfun$loadUnloadActions$1$adapted(TransactionCoordinatorConcurrencyTest $this, Object i) {
        return $this.createTransactions(new StringBuilder(35).append("testConcurrentLoadUnloadPartitions").append(BoxesRunTime.unboxToInt((Object)i)).append("-").toString());
    }

    public static final /* synthetic */ Transaction $anonfun$createTransactions$1$adapted(TransactionCoordinatorConcurrencyTest $this, String txnPrefix$1, Object i) {
        return TransactionCoordinatorConcurrencyTest.$anonfun$createTransactions$1($this, txnPrefix$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$verifyTransaction$2$adapted(TransactionState expectedState$1, Option metadata) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$2(expectedState$1, metadata));
    }

    public static final /* synthetic */ Object $anonfun$verifyTransaction$3$adapted(TransactionState expectedState$1, TransactionMetadata m) {
        return BoxesRunTime.boxToBoolean((boolean)TransactionCoordinatorConcurrencyTest.$anonfun$verifyTransaction$3(expectedState$1, m));
    }

    public static final /* synthetic */ Tuple2 $anonfun$txnRecordsByPartition$1$adapted(Object i) {
        return TransactionCoordinatorConcurrencyTest.$anonfun$txnRecordsByPartition$1(BoxesRunTime.unboxToInt((Object)i));
    }

    public class AddPartitionsToTxnOperation
    extends TxnOperation<Errors> {
        private final scala.collection.immutable.Set<TopicPartition> partitions;

        public void run(Transaction txn) {
            Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                AddPartitionsToTxnOperation.$anonfun$run$2(this, txn, transactionMetadata);
            }
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw new IllegalStateException("AddPartitionsToTransaction has not completed");
            }
            Object var3_2 = null;
            Errors error = (Errors)getOrElse_this.get();
            Assert.assertEquals((Object)Errors.NONE, (Object)error);
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Ongoing$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$2(AddPartitionsToTxnOperation $this, Transaction txn$9, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$AddPartitionsToTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleAddPartitionsToTransaction(txn$9.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.partitions, (Function1 & Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$2() {
            throw new IllegalStateException("AddPartitionsToTransaction has not completed");
        }

        public AddPartitionsToTxnOperation(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<TopicPartition> partitions) {
            this.partitions = partitions;
            super($outer);
        }

        public static final /* synthetic */ Object $anonfun$run$2$adapted(AddPartitionsToTxnOperation $this, Transaction txn$9, TransactionMetadata txnMetadata) {
            AddPartitionsToTxnOperation.$anonfun$run$2($this, txn$9, txnMetadata);
            return BoxedUnit.UNIT;
        }
    }

    public class EndTxnOperation
    extends TxnOperation<Errors> {
        public void run(Transaction txn) {
            Option<TransactionMetadata> option = this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                EndTxnOperation.$anonfun$run$4(this, txn, transactionMetadata);
            }
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw new IllegalStateException("EndTransaction has not completed");
            }
            Object var5_2 = null;
            Errors error = (Errors)getOrElse_this.get();
            if (!txn.ended()) {
                txn.ended_$eq(true);
                Assert.assertEquals((Object)Errors.NONE, (Object)error);
                TransactionResult transactionResult = this.transactionResult(txn);
                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                CompleteCommit$ expectedState = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
                this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)expectedState);
                return;
            }
            Assert.assertEquals((Object)Errors.INVALID_TXN_STATE, (Object)error);
        }

        private TransactionResult transactionResult(Transaction txn) {
            int apply$extension_i;
            String txnId = txn.transactionalId();
            if (txnId.charAt(apply$extension_i = txnId.length() - 1) % 2 == 0) {
                return TransactionResult.COMMIT;
            }
            return TransactionResult.ABORT;
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$4(EndTxnOperation $this, Transaction txn$10, TransactionMetadata txnMetadata) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$EndTxnOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleEndTransaction(txn$10.transactionalId(), txnMetadata.producerId(), txnMetadata.producerEpoch(), $this.transactionResult(txn$10), (Function1 & Serializable)r -> {
                $this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$3() {
            throw new IllegalStateException("EndTransaction has not completed");
        }

        public EndTxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }

        public static final /* synthetic */ Object $anonfun$run$4$adapted(EndTxnOperation $this, Transaction txn$10, TransactionMetadata txnMetadata) {
            EndTxnOperation.$anonfun$run$4($this, txn$10, txnMetadata);
            return BoxedUnit.UNIT;
        }
    }

    public class ExpireTransactionsAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final scala.collection.immutable.Set<Transaction> transactions;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.transactions.foreach((Function1 & Serializable)txn -> {
                ExpireTransactionsAction.$anonfun$run$6(this, txn);
                return BoxedUnit.UNIT;
            });
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().enableTransactionalIdExpiration();
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().sleep(this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().removeExpiredTransactionalIdsIntervalMs() + 1);
        }

        @Override
        public void await() {
            boolean bl;
            long l = 15000L;
            long l2 = 100L;
            long computeUntilTrue_startTime = System.currentTimeMillis();
            while (true) {
                if (ExpireTransactionsAction.$anonfun$await$3(this)) {
                    bl = true;
                    break;
                }
                if (System.currentTimeMillis() > computeUntilTrue_startTime + l) {
                    bl = false;
                    break;
                }
                Thread.sleep(Math.min(l, l2));
            }
            Assert.assertTrue((String)"Transaction not expired", (boolean)bl);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$run$6(ExpireTransactionsAction $this, Transaction txn) {
            Option<TransactionMetadata> option = $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn);
            if (option == null) {
                throw null;
            }
            Option<TransactionMetadata> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                TransactionMetadata transactionMetadata = (TransactionMetadata)foreach_this.get();
                transactionMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
            }
        }

        public static final /* synthetic */ boolean $anonfun$await$4(ExpireTransactionsAction $this, Transaction txn) {
            return $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty();
        }

        public static final /* synthetic */ boolean $anonfun$await$3(ExpireTransactionsAction $this) {
            $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().replicaManager().tryCompleteDelayedRequests();
            return $this.transactions.forall((Function1 & Serializable)txn -> BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$4($this, txn)));
        }

        public static final /* synthetic */ boolean $anonfun$await$5(boolean x) {
            return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
        }

        public ExpireTransactionsAction(TransactionCoordinatorConcurrencyTest $outer, scala.collection.immutable.Set<Transaction> transactions) {
            this.transactions = transactions;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public static final /* synthetic */ Object $anonfun$await$5$adapted(Object x) {
            return BoxesRunTime.boxToBoolean((boolean)ExpireTransactionsAction.$anonfun$await$5(BoxesRunTime.unboxToBoolean((Object)x)));
        }

        public static final /* synthetic */ Object $anonfun$run$7$adapted(ExpireTransactionsAction $this, TransactionMetadata txnMetadata) {
            txnMetadata.txnLastUpdateTimestamp_$eq($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().time().milliseconds() - (long)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$ExpireTransactionsAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnConfig().transactionalIdExpirationMs());
            return BoxedUnit.UNIT;
        }
    }

    public class InitProducerIdOperation
    extends TxnOperation<InitProducerIdResult> {
        private final Option<ProducerIdAndEpoch> producerIdAndEpoch;

        public Option<ProducerIdAndEpoch> producerIdAndEpoch() {
            return this.producerIdAndEpoch;
        }

        public void run(Transaction txn) {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().handleInitProducerId(txn.transactionalId(), 60000, this.producerIdAndEpoch(), (Function1 & Serializable)r -> {
                this.resultCallback(r);
                return BoxedUnit.UNIT;
            });
        }

        public void awaitAndVerify(Transaction txn) {
            Option option = this.result();
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                throw new IllegalStateException("InitProducerId has not completed");
            }
            Object var3_2 = null;
            InitProducerIdResult initPidResult = (InitProducerIdResult)getOrElse_this.get();
            Assert.assertEquals((Object)Errors.NONE, (Object)initPidResult.error());
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)Empty$.MODULE$);
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$InitProducerIdOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public static final /* synthetic */ Nothing$ $anonfun$awaitAndVerify$1() {
            throw new IllegalStateException("InitProducerId has not completed");
        }

        public InitProducerIdOperation(TransactionCoordinatorConcurrencyTest $outer, Option<ProducerIdAndEpoch> producerIdAndEpoch) {
            this.producerIdAndEpoch = producerIdAndEpoch;
            super($outer);
        }
    }

    public class LoadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onElection(this.txnTopicPartitionId, this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch());
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable)txn -> {
                LoadTxnPartitionAction.$anonfun$await$1(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$1(LoadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                $this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$LoadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$verifyTransaction(txn, (TransactionState)CompleteCommit$.MODULE$);
            }
        }

        public LoadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    public static class Transaction
    implements AbstractCoordinatorConcurrencyTest.CoordinatorMember {
        private final String transactionalId;
        private final byte[] txnMessageKeyBytes;
        private volatile boolean ended;

        public String transactionalId() {
            return this.transactionalId;
        }

        public byte[] txnMessageKeyBytes() {
            return this.txnMessageKeyBytes;
        }

        public boolean ended() {
            return this.ended;
        }

        public void ended_$eq(boolean x$1) {
            this.ended = x$1;
        }

        public String toString() {
            return this.transactionalId();
        }

        public Transaction(String transactionalId, long producerId, MockTime time) {
            this.transactionalId = transactionalId;
            this.txnMessageKeyBytes = TransactionLog$.MODULE$.keyToBytes(transactionalId);
            this.ended = false;
        }
    }

    public abstract class TxnOperation<R>
    extends AbstractCoordinatorConcurrencyTest.Operation {
        private volatile Option<R> result = None$.MODULE$;

        public Option<R> result() {
            return this.result;
        }

        public void result_$eq(Option<R> x$1) {
            this.result = x$1;
        }

        public void resultCallback(R r) {
            this.result_$eq((Option<R>)new Some(r));
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$TxnOperation$$$outer() {
            return (TransactionCoordinatorConcurrencyTest)this.$outer;
        }

        public TxnOperation(TransactionCoordinatorConcurrencyTest $outer) {
            super($outer);
        }
    }

    public class UnloadTxnPartitionAction
    implements AbstractCoordinatorConcurrencyTest.Action {
        private final int txnTopicPartitionId;
        private final ArrayBuffer<SimpleRecord> txnRecords;
        public final /* synthetic */ TransactionCoordinatorConcurrencyTest $outer;

        public ArrayBuffer<SimpleRecord> txnRecords() {
            return this.txnRecords;
        }

        @Override
        public void run() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionCoordinator().onResignation(this.txnTopicPartitionId, (Option)new Some((Object)this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$coordinatorEpoch()));
        }

        @Override
        public void await() {
            this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$allTransactions().foreach((Function1 & Serializable)txn -> {
                UnloadTxnPartitionAction.$anonfun$await$2(this, txn);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ TransactionCoordinatorConcurrencyTest kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$await$2(UnloadTxnPartitionAction $this, Transaction txn) {
            if ($this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$txnStateManager().partitionFor(txn.transactionalId()) == $this.txnTopicPartitionId) {
                Assert.assertTrue((String)"Transaction metadata not removed", (boolean)$this.kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$UnloadTxnPartitionAction$$$outer().kafka$coordinator$transaction$TransactionCoordinatorConcurrencyTest$$transactionMetadata(txn).isEmpty());
            }
        }

        public UnloadTxnPartitionAction(TransactionCoordinatorConcurrencyTest $outer, int txnTopicPartitionId) {
            this.txnTopicPartitionId = txnTopicPartitionId;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.txnRecords = (ArrayBuffer)IterableFactory.apply$((IterableFactory)ArrayBuffer$.MODULE$, (scala.collection.immutable.Seq)Nil$.MODULE$);
        }
    }
}

