/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.common.LogCleaningAbortedException;
import kafka.log.AbortedTxn;
import kafka.log.AppendOrigin;
import kafka.log.CleanedTransactionMetadata;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.LogToClean;
import kafka.log.LogToClean$;
import kafka.log.OffsetMap;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.CoreUtils$;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.IntegralProxy;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011Ea\u0001\u00022d\u0001!DQa\u001c\u0001\u0005\u0002ADqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004~\u0001\u0001\u0006I!\u001e\u0005\b}\u0002\u0011\r\u0011\"\u0001u\u0011\u0019y\b\u0001)A\u0005k\"I\u0011\u0011\u0001\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\u0006!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\u0018!I\u0011q\u0004\u0001C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002$!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00026!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA-\u0001\u0011\u0005\u0011q\b\u0005\b\u0003G\u0002A\u0011AA \u0011\u001d\t9\u0007\u0001C\u0001\u0003\u007fAq!a\u001b\u0001\t\u0003\ty\u0004C\u0004\u0002p\u0001!\t!a\u0010\t\u000f\u0005M\u0004\u0001\"\u0001\u0002@!9\u0011q\u000f\u0001\u0005\u0002\u0005}\u0002bBA>\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u007f\u0002A\u0011AA \u0011\u001d\t\u0019\t\u0001C\u0001\u0003\u007fAq!a\"\u0001\t\u0003\ty\u0004C\u0004\u0002\f\u0002!\t!a\u0010\t\u000f\u0005=\u0005\u0001\"\u0001\u0002@!9\u00111\u0013\u0001\u0005\u0002\u0005}\u0002bBAL\u0001\u0011\u0005\u0011q\b\u0005\b\u00037\u0003A\u0011AA \u0011\u001d\ty\n\u0001C\u0001\u0003\u007fAq!a)\u0001\t\u0003\ty\u0004C\u0004\u0002(\u0002!\t!a\u0010\t\u000f\u0005-\u0006\u0001\"\u0001\u0002.\"9\u00111\u001a\u0001\u0005\u0002\u0005}\u0002bBAh\u0001\u0011\u0005\u0011q\b\u0005\b\u0003#\u0004A\u0011AA \u0011\u001d\t)\u000e\u0001C\u0001\u0003\u007fAq!!7\u0001\t\u0003\ty\u0004C\u0004\u0002^\u0002!\t!a\u0010\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002@!9\u0011Q\u001d\u0001\u0005\u0002\u0005}\u0002bBAu\u0001\u0011\u0005\u0011q\b\u0005\b\u0003[\u0004A\u0011AAx\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u000fAqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0018\u0001!\tA!\u0007\t\u000f\tu\u0001\u0001\"\u0001\u0003 !9!q\u0007\u0001\u0005\u0002\u0005}\u0002b\u0002B\u001e\u0001\u0011\u0005\u0011q\b\u0005\b\u0005\u007f\u0001A\u0011AA \u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003\u007fAqAa\u0012\u0001\t\u0013\u0011I\u0005C\u0004\u0003^\u0001!\t!a\u0010\t\u000f\t\u0005\u0004\u0001\"\u0001\u0002@!9!Q\r\u0001\u0005\u0002\u0005}\u0002b\u0002B5\u0001\u0011\u0005\u0011q\b\u0005\b\u0005[\u0002A\u0011AA \u0011\u001d\u0011\t\b\u0001C\u0001\u0003\u007fAqA!\u001e\u0001\t\u0003\ty\u0004C\u0004\u0003z\u0001!\t!a\u0010\t\u000f\tu\u0004\u0001\"\u0001\u0002@!9!\u0011\u0011\u0001\u0005\n\t\r\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0005\n\u0005g\u0003\u0011\u0013!C\u0005\u0005kCqAa3\u0001\t\u0013\u0011i\rC\u0004\u0003L\u0002!IAa:\t\u000f\t=\b\u0001\"\u0003\u0003r\"I!Q \u0001\u0012\u0002\u0013%!q \u0005\n\u0007\u0007\u0001\u0011\u0013!C\u0005\u0007\u000bA\u0011b!\u0003\u0001#\u0003%Iaa\u0003\t\u000f\r=\u0001\u0001\"\u0003\u0004\u0012!I11\u0006\u0001\u0012\u0002\u0013%1Q\u0006\u0005\n\u0007c\u0001\u0011\u0013!C\u0005\u0007gAqA!!\u0001\t\u0013\u00199\u0004C\u0004\u0003R\u0002!Iaa\u0010\t\u000f\tu\u0005\u0001\"\u0003\u0004R!I1Q\u000e\u0001\u0012\u0002\u0013%11\u0002\u0005\n\u0007_\u0002\u0011\u0013!C\u0005\u0007cB\u0011b!\u001e\u0001#\u0003%Iaa\r\t\u0013\r]\u0004!%A\u0005\n\rM\u0002bBB=\u0001\u0011%11\u0010\u0005\n\u00077\u0003\u0011\u0013!C\u0005\u0007gA\u0011b!(\u0001#\u0003%Iaa(\t\u000f\r\r\u0006\u0001\"\u0003\u0004&\"I11\u0018\u0001\u0012\u0002\u0013%1Q\u0018\u0005\n\u0007\u0003\u0004\u0011\u0013!C\u0005\u0007gA\u0011ba1\u0001#\u0003%Iaa(\t\u000f\r\u0015\u0007\u0001\"\u0003\u0004H\"I1\u0011\u001b\u0001\u0012\u0002\u0013%11\u0002\u0005\b\u0007'\u0004A\u0011BBk\u0011%\u0019i\u000eAI\u0001\n\u0013\u0019Y\u0001C\u0004\u0004`\u0002!Ia!9\t\u000f\tu\u0005\u0001\"\u0003\u0004v\"911 \u0001\u0005\n\ru\bb\u0002C\u0001\u0001\u0011%A1\u0001\u0005\b\t\u000f\u0001A\u0011\u0002C\u0005\u00059aunZ\"mK\u0006tWM\u001d+fgRT!\u0001Z3\u0002\u00071|wMC\u0001g\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A5\u0011\u0005)lW\"A6\u000b\u00031\fQa]2bY\u0006L!A\\6\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0011\u000f\u0005\u0002s\u00015\t1-\u0001\u0004u[B$\u0017N]\u000b\u0002kB\u0011ao_\u0007\u0002o*\u0011\u00010_\u0001\u0003S>T\u0011A_\u0001\u0005U\u00064\u0018-\u0003\u0002}o\n!a)\u001b7f\u0003\u001d!X\u000e\u001d3je\u0002\n1\u0001Z5s\u0003\u0011!\u0017N\u001d\u0011\u0002\u00111|w\r\u0015:paN,\"!!\u0002\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003z\u0003\u0011)H/\u001b7\n\t\u0005=\u0011\u0011\u0002\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\u00037pOB\u0013x\u000e]:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002\u0018A\u0019!/!\u0007\n\u0007\u0005m1MA\u0005M_\u001e\u001cuN\u001c4jO\u0006QAn\\4D_:4\u0017n\u001a\u0011\u0002\tQLW.Z\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S)\u0017!B;uS2\u001c\u0018\u0002BA\u0017\u0003O\u0011\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\ni\"\u0014x\u000e\u001e;mKJ,\"!!\u000e\u0011\t\u0005\u0015\u0012qG\u0005\u0005\u0003s\t9CA\u0005UQJ|G\u000f\u001e7fe\u0006QA\u000f\u001b:piRdWM\u001d\u0011\u0002\u0011Q,\u0017M\u001d3po:$\"!!\u0011\u0011\u0007)\f\u0019%C\u0002\u0002F-\u0014A!\u00168ji\"\u001aa\"!\u0013\u0011\t\u0005-\u0013QK\u0007\u0003\u0003\u001bRA!a\u0014\u0002R\u0005)!.\u001e8ji*\u0011\u00111K\u0001\u0004_J<\u0017\u0002BA,\u0003\u001b\u0012Q!\u00114uKJ\f\u0011\u0003^3ti\u000ecW-\u00198TK\u001elWM\u001c;tQ\ry\u0011Q\f\t\u0005\u0003\u0017\ny&\u0003\u0003\u0002b\u00055#\u0001\u0002+fgR\fa\u0006^3ti\u000ecW-\u00198TK\u001elWM\u001c;t/&$\bnQ8oGV\u0014(/\u001a8u'\u0016<W.\u001a8u\t\u0016dW\r^5p]\"\u001a\u0001#!\u0018\u0002_Q,7\u000f^*ju\u0016$&/[7nK\u00124uN\u001d)sK\u0006dGn\\2bi\u0016$\u0017I\u001c3D_6\u0004\u0018m\u0019;fIR{\u0007/[2)\u0007E\ti&A\u0010uKN$H)\u001e9mS\u000e\fG/Z\"iK\u000e\\\u0017I\u001a;fe\u000ecW-\u00198j]\u001eD3AEA/\u0003\u0005\"Xm\u001d;CCNL7\r\u0016:b]N\f7\r^5p]\u0006;\u0018M]3DY\u0016\fg.\u001b8hQ\r\u0019\u0012QL\u0001*i\u0016\u001cHo\u00117fC:<\u0016\u000e\u001e5Ue\u0006t7/Y2uS>t7o\u00159b]:LgnZ*fO6,g\u000e^:)\u0007Q\ti&A\fuKN$8i\\7nSRl\u0015M]6feJ+Wn\u001c<bY\"\u001aQ#!\u0018\u0002IQ,7\u000f\u001e#fY\u0016$X\r\u001a\"bi\u000eDWm],ji\"tu.T3tg\u0006<Wm\u001d*fC\u0012D3AFA/\u0003\u001d\"Xm\u001d;D_6l\u0017\u000e^'be.,'OU3uK:$\u0018n\u001c8XSRDW)\u001c9us\n\u000bGo\u00195)\u0007]\ti&\u0001\u000euKN$8\t\\3b]\u0016k\u0007\u000f^=D_:$(o\u001c7CCR\u001c\u0007\u000eK\u0002\u0019\u0003;\n\u0001\u0006^3ti\u000e{W.\\5ui\u0016$GK]1og\u0006\u001cG/[8o'B\fgN\\5oON+w-\\3oiND3!GA/\u0003\u0019\"Xm\u001d;BE>\u0014H/\u001a3Ue\u0006t7/Y2uS>t7\u000b]1o]&twmU3h[\u0016tGo\u001d\u0015\u00045\u0005u\u0013A\u0006;fgR\f%m\u001c:u\u001b\u0006\u00148.\u001a:SK6|g/\u00197)\u0007m\ti&\u0001\u0014uKN$X)\u001c9us\n\u000bGo\u00195SK6|g/\u00197XSRD7+Z9vK:\u001cWMU3vg\u0016D3\u0001HA/\u0003\u0019\"Xm\u001d;BE>\u0014H/T1sW\u0016\u0014(+\u001a;f]RLwN\\,ji\",U\u000e\u001d;z\u0005\u0006$8\r\u001b\u0015\u0004;\u0005u\u0013\u0001\u0005;fgRd\u0015M]4f\u001b\u0016\u001c8/Y4fQ\rq\u0012QL\u0001$i\u0016\u001cH/T3tg\u0006<W\rT1sO\u0016\u0014H\u000b[1o\u001b\u0006DX*Z:tC\u001e,7+\u001b>fQ\ry\u0012QL\u00015i\u0016\u001cH/T3tg\u0006<W\rT1sO\u0016\u0014H\u000b[1o\u001b\u0006DX*Z:tC\u001e,7+\u001b>f/&$\bnQ8seV\u0004H\u000fS3bI\u0016\u0014\bf\u0001\u0011\u0002^\u0005qC/Z:u\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4f'&TX\rT1sO\u0016\u0014H\u000b[1o\u0005f$Xm]!wC&d\u0017M\u00197fQ\r\t\u0013QL\u0001'GJ,\u0017\r^3M_\u001e<\u0016\u000e\u001e5NKN\u001c\u0018mZ3t\u0019\u0006\u0014x-\u001a:UQ\u0006tW*\u0019=TSj,G\u0003BAX\u0003\u0003\u0004rA[AY\u0003k\u000bY,C\u0002\u00024.\u0014a\u0001V;qY\u0016\u0014\u0004c\u0001:\u00028&\u0019\u0011\u0011X2\u0003\u00071{w\rE\u0002s\u0003{K1!a0d\u000551\u0015m[3PM\u001a\u001cX\r^'ba\"9\u00111\u0019\u0012A\u0002\u0005\u0015\u0017\u0001\u00057be\u001e,W*Z:tC\u001e,7+\u001b>f!\rQ\u0017qY\u0005\u0004\u0003\u0013\\'aA%oi\u00069B/Z:u\u00072,\u0017M\\5oO^KG\u000f\u001b#fY\u0016$Xm\u001d\u0015\u0004G\u0005u\u0013a\u0005;fgRdunZ\"mK\u0006tWM]*uCR\u001c\u0018!\u000b;fgRdunZ\"mK\u0006tWM\u001d*fi\u0006Lgn\u001d)s_\u0012,8-\u001a:MCN$8+Z9vK:\u001cW\rK\u0002&\u0003;\n\u0011\b^3ti2{wm\u00117fC:,'OU3uC&t7\u000fT1tiN+\u0017/^3oG\u0016,e/\u001a8JMR\u0013\u0018M\\:bGRLwN\\!c_J$X\r\u001a\u0015\u0004M\u0005u\u0013a\u0006;fgR\u0004\u0016M\u001d;jC2\u001cVmZ7f]R\u001cE.Z1oQ\r9\u0013QL\u0001#i\u0016\u001cHo\u00117fC:LgnZ,ji\",fn\u00197fC:\f'\r\\3TK\u000e$\u0018n\u001c8)\u0007!\ni&\u0001\buKN$Hj\\4U_\u000ecW-\u00198)\u0007%\ni&\u0001\u0013uKN$Hj\\4U_\u000ecW-\u00198XSRDWK\\2mK\u0006t\u0017M\u00197f'\u0016\u001cG/[8oQ\rQ\u0013QL\u0001 i\u0016\u001cHo\u00117fC:LgnZ,ji\",fn[3zK\u0012lUm]:bO\u0016\u001c\bfA\u0016\u0002^\u0005AB.Y:u\u001f\u001a47/\u001a;t!\u0016\u0014()\u0019;dQ&sGj\\4\u0015\t\u0005E(1\u0001\t\u0007\u0003g\fI0!@\u000e\u0005\u0005U(bAA|W\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005m\u0018Q\u001f\u0002\t\u0013R,'/\u00192mKB\u0019!.a@\n\u0007\t\u00051N\u0001\u0003M_:<\u0007B\u00023-\u0001\u0004\t),\u0001\nmCN$8+Z9vK:\u001cWm]%o\u0019><G\u0003\u0002B\u0005\u0005\u001f\u0001\u0002\"a=\u0003\f\u0005u\u0018QY\u0005\u0005\u0005\u001b\t)PA\u0002NCBDa\u0001Z\u0017A\u0002\u0005U\u0016\u0001D8gMN,Go]%o\u0019><G\u0003BAy\u0005+Aa\u0001\u001a\u0018A\u0002\u0005U\u0016\u0001G;oW\u0016LX\rZ'fgN\fw-Z\"pk:$\u0018J\u001c'pOR!\u0011Q\u0019B\u000e\u0011\u0019!w\u00061\u0001\u00026\u0006q\u0011MY8si\u000eCWmY6E_:,G\u0003BA!\u0005CAqAa\t1\u0001\u0004\u0011)#\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\t\t\u001d\"1G\u0007\u0003\u0005SQAAa\u000b\u0003.\u000511m\\7n_:T1A\u001aB\u0018\u0015\u0011\u0011\t$!\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\u0011)D!\u000b\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006QB/Z:u\u00072,\u0017M\\*fO6,g\u000e^:XSRD\u0017IY8si\"\u001a\u0011'!\u0018\u0002'Q,7\u000f^*fO6,g\u000e^$s_V\u0004\u0018N\\4)\u0007I\ni&\u0001\u0013uKN$8+Z4nK:$xI]8va&twmV5uQN\u0003\u0018M]:f\u001f\u001a47/\u001a;tQ\r\u0019\u0014QL\u0001,i\u0016\u001cHoU3h[\u0016tGo\u0012:pkBLgn\u001a$pY2|w/\u001b8h\u0019>\fGm\u00144[KJ|\u0017J\u001c3fq\"\u001aA'!\u0018\u0002#\rDWmY6TK\u001elWM\u001c;Pe\u0012,'\u000f\u0006\u0003\u0002B\t-\u0003b\u0002B'k\u0001\u0007!qJ\u0001\u0007OJ|W\u000f]:\u0011\r\u0005M(\u0011\u000bB+\u0013\u0011\u0011\u0019&!>\u0003\u0007M+\u0017\u000f\u0005\u0004\u0002t\nE#q\u000b\t\u0004e\ne\u0013b\u0001B.G\nQAj\\4TK\u001elWM\u001c;\u0002%Q,7\u000f\u001e\"vS2$wJ\u001a4tKRl\u0015\r\u001d\u0015\u0004m\u0005u\u0013!\b;fgR\u001cVmZ7f]R<\u0016\u000e\u001e5PM\u001a\u001cX\r^(wKJ4Gn\\<)\u0007]\ni&\u0001\fuKN$(+Z2pm\u0016\u0014\u00180\u00114uKJ\u001c%/Y:iQ\rA\u0014QL\u0001\u001ci\u0016\u001cHOQ;jY\u0012|eMZ:fi6\u000b\u0007OR1lK2\u000b'oZ3)\u0007e\ni&A\ruKN$()^5mIB\u000b'\u000f^5bY>3gm]3u\u001b\u0006\u0004\bf\u0001\u001e\u0002^\u0005QB/Z:u\u00072,\u0017M\\\"peJ,\b\u000f^'fgN\fw-Z*fi\"\u001a1(!\u0018\u0002KQ,7\u000f^\"mS\u0016tG\u000fS1oI2LgnZ(g\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4f'\u0016$\bf\u0001\u001f\u0002^\u0005\u0011B/Z:u\u00072,\u0017M\u001c+p[\n\u001cHo\u001c8fQ\ri\u0014QL\u0001!i\u0016\u001cHo\u00117fC:Lgn\u001a\"fs>tG-T5tg&twm\u00144gg\u0016$8\u000fK\u0002?\u0003;\n!b\u001e:ji\u0016$v\u000eT8h)!\t\tP!\"\u0003\b\n=\u0005B\u00023@\u0001\u0004\t)\fC\u0004\u0003\n~\u0002\rAa#\u0002\u001b-,\u0017p]!oIZ\u000bG.^3t!\u0019\t\u00190!?\u0003\u000eB9!.!-\u0002F\u0006\u0015\u0007b\u0002BI\u007f\u0001\u0007\u0011\u0011_\u0001\n_\u001a47/\u001a;TKF\fQ#\u001b8wC2LGm\u00117fC:,G-T3tg\u0006<W\r\u0006\u0005\u0003\u0018\n\r&q\u0015BU!\u0011\u0011IJa(\u000e\u0005\tm%\u0002\u0002BO\u0005S\taA]3d_J$\u0017\u0002\u0002BQ\u00057\u0013Q\"T3n_JL(+Z2pe\u0012\u001c\bb\u0002BS\u0001\u0002\u0007\u0011Q`\u0001\u000eS:LG/[1m\u001f\u001a47/\u001a;\t\u000f\t%\u0005\t1\u0001\u0003\f\"I!1\u0016!\u0011\u0002\u0003\u0007!QV\u0001\u0006G>$Wm\u0019\t\u0005\u00053\u0013y+\u0003\u0003\u00032\nm%aD\"p[B\u0014Xm]:j_:$\u0016\u0010]3\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u00038*\"!Q\u0016B]W\t\u0011Y\f\u0005\u0003\u0003>\n\u001dWB\u0001B`\u0015\u0011\u0011\tMa1\u0002\u0013Ut7\r[3dW\u0016$'b\u0001BcW\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t%'q\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!E7fgN\fw-Z,ji\"|eMZ:fiRA!q\u0013Bh\u0005?\u0014\u0019\u000fC\u0004\u0003R\n\u0003\rAa5\u0002\u0007-,\u0017\u0010E\u0003k\u0005+\u0014I.C\u0002\u0003X.\u0014Q!\u0011:sCf\u00042A\u001bBn\u0013\r\u0011in\u001b\u0002\u0005\u0005f$X\rC\u0004\u0003b\n\u0003\rAa5\u0002\u000bY\fG.^3\t\u000f\t\u0015(\t1\u0001\u0002~\u00061qN\u001a4tKR$\u0002Ba&\u0003j\n-(Q\u001e\u0005\b\u0005#\u001c\u0005\u0019AAc\u0011\u001d\u0011\to\u0011a\u0001\u0003\u000bDqA!:D\u0001\u0004\ti0A\u0004nC.,Gj\\4\u0015\u0011\u0005U&1\u001fB{\u0005sDqA #\u0011\u0002\u0003\u0007Q\u000fC\u0005\u0003x\u0012\u0003\n\u00111\u0001\u0002\u0018\u000511m\u001c8gS\u001eD\u0011Ba?E!\u0003\u0005\r!!@\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$H%M\u000b\u0003\u0007\u0003Q3!\u001eB]\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$HEM\u000b\u0003\u0007\u000fQC!a\u0006\u0003:\u0006\tR.Y6f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\r5!\u0006BA\u007f\u0005s\u000b1\"\\1lK\u000ecW-\u00198feRA11CB\r\u0007;\u00199\u0003E\u0002s\u0007+I1aa\u0006d\u0005\u001d\u0019E.Z1oKJDqaa\u0007I\u0001\u0004\t)-\u0001\u0005dCB\f7-\u001b;z\u0011%\u0019y\u0002\u0013I\u0001\u0002\u0004\u0019\t#A\u0005dQ\u0016\u001c7\u000eR8oKB9!na\t\u0003&\u0005\u0005\u0013bAB\u0013W\nIa)\u001e8di&|g.\r\u0005\n\u0007SA\u0005\u0013!a\u0001\u0003\u000b\fa\"\\1y\u001b\u0016\u001c8/Y4f'&TX-A\u000bnC.,7\t\\3b]\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r=\"\u0006BB\u0011\u0005s\u000bQ#\\1lK\u000ecW-\u00198fe\u0012\"WMZ1vYR$3'\u0006\u0002\u00046)\"\u0011Q\u0019B])\u0019\t\tp!\u000f\u0004<!1Am\u0013a\u0001\u0003kCqa!\u0010L\u0001\u0004\u0011Y)A\u0002tKF$Ba!\u0011\u0004NA!11IB%\u001b\t\u0019)EC\u0002\u0004He\f1A\\5p\u0013\u0011\u0019Ye!\u0012\u0003\u0015\tKH/\u001a\"vM\u001a,'\u000fC\u0004\u0004P1\u0003\r!!@\u0002\u0005%$GC\u0004BL\u0007'\u001a)fa\u0016\u0004\\\r\u00154\u0011\u000e\u0005\b\u0005#l\u0005\u0019AAc\u0011\u001d\u0011\t/\u0014a\u0001\u0003\u000bD\u0011b!\u0017N!\u0003\u0005\r!!@\u0002\u0015A\u0014x\u000eZ;dKJLE\rC\u0005\u0004^5\u0003\n\u00111\u0001\u0004`\u0005i\u0001O]8ek\u000e,'/\u00129pG\"\u00042A[B1\u0013\r\u0019\u0019g\u001b\u0002\u0006'\"|'\u000f\u001e\u0005\n\u0007Oj\u0005\u0013!a\u0001\u0003\u000b\f\u0001b]3rk\u0016t7-\u001a\u0005\n\u0007Wj\u0005\u0013!a\u0001\u0003\u000b\fA\u0003]1si&$\u0018n\u001c8MK\u0006$WM]#q_\u000eD\u0017\u0001\u0005:fG>\u0014H\r\n3fM\u0006,H\u000e\u001e\u00134\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$C'\u0006\u0002\u0004t)\"1q\fB]\u0003A\u0011XmY8sI\u0012\"WMZ1vYR$S'\u0001\tsK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%m\u0005Y\u0012\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u001bH*Z1eKJ$Bb! \u0004\b\u000e%51RBG\u0007#\u0003rA[B\u0012\u0007\u007f\u001a\t\t\u0005\u0004\u0002t\nE\u0013Q\u0019\t\u0004e\u000e\r\u0015bABCG\niAj\\4BaB,g\u000eZ%oM>Da\u0001\u001a*A\u0002\u0005U\u0006bBB-%\u0002\u0007\u0011Q \u0005\b\u0007;\u0012\u0006\u0019AB0\u0011%\u0019yI\u0015I\u0001\u0002\u0004\t)-A\u0006mK\u0006$WM]#q_\u000eD\u0007\"CBJ%B\u0005\t\u0019ABK\u0003\u0019y'/[4j]B\u0019!oa&\n\u0007\re5M\u0001\u0007BaB,g\u000eZ(sS\u001eLg.A\u0013baB,g\u000e\u001a+sC:\u001c\u0018m\u0019;j_:\fG.Q:MK\u0006$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005)\u0013\r\u001d9f]\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0006\u001bH*Z1eKJ$C-\u001a4bk2$H%N\u000b\u0003\u0007CSCa!&\u0003:\u0006A\u0012\r\u001d9f]\u0012LE-Z7q_R,g\u000e^!t\u0019\u0016\fG-\u001a:\u0015\u001d\ru4qUBU\u0007W\u001bika.\u0004:\"1A-\u0016a\u0001\u0003kCqa!\u0017V\u0001\u0004\ti\u0010C\u0004\u0004^U\u0003\raa\u0018\t\u0013\r=V\u000b%AA\u0002\rE\u0016aD5t)J\fgn]1di&|g.\u00197\u0011\u0007)\u001c\u0019,C\u0002\u00046.\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0004\u0010V\u0003\n\u00111\u0001\u0002F\"I11S+\u0011\u0002\u0003\u00071QS\u0001#CB\u0004XM\u001c3JI\u0016l\u0007o\u001c;f]R\f5\u000fT3bI\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r}&\u0006BBY\u0005s\u000b!%\u00199qK:$\u0017\nZ3na>$XM\u001c;Bg2+\u0017\rZ3sI\u0011,g-Y;mi\u0012*\u0014AI1qa\u0016tG-\u00133f[B|G/\u001a8u\u0003NdU-\u00193fe\u0012\"WMZ1vYR$c'\u0001\u0007d_6l\u0017\u000e^'be.,'\u000f\u0006\u0005\u0003\u0018\u000e%71ZBg\u0011\u001d\u0019I&\u0017a\u0001\u0003{Dqa!\u0018Z\u0001\u0004\u0019y\u0006C\u0005\u0004Pf\u0003\n\u00111\u0001\u0002~\u0006IA/[7fgR\fW\u000e]\u0001\u0017G>lW.\u001b;NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%g\u0005Y\u0011MY8si6\u000b'o[3s)!\u00119ja6\u0004Z\u000em\u0007bBB-7\u0002\u0007\u0011Q \u0005\b\u0007;Z\u0006\u0019AB0\u0011%\u0019ym\u0017I\u0001\u0002\u0004\ti0A\u000bbE>\u0014H/T1sW\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0002\u0019\u0015tG\r\u0016=o\u001b\u0006\u00148.\u001a:\u0015\u0019\t]51]Bs\u0007O\u001c\tpa=\t\u000f\reS\f1\u0001\u0002~\"91QL/A\u0002\r}\u0003bBBu;\u0002\u000711^\u0001\u0012G>tGO]8m%\u0016\u001cwN\u001d3UsB,\u0007\u0003\u0002BM\u0007[LAaa<\u0003\u001c\n\t2i\u001c8ue>d'+Z2pe\u0012$\u0016\u0010]3\t\u000f\t\u0015X\f1\u0001\u0002~\"91qZ/A\u0002\u0005uHC\u0002BL\u0007o\u001cI\u0010C\u0004\u0003Rz\u0003\r!!2\t\u000f\t\u0005h\f1\u0001\u0003T\u0006iQO\\6fs\u0016$'+Z2pe\u0012$BAa&\u0004\u0000\"9!\u0011]0A\u0002\u0005\u0015\u0017a\u0004;p[\n\u001cHo\u001c8f%\u0016\u001cwN\u001d3\u0015\t\t]EQ\u0001\u0005\b\u0005#\u0004\u0007\u0019AAc\u0003=\u0011XmY8wKJ\fe\u000eZ\"iK\u000e\\GCBA[\t\u0017!i\u0001C\u0004\u0003x\u0006\u0004\r!a\u0006\t\u000f\u0011=\u0011\r1\u0001\u0002r\u0006aQ\r\u001f9fGR,GmS3zg\u0002")
public class LogCleanerTest {
    private final File tmpdir = TestUtils.tempDirectory(null, null);
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$22 = file2;
        long l = 0L;
        Log log = this.makeLog(x$22, x$12, l);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assert.assertEquals((Object)IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)log.logEndOffset()), keysFound);
        ListSet keys = (ListSet)IterableFactory.apply$((IterableFactory)ListSet$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        scala.collection.immutable.Seq segments = ((IterableOnceOps)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        int expectedBytesRead = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)segments.map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, (Seq)segments, (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$2 -> !keys.contains((Object)x$2))), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testCleanSegmentsWithConcurrentSegmentDeletion() {
        CountDownLatch deleteStartLatch = new CountDownLatch(1);
        CountDownLatch deleteCompleteLatch = new CountDownLatch(1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), new StringBuilder(1).append(LogConfig$.MODULE$.Compact()).append(",").append(LogConfig$.MODULE$.Delete()).toString());
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(this.dir());
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, this.dir(), 3600000);
        Log log = new Log(this, logProps, topicPartition, producerStateManager, deleteStartLatch, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void replaceSegments(Seq<LogSegment> newSegments, Seq<LogSegment> oldSegments, boolean isRecoveredSwapFile) {
                this.deleteStartLatch$1.countDown();
                if (!this.deleteCompleteLatch$1.await(5000L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalStateException("Log segment deletion timed out");
                }
                super.replaceSegments(newSegments, oldSegments, isRecoveredSwapFile);
            }

            public boolean replaceSegments$default$3() {
                return false;
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
                super($outer.dir(), LogConfig$.MODULE$.fromProps($outer.logConfig().originals(), logProps$1), 0L, 0L, (Scheduler)$outer.time().scheduler(), new BrokerTopicStats(), (Time)$outer.time(), 3600000, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition$1, producerStateManager$1, new LogDirFailureChannel(10));
            }
        };
        new Thread(null, deleteStartLatch, log, deleteCompleteLatch){
            private final CountDownLatch deleteStartLatch$1;
            private final Log log$1;
            private final CountDownLatch deleteCompleteLatch$1;

            public void run() {
                this.deleteStartLatch$1.await(5000L, TimeUnit.MILLISECONDS);
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.maybeIncrementLogStartOffset(this.log$1.activeSegment().baseOffset());
                this.log$1.updateHighWatermark(this.log$1.activeSegment().baseOffset());
                this.log$1.deleteOldSegments();
                this.deleteCompleteLatch$1.countDown();
            }
            {
                this.deleteStartLatch$1 = deleteStartLatch$1;
                this.log$1 = log$1;
                this.deleteCompleteLatch$1 = deleteCompleteLatch$1;
            }
        }.start();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record(0, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
            log.roll(log.roll$default$1());
        }
        Assert.assertEquals((long)3L, (long)log.numberOfSegments());
        FileRecords firstLogFile = ((LogSegment)log.logSegments().head()).log();
        String expectedFileName = CoreUtils$.MODULE$.replaceSuffix(firstLogFile.file().getPath(), "", Log$.MODULE$.DeletedFileSuffix());
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        scala.collection.immutable.Seq segments = log.logSegments(0L, log.activeSegment().baseOffset()).toSeq();
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.buildOffsetMap(log, 0L, log.activeSegment().baseOffset(), (OffsetMap)offsetMap, stats);
        cleaner.cleanSegments(log, (Seq)segments, (OffsetMap)offsetMap, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)expectedFileName, (Object)firstLogFile.file().getPath());
        Assert.assertEquals((long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testSizeTrimmedForPreallocatedAndCompactedTopic() {
        File file;
        int originalMaxFileSize = 1024;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)originalMaxFileSize);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), "compact");
        logProps.put(LogConfig$.MODULE$.PreAllocateEnableProp(), "true");
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assert.assertTrue((String)"Cleaned segment file should be trimmed to its real size.", (((LogSegment)log.logSegments().iterator().next()).log().channel().size() < (long)originalMaxFileSize ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDuplicateCheckAfterCleaning() {
        File file;
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        void $minus$greater$extension_y3;
        Integer n3;
        void $minus$greater$extension_y4;
        Integer n4;
        File file2;
        void $minus$greater$extension_y5;
        Integer n5;
        void $minus$greater$extension_y6;
        Integer n6;
        void $minus$greater$extension_y7;
        Integer n7;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)2048);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        long x$3 = this.makeLog$default$3();
        Log log = this.makeLog(x$2, x$1, x$3);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        int pid4 = 4;
        this.appendIdempotentAsLeader(log, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        this.appendIdempotentAsLeader(log, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        this.appendIdempotentAsLeader(log, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Option x$4 = log.roll$default$1();
        log.roll(x$4);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 5, 7})), this.lastOffsetsPerBatchInLog(log));
        Object[] objectArray = new Tuple2[3];
        Integer n8 = n7 = Integer.valueOf(2);
        n7 = null;
        Integer n9 = n8;
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)pid1);
        Object var15_15 = null;
        n9 = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y7);
        Integer n10 = n6 = Integer.valueOf(2);
        n6 = null;
        Integer n11 = n10;
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)pid2);
        Object var17_18 = null;
        n11 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y6);
        Integer n12 = n5 = Integer.valueOf(1);
        n5 = null;
        Integer n13 = n12;
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)pid3);
        Object var19_21 = null;
        n13 = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y5);
        Assert.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1, 4})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 6, 7})), this.offsetsInLog(log));
        log.close();
        LogConfig reloadLog$1_x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file3 = file2 = this.dir();
        file2 = null;
        File reloadLog$1_x$3 = file3;
        log = this.makeLog(reloadLog$1_x$3, reloadLog$1_x$1, 0L);
        Object var29_22 = null;
        Object var30_24 = null;
        LogAppendInfo logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid3, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4})));
        Assert.assertEquals((long)6L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)7L, (long)logAppendInfo.lastOffset());
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid2, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4})));
        Assert.assertEquals((long)3L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)5L, (long)logAppendInfo.lastOffset());
        this.appendIdempotentAsLeader(log, pid4, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        Option x$5 = log.roll$default$1();
        log.roll(x$5);
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), LogToClean$.MODULE$.apply$default$5()));
        Object[] objectArray2 = new Tuple2[4];
        Integer n14 = n4 = Integer.valueOf(2);
        n4 = null;
        Integer n15 = n14;
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)pid1);
        Object var21_29 = null;
        n15 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        Integer n16 = n3 = Integer.valueOf(2);
        n3 = null;
        Integer n17 = n16;
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)pid2);
        Object var23_32 = null;
        n17 = null;
        objectArray2[1] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y3);
        Integer n18 = n2 = Integer.valueOf(1);
        n2 = null;
        Integer n19 = n18;
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)pid3);
        Object var25_35 = null;
        n19 = null;
        objectArray2[2] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y2);
        Integer n20 = n = Integer.valueOf(0);
        n = null;
        Integer n21 = n20;
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)pid4);
        Object var27_38 = null;
        n21 = null;
        objectArray2[3] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 5, 7, 8})), this.lastOffsetsPerBatchInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 1, 4, 2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8})), this.offsetsInLog(log));
        log.close();
        LogConfig reloadLog$1_x$12 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file4 = file = this.dir();
        file = null;
        File reloadLog$1_x$32 = file4;
        log = this.makeLog(reloadLog$1_x$32, reloadLog$1_x$12, 0L);
        Object var32_39 = null;
        Object var33_41 = null;
        logAppendInfo = (LogAppendInfo)this.appendIdempotentAsLeader(log, pid1, producerEpoch, this.appendIdempotentAsLeader$default$4(), this.appendIdempotentAsLeader$default$5(), this.appendIdempotentAsLeader$default$6()).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)logAppendInfo.firstOffset().get()));
        Assert.assertEquals((long)2L, (long)logAppendInfo.lastOffset());
    }

    @Test
    public void testBasicTransactionAwareCleaning() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)2048);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(pid2, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(pid1, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        List abortedTransactions = log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)abortedTransactions, (Object)log.collectAbortedTransactions(log.logStartOffset(), log.logEndOffset()));
    }

    @Test
    public void testCleanWithTransactionsSpanningSegments() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        int pid1 = 1;
        int pid2 = 2;
        int pid3 = 3;
        Function1<Seq<Object>, LogAppendInfo> appendProducer1 = this.appendTransactionalAsLeader(log, pid1, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer2 = this.appendTransactionalAsLeader(log, pid2, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> appendProducer3 = this.appendTransactionalAsLeader(log, pid3, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6})));
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{6, 7})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{7, 8})));
        log.appendAsLeader(this.abortMarker(pid2, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer3.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{8, 9})));
        log.appendAsLeader(this.commitMarker(pid3, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9, 10})));
        log.appendAsLeader(this.abortMarker(pid1, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        long dirtyOffset = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false))._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10})), LogTest$.MODULE$.keysInLog(log));
        log.roll(log.roll$default$1());
        appendProducer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{11})));
        appendProducer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{12})));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, dirtyOffset, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 6, 7, 8, 9, 11, 12})), LogTest$.MODULE$.keysInLog(log));
    }

    @Test
    public void testCommitMarkerRemoval() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)256);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3, 4, 5})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5, 6, 7, 8})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 1, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8})), this.offsetsInLog(log));
    }

    @Test
    public void testDeletedBatchesWithNoMessagesRead() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 100);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)100);
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1000);
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$5 = file2;
        long l = 0L;
        Log log = this.makeLog(x$5, x$4, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCommitMarkerRetentionWithEmptyBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)256);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        Function1<Seq<Object>, LogAppendInfo> producer1 = this.appendTransactionalAsLeader(log, 1L, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Function1<Seq<Object>, LogAppendInfo> producer2 = this.appendTransactionalAsLeader(log, 2L, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        producer1.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.roll(log.roll$default$1());
        producer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5, 6, 7})), this.lastOffsetsPerBatchInLog(log));
        producer2.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(2L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 4, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 6, 7, 8, 9})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5, 6, 7, 8, 9})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCleanEmptyControlBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)256);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        log.appendAsLeader(this.commitMarker(1L, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testCommittedTransactionSpanningSegments() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)128);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortedTransactionSpanningSegments() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)128);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRemoval() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)256);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), 0L)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testEmptyBatchRemovalWithSequenceReuse() {
        File file;
        short producerEpoch = (short)0;
        long producerId = 1L;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)2048);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        int n = 0;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, n, (AppendOrigin)x$7).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        AppendOrigin.Replication$ x$12 = AppendOrigin.Replication$.MODULE$;
        int n2 = 0;
        this.appendTransactionalAsLeader(log, producerId, producerEpoch, n2, (AppendOrigin)x$12).apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})));
        log.appendAsLeader(this.commitMarker(producerId, producerEpoch, this.commitMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4, 5})), this.lastOffsetsPerBatchInLog(log));
    }

    @Test
    public void testAbortMarkerRetentionWithEmptyBatch() {
        File file;
        TopicPartition tp = new TopicPartition("test", 0);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)256);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        long dirtyOffset = cleaner.doClean(new LogToClean(tp, log, 0L, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), this.lastOffsetsPerBatchInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        log.roll(log.roll$default$1());
        dirtyOffset = cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        LogCleanerTest.assertAbortedTransactionIndexed$1(log, producerId);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        cleaner.doClean(new LogToClean(tp, log, dirtyOffset, log.activeSegment().baseOffset(), false), Long.MAX_VALUE)._1$mcJ$sp();
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.lastOffsetsPerBatchInLog(log));
        List list = log.collectAbortedTransactions(0L, 100L);
        if (list == null) {
            throw null;
        }
        Assert.assertEquals((long)0L, (long)SeqOps.size$((SeqOps)list));
    }

    @Test
    public void testLargeMessage() {
        File file;
        int largeMessageSize = 0x100000;
        Function1<TopicPartition, BoxedUnit> x$32 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$32, 1024);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)(largeMessageSize * 2));
        LogConfig x$4 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$5 = file2;
        long l = 0L;
        Log log = this.makeLog(x$5, x$4, l);
        while (log.numberOfSegments() < 2) {
            byte[] byArray;
            int n = (int)log.logEndOffset();
            if (largeMessageSize <= 0) {
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4 = byArray3 = new byte[0];
                byArray3 = null;
                byte[] byArray5 = byArray2 = byArray4;
                byArray2 = null;
                byArray = byArray5;
            } else {
                byte[] byArray6;
                byte[] byArray7;
                byte[] byArray8 = byArray7 = new byte[largeMessageSize];
                byArray7 = null;
                byte[] byArray9 = byArray6 = byArray8;
                byArray6 = null;
                byte[] fill_array = byArray9;
                for (int fill_i = 0; fill_i < largeMessageSize; ++fill_i) {
                    byte by;
                    fill_array[fill_i] = by = 0;
                }
                byArray = fill_array;
            }
            byte[] byArray10 = byArray;
            Object var12_10 = null;
            byArray = null;
            log.appendAsLeader(this.record(n, byArray10), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assert.assertEquals((Object)IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)log.logEndOffset()), keysFound);
        ListSet keys = (ListSet)IterableFactory.apply$((IterableFactory)ListSet$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{1L, 3L, 5L, 7L, 9L}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.cleanSegments(log, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log.logSegments().head()})), (OffsetMap)map, 0L, stats, new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog(log).filter((Function1)(JFunction1.mcZJ.sp & Serializable)x$3 -> !keys.contains((Object)x$3))), LogTest$.MODULE$.keysInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSize() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        this.makeCleaner(Integer.MAX_VALUE, x$3, 1024).cleanSegments((Log)var2_2, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)var2_2.logSegments().head()})), (OffsetMap)var3_3, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        Assert.assertEquals((Object)((Iterable)LogTest$.MODULE$.keysInLog((Log)var2_2).filter((Function1)((JFunction1.mcZJ.sp & Serializable)arg_0 -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSize$1((FakeOffsetMap)var3_3, arg_0)))), LogTest$.MODULE$.keysInLog((Log)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMessageLargerThanMaxMessageSizeWithCorruptHeader() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        RandomAccessFile file = new RandomAccessFile(((LogSegment)var2_2.logSegments().head()).log().file(), "rw");
        file.seek(16L);
        file.write(255);
        file.close();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 1024);
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> LogCleanerTest.$anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(cleaner, (Log)var2_2, (FakeOffsetMap)var3_3)), ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 745));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCorruptMessageSizeLargerThanBytesAvailable() {
        void var3_3;
        void var2_2;
        Tuple2<Log, FakeOffsetMap> tuple2 = this.createLogWithMessagesLargerThanMaxSize(0x100000);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Log log = (Log)tuple2._1();
        FakeOffsetMap offsetMap = (FakeOffsetMap)tuple2._2();
        RandomAccessFile file = new RandomAccessFile(((LogSegment)var2_2.logSegments().head()).log().file(), "rw");
        file.setLength(1024L);
        file.close();
        Function1<TopicPartition, BoxedUnit> x$3 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, x$3, 1024);
        Assertions$.MODULE$.intercept((Function0)((JFunction0.mcV.sp & Serializable)() -> LogCleanerTest.$anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(cleaner, (Log)var2_2, (FakeOffsetMap)var3_3)), ClassTag$.MODULE$.apply(CorruptRecordException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 762));
    }

    public Tuple2<Log, FakeOffsetMap> createLogWithMessagesLargerThanMaxSize(int largeMessageSize) {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)(largeMessageSize * 2));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            byte[] byArray;
            int n = (int)log.logEndOffset();
            if (largeMessageSize <= 0) {
                byte[] byArray2;
                byte[] byArray3;
                byte[] byArray4 = byArray3 = new byte[0];
                byArray3 = null;
                byte[] byArray5 = byArray2 = byArray4;
                byArray2 = null;
                byArray = byArray5;
            } else {
                byte[] byArray6;
                byte[] byArray7;
                byte[] byArray8 = byArray7 = new byte[largeMessageSize];
                byArray7 = null;
                byte[] byArray9 = byArray6 = byArray8;
                byArray6 = null;
                byte[] fill_array = byArray9;
                for (int fill_i = 0; fill_i < largeMessageSize; ++fill_i) {
                    byte by;
                    fill_array[fill_i] = by = 0;
                }
                byArray = fill_array;
            }
            byte[] byArray10 = byArray;
            Object var9_8 = null;
            byArray = null;
            log.appendAsLeader(this.record(n, byArray10), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keysFound = LogTest$.MODULE$.keysInLog(log);
        Assert.assertEquals((Object)IntegralProxy.until$((IntegralProxy)new RichLong(0L), (Object)log.logEndOffset()), keysFound);
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)(largeMessageSize / 2));
        log.config_$eq(LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps));
        ListSet keys = (ListSet)IterableFactory.apply$((IterableFactory)ListSet$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVI.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        return new Tuple2((Object)log, (Object)map);
    }

    @Test
    public void testCleaningWithDeletes() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long leo = log.logEndOffset();
        int n = 0;
        int until$extension_end = (int)leo;
        Range range = new Range.Exclusive(n, until$extension_end, 1).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach_this = range;
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(this.tombstoneRecord(foreach_i), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var11_11 = null;
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Set keys = LogTest$.MODULE$.keysInLog(log).toSet();
        int n2 = 0;
        int until$extension_end2 = (int)leo;
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)new Range.Exclusive(n2, until$extension_end2, 1).by(2).forall((Function1)(JFunction1.mcZI.sp & Serializable)x$7 -> !keys.contains((Object)x$7)));
    }

    /*
     * WARNING - void declaration
     */
    public void testLogCleanerStats() {
        void var11_11;
        void var9_10;
        File file;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long endOffset = tuple2._1$mcJ$sp();
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assert.assertEquals((long)5L, (long)var9_10);
        Assert.assertEquals((long)5L, (long)var11_11.messagesRead());
        Assert.assertEquals((long)initialLogSize, (long)var11_11.bytesRead());
        Assert.assertEquals((long)2L, (long)var11_11.messagesWritten());
        Assert.assertEquals((long)log.size(), (long)var11_11.bytesWritten());
        Assert.assertEquals((long)0L, (long)var11_11.invalidMessagesRead());
        Assert.assertTrue((var11_11.endTime() >= var11_11.startTime() ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerRetainsProducerLastSequence() {
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        void $minus$greater$extension_y3;
        Integer n3;
        File file;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 1, 1L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 2, 2L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 3, 3L, (short)0, 0, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, 2L, (short)0, 1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4})), this.lastOffsetsPerBatchInLog(log));
        Object[] objectArray = new Tuple2[3];
        Integer n4 = n3 = Integer.valueOf(0);
        n3 = null;
        Integer n5 = n4;
        Long $minus$greater$extension_$this = 1L;
        Object var6_10 = null;
        n5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        Integer n6 = n2 = Integer.valueOf(1);
        n2 = null;
        Integer n7 = n6;
        Long $minus$greater$extension_$this2 = 2L;
        Object var8_13 = null;
        n7 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Integer n8 = n = Integer.valueOf(0);
        n = null;
        Integer n9 = n8;
        Long $minus$greater$extension_$this3 = 3L;
        Object var10_16 = null;
        n9 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogCleanerRetainsLastSequenceEvenIfTransactionAborted() {
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        File file;
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        short producerEpoch = (short)0;
        long producerId = 1L;
        Function1<Seq<Object>, LogAppendInfo> appendProducer = this.appendTransactionalAsLeader(log, producerId, producerEpoch, 0, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})));
        log.appendAsLeader(this.abortMarker(producerId, producerEpoch, this.abortMarker$default$3()), 0, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})), this.lastOffsetsPerBatchInLog(log));
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(2);
        n2 = null;
        Integer n4 = n3;
        Long $minus$greater$extension_$this = producerId;
        Object var10_13 = null;
        n4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Assert.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)Nil$.MODULE$, LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3})), this.offsetsInLog(log));
        appendProducer.apply((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5})));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 5})), this.lastOffsetsPerBatchInLog(log));
        Object[] objectArray2 = new Tuple2[1];
        Integer n5 = n = Integer.valueOf(4);
        n = null;
        Integer n6 = n5;
        Long $minus$greater$extension_$this2 = producerId;
        Object var12_16 = null;
        n6 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Assert.assertEquals((Object)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2)), this.lastSequencesInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 5})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), this.offsetsInLog(log));
    }

    @Test
    public void testPartialSegmentClean() {
        File file;
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), LogTest$.MODULE$.keysInLog(log));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.appendAsLeader(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        scala.collection.immutable.Seq disctinctValuesBySegmentBeforeClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableOnceOps)((IterableOps)LogCleanerTest.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)(JFunction1.mcZI.sp & Serializable)x$9 -> x$9 > N));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset, false));
        scala.collection.immutable.Seq distinctValuesBySegmentAfterClean = LogCleanerTest.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableOnceOps)((IterableOps)disctinctValuesBySegmentBeforeClean.zip((IterableOnce)distinctValuesBySegmentAfterClean)).take(numCleanableSegments)).forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$4(x0$1))));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableOnceOps)((IterableOps)disctinctValuesBySegmentBeforeClean.zip((IterableOnce)distinctValuesBySegmentAfterClean)).slice(numCleanableSegments, numTotalSegments)).forall((Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$5(x))));
    }

    @Test
    public void testLogToClean() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)100);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int n = 0;
        int until$extension_end = 6;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var7_9 = null;
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset(), false);
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - (long)log.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        File file;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)100);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        int n = 0;
        int until$extension_end = 6;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var10_9 = null;
        scala.collection.immutable.Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset(), false);
        int expectedCleanSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)segs.take(2)).map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int expectedCleanableSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)segs.slice(2, 4)).map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningWithUnkeyedMessages() {
        void var12_12;
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 2) {
            log.appendAsLeader(this.unkeyedRecord((int)log.logEndOffset()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        CleanerStats stats = (CleanerStats)tuple2._2();
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
        Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
        Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)var12_12.invalidMessagesRead());
    }

    public Iterable<Object> lastOffsetsPerBatchInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).map((Function1 & Serializable)batch -> BoxesRunTime.boxToLong((long)batch.lastOffset())));
    }

    public Map<Object, Object> lastSequencesInLog(Log log) {
        return ((IterableOnceOps)log.logSegments().flatMap((Function1 & Serializable)segment -> (Iterable)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).withFilter((Function1 & Serializable)batch -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$lastSequencesInLog$2(batch))).map((Function1 & Serializable)batch -> {
            Integer n;
            Integer n2 = n = Integer.valueOf(batch.lastSequence());
            n = null;
            Integer $minus$greater$extension_y = n2;
            Long $minus$greater$extension_$this = batch.producerId();
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        }))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable)s -> (Iterable)((IterableOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)x$14.hasValue()))).filter((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)x$15.hasKey()))).map((Function1 & Serializable)m -> BoxesRunTime.boxToLong((long)m.offset())));
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((IterableOnceOps)log.logSegments().map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$1(s)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleanSegmentsWithAbort() {
        File file;
        void makeCleaner_checkDone;
        Cleaner cleaner;
        int n = 65536;
        Function1 & Serializable intersect = (Function1 & Serializable)topicPartition -> {
            this.abortCheckDone(topicPartition);
            return BoxedUnit.UNIT;
        };
        int makeCleaner_capacity = Integer.MAX_VALUE;
        Cleaner cleaner2 = cleaner = new Cleaner(0, (OffsetMap)new FakeOffsetMap(makeCleaner_capacity), n, n, 0.75, this.throttler(), (Time)this.time(), (Function1)makeCleaner_checkDone);
        intersect = null;
        cleaner = null;
        Cleaner cleaner3 = cleaner2;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        Iterable<Object> keys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)k -> map.put(this.key(k), Long.MAX_VALUE));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> cleaner3.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(3)).toSeq(), (OffsetMap)map, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata()), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1093));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSegmentGrouping() {
        boolean bl;
        block20: {
            void dropRight_n;
            boolean bl2;
            int groupSize;
            List groups;
            Log log;
            Cleaner cleaner;
            block19: {
                void dropRight_n2;
                boolean bl3;
                block18: {
                    boolean bl4;
                    block17: {
                        File file;
                        cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
                        Properties logProps = new Properties();
                        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)300);
                        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), (Object)1);
                        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
                        File file2 = file = this.dir();
                        file = null;
                        File x$2 = file2;
                        long l = 0L;
                        log = this.makeLog(x$2, x$1, l);
                        int i = 0;
                        while (log.numberOfSegments() < 10) {
                            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                            ++i;
                        }
                        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
                        if (groups == null) {
                            throw null;
                        }
                        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)groups));
                        SeqOps seqOps = (SeqOps)groups.head();
                        if (seqOps == null) {
                            throw null;
                        }
                        Assert.assertEquals((long)log.numberOfSegments(), (long)seqOps.length());
                        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
                        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE, log.logEndOffset());
                        if (groups == null) {
                            throw null;
                        }
                        Assert.assertEquals((long)log.numberOfSegments(), (long)SeqOps.size$((SeqOps)groups));
                        List forall_these = groups;
                        while (!forall_these.isEmpty()) {
                            if (!LogCleanerTest.$anonfun$testSegmentGrouping$1((Seq)forall_these.head())) {
                                bl4 = false;
                                break block17;
                            }
                            forall_these = (List)forall_these.tail();
                        }
                        bl4 = true;
                    }
                    Object var13_10 = null;
                    Assert.assertTrue((String)"All groups should be singletons.", (boolean)bl4);
                    this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
                    groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1, log.logEndOffset());
                    if (groups == null) {
                        throw null;
                    }
                    Assert.assertEquals((long)log.numberOfSegments(), (long)SeqOps.size$((SeqOps)groups));
                    List forall_these = groups;
                    while (!forall_these.isEmpty()) {
                        if (!LogCleanerTest.$anonfun$testSegmentGrouping$2((Seq)forall_these.head())) {
                            bl3 = false;
                            break block18;
                        }
                        forall_these = (List)forall_these.tail();
                    }
                    bl3 = true;
                }
                Object var15_12 = null;
                Assert.assertTrue((String)"All groups should be singletons.", (boolean)bl3);
                this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
                groupSize = 3;
                int logSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)log.logSegments().take(groupSize)).map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToInteger((int)x$19.size()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
                groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE, log.logEndOffset());
                this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
                boolean bl5 = true;
                if (groups == null) {
                    throw null;
                }
                List list = (List)StrictOptimizedIterableOps.dropRight$((StrictOptimizedIterableOps)groups, (int)dropRight_n2);
                if (list == null) {
                    throw null;
                }
                List forall_these = list;
                while (!forall_these.isEmpty()) {
                    Seq seq = (Seq)forall_these.head();
                    if (!LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize, seq)) {
                        bl2 = false;
                        break block19;
                    }
                    forall_these = (List)forall_these.tail();
                }
                bl2 = true;
            }
            Object var17_17 = null;
            Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)bl2);
            int indexSize = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)((IterableOps)log.logSegments().take(groupSize)).map((Function1 & Serializable)x$21 -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testSegmentGrouping$5(x$21)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
            groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize, log.logEndOffset());
            this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
            boolean bl6 = true;
            if (groups == null) {
                throw null;
            }
            List list = (List)StrictOptimizedIterableOps.dropRight$((StrictOptimizedIterableOps)groups, (int)dropRight_n);
            if (list == null) {
                throw null;
            }
            List forall_these = list;
            while (!forall_these.isEmpty()) {
                Seq seq = (Seq)forall_these.head();
                if (!LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize, seq)) {
                    bl = false;
                    break block20;
                }
                forall_these = (List)forall_these.tail();
            }
            bl = true;
        }
        Object var19_22 = null;
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)bl);
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)400);
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), (Object)1);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        while (log.numberOfSegments() == 1) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        MemoryRecords records = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x7FFFFFFEL);
        log.appendAsFollower(records);
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().offsetIndex().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        if (groups == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)groups));
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        if (groups == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)groups));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        if (groups == null) {
            throw null;
        }
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)SeqOps.size$((SeqOps)groups));
        List foreach_these = groups;
        while (!foreach_these.isEmpty()) {
            LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1((Seq)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
        Object var8_10 = null;
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    @Test
    public void testSegmentGroupingFollowingLoadOfZeroIndex() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)400);
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), (Object)400);
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, x$1, l);
        MemoryRecords record1 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0L);
        log.appendAsFollower(record1);
        MemoryRecords record2 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 1L);
        log.appendAsFollower(record2);
        log.roll((Option)new Some((Object)0x3FFFFFFFL));
        MemoryRecords record3 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), 0x3FFFFFFFL);
        log.appendAsFollower(record3);
        MemoryRecords record4 = this.messageWithOffset("hello".getBytes(), "hello".getBytes(), (long)Integer.MAX_VALUE + 1L);
        log.appendAsFollower(record4);
        Assert.assertTrue((String)"Actual offset range should be > Int.MaxValue", (log.logEndOffset() - 1L - log.logStartOffset() > Integer.MAX_VALUE ? 1 : 0) != 0);
        Assert.assertTrue((String)"index.lastOffset is reporting the wrong last offset", (((LogSegment)log.logSegments().last()).offsetIndex().lastOffset() - log.logStartOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE, log.logEndOffset());
        if (groups == null) {
            throw null;
        }
        Assert.assertEquals((long)2L, (long)SeqOps.size$((SeqOps)groups));
        List foreach_these = groups;
        while (!foreach_these.isEmpty()) {
            LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1((Seq)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
        Object var11_13 = null;
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1 & Serializable)x$23 -> (Seq)x$23.map((Function1 & Serializable)x$24 -> BoxesRunTime.boxToLong((long)x$24.baseOffset())));
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.dir(), this.logConfig(), 0L);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        int start = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)new Range.Exclusive(start, end, 1), (IterableOnce)new Range.Exclusive(start, end, 1))));
        scala.collection.immutable.Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), cleaner, log);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), cleaner, log);
    }

    @Test
    public void testSegmentWithOffsetOverflow() {
        File file;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), (Object)1);
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), (Object)1000);
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        LogTest$.MODULE$.initializeLogDirWithOverflowedSegment(this.dir());
        File file2 = file = this.dir();
        file = null;
        File x$3 = file2;
        Log log = this.makeLog(x$3, config, Long.MAX_VALUE);
        Option<LogSegment> option = LogTest$.MODULE$.firstOverflowSegment(log);
        if (option == null) {
            throw null;
        }
        Option<LogSegment> getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            throw Assertions$.MODULE$.fail("Failed to create log with a segment which has overflowed offsets", new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1288));
        }
        Object var11_7 = null;
        LogSegment segmentWithOverflow = (LogSegment)getOrElse_this.get();
        int numSegmentsInitial = log.logSegments().size();
        List allKeys = LogTest$.MODULE$.keysInLog(log).toList();
        ArrayBuffer expectedKeysAfterCleaning = new ArrayBuffer();
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        int n = 1;
        if (allKeys == null) {
            throw null;
        }
        int n2 = SeqOps.size$((SeqOps)allKeys);
        Range range = new Range.Exclusive(n, n2, 1).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleanerTest.$anonfun$testSegmentWithOffsetOverflow$2(this, expectedKeysAfterCleaning, allKeys, offsetMap, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var14_15 = null;
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentWithOverflow, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata()), ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1303));
        Assert.assertEquals((long)(numSegmentsInitial + 1), (long)log.logSegments().size());
        Assert.assertEquals((Object)allKeys, LogTest$.MODULE$.keysInLog(log));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.logSegments().foreach((Function1 & Serializable)segmentToClean -> {
            cleaner.cleanSegments(log, (Seq)new .colon.colon((Object)segmentToClean, (List)Nil$.MODULE$), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((Object)expectedKeysAfterCleaning, LogTest$.MODULE$.keysInLog(log));
        Assert.assertFalse((boolean)LogTest$.MODULE$.hasOffsetOverflow(log));
        log.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRecoveryAfterCrash() {
        void withFilter$extension_p;
        void withFilter$extension_p2;
        File file2;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)300);
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), (Object)1);
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), (Object)10);
        LogConfig config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File file3 = file2 = this.dir();
        file2 = null;
        File x$2 = file3;
        long l = 0L;
        Log log = this.makeLog(x$2, config, l);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$4 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$6 = log.appendAsLeader$default$3();
            ApiVersion x$7 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$4, 0, x$6, x$7);
            ++messageCount;
        }
        Iterable<Object> allKeys = LogTest$.MODULE$.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        int n = 1;
        Range range = new Range.Exclusive(n, messageCount, 1).by(2);
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var22_15 = null;
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Function1 & Serializable intersect = (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$2(file));
        File[] withFilter$extension_$this = this.dir().listFiles();
        Object var24_18 = null;
        intersect = null;
        new ArrayOps.WithFilter((Function1)withFilter$extension_p2, (Object)withFilter$extension_$this).foreach((Function1 & Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$3(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, allKeys);
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        Iterable<Object> cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Function1 & Serializable intersect2 = (Function1 & Serializable)file -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testRecoveryAfterCrash$4(file));
        File[] withFilter$extension_$this2 = this.dir().listFiles();
        Object var26_21 = null;
        intersect2 = null;
        new ArrayOps.WithFilter((Function1)withFilter$extension_p, (Object)withFilter$extension_$this2).foreach((Function1 & Serializable)file -> {
            LogCleanerTest.$anonfun$testRecoveryAfterCrash$5(file);
            return BoxedUnit.UNIT;
        });
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$8 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$10 = log.appendAsLeader$default$3();
            ApiVersion x$11 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$8, 0, x$10, x$11);
            ++messageCount;
        }
        int n2 = 1;
        Range range2 = new Range.Exclusive(n2, messageCount, 1).by(2);
        if (range2 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this2 = range2;
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
        Object var28_26 = null;
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            MemoryRecords x$12 = this.record((int)log.logEndOffset(), (int)log.logEndOffset(), -1L, (short)-1, -1, -1);
            AppendOrigin x$14 = log.appendAsLeader$default$3();
            ApiVersion x$15 = log.appendAsLeader$default$4();
            log.appendAsLeader(x$12, 0, x$14, x$15);
            ++messageCount;
        }
        int n3 = 1;
        Range range3 = new Range.Exclusive(n3, messageCount, 1).by(2);
        if (range3 == null) {
            throw null;
        }
        Range foreach$mVc$sp_this3 = range3;
        if (!foreach$mVc$sp_this3.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
            while (true) {
                offsetMap.put(this.key(foreach$mVc$sp_i), Long.MAX_VALUE);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
            }
        }
        Object var30_32 = null;
        cleaner.cleanSegments(log, (Seq)((IterableOnceOps)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
        this.time().scheduler().clear();
        cleanedKeys = LogTest$.MODULE$.keysInLog(log);
        log.close();
        log = this.recoverAndCheck(config, cleanedKeys);
        log.close();
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        File file;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)120);
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), (Object)120);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        int keyStart = 0;
        int keyEnd = 2;
        long offsetStart = 0L;
        long offsetEnd = 7206178L;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{offsetStart, offsetEnd}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)new Range.Exclusive(keyStart, keyEnd, 1), (IterableOnce)new Range.Exclusive(keyStart, keyEnd, 1))), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)keyStart, offsetEnd + 1L, (OffsetMap)map, new CleanerStats(Time.SYSTEM));
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)offsetEnd, (long)map.latestOffset());
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(keyEnd - keyStart), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0L)));
        Assert.assertEquals((String)"Map should contain second value", (long)offsetEnd, (long)map.get(this.key(1L)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.dir(), this.logConfig(), 0L);
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), 65536);
        log.appendAsLeader(this.record(0, 0, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(1, 1, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(2, 2, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(3, 3, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.appendAsLeader(this.record(4, 4, -1L, (short)-1, -1, -1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0L)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2L)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3L)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4L)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        Range.Exclusive exclusive;
        Range.Exclusive exclusive2;
        File file;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        int n = 0;
        int until$extension_end = 2;
        int n2 = 0;
        int until$extension_end2 = 2;
        IndexedSeq dupSetKeys = (IndexedSeq)StrictOptimizedSeqOps.appendedAll$((StrictOptimizedSeqOps)new Range.Exclusive(n, until$extension_end, 1), (IterableOnce)new Range.Exclusive(n2, until$extension_end2, 1));
        int dupSetOffset = 25;
        if (dupSetKeys == null) {
            throw null;
        }
        int until$extension_end3 = dupSetOffset + dupSetKeys.length();
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((IterableOnce)new Range.Exclusive(dupSetOffset, until$extension_end3, 1));
        int n3 = 3;
        int until$extension_end4 = 5;
        Range.Exclusive exclusive3 = exclusive2 = new Range.Exclusive(n3, until$extension_end4, 1);
        exclusive2 = null;
        Range.Exclusive noDupSetKeys = exclusive3;
        int noDupSetOffset = 50;
        int until$extension_end5 = noDupSetOffset + SeqOps.size$((SeqOps)noDupSetKeys);
        Range.Exclusive exclusive4 = exclusive = new Range.Exclusive(noDupSetOffset, until$extension_end5, 1);
        exclusive = null;
        Range.Exclusive zip_that = exclusive4;
        Object var16_24 = null;
        IndexedSeq noDupSet = (IndexedSeq)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)noDupSetKeys, (IterableOnce)zip_that);
        log.appendAsFollower(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec));
        log.appendAsFollower(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec));
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        log.logSegments().foreach((Function1 & Serializable)segment -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$1(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range.Exclusive exclusive;
        Range.Exclusive exclusive2;
        int n = 1;
        int until$extension_end = 10;
        Range.Exclusive exclusive3 = exclusive2 = new Range.Exclusive(n, until$extension_end, 1);
        exclusive2 = null;
        Range.Exclusive keys = exclusive3;
        int offset = 50;
        int until$extension_end2 = offset + SeqOps.size$((SeqOps)keys);
        Range.Exclusive exclusive4 = exclusive = new Range.Exclusive(offset, until$extension_end2, 1);
        exclusive = null;
        Range.Exclusive zip_that = exclusive4;
        Object var6_8 = null;
        IndexedSeq set = (IndexedSeq)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)keys, (IterableOnce)zip_that);
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, CompressionType.GZIP).buffer());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable)logEntry -> {
            LogCleanerTest.$anonfun$testClientHandlingOfCorruptMessageSet$1(logEntry);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testCleanTombstone() {
        CompressionType compressionType;
        CompressionType compressionType2;
        CompressionType compressionType3;
        File file;
        LogConfig logConfig = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        File file2 = file = this.dir();
        file = null;
        File x$2 = file2;
        long l = 0L;
        Log log = this.makeLog(x$2, logConfig, l);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), 65536);
        byte[] x$4 = "0".getBytes();
        byte[] x$5 = "0".getBytes();
        long x$6 = this.time().milliseconds() + BoxesRunTime.unboxToLong((Object)logConfig.deleteRetentionMs()) + 10000L;
        CompressionType compressionType4 = compressionType3 = CompressionType.NONE;
        compressionType3 = null;
        CompressionType x$7 = compressionType4;
        byte by = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$4, x$5, x$7, x$6, by), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset(), false));
        byte[] x$10 = "0".getBytes();
        long x$11 = this.time().milliseconds() - BoxesRunTime.unboxToLong((Object)logConfig.deleteRetentionMs()) - 10000L;
        CompressionType compressionType5 = compressionType2 = CompressionType.NONE;
        compressionType2 = null;
        CompressionType x$12 = compressionType5;
        byte by2 = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(null, x$10, x$12, x$11, by2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
        byte[] x$14 = "1".getBytes();
        byte[] x$15 = "1".getBytes();
        long x$16 = this.time().milliseconds();
        CompressionType compressionType6 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$17 = compressionType6;
        byte by3 = 2;
        log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$14, x$15, x$17, x$16, by3), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset(), false));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((RecordBatch)((LogSegment)log.logSegments().head()).log().batches().iterator().next()).lastOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCleaningBeyondMissingOffsets() {
        void var10_21;
        void var6_10;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)0x100000);
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig logConfig = new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), 65536);
        Log log = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, 0L);
        int n = 0;
        int to$extension_end = 9;
        int n2 = 0;
        int to$extension_end2 = 9;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)new Range.Inclusive(n, to$extension_end, 1), (IterableOnce)new Range.Inclusive(n2, to$extension_end2, 1))), (Iterable<Object>)IntegralProxy.to$((IntegralProxy)new RichLong(0L), (Object)9L));
        log.roll((Option)new Some((Object)11L));
        log.appendAsFollower(this.messageWithOffset(1015, 1015, 11L));
        Tuple2 tuple2 = cleaner.clean(new LogToClean(log.topicPartition(), log, 0L, log.activeSegment().baseOffset(), true));
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset = tuple2._1$mcJ$sp();
        Assert.assertEquals((String)"Cleaning point should pass offset gap", (long)log.activeSegment().baseOffset(), (long)var6_10);
        Log log2 = this.makeLog(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir()), logConfig, 0L);
        int n3 = 0;
        int to$extension_end3 = 9;
        int n4 = 0;
        int to$extension_end4 = 9;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)new Range.Inclusive(n3, to$extension_end3, 1), (IterableOnce)new Range.Inclusive(n4, to$extension_end4, 1))), (Iterable<Object>)IntegralProxy.to$((IntegralProxy)new RichLong(0L), (Object)9L));
        log2.roll((Option)new Some((Object)15L));
        int n5 = 15;
        int to$extension_end5 = 24;
        int n6 = 15;
        int to$extension_end6 = 24;
        this.writeToLog(log2, (Iterable<Tuple2<Object, Object>>)((Iterable)StrictOptimizedIterableOps.zip$((StrictOptimizedIterableOps)new Range.Inclusive(n5, to$extension_end5, 1), (IterableOnce)new Range.Inclusive(n6, to$extension_end6, 1))), (Iterable<Object>)IntegralProxy.to$((IntegralProxy)new RichLong(15L), (Object)24L));
        log2.roll((Option)new Some((Object)30L));
        log2.appendAsFollower(this.messageWithOffset(1015, 1015, 30L));
        Tuple2 tuple22 = cleaner.clean(new LogToClean(log2.topicPartition(), log2, 0L, log2.activeSegment().baseOffset(), true));
        if (tuple22 == null) {
            throw new MatchError(null);
        }
        long nextDirtyOffset2 = tuple22._1$mcJ$sp();
        Assert.assertEquals((String)"Cleaning point should pass offset gap in multiple segments", (long)log2.activeSegment().baseOffset(), (long)var10_21);
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((IterableOps)keysAndValues.zip(offsetSeq)).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null && (Tuple2)check$ifrefutable$1._1() != null))).map((Function1 & Serializable)x$25 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$2(this, log, x$25)));
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        LongRef longRef;
        Iterable records = (Iterable)keysAndValues.map((Function1 & Serializable)kv -> LegacyRecord.create((byte)0, (long)-1L, (byte[])((Object)kv._1$mcI$sp()).toString().getBytes(), (byte[])((Object)kv._2$mcI$sp()).toString().getBytes(), (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        int n = Math.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$26 -> BoxesRunTime.boxToInteger((int)x$26.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024);
        int min_y = 65536;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(Math.min(n, min_y)), (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)initialOffset);
        LongRef longRef2 = longRef = new LongRef(initialOffset);
        longRef = null;
        LongRef offset = longRef2;
        records.foreach((Function1 & Serializable)record -> {
            LogCleanerTest.$anonfun$invalidCleanedMessage$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords messageWithOffset(byte[] key, byte[] value, long offset) {
        void withRecords_records;
        int n = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(key, value)};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        return MemoryRecords.withRecords((byte)2, (long)offset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)n, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    private MemoryRecords messageWithOffset(int key, int value, long offset) {
        return this.messageWithOffset(((Object)key).toString().getBytes(), ((Object)value).toString().getBytes(), offset);
    }

    private Log makeLog(File dir, LogConfig config, long recoveryPoint) {
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$9 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$10 = new LogDirFailureChannel(10);
        return Log$.MODULE$.apply(dir, config, 0L, recoveryPoint, (Scheduler)x$5, x$7, (Time)x$6, 3600000, x$9, x$10);
    }

    private File makeLog$default$1() {
        return this.dir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private long makeLog$default$3() {
        return 0L;
    }

    private Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    private Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return (Function1 & Serializable)x$27 -> {
            LogCleanerTest.$anonfun$makeCleaner$default$2$1(x$27);
            return BoxedUnit.UNIT;
        };
    }

    private int makeCleaner$default$3() {
        return 65536;
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).map((Function1 & Serializable)x$28 -> BoxesRunTime.boxToLong((long)LogCleanerTest.$anonfun$writeToLog$4(this, log, x$28)));
    }

    private ByteBuffer key(long id) {
        return ByteBuffer.wrap(((Object)id).toString().getBytes());
    }

    private MemoryRecords record(int key, int value, long producerId, short producerEpoch, int sequence, int partitionLeaderEpoch) {
        SimpleRecord[] withIdempotentRecords_records = new SimpleRecord[]{new SimpleRecord(((Object)key).toString().getBytes(), ((Object)value).toString().getBytes())};
        return MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
    }

    private Function1<Seq<Object>, LogAppendInfo> appendTransactionalAsLeader(Log log, long producerId, short producerEpoch, int leaderEpoch, AppendOrigin origin) {
        int n = 0;
        return this.appendIdempotentAsLeader(log, producerId, producerEpoch, true, n, origin);
    }

    private int appendTransactionalAsLeader$default$4() {
        return 0;
    }

    private AppendOrigin appendTransactionalAsLeader$default$5() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Function1<Seq<Object>, LogAppendInfo> appendIdempotentAsLeader(Log log, long producerId, short producerEpoch, boolean isTransactional, int leaderEpoch, AppendOrigin origin) {
        IntRef intRef;
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef sequence = intRef2;
        return (Function1 & Serializable)keys -> {
            MemoryRecords memoryRecords;
            Seq simpleRecords = (Seq)keys.map((Function1 & Serializable)key -> LogCleanerTest.$anonfun$appendIdempotentAsLeader$2(this, BoxesRunTime.unboxToInt((Object)key)));
            if (isTransactional) {
                void withTransactionalRecords_records;
                void withTransactionalRecords_baseSequence;
                SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                int n = sequence$1.elem;
                CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
                memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
                Object var12_12 = null;
                simpleRecordArray = null;
            } else {
                void withIdempotentRecords_records;
                void withIdempotentRecords_baseSequence;
                MemoryRecords memoryRecords2;
                SimpleRecord[] simpleRecordArray = (SimpleRecord[])simpleRecords.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
                int n = sequence$1.elem;
                CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
                memoryRecords = memoryRecords2 = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withIdempotentRecords_baseSequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
                Object var15_15 = null;
                simpleRecordArray = null;
                memoryRecords2 = null;
            }
            MemoryRecords records = memoryRecords;
            sequence$1.elem += simpleRecords.length();
            return log.appendAsLeader(records, leaderEpoch, origin, log.appendAsLeader$default$4());
        };
    }

    private boolean appendIdempotentAsLeader$default$4() {
        return false;
    }

    private int appendIdempotentAsLeader$default$5() {
        return 0;
    }

    private AppendOrigin appendIdempotentAsLeader$default$6() {
        return AppendOrigin.Client$.MODULE$;
    }

    private MemoryRecords commitMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.COMMIT, 0L, timestamp);
    }

    private long commitMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords abortMarker(long producerId, short producerEpoch, long timestamp) {
        return this.endTxnMarker(producerId, producerEpoch, ControlRecordType.ABORT, 0L, timestamp);
    }

    private long abortMarker$default$3() {
        return this.time().milliseconds();
    }

    private MemoryRecords endTxnMarker(long producerId, short producerEpoch, ControlRecordType controlRecordType, long offset, long timestamp) {
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlRecordType, 0);
        return MemoryRecords.withEndTransactionMarker((long)offset, (long)timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)endTxnMarker);
    }

    private MemoryRecords record(int key, byte[] value) {
        CompressionType compressionType;
        byte[] x$1 = ((Object)key).toString().getBytes();
        CompressionType compressionType2 = compressionType = CompressionType.NONE;
        compressionType = null;
        CompressionType x$3 = compressionType2;
        long l = -1L;
        byte by = 2;
        return TestUtils$.MODULE$.singletonRecords(value, x$1, x$3, l, by);
    }

    private long record$default$3() {
        return -1L;
    }

    private short record$default$4() {
        return -1;
    }

    private int record$default$5() {
        return -1;
    }

    private int record$default$6() {
        return -1;
    }

    private MemoryRecords unkeyedRecord(int value) {
        return TestUtils$.MODULE$.singletonRecords(((Object)value).toString().getBytes(), null, CompressionType.NONE, -1L, (byte)2);
    }

    private MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private Log recoverAndCheck(LogConfig config, Iterable<Object> expectedKeys) {
        return LogTest$.MODULE$.recoverAndCheck(this.dir(), config, expectedKeys, new BrokerTopicStats(), (Time)this.time(), this.time().scheduler(), false);
    }

    private final void reloadLog$1(ObjectRef log$2, Properties logProps$2) {
        File file;
        ((Log)log$2.elem).close();
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps$2);
        File file2 = file = this.dir();
        file = null;
        File x$3 = file2;
        log$2.elem = this.makeLog(x$3, x$1, 0L);
    }

    private static final void assertAbortedTransactionIndexed$1(Log log$3, long producerId$1) {
        List abortedTxns = log$3.collectAbortedTransactions(0L, 100L);
        if (abortedTxns == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)SeqOps.size$((SeqOps)abortedTxns));
        Assert.assertEquals((long)producerId$1, (long)((AbortedTxn)abortedTxns.head()).producerId());
        Assert.assertEquals((long)0L, (long)((AbortedTxn)abortedTxns.head()).firstOffset());
        Assert.assertEquals((long)2L, (long)((AbortedTxn)abortedTxns.head()).lastOffset());
    }

    public static final /* synthetic */ byte $anonfun$testLargeMessage$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$testMessageLargerThanMaxMessageSize$1(FakeOffsetMap offsetMap$1, long k) {
        return !offsetMap$1.map().containsKey(((Object)k).toString());
    }

    public static final /* synthetic */ void $anonfun$testMessageLargerThanMaxMessageSizeWithCorruptHeader$1(Cleaner cleaner$1, Log log$4, FakeOffsetMap offsetMap$2) {
        cleaner$1.cleanSegments(log$4, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log$4.logSegments().head()})), (OffsetMap)offsetMap$2, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ void $anonfun$testCorruptMessageSizeLargerThanBytesAvailable$1(Cleaner cleaner$2, Log log$5, FakeOffsetMap offsetMap$3) {
        cleaner$2.cleanSegments(log$5, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log$5.logSegments().head()})), (OffsetMap)offsetMap$3, 0L, new CleanerStats(Time.SYSTEM), new CleanedTransactionMetadata());
    }

    public static final /* synthetic */ byte $anonfun$createLogWithMessagesLargerThanMaxSize$1() {
        return 0;
    }

    public static final /* synthetic */ int $anonfun$testCleaningWithUncleanableSection$1(LogSegment s) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).map((Function1 & Serializable)record -> TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toSet().size();
    }

    private static final scala.collection.immutable.Seq distinctValuesBySegment$1(Log log$7) {
        return ((IterableOnceOps)log$7.logSegments().map((Function1 & Serializable)s -> BoxesRunTime.boxToInteger((int)LogCleanerTest.$anonfun$testCleaningWithUncleanableSection$1(s)))).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$4(Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int before = x0$1._1$mcI$sp();
        boolean bl = x0$1._2$mcI$sp() < before;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testCleaningWithUncleanableSection$5(Tuple2 x) {
        return x._1$mcI$sp() == x._2$mcI$sp();
    }

    public static final /* synthetic */ byte $anonfun$testLogToClean$1() {
        return 0;
    }

    private static final MemoryRecords createRecorcs$1() {
        Object var1_6;
        byte[] byArray;
        int fill_n = 25;
        if (fill_n <= 0) {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4 = byArray3 = new byte[0];
            byArray3 = null;
            byte[] byArray5 = byArray2 = byArray4;
            byArray2 = null;
            byArray = byArray5;
        } else {
            byte[] byArray6;
            byte[] byArray7;
            byte[] byArray8 = byArray7 = new byte[fill_n];
            byArray7 = null;
            byte[] byArray9 = byArray6 = byArray8;
            byArray6 = null;
            byte[] fill_array = byArray9;
            for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
                byte by;
                fill_array[fill_i] = by = 0;
            }
            byArray = var1_6;
        }
        byte[] byArray10 = byArray;
        var1_6 = null;
        byArray = null;
        return TestUtils$.MODULE$.singletonRecords(byArray10, ((Object)1).toString().getBytes(), CompressionType.NONE, -1L, (byte)2);
    }

    public static final /* synthetic */ byte $anonfun$testLogToCleanWithUncleanableSection$1() {
        return 0;
    }

    private static final MemoryRecords createRecords$1() {
        Object var1_6;
        byte[] byArray;
        int fill_n = 25;
        if (fill_n <= 0) {
            byte[] byArray2;
            byte[] byArray3;
            byte[] byArray4 = byArray3 = new byte[0];
            byArray3 = null;
            byte[] byArray5 = byArray2 = byArray4;
            byArray2 = null;
            byArray = byArray5;
        } else {
            byte[] byArray6;
            byte[] byArray7;
            byte[] byArray8 = byArray7 = new byte[fill_n];
            byArray7 = null;
            byte[] byArray9 = byArray6 = byArray8;
            byArray6 = null;
            byte[] fill_array = byArray9;
            for (int fill_i = 0; fill_i < fill_n; ++fill_i) {
                byte by;
                fill_array[fill_i] = by = 0;
            }
            byArray = var1_6;
        }
        byte[] byArray10 = byArray;
        var1_6 = null;
        byArray = null;
        return TestUtils$.MODULE$.singletonRecords(byArray10, ((Object)1).toString().getBytes(), CompressionType.NONE, -1L, (byte)2);
    }

    public static final /* synthetic */ boolean $anonfun$lastSequencesInLog$2(FileLogInputStream.FileChannelRecordBatch batch) {
        return !batch.isControlBatch() && batch.hasProducerId();
    }

    public static final /* synthetic */ boolean $anonfun$unkeyedMessageCountInLog$3(Record m) {
        return !m.hasKey();
    }

    public static final /* synthetic */ int $anonfun$unkeyedMessageCountInLog$1(LogSegment s) {
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().records()).asScala()).filter((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)x$16.hasValue()))).count((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$unkeyedMessageCountInLog$3(m)));
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$1(Seq x$17) {
        return x$17.length() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$2(Seq x$18) {
        return x$18.length() == 1;
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$4(int groupSize$1, Seq x$20) {
        if (x$20 == null) {
            throw null;
        }
        return x$20.length() == groupSize$1;
    }

    public static final /* synthetic */ int $anonfun$testSegmentGrouping$5(LogSegment x$21) {
        return x$21.offsetIndex().sizeInBytes();
    }

    public static final /* synthetic */ boolean $anonfun$testSegmentGrouping$6(int groupSize$1, Seq x$22) {
        if (x$22 == null) {
            throw null;
        }
        return x$22.length() == groupSize$1;
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingWithSparseOffsets$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).offsetIndex().lastOffset() - ((LogSegment)group.head()).offsetIndex().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(Seq group) {
        Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).readNextOffset() - 1L - ((LogSegment)group.head()).baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testBuildOffsetMap$1(LogCleanerTest $this, FakeOffsetMap map$5, int i) {
        Assert.assertEquals((String)"Should find all the keys", (long)i, (long)map$5.get($this.key(i)));
    }

    private final void checkRange$1(FakeOffsetMap map, int start, int end, Cleaner cleaner$4, Log log$11) {
        CleanerStats stats = new CleanerStats(Time.SYSTEM);
        cleaner$4.buildOffsetMap(log$11, (long)start, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start), (long)map.size());
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(start, end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                LogCleanerTest.$anonfun$testBuildOffsetMap$1(this, map, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var9_8 = null;
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
        Assert.assertEquals((long)(end - start), (long)stats.mapMessagesRead());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testSegmentWithOffsetOverflow$2(LogCleanerTest $this, ArrayBuffer expectedKeysAfterCleaning$1, List allKeys$1, FakeOffsetMap offsetMap$4, int k) {
        void $plus$eq_elem;
        void apply_n;
        Object object;
        int n = k - 1;
        if (allKeys$1 == null) {
            throw null;
        }
        Object object2 = object = LinearSeqOps.apply$((LinearSeqOps)allKeys$1, (int)apply_n);
        object = null;
        Object object3 = object2;
        if (expectedKeysAfterCleaning$1 == null) {
            throw null;
        }
        expectedKeysAfterCleaning$1.addOne((Object)$plus$eq_elem);
        object3 = null;
        offsetMap$4.put($this.key(BoxesRunTime.unboxToLong((Object)LinearSeqOps.apply$((LinearSeqOps)allKeys$1, (int)k))), Long.MAX_VALUE);
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$2(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$3(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ boolean $anonfun$testRecoveryAfterCrash$4(File file) {
        return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
    }

    public static final /* synthetic */ void $anonfun$testRecoveryAfterCrash$5(File file) {
        Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$3(FileLogInputStream.FileChannelRecordBatch batch$1, Record record) {
        Assert.assertTrue((boolean)record.hasMagic(batch$1.magic()));
        long l = Long.parseLong(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()));
        Assert.assertEquals((long)record.offset(), (long)l);
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$2(FileLogInputStream.FileChannelRecordBatch batch) {
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$3(batch, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testCleanCorruptMessageSet$1(LogSegment segment) {
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            LogCleanerTest.$anonfun$testCleanCorruptMessageSet$2(batch);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testClientHandlingOfCorruptMessageSet$1(Record logEntry) {
        long offset = logEntry.offset();
        long l = Long.parseLong(TestUtils$.MODULE$.readString(logEntry.value(), TestUtils$.MODULE$.readString$default$2()));
        Assert.assertEquals((long)offset, (long)l);
    }

    public static final /* synthetic */ long $anonfun$writeToLog$2(LogCleanerTest $this, Log log$13, Tuple2 x$25) {
        long offset;
        Tuple2 tuple2;
        block3: {
            block2: {
                if (x$25 == null) break block2;
                tuple2 = (Tuple2)x$25._1();
                offset = x$25._2$mcJ$sp();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)x$25);
        }
        int key = tuple2._1$mcI$sp();
        int value = tuple2._2$mcI$sp();
        long l = log$13.appendAsFollower($this.messageWithOffset(key, value, offset)).lastOffset();
        return l;
    }

    public static final /* synthetic */ void $anonfun$invalidCleanedMessage$3(MemoryRecordsBuilder builder$1, LongRef offset$1, LegacyRecord record) {
        builder$1.appendUncheckedWithOffset(offset$1.elem, record);
        ++offset$1.elem;
    }

    public static final /* synthetic */ void $anonfun$makeCleaner$default$2$1(TopicPartition x$27) {
    }

    public static final /* synthetic */ long $anonfun$writeToLog$4(LogCleanerTest $this, Log log$14, Tuple2 x$28) {
        if (x$28 == null) {
            throw new MatchError(null);
        }
        int key = x$28._1$mcI$sp();
        int value = x$28._2$mcI$sp();
        long l = BoxesRunTime.unboxToLong((Object)log$14.appendAsLeader($this.record(key, value, -1L, (short)-1, -1, -1), 0, log$14.appendAsLeader$default$3(), log$14.appendAsLeader$default$4()).firstOffset().get());
        return l;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendIdempotentAsLeader$2(LogCleanerTest $this, int key) {
        byte[] keyBytes = ((Object)key).toString().getBytes();
        return new SimpleRecord($this.time().milliseconds(), keyBytes, keyBytes);
    }

    public LogCleanerTest() {
        String string;
        String string2;
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), (Object)1024);
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), (Object)1024);
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logProps().put(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), ((Object)Long.MAX_VALUE).toString());
        this.logConfig = new LogConfig((java.util.Map)this.logProps(), LogConfig$.MODULE$.apply$default$2());
        this.time = new MockTime();
        MockTime x$3 = this.time();
        boolean bl = true;
        String string3 = string2 = "throttler";
        string2 = null;
        String x$5 = string3;
        String string4 = string = "entries";
        string = null;
        String x$6 = string4;
        this.throttler = new Throttler(Double.MAX_VALUE, Long.MAX_VALUE, bl, x$5, x$6, (Time)x$3);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testCleaningWithDeletes$1$adapted(LogCleanerTest $this, Log log$6, Object key) {
        return log$6.appendAsLeader($this.tombstoneRecord(BoxesRunTime.unboxToInt((Object)key)), 0, log$6.appendAsLeader$default$3(), log$6.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogToClean$2$adapted(Log log$8, Object x$10) {
        return log$8.appendAsLeader(LogCleanerTest.createRecorcs$1(), 0, log$8.appendAsLeader$default$3(), log$8.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testLogToCleanWithUncleanableSection$2$adapted(Log log$9, Object x$11) {
        return log$9.appendAsLeader(LogCleanerTest.createRecords$1(), 0, log$9.appendAsLeader$default$3(), log$9.appendAsLeader$default$4());
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$1$adapted(Seq x$17) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$1(x$17));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$2$adapted(Seq x$18) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$2(x$18));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$4$adapted(int groupSize$1, Seq x$20) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$4(groupSize$1, x$20));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGrouping$6$adapted(int groupSize$1, Seq x$22) {
        return BoxesRunTime.boxToBoolean((boolean)LogCleanerTest.$anonfun$testSegmentGrouping$6(groupSize$1, x$22));
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGroupingWithSparseOffsets$1$adapted(Seq group) {
        LogCleanerTest.$anonfun$testSegmentGroupingWithSparseOffsets$1(group);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1$adapted(Seq group) {
        LogCleanerTest.$anonfun$testSegmentGroupingFollowingLoadOfZeroIndex$1(group);
        return BoxedUnit.UNIT;
    }
}

