/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.api.KAFKA_2_3_IV1$;
import kafka.common.RecordValidationException;
import kafka.log.AppendOrigin;
import kafka.log.LogValidator;
import kafka.log.LogValidator$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.NoCompressionCodec$;
import kafka.message.SnappyCompressionCodec$;
import kafka.message.ZStdCompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.BrokerTopicStats$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.InvalidRecordException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.UnsupportedCompressionTypeException;
import org.apache.kafka.common.errors.UnsupportedForMessageFormatException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.RecordConversionStats;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u0005f\u0001\u0002-Z\u0001yCQ!\u001a\u0001\u0005\u0002\u0019Dq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004y\u0001\u0001\u0006Ia\u001b\u0005\bs\u0002\u0011\r\u0011\"\u0001{\u0011\u0019y\b\u0001)A\u0005w\"I\u0011\u0011\u0001\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\t\u0003#\u0001\u0001\u0015!\u0003\u0002\u0006!I\u00111\u0003\u0001C\u0002\u0013\u0005\u0011Q\u0003\u0005\t\u0003\u007f\u0001\u0001\u0015!\u0003\u0002\u0018!9\u0011\u0011\t\u0001\u0005\u0002\u0005\r\u0003bBA-\u0001\u0011\u0005\u00111\t\u0005\b\u0003;\u0002A\u0011AA\"\u0011\u001d\t\t\u0007\u0001C\u0005\u0003GBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\u000e\u0002!I!a$\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005\r\u0003bBA[\u0001\u0011%\u0011q\u0017\u0005\b\u0003w\u0003A\u0011AA\"\u0011\u001d\ti\f\u0001C\u0001\u0003\u0007Bq!!1\u0001\t\u0013\t\u0019\rC\u0004\u0002J\u0002!\t!a\u0011\t\u000f\u00055\u0007\u0001\"\u0001\u0002D!9\u0011\u0011\u001b\u0001\u0005\n\u0005M\u0007bBAl\u0001\u0011\u0005\u00111\t\u0005\b\u00037\u0004A\u0011BAo\u0011\u001d\ti\u000f\u0001C\u0005\u0003_Dq!!>\u0001\t\u0003\t\u0019\u0005C\u0004\u0002z\u0002!\t!a\u0011\t\u000f\u0005u\b\u0001\"\u0003\u0002\u0000\"9!1\u0001\u0001\u0005\u0002\u0005\r\u0003b\u0002B\u0004\u0001\u0011\u0005\u00111\t\u0005\b\u0005\u0017\u0001A\u0011\u0002B\u0007\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0003\u0007BqA!\u0006\u0001\t\u0003\t\u0019\u0005C\u0004\u0003\u001a\u0001!IAa\u0007\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002D!9!Q\u0005\u0001\u0005\u0002\u0005\r\u0003b\u0002B\u0015\u0001\u0011\u0005\u00111\t\u0005\b\u0005[\u0001A\u0011\u0002B\u0018\u0011\u001d\u0011\u0019\u0004\u0001C\u0001\u0003\u0007BqAa\u000e\u0001\t\u0003\t\u0019\u0005C\u0004\u0003J\u0001!\t!a\u0011\t\u000f\t5\u0003\u0001\"\u0001\u0002D!9!\u0011\u000b\u0001\u0005\u0002\u0005\r\u0003b\u0002B+\u0001\u0011\u0005\u00111\t\u0005\b\u00053\u0002A\u0011AA\"\u0011\u001d\u0011i\u0006\u0001C\u0001\u0003\u0007BqA!\u0019\u0001\t\u0003\t\u0019\u0005C\u0004\u0003f\u0001!\t!a\u0011\t\u000f\t%\u0004\u0001\"\u0001\u0002D!9!Q\u000e\u0001\u0005\u0002\u0005\r\u0003b\u0002B9\u0001\u0011\u0005\u00111\t\u0005\b\u0005k\u0002A\u0011AA\"\u0011\u001d\u0011I\b\u0001C\u0001\u0003\u0007BqA! \u0001\t\u0003\t\u0019\u0005C\u0004\u0003\n\u0002!\t!a\u0011\t\u000f\t5\u0005\u0001\"\u0001\u0002D!9!\u0011\u0013\u0001\u0005\u0002\u0005\r\u0003b\u0002BK\u0001\u0011\u0005\u00111\t\u0005\b\u00053\u0003A\u0011AA\"\u0011\u001d\u0011i\n\u0001C\u0001\u0003\u0007BqA!)\u0001\t\u0003\t\u0019\u0005C\u0004\u0003&\u0002!\t!a\u0011\t\u000f\t]\u0006\u0001\"\u0001\u0002D!9!1\u0018\u0001\u0005\u0002\u0005\r\u0003b\u0002B`\u0001\u0011\u0005\u00111\t\u0005\b\u0005\u0007\u0004A\u0011AA\"\u0011\u001d\u00119\r\u0001C\u0001\u0003\u0007BqAa3\u0001\t\u0003\t\u0019\u0005C\u0004\u0003X\u0002!\t!a\u0011\t\u000f\tm\u0007\u0001\"\u0001\u0002D!9!q\u001c\u0001\u0005\u0002\u0005\r\u0003b\u0002Br\u0001\u0011\u0005\u00111\t\u0005\b\u0005O\u0004A\u0011AA\"\u0011\u001d\u0011Y\u000f\u0001C\u0005\u0005[Dqaa\u0001\u0001\t\u0013\u0019)\u0001C\u0005\u0004\u001a\u0001\t\n\u0011\"\u0003\u0004\u001c!91\u0011\u0007\u0001\u0005\n\rM\u0002\"CB\u001e\u0001E\u0005I\u0011BB\u000e\u0011%\u0019i\u0004AI\u0001\n\u0013\u0019y\u0004C\u0004\u0004D\u0001!Ia!\u0012\t\u000f\r5\u0003\u0001\"\u0001\u0004P!91q\u000b\u0001\u0005\n\re\u0003bBB3\u0001\u0011\u00051q\r\u0005\b\u0007k\u0002A\u0011AB<\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0007\u000b\u0013\u0001\u0003T8h-\u0006d\u0017\u000eZ1u_J$Vm\u001d;\u000b\u0005i[\u0016a\u00017pO*\tA,A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0006C\u00011d\u001b\u0005\t'\"\u00012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\f'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002OB\u0011\u0001\u000eA\u0007\u00023\u0006!A/[7f+\u0005Y\u0007C\u00017w\u001b\u0005i'B\u00018p\u0003\u0015)H/\u001b7t\u0015\t\u0001\u0018/\u0001\u0004d_6lwN\u001c\u0006\u00039JT!a\u001d;\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005)\u0018aA8sO&\u0011q/\u001c\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003m\u0004\"\u0001`?\u000e\u0003=L!A`8\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t\u0007%\u0001\tce>\\WM\u001d+pa&\u001c7\u000b^1ugV\u0011\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111B.\u0002\rM,'O^3s\u0013\u0011\ty!!\u0003\u0003!\t\u0013xn[3s)>\u0004\u0018nY*uCR\u001c\u0018!\u00052s_.,'\u000fV8qS\u000e\u001cF/\u0019;tA\u0005iQ.\u001a;sS\u000e\u001c8*Z=TKR,\"!a\u0006\u0011\r\u0005e\u00111EA\u0014\u001b\t\tYB\u0003\u0003\u0002\u001e\u0005}\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003C\t\u0017AC2pY2,7\r^5p]&!\u0011QEA\u000e\u0005\r\u0019V\r\u001e\t\u0005\u0003S\tY$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0011\u0019wN]3\u000b\t\u0005E\u00121G\u0001\b[\u0016$(/[2t\u0015\u0011\t)$a\u000e\u0002\re\fW.\\3s\u0015\t\tI$A\u0002d_6LA!!\u0010\u0002,\tQQ*\u001a;sS\u000et\u0015-\\3\u0002\u001d5,GO]5dg.+\u0017pU3uA\u0005\u0001B/Z:u\u001f:d\u0017p\u00148f\u0005\u0006$8\r\u001b\u000b\u0003\u0003\u000b\u00022\u0001YA$\u0013\r\tI%\u0019\u0002\u0005+:LG\u000fK\u0002\u000b\u0003\u001b\u0002B!a\u0014\u0002V5\u0011\u0011\u0011\u000b\u0006\u0004\u0003'\"\u0018!\u00026v]&$\u0018\u0002BA,\u0003#\u0012A\u0001V3ti\u0006\u0019B/Z:u\u00032dwn^'vYRL')\u0019;dQ\"\u001a1\"!\u0014\u0002#Q,7\u000f^'jg6\u000bGo\u00195NC\u001eL7\rK\u0002\r\u0003\u001b\n\u0011c\u00195fG.|e\u000e\\=P]\u0016\u0014\u0015\r^2i)!\t)%!\u001a\u0002p\u0005}\u0004bBA4\u001b\u0001\u0007\u0011\u0011N\u0001\u0006[\u0006<\u0017n\u0019\t\u0004A\u0006-\u0014bAA7C\n!!)\u001f;f\u0011\u001d\t\t(\u0004a\u0001\u0003g\nQc]8ve\u000e,7i\\7qe\u0016\u001c8/[8o)f\u0004X\r\u0005\u0003\u0002v\u0005mTBAA<\u0015\r\tIh\\\u0001\u0007e\u0016\u001cwN\u001d3\n\t\u0005u\u0014q\u000f\u0002\u0010\u0007>l\u0007O]3tg&|g\u000eV=qK\"9\u0011\u0011Q\u0007A\u0002\u0005M\u0014!\u0006;be\u001e,GoQ8naJ,7o]5p]RK\b/Z\u0001\u0015G\",7m[!mY><X*\u001e7uS\n\u000bGo\u00195\u0015\u0011\u0005\u0015\u0013qQAE\u0003\u0017Cq!a\u001a\u000f\u0001\u0004\tI\u0007C\u0004\u0002r9\u0001\r!a\u001d\t\u000f\u0005\u0005e\u00021\u0001\u0002t\u0005\u00112\r[3dW6K7/\\1uG\"l\u0015mZ5d)!\t)%!%\u0002\u0016\u0006e\u0005bBAJ\u001f\u0001\u0007\u0011\u0011N\u0001\u000bE\u0006$8\r['bO&\u001c\u0007bBAL\u001f\u0001\u0007\u0011\u0011N\u0001\fe\u0016\u001cwN\u001d3NC\u001eL7\rC\u0004\u0002\u001c>\u0001\r!a\u001d\u0002\u001f\r|W\u000e\u001d:fgNLwN\u001c+za\u0016\f\u0001C^1mS\u0012\fG/Z'fgN\fw-Z:\u0015\u0015\u0005\u0015\u0013\u0011UAV\u0003[\u000by\u000bC\u0004\u0002$B\u0001\r!!*\u0002\u000fI,7m\u001c:egB!\u0011QOAT\u0013\u0011\tI+a\u001e\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\t9\u0007\u0005a\u0001\u0003SBq!!\u001d\u0011\u0001\u0004\t\u0019\bC\u0004\u0002\u0002B\u0001\r!a\u001d\u0002AQ,7\u000f\u001e'pO\u0006\u0003\b/\u001a8e)&lWMT8o\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004#\u00055\u0013aH2iK\u000e\\Gj\\4BaB,g\u000e\u001a+j[\u0016tuN\\\"p[B\u0014Xm]:fIR!\u0011QIA]\u0011\u001d\t9G\u0005a\u0001\u0003S\n\u0001\u0005^3ti2{w-\u00119qK:$G+[7f\u001d>t7i\\7qe\u0016\u001c8/\u001a3We\u0005!C/Z:u\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3XSRD'+Z2p[B\u0014Xm]:j_:4\u0016\u0007K\u0002\u0015\u0003\u001b\n1e\u00195fG.dunZ!qa\u0016tG\rV5nK^KG\u000f\u001b*fG>l\u0007O]3tg&|g\u000e\u0006\u0003\u0002F\u0005\u0015\u0007bBAd+\u0001\u0007\u0011\u0011N\u0001\fi\u0006\u0014x-\u001a;NC\u001eL7-\u0001\u0013uKN$Hj\\4BaB,g\u000e\u001a+j[\u0016<\u0016\u000e\u001e5SK\u000e|W\u000e\u001d:fgNLwN\u001c,3Q\r1\u0012QJ\u0001(i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i_V$(+Z2p[B\u0014Xm]:j_:4\u0016\u0007K\u0002\u0018\u0003\u001b\nae\u00195fG.dunZ!qa\u0016tG\rV5nK^KG\u000f[8viJ+7m\\7qe\u0016\u001c8/[8o)\u0011\t)%!6\t\u000f\u0005\u001d\u0004\u00041\u0001\u0002j\u0005!C/Z:u\u0013:4\u0018\r\\5e\u001f\u001a47/\u001a;SC:<W-\u00118e%\u0016\u001cwN\u001d3D_VtG\u000fK\u0002\u001a\u0003\u001b\n\u0001%Y:tKJ$\u0018J\u001c<bY&$')\u0019;dQ\u000e{WO\u001c;Pm\u0016\u0014(/\u001b3fgR1\u0011QIAp\u0003SDq!!9\u001b\u0001\u0004\t\u0019/A\bmCN$xJ\u001a4tKR$U\r\u001c;b!\r\u0001\u0017Q]\u0005\u0004\u0003O\f'aA%oi\"9\u00111\u001e\u000eA\u0002\u0005\r\u0018!B2pk:$\u0018!\n<bY&$\u0017\r^3SK\u000e|'\u000f\u001a\"bi\u000eDw+\u001b;i\u0007>,h\u000e^(wKJ\u0014\u0018\u000eZ3t)\u0019\t)%!=\u0002t\"9\u0011\u0011]\u000eA\u0002\u0005\r\bbBAv7\u0001\u0007\u00111]\u0001(i\u0016\u001cH\u000fT8h\u0003B\u0004XM\u001c3US6,w+\u001b;i_V$(+Z2p[B\u0014Xm]:j_:4&\u0007K\u0002\u001d\u0003\u001b\n1\u0003^3ti:{gnQ8naJ,7o]3e-FB3!HA'\u0003I\u0019\u0007.Z2l\u001d>t7i\\7qe\u0016\u001c8/\u001a3\u0015\t\u0005\u0015#\u0011\u0001\u0005\b\u0003Or\u0002\u0019AA5\u0003M!Xm\u001d;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\ry\u0012QJ\u0001\u0014i\u0016\u001cHOU3d_6\u0004(/Z:tS>tg+\r\u0015\u0004A\u00055\u0013AE2iK\u000e\\'+Z2p[B\u0014Xm]:j_:$B!!\u0012\u0003\u0010!9\u0011qM\u0011A\u0002\u0005%\u0014a\u0005;fgR\u0014VmY8naJ,7o]5p]Z\u0013\u0004f\u0001\u0012\u0002N\u0005\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,2Q\r\u0019\u0013QJ\u0001\"G\",7m[\"sK\u0006$X\rV5nKV\u00038i\u001c8wKJ\u001c\u0018n\u001c8Ge>lg\u000b\r\u000b\u0005\u0003\u000b\u0012i\u0002C\u0004\u0003 \u0011\u0002\r!!\u001b\u0002\u000fQ|W*Y4jG\u0006\u0001C/Z:u\u0007J,\u0017\r^3US6,W\u000b]\"p]Z,'o]5p]Z\u0003Dk\u001c,3Q\r)\u0013QJ\u0001!i\u0016\u001cHo\u0011:fCR,G+[7f+B\u001cuN\u001c<feNLwN\u001c,2)>4&\u0007K\u0002'\u0003\u001b\n\u0001\u0003^3ti\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007\u001d\ni%A\bdQ\u0016\u001c7nQ8naJ,7o]3e)\u0011\t)E!\r\t\u000f\u0005\u001d\u0004\u00061\u0001\u0002j\u0005\u0001B/Z:u\u0007>l\u0007O]3tg\u0016$gK\r\u0015\u0004S\u00055\u0013\u0001\n;fgRLeN^1mS\u0012\u001c%/Z1uKRKW.\u001a(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u000f)\niEa\u000f\u0003>\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0003@A!!\u0011\tB#\u001b\t\u0011\u0019E\u0003\u0002q7&!!q\tB\"\u0005e\u0011VmY8sIZ\u000bG.\u001b3bi&|g.\u0012=dKB$\u0018n\u001c8\u0002IQ,7\u000f^%om\u0006d\u0017\u000eZ\"sK\u0006$X\rV5nK:{gnQ8naJ,7o]3e-JBsaKA'\u0005w\u0011i$A\u0011uKN$\u0018J\u001c<bY&$7I]3bi\u0016$\u0016.\\3D_6\u0004(/Z:tK\u00124\u0016\u0007K\u0004-\u0003\u001b\u0012YD!\u0010\u0002CQ,7\u000f^%om\u0006d\u0017\u000eZ\"sK\u0006$X\rV5nK\u000e{W\u000e\u001d:fgN,GM\u0016\u001a)\u000f5\niEa\u000f\u0003>\u0005IC/Z:u\u0003\n\u001cx\u000e\\;uK>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$hj\u001c8D_6\u0004(/Z:tK\u0012D3ALA'\u0003\u0019\"Xm\u001d;BEN|G.\u001e;f\u001f\u001a47/\u001a;BgNLwM\\7f]R\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004_\u00055\u0013a\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e\u001e(p]\u000e{W\u000e\u001d:fgN,GMV\u0019)\u0007A\ni%A\u0016uKN$(+\u001a7bi&4Xm\u00144gg\u0016$\u0018i]:jO:lWM\u001c;O_:\u001cu.\u001c9sKN\u001cX\r\u001a,3Q\r\t\u0014QJ\u0001)i\u0016\u001cHOU3mCRLg/Z(gMN,G/Q:tS\u001etW.\u001a8u\u0007>l\u0007O]3tg\u0016$g+\r\u0015\u0004e\u00055\u0013\u0001\u000b;fgR\u0014V\r\\1uSZ,wJ\u001a4tKR\f5o]5h]6,g\u000e^\"p[B\u0014Xm]:fIZ\u0013\u0004fA\u001a\u0002N\u0005AD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\u001b\u0002N\u0005AD/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,1)>4&GT8o\u0007>l\u0007O]3tg\u0016$\u0007fA\u001b\u0002N\u0005)D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s+B\u001cuN\u001c<feNLwN\u001c,1)>4\u0016gQ8naJ,7o]3eQ\r1\u0014QJ\u00016i\u0016\u001cHo\u00144gg\u0016$\u0018i]:jO:lWM\u001c;BMR,'/\u00169D_:4XM]:j_:4\u0006\u0007V8We\r{W\u000e\u001d:fgN,G\rK\u00028\u0003\u001b\nq\u0005^3ti\u000e{g\u000e\u001e:pYJ+7m\u001c:eg:{G/\u00117m_^,GM\u0012:p[\u000ec\u0017.\u001a8ug\":\u0001(!\u0014\u0003<\t\u00055E\u0001BB!\ra(QQ\u0005\u0004\u0005\u000f{'AF%om\u0006d\u0017\u000e\u001a*fG>\u0014H-\u0012=dKB$\u0018n\u001c8\u0002?Q,7\u000f^\"p]R\u0014x\u000e\u001c*fG>\u0014Hm\u001d(pi\u000e{W\u000e\u001d:fgN,G\rK\u0002:\u0003\u001b\n!\b^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u000bDk\u001c,1\u001d>t7i\\7qe\u0016\u001c8/\u001a3)\u0007i\ni%A\u001cuKN$xJ\u001a4tKR\f5o]5h]6,g\u000e^!gi\u0016\u0014Hi\\<o\u0007>tg/\u001a:tS>tg+\r+p-B\u001au.\u001c9sKN\u001cX\r\u001a\u0015\u0004w\u00055\u0013\u0001\u000f;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-F\"vN\u0016\u001aO_:\u001cu.\u001c9sKN\u001cX\r\u001a\u0015\u0004y\u00055\u0013!\u000e;fgR|eMZ:fi\u0006\u001b8/[4o[\u0016tG/\u00114uKJ,\u0006oQ8om\u0016\u00148/[8o-F\"vN\u0016\u001aD_6\u0004(/Z:tK\u0012D3!PA'\u0003i\"Xm\u001d;PM\u001a\u001cX\r^!tg&<g.\\3oi\u00063G/\u001a:E_^t7i\u001c8wKJ\u001c\u0018n\u001c8WeQ{g+\r(p]\u000e{W\u000e\u001d:fgN,G\rK\u0002?\u0003\u001b\nq\u0007^3ti>3gm]3u\u0003N\u001c\u0018n\u001a8nK:$\u0018I\u001a;fe\u0012{wO\\\"p]Z,'o]5p]Z\u0013Dk\u001c,2\u0007>l\u0007O]3tg\u0016$\u0007fA \u0002N\u0005!D/Z:u\t><hnQ8om\u0016\u00148/[8o\u001f\u001a$&/\u00198tC\u000e$\u0018n\u001c8bYJ+7m\u001c:eg:{G\u000fU3s[&$H/\u001a3)\u000f\u0001\u000biEa\u000f\u0003*\u000e\u0012!1\u0016\t\u0005\u0005[\u0013\u0019,\u0004\u0002\u00030*\u0019!\u0011W8\u0002\r\u0015\u0014(o\u001c:t\u0013\u0011\u0011)La,\u0003IUs7/\u001e9q_J$X\r\u001a$pe6+7o]1hK\u001a{'/\\1u\u000bb\u001cW\r\u001d;j_:\f\u0011\u0007^3ti\u0012{wO\\\"p]Z,'o]5p]>3\u0017\nZ3na>$XM\u001c;SK\u000e|'\u000fZ:O_R\u0004VM]7jiR,G\rK\u0004B\u0003\u001b\u0012YD!+\u0002uQ,7\u000f^(gMN,G/Q:tS\u001etW.\u001a8u\u0003\u001a$XM\u001d#po:\u001cuN\u001c<feNLwN\u001c,3)>4\u0006GT8o\u0007>l\u0007O]3tg\u0016$\u0007f\u0001\"\u0002N\u00059D/Z:u\u001f\u001a47/\u001a;BgNLwM\\7f]R\fe\r^3s\t><hnQ8om\u0016\u00148/[8o-J\"vN\u0016\u0019D_6\u0004(/Z:tK\u0012D3aQA'\u0003I\"Xm\u001d;O_:Len\u0019:fCNLgnZ(gMN,GOU3d_J$')\u0019;dQ\"\u000b7/T3ue&\u001c7\u000fT8hO\u0016$\u0007f\u0001#\u0002N\u0005YC/Z:u\u0007>l\u0007O]3tg\u0016$')\u0019;dQ^KG\u000f[8viJ+7m\u001c:eg:{G/\u00117m_^,G\rK\u0004F\u0003\u001b\u0012YD!!\u0002WQ,7\u000f\u001e.Ti\u0012\u001cu.\u001c9sKN\u001cX\rZ,ji\",f.\u0019<bS2\f'\r\\3J\u0005B3VM]:j_:DsARA'\u0005w\u0011ym\t\u0002\u0003RB!!Q\u0016Bj\u0013\u0011\u0011)Na,\u0003GUs7/\u001e9q_J$X\rZ\"p[B\u0014Xm]:j_:$\u0016\u0010]3Fq\u000e,\u0007\u000f^5p]\u0006iC/Z:u+:\u001cw.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u000f\u001d\u000biEa\u000f\u0003\u0002\u0006iC/Z:u%\u0016\u001cw.\u001c9sKN\u001cX\r\u001a\"bi\u000eDw+\u001b;i_V$(+Z2pe\u0012\u001chj\u001c;BY2|w/\u001a3)\u000f!\u000biEa\u000f\u0003\u0002\u0006QC/Z:u\u0013:4\u0018\r\\5e)&lWm\u001d;b[B,\u0005pY3qi&|g\u000eS1t\u0005\u0006$8\r[%oI\u0016D\bfA%\u0002N\u00059C/Z:u\u0013:4\u0018\r\\5e%\u0016\u001cwN\u001d3Fq\u000e,\u0007\u000f^5p]\"\u000b7OQ1uG\"Le\u000eZ3yQ\rQ\u0015QJ\u0001/i\u0016\u001cHOQ1uG\"<\u0016\u000e\u001e5J]Z\fG.\u001b3SK\u000e|'\u000fZ:B]\u0012LeN^1mS\u0012$\u0016.\\3ti\u0006l\u0007\u000fK\u0002L\u0003\u001b\n\u0011\u0005^3ti\n\u000bGo\u00195XSRDw.\u001e;SK\u000e|'\u000fZ:O_R\fE\u000e\\8xK\u0012$b!!\u0012\u0003p\n}\bb\u0002By\u0019\u0002\u0007!1_\u0001\fg>,(oY3D_\u0012,7\r\u0005\u0003\u0003v\nmXB\u0001B|\u0015\r\u0011IpW\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011iPa>\u0003!\r{W\u000e\u001d:fgNLwN\\\"pI\u0016\u001c\u0007bBB\u0001\u0019\u0002\u0007!1_\u0001\fi\u0006\u0014x-\u001a;D_\u0012,7-A\u0007de\u0016\fG/\u001a*fG>\u0014Hm\u001d\u000b\t\u0003K\u001b9aa\u0003\u0004\u0016!91\u0011B'A\u0002\u0005%\u0014AC7bO&\u001cg+\u00197vK\"I1QB'\u0011\u0002\u0003\u00071qB\u0001\ni&lWm\u001d;b[B\u00042\u0001YB\t\u0013\r\u0019\u0019\"\u0019\u0002\u0005\u0019>tw\rC\u0004\u0004\u00185\u0003\r!a\u001d\u0002\u000b\r|G-Z2\u0002/\r\u0014X-\u0019;f%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\u0012TCAB\u000fU\u0011\u0019yaa\b,\u0005\r\u0005\u0002\u0003BB\u0012\u0007[i!a!\n\u000b\t\r\u001d2\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u000bb\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007_\u0019)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001e\u0019:fCR,gj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:egRA\u0011QUB\u001b\u0007o\u0019I\u0004C\u0004\u0004\n=\u0003\r!!\u001b\t\u0013\r5q\n%AA\u0002\r=\u0001\"CB\f\u001fB\u0005\t\u0019AA:\u0003)\u001a'/Z1uK:{g.\u00138de\u0016\f7/\u001b8h\u001f\u001a47/\u001a;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uII\n!f\u0019:fCR,gj\u001c8J]\u000e\u0014X-Y:j]\u001e|eMZ:fiJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0004B)\"\u00111OB\u0010\u0003]\u0019'/Z1uKR;xNQ1uG\",GMU3d_J$7\u000f\u0006\u0005\u0002&\u000e\u001d3\u0011JB&\u0011\u001d\u0019IA\u0015a\u0001\u0003SBqa!\u0004S\u0001\u0004\u0019y\u0001C\u0004\u0004\u0018I\u0003\r!a\u001d\u0002\u0019\rDWmY6PM\u001a\u001cX\r^:\u0015\r\u0005\u00153\u0011KB*\u0011\u001d\t\u0019k\u0015a\u0001\u0003KCqa!\u0016T\u0001\u0004\u0019y!\u0001\u0006cCN,wJ\u001a4tKR\fAD]3d_J$7oV5uQ&sg/\u00197jI&sg.\u001a:NC\u001eL7\r\u0006\u0005\u0002&\u000em3qLB2\u0011\u001d\u0019i\u0006\u0016a\u0001\u0003S\nqBY1uG\"l\u0015mZ5d-\u0006dW/\u001a\u0005\b\u0007C\"\u0006\u0019AA5\u0003A\u0011XmY8sI6\u000bw-[2WC2,X\rC\u0004\u0004\u0018Q\u0003\r!a\u001d\u0002/5\f\u0017PY3DQ\u0016\u001c7NQ1tKRKW.Z:uC6\u0004HCBA#\u0007S\u001aY\u0007C\u0004\u0003<U\u0003\raa\u0004\t\u000f\r5T\u000b1\u0001\u0004p\u0005)!-\u0019;dQB!\u0011QOB9\u0013\u0011\u0019\u0019(a\u001e\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r[\u0001\u0016m\u0006d\u0017\u000eZ1uK2{w-\u00119qK:$G+[7f)!\t)e!\u001f\u0004~\r\u0005\u0005bBB>-\u0002\u00071qB\u0001\u0016Kb\u0004Xm\u0019;fI2{w-\u00119qK:$G+[7f\u0011\u001d\u0019yH\u0016a\u0001\u0007\u001f\tQ#\u001a=qK\u000e$X\r\u001a\"bg\u0016$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0004nY\u0003\raa\u001c\u00027Y,'/\u001b4z%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t))\t)ea\"\u0004\u0012\u000eU5q\u0013\u0005\b\u0007\u0013;\u0006\u0019ABF\u0003\u0015\u0019H/\u0019;t!\u0011\t)h!$\n\t\r=\u0015q\u000f\u0002\u0016%\u0016\u001cwN\u001d3D_:4XM]:j_:\u001cF/\u0019;t\u0011\u001d\u0019\u0019j\u0016a\u0001\u0003G\f1C\\;n\u0007>tg/\u001a:uK\u0012\u0014VmY8sINDq!a)X\u0001\u0004\t)\u000bC\u0004\u0004\u001a^\u0003\raa'\u0002\u0015\r|W\u000e\u001d:fgN,G\rE\u0002a\u0007;K1aa(b\u0005\u001d\u0011un\u001c7fC:\u0004")
public class LogValidatorTest {
    private final Time time = Time.SYSTEM;
    private final TopicPartition topicPartition = new TopicPartition("topic", 0);
    private final BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
    private final Set<MetricName> metricsKeySet = (Set)JavaConverters$.MODULE$.asScalaSetConverter(Metrics.defaultRegistry().allMetrics().keySet()).asScala();

    public Time time() {
        return this.time;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerTopicStats brokerTopicStats() {
        return this.brokerTopicStats;
    }

    public Set<MetricName> metricsKeySet() {
        return this.metricsKeySet;
    }

    @Test
    public void testOnlyOneBatch() {
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.GZIP);
        this.checkOnlyOneBatch((byte)0, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)1, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.GZIP, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.NONE);
        this.checkOnlyOneBatch((byte)2, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testAllowMultiBatch() {
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.NONE);
        this.checkAllowMultiBatch((byte)0, CompressionType.NONE, CompressionType.GZIP);
        this.checkAllowMultiBatch((byte)1, CompressionType.NONE, CompressionType.GZIP);
    }

    @Test
    public void testMisMatchMagic() {
        this.checkMismatchMagic((byte)0, (byte)1, CompressionType.GZIP);
        this.checkMismatchMagic((byte)1, (byte)0, CompressionType.GZIP);
    }

    private void checkOnlyOneBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
    }

    private void checkAllowMultiBatch(byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        this.validateMessages(this.createTwoBatchedRecords(magic, 0L, sourceCompressionType), magic, sourceCompressionType, targetCompressionType);
    }

    private void checkMismatchMagic(byte batchMagic, byte recordMagic, CompressionType compressionType) {
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic(batchMagic, recordMagic, compressionType), batchMagic, compressionType, compressionType), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$checkMismatchMagic$2(x$1))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    private void validateMessages(MemoryRecords records, byte magic, CompressionType sourceCompressionType, CompressionType targetCompressionType) {
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), 0L, CompressionCodec$.MODULE$.getCompressionCodec(sourceCompressionType.name), CompressionCodec$.MODULE$.getCompressionCodec(targetCompressionType.name), false, magic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_3_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeNonCompressedV1() {
        this.checkLogAppendTimeNonCompressed((byte)1);
    }

    private void checkLogAppendTimeNonCompressed(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.NONE);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)"The offset of max timestamp should be 0", (long)0L, (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, false);
    }

    public void testLogAppendTimeNonCompressedV2() {
        this.checkLogAppendTimeNonCompressed((byte)2);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV1() {
        this.checkLogAppendTimeWithRecompression((byte)1);
    }

    private void checkLogAppendTimeWithRecompression(byte targetMagic) {
        long now = System.currentTimeMillis();
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, targetMagic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            this.validateLogAppendTime(now, -1L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size may have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        RecordConversionStats stats = validatedResults.recordConversionStats();
        this.verifyRecordConversionStats(stats, 3, records, true);
    }

    @Test
    public void testLogAppendTimeWithRecompressionV2() {
        this.checkLogAppendTimeWithRecompression((byte)2);
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV1() {
        this.checkLogAppendTimeWithoutRecompression((byte)1);
    }

    private void checkLogAppendTimeWithoutRecompression(byte magic) {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords(magic, 1234L, CompressionType.GZIP);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, magic, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        Assert.assertEquals((String)"message set size should not change", (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size(), (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            this.validateLogAppendTime(now, 1234L, (RecordBatch)batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((String)"MessageSet should still valid", (boolean)((RecordBatch)validatedRecords.batches().iterator().next()).isValid());
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now).toString(), (long)now, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(38).append("The offset of max timestamp should be ").append(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1).toString(), (long)(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testInvalidOffsetRangeAndRecordCount() {
        this.validateRecordBatchWithCountOverrides(2, 3);
        this.assertInvalidBatchCountOverrides(0, 3);
        this.assertInvalidBatchCountOverrides(15, 3);
        this.assertInvalidBatchCountOverrides(-3, 3);
        this.assertInvalidBatchCountOverrides(2, -3);
        this.assertInvalidBatchCountOverrides(2, 6);
        this.assertInvalidBatchCountOverrides(2, 0);
        this.assertInvalidBatchCountOverrides(-3, -2);
        this.assertInvalidBatchCountOverrides(5, 6);
        this.assertInvalidBatchCountOverrides(1, 2);
    }

    private void assertInvalidBatchCountOverrides(int lastOffsetDelta, int count) {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateRecordBatchWithCountOverrides(lastOffsetDelta, count), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
    }

    private void validateRecordBatchWithCountOverrides(int lastOffsetDelta, int count) {
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        records.buffer().putInt(57, count);
        records.buffer().putInt(23, lastOffsetDelta);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), this.time().milliseconds(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testLogAppendTimeWithoutRecompressionV2() {
        this.checkLogAppendTimeWithoutRecompression((byte)2);
    }

    @Test
    public void testNonCompressedV1() {
        this.checkNonCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkNonCompressed(byte magic) {
        IntRef intRef;
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkNonCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (boolean)var10_8, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 1", (long)1L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 0, records, false);
    }

    @Test
    public void testNonCompressedV2() {
        this.checkNonCompressed((byte)2);
    }

    @Test
    public void testRecompressionV1() {
        this.checkRecompression((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkRecompression(byte magic) {
        IntRef intRef;
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        LogValidator.ValidationAndOffsetAssignResult validatingResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)GZIPCompressionCodec$.MODULE$, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        MemoryRecords validatedRecords = validatingResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkRecompression$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatingResults.maxTimestamp());
        Assert.assertEquals((String)"Offset of max timestamp should be 2", (long)2L, (long)validatingResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatingResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatingResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testRecompressionV2() {
        this.checkRecompression((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV1() {
        this.checkCreateTimeUpConversionFromV0((byte)1);
    }

    private void checkCreateTimeUpConversionFromV0(byte toMagic) {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, false, toMagic, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$checkCreateTimeUpConversionFromV0$1(this, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(-1L).toString(), (long)-1L, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCreateTimeUpConversionV0ToV2() {
        this.checkCreateTimeUpConversionFromV0((byte)2);
    }

    @Test
    public void testCreateTimeUpConversionV1ToV2() {
        long timestamp = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, timestamp, CompressionType.GZIP);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef(0L);
        Time x$7 = this.time();
        DefaultCompressionCodec$ x$9 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$10 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, timestamp, (CompressionCodec)x$9, (CompressionCodec)x$10, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach((Function1 & Serializable)batch -> {
            LogValidatorTest.$anonfun$testCreateTimeUpConversionV1ToV2$1(this, timestamp, batch);
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)timestamp, (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertTrue((String)"Message size should have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testCompressedV1() {
        this.checkCompressed((byte)1);
    }

    /*
     * WARNING - void declaration
     */
    private void checkCompressed(byte magic) {
        IntRef intRef;
        void var10_8;
        void var11_9;
        void var9_7;
        void var8_6;
        void var6_5;
        long now = System.currentTimeMillis();
        scala.collection.immutable.Seq timestampSeq = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{now - 1L, now + 1L, now}));
        Tuple5 tuple5 = magic >= 2 ? new Tuple5((Object)1324L, (Object)((short)10), (Object)984, (Object)true, (Object)40) : new Tuple5((Object)-1L, (Object)-1, (Object)-1, (Object)false, (Object)-1);
        long producerId = BoxesRunTime.unboxToLong((Object)tuple5._1());
        short producerEpoch = BoxesRunTime.unboxToShort((Object)tuple5._2());
        int baseSequence = BoxesRunTime.unboxToInt((Object)tuple5._3());
        boolean isTransactional = BoxesRunTime.unboxToBoolean((Object)tuple5._4());
        int partitionLeaderEpoch = BoxesRunTime.unboxToInt((Object)tuple5._5());
        MemoryRecords records = MemoryRecords.withRecords((byte)magic, (long)0L, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)var6_5, (short)var8_6, (int)var9_7, (int)var11_9, (boolean)var10_8, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(0)), "hello".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(1)), "there".getBytes()), new SimpleRecord(BoxesRunTime.unboxToLong((Object)timestampSeq.apply(2)), "beautiful".getBytes())});
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, magic, TimestampType.CREATE_TIME, 1000L, (int)var11_9, (AppendOrigin)x$13, x$14, x$15);
        MemoryRecords validatedRecords = validatedResults.validatedRecords();
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef i = intRef2;
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.batches()).asScala()).foreach(arg_0 -> LogValidatorTest.$anonfun$checkCompressed$1$adapted(this, timestampSeq, (short)var8_6, (long)var6_5, (int)var9_7, (int)var11_9, i, arg_0));
        Assert.assertEquals((String)new StringBuilder(24).append("Max timestamp should be ").append(now + 1L).toString(), (long)(now + 1L), (long)validatedResults.maxTimestamp());
        Assert.assertEquals((String)new StringBuilder(34).append("Offset of max timestamp should be ").append(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1).toString(), (long)(((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(validatedRecords.records()).asScala()).size() - 1), (long)validatedResults.shallowOffsetOfMaxTimestamp());
        Assert.assertFalse((String)"Message size should not have been changed", (boolean)validatedResults.messageSizeMaybeChanged());
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 0, records, true);
    }

    @Test
    public void testCompressedV2() {
        this.checkCompressed((byte)2);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test(expected=RecordValidationException.class)
    public void testInvalidCreateTimeCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        TopicPartition x$2 = this.topicPartition();
        kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
        Time x$4 = this.time();
        long x$5 = System.currentTimeMillis();
        DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
        DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$15 = this.brokerTopicStats();
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
    }

    @Test
    public void testAbsoluteOffsetAssignmentNonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        TopicPartition x$5 = this.topicPartition();
        kafka.common.LongRef x$6 = new kafka.common.LongRef((long)offset);
        Time x$7 = this.time();
        long x$8 = System.currentTimeMillis();
        NoCompressionCodec$ x$9 = NoCompressionCodec$.MODULE$;
        NoCompressionCodec$ x$10 = NoCompressionCodec$.MODULE$;
        AppendOrigin.Client$ x$16 = AppendOrigin.Client$.MODULE$;
        ApiVersion x$17 = ApiVersion$.MODULE$.latestVersion();
        BrokerTopicStats x$18 = this.brokerTopicStats();
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$5, x$6, x$7, x$8, (CompressionCodec)x$9, (CompressionCodec)x$10, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$16, x$17, x$18).validatedRecords(), offset);
    }

    @Test
    public void testAbsoluteOffsetAssignmentCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentNonCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords messageWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(messageWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV1() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testRelativeOffsetAssignmentCompressedV2() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        MemoryRecords compressedMessagesWithOffset = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords();
        this.checkOffsets(compressedMessagesWithOffset, offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, false);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV1Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV0ToV2Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)0, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        LogValidator.ValidationAndOffsetAssignResult validatedResults = LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
        this.checkOffsets(validatedResults.validatedRecords(), offset);
        this.verifyRecordConversionStats(validatedResults.recordConversionStats(), 3, records, true);
    }

    @Test(expected=InvalidRecordException.class)
    public void testControlRecordsNotAllowedFromClients() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    @Test
    public void testControlRecordsNotCompressed() {
        int offset = 1234567;
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
        MemoryRecords records = MemoryRecords.withEndTransactionMarker((long)23423L, (short)5, (EndTransactionMarker)endTxnMarker);
        List batches = TestUtils.toList((Iterable)LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)SnappyCompressionCodec$.MODULE$, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords().batches());
        Assert.assertEquals((long)1L, (long)batches.size());
        Assert.assertFalse((boolean)((MutableRecordBatch)batches.get(0)).isCompressed());
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV1ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)1, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2NonCompressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)1, l, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        int offset = 1234567;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterUpConversionV1ToV2Compressed() {
        long l = -1L;
        MemoryRecords records = this.createRecords((byte)1, l, CompressionType.GZIP);
        int offset = 1234567;
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV1Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfTransactionalRecordsNotPermitted() {
        void withTransactionalRecords_records;
        MemoryRecords memoryRecords;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records);
        Object var7_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    /*
     * WARNING - void declaration
     */
    @Test(expected=UnsupportedForMessageFormatException.class)
    public void testDownConversionOfIdempotentRecordsNotPermitted() {
        void withIdempotentRecords_records;
        MemoryRecords memoryRecords;
        int offset = 1234567;
        long producerId = 1344L;
        short producerEpoch = (short)16;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes()), new SimpleRecord("beautiful".getBytes())};
        CompressionType withIdempotentRecords_compressionType = CompressionType.NONE;
        MemoryRecords memoryRecords2 = memoryRecords = MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withIdempotentRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)false, (SimpleRecord[])withIdempotentRecords_records);
        Object var7_6 = null;
        simpleRecordArray = null;
        memoryRecords = null;
        MemoryRecords records = memoryRecords2;
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)1, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0NonCompressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.NONE);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testOffsetAssignmentAfterDownConversionV2ToV0Compressed() {
        int offset = 1234567;
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now, CompressionType.GZIP);
        this.checkOffsets(records, 0L);
        this.checkOffsets(LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()).validatedRecords(), offset);
    }

    @Test
    public void testNonIncreasingOffsetRecordBatchHasMetricsLogged() {
        MemoryRecords records = this.createNonIncreasingOffsetRecords((byte)2, -1L, CompressionType.NONE);
        ((MutableRecordBatch)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.batches()).asScala()).head()).setLastOffset(2L);
        Assertions$.MODULE$.assertThrows((Function0 & Serializable)() -> LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), System.currentTimeMillis(), (CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$, false, (byte)0, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats()), ClassTag$.MODULE$.apply(InvalidRecordException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1195));
        Assert.assertEquals((long)this.metricsKeySet().count((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogValidatorTest.$anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(x$8))), (long)1L);
        Assert.assertTrue((TestUtils$.MODULE$.meterCount(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec())) > 0L ? 1 : 0) != 0);
    }

    @Test(expected=InvalidRecordException.class)
    public void testCompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)DefaultCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test(expected=UnsupportedCompressionTypeException.class)
    public void testZStdCompressedWithUnavailableIBPVersion() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, 1234L, CompressionType.NONE);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef(0L), this.time(), now, (CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)ZStdCompressionCodec$.MODULE$, false, (byte)2, TimestampType.LOG_APPEND_TIME, 1000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, (ApiVersion)KAFKA_2_0_IV1$.MODULE$, this.brokerTopicStats());
    }

    @Test(expected=InvalidRecordException.class)
    public void testUncompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)NoCompressionCodec$.MODULE$);
    }

    @Test(expected=InvalidRecordException.class)
    public void testRecompressedBatchWithoutRecordsNotAllowed() {
        this.testBatchWithoutRecordsNotAllowed((CompressionCodec)NoCompressionCodec$.MODULE$, (CompressionCodec)DefaultCompressionCodec$.MODULE$);
    }

    @Test
    public void testInvalidTimestampExceptionHasBatchIndex() {
        long now = System.currentTimeMillis();
        MemoryRecords records = this.createRecords((byte)2, now - 1001L, CompressionType.GZIP);
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            TopicPartition x$2 = this.topicPartition();
            kafka.common.LongRef x$3 = new kafka.common.LongRef(0L);
            Time x$4 = this.time();
            long x$5 = System.currentTimeMillis();
            DefaultCompressionCodec$ x$6 = DefaultCompressionCodec$.MODULE$;
            DefaultCompressionCodec$ x$7 = DefaultCompressionCodec$.MODULE$;
            AppendOrigin.Client$ x$13 = AppendOrigin.Client$.MODULE$;
            ApiVersion x$14 = ApiVersion$.MODULE$.latestVersion();
            BrokerTopicStats x$15 = this.brokerTopicStats();
            return LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, x$2, x$3, x$4, x$5, (CompressionCodec)x$6, (CompressionCodec)x$7, false, (byte)1, TimestampType.CREATE_TIME, 1000L, -1, (AppendOrigin)x$13, x$14, x$15);
        }, ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1258));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Seq seq = e.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)seq.length(), (long)3L);
    }

    @Test
    public void testInvalidRecordExceptionHasBatchIndex() {
        RecordValidationException e2 = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateMessages(this.recordsWithInvalidInnerMagic((byte)0, (byte)1, CompressionType.GZIP), (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1284));
        e2.recordErrors().foreach((Function1 & Serializable)e -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$2(e);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)(e2.invalidException() instanceof InvalidRecordException));
        Assert.assertTrue((boolean)e2.recordErrors().nonEmpty());
        Seq seq = e2.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)seq.length(), (long)20L);
        e2.recordErrors().foreach((Function1 & Serializable)x$9 -> {
            LogValidatorTest.$anonfun$testInvalidRecordExceptionHasBatchIndex$3(x$9);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBatchWithInvalidRecordsAndInvalidTimestamp() {
        IntRef intRef;
        IndexedSeq indexedSeq;
        LegacyRecord legacyRecord;
        int n = 0;
        int until$extension_end = 5;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            LegacyRecord legacyRecord2;
            LegacyRecord legacyRecord3 = legacyRecord2 = LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            legacyRecord2 = null;
            legacyRecord = legacyRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            legacyRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_3 = null;
        Object var8_4 = null;
        Object var9_5 = null;
        legacyRecord = null;
        indexedSeq = null;
        IndexedSeq records = indexedSeq2;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)1, (CompressionType)CompressionType.GZIP, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        int create_e = 0;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef offset = intRef2;
        byte[] create_value = "timestamp".getBytes();
        Object var15_14 = null;
        builder.appendUncheckedWithOffset((long)offset.elem, LegacyRecord.create((byte)1, (long)1200L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME));
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(offset, builder, record);
            return BoxedUnit.UNIT;
        });
        MemoryRecords invalidOffsetTimestampRecords = builder.build();
        RecordValidationException e = (RecordValidationException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.validateMessages(invalidOffsetTimestampRecords, (byte)0, CompressionType.GZIP, CompressionType.GZIP), ClassTag$.MODULE$.apply(RecordValidationException.class), new Position("LogValidatorTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1318));
        Assert.assertTrue((boolean)(e.invalidException() instanceof InvalidTimestampException));
        Assert.assertTrue((boolean)e.recordErrors().nonEmpty());
        Seq seq = e.recordErrors();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)6L, (long)seq.length());
    }

    private void testBatchWithoutRecordsNotAllowed(CompressionCodec sourceCodec, CompressionCodec targetCodec) {
        int offset = 1234567;
        long l = 1324L;
        short s = (short)10;
        int n = 984;
        boolean bl = true;
        int n2 = 40;
        ByteBuffer buffer = ByteBuffer.allocate(61);
        DefaultRecordBatch.writeEmptyHeader((ByteBuffer)buffer, (byte)2, (long)l, (short)s, (int)n, (long)0L, (long)5L, (int)n2, (TimestampType)TimestampType.CREATE_TIME, (long)System.currentTimeMillis(), (boolean)bl, (boolean)false);
        buffer.flip();
        MemoryRecords records = MemoryRecords.readableRecords((ByteBuffer)buffer);
        LogValidator$.MODULE$.validateMessagesAndAssignOffsets(records, this.topicPartition(), new kafka.common.LongRef((long)offset), this.time(), System.currentTimeMillis(), sourceCodec, targetCodec, false, (byte)2, TimestampType.CREATE_TIME, 5000L, -1, (AppendOrigin)AppendOrigin.Client$.MODULE$, ApiVersion$.MODULE$.latestVersion(), this.brokerTopicStats());
    }

    private MemoryRecords createRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(1L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createRecords$default$2() {
        return -1L;
    }

    private MemoryRecords createNonIncreasingOffsetRecords(byte magicValue, long timestamp, CompressionType codec) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(512), (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.appendWithOffset(0L, timestamp, null, "hello".getBytes());
        builder.appendWithOffset(2L, timestamp, null, "there".getBytes());
        builder.appendWithOffset(3L, timestamp, null, "beautiful".getBytes());
        return builder.build();
    }

    private long createNonIncreasingOffsetRecords$default$2() {
        return -1L;
    }

    private CompressionType createNonIncreasingOffsetRecords$default$3() {
        return CompressionType.NONE;
    }

    private MemoryRecords createTwoBatchedRecords(byte magicValue, long timestamp, CompressionType codec) {
        ByteBuffer buf = ByteBuffer.allocate(2048);
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        builder.append(10L, "1".getBytes(), "a".getBytes());
        builder.close();
        builder = MemoryRecords.builder((ByteBuffer)buf, (byte)magicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)1L);
        builder.append(11L, "2".getBytes(), "b".getBytes());
        builder.append(12L, "3".getBytes(), "c".getBytes());
        builder.close();
        buf.flip();
        return MemoryRecords.readableRecords((ByteBuffer)buf.slice());
    }

    public void checkOffsets(MemoryRecords records, long baseOffset) {
        LongRef longRef;
        Assert.assertTrue((String)"Message set should not be empty", (boolean)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).nonEmpty());
        LongRef longRef2 = longRef = new LongRef(baseOffset);
        longRef = null;
        LongRef offset = longRef2;
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).foreach((Function1 & Serializable)entry -> {
            LogValidatorTest.$anonfun$checkOffsets$1(offset, entry);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords recordsWithInvalidInnerMagic(byte batchMagicValue, byte recordMagicValue, CompressionType codec) {
        IntRef intRef;
        IndexedSeq indexedSeq;
        LegacyRecord legacyRecord;
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive map_this = new Range.Exclusive(n, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            LegacyRecord legacyRecord2;
            LegacyRecord legacyRecord3 = legacyRecord2 = LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue, BoxesRunTime.unboxToInt((Object)object));
            legacyRecord2 = null;
            legacyRecord = legacyRecord3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            legacyRecord = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var8_6 = null;
        Object var9_7 = null;
        Object var10_8 = null;
        legacyRecord = null;
        indexedSeq = null;
        IndexedSeq records = indexedSeq2;
        int n2 = Math.max(BoxesRunTime.unboxToInt((Object)((IterableOnceOps)records.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.sizeInBytes()))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024);
        int min_y = 65536;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(Math.min(n2, min_y)), (byte)batchMagicValue, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME, (long)0L);
        int create_e = 1234567;
        IntRef intRef2 = intRef = new IntRef(create_e);
        intRef = null;
        IntRef offset = intRef2;
        records.foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$3(builder, offset, record);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public void maybeCheckBaseTimestamp(long expected, RecordBatch batch) {
        if (batch instanceof DefaultRecordBatch) {
            DefaultRecordBatch defaultRecordBatch = (DefaultRecordBatch)batch;
            Assert.assertEquals((String)new StringBuilder(35).append("Unexpected base timestamp of batch ").append(batch).toString(), (long)expected, (long)defaultRecordBatch.firstTimestamp());
            return;
        }
    }

    public void validateLogAppendTime(long expectedLogAppendTime, long expectedBaseTimestamp, RecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        TimestampType timestampType = batch.timestampType();
        TimestampType timestampType2 = TimestampType.LOG_APPEND_TIME;
        Assert.assertTrue((!(timestampType != null ? !timestampType.equals(timestampType2) : timestampType2 != null) ? 1 : 0) != 0);
        Assert.assertEquals((String)new StringBuilder(34).append("Unexpected max timestamp of batch ").append(batch).toString(), (long)expectedLogAppendTime, (long)batch.maxTimestamp());
        this.maybeCheckBaseTimestamp(expectedBaseTimestamp, batch);
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$validateLogAppendTime$1(expectedLogAppendTime, record);
            return BoxedUnit.UNIT;
        });
    }

    public void verifyRecordConversionStats(RecordConversionStats stats, int numConvertedRecords, MemoryRecords records, boolean compressed) {
        Assert.assertNotNull((String)"Records processing info is null", (Object)stats);
        Assert.assertEquals((long)numConvertedRecords, (long)stats.numRecordsConverted());
        if (numConvertedRecords > 0) {
            Assert.assertTrue((String)new StringBuilder(29).append("Conversion time not recorded ").append(stats).toString(), (stats.conversionTimeNanos() >= 0L ? 1 : 0) != 0);
            Assert.assertTrue((String)new StringBuilder(26).append("Conversion time not valid ").append(stats).toString(), (stats.conversionTimeNanos() <= TimeUnit.MINUTES.toNanos(1L) ? 1 : 0) != 0);
        }
        int originalSize = records.sizeInBytes();
        long tempBytes = stats.temporaryMemoryBytes();
        if (numConvertedRecords > 0 && compressed) {
            Assert.assertTrue((String)new StringBuilder(35).append("Temp bytes too small, orig=").append(originalSize).append(" actual=").append(tempBytes).toString(), (tempBytes > (long)originalSize ? 1 : 0) != 0);
            return;
        }
        if (numConvertedRecords > 0 || compressed) {
            Assert.assertTrue((String)"Temp bytes not updated", (tempBytes > 0L ? 1 : 0) != 0);
            return;
        }
        Assert.assertEquals((long)0L, (long)tempBytes);
    }

    public static final /* synthetic */ boolean $anonfun$checkMismatchMagic$2(MetricName x$1) {
        return x$1.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidMagicNumberRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$3(scala.collection.immutable.Seq timestampSeq$1, IntRef i$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(i$1.elem)), (long)record.timestamp());
        ++i$1.elem;
    }

    public static final /* synthetic */ void $anonfun$checkNonCompressed$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$1.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$1, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$1, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$1, (long)batch.baseSequence());
        Assert.assertEquals((Object)isTransactional$1, (Object)batch.isTransactional());
        Assert.assertEquals((long)partitionLeaderEpoch$1, (long)batch.partitionLeaderEpoch());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkNonCompressed$3(timestampSeq$1, i$1, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$3(scala.collection.immutable.Seq timestampSeq$2, IntRef i$2, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(i$2.elem)), (long)record.timestamp());
        ++i$2.elem;
    }

    public static final /* synthetic */ void $anonfun$checkRecompression$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$2.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$2, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$2, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$2, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$2, (long)batch.partitionLeaderEpoch());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkRecompression$3(timestampSeq$2, i$2, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$checkCreateTimeUpConversionFromV0$1(LogValidatorTest $this, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(-1L, (RecordBatch)batch);
        Assert.assertEquals((long)-1L, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$testCreateTimeUpConversionV1ToV2$1(LogValidatorTest $this, long timestamp$1, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        $this.maybeCheckBaseTimestamp(timestamp$1, (RecordBatch)batch);
        Assert.assertEquals((long)timestamp$1, (long)batch.maxTimestamp());
        Assert.assertEquals((Object)TimestampType.CREATE_TIME, (Object)batch.timestampType());
        Assert.assertEquals((long)-1L, (long)batch.producerEpoch());
        Assert.assertEquals((long)-1L, (long)batch.producerId());
        Assert.assertEquals((long)-1L, (long)batch.baseSequence());
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$3(scala.collection.immutable.Seq timestampSeq$3, IntRef i$3, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((long)BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(i$3.elem)), (long)record.timestamp());
        ++i$3.elem;
    }

    public static final /* synthetic */ void $anonfun$checkCompressed$1(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        Assert.assertTrue((boolean)batch.isValid());
        Assert.assertEquals((Object)batch.timestampType(), (Object)TimestampType.CREATE_TIME);
        $this.maybeCheckBaseTimestamp(BoxesRunTime.unboxToLong((Object)timestampSeq$3.apply(0)), (RecordBatch)batch);
        Assert.assertEquals((long)batch.maxTimestamp(), (long)BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.timestamp()))).max((Ordering)Ordering.Long$.MODULE$)));
        Assert.assertEquals((long)producerEpoch$3, (long)batch.producerEpoch());
        Assert.assertEquals((long)producerId$3, (long)batch.producerId());
        Assert.assertEquals((long)baseSequence$3, (long)batch.baseSequence());
        Assert.assertEquals((long)partitionLeaderEpoch$3, (long)batch.partitionLeaderEpoch());
        ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)batch).asScala()).foreach((Function1 & Serializable)record -> {
            LogValidatorTest.$anonfun$checkCompressed$3(timestampSeq$3, i$3, record);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testNonIncreasingOffsetRecordBatchHasMetricsLogged$2(MetricName x$8) {
        return x$8.getMBeanName().endsWith(String.valueOf(BrokerTopicStats$.MODULE$.InvalidOffsetOrSequenceRecordsPerSec()));
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$2(ProduceResponse.RecordError e) {
        String println_x = new StringBuilder(1).append(e.batchIndex).append(" ").append(e.message).toString();
        Console$.MODULE$.println((Object)println_x);
    }

    public static final /* synthetic */ void $anonfun$testInvalidRecordExceptionHasBatchIndex$3(ProduceResponse.RecordError x$9) {
        Assert.assertNotNull((Object)x$9);
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(int id) {
        byte[] create_value = ((Object)id).toString().getBytes();
        return LegacyRecord.create((byte)0, (long)0L, null, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$2(IntRef offset$1, MemoryRecordsBuilder builder$1, LegacyRecord record) {
        offset$1.elem += 30;
        builder$1.appendUncheckedWithOffset((long)offset$1.elem, record);
    }

    public static final /* synthetic */ void $anonfun$checkOffsets$1(LongRef offset$2, Record entry) {
        Assert.assertEquals((String)"Unexpected offset in message set iterator", (long)offset$2.elem, (long)entry.offset());
        ++offset$2.elem;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1(byte recordMagicValue$1, int id) {
        void create_value;
        void create_key;
        byte[] byArray = ((Object)id).toString().getBytes();
        byte[] byArray2 = ((Object)id).toString().getBytes();
        long create_timestamp = -1L;
        return LegacyRecord.create((byte)recordMagicValue$1, (long)create_timestamp, (byte[])create_key, (byte[])create_value, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME);
    }

    public static final /* synthetic */ void $anonfun$recordsWithInvalidInnerMagic$3(MemoryRecordsBuilder builder$2, IntRef offset$3, LegacyRecord record) {
        builder$2.appendUncheckedWithOffset((long)offset$3.elem, record);
        ++offset$3.elem;
    }

    public static final /* synthetic */ void $anonfun$validateLogAppendTime$1(long expectedLogAppendTime$1, Record record) {
        Assert.assertTrue((boolean)record.isValid());
        Assert.assertEquals((String)new StringBuilder(31).append("Unexpected timestamp of record ").append(record).toString(), (long)expectedLogAppendTime$1, (long)record.timestamp());
    }

    public static final /* synthetic */ Object $anonfun$checkNonCompressed$1$adapted(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$1, short producerEpoch$1, long producerId$1, int baseSequence$1, boolean isTransactional$1, int partitionLeaderEpoch$1, IntRef i$1, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkNonCompressed$1($this, timestampSeq$1, producerEpoch$1, producerId$1, baseSequence$1, isTransactional$1, partitionLeaderEpoch$1, i$1, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkRecompression$1$adapted(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$2, short producerEpoch$2, long producerId$2, int baseSequence$2, int partitionLeaderEpoch$2, IntRef i$2, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkRecompression$1($this, timestampSeq$2, producerEpoch$2, producerId$2, baseSequence$2, partitionLeaderEpoch$2, i$2, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$checkCompressed$1$adapted(LogValidatorTest $this, scala.collection.immutable.Seq timestampSeq$3, short producerEpoch$3, long producerId$3, int baseSequence$3, int partitionLeaderEpoch$3, IntRef i$3, MutableRecordBatch batch) {
        LogValidatorTest.$anonfun$checkCompressed$1($this, timestampSeq$3, producerEpoch$3, producerId$3, baseSequence$3, partitionLeaderEpoch$3, i$3, batch);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LegacyRecord $anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1$adapted(Object id) {
        return LogValidatorTest.$anonfun$testBatchWithInvalidRecordsAndInvalidTimestamp$1(BoxesRunTime.unboxToInt((Object)id));
    }

    public static final /* synthetic */ LegacyRecord $anonfun$recordsWithInvalidInnerMagic$1$adapted(byte recordMagicValue$1, Object id) {
        return LogValidatorTest.$anonfun$recordsWithInvalidInnerMagic$1(recordMagicValue$1, BoxesRunTime.unboxToInt((Object)id));
    }
}

