/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileBooleanRef;

@ScalaSignature(bytes="\u0006\u0005\u0005%c\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013\u0005a\u0005\u0003\u0004.\u0001\u0001\u0006Ia\n\u0005\b]\u0001\u0011\r\u0011\"\u0001'\u0011\u0019y\u0003\u0001)A\u0005O!9\u0001\u0007\u0001a\u0001\n\u0003\t\u0004bB!\u0001\u0001\u0004%\tA\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002\u001a\t\u000b%\u0003A\u0011\t&\t\u000bQ\u0003A\u0011\t&\t\u000be\u0003A\u0011\u0001&\t\u000by\u0003A\u0011\u0001&\t\u000b\u0001\u0004A\u0011\u0001&\t\u000b\t\u0004A\u0011\u0001&\t\u000b\u0011\u0004A\u0011B3\t\u000b-\u0004A\u0011\u00027\t\u000b5\u0004A\u0011\u00028\t\u000b]\u0004A\u0011\u0002=\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:\tQ\"I]8lKJ,\u0005o\\2i\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011acF\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003a\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00017A\u0011AdH\u0007\u0002;)\u0011adF\u0001\u0003u.L!\u0001I\u000f\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\t1\u0005\u0005\u0002%\u00015\tQ#A\u0005ce>\\WM]%ecU\tq\u0005\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013FA\u0002J]R\f!B\u0019:pW\u0016\u0014\u0018\nZ\u0019!\u0003%\u0011'o\\6fe&#''\u0001\u0006ce>\\WM]%ee\u0001\nqa]3sm\u0016\u00148/F\u00013!\r\u00194H\u0010\b\u0003ier!!\u000e\u001d\u000e\u0003YR!aN\r\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u001e*\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001P\u001f\u0003\u0007M+\u0017O\u0003\u0002;SA\u0011AeP\u0005\u0003\u0001V\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0019e\t\u0005\u0002)\t&\u0011Q)\u000b\u0002\u0005+:LG\u000fC\u0004H\u000f\u0005\u0005\t\u0019\u0001\u001a\u0002\u0007a$\u0013'\u0001\u0005tKJ4XM]:!\u0003\u0015\u0019X\r^+q)\u0005\u0019\u0005FA\u0005M!\ti%+D\u0001O\u0015\ty\u0005+A\u0003kk:LGOC\u0001R\u0003\ry'oZ\u0005\u0003':\u0013aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0005)1\u0006CA'X\u0013\tAfJA\u0003BMR,'/\u0001\u0016uKN$(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014(I]8lKJ,\u0005o\\2i\u001b\u0006$8\r[3t/&$\bNW6)\u0005-Y\u0006CA']\u0013\tifJ\u0001\u0003UKN$\u0018a\u000b;fgR\u001cuN\u001c;s_2dWM\u001d\"s_.,'/\u00129pG\"\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6)\u00051Y\u0016\u0001\u000b;fgR\u001cuN\u001c;s_2\u0014V-];fgR<\u0016\u000e\u001e5D_J\u0014Xm\u0019;Ce>\\WM]#q_\u000eD\u0007FA\u0007\\\u0003\u0019\"Xm\u001d;D_:$(o\u001c7SKF,Xm\u001d;XSRD7\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u0003\u001dm\u000b\u0011\u0005^3ti\u000e{g\u000e\u001e:pYJ+\u0017/^3ti^KG\u000f\u001b\"s_.,'/\u00129pG\"$\"a\u00114\t\u000b\u001d|\u0001\u0019\u00015\u0002+%\u001cX\t]8dQ&s'+Z9vKN$8\u000b^1mKB\u0011\u0001&[\u0005\u0003U&\u0012qAQ8pY\u0016\fg.A\u0007hKR\u001cuN\u001c;s_2dWM]\u000b\u0002}\u0005i3\r[3dW\u000e{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014X\t]8dQN\u001c\u0015m\u00195f\u001b\u0006$8\r[3t/&$\bNW6\u0015\u0005\r{\u0007\"\u00029\u0012\u0001\u0004\t\u0018!E2p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yiB\u0011!/^\u0007\u0002g*\u0011AoF\u0001\u000bG>tGO]8mY\u0016\u0014\u0018B\u0001<t\u0005E\u0019uN\u001c;s_2dWM]\"p]R,\u0007\u0010^\u0001(g\u0016tG-\u00118e-\u0016\u0014\u0018NZ=Ti\u0006dWM\u0011:pW\u0016\u0014X\t]8dQ&s'+Z:q_:\u001cX\rF\u0002DszDQA\u001f\nA\u0002m\f\u0001dY8oiJ|G\u000e\\3s\u0007\"\fgN\\3m\u001b\u0006t\u0017mZ3s!\t\u0011H0\u0003\u0002~g\nA2i\u001c8ue>dG.\u001a:DQ\u0006tg.\u001a7NC:\fw-\u001a:\t\r}\u0014\u0002\u0019AA\u0001\u0003\u001d\u0011W/\u001b7eKJ\u0004D!a\u0001\u0002&A1\u0011QAA\u000e\u0003CqA!a\u0002\u0002\u00185\u0011\u0011\u0011\u0002\u0006\u0005\u0003\u0017\ti!\u0001\u0005sKF,Xm\u001d;t\u0015\u0011\ty!!\u0005\u0002\r\r|W.\\8o\u0015\rA\u00121\u0003\u0006\u0004\u0003+\u0001\u0016AB1qC\u000eDW-\u0003\u0003\u0002\u001a\u0005%\u0011AF!cgR\u0014\u0018m\u0019;D_:$(o\u001c7SKF,Xm\u001d;\n\t\u0005u\u0011q\u0004\u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tI\"!\u0003\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t-\t9C`A\u0001\u0002\u0003\u0015\t!!\u000b\u0003\u0007}#\u0013'\u0005\u0003\u0002,\u0005E\u0002c\u0001\u0015\u0002.%\u0019\u0011qF\u0015\u0003\u000f9{G\u000f[5oOB!\u0011qAA\u001a\u0013\u0011\t)$!\u0003\u0003-\u0005\u00137\u000f\u001e:bGR\u001cuN\u001c;s_2\u0014V-];fgR\fqd]3oI\u0006sGMV3sS\u001aL8+^2dKN\u001ch-\u001e7SKN\u0004xN\\:f)\u0015\u0019\u00151HA\u001f\u0011\u0015Q8\u00031\u0001|\u0011\u0019y8\u00031\u0001\u0002@A\"\u0011\u0011IA#!\u0019\t)!a\u0007\u0002DA!\u00111EA#\t1\t9%!\u0010\u0002\u0002\u0003\u0005)\u0011AA\u0015\u0005\ryFE\r")
public class BrokerEpochIntegrationTest
extends ZooKeeperTestHarness {
    private final int brokerId1;
    private final int brokerId2;
    private scala.collection.immutable.Seq<KafkaServer> servers = (scala.collection.immutable.Seq)Seq$.MODULE$.empty();

    public int brokerId1() {
        return this.brokerId1;
    }

    public int brokerId2() {
        return this.brokerId2;
    }

    public scala.collection.immutable.Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Object[] objectArray = new Properties[2];
        objectArray[0] = TestUtils$.MODULE$.createBrokerConfig(this.brokerId1(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        objectArray[1] = TestUtils$.MODULE$.createBrokerConfig(this.brokerId2(), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        scala.collection.immutable.Seq configs = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        configs.foreach((Function1 & Serializable)config -> config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)false).toString()));
        this.servers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)configs.map((Function1 & Serializable)config -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, (Option<String>)None$.MODULE$))));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.servers());
        super.tearDown();
    }

    @Test
    public void testReplicaManagerBrokerEpochMatchesWithZk() {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        scala.collection.immutable.Seq<KafkaServer> seq = this.servers();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((long)brokerAndEpochs.size(), (long)seq.length());
        brokerAndEpochs.foreach((Function1 & Serializable)x0$1 -> {
            BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testControllerBrokerEpochCacheMatchesWithZk() {
        KafkaServer controller = this.getController();
        KafkaServer otherBroker = (KafkaServer)this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(controller, e))).get();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.shutdown();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
        otherBroker.startup();
        this.checkControllerBrokerEpochsCacheMatchesWithZk(controller.kafkaController().controllerContext());
    }

    @Test
    public void testControlRequestWithCorrectBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(false);
    }

    @Test
    public void testControlRequestWithStaleBrokerEpoch() {
        this.testControlRequestWithBrokerEpoch(true);
    }

    /*
     * WARNING - void declaration
     */
    private void testControlRequestWithBrokerEpoch(boolean isEpochInRequestStale) {
        void apply_elems;
        void $minus$greater$extension_y;
        TopicPartition tp = new TopicPartition("new-topic", 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()}));
        Integer $minus$greater$extension_$this = 0;
        Object var23_4 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), tp.topic(), (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)), (Seq<KafkaServer>)this.servers());
        int controllerId = 2;
        int controllerEpoch = ((Tuple2)this.zkClient().getControllerEpoch().get())._1$mcI$sp();
        KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        scala.collection.immutable.Map brokerAndEpochs = ((IterableOnceOps)this.servers().map((Function1 & Serializable)s -> new Tuple2((Object)new Broker(s.config().brokerId(), "localhost", TestUtils$.MODULE$.boundPort((KafkaServer)s, SecurityProtocol.PLAINTEXT), listenerName, securityProtocol), (Object)s.kafkaController().brokerEpoch()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Iterable nodes = (Iterable)brokerAndEpochs.keys().map((Function1 & Serializable)x$1 -> x$1.node(listenerName));
        ControllerContext controllerContext = new ControllerContext();
        controllerContext.setLiveBrokerAndEpochs((Map)brokerAndEpochs);
        Metrics metrics = new Metrics();
        ControllerChannelManager controllerChannelManager = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), (Option)None$.MODULE$);
        controllerChannelManager.startup();
        KafkaServer broker2 = (KafkaServer)this.servers().apply(this.brokerId2());
        long epochInRequest = isEpochInRequestStale ? broker2.kafkaController().brokerEpoch() - 1L : broker2.kafkaController().brokerEpoch();
        try {
            void apply_elems2;
            Buffer buffer;
            scala.collection.immutable.Seq partitionStates = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LeaderAndIsrRequestData.LeaderAndIsrPartitionState[]{new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setIsNew(false)}));
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, epochInRequest, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)nodes.toSet()).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder);
                TestUtils$.MODULE$.waitUntilLeaderIsKnown((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp, 10000L);
            }
            scala.collection.immutable.Seq partitionStates2 = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataPartitionState[]{new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(tp.topic()).setPartitionIndex(tp.partition()).setControllerEpoch(controllerEpoch).setLeader(this.brokerId2()).setLeaderEpoch(LeaderAndIsr$.MODULE$.initialLeaderEpoch() + 1).setIsr((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{this.brokerId1(), this.brokerId2()})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava()).setZkVersion(LeaderAndIsr$.MODULE$.initialZKVersion()).setReplicas((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})).map((Function1 & Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1))).asJava())}));
            IterableOnceOps iterableOnceOps = (IterableOnceOps)brokerAndEpochs.map((Function1 & Serializable)x0$1 -> {
                void orNull_ev;
                .eq.colon.eq eq2;
                Option option;
                scala.collection.immutable.Seq endpoints;
                Broker broker;
                if (x0$1 != null) {
                    broker = (Broker)x0$1._1();
                    SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
                    ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
                    Node node = broker.node(listenerName);
                    endpoints = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UpdateMetadataRequestData.UpdateMetadataEndpoint[]{new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(node.host()).setPort(node.port()).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value())}));
                    option = broker.rack();
                    eq2 = $less$colon$less$.MODULE$.refl();
                    if (option == null) {
                        throw null;
                    }
                } else {
                    throw new MatchError(null);
                }
                Option orNull_this = option;
                Object object = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
                Object object2 = object;
                Object var7_7 = null;
                eq2 = null;
                object = null;
                UpdateMetadataRequestData.UpdateMetadataBroker updateMetadataBroker = new UpdateMetadataRequestData.UpdateMetadataBroker().setId(broker.id()).setEndpoints((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)endpoints).asJava()).setRack((String)object2);
                return updateMetadataBroker;
            });
            if (iterableOnceOps == null) {
                throw null;
            }
            IterableOnceOps toBuffer_this = iterableOnceOps;
            Buffer buffer2 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
            Object var25_21 = null;
            buffer = null;
            Buffer liveBrokers = buffer2;
            UpdateMetadataRequest.Builder requestBuilder2 = new UpdateMetadataRequest.Builder(ApiKeys.UPDATE_METADATA.latestVersion(), controllerId, controllerEpoch, epochInRequest, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates2).asJava(), (List)JavaConverters$.MODULE$.bufferAsJavaListConverter(liveBrokers).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder2);
                TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{broker2}))), tp.topic(), tp.partition(), 10000L);
                Assert.assertEquals((long)this.brokerId2(), (long)((UpdateMetadataRequestData.UpdateMetadataPartitionState)broker2.metadataCache().getPartitionInfo(tp.topic(), tp.partition()).get()).leader());
            }
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
            if (set$ == null) {
                throw null;
            }
            arraySeq2 = null;
            StopReplicaRequest.Builder requestBuilder3 = new StopReplicaRequest.Builder(ApiKeys.STOP_REPLICA.latestVersion(), controllerId, controllerEpoch, epochInRequest, true, (Collection)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).asJava());
            if (isEpochInRequestStale) {
                this.sendAndVerifyStaleBrokerEpochInResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
            } else {
                this.sendAndVerifySuccessfulResponse(controllerChannelManager, (AbstractControlRequest.Builder<? extends AbstractControlRequest>)requestBuilder3);
                Assert.assertEquals((Object)HostedPartition.None$.MODULE$, (Object)broker2.replicaManager().getPartition(tp));
            }
        }
        finally {
            controllerChannelManager.shutdown();
            metrics.close();
        }
    }

    private KafkaServer getController() {
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), 15000L);
        return (KafkaServer)((IterableOps)this.servers().filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$getController$1(controllerId, s)))).head();
    }

    private void checkControllerBrokerEpochsCacheMatchesWithZk(ControllerContext controllerContext) {
        Map brokerAndEpochs = this.zkClient().getAllBrokerAndEpochsInCluster();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$1(controllerContext, brokerAndEpochs)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Broker epoch mismatches", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private void sendAndVerifyStaleBrokerEpochInResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        BooleanRef booleanRef;
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef staleBrokerEpochDetected = booleanRef2;
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable)response -> {
            staleBrokerEpochDetected.elem = response.errorCounts().containsKey(Errors.STALE_BROKER_EPOCH);
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!staleBrokerEpochDetected.elem) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Broker epoch should be stale", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertTrue((String)"Stale broker epoch not detected by the broker", (boolean)staleBrokerEpochDetected.elem);
    }

    private void sendAndVerifySuccessfulResponse(ControllerChannelManager controllerChannelManager, AbstractControlRequest.Builder<? extends AbstractControlRequest> builder) {
        VolatileBooleanRef volatileBooleanRef;
        boolean create_e = false;
        VolatileBooleanRef volatileBooleanRef2 = volatileBooleanRef = new VolatileBooleanRef(create_e);
        volatileBooleanRef = null;
        VolatileBooleanRef succeed = volatileBooleanRef2;
        controllerChannelManager.sendRequest(this.brokerId2(), builder, (Function1 & Serializable)response -> {
            succeed.elem = response.errorCounts().isEmpty() || response.errorCounts().containsKey(Errors.NONE) && response.errorCounts().size() == 1;
            return BoxedUnit.UNIT;
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!succeed.elem) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Should receive response with no errors", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(Broker broker$1, KafkaServer e) {
        return e.config().brokerId() == broker$1.id();
    }

    public static final /* synthetic */ void $anonfun$testReplicaManagerBrokerEpochMatchesWithZk$1(BrokerEpochIntegrationTest $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            Broker broker = (Broker)x0$1._1();
            long epoch = x0$1._2$mcJ$sp();
            Option brokerServer = $this.servers().find((Function1 & Serializable)e -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$testReplicaManagerBrokerEpochMatchesWithZk$2(broker, e)));
            Assert.assertTrue((boolean)brokerServer.isDefined());
            Assert.assertEquals((long)epoch, (long)((KafkaServer)brokerServer.get()).kafkaController().brokerEpoch());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$testControllerBrokerEpochCacheMatchesWithZk$1(KafkaServer controller$1, KafkaServer e) {
        return e.config().brokerId() != controller$1.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(Map brokerEpochsInControllerContext$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        Broker broker = (Broker)x0$1._1();
        long epoch = x0$1._2$mcJ$sp();
        boolean bl = brokerEpochsInControllerContext$1.get((Object)broker.id()).contains((Object)epoch);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$1(ControllerContext controllerContext$1, Map brokerAndEpochs$1) {
        Map brokerEpochsInControllerContext = controllerContext$1.liveBrokerIdAndEpochs();
        if (brokerAndEpochs$1.size() != brokerEpochsInControllerContext.size()) {
            return false;
        }
        return brokerAndEpochs$1.forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerEpochIntegrationTest.$anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$2(brokerEpochsInControllerContext, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$checkControllerBrokerEpochsCacheMatchesWithZk$3() {
        return "Broker epoch mismatches";
    }

    public static final /* synthetic */ boolean $anonfun$sendAndVerifyStaleBrokerEpochInResponse$2(BooleanRef staleBrokerEpochDetected$1) {
        return staleBrokerEpochDetected$1.elem;
    }

    public static final /* synthetic */ String $anonfun$sendAndVerifyStaleBrokerEpochInResponse$3() {
        return "Broker epoch should be stale";
    }

    public static final /* synthetic */ boolean $anonfun$sendAndVerifySuccessfulResponse$2(VolatileBooleanRef succeed$1) {
        return succeed$1.elem;
    }

    public static final /* synthetic */ String $anonfun$sendAndVerifySuccessfulResponse$3() {
        return "Should receive response with no errors";
    }

    public BrokerEpochIntegrationTest() {
        this.brokerId1 = 0;
        this.brokerId2 = 1;
    }
}

