/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005M4AAC\u0006\u0001!!)Q\u0003\u0001C\u0001-!)\u0001\u0004\u0001C\u00013!)\u0011\u0006\u0001C\u0005U!)\u0001\b\u0001C\u00013!)!\b\u0001C\u0005w!)1\u000b\u0001C\u00013!)Q\u000b\u0001C\u0005-\")\u0011\f\u0001C\u00055\"9q\rAI\u0001\n\u0013A'a\u0006#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0015\taQ\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001d\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0012!\t\u00112#D\u0001\f\u0013\t!2BA\bCCN,'+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\u0003\u0005\u0002\u0013\u0001\u0005aB/Z:u-\u0006d\u0017\u000e\u001a#fY\u0016$X\rV8qS\u000e\u0014V-];fgR\u001cH#\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005\u0005\u0002\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u000b),h.\u001b;\u000b\u0003\u0019\n1a\u001c:h\u0013\tA3E\u0001\u0003UKN$\u0018\u0001\t<bY&$\u0017\r^3WC2LG\rR3mKR,Gk\u001c9jGJ+\u0017/^3tiN$\"AG\u0016\t\u000b1\u001a\u0001\u0019A\u0017\u0002\u000fI,\u0017/^3tiB\u0011aFN\u0007\u0002_)\u0011\u0001'M\u0001\te\u0016\fX/Z:ug*\u0011!gM\u0001\u0007G>lWn\u001c8\u000b\u00059!$BA\u001b&\u0003\u0019\t\u0007/Y2iK&\u0011qg\f\u0002\u0014\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f^\u0001\u001di\u0016\u001cH/\u0012:s_J$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;tQ\t!\u0011%\u0001\u0011wC2LG-\u0019;f\u000bJ\u0014xN\u001d#fY\u0016$X\rV8qS\u000e\u0014V-];fgR\u001cHc\u0001\u000e={!)A&\u0002a\u0001[!)a(\u0002a\u0001\u007f\u0005\u0001R\r\u001f9fGR,GMU3ta>t7/\u001a\t\u0005\u0001\u001eSUJ\u0004\u0002B\u000bB\u0011!\tH\u0007\u0002\u0007*\u0011AiD\u0001\u0007yI|w\u000e\u001e \n\u0005\u0019c\u0012A\u0002)sK\u0012,g-\u0003\u0002I\u0013\n\u0019Q*\u00199\u000b\u0005\u0019c\u0002C\u0001!L\u0013\ta\u0015J\u0001\u0004TiJLgn\u001a\t\u0003\u001dFk\u0011a\u0014\u0006\u0003!F\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003%>\u0013a!\u0012:s_J\u001c\u0018!\u0005;fgRtu\u000e^\"p]R\u0014x\u000e\u001c7fe\"\u0012a!I\u0001\u0017m\u0006d\u0017\u000eZ1uKR{\u0007/[2Jg\u0012+G.\u001a;fIR\u0011!d\u0016\u0005\u00061\u001e\u0001\rAS\u0001\u0006i>\u0004\u0018nY\u0001\u0018g\u0016tG\rR3mKR,Gk\u001c9jGN\u0014V-];fgR$2a\u00170`!\tqC,\u0003\u0002^_\t!B)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016DQ\u0001\f\u0005A\u00025Bq\u0001\u0019\u0005\u0011\u0002\u0003\u0007\u0011-\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002cK6\t1M\u0003\u0002e\u001b\u00059a.\u001a;x_J\\\u0017B\u00014d\u00051\u0019vnY6fiN+'O^3s\u0003\u0005\u001aXM\u001c3EK2,G/\u001a+pa&\u001c7OU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005I'FA1kW\u0005Y\u0007C\u00017r\u001b\u0005i'B\u00018p\u0003%)hn\u00195fG.,GM\u0003\u0002q9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Il'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        this.createTopic("topic-1", 1, 1, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-1")).setTimeoutMs(timeout)).build());
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4());
        this.validateValidDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("topic-3", "topic-4")).setTimeoutMs(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        Option error = ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateValidDeleteTopicRequests$1(x$1)));
        Assert.assertTrue((String)new StringBuilder(33).append("There should be no errors, found ").append(JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)response.data().responses()).asScala()).toString(), (boolean)error.isEmpty());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(request.data().topicNames()).asScala()).foreach((Function1 & Serializable)topic -> {
            this.validateTopicIsDeleted(topic);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testErrorDeleteTopicRequests() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Errors errors = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        String $minus$greater$extension_$this = "invalid-topic";
        Object var3_4 = null;
        errors = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("invalid-topic")).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3)));
        this.createTopic("partial-topic-1", 1, 1, this.createTopic$default$4());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        Errors errors2 = Errors.NONE;
        String $minus$greater$extension_$this2 = "partial-topic-1";
        Object var5_7 = null;
        errors2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        Errors errors3 = Errors.UNKNOWN_TOPIC_OR_PARTITION;
        String $minus$greater$extension_$this3 = "partial-invalid-topic";
        Object var7_9 = null;
        errors3 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList("partial-topic-1", "partial-invalid-topic")).setTimeoutMs(timeout)).build(), (Map<String, Errors>)((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems2)));
        this.createTopic(timeoutTopic, 5, 2, this.createTopic$default$4());
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        Errors $minus$greater$extension_y4 = Errors.REQUEST_TIMED_OUT;
        Object var9_11 = null;
        objectArray3[0] = new Tuple2((Object)timeoutTopic, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.validateErrorDeleteTopicRequests((DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList(timeoutTopic)).setTimeoutMs(0)).build(), (Map<String, Errors>)((Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems)));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$1(this, timeoutTopic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(DeleteTopicsRequestTest.$anonfun$testErrorDeleteTopicRequests$2(timeoutTopic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        this.validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.controllerSocketServer());
        DeleteTopicsResponseData.DeletableTopicResultCollection errors = response.data().responses();
        int errorCount = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala()).foldLeft((Object)0, (Function2 & Serializable)(x$2, x$3) -> BoxesRunTime.boxToInteger((int)DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$1(BoxesRunTime.unboxToInt((Object)x$2), x$3))));
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)errorCount);
        expectedResponse.foreach((Function1 & Serializable)x0$1 -> {
            DeleteTopicsRequestTest.$anonfun$validateErrorDeleteTopicRequests$2(this, expectedResponse, errors, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testNotController() {
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Collections.singletonList("not-controller")).setTimeoutMs(1000)).build();
        short error = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer()).data().responses().find("not-controller").errorCode();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (long)Errors.NOT_CONTROLLER.code(), (long)error);
    }

    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).topicMetadata()).asScala();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$3(topic), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    public static final /* synthetic */ boolean $anonfun$validateValidDeleteTopicRequests$1(Tuple2 x$1) {
        Object object = x$1._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$testErrorDeleteTopicRequests$1(DeleteTopicsRequestTest $this, String timeoutTopic$1) {
        return !((KafkaServer)$this.servers().head()).metadataCache().contains(timeoutTopic$1);
    }

    public static final /* synthetic */ String $anonfun$testErrorDeleteTopicRequests$2(String timeoutTopic$1) {
        return new StringBuilder(23).append("Topic ").append(timeoutTopic$1).append(" is never deleted").toString();
    }

    public static final /* synthetic */ int $anonfun$validateErrorDeleteTopicRequests$1(int x$2, Tuple2 x$3) {
        return x$2 + Predef$.MODULE$.Integer2int((Integer)x$3._2());
    }

    public static final /* synthetic */ void $anonfun$validateErrorDeleteTopicRequests$2(DeleteTopicsRequestTest $this, Map expectedResponse$1, DeleteTopicsResponseData.DeletableTopicResultCollection errors$1, Tuple2 x0$1) {
        block7: {
            block4: {
                String topic;
                block6: {
                    Errors errors;
                    Errors errors2;
                    block5: {
                        if (x0$1 == null) break block4;
                        topic = (String)x0$1._1();
                        Errors expectedError = (Errors)x0$1._2();
                        Assert.assertEquals((String)"The response error should match", (long)((Errors)expectedResponse$1.apply((Object)topic)).code(), (long)errors$1.find(topic).errorCode());
                        errors2 = expectedError;
                        errors = Errors.NONE;
                        if (errors2 != null) break block5;
                        if (errors != null) {
                            return;
                        }
                        break block6;
                    }
                    if (!errors2.equals(errors)) break block7;
                }
                $this.validateTopicIsDeleted(topic);
                return;
            }
            throw new MatchError(null);
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeleteTopicsRequestTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

