/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.Log;
import kafka.log.LogAppendInfo;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.server.LogOffsetTest$;
import kafka.utils.MockTime;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactoryDefaults;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LazyZip2;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.View;
import scala.collection.WithFilter;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005ma\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uA\u0001b\b\u0001\t\u0006\u0004%I\u0001\t\u0005\u0006O\u0001!\t\u0005\u000b\u0005\u0006_\u0001!\t\u0006\r\u0005\u0006g\u0001!\t\u0006\u000e\u0005\u0006\u0005\u0002!\ta\u0011\u0005\u0006+\u0002!\ta\u0011\u0005\u00061\u0002!\ta\u0011\u0005\u00065\u0002!\ta\u0011\u0005\u00069\u0002!\ta\u0011\u0005\u0006C\u0002!\ta\u0011\u0005\u0006I\u0002!\ta\u0011\u0005\u0006M\u0002!\ta\u0011\u0005\u0006'\u0001!I\u0001\u001b\u0005\u0006Y\u0002!I!\u001c\u0005\u0006}\u0002!Ia \u0002\u000e\u0019><wJ\u001a4tKR$Vm\u001d;\u000b\u0005M!\u0012AB:feZ,'OC\u0001\u0016\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eQR\"\u0001\n\n\u0005m\u0011\"a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005q\u0002CA\r\u0001\u0003\u0011!\u0018.\\3\u0016\u0003\u0005\u0002\"AI\u0013\u000e\u0003\rR!\u0001\n\u000b\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0019\u001a#\u0001C'pG.$\u0016.\\3\u0002\u0017\t\u0014xn[3s\u0007>,h\u000e^\u000b\u0002SA\u0011!&L\u0007\u0002W)\tA&A\u0003tG\u0006d\u0017-\u0003\u0002/W\t\u0019\u0011J\u001c;\u0002\u0015\t\u0014xn[3s)&lW\r\u0006\u0002\"c!)!\u0007\u0002a\u0001S\u0005A!M]8lKJLE-A\fce>\\WM\u001d)s_B,'\u000f^=Pm\u0016\u0014(/\u001b3fgR\u0011Q\u0007\u000f\t\u0003UYJ!aN\u0016\u0003\tUs\u0017\u000e\u001e\u0005\u0006s\u0015\u0001\rAO\u0001\u0006aJ|\u0007o\u001d\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005)\u0001&o\u001c9feRLWm]\u0001\u001ei\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\r>\u0014XK\\6o_^tGk\u001c9jGR\tQ\u0007\u000b\u0002\u0007\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002\u0015\u0006\u0019qN]4\n\u00051;%\u0001\u0002+fgRDCA\u0002(R'B\u0011!fT\u0005\u0003!.\u0012!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005\u0011\u0016!\u0006'jgR|eMZ:fiN\u0014V-];fgR\u0004c\u000bM\u0011\u0002)\u0006\u0001\u0011\u0001\t;fgR<U\r^(gMN,Go]!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND#aB#)\t\u001dq\u0015kU\u0001\u001fi\u0016\u001cHoR3u\u001f\u001a47/\u001a;t\u0005\u00164wN]3MCR,7\u000f\u001e+j[\u0016D#\u0001C#\u0002/Q,7\u000f^#naRLHj\\4t\u000f\u0016$xJ\u001a4tKR\u001c\bFA\u0005F\u0003]!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK:{w\u000f\u000b\u0002\u000b\u000b\"\"!BT0TC\u0005\u0001\u0017\u0001\u00077fO\u0006\u001c\u0017PR3uG\"|eMZ:fiN\u0014UMZ8sK\u0006\u0001C/Z:u\u000f\u0016$xJ\u001a4tKR\u001c()\u001a4pe\u0016,\u0015M\u001d7jKN$H+[7fQ\tYQ\t\u000b\u0003\f\u001d~\u001b\u0016!\f;fgR4U\r^2i\u001f\u001a47/\u001a;t\u0005\u00164wN]3XSRD7\t[1oO&twmU3h[\u0016tGoU5{K\"\u0012A\"R\u0001+i\u0016\u001cHOR3uG\"|eMZ:fiN\u0014UMZ8sK^KG\u000f[\"iC:<\u0017N\\4TK\u001elWM\u001c;tQ\tiQ)F\u0001j!\tI\".\u0003\u0002l%\tY1*\u00194lCN+'O^3s\u0003Y\u0019XM\u001c3MSN$xJ\u001a4tKR\u001c(+Z9vKN$HC\u00018z!\tyw/D\u0001q\u0015\t\t(/\u0001\u0005sKF,Xm\u001d;t\u0015\t\u0019H/\u0001\u0004d_6lwN\u001c\u0006\u0003+UT!A^%\u0002\r\u0005\u0004\u0018m\u00195f\u0013\tA\bO\u0001\nMSN$xJ\u001a4tKR\u0014Vm\u001d9p]N,\u0007\"\u0002>\u0010\u0001\u0004Y\u0018a\u0002:fcV,7\u000f\u001e\t\u0003_rL!! 9\u0003#1K7\u000f^(gMN,GOU3rk\u0016\u001cH/\u0001\ttK:$g)\u001a;dQJ+\u0017/^3tiR!\u0011\u0011AA\n!\u0015y\u00171AA\u0004\u0013\r\t)\u0001\u001d\u0002\u000e\r\u0016$8\r\u001b*fgB|gn]3\u0011\t\u0005%\u0011qB\u0007\u0003\u0003\u0017Q1!!\u0004s\u0003\u0019\u0011XmY8sI&!\u0011\u0011CA\u0006\u00055iU-\\8ssJ+7m\u001c:eg\"1!\u0010\u0005a\u0001\u0003+\u00012a\\A\f\u0013\r\tI\u0002\u001d\u0002\r\r\u0016$8\r\u001b*fcV,7\u000f\u001e")
public class LogOffsetTest
extends BaseRequestTest {
    private MockTime time;
    private volatile boolean bitmap$0;

    private MockTime time$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.time = new MockTime();
                this.bitmap$0 = true;
            }
        }
        return this.time;
    }

    private MockTime time() {
        if (!this.bitmap$0) {
            return this.time$lzycompute();
        }
        return this.time;
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    public MockTime brokerTime(int brokerId) {
        return this.time();
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", ((Object)300000).toString());
        props.put("log.segment.bytes", "140");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsForUnknownTopic() {
        void apply_elems;
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(-1L, 10);
        Object var4_2 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava()).build((short)0);
        ListOffsetResponse response = this.sendListOffsetsRequest(request);
        Assert.assertEquals((Object)Errors.UNKNOWN_TOPIC_OR_PARTITION, (Object)((ListOffsetResponse.PartitionData)response.responseData().get((Object)topicPartition)).error);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsAfterDeleteRecords() {
        void apply_elems;
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsAfterDeleteRecords$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Log for partition [topic,0] should be created", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var13_10 = null;
        log.flush();
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(-1L, 15);
        Object var9_16 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeLatestTime() {
        void apply_elems;
        void apply_elems2;
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$1(logManager, topicPartition)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(LogOffsetTest.$anonfun$testGetOffsetsBeforeLatestTime$2(topicPartition), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Log log = (Log)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var16_10 = null;
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(-1L, 15);
        Object var10_16 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems2)).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        FetchRequest.PartitionData $minus$greater$extension_y2 = new FetchRequest.PartitionData(BoxesRunTime.unboxToLong((Object)((Long)consumerOffsets.head())), -1L, 307200, Optional.empty());
        Object var11_20 = null;
        objectArray2[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((int)0, (int)1, (java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems)).asJava())).build();
        Assert.assertFalse((boolean)((MemoryRecords)((FetchResponse.PartitionData)this.sendFetchRequest((FetchRequest)fetchRequest).responseData().get((Object)topicPartition)).records).batches().iterator().hasNext());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEmptyLogsGetOffsets() {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new java.lang.StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4());
        boolean bl = false;
        int n = 1;
        int to$extension_end = 14;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                void $anonfun$testEmptyLogsGetOffsets$1_apply_elems;
                TopicPartition $anonfun$testEmptyLogsGetOffsets$1_topicPartition = new TopicPartition(topic, 0);
                Map$ map$ = Predef$.MODULE$.Map();
                Object[] objectArray = new Tuple2[1];
                ListOffsetRequest.PartitionData $anonfun$testEmptyLogsGetOffsets$1_$minus$greater$extension_y = new ListOffsetRequest.PartitionData(-2L, 1);
                Object var11_12 = null;
                objectArray[0] = new Tuple2((Object)$anonfun$testEmptyLogsGetOffsets$1_topicPartition, (Object)$anonfun$testEmptyLogsGetOffsets$1_$minus$greater$extension_y);
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
                if (map$ == null) {
                    throw null;
                }
                arraySeq = null;
                ListOffsetRequest $anonfun$testEmptyLogsGetOffsets$1_request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)$anonfun$testEmptyLogsGetOffsets$1_apply_elems)).asJava()).build();
                if (BoxesRunTime.equals((Object)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)$anonfun$testEmptyLogsGetOffsets$1_request).responseData().get((Object)$anonfun$testEmptyLogsGetOffsets$1_topicPartition)).offsets).asScala()).head(), (Object)1)) {
                    bl = true;
                }
                Object var9_10 = null;
                Object var10_11 = null;
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var6_8 = null;
        Assert.assertFalse((boolean)bl);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeNow() {
        void apply_elems;
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var14_8 = null;
        log.flush();
        long now = this.time().milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(now, 15);
        Object var12_15 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetOffsetsBeforeEarliestTime() {
        void apply_elems;
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4());
        LogManager logManager = this.server().getLogManager();
        Log log = logManager.getOrCreateLog(topicPartition, logManager.initialDefaultConfig(), logManager.getOrCreateLog$default$3(), logManager.getOrCreateLog$default$4());
        int n = 0;
        int until$extension_end = 20;
        Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4());
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
        Object var12_8 = null;
        log.flush();
        Seq offsets = log.legacyFetchOffsetsBefore(-2L, 10);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.server())) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Leader should be elected", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(-2L, 10);
        Object var10_14 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava()).build();
        Buffer consumerOffsets = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)this.sendListOffsetsRequest((ListOffsetRequest)request).responseData().get((Object)topicPartition)).offsets).asScala();
        Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegmentSize() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)logSegment.size()).andStubAnswer((IAnswer)new IAnswer<Object>(null){
            private final AtomicInteger value;

            private AtomicInteger value() {
                return this.value;
            }

            public int answer() {
                return this.value().getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        scala.collection.immutable.Seq logSegments = (scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{logSegment}));
        EasyMock.expect((Object)log.logSegments()).andStubReturn((Object)logSegments);
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @Test
    public void testFetchOffsetsBeforeWithChangingSegments() {
        Log log = (Log)EasyMock.niceMock(Log.class);
        LogSegment logSegment = (LogSegment)EasyMock.niceMock(LogSegment.class);
        EasyMock.expect((Object)log.logSegments()).andStubAnswer((IAnswer)new IAnswer<Iterable<LogSegment>>(null, logSegment){
            public final LogSegment logSegment$1;

            public Iterable<LogSegment> answer() {
                return new Iterable<LogSegment>(this){
                    private final /* synthetic */ $anon$2 $outer;

                    public final Iterable<LogSegment> toIterable() {
                        return Iterable.toIterable$((Iterable)this);
                    }

                    public final Iterable<LogSegment> coll() {
                        return Iterable.coll$((Iterable)this);
                    }

                    public IterableFactory<Iterable> iterableFactory() {
                        return Iterable.iterableFactory$((Iterable)this);
                    }

                    public Iterable<LogSegment> seq() {
                        return Iterable.seq$((Iterable)this);
                    }

                    public String className() {
                        return Iterable.className$((Iterable)this);
                    }

                    public final String collectionClassName() {
                        return Iterable.collectionClassName$((Iterable)this);
                    }

                    public String stringPrefix() {
                        return Iterable.stringPrefix$((Iterable)this);
                    }

                    public String toString() {
                        return Iterable.toString$((Iterable)this);
                    }

                    public <B> LazyZip2<LogSegment, B, Iterable> lazyZip(Iterable<B> that) {
                        return Iterable.lazyZip$((Iterable)this, that);
                    }

                    public IterableOps fromSpecific(IterableOnce coll) {
                        return IterableFactoryDefaults.fromSpecific$((IterableFactoryDefaults)this, (IterableOnce)coll);
                    }

                    public Builder<LogSegment, Iterable<LogSegment>> newSpecificBuilder() {
                        return IterableFactoryDefaults.newSpecificBuilder$((IterableFactoryDefaults)this);
                    }

                    public IterableOps empty() {
                        return IterableFactoryDefaults.empty$((IterableFactoryDefaults)this);
                    }

                    public final Iterable<LogSegment> toTraversable() {
                        return IterableOps.toTraversable$((IterableOps)this);
                    }

                    public boolean isTraversableAgain() {
                        return IterableOps.isTraversableAgain$((IterableOps)this);
                    }

                    public final Object repr() {
                        return IterableOps.repr$((IterableOps)this);
                    }

                    public IterableFactory<Iterable> companion() {
                        return IterableOps.companion$((IterableOps)this);
                    }

                    public Object head() {
                        return IterableOps.head$((IterableOps)this);
                    }

                    public Option<LogSegment> headOption() {
                        return IterableOps.headOption$((IterableOps)this);
                    }

                    public Object last() {
                        return IterableOps.last$((IterableOps)this);
                    }

                    public Option<LogSegment> lastOption() {
                        return IterableOps.lastOption$((IterableOps)this);
                    }

                    public View<LogSegment> view() {
                        return IterableOps.view$((IterableOps)this);
                    }

                    public int sizeCompare(int otherSize) {
                        return IterableOps.sizeCompare$((IterableOps)this, (int)otherSize);
                    }

                    public final IterableOps sizeIs() {
                        return IterableOps.sizeIs$((IterableOps)this);
                    }

                    public int sizeCompare(Iterable<?> that) {
                        return IterableOps.sizeCompare$((IterableOps)this, that);
                    }

                    public View<LogSegment> view(int from, int until) {
                        return IterableOps.view$((IterableOps)this, (int)from, (int)until);
                    }

                    public Object transpose(Function1 asIterable) {
                        return IterableOps.transpose$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object filter(Function1 pred) {
                        return IterableOps.filter$((IterableOps)this, (Function1)pred);
                    }

                    public Object filterNot(Function1 pred) {
                        return IterableOps.filterNot$((IterableOps)this, (Function1)pred);
                    }

                    public WithFilter<LogSegment, Iterable> withFilter(Function1<LogSegment, Object> p) {
                        return IterableOps.withFilter$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> partition(Function1<LogSegment, Object> p) {
                        return IterableOps.partition$((IterableOps)this, p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> splitAt(int n) {
                        return IterableOps.splitAt$((IterableOps)this, (int)n);
                    }

                    public Object take(int n) {
                        return IterableOps.take$((IterableOps)this, (int)n);
                    }

                    public Object takeRight(int n) {
                        return IterableOps.takeRight$((IterableOps)this, (int)n);
                    }

                    public Object takeWhile(Function1 p) {
                        return IterableOps.takeWhile$((IterableOps)this, (Function1)p);
                    }

                    public Tuple2<Iterable<LogSegment>, Iterable<LogSegment>> span(Function1<LogSegment, Object> p) {
                        return IterableOps.span$((IterableOps)this, p);
                    }

                    public Object drop(int n) {
                        return IterableOps.drop$((IterableOps)this, (int)n);
                    }

                    public Object dropRight(int n) {
                        return IterableOps.dropRight$((IterableOps)this, (int)n);
                    }

                    public Object dropWhile(Function1 p) {
                        return IterableOps.dropWhile$((IterableOps)this, (Function1)p);
                    }

                    public Iterator<Iterable<LogSegment>> grouped(int size) {
                        return IterableOps.grouped$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size) {
                        return IterableOps.sliding$((IterableOps)this, (int)size);
                    }

                    public Iterator<Iterable<LogSegment>> sliding(int size, int step) {
                        return IterableOps.sliding$((IterableOps)this, (int)size, (int)step);
                    }

                    public Object tail() {
                        return IterableOps.tail$((IterableOps)this);
                    }

                    public Object init() {
                        return IterableOps.init$((IterableOps)this);
                    }

                    public Object slice(int from, int until) {
                        return IterableOps.slice$((IterableOps)this, (int)from, (int)until);
                    }

                    public <K> scala.collection.immutable.Map<K, Iterable<LogSegment>> groupBy(Function1<LogSegment, K> f) {
                        return IterableOps.groupBy$((IterableOps)this, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, Iterable<B>> groupMap(Function1<LogSegment, K> key, Function1<LogSegment, B> f) {
                        return IterableOps.groupMap$((IterableOps)this, key, f);
                    }

                    public <K, B> scala.collection.immutable.Map<K, B> groupMapReduce(Function1<LogSegment, K> key, Function1<LogSegment, B> f, Function2<B, B, B> reduce) {
                        return IterableOps.groupMapReduce$((IterableOps)this, key, f, reduce);
                    }

                    public Object scan(Object z, Function2 op) {
                        return IterableOps.scan$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanLeft(Object z, Function2 op) {
                        return IterableOps.scanLeft$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object scanRight(Object z, Function2 op) {
                        return IterableOps.scanRight$((IterableOps)this, (Object)z, (Function2)op);
                    }

                    public Object map(Function1 f) {
                        return IterableOps.map$((IterableOps)this, (Function1)f);
                    }

                    public Object flatMap(Function1 f) {
                        return IterableOps.flatMap$((IterableOps)this, (Function1)f);
                    }

                    public Object flatten(Function1 asIterable) {
                        return IterableOps.flatten$((IterableOps)this, (Function1)asIterable);
                    }

                    public Object collect(PartialFunction pf) {
                        return IterableOps.collect$((IterableOps)this, (PartialFunction)pf);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> partitionMap(Function1<LogSegment, Either<A1, A2>> f) {
                        return IterableOps.partitionMap$((IterableOps)this, f);
                    }

                    public Object concat(IterableOnce suffix) {
                        return IterableOps.concat$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public final Object $plus$plus(IterableOnce suffix) {
                        return IterableOps.$plus$plus$((IterableOps)this, (IterableOnce)suffix);
                    }

                    public Object zip(IterableOnce that) {
                        return IterableOps.zip$((IterableOps)this, (IterableOnce)that);
                    }

                    public Object zipWithIndex() {
                        return IterableOps.zipWithIndex$((IterableOps)this);
                    }

                    public Object zipAll(Iterable that, Object thisElem, Object thatElem) {
                        return IterableOps.zipAll$((IterableOps)this, (Iterable)that, (Object)thisElem, (Object)thatElem);
                    }

                    public <A1, A2> Tuple2<Iterable<A1>, Iterable<A2>> unzip(Function1<LogSegment, Tuple2<A1, A2>> asPair) {
                        return IterableOps.unzip$((IterableOps)this, asPair);
                    }

                    public <A1, A2, A3> Tuple3<Iterable<A1>, Iterable<A2>, Iterable<A3>> unzip3(Function1<LogSegment, Tuple3<A1, A2, A3>> asTriple) {
                        return IterableOps.unzip3$((IterableOps)this, asTriple);
                    }

                    public Iterator<Iterable<LogSegment>> tails() {
                        return IterableOps.tails$((IterableOps)this);
                    }

                    public Iterator<Iterable<LogSegment>> inits() {
                        return IterableOps.inits$((IterableOps)this);
                    }

                    public Object tapEach(Function1 f) {
                        return IterableOps.tapEach$((IterableOps)this, (Function1)f);
                    }

                    public Object $plus$plus$colon(IterableOnce that) {
                        return IterableOps.$plus$plus$colon$((IterableOps)this, (IterableOnce)that);
                    }

                    public boolean hasDefiniteSize() {
                        return IterableOnceOps.hasDefiniteSize$((IterableOnceOps)this);
                    }

                    public <U> void foreach(Function1<LogSegment, U> f) {
                        IterableOnceOps.foreach$((IterableOnceOps)this, f);
                    }

                    public boolean forall(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.forall$((IterableOnceOps)this, p);
                    }

                    public boolean exists(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.exists$((IterableOnceOps)this, p);
                    }

                    public int count(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.count$((IterableOnceOps)this, p);
                    }

                    public Option<LogSegment> find(Function1<LogSegment, Object> p) {
                        return IterableOnceOps.find$((IterableOnceOps)this, p);
                    }

                    public <B> B foldLeft(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
                    }

                    public <B> B foldRight(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $div$colon(B z, Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
                    }

                    public final <B> B $colon$bslash(B z, Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
                    }

                    public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                        return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
                    }

                    public <B> B reduce(Function2<B, B, B> op) {
                        return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                        return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceLeft(Function2<B, LogSegment, B> op) {
                        return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
                    }

                    public <B> B reduceRight(Function2<LogSegment, B, B> op) {
                        return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceLeftOption(Function2<B, LogSegment, B> op) {
                        return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
                    }

                    public <B> Option<B> reduceRightOption(Function2<LogSegment, B, B> op) {
                        return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
                    }

                    public boolean isEmpty() {
                        return IterableOnceOps.isEmpty$((IterableOnceOps)this);
                    }

                    public boolean nonEmpty() {
                        return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
                    }

                    public final <B> void copyToBuffer(Buffer<B> dest) {
                        IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
                    }

                    public <B> int copyToArray(Object xs) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
                    }

                    public <B> int copyToArray(Object xs, int start) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
                    }

                    public <B> int copyToArray(Object xs, int start, int len) {
                        return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
                    }

                    public <B> B sum(Numeric<B> num) {
                        return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
                    }

                    public <B> B product(Numeric<B> num) {
                        return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
                    }

                    public Object min(Ordering ord) {
                        return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> minOption(Ordering<B> ord) {
                        return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
                    }

                    public Object max(Ordering ord) {
                        return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
                    }

                    public <B> Option<LogSegment> maxOption(Ordering<B> ord) {
                        return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
                    }

                    public Object maxBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> maxByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public Object minBy(Function1 f, Ordering cmp) {
                        return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)cmp);
                    }

                    public <B> Option<LogSegment> minByOption(Function1<LogSegment, B> f, Ordering<B> cmp) {
                        return IterableOnceOps.minByOption$((IterableOnceOps)this, f, cmp);
                    }

                    public <B> Option<B> collectFirst(PartialFunction<LogSegment, B> pf) {
                        return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
                    }

                    public <B> B aggregate(Function0<B> z, Function2<B, LogSegment, B> seqop, Function2<B, B, B> combop) {
                        return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
                    }

                    public <B> boolean corresponds(IterableOnce<B> that, Function2<LogSegment, B, Object> p) {
                        return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
                    }

                    public final String mkString(String start, String sep, String end) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
                    }

                    public final String mkString(String sep) {
                        return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
                    }

                    public final String mkString() {
                        return IterableOnceOps.mkString$((IterableOnceOps)this);
                    }

                    public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
                    }

                    public final StringBuilder addString(StringBuilder b, String sep) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
                    }

                    public final StringBuilder addString(StringBuilder b) {
                        return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
                    }

                    public <C1> C1 to(Factory<LogSegment, C1> factory) {
                        return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
                    }

                    public final Iterator<LogSegment> toIterator() {
                        return IterableOnceOps.toIterator$((IterableOnceOps)this);
                    }

                    public List<LogSegment> toList() {
                        return IterableOnceOps.toList$((IterableOnceOps)this);
                    }

                    public Vector<LogSegment> toVector() {
                        return IterableOnceOps.toVector$((IterableOnceOps)this);
                    }

                    public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<LogSegment, Tuple2<K, V>> ev) {
                        return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
                    }

                    public <B> Set<B> toSet() {
                        return IterableOnceOps.toSet$((IterableOnceOps)this);
                    }

                    public scala.collection.immutable.Seq<LogSegment> toSeq() {
                        return IterableOnceOps.toSeq$((IterableOnceOps)this);
                    }

                    public IndexedSeq<LogSegment> toIndexedSeq() {
                        return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
                    }

                    public final Stream<LogSegment> toStream() {
                        return IterableOnceOps.toStream$((IterableOnceOps)this);
                    }

                    public final <B> Buffer<B> toBuffer() {
                        return IterableOnceOps.toBuffer$((IterableOnceOps)this);
                    }

                    public <B> Object toArray(ClassTag<B> evidence$2) {
                        return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
                    }

                    public Iterable<LogSegment> reversed() {
                        return IterableOnceOps.reversed$((IterableOnceOps)this);
                    }

                    public <S extends Stepper<?>> S stepper(StepperShape<LogSegment, S> shape) {
                        return (S)IterableOnce.stepper$((IterableOnce)this, shape);
                    }

                    public int knownSize() {
                        return IterableOnce.knownSize$((IterableOnce)this);
                    }

                    public int size() {
                        return 2;
                    }

                    public Iterator<LogSegment> iterator() {
                        return Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LogSegment[]{this.$outer.logSegment$1})).iterator();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                };
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logSegment});
        EasyMock.replay((Object[])new Object[]{log});
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaServer server() {
        return (KafkaServer)this.servers().head();
    }

    private ListOffsetResponse sendListOffsetsRequest(ListOffsetRequest request) {
        return (ListOffsetResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse<MemoryRecords> sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsAfterDeleteRecords$1(LogManager logManager$1, TopicPartition topicPartition$1) {
        return logManager$1.getLog(topicPartition$1, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$2() {
        return "Log for partition [topic,0] should be created";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$5() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$testGetOffsetsBeforeLatestTime$1(LogManager logManager$2, TopicPartition topicPartition$2) {
        return logManager$2.getLog(topicPartition$2, logManager$2.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$2(TopicPartition topicPartition$2) {
        return new java.lang.StringBuilder(36).append("Log for partition ").append(topicPartition$2).append(" should be created").toString();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$5() {
        return "Leader should be elected";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testEmptyLogsGetOffsets$1(LogOffsetTest $this, String topic$3, BooleanRef offsetChanged$1, int x$3) {
        void apply_elems;
        TopicPartition topicPartition = new TopicPartition(topic$3, 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ListOffsetRequest.PartitionData $minus$greater$extension_y = new ListOffsetRequest.PartitionData(-2L, 1);
        Object var6_5 = null;
        objectArray[0] = new Tuple2((Object)topicPartition, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)0, (int)0).setTargetTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava()).build();
        if (BoxesRunTime.equals((Object)((Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(((ListOffsetResponse.PartitionData)$this.sendListOffsetsRequest((ListOffsetRequest)request).responseData().get((Object)topicPartition)).offsets).asScala()).head(), (Object)1)) {
            offsetChanged$1.elem = true;
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsAfterDeleteRecords$3$adapted(Log log$1, Object x$1) {
        return log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeLatestTime$3$adapted(Log log$2, Object x$2) {
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeNow$1$adapted(Log log$3, Object x$4) {
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testGetOffsetsBeforeEarliestTime$1$adapted(Log log$4, Object x$5) {
        return log$4.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log$4.appendAsLeader$default$3(), log$4.appendAsLeader$default$4());
    }
}

