/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaType;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.Builder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001de\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dBQA\u000b\u0001\u0005\u0002-Bq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0001\r\u0011\"\u0001D\u0011\u001d\u0019\u0006\u00011A\u0005\u0002QCaA\u0017\u0001!B\u0013!\u0005bB.\u0001\u0005\u0004%\t\u0001\u0018\u0005\u0007K\u0002\u0001\u000b\u0011B/\t\u000f\u0019\u0004\u0001\u0019!C\u0001O\"9A\u000f\u0001a\u0001\n\u0003)\bBB<\u0001A\u0003&\u0001\u000eC\u0003y\u0001\u0011\u0005\u0013\u0010\u0003\u0004\u0002\u0004\u0001!\t!\u001f\u0005\u0007\u0003\u001b\u0001A\u0011A=\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u0011q\u0004\u0001\u0005\u0002\u0005\u0005\u0002BBA\u001a\u0001\u0011\u0005\u0011\u0010C\u0004\u00028\u0001!\t!!\u000f\t\u000f\u0005\r\u0003\u0001\"\u0003\u0002F!9\u00111\u000b\u0001\u0005\n\u0005U\u0003bBA.\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003K\u0002A\u0011BA4\u0011\u001d\tY\b\u0001C\u0005\u0003{\u0012QCU3qY&\u001c\u0017\r^5p]F+x\u000e^1t)\u0016\u001cHO\u0003\u0002\u001c9\u000511/\u001a:wKJT\u0011!H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0005\u0005\u0002\"I5\t!E\u0003\u0002$9\u0005\u0011!p[\u0005\u0003K\t\u0012ACW8p\u0017\u0016,\u0007/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0003!D\u0001\u001b\u00031\u0001XM]2f]R,%O]8s)\ra#g\u000e\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0005\u0019>tw\rC\u00034\u0005\u0001\u0007A'A\u0004qKJ\u001cWM\u001c;\u0011\u00055*\u0014B\u0001\u001c/\u0005\rIe\u000e\u001e\u0005\u0006q\t\u0001\r\u0001L\u0001\u0006m\u0006dW/Z\u0001\t[N<\u0017\u0007\r\u0019L\u0005V\t1\bE\u0002.yyJ!!\u0010\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u00055z\u0014B\u0001!/\u0005\u0011\u0011\u0015\u0010^3\u0002\u00135\u001cx-\r\u00191\u0017\n\u0003\u0013a\u00022s_.,'o]\u000b\u0002\tB\u0019Q)\u0014)\u000f\u0005\u0019[eBA$K\u001b\u0005A%BA%\u001f\u0003\u0019a$o\\8u}%\tq&\u0003\u0002M]\u00059\u0001/Y2lC\u001e,\u0017B\u0001(P\u0005\r\u0019V-\u001d\u0006\u0003\u0019:\u0002\"!K)\n\u0005IS\"aC&bM.\f7+\u001a:wKJ\f1B\u0019:pW\u0016\u00148o\u0018\u0013fcR\u0011Q\u000b\u0017\t\u0003[YK!a\u0016\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b3\u001a\t\t\u00111\u0001E\u0003\rAH%M\u0001\tEJ|7.\u001a:tA\u0005)Ao\u001c9jGV\tQ\f\u0005\u0002_G6\tqL\u0003\u0002aC\u0006!A.\u00198h\u0015\u0005\u0011\u0017\u0001\u00026bm\u0006L!\u0001Z0\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005A\u0001O]8ek\u000e,'/F\u0001i!\u0011I'oO\u001e\u000e\u0003)T!AZ6\u000b\u00051l\u0017aB2mS\u0016tGo\u001d\u0006\u0003;9T!a\u001c9\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0018aA8sO&\u00111O\u001b\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\u0002\u0019A\u0014x\u000eZ;dKJ|F%Z9\u0015\u0005U3\bbB-\f\u0003\u0003\u0005\r\u0001[\u0001\naJ|G-^2fe\u0002\n\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002+\"\u0012Qb\u001f\t\u0003y~l\u0011! \u0006\u0003}B\fQA[;oSRL1!!\u0001~\u0005\u0015\te\r^3s\u0003-\u001a\bn\\;mI\n{w\u000e^:ue\u0006\u0004Hk^8Ce>\\WM]:XSRDG*Z1eKJ$\u0006N]8ui2,\u0007f\u0001\b\u0002\bA\u0019A0!\u0003\n\u0007\u0005-QP\u0001\u0003UKN$\u0018!L:i_VdGMQ8piN$(/\u00199Uo>\u0014%o\\6feN<\u0016\u000e\u001e5G_2dwn^3s)\"\u0014x\u000e\u001e;mK\"\u001aq\"a\u0002\u0002mMDw.\u001e7e\u001b\u0006$8\r[)v_R\f'+\u001a9mS\u000e\fG/\u001b8h)\"\u0014x.^4i\u0003:\f5/_7nKR\u0014\u0018n\u0019+pa>dwnZ=\u0015\u0007U\u000b)\u0002C\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u001d1,\u0017\rZ3s)\"\u0014x\u000e\u001e;mKB\u0019Q&a\u0007\n\u0007\u0005uaFA\u0004C_>dW-\u00198\u0002\u0005Q\u0004H\u0003BA\u0012\u0003_\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003Si\u0017AB2p[6|g.\u0003\u0003\u0002.\u0005\u001d\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\u0007\u0003c\t\u0002\u0019\u0001\u001b\u0002\u0013A\f'\u000f^5uS>t\u0017!G:i_VdG\r\u00165s_R$H.Z(mIN+w-\\3oiND3AEA\u0004\u0003\u001d\tG\r\u001a#bi\u0006$R!VA\u001e\u0003\u007fAa!!\u0010\u0014\u0001\u0004!\u0014\u0001C7tO\u000e{WO\u001c;\t\r\u0005\u00053\u00031\u0001<\u0003\ri7oZ\u0001\u0016o\u0006LGOR8s\u001f\u001a47/\u001a;t)>l\u0015\r^2i)\u001d)\u0016qIA&\u0003\u001fBa!!\u0013\u0015\u0001\u0004!\u0014AB8gMN,G\u000f\u0003\u0004\u0002NQ\u0001\r\u0001N\u0001\fa\u0006\u0014H/\u001b;j_:LE\r\u0003\u0004\u0002RQ\u0001\r\u0001N\u0001\tEJ|7.\u001a:JI\u0006I!M]8lKJ4uN\u001d\u000b\u0004!\u0006]\u0003BBA-+\u0001\u0007A'\u0001\u0002jI\u0006i1M]3bi\u0016\u0014%o\\6feN$2!VA0\u0011\u001d\t\tG\u0006a\u0001\u0003G\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\u0007\u0015kE'\u0001\u0004bmJ\u000bG/\u001a\u000b\u0007\u0003S\ny'!\u001f\u0011\u00075\nY'C\u0002\u0002n9\u0012a\u0001R8vE2,\u0007bBA9/\u0001\u0007\u00111O\u0001\u0010e\u0016\u0004H.[2bi&|g\u000eV=qKB\u0019\u0011&!\u001e\n\u0007\u0005]$DA\u0005Rk>$\u0018\rV=qK\"1!i\u0006a\u0001\u0003G\nA\"\\3bgV\u0014X\r\u001a*bi\u0016$b!!\u001b\u0002\u0000\u0005\r\u0005BBAA1\u0001\u0007\u0001+\u0001\u0004ce>\\WM\u001d\u0005\b\u0003\u000bC\u0002\u0019AA:\u0003\u001d\u0011X\r\u001d+za\u0016\u0004")
public class ReplicationQuotasTest
extends ZooKeeperTestHarness {
    private final byte[] msg100KB = new byte[100000];
    private scala.collection.immutable.Seq<KafkaServer> brokers = null;
    private final String topic;
    private KafkaProducer<byte[], byte[]> producer = null;

    public long percentError(int percent, long value) {
        return Math.round(value * (long)percent / 100L);
    }

    public byte[] msg100KB() {
        return this.msg100KB;
    }

    public scala.collection.immutable.Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(scala.collection.immutable.Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers((Seq<KafkaServer>)this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldBootstrapTwoBrokersWithLeaderThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(true);
    }

    @Test
    public void shouldBootstrapTwoBrokersWithFollowerThrottle() {
        this.shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(false);
    }

    /*
     * WARNING - void declaration
     */
    public void shouldMatchQuotaReplicatingThroughAnAsymmetricTopology(boolean leaderThrottle) {
        double d;
        LongRef longRef;
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_y8;
        KafkaServer kafkaServer;
        int n = 100;
        int to$extension_end = 105;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            KafkaServer kafkaServer2;
            KafkaServer kafkaServer3 = kafkaServer2 = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)object), this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), Time.SYSTEM, (Option<String>)None$.MODULE$);
            kafkaServer2 = null;
            kafkaServer = kafkaServer3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            kafkaServer = null;
        }
        Object var52_4 = null;
        Object var53_5 = null;
        Object var54_6 = null;
        kafkaServer = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((IndexedSeq)map_strictOptimizedMap_b.result()));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[8];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}));
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var23_11 = null;
        seqOps = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y8);
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 106}));
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var25_13 = null;
        seqOps2 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y7);
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{102, 106}));
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var27_15 = null;
        seqOps3 = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y6);
        SeqOps seqOps4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{103, 107}));
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var29_17 = null;
        seqOps4 = null;
        objectArray[3] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y5);
        SeqOps seqOps5 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{104, 107}));
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)4);
        Object var31_19 = null;
        seqOps5 = null;
        objectArray[4] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y4);
        SeqOps seqOps6 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{105, 107}));
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)5);
        Object var33_21 = null;
        seqOps6 = null;
        objectArray[5] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y3);
        SeqOps seqOps7 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 106}));
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)6);
        Object var35_23 = null;
        seqOps7 = null;
        objectArray[6] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y2);
        SeqOps seqOps8 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{101, 107}));
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)7);
        Object var37_25 = null;
        seqOps8 = null;
        objectArray[7] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map assignment = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)assignment, (Seq<KafkaServer>)this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 100;
        int expectedDuration = 10;
        long create_e = msgCount * msg.length / expectedDuration;
        LongRef longRef2 = longRef = new LongRef(create_e);
        longRef = null;
        LongRef throttle = longRef2;
        if (!leaderThrottle) {
            throttle.elem *= 3L;
        }
        int n2 = 100;
        int to$extension_end2 = 107;
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive(n2, to$extension_end2, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$2(this, throttle, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var56_36 = null;
        if (leaderThrottle) {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100,1:101,2:102,3:103,4:104,5:105"));
        } else {
            this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), "0:106,1:106,2:106,3:107,4:107,5:107"));
        }
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), new ByteArraySerializer(), new ByteArraySerializer(), TestUtils$.MODULE$.createProducer$default$16()));
        int n3 = 0;
        Range.Exclusive foreach$mVc$sp_this2 = new Range.Exclusive(n3, msgCount, 1);
        if (!foreach$mVc$sp_this2.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this2.start();
            while (true) {
                ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$3(this, msg, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this2.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this2.step();
            }
        }
        Object var58_39 = null;
        int n4 = 0;
        int to$extension_end3 = 5;
        Range.Inclusive foreach$mVc$sp_this3 = new Range.Inclusive(n4, to$extension_end3, 1);
        if (!foreach$mVc$sp_this3.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this3.start();
            while (true) {
                this.waitForOffsetsToMatch(msgCount, foreach$mVc$sp_i, 100 + foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this3.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this3.step();
            }
        }
        Object var60_43 = null;
        this.waitForOffsetsToMatch(msgCount, 6, 100);
        this.waitForOffsetsToMatch(msgCount, 7, 101);
        long start = System.currentTimeMillis();
        int n5 = 106;
        int to$extension_end4 = 107;
        this.createBrokers((scala.collection.immutable.Seq<Object>)new Range.Inclusive(n5, to$extension_end4, 1));
        int n6 = 106;
        int to$extension_end5 = 107;
        Range.Inclusive foreach$mVc$sp_this4 = new Range.Inclusive(n6, to$extension_end5, 1);
        if (!foreach$mVc$sp_this4.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this4.start();
            while (true) {
                ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(this, throttle, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this4.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this4.step();
            }
        }
        Object var62_50 = null;
        if (!leaderThrottle) {
            int n7 = 0;
            int to$extension_end6 = 2;
            Range.Inclusive foreach$mVc$sp_this5 = new Range.Inclusive(n7, to$extension_end6, 1);
            if (!foreach$mVc$sp_this5.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this5.start();
                while (true) {
                    ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$7(this, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this5.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this5.step();
                }
            }
            Object var64_54 = null;
            int n8 = 3;
            int to$extension_end7 = 5;
            Range.Inclusive foreach$mVc$sp_this6 = new Range.Inclusive(n8, to$extension_end7, 1);
            if (!foreach$mVc$sp_this6.isEmpty()) {
                int foreach$mVc$sp_i = foreach$mVc$sp_this6.start();
                while (true) {
                    ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(this, foreach$mVc$sp_i);
                    if (foreach$mVc$sp_i == foreach$mVc$sp_this6.scala$collection$immutable$Range$$lastElement) break;
                    foreach$mVc$sp_i += foreach$mVc$sp_this6.step();
                }
            }
            Object var66_58 = null;
        }
        int n9 = 6;
        int to$extension_end8 = 7;
        Range.Inclusive foreach$mVc$sp_this7 = new Range.Inclusive(n9, to$extension_end8, 1);
        if (!foreach$mVc$sp_this7.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this7.start();
            while (true) {
                this.waitForOffsetsToMatch(msgCount, foreach$mVc$sp_i, 100 + foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this7.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this7.step();
            }
        }
        Object var68_62 = null;
        long unthrottledTook = System.currentTimeMillis() - start;
        int n10 = 0;
        int to$extension_end9 = 2;
        Range.Inclusive foreach$mVc$sp_this8 = new Range.Inclusive(n10, to$extension_end9, 1);
        if (!foreach$mVc$sp_this8.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this8.start();
            while (true) {
                this.waitForOffsetsToMatch(msgCount, foreach$mVc$sp_i, 106);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this8.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this8.step();
            }
        }
        Object var70_67 = null;
        int n11 = 3;
        int to$extension_end10 = 5;
        Range.Inclusive foreach$mVc$sp_this9 = new Range.Inclusive(n11, to$extension_end10, 1);
        if (!foreach$mVc$sp_this9.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this9.start();
            while (true) {
                this.waitForOffsetsToMatch(msgCount, foreach$mVc$sp_i, 107);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this9.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this9.step();
            }
        }
        Object var72_71 = null;
        long throttledTook = System.currentTimeMillis() - start;
        double throttledLowerBound = (double)(expectedDuration * 1000) * 0.9;
        int throttledUpperBound = expectedDuration * 1000 * 3;
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(unthrottledTook).append(" < ").append(throttledLowerBound).toString(), ((double)unthrottledTook < throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" > ").append(throttledLowerBound).toString(), ((double)throttledTook > throttledLowerBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(throttledTook).append(" < ").append(throttledUpperBound).toString(), (throttledTook < (long)throttledUpperBound ? 1 : 0) != 0);
        double rateUpperBound = (double)throttle.elem * 1.1;
        double rateLowerBound = (double)throttle.elem * 0.5;
        if (leaderThrottle) {
            int n12 = 100;
            int to$extension_end11 = 105;
            d = this.avRate((QuotaType)QuotaType.LeaderReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)new Range.Inclusive(n12, to$extension_end11, 1));
        } else {
            int n13 = 106;
            int to$extension_end12 = 107;
            d = this.avRate((QuotaType)QuotaType.FollowerReplication$.MODULE$, (scala.collection.immutable.Seq<Object>)new Range.Inclusive(n13, to$extension_end12, 1));
        }
        double rate = d;
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(rate).append(" < ").append(rateUpperBound).toString(), (rate < rateUpperBound ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(12).append("Expected ").append(rate).append(" > ").append(rateLowerBound).toString(), (rate > rateLowerBound ? 1 : 0) != 0);
    }

    public TopicPartition tp(int partition) {
        return new TopicPartition(this.topic(), partition);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldThrottleOldSegments() {
        void $colon$plus_elem;
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        void apply_elems;
        void $minus$greater$extension_y;
        Properties config = TestUtils$.MODULE$.createBrokerConfig(100, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        config.put("log.segment.bytes", ((Object)0x100000).toString());
        Object[] objectArray = new KafkaServer[1];
        objectArray[0] = TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), Time.SYSTEM, (Option<String>)None$.MODULE$);
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100, 101}));
        Integer $minus$greater$extension_$this = 0;
        Object var11_3 = null;
        seqOps = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)), (Seq<KafkaServer>)this.brokers());
        byte[] msg = this.msg100KB();
        int msgCount = 200;
        int expectedDuration = 4;
        long throttle = msg.length * msgCount / expectedDuration;
        this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{100})), CoreUtils$.MODULE$.propsWith(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ((Object)throttle).toString()));
        this.adminZkClient().changeTopicConfig(this.topic(), CoreUtils$.MODULE$.propsWith(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), "0:100"));
        this.addData(msgCount, msg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Starting new broker");
        scala.collection.immutable.Seq<KafkaServer> seq = this.brokers();
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(101, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var15_11 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer kafkaServer3 = kafkaServer2;
        if (seq == null) {
            throw null;
        }
        kafkaServer3 = null;
        this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)seq.appended((Object)$colon$plus_elem)));
        long start = System.currentTimeMillis();
        this.waitForOffsetsToMatch(msgCount, 0, 101);
        long throttledTook = System.currentTimeMillis() - start;
        Assert.assertTrue((String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be > ").append((double)(expectedDuration * 1000) * 0.9).append("ms").toString(), ((double)throttledTook > (double)(expectedDuration * 1000) * 0.9 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(42).append("Throttled replication of ").append(throttledTook).append("ms should be < ").append(expectedDuration * 1500).append("ms").toString(), ((double)throttledTook < (double)(expectedDuration * 1000) * 1.5 ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    public void addData(int msgCount, byte[] msg) {
        Future future;
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.brokers(), SecurityProtocol.PLAINTEXT), 0, 60000L, 0x100000L, Integer.MAX_VALUE, 30000, 0, 16384, "none", 20000, SecurityProtocol.PLAINTEXT, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, new ByteArraySerializer(), new ByteArraySerializer(), false));
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, msgCount, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3 = future2 = ReplicationQuotasTest.$anonfun$addData$1(this, msg, BoxesRunTime.unboxToInt((Object)object));
            future2 = null;
            future = future3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        future = null;
        ((IndexedSeq)map_strictOptimizedMap_b.result()).foreach((Function1 & Serializable)x$3 -> (RecordMetadata)x$3.get());
        this.waitForOffsetsToMatch(msgCount, 0, 100);
    }

    private void waitForOffsetsToMatch(int offset, int partitionId, int brokerId) {
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 60000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$1(this, offset, brokerId, partitionId)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(ReplicationQuotasTest.$anonfun$waitForOffsetsToMatch$4(partitionId, brokerId), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, l));
        }
    }

    private KafkaServer brokerFor(int id) {
        return (KafkaServer)((IterableOps)this.brokers().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicationQuotasTest.$anonfun$brokerFor$1(id, x$5)))).head();
    }

    public void createBrokers(scala.collection.immutable.Seq<Object> brokerIds) {
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)id -> {
            void $colon$plus_elem;
            void createServer_time;
            void createServer_config;
            KafkaServer kafkaServer;
            scala.collection.immutable.Seq<KafkaServer> seq = this.brokers();
            Time time = Time.SYSTEM;
            KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
            Object var3_4 = null;
            kafkaConfig = null;
            time = null;
            kafkaServer = null;
            KafkaServer kafkaServer3 = kafkaServer2;
            if (seq == null) {
                throw null;
            }
            kafkaServer3 = null;
            this.brokers_$eq((scala.collection.immutable.Seq<KafkaServer>)((scala.collection.immutable.Seq)seq.appended((Object)$colon$plus_elem)));
        });
    }

    private double avRate(QuotaType replicationType, scala.collection.immutable.Seq<Object> brokers) {
        return BoxesRunTime.unboxToDouble((Object)((IterableOnceOps)((IterableOps)brokers.map((Function1 & Serializable)id -> this.brokerFor(BoxesRunTime.unboxToInt((Object)id)))).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToDouble((double)this.measuredRate(x$6, replicationType)))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)brokers.length();
    }

    private double measuredRate(KafkaServer broker, QuotaType repType) {
        MetricName metricName = broker.metrics().metricName("byte-rate", repType.toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(broker.metrics().metrics()).asScala()).apply((Object)metricName)).metricValue());
    }

    public static final /* synthetic */ void $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$2(ReplicationQuotasTest $this, LongRef throttle$1, int brokerId) {
        $this.adminZkClient().changeBrokerConfig((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{brokerId})), CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)throttle$1.elem).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)throttle$1.elem).toString())})));
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4(ReplicationQuotasTest $this, byte[] msg$1, int partition) {
        Integer n;
        Integer n2 = n = Integer.valueOf(partition);
        n = null;
        return $this.producer().send(new ProducerRecord($this.topic(), n2, null, (Object)msg$1));
    }

    public static final /* synthetic */ void $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$3(ReplicationQuotasTest $this, byte[] msg$1, int x$1) {
        int n = 0;
        int to$extension_end = 7;
        Range.Inclusive foreach_this = new Range.Inclusive(n, to$extension_end, 1);
        if (!foreach_this.isEmpty()) {
            int foreach_i = foreach_this.start();
            while (true) {
                ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4($this, msg$1, foreach_i);
                if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                foreach_i += foreach_this.step();
            }
        }
    }

    public static final /* synthetic */ void $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$6(ReplicationQuotasTest $this, LongRef throttle$1, int brokerId) {
        Assert.assertEquals((long)throttle$1.elem, (long)$this.brokerFor(brokerId).quotaManagers().follower().upperBound());
    }

    public static final /* synthetic */ void $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$7(ReplicationQuotasTest $this, int partition) {
        Assert.assertTrue((boolean)$this.brokerFor(106).quotaManagers().follower().isThrottled($this.tp(partition)));
    }

    public static final /* synthetic */ void $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$8(ReplicationQuotasTest $this, int partition) {
        Assert.assertTrue((boolean)$this.brokerFor(107).quotaManagers().follower().isThrottled($this.tp(partition)));
    }

    public static final /* synthetic */ Future $anonfun$addData$1(ReplicationQuotasTest $this, byte[] msg$2, int x$2) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)msg$2));
    }

    public static final /* synthetic */ int $anonfun$waitForOffsetsToMatch$3() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$waitForOffsetsToMatch$1(ReplicationQuotasTest $this, int offset$1, int brokerId$1, int partitionId$1) {
        Object object;
        Integer n = offset$1;
        LogManager qual$1 = $this.brokerFor(brokerId$1).getLogManager();
        TopicPartition x$1 = new TopicPartition($this.topic(), partitionId$1);
        boolean x$2 = qual$1.getLog$default$2();
        Option option = qual$1.getLog(x$1, x$2);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        Object object2 = map_this.isEmpty() ? None$.MODULE$ : new Some((Object)((Log)map_this.get()).logEndOffset());
        None$ none$ = object2;
        Object var7_7 = null;
        object2 = null;
        None$ getOrElse_this = none$;
        if (getOrElse_this.isEmpty()) {
            Integer n2;
            Integer n3 = n2 = Integer.valueOf(0);
            n2 = null;
            object = n3;
        } else {
            object = getOrElse_this.get();
        }
        Object object3 = object;
        Object var9_9 = null;
        object = null;
        return BoxesRunTime.equals((Object)n, (Object)object3);
    }

    public static final /* synthetic */ String $anonfun$waitForOffsetsToMatch$4(int partitionId$1, int brokerId$1) {
        return new StringBuilder(47).append("Offsets did not match for partition ").append(partitionId$1).append(" on broker ").append(brokerId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$brokerFor$1(int id$1, KafkaServer x$5) {
        return x$5.config().brokerId() == id$1;
    }

    public ReplicationQuotasTest() {
        this.topic = "topic1";
    }

    public static final /* synthetic */ KafkaServer $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$1$adapted(ReplicationQuotasTest $this, Object id) {
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), $this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1)), Time.SYSTEM, (Option<String>)None$.MODULE$);
    }

    public static final /* synthetic */ Future $anonfun$addData$1$adapted(ReplicationQuotasTest $this, byte[] msg$2, Object x$2) {
        return ReplicationQuotasTest.$anonfun$addData$1($this, msg$2, BoxesRunTime.unboxToInt((Object)x$2));
    }

    public static final /* synthetic */ Future $anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4$adapted(ReplicationQuotasTest $this, byte[] msg$1, Object partition) {
        return ReplicationQuotasTest.$anonfun$shouldMatchQuotaReplicatingThroughAnAsymmetricTopology$4($this, msg$1, BoxesRunTime.unboxToInt((Object)partition));
    }

    public static final /* synthetic */ Object $anonfun$waitForOffsetsToMatch$2$adapted(Log x$4) {
        return BoxesRunTime.boxToLong((long)x$4.logEndOffset());
    }
}

