/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.util.List;
import kafka.consumer.BaseConsumerRecord;
import kafka.tools.MirrorMaker;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.apache.kafka.common.record.TimestampType;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005!2A!\u0002\u0004\u0001\u0017!)!\u0003\u0001C\u0001'!)a\u0003\u0001C\u0001/!)A\u0005\u0001C\u0001/!)a\u0005\u0001C\u0001/\tyQ*\u001b:s_Jl\u0015m[3s)\u0016\u001cHO\u0003\u0002\b\u0011\u0005)Ao\\8mg*\t\u0011\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002)A\u0011Q\u0003A\u0007\u0002\r\u0005!C/Z:u\t\u00164\u0017-\u001e7u\u001b&\u0014(o\u001c:NC.,'/T3tg\u0006<W\rS1oI2,'\u000fF\u0001\u0019!\ti\u0011$\u0003\u0002\u001b\u001d\t!QK\\5uQ\t\u0011A\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005)!.\u001e8ji*\t\u0011%A\u0002pe\u001eL!a\t\u0010\u0003\tQ+7\u000f^\u0001Ci\u0016\u001cH\u000fR3gCVdG/T5se>\u0014X*Y6fe6+7o]1hK\"\u000bg\u000e\u001a7fe^KG\u000f\u001b(p)&lWm\u001d;b[BLenU8ve\u000e,W*Z:tC\u001e,\u0007FA\u0002\u001d\u0003=\"Xm\u001d;EK\u001a\fW\u000f\u001c;NSJ\u0014xN]'bW\u0016\u0014X*Z:tC\u001e,\u0007*\u00198eY\u0016\u0014x+\u001b;i\u0011\u0016\fG-\u001a:tQ\t!A\u0004")
public class MirrorMakerTest {
    @Test
    public void testDefaultMirrorMakerMessageHandler() {
        long now = 12345L;
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, now, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), (Headers)new RecordHeaders());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assert.assertEquals((long)1L, (long)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assert.assertEquals((Object)now, (Object)producerRecord.timestamp());
        Assert.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assert.assertNull((Object)producerRecord.partition());
        Assert.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assert.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
    }

    @Test
    public void testDefaultMirrorMakerMessageHandlerWithNoTimestampInSourceMessage() {
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, -1L, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), (Headers)new RecordHeaders());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assert.assertEquals((long)1L, (long)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assert.assertNull((Object)producerRecord.timestamp());
        Assert.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assert.assertNull((Object)producerRecord.partition());
        Assert.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assert.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
    }

    @Test
    public void testDefaultMirrorMakerMessageHandlerWithHeaders() {
        long now = 12345L;
        BaseConsumerRecord consumerRecord = new BaseConsumerRecord("topic", 0, 1L, now, TimestampType.CREATE_TIME, "key".getBytes(), "value".getBytes(), (Headers)new RecordHeaders());
        consumerRecord.headers().add("headerKey", "headerValue".getBytes());
        List result = MirrorMaker.defaultMirrorMakerMessageHandler$.MODULE$.handle(consumerRecord);
        Assert.assertEquals((long)1L, (long)result.size());
        ProducerRecord producerRecord = (ProducerRecord)result.get(0);
        Assert.assertEquals((Object)now, (Object)producerRecord.timestamp());
        Assert.assertEquals((Object)"topic", (Object)producerRecord.topic());
        Assert.assertNull((Object)producerRecord.partition());
        Assert.assertEquals((Object)"key", (Object)new String((byte[])producerRecord.key()));
        Assert.assertEquals((Object)"value", (Object)new String((byte[])producerRecord.value()));
        Assert.assertEquals((Object)"headerValue", (Object)new String(producerRecord.headers().lastHeader("headerKey").value()));
        Assert.assertEquals((long)1L, (long)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)producerRecord.headers()).asScala()).size());
    }
}

