/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.LogDirFailureChannel;
import kafka.utils.KafkaScheduler;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00154Aa\u0005\u000b\u00013!)\u0001\u0005\u0001C\u0001C!9A\u0005\u0001b\u0001\n\u0003)\u0003BB\u0015\u0001A\u0003%a\u0005C\u0004+\u0001\t\u0007I\u0011A\u0016\t\r=\u0002\u0001\u0015!\u0003-\u0011\u001d\u0001\u0004A1A\u0005\u0002EBaA\u0010\u0001!\u0002\u0013\u0011\u0004bB \u0001\u0005\u0004%\t!\r\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u001a\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b=\u0003A\u0011\u0001\"\t\u000bQ\u0003A\u0011\u0001\"\t\u000be\u0003A\u0011\u0001\"\t\u000bm\u0003A\u0011\u0001\"\t\u000bu\u0003A\u0011\u0001\"\t\u000b}\u0003A\u0011\u0001\"\t\u000b\u0005\u0004A\u0011\u0001\"\t\u000b\r\u0004A\u0011\u0001\"\u0003\u001bM\u001b\u0007.\u001a3vY\u0016\u0014H+Z:u\u0015\t)b#A\u0003vi&d7OC\u0001\u0018\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0005\u0005\u0002$\u00015\tA#A\u0005tG\",G-\u001e7feV\ta\u0005\u0005\u0002$O%\u0011\u0001\u0006\u0006\u0002\u000f\u0017\u000647.Y*dQ\u0016$W\u000f\\3s\u0003)\u00198\r[3ek2,'\u000fI\u0001\t[>\u001c7\u000eV5nKV\tA\u0006\u0005\u0002$[%\u0011a\u0006\u0006\u0002\t\u001b>\u001c7\u000eV5nK\u0006IQn\\2l)&lW\rI\u0001\tG>,h\u000e^3scU\t!\u0007\u0005\u00024y5\tAG\u0003\u00026m\u00051\u0011\r^8nS\u000eT!a\u000e\u001d\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002:u\u0005!Q\u000f^5m\u0015\u0005Y\u0014\u0001\u00026bm\u0006L!!\u0010\u001b\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003%\u0019w.\u001e8uKJ\f\u0004%\u0001\u0005d_VtG/\u001a:3\u0003%\u0019w.\u001e8uKJ\u0014\u0004%A\u0003tKR,\b\u000fF\u0001D!\tYB)\u0003\u0002F9\t!QK\\5uQ\tQq\t\u0005\u0002I\u001b6\t\u0011J\u0003\u0002K\u0017\u0006)!.\u001e8ji*\tA*A\u0002pe\u001eL!AT%\u0003\r\t+gm\u001c:f\u0003!!X-\u0019:e_^t\u0007FA\u0006R!\tA%+\u0003\u0002T\u0013\n)\u0011I\u001a;fe\u0006\u0001C/Z:u\u001b>\u001c7nU2iK\u0012,H.\u001a:O_:\u0004VM]5pI&\u001cG+Y:lQ\taa\u000b\u0005\u0002I/&\u0011\u0001,\u0013\u0002\u0005)\u0016\u001cH/A\u000fuKN$Xj\\2l'\u000eDW\rZ;mKJ\u0004VM]5pI&\u001cG+Y:lQ\tia+\u0001\u0011uKN$(+Z3oiJ\fg\u000e\u001e+bg.Le.T8dWN\u001b\u0007.\u001a3vY\u0016\u0014\bF\u0001\bW\u0003M!Xm\u001d;O_:\u0004VM]5pI&\u001cG+Y:lQ\tya+\u0001\tuKN$\b+\u001a:j_\u0012L7\rV1tW\"\u0012\u0001CV\u0001\fi\u0016\u001cHOU3ti\u0006\u0014H\u000f\u000b\u0002\u0012-\u0006QB/Z:u+:\u001c8\r[3ek2,\u0007K]8ek\u000e,'\u000fV1tW\"\u0012!C\u0016")
public class SchedulerTest {
    private final KafkaScheduler scheduler = new KafkaScheduler(1, "kafka-scheduler-", true);
    private final MockTime mockTime = new MockTime();
    private final AtomicInteger counter1 = new AtomicInteger(0);
    private final AtomicInteger counter2 = new AtomicInteger(0);

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public AtomicInteger counter1() {
        return this.counter1;
    }

    public AtomicInteger counter2() {
        return this.counter2;
    }

    @Before
    public void setup() {
        this.scheduler().startup();
    }

    @After
    public void teardown() {
        this.scheduler().shutdown();
    }

    @Test
    public void testMockSchedulerNonPeriodicTask() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter2().getAndIncrement(), 100L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        Assert.assertEquals((String)"Counter1 should not be incremented prior to task running.", (long)0L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented prior to task running.", (long)0L, (long)this.counter2().get());
        this.mockTime().sleep(1L);
        Assert.assertEquals((String)"Counter1 should be incremented", (long)1L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented", (long)0L, (long)this.counter2().get());
        this.mockTime().sleep(100000L);
        Assert.assertEquals((String)"More sleeping should not result in more incrementing on counter1.", (long)1L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should now be incremented.", (long)1L, (long)this.counter2().get());
    }

    @Test
    public void testMockSchedulerPeriodicTask() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 1L, 1L, this.mockTime().scheduler().schedule$default$5());
        this.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter2().getAndIncrement(), 100L, 100L, this.mockTime().scheduler().schedule$default$5());
        Assert.assertEquals((String)"Counter1 should not be incremented prior to task running.", (long)0L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented prior to task running.", (long)0L, (long)this.counter2().get());
        this.mockTime().sleep(1L);
        Assert.assertEquals((String)"Counter1 should be incremented", (long)1L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented", (long)0L, (long)this.counter2().get());
        this.mockTime().sleep(100L);
        Assert.assertEquals((String)"Counter1 should be incremented 101 times", (long)101L, (long)this.counter1().get());
        Assert.assertEquals((String)"Counter2 should not be incremented once", (long)1L, (long)this.counter2().get());
    }

    @Test
    public void testReentrantTaskInMockScheduler() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.mockTime().scheduler().schedule("test2", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter2().getAndIncrement(), 0L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5()), 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().sleep(1L);
        Assert.assertEquals((long)1L, (long)this.counter2().get());
    }

    @Test
    public void testNonPeriodicTask() {
        this.scheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 0L, this.scheduler().schedule$default$4(), this.scheduler().schedule$default$5());
        long retry_maxWaitMs = 30000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                SchedulerTest.$anonfun$testNonPeriodicTask$2(this);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += Math.min(l, 1000L);
                continue;
            }
            break;
        }
        Object var1_2 = null;
        Object var6_6 = null;
        Thread.sleep(5L);
        Assert.assertEquals((String)"Should only run once", (long)1L, (long)this.counter1().get());
    }

    @Test
    public void testPeriodicTask() {
        this.scheduler().schedule("test", (Function0)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 0L, 5L, this.scheduler().schedule$default$5());
        long retry_maxWaitMs = 30000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                SchedulerTest.$anonfun$testPeriodicTask$2(this);
            }
            catch (AssertionError retry_e) {
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var7_6 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l);
                l += Math.min(l, 1000L);
                continue;
            }
            break;
        }
    }

    @Test
    public void testRestart() {
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().sleep(1L);
        Assert.assertEquals((long)1L, (long)this.counter1().get());
        this.mockTime().scheduler().shutdown();
        this.mockTime().scheduler().startup();
        this.mockTime().scheduler().schedule("test1", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.counter1().getAndIncrement(), 1L, this.mockTime().scheduler().schedule$default$4(), this.mockTime().scheduler().schedule$default$5());
        this.mockTime().sleep(1L);
        Assert.assertEquals((long)2L, (long)this.counter1().get());
    }

    @Test
    public void testUnscheduleProducerTask() {
        File file;
        File file2;
        File file3;
        File file4 = file3 = TestUtils.tempDirectory(null, null);
        file3 = null;
        File file5 = file2 = file4;
        file2 = null;
        File file6 = file = file5;
        file = null;
        File tmpDir = file6;
        File logDir = TestUtils$.MODULE$.randomPartitionLogDir(tmpDir);
        LogConfig logConfig = new LogConfig((Map)new Properties(), LogConfig$.MODULE$.apply$default$2());
        BrokerTopicStats brokerTopicStats = new BrokerTopicStats();
        long recoveryPoint = 0L;
        int maxProducerIdExpirationMs = 3600000;
        TopicPartition topicPartition = Log$.MODULE$.parseTopicPartitionName(logDir);
        ProducerStateManager producerStateManager = new ProducerStateManager(topicPartition, logDir, maxProducerIdExpirationMs);
        Log log = new Log(logDir, logConfig, 0L, recoveryPoint, (Scheduler)this.scheduler(), brokerTopicStats, (Time)this.mockTime(), maxProducerIdExpirationMs, LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs(), topicPartition, producerStateManager, new LogDirFailureChannel(10));
        Assert.assertTrue((boolean)this.scheduler().taskRunning(log.producerExpireCheck()));
        log.close();
        Assert.assertTrue((!this.scheduler().taskRunning(log.producerExpireCheck()) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testNonPeriodicTask$2(SchedulerTest $this) {
        Assert.assertEquals((long)$this.counter1().get(), (long)1L);
    }

    public static final /* synthetic */ void $anonfun$testPeriodicTask$2(SchedulerTest $this) {
        Assert.assertTrue((String)"Should count to 20", ($this.counter1().get() >= 20 ? 1 : 0) != 0);
    }
}

