/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.common.TopicAlreadyMarkedForDeletionException;
import kafka.controller.ReplicaAssignment;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.CreatePartitionsMetadata;
import kafka.server.DelayedCreatePartitions;
import kafka.server.DelayedDeleteTopics;
import kafka.server.DelayedOperation;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.DeleteTopicMetadata;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer$;
import kafka.server.MetadataCache;
import kafka.server.TopicKey;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.config.LogLevelConfig;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.ReassignmentInProgressException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.DescribeConfigsResponse;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.apache.kafka.server.policy.CreateTopicPolicy;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Builder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r=e\u0001\u0002\u0017.\u0001IB\u0001\"\u0012\u0001\u0003\u0006\u0004%\tA\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u000f\"A!\t\u0001BC\u0002\u0013\u0005A\n\u0003\u0005Z\u0001\t\u0005\t\u0015!\u0003N\u0011!Q\u0006A!b\u0001\n\u0003Y\u0006\u0002C0\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!Q1A\u0005\u0002\u0005D\u0001\u0002\u001b\u0001\u0003\u0002\u0003\u0006IA\u0019\u0005\u0006S\u0002!\tA\u001b\u0005\ba\u0002\u0011\r\u0011\"\u0003r\u0011\u0019A\b\u0001)A\u0005e\"9\u0011\u0010\u0001b\u0001\n\u0013Q\bB\u0002@\u0001A\u0003%1\u0010\u0003\u0005\u0000\u0001\t\u0007I\u0011BA\u0001\u0011!\t9\u0002\u0001Q\u0001\n\u0005\r\u0001\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\t)\u0003\u0001Q\u0001\n\u0005u\u0001bBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\n\u0003c\u0001!\u0019!C\u0005\u0003gA\u0001\"a\u000f\u0001A\u0003%\u0011Q\u0007\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\b\u0003\u0013\u0002A\u0011AA&\u0011\u001d\ti\u0007\u0001C\u0001\u0003_Bq!a7\u0001\t\u0003\ti\u000eC\u0004\u0002~\u0002!\t!a@\t\u000f\tE\u0002\u0001\"\u0001\u00034!9!1\f\u0001\u0005\u0002\tu\u0003b\u0002B;\u0001\u0011%!q\u000f\u0005\b\u0005?\u0003A\u0011\u0002BQ\u0011\u001d\u0011Y\u000b\u0001C\u0005\u0005[CqA!6\u0001\t\u0013\u00119\u000eC\u0004\u0003^\u0002!IAa8\t\u000f\t\u0015\b\u0001\"\u0001\u0003h\"9!q\u001e\u0001\u0005\n\tE\bb\u0002B{\u0001\u0011%!q\u001f\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019I\u0002\u0001C\u0005\u00077Aqa!\t\u0001\t\u0013\u0019\u0019\u0003C\u0004\u0004,\u0001!Ia!\f\t\u000f\ru\u0002\u0001\"\u0003\u0004@!91\u0011\u000b\u0001\u0005\n\rM\u0003bBB@\u0001\u0011%1\u0011\u0011\u0002\r\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0006\u0003]=\naa]3sm\u0016\u0014(\"\u0001\u0019\u0002\u000b-\fgm[1\u0004\u0001M!\u0001aM\u001d@!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u0019\te.\u001f*fMB\u0011!(P\u0007\u0002w)\u0011AhL\u0001\u0006kRLGn]\u0005\u0003}m\u0012q\u0001T8hO&tw\r\u0005\u0002A\u00076\t\u0011I\u0003\u0002C_\u00059Q.\u001a;sS\u000e\u001c\u0018B\u0001#B\u0005EY\u0015MZ6b\u001b\u0016$(/[2t\u000fJ|W\u000f]\u0001\u0007G>tg-[4\u0016\u0003\u001d\u0003\"\u0001S%\u000e\u00035J!AS\u0017\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!+\u0005i\u0005C\u0001(X\u001b\u0005y%B\u0001\"Q\u0015\t\t&+\u0001\u0004d_6lwN\u001c\u0006\u0003aMS!\u0001V+\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0016aA8sO&\u0011\u0001l\u0014\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW-F\u0001]!\tAU,\u0003\u0002_[\tiQ*\u001a;bI\u0006$\u0018mQ1dQ\u0016\fa\"\\3uC\u0012\fG/Y\"bG\",\u0007%\u0001\u0005{W\u000ec\u0017.\u001a8u+\u0005\u0011\u0007CA2g\u001b\u0005!'BA30\u0003\tQ8.\u0003\u0002hI\ni1*\u00194lCj[7\t\\5f]R\f\u0011B_6DY&,g\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\u0015YG.\u001c8p!\tA\u0005\u0001C\u0003F\u0013\u0001\u0007q\tC\u0003C\u0013\u0001\u0007Q\nC\u0003[\u0013\u0001\u0007A\fC\u0003a\u0013\u0001\u0007!-\u0001\bu_BL7\rU;sO\u0006$xN]=\u0016\u0003I\u00042\u0001S:v\u0013\t!XFA\rEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]B+(oZ1u_JL\bC\u0001%w\u0013\t9XF\u0001\tEK2\f\u00170\u001a3Pa\u0016\u0014\u0018\r^5p]\u0006yAo\u001c9jGB+(oZ1u_JL\b%A\u0007bI6LgNW6DY&,g\u000e^\u000b\u0002wB\u00111\r`\u0005\u0003{\u0012\u0014Q\"\u00113nS:T6n\u00117jK:$\u0018AD1e[&t'l[\"mS\u0016tG\u000fI\u0001\u0012GJ,\u0017\r^3U_BL7\rU8mS\u000eLXCAA\u0002!\u0015!\u0014QAA\u0005\u0013\r\t9!\u000e\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u00111C\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u00051\u0001o\u001c7jGfT!A\f*\n\t\u0005U\u0011Q\u0002\u0002\u0012\u0007J,\u0017\r^3U_BL7\rU8mS\u000eL\u0018AE2sK\u0006$X\rV8qS\u000e\u0004v\u000e\\5ds\u0002\n\u0011#\u00197uKJ\u001cuN\u001c4jOB{G.[2z+\t\ti\u0002E\u00035\u0003\u000b\ty\u0002\u0005\u0003\u0002\f\u0005\u0005\u0012\u0002BA\u0012\u0003\u001b\u0011\u0011#\u00117uKJ\u001cuN\u001c4jOB{G.[2z\u0003I\tG\u000e^3s\u0007>tg-[4Q_2L7-\u001f\u0011\u00023!\f7\u000fR3mCf,G\rV8qS\u000e|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003W\u00012\u0001NA\u0017\u0013\r\ty#\u000e\u0002\b\u0005>|G.Z1o\u0003Q!WMZ1vYRtU/\u001c)beRLG/[8ogV\u0011\u0011Q\u0007\t\u0004i\u0005]\u0012bAA\u001dk\t\u0019\u0011J\u001c;\u0002+\u0011,g-Y;mi:+X\u000eU1si&$\u0018n\u001c8tA\u0005AB-\u001a4bk2$(+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:\u0016\u0005\u0005\u0005\u0003c\u0001\u001b\u0002D%\u0019\u0011QI\u001b\u0003\u000bMCwN\u001d;\u00023\u0011,g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fI\u0001\"iJL8i\\7qY\u0016$X\rR3mCf,G\rV8qS\u000e|\u0005/\u001a:bi&|gn\u001d\u000b\u0005\u0003\u001b\n\u0019\u0006E\u00025\u0003\u001fJ1!!\u00156\u0005\u0011)f.\u001b;\t\u000f\u0005Us\u00031\u0001\u0002X\u0005)Ao\u001c9jGB!\u0011\u0011LA4\u001d\u0011\tY&a\u0019\u0011\u0007\u0005uS'\u0004\u0002\u0002`)\u0019\u0011\u0011M\u0019\u0002\rq\u0012xn\u001c;?\u0013\r\t)'N\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00141\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015T'\u0001\u0007de\u0016\fG/\u001a+pa&\u001c7\u000f\u0006\u0007\u0002N\u0005E\u0014QOA=\u0003_\u000b\u0019\rC\u0004\u0002ta\u0001\r!!\u000e\u0002\u000fQLW.Z8vi\"9\u0011q\u000f\rA\u0002\u0005-\u0012\u0001\u0004<bY&$\u0017\r^3P]2L\bbBA>1\u0001\u0007\u0011QP\u0001\ti>\u001c%/Z1uKBA\u0011qPAC\u0003/\nI)\u0004\u0002\u0002\u0002*\u0019\u00111Q\u001b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\b\u0006\u0005%aA'baB!\u00111RAU\u001d\u0011\ti)a)\u000f\t\u0005=\u0015q\u0014\b\u0005\u0003#\u000biJ\u0004\u0003\u0002\u0014\u0006me\u0002BAK\u00033sA!!\u0018\u0002\u0018&\ta+\u0003\u0002U+&\u0011\u0001gU\u0005\u0003#JK1!!)Q\u0003\u001diWm]:bO\u0016LA!!*\u0002(\u000692I]3bi\u0016$v\u000e]5dgJ+\u0017/^3ti\u0012\u000bG/\u0019\u0006\u0004\u0003C\u0003\u0016\u0002BAV\u0003[\u0013ab\u0011:fCR\f'\r\\3U_BL7M\u0003\u0003\u0002&\u0006\u001d\u0006bBAY1\u0001\u0007\u00111W\u0001\u001cS:\u001cG.\u001e3f\u0007>tg-[4t\u0003:$W*\u001a;bi\u0006$\u0017\r^1\u0011\u0011\u0005}\u0014QQA,\u0003k\u0003B!a.\u0002>:!\u0011QRA]\u0013\u0011\tY,a*\u00021\r\u0013X-\u0019;f)>\u0004\u0018nY:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002@\u0006\u0005'\u0001F\"sK\u0006$\u0018M\u00197f)>\u0004\u0018n\u0019*fgVdGO\u0003\u0003\u0002<\u0006\u001d\u0006bBAc1\u0001\u0007\u0011qY\u0001\u0011e\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\u0004r\u0001NAe\u0003\u001b\fi%C\u0002\u0002LV\u0012\u0011BR;oGRLwN\\\u0019\u0011\u0011\u0005}\u0014QQA,\u0003\u001f\u0004B!!5\u0002X6\u0011\u00111\u001b\u0006\u0004\u0003+\u0004\u0016\u0001\u0003:fcV,7\u000f^:\n\t\u0005e\u00171\u001b\u0002\t\u0003BLWI\u001d:pe\u0006aA-\u001a7fi\u0016$v\u000e]5dgRA\u0011QJAp\u0003C\fY\u000fC\u0004\u0002te\u0001\r!!\u000e\t\u000f\u0005\r\u0018\u00041\u0001\u0002f\u00061Ao\u001c9jGN\u0004b!a \u0002h\u0006]\u0013\u0002BAu\u0003\u0003\u00131aU3u\u0011\u001d\t)-\u0007a\u0001\u0003[\u0004r\u0001NAe\u0003_\fi\u0005\u0005\u0005\u0002\u0000\u0005\u0015\u0015qKAy!\u0011\t\u00190!?\u000e\u0005\u0005U(bAA|!\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u0002|\u0006U(AB#se>\u00148/\u0001\tde\u0016\fG/\u001a)beRLG/[8ogRa\u0011Q\nB\u0001\u0005\u0007\u0011YB!\b\u0003.!9\u00111\u000f\u000eA\u0002\u0005U\u0002b\u0002B\u00035\u0001\u0007!qA\u0001\u000e]\u0016<\b+\u0019:uSRLwN\\:\u0011\r\u0005}$\u0011\u0002B\u0007\u0013\u0011\u0011Y!!!\u0003\u0007M+\u0017\u000f\u0005\u0003\u0003\u0010\tUa\u0002BAG\u0005#IAAa\u0005\u0002(\u0006Y2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fcV,7\u000f\u001e#bi\u0006LAAa\u0006\u0003\u001a\t)2I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d+pa&\u001c'\u0002\u0002B\n\u0003OCq!a\u001e\u001b\u0001\u0004\tY\u0003C\u0004\u0003 i\u0001\rA!\t\u0002\u00191L7\u000f^3oKJt\u0015-\\3\u0011\t\t\r\"\u0011F\u0007\u0003\u0005KQ1Aa\nQ\u0003\u001dqW\r^<pe.LAAa\u000b\u0003&\taA*[:uK:,'OT1nK\"9!q\u0006\u000eA\u0002\u0005\u001d\u0017\u0001C2bY2\u0014\u0017mY6\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$bA!\u000e\u0003P\t]\u0003\u0003CA@\u0003\u000b\u00139D!\u0011\u0011\t\te\"QH\u0007\u0003\u0005wQ!!\u0012)\n\t\t}\"1\b\u0002\u000f\u0007>tg-[4SKN|WO]2f!\u0011\u0011\u0019E!\u0013\u000f\t\u0005E'QI\u0005\u0005\u0005\u000f\n\u0019.A\fEKN\u001c'/\u001b2f\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK&!!1\nB'\u0005\u0019\u0019uN\u001c4jO*!!qIAj\u0011\u001d\u0011\tf\u0007a\u0001\u0005'\nQC]3t_V\u00148-\u001a+p\u0007>tg-[4OC6,7\u000f\u0005\u0005\u0002\u0000\u0005\u0015%q\u0007B+!\u0015!\u0014QAAs\u0011\u001d\u0011If\u0007a\u0001\u0003W\tq\"\u001b8dYV$WmU=o_:LXn]\u0001\rC2$XM]\"p]\u001aLwm\u001d\u000b\u0007\u0005?\u0012\tGa\u001d\u0011\u0011\u0005}\u0014Q\u0011B\u001c\u0003\u001fDqAa\u0019\u001d\u0001\u0004\u0011)'A\u0004d_:4\u0017nZ:\u0011\u0011\u0005}\u0014Q\u0011B\u001c\u0005O\u0002BA!\u001b\u0003p9!\u0011\u0011\u001bB6\u0013\u0011\u0011i'a5\u0002'\u0005cG/\u001a:D_:4\u0017nZ:SKF,Xm\u001d;\n\t\t-#\u0011\u000f\u0006\u0005\u0005[\n\u0019\u000eC\u0004\u0002xq\u0001\r!a\u000b\u0002#\u0005dG/\u001a:U_BL7mQ8oM&<7\u000f\u0006\u0006\u0003z\t}$1\u0011BC\u00053\u0003r\u0001\u000eB>\u0005o\ty-C\u0002\u0003~U\u0012a\u0001V;qY\u0016\u0014\u0004b\u0002BA;\u0001\u0007!qG\u0001\te\u0016\u001cx.\u001e:dK\"9\u0011qO\u000fA\u0002\u0005-\u0002b\u0002BD;\u0001\u0007!\u0011R\u0001\fG>tg-[4Qe>\u00048\u000f\u0005\u0003\u0003\f\nUUB\u0001BG\u0015\u0011\u0011yI!%\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005'\u000bAA[1wC&!!q\u0013BG\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u00057k\u0002\u0019\u0001BO\u0003A\u0019wN\u001c4jO\u0016sGO]5fg6\u000b\u0007\u000f\u0005\u0005\u0002\u0000\u0005\u0015\u0015qKA,\u0003I\tG\u000e^3s\u0005J|7.\u001a:D_:4\u0017nZ:\u0015\u0015\te$1\u0015BS\u0005O\u0013I\u000bC\u0004\u0003\u0002z\u0001\rAa\u000e\t\u000f\u0005]d\u00041\u0001\u0002,!9!q\u0011\u0010A\u0002\t%\u0005b\u0002BN=\u0001\u0007!QT\u0001\u0015C2$XM\u001d'pO2+g/\u001a7D_:4\u0017nZ:\u0015\t\u00055#q\u0016\u0005\b\u0005c{\u0002\u0019\u0001BZ\u00039\tG\u000e^3s\u0007>tg-[4PaN\u0004bA!.\u0003@\n\u0015g\u0002\u0002B\\\u0005wsA!!\u0018\u0003:&\ta'C\u0002\u0003>V\nq\u0001]1dW\u0006<W-\u0003\u0003\u0003B\n\r'\u0001\u0002'jgRT1A!06!\u0011\u00119M!5\u000e\u0005\t%'\u0002\u0002Bf\u0005\u001b\fQ!\u00193nS:T1Aa4S\u0003\u001d\u0019G.[3oiNLAAa5\u0003J\ni\u0011\t\u001c;fe\u000e{gNZ5h\u001fB\f1bZ3u\u0005J|7.\u001a:JIR!!\u0011\u001cBn!\u0015!\u0014QAA\u001b\u0011\u001d\u0011\t\t\ta\u0001\u0005o\tAC^1mS\u0012\fG/Z\"p]\u001aLw\rU8mS\u000eLHCBA'\u0005C\u0014\u0019\u000fC\u0004\u0003\u0002\u0006\u0002\rAa\u000e\t\u000f\tm\u0015\u00051\u0001\u0003\u001e\u00069\u0012N\\2sK6,g\u000e^1m\u00032$XM]\"p]\u001aLwm\u001d\u000b\u0007\u0005?\u0012IO!<\t\u000f\t\r$\u00051\u0001\u0003lBA\u0011qPAC\u0005o\u0011\u0019\fC\u0004\u0002x\t\u0002\r!a\u000b\u0002/Y\fG.\u001b3bi\u0016dun\u001a'fm\u0016d7i\u001c8gS\u001e\u001cH\u0003BA'\u0005gDqA!-$\u0001\u0004\u0011\u0019,A\rqe\u0016\u0004\u0018M]3J]\u000e\u0014X-\\3oi\u0006d7i\u001c8gS\u001e\u001cH\u0003CA'\u0005s\u0014YP!@\t\u000f\tEF\u00051\u0001\u00034\"9!q\u0011\u0013A\u0002\t%\u0005b\u0002B\u0000I\u0001\u00071\u0011A\u0001\u000bG>tg-[4LKf\u001c\b\u0003CA@\u0003\u000b\u000b9fa\u0001\u0011\t\r\u00151q\u0002\b\u0005\u0007\u000f\u0019YA\u0004\u0003\u0002\u0010\u000e%\u0011BA#Q\u0013\u0011\u0019iAa\u000f\u0002\u0013\r{gNZ5h\t\u00164\u0017\u0002BB\t\u0007'\u0011\u0011bQ8oM&<7*Z=\u000b\t\r5!1H\u0001\tg\",H\u000fZ8x]R\u0011\u0011QJ\u0001\u0017e\u0016\u001cx.\u001e:dK:\u000bW.\u001a+p\u0005J|7.\u001a:JIR!\u0011QGB\u000f\u0011\u001d\u0019yB\na\u0001\u0003/\nAB]3t_V\u00148-\u001a(b[\u0016\faB\u0019:pW\u0016\u00148+\u001f8p]fl7\u000f\u0006\u0003\u0004&\r\u001d\u0002C\u0002B[\u0005\u007f\u000b9\u0006C\u0004\u0004*\u001d\u0002\r!a\u0016\u0002\t9\fW.Z\u0001\u000bG>tg-[4UsB,GCBB\u0018\u0007o\u0019I\u0004\u0005\u0003\u00042\rMb\u0002\u0002B\u001d\u0007\u0017IAa!\u000e\u0004\u0014\t!A+\u001f9f\u0011\u001d\u0019I\u0003\u000ba\u0001\u0003/Bqaa\u000f)\u0001\u0004\u0019)#\u0001\u0005ts:|g._7t\u00039\u0019wN\u001c4jONKhn\u001c8z[N$\u0002b!\u0011\u0004J\r-3Q\n\t\u0007\u0005k\u0013yla\u0011\u0011\t\t\r3QI\u0005\u0005\u0007\u000f\u0012iEA\u0007D_:4\u0017nZ*z]>t\u00170\u001c\u0005\b\u0007SI\u0003\u0019AA,\u0011\u001d\u0019Y$\u000ba\u0001\u0007KAqaa\u0014*\u0001\u0004\tY#A\u0006jgN+gn]5uSZ,\u0017AF2sK\u0006$X\rV8qS\u000e\u001cuN\u001c4jO\u0016sGO]=\u0015\u0011\rU3\u0011NB=\u0007{\"baa\u0016\u0004^\r}\u0003\u0003\u0002B\"\u00073JAaa\u0017\u0003N\tY1i\u001c8gS\u001e,e\u000e\u001e:z\u0011\u001d\u0019IC\u000ba\u0001\u0003/Bqa!\u0019+\u0001\u0004\u0019\u0019'A\u0003wC2,X\rE\u00025\u0007KJ1aa\u001a6\u0005\r\te.\u001f\u0005\b\u0007WR\u0003\u0019AB7\u0003%awnZ\"p]\u001aLw\r\u0005\u0003\u0004p\rUTBAB9\u0015\r\u0019\u0019hL\u0001\u0004Y><\u0017\u0002BB<\u0007c\u0012\u0011\u0002T8h\u0007>tg-[4\t\u000f\rm$\u00061\u0001\u0003\n\u0006QAo\u001c9jGB\u0013x\u000e]:\t\u000f\te#\u00061\u0001\u0002,\u000592M]3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u000b:$(/\u001f\u000b\u0007\u0007\u0007\u001bIi!$\u0015\r\r]3QQBD\u0011\u001d\u0019Ic\u000ba\u0001\u0003/Bqa!\u0019,\u0001\u0004\u0019\u0019\u0007C\u0004\u0004\f.\u0002\r!a\u000b\u0002\u001fA,'O\u0011:pW\u0016\u00148i\u001c8gS\u001eDqA!\u0017,\u0001\u0004\tY\u0003")
public class AdminManager
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final MetadataCache metadataCache;
    private final KafkaZkClient zkClient;
    private final DelayedOperationPurgatory<DelayedOperation> topicPurgatory;
    private final AdminZkClient adminZkClient;
    private final Option<CreateTopicPolicy> createTopicPolicy;
    private final Option<AlterConfigPolicy> alterConfigPolicy;
    private final int defaultNumPartitions;
    private final short defaultReplicationFactor;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    private DelayedOperationPurgatory<DelayedOperation> topicPurgatory() {
        return this.topicPurgatory;
    }

    private AdminZkClient adminZkClient() {
        return this.adminZkClient;
    }

    private Option<CreateTopicPolicy> createTopicPolicy() {
        return this.createTopicPolicy;
    }

    private Option<AlterConfigPolicy> alterConfigPolicy() {
        return this.alterConfigPolicy;
    }

    public boolean hasDelayedTopicOperations() {
        return this.topicPurgatory().numDelayed() != 0;
    }

    private int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    public void tryCompleteDelayedTopicOperations(String topic) {
        TopicKey key = new TopicKey(topic);
        int completed = this.topicPurgatory().checkAndComplete(key);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Request key ").append(key.keyLabel()).append(" unblocked ").append(completed).append(" topic requests.").toString());
    }

    public void createTopics(int timeout, boolean validateOnly, Map<String, CreateTopicsRequestData.CreatableTopic> toCreate, Map<String, CreateTopicsResponseData.CreatableTopicResult> includeConfigsAndMetatadata, Function1<Map<String, ApiError>, BoxedUnit> responseCallback) {
        Buffer buffer;
        Buffer buffer2;
        Seq brokers = (Seq)this.metadataCache().getAliveBrokers().map((Function1 & Serializable)b -> new BrokerMetadata(b.id(), b.rack()));
        IterableOnceOps iterableOnceOps = (IterableOnceOps)toCreate.values().map((Function1 & Serializable)topic -> {
            try {
                scala.collection.mutable.HashMap hashMap;
                short resolvedReplicationFactor;
                if (this.metadataCache().contains(topic.name())) {
                    throw new TopicExistsException(new StringBuilder(24).append("Topic '").append(topic.name()).append("' already exists.").toString());
                }
                Properties configs = new Properties();
                ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable)entry -> configs.setProperty(entry.name(), entry.value()));
                LogConfig$.MODULE$.validate(configs);
                if (!(topic.numPartitions() == -1 && topic.replicationFactor() == -1 || topic.assignments().isEmpty())) {
                    throw new InvalidRequestException("Both numPartitions or replicationFactor and replicasAssignments were set. Both cannot be used at the same time.");
                }
                int resolvedNumPartitions = topic.numPartitions() == -1 ? this.defaultNumPartitions() : topic.numPartitions();
                short s = resolvedReplicationFactor = topic.replicationFactor() == -1 ? this.defaultReplicationFactor() : topic.replicationFactor();
                if (topic.assignments().isEmpty()) {
                    hashMap = AdminUtils$.MODULE$.assignReplicasToBrokers((Seq<BrokerMetadata>)brokers, resolvedNumPartitions, resolvedReplicationFactor, -1, -1);
                } else {
                    scala.collection.mutable.HashMap assignments = new scala.collection.mutable.HashMap();
                    ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.assignments()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                        assignments.update((Object)x0$1.partitionIndex(), ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(x0$1.brokerIds()).asScala()).map((Function1 & Serializable)a -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(a))));
                        return BoxedUnit.UNIT;
                    });
                    hashMap = assignments;
                }
                scala.collection.mutable.HashMap assignments = hashMap;
                this.trace((Function0<String>)((Function0 & Serializable)() -> AdminManager.$anonfun$createTopics$6(topic, (Map)assignments)));
                Option<CreateTopicPolicy> option = this.createTopicPolicy();
                if (option instanceof Some) {
                    CreateTopicPolicy policy = (CreateTopicPolicy)((Some)option).value();
                    this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    Integer numPartitions = topic.assignments().isEmpty() ? Integer.valueOf(resolvedNumPartitions) : null;
                    Short replicationFactor = topic.assignments().isEmpty() ? Short.valueOf(resolvedReplicationFactor) : null;
                    java.util.Map javaAssignments = topic.assignments().isEmpty() ? null : (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)assignments.map((Function1 & Serializable)x0$2 -> {
                        void $minus$greater$extension_y;
                        Tuple2 tuple2;
                        if (x0$2 == null) {
                            throw new MatchError(null);
                        }
                        int k = x0$2._1$mcI$sp();
                        Seq v = (Seq)x0$2._2();
                        Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)v.map((Function1 & Serializable)i -> Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)i)))).asJava();
                        Integer $minus$greater$extension_$this = k;
                        Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                        Object var4_4 = null;
                        object = null;
                        tuple2 = null;
                        Tuple2 tuple23 = tuple22;
                        return tuple23;
                    })).asJava();
                    HashMap javaConfigs = new HashMap();
                    ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)topic.configs()).asScala()).foreach((Function1 & Serializable)config -> javaConfigs.put(config.name(), config.value()));
                    policy.validate(new CreateTopicPolicy.RequestMetadata(topic.name(), numPartitions, replicationFactor, javaAssignments, javaConfigs));
                    if (!validateOnly) {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    if (validateOnly) {
                        this.adminZkClient().validateTopicCreate(topic.name(), (Map<Object, Seq<Object>>)assignments, configs);
                    } else {
                        this.adminZkClient().createTopicWithAssignment(topic.name(), configs, (Map<Object, Seq<Object>>)assignments);
                    }
                } else {
                    throw new MatchError(option);
                }
                Option option2 = includeConfigsAndMetatadata.get((Object)topic.name());
                if (option2 == null) {
                    throw null;
                }
                Option foreach_this = option2;
                if (!foreach_this.isEmpty()) {
                    CreateTopicsResponseData.CreatableTopicResult creatableTopicResult = (CreateTopicsResponseData.CreatableTopicResult)foreach_this.get();
                    AdminManager.$anonfun$createTopics$10(this, configs, (Map)assignments, creatableTopicResult);
                }
                Object var20_16 = null;
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)assignments.keySet(), ApiError.NONE);
            }
            catch (TopicExistsException e) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("Topic creation failed since topic '").append(topic.name()).append("' already exists.").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)e));
            }
            catch (ConfigException e) {
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)new InvalidConfigurationException(e.getMessage(), e.getCause())));
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(38).append("Error processing create topic request ").append(topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return new CreatePartitionsMetadata(topic.name(), (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)e));
            }
        });
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Buffer buffer3 = buffer2 = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this);
        Object var11_7 = null;
        buffer2 = null;
        Buffer metadata = buffer3;
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$24(x$4)))) {
            scala.collection.immutable.Map results = ((IterableOnceOps)metadata.map((Function1 & Serializable)createTopicMetadata -> {
                if (createTopicMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createTopicMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createTopicMetadata.topic(), (Object)createTopicMetadata.error());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, responseCallback);
        IterableOnceOps iterableOnceOps2 = (IterableOnceOps)toCreate.values().map((Function1 & Serializable)topic -> new TopicKey(topic.name()));
        if (iterableOnceOps2 == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this2 = iterableOnceOps2;
        Buffer buffer4 = buffer = (Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this2);
        Object var13_12 = null;
        buffer = null;
        Buffer delayedCreateKeys = buffer4;
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public void deleteTopics(int timeout, Set<String> topics, Function1<Map<String, Errors>, BoxedUnit> responseCallback) {
        Set metadata = (Set)topics.map((Function1 & Serializable)topic -> {
            try {
                this.adminZkClient().deleteTopic((String)topic);
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (TopicAlreadyMarkedForDeletionException topicAlreadyMarkedForDeletionException) {
                return new DeleteTopicMetadata((String)topic, Errors.NONE);
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Error processing delete topic request for topic ").append((String)topic).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return new DeleteTopicMetadata((String)topic, Errors.forException((Throwable)e));
            }
        });
        if (timeout <= 0 || !metadata.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$deleteTopics$4(x$5)))) {
            scala.collection.immutable.Map results = ((IterableOnceOps)metadata.map((Function1 & Serializable)deleteTopicMetadata -> {
                Errors errors = deleteTopicMetadata.error();
                Errors errors2 = Errors.NONE;
                if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                    return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)Errors.REQUEST_TIMED_OUT);
                }
                return new Tuple2((Object)deleteTopicMetadata.topic(), (Object)deleteTopicMetadata.error());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            responseCallback.apply((Object)results);
            return;
        }
        DelayedDeleteTopics delayedDelete = new DelayedDeleteTopics(timeout, (Seq<DeleteTopicMetadata>)metadata.toSeq(), this, responseCallback);
        scala.collection.immutable.Seq delayedDeleteKeys = ((IterableOnceOps)topics.map((Function1 & Serializable)x$6 -> new TopicKey((String)x$6))).toSeq();
        this.topicPurgatory().tryCompleteElseWatch(delayedDelete, (Seq<Object>)delayedDeleteKeys);
    }

    public void createPartitions(int timeout, Seq<CreatePartitionsRequestData.CreatePartitionsTopic> newPartitions, boolean validateOnly, ListenerName listenerName, Function1<Map<String, ApiError>, BoxedUnit> callback) {
        Seq<BrokerMetadata> allBrokers = this.adminZkClient().getBrokerMetadatas(this.adminZkClient().getBrokerMetadatas$default$1(), this.adminZkClient().getBrokerMetadatas$default$2());
        Seq allBrokerIds = (Seq)allBrokers.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id()));
        Seq metadata = (Seq)newPartitions.map((Function1 & Serializable)newPartition -> {
            String topic = newPartition.name();
            try {
                None$ none$;
                Map existingAssignment = (Map)this.zkClient().getFullReplicaAssignmentForTopics((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)scala.collection.immutable.Set$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2;
                    Integer n;
                    Integer n2;
                    ReplicaAssignment assignment;
                    TopicPartition topicPartition;
                    if (x0$1 != null) {
                        topicPartition = (TopicPartition)x0$1._1();
                        assignment = (ReplicaAssignment)x0$1._2();
                        if (assignment.isBeingReassigned()) {
                            throw new ReassignmentInProgressException(new StringBuilder(57).append("A partition reassignment is in progress for the topic '").append(topic).append("'.").toString());
                        }
                    } else {
                        throw new MatchError(null);
                    }
                    Integer n3 = n2 = Integer.valueOf(topicPartition.partition());
                    n2 = null;
                    Integer n4 = n = n3;
                    n = null;
                    Integer $minus$greater$extension_$this = n4;
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment);
                    Object var5_6 = null;
                    tuple2 = null;
                    Tuple2 tuple23 = tuple22;
                    return tuple23;
                });
                if (existingAssignment.isEmpty()) {
                    throw new UnknownTopicOrPartitionException(new StringBuilder(28).append("The topic '").append(topic).append("' does not exist.").toString());
                }
                int oldNumPartitions = existingAssignment.size();
                int newNumPartitions = newPartition.count();
                int numPartitionsIncrement = newNumPartitions - oldNumPartitions;
                if (numPartitionsIncrement < 0) {
                    throw new InvalidPartitionsException(new StringBuilder(69).append("Topic currently has ").append(oldNumPartitions).append(" partitions, which is higher than the requested ").append(newNumPartitions).append(".").toString());
                }
                if (numPartitionsIncrement == 0) {
                    throw new InvalidPartitionsException(new StringBuilder(30).append("Topic already has ").append(oldNumPartitions).append(" partitions.").toString());
                }
                Option option = Option$.MODULE$.apply((Object)newPartition.assignments());
                if (option == null) {
                    throw null;
                }
                Option map_this = option;
                if (map_this.isEmpty()) {
                    none$ = None$.MODULE$;
                } else {
                    java.util.List list = (java.util.List)map_this.get();
                    none$ = new Some((Object)AdminManager.$anonfun$createPartitions$4(allBrokerIds, numPartitionsIncrement, existingAssignment, list));
                }
                None$ none$2 = none$;
                Object var14_10 = null;
                none$ = null;
                None$ newPartitionsAssignment = none$2;
                Map<Object, Seq<Object>> updatedReplicaAssignment = this.adminZkClient().addPartitions(topic, (Map<Object, ReplicaAssignment>)existingAssignment, allBrokers, newPartition.count(), (Option<Map<Object, Seq<Object>>>)newPartitionsAssignment, validateOnly);
                return new CreatePartitionsMetadata(topic, (Set<Object>)updatedReplicaAssignment.keySet(), ApiError.NONE);
            }
            catch (AdminOperationException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)e));
            }
            catch (ApiException e) {
                return new CreatePartitionsMetadata(topic, (Set<Object>)((Set)Set$.MODULE$.empty()), ApiError.fromThrowable((Throwable)e));
            }
        });
        if (timeout <= 0 || validateOnly || !metadata.exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createPartitions$8(x$9)))) {
            scala.collection.immutable.Map results = ((IterableOnceOps)metadata.map((Function1 & Serializable)createPartitionMetadata -> {
                if (createPartitionMetadata.error().isSuccess() && !validateOnly) {
                    return new Tuple2((Object)createPartitionMetadata.topic(), (Object)new ApiError(Errors.REQUEST_TIMED_OUT, null));
                }
                return new Tuple2((Object)createPartitionMetadata.topic(), (Object)createPartitionMetadata.error());
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            callback.apply((Object)results);
            return;
        }
        DelayedCreatePartitions delayedCreate = new DelayedCreatePartitions(timeout, (Seq<CreatePartitionsMetadata>)metadata, this, callback);
        Seq delayedCreateKeys = (Seq)newPartitions.map((Function1 & Serializable)createPartitionTopic -> new TopicKey(createPartitionTopic.name()));
        this.topicPurgatory().tryCompleteElseWatch(delayedCreate, (Seq<Object>)delayedCreateKeys);
    }

    public Map<ConfigResource, DescribeConfigsResponse.Config> describeConfigs(Map<ConfigResource, Option<Set<String>>> resourceToConfigNames, boolean includeSynonyms) {
        return resourceToConfigNames.map((Function1 & Serializable)x0$12 -> {
            Tuple2 tuple2;
            if (x0$12 != null) {
                ConfigResource resource = (ConfigResource)x0$12._1();
                Option configNames = (Option)x0$12._2();
                try {
                    DescribeConfigsResponse.Config config;
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        DescribeConfigsResponse.Config config2;
                        String topic = resource.name();
                        Topic.validate((String)topic);
                        if (this.metadataCache().contains(topic)) {
                            Properties topicProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
                            LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog(this.config()), topicProps);
                            Function2 & Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable)(name, value) -> this.createTopicConfigEntry(logConfig, topicProps, includeSynonyms, (String)name, value);
                            IterableOnceOps iterableOnceOps = (IterableOnceOps)AdminManager.allConfigs$1(logConfig).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)));
                            if (iterableOnceOps == null) {
                                throw null;
                            }
                            IterableOnceOps createResponseConfig$1_toBuffer_this = iterableOnceOps;
                            Object var17_10 = null;
                            Buffer createResponseConfig$1_configEntries = (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)createResponseConfig$1_toBuffer_this)).map((Function1 & Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            });
                            config2 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                            Object var15_9 = null;
                            Object var16_11 = null;
                        } else {
                            config2 = new DescribeConfigsResponse.Config(new ApiError(Errors.UNKNOWN_TOPIC_OR_PARTITION, null), Collections.emptyList());
                        }
                        config = config2;
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        DescribeConfigsResponse.Config config3;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            Function2 & Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(false, includeSynonyms, (String)name, value);
                            IterableOnceOps iterableOnceOps = (IterableOnceOps)this.config().dynamicConfig().currentDynamicDefaultConfigs().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)));
                            if (iterableOnceOps == null) {
                                throw null;
                            }
                            IterableOnceOps createResponseConfig$1_toBuffer_this = iterableOnceOps;
                            Object var20_14 = null;
                            Buffer createResponseConfig$1_configEntries = (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)createResponseConfig$1_toBuffer_this)).map((Function1 & Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            });
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                            Object var18_13 = null;
                            Object var19_15 = null;
                        } else if (this.resourceNameToBrokerId(resource.name()) == this.config().brokerId()) {
                            Function2 & Serializable createResponseConfig$1_createConfigEntry = (Function2 & Serializable)(name, value) -> this.createBrokerConfigEntry(true, includeSynonyms, (String)name, value);
                            IterableOnceOps iterableOnceOps = (IterableOnceOps)AdminManager.allConfigs$1(this.config()).filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)));
                            if (iterableOnceOps == null) {
                                throw null;
                            }
                            IterableOnceOps createResponseConfig$1_toBuffer_this = iterableOnceOps;
                            Object var23_17 = null;
                            Buffer createResponseConfig$1_configEntries = (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)createResponseConfig$1_toBuffer_this)).map((Function1 & Serializable)x0$2 -> {
                                if (x0$2 == null) {
                                    throw new MatchError(null);
                                }
                                String name = (String)x0$2._1();
                                Object value = x0$2._2();
                                DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
                                return configEntry;
                            });
                            config3 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                            Object var21_16 = null;
                            Object var22_18 = null;
                        } else {
                            throw new InvalidRequestException(new StringBuilder(62).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" or empty string, but received ").append(resource.name()).toString());
                        }
                        config = config3;
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        DescribeConfigsResponse.Config config4;
                        void createResponseConfig$1_createConfigEntry;
                        if (resource.name() == null || resource.name().isEmpty()) {
                            throw new InvalidRequestException("Broker id must not be empty");
                        }
                        if (this.resourceNameToBrokerId(resource.name()) != this.config().brokerId()) {
                            throw new InvalidRequestException(new StringBuilder(45).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(" but received ").append(resource.name()).toString());
                        }
                        Function2 & Serializable intersect = (Function2 & Serializable)(name, value) -> new DescribeConfigsResponse.ConfigEntry(name, value.toString(), DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, false, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava());
                        scala.collection.mutable.Map<String, String> createResponseConfig$1_configs = Log4jController$.MODULE$.loggers();
                        IterableOnceOps iterableOnceOps = (IterableOnceOps)createResponseConfig$1_configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)));
                        if (iterableOnceOps == null) {
                            throw null;
                        }
                        IterableOnceOps createResponseConfig$1_toBuffer_this = iterableOnceOps;
                        Object var28_21 = null;
                        Buffer createResponseConfig$1_filteredConfigPairs = (Buffer)Buffer$.MODULE$.from((IterableOnce)createResponseConfig$1_toBuffer_this);
                        Buffer createResponseConfig$1_configEntries = (Buffer)createResponseConfig$1_filteredConfigPairs.map(arg_0 -> AdminManager.$anonfun$describeConfigs$5((Function2)createResponseConfig$1_createConfigEntry, arg_0));
                        DescribeConfigsResponse.Config config5 = config4 = new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(createResponseConfig$1_configEntries).asJava());
                        Object var24_20 = null;
                        intersect = null;
                        Object var26_22 = null;
                        Object var27_23 = null;
                        config4 = null;
                        config = config5;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(27).append("Unsupported resource type: ").append(type).toString());
                    }
                    tuple2 = new Tuple2((Object)resource, (Object)config);
                }
                catch (Throwable e) {
                    Tuple2 tuple22;
                    String message = new StringBuilder(55).append("Error processing describe configs request for resource ").append(resource).toString();
                    if (e instanceof ApiException) {
                        this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    } else {
                        this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> e);
                    }
                    DescribeConfigsResponse.Config $minus$greater$extension_y = new DescribeConfigsResponse.Config(ApiError.fromThrowable((Throwable)e), Collections.emptyList());
                    tuple2 = tuple22 = new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
                    Object var13_27 = null;
                    tuple22 = null;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple23 = tuple2;
            return tuple23;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Map<ConfigResource, ApiError> alterConfigs(Map<ConfigResource, AlterConfigsRequest.Config> configs, boolean validateOnly) {
        return configs.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                AlterConfigsRequest.Config config = (AlterConfigsRequest.Config)x0$1._2();
                try {
                    Tuple2 tuple22;
                    scala.collection.immutable.Map configEntriesMap = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).map((Function1 & Serializable)entry -> new Tuple2((Object)entry.name(), (Object)entry.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    Properties configProps = new Properties();
                    ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable)configEntry -> configProps.setProperty(configEntry.name(), configEntry.value()));
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2 tuple23;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        Tuple2 tuple24;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable)() -> message);
                        ApiError $minus$greater$extension_y = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Tuple2 tuple25 = tuple24 = new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
                        Object var15_12 = null;
                        tuple24 = null;
                        tuple23 = tuple25;
                    } else if (throwable != null) {
                        Tuple2 tuple26;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(config).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                        }
                        ApiError $minus$greater$extension_y = ApiError.fromThrowable((Throwable)throwable);
                        Tuple2 tuple27 = tuple26 = new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
                        Object var17_16 = null;
                        tuple26 = null;
                        tuple23 = tuple27;
                    } else {
                        throw null;
                    }
                    tuple2 = tuple23;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2 tuple28 = tuple2;
            return tuple28;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Tuple2<ConfigResource, ApiError> alterTopicConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        String topic = resource.name();
        this.adminZkClient().validateTopicConfig(topic, configProps);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Updating topic ").append(topic).append(" with new configuration ").append((Object)this.config()).toString());
            this.adminZkClient().changeTopicConfig(topic, configProps);
        }
        ApiError $minus$greater$extension_y = ApiError.NONE;
        return new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
    }

    private Tuple2<ConfigResource, ApiError> alterBrokerConfigs(ConfigResource resource, boolean validateOnly, Properties configProps, Map<String, String> configEntriesMap) {
        Option<Object> brokerId = this.getBrokerId(resource);
        if (brokerId == null) {
            throw null;
        }
        boolean bl = brokerId.isDefined();
        this.config().dynamicConfig().validate(configProps, bl);
        this.validateConfigPolicy(resource, configEntriesMap);
        if (!validateOnly) {
            if (bl) {
                this.config().dynamicConfig().reloadUpdatedFilesWithoutConfigChange(configProps);
            }
            this.adminZkClient().changeBrokerConfig(brokerId, this.config().dynamicConfig().toPersistentProps(configProps, bl));
        }
        ApiError $minus$greater$extension_y = ApiError.NONE;
        return new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
    }

    private void alterLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AdminManager.$anonfun$alterLogLevelConfigs$1((AlterConfigOp)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private Option<Object> getBrokerId(ConfigResource resource) {
        if (resource.name() == null || resource.name().isEmpty()) {
            return None$.MODULE$;
        }
        int id = this.resourceNameToBrokerId(resource.name());
        if (id != this.config().brokerId()) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.config().brokerId()).append(", but received ").append(resource.name()).toString());
        }
        return new Some((Object)id);
    }

    private void validateConfigPolicy(ConfigResource resource, Map<String, String> configEntriesMap) {
        Option<AlterConfigPolicy> option = this.alterConfigPolicy();
        if (option instanceof Some) {
            ((AlterConfigPolicy)((Some)option).value()).validate(new AlterConfigPolicy.RequestMetadata(new ConfigResource(resource.type(), resource.name()), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(configEntriesMap).asJava()));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            return;
        }
        throw new MatchError(option);
    }

    public Map<ConfigResource, ApiError> incrementalAlterConfigs(Map<ConfigResource, List<AlterConfigOp>> configs, boolean validateOnly) {
        return configs.map((Function1 & Serializable)x0$1 -> {
            Tuple2<ConfigResource, ApiError> tuple2;
            if (x0$1 != null) {
                ConfigResource resource = (ConfigResource)x0$1._1();
                List alterConfigOps = (List)x0$1._2();
                try {
                    Tuple2<ConfigResource, ApiError> tuple22;
                    Nil$ nil$;
                    scala.collection.immutable.Set duplicateKeys = alterConfigOps.groupBy((Function1 & Serializable)config -> config.configEntry().name()).mapValues((Function1 & Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.size())).filter((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$incrementalAlterConfigs$4(x$13))).keys().toSet();
                    if (duplicateKeys.nonEmpty()) {
                        String mkString_sep = ",";
                        Object var19_6 = null;
                        throw new InvalidRequestException(new StringBuilder(37).append("Error due to duplicate config keys : ").append(duplicateKeys.mkString("", mkString_sep, "")).toString());
                    }
                    if (alterConfigOps == Nil$.MODULE$) {
                        nil$ = Nil$.MODULE$;
                    } else {
                        .colon.colon map_h;
                        .colon.colon map_t = map_h = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)alterConfigOps.head()), (List)Nil$.MODULE$);
                        for (List map_rest = (List)alterConfigOps.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                            .colon.colon map_nx = new .colon.colon((Object)AdminManager.$anonfun$incrementalAlterConfigs$5((AlterConfigOp)map_rest.head()), (List)Nil$.MODULE$);
                            map_t.next_$eq((List)map_nx);
                            map_t = map_nx;
                        }
                        Statics.releaseFence();
                        nil$ = map_h;
                    }
                    Nil$ nil$2 = nil$;
                    Object var26_8 = null;
                    Object var27_9 = null;
                    Object var28_10 = null;
                    Object var29_11 = null;
                    nil$ = null;
                    scala.collection.immutable.Map configEntriesMap = nil$2.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                    ConfigResource.Type type = resource.type();
                    if (ConfigResource.Type.TOPIC.equals(type)) {
                        Properties configProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), resource.name());
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, LogConfig$.MODULE$.configKeys());
                        tuple22 = this.alterTopicConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER.equals(type)) {
                        Option<Object> brokerId = this.getBrokerId(resource);
                        if (brokerId == null) {
                            throw null;
                        }
                        boolean bl = brokerId.isDefined();
                        Properties persistentProps = bl ? this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), brokerId.get().toString()) : this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ConfigEntityName$.MODULE$.Default());
                        Properties configProps = this.config().dynamicConfig().fromPersistentProps(persistentProps, bl);
                        this.prepareIncrementalConfigs((List<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
                        tuple22 = this.alterBrokerConfigs(resource, validateOnly, configProps, (Map<String, String>)configEntriesMap);
                    } else if (ConfigResource.Type.BROKER_LOGGER.equals(type)) {
                        Tuple2<ConfigResource, ApiError> tuple23;
                        this.getBrokerId(resource);
                        this.validateLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        if (!validateOnly) {
                            this.alterLogLevelConfigs((List<AlterConfigOp>)alterConfigOps);
                        }
                        ApiError $minus$greater$extension_y = ApiError.NONE;
                        Tuple2<ConfigResource, ApiError> tuple24 = tuple23 = new Tuple2<ConfigResource, ApiError>((Object)resource, (Object)$minus$greater$extension_y);
                        Object var20_20 = null;
                        tuple23 = null;
                        tuple22 = tuple24;
                    } else {
                        throw new InvalidRequestException(new StringBuilder(76).append("AlterConfigs is only supported for topics and brokers, but resource type is ").append(type).toString());
                    }
                    tuple2 = tuple22;
                }
                catch (Throwable throwable) {
                    Tuple2<ConfigResource, ApiError> tuple25;
                    boolean bl = throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException;
                    if (bl) {
                        Tuple2<ConfigResource, ApiError> tuple26;
                        String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                        this.info((Function0<String>)(Function0 & Serializable)() -> message);
                        ApiError $minus$greater$extension_y = ApiError.fromThrowable((Throwable)new InvalidRequestException(message, throwable));
                        Tuple2<ConfigResource, ApiError> tuple27 = tuple26 = new Tuple2<ConfigResource, ApiError>((Object)resource, (Object)$minus$greater$extension_y);
                        Object var22_25 = null;
                        tuple26 = null;
                        tuple25 = tuple27;
                    } else if (throwable != null) {
                        Tuple2 tuple28;
                        String message = new StringBuilder(61).append("Error processing alter configs request for resource ").append(resource).append(", config ").append(alterConfigOps).toString();
                        if (throwable instanceof ApiException) {
                            this.info((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                        } else {
                            this.error((Function0<String>)(Function0 & Serializable)() -> message, (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                        }
                        ApiError $minus$greater$extension_y = ApiError.fromThrowable((Throwable)throwable);
                        Tuple2 tuple29 = tuple28 = new Tuple2((Object)resource, (Object)$minus$greater$extension_y);
                        Object var24_29 = null;
                        tuple28 = null;
                        tuple25 = tuple29;
                    } else {
                        throw null;
                    }
                    tuple2 = tuple25;
                }
            } else {
                throw new MatchError(null);
            }
            Tuple2<ConfigResource, ApiError> tuple210 = tuple2;
            return tuple210;
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private void validateLogLevelConfigs(List<AlterConfigOp> alterConfigOps) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AdminManager.$anonfun$validateLogLevelConfigs$1((AlterConfigOp)foreach_these.head());
            foreach_these = (List)foreach_these.tail();
        }
    }

    private void prepareIncrementalConfigs(List<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        if (alterConfigOps == null) {
            throw null;
        }
        List foreach_these = alterConfigOps;
        while (!foreach_these.isEmpty()) {
            AlterConfigOp alterConfigOp = (AlterConfigOp)foreach_these.head();
            AdminManager.$anonfun$prepareIncrementalConfigs$1(configProps, configKeys, alterConfigOp);
            foreach_these = (List)foreach_these.tail();
        }
    }

    public void shutdown() {
        this.topicPurgatory().shutdown();
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<CreateTopicPolicy> option = this.createTopicPolicy();
            if (option == null) {
                throw null;
            }
            Option<CreateTopicPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((CreateTopicPolicy)foreach_this.get()).close();
            }
        }, this, Level.WARN);
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            Option<AlterConfigPolicy> option = this.alterConfigPolicy();
            if (option == null) {
                throw null;
            }
            Option<AlterConfigPolicy> foreach_this = option;
            if (!foreach_this.isEmpty()) {
                ((AlterConfigPolicy)foreach_this.get()).close();
            }
        }, this, Level.WARN);
    }

    private int resourceNameToBrokerId(String resourceName) {
        try {
            return Integer.parseInt(resourceName);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(41).append("Broker id must be an integer, but it is: ").append(resourceName).toString());
        }
    }

    private List<String> brokerSynonyms(String name) {
        return DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
    }

    /*
     * WARNING - void declaration
     */
    private ConfigDef.Type configType(String name, List<String> synonyms) {
        void orNull_ev;
        ConfigDef.Type configType = this.config().typeOf(name);
        if (configType != null) {
            return configType;
        }
        Option option = synonyms.iterator().map((Function1 & Serializable)x$1 -> this.config().typeOf((String)x$1)).find((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configType$2(x$16)));
        .eq.colon.eq eq2 = $less$colon$less$.MODULE$.refl();
        if (option == null) {
            throw null;
        }
        Option orNull_this = option;
        Object object = orNull_this.isEmpty() ? orNull_ev.apply(null) : orNull_this.get();
        return (ConfigDef.Type)object;
    }

    private List<DescribeConfigsResponse.ConfigSynonym> configSynonyms(String name, List<String> synonyms, boolean isSensitive) {
        DynamicBrokerConfig dynamicConfig = this.config().dynamicConfig();
        Buffer allSynonyms = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        Map<String, String> map = dynamicConfig.currentDynamicBrokerConfigs();
        if (synonyms == null) {
            throw null;
        }
        List foreach_these = synonyms;
        while (!foreach_these.isEmpty()) {
            String string = (String)foreach_these.head();
            AdminManager.maybeAddSynonym$1(map, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these = (List)foreach_these.tail();
        }
        Object var8_7 = null;
        Map<String, String> map2 = dynamicConfig.currentDynamicDefaultConfigs();
        List foreach_these2 = synonyms;
        while (!foreach_these2.isEmpty()) {
            String string = (String)foreach_these2.head();
            AdminManager.maybeAddSynonym$1(map2, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these2 = (List)foreach_these2.tail();
        }
        Object var9_10 = null;
        List foreach_these3 = synonyms;
        while (!foreach_these3.isEmpty()) {
            String string = (String)foreach_these3.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, string, isSensitive, allSynonyms);
            foreach_these3 = (List)foreach_these3.tail();
        }
        Object var10_12 = null;
        List foreach_these4 = synonyms;
        while (!foreach_these4.isEmpty()) {
            String string = (String)foreach_these4.head();
            AdminManager.maybeAddSynonym$1(dynamicConfig.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, string, isSensitive, allSynonyms);
            foreach_these4 = (List)foreach_these4.tail();
        }
        Object var11_14 = null;
        return ((IterableOnceOps)allSynonyms.dropWhile((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$configSynonyms$6(name, s)))).toList();
    }

    private DescribeConfigsResponse.ConfigEntry createTopicConfigEntry(LogConfig logConfig, Properties topicProps, boolean includeSynonyms, String name, Object value) {
        DescribeConfigsResponse.ConfigSource source;
        List list;
        Object object;
        None$ none$;
        ConfigDef.Type configEntryType;
        ConfigDef.Type type = configEntryType = logConfig.typeOf(name);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean isSensitive = !(type != null ? !type.equals(type2) : type2 != null);
        String valueAsString = isSensitive ? null : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
        Option option = LogConfig$.MODULE$.TopicConfigSynonyms().get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            String string = (String)map_this.get();
            none$ = new Some((Object)this.configSynonyms(string, DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(string, true), isSensitive));
        }
        None$ none$2 = none$;
        Object var15_10 = null;
        none$ = null;
        None$ getOrElse_this = none$2;
        if (getOrElse_this.isEmpty()) {
            Nil$ nil$;
            Nil$ nil$2;
            Nil$ nil$3 = nil$2 = Nil$.MODULE$;
            nil$2 = null;
            Nil$ nil$4 = nil$ = nil$3;
            nil$ = null;
            object = nil$4;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var17_13 = null;
        object = null;
        List list2 = (List)object2;
        if (!topicProps.containsKey(name)) {
            list = list2;
        } else {
            DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name, valueAsString, DescribeConfigsResponse.ConfigSource.TOPIC_CONFIG);
            if (list2 == null) {
                throw null;
            }
            list = new .colon.colon((Object)configSynonym, list2);
        }
        List allSynonyms = list;
        DescribeConfigsResponse.ConfigSource configSource = source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        List synonyms = !includeSynonyms ? Nil$.MODULE$ : allSynonyms;
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, false, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    private DescribeConfigsResponse.ConfigEntry createBrokerConfigEntry(boolean perBrokerConfig, boolean includeSynonyms, String name, Object value) {
        Object var17_30;
        Nil$ nil$;
        Object var22_19;
        Object var21_18;
        List list;
        Object var30_27;
        Object var29_26;
        Object var28_25;
        Object var27_24;
        Object var26_23;
        Object var25_22;
        Object var24_21;
        Object var23_20;
        Nil$ nil$2;
        String string;
        boolean isSensitive;
        ConfigDef.Type configEntryType;
        List<String> list2;
        List<String> list3 = list2 = DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(name, true);
        list2 = null;
        List<String> allNames = list3;
        ConfigDef.Type type = configEntryType = this.configType(name, allNames);
        ConfigDef.Type type2 = ConfigDef.Type.PASSWORD;
        boolean bl = !(type == null ? type2 != null : !type.equals(type2)) || configEntryType == null ? true : (isSensitive = false);
        if (isSensitive) {
            string = null;
        } else {
            String string2 = value instanceof String ? (String)value : ConfigDef.convertToString((Object)value, (ConfigDef.Type)configEntryType);
            string = string2;
        }
        String valueAsString = string;
        List list4 = this.configSynonyms(name, allNames, isSensitive);
        if (list4 == null) {
            throw null;
        }
        List filter_this = list4;
        boolean filter_filterImpl_isFlipped = false;
        List filter_filterImpl_noneIn$1_l = filter_this;
        while (true) {
            if (filter_filterImpl_noneIn$1_l.isEmpty()) {
                nil$2 = Nil$.MODULE$;
                break;
            }
            Object filter_filterImpl_noneIn$1_h = filter_filterImpl_noneIn$1_l.head();
            List filter_filterImpl_noneIn$1_t = (List)filter_filterImpl_noneIn$1_l.tail();
            DescribeConfigsResponse.ConfigSynonym configSynonym = (DescribeConfigsResponse.ConfigSynonym)filter_filterImpl_noneIn$1_h;
            if (AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, configSynonym) != filter_filterImpl_isFlipped) {
                List list5;
                block13: {
                    List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next;
                    List filter_filterImpl_noneIn$1_allIn$1_remaining = filter_filterImpl_noneIn$1_t;
                    while (true) {
                        if (filter_filterImpl_noneIn$1_allIn$1_remaining.isEmpty()) {
                            list5 = filter_filterImpl_noneIn$1_l;
                            break block13;
                        }
                        Object filter_filterImpl_noneIn$1_allIn$1_x = filter_filterImpl_noneIn$1_allIn$1_remaining.head();
                        configSynonym = (DescribeConfigsResponse.ConfigSynonym)filter_filterImpl_noneIn$1_allIn$1_x;
                        if (AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, configSynonym) == filter_filterImpl_isFlipped) break;
                        filter_filterImpl_noneIn$1_allIn$1_remaining = (List)filter_filterImpl_noneIn$1_allIn$1_remaining.tail();
                    }
                    .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newHead = new .colon.colon(filter_filterImpl_noneIn$1_l.head(), (List)Nil$.MODULE$);
                    .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newHead;
                    for (List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterImpl_noneIn$1_l.tail(); filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess != filter_filterImpl_noneIn$1_allIn$1_remaining; filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess.tail()) {
                        .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_toProcess.head(), (List)Nil$.MODULE$);
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem);
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem;
                    }
                    List filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_remaining.tail();
                    while (!filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.isEmpty()) {
                        Object filter_filterImpl_noneIn$1_allIn$1_partialFill$1_head = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.head();
                        configSynonym = (DescribeConfigsResponse.ConfigSynonym)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_head;
                        if (AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig, configSynonym) != filter_filterImpl_isFlipped) {
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                            continue;
                        }
                        while (filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy != filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next) {
                            .colon.colon filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem = new .colon.colon(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.head(), (List)Nil$.MODULE$);
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq((List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem);
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast = filter_filterImpl_noneIn$1_allIn$1_partialFill$1_newElem;
                            filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.tail();
                        }
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next = (List)filter_filterImpl_noneIn$1_allIn$1_partialFill$1_next.tail();
                    }
                    if (!filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy.isEmpty()) {
                        filter_filterImpl_noneIn$1_allIn$1_partialFill$1_currentLast.next_$eq(filter_filterImpl_noneIn$1_allIn$1_partialFill$1_nextToCopy);
                    }
                    list5 = var23_20;
                    var23_20 = null;
                    var24_21 = null;
                    var25_22 = null;
                    var26_23 = null;
                    var27_24 = null;
                    var28_25 = null;
                    var29_26 = null;
                    var30_27 = null;
                }
                list = list5;
                nil$2 = list;
                var21_18 = null;
                var22_19 = null;
                var23_20 = null;
                var24_21 = null;
                var25_22 = null;
                var26_23 = null;
                var27_24 = null;
                var28_25 = null;
                var29_26 = null;
                var30_27 = null;
                list = null;
                break;
            }
            filter_filterImpl_noneIn$1_l = filter_filterImpl_noneIn$1_t;
        }
        Nil$ nil$3 = nil$ = nil$2;
        Object var18_14 = null;
        Object var19_16 = null;
        Object var20_17 = null;
        var21_18 = null;
        var22_19 = null;
        var23_20 = null;
        var24_21 = null;
        var25_22 = null;
        var26_23 = null;
        var27_24 = null;
        var28_25 = null;
        var29_26 = null;
        var30_27 = null;
        list = null;
        nil$ = null;
        Nil$ filter_filterImpl_result = nil$3;
        Statics.releaseFence();
        void v8 = var17_30;
        Object var15_12 = null;
        var17_30 = null;
        void allSynonyms = v8;
        void synonyms = !includeSynonyms ? Nil$.MODULE$ : allSynonyms;
        DescribeConfigsResponse.ConfigSource source = allSynonyms.isEmpty() ? DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG : ((DescribeConfigsResponse.ConfigSynonym)allSynonyms.head()).source();
        boolean readOnly = !DynamicBrokerConfig$.MODULE$.AllDynamicConfigs().contains((Object)name);
        return new DescribeConfigsResponse.ConfigEntry(name, valueAsString, source, isSensitive, readOnly, (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)synonyms).asJava());
    }

    public static final /* synthetic */ String $anonfun$createTopics$6(CreateTopicsRequestData.CreatableTopic topic$1, Map assignments$2) {
        return new StringBuilder(28).append("Assignments for topic ").append(topic$1).append(" are ").append(assignments$2).append(" ").toString();
    }

    public static final /* synthetic */ byte $anonfun$createTopics$13(int x$3) {
        return (byte)x$3;
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$14(DescribeConfigsResponse.ConfigEntry entry$1, byte i) {
        DescribeConfigsResponse.ConfigSource configSource = DescribeConfigsResponse.ConfigSource.forId((byte)i);
        DescribeConfigsResponse.ConfigSource configSource2 = entry$1.source();
        return !(configSource != null ? !configSource.equals(configSource2) : configSource2 != null);
    }

    public static final /* synthetic */ byte $anonfun$createTopics$15() {
        return (byte)0;
    }

    public static final /* synthetic */ CreateTopicsResponseData.CreatableTopicResult $anonfun$createTopics$10(AdminManager $this, Properties configs$1, Map assignments$2, CreateTopicsResponseData.CreatableTopicResult result) {
        LogConfig logConfig = LogConfig$.MODULE$.fromProps(KafkaServer$.MODULE$.copyKafkaConfigToLog($this.config()), configs$1);
        Function2 & Serializable createEntry = (Function2 & Serializable)(x$1, x$2) -> $this.createTopicConfigEntry(logConfig, configs$1, false, (String)x$1, x$2);
        java.util.List topicConfigs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(logConfig.values()).asScala()).map((Function1 & Serializable)x0$3 -> {
            Object object;
            DescribeConfigsResponse.ConfigEntry entry;
            String k;
            if (x0$3 != null) {
                Byte by;
                k = (String)x0$3._1();
                Object v = x0$3._2();
                entry = (DescribeConfigsResponse.ConfigEntry)createEntry.apply((Object)k, v);
                Range range = ArrayOps$.MODULE$.indices$extension((Object)DescribeConfigsResponse.ConfigSource.values());
                if (range == null) {
                    throw null;
                }
                Range map_this = range;
                map_this.scala$collection$immutable$Range$$validateMaxLength();
                Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
                Iterator map_strictOptimizedMap_it = map_this.iterator();
                while (map_strictOptimizedMap_it.hasNext()) {
                    void map_strictOptimizedMap_$plus$eq_elem;
                    Byte by2;
                    Byte by3;
                    Byte by4 = by3 = Byte.valueOf((byte)BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
                    by3 = null;
                    Byte by5 = by2 = by4;
                    by2 = null;
                    by = by5;
                    if (map_strictOptimizedMap_b == null) {
                        throw null;
                    }
                    map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
                    by = null;
                }
                Object var9_5 = null;
                Object var10_6 = null;
                Object var11_7 = null;
                by = null;
                Option option = ((IndexedSeq)map_strictOptimizedMap_b.result()).find((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createTopics$14(entry, BoxesRunTime.unboxToByte((Object)i))));
                if (option == null) {
                    throw null;
                }
                Option getOrElse_this = option;
                if (getOrElse_this.isEmpty()) {
                    Byte by6;
                    Byte by7 = by6 = Byte.valueOf((byte)0);
                    by6 = null;
                    object = by7;
                } else {
                    object = getOrElse_this.get();
                }
            } else {
                throw new MatchError(null);
            }
            Object object2 = object;
            Object var7_11 = null;
            object = null;
            byte source = BoxesRunTime.unboxToByte((Object)object2);
            CreateTopicsResponseData.CreatableTopicConfigs creatableTopicConfigs = new CreateTopicsResponseData.CreatableTopicConfigs().setName(k).setValue(entry.value()).setIsSensitive(entry.isSensitive()).setReadOnly(entry.isReadOnly()).setConfigSource(source);
            return creatableTopicConfigs;
        })).toList()).asJava();
        result.setConfigs(topicConfigs);
        result.setNumPartitions(assignments$2.size());
        SeqOps seqOps = (SeqOps)assignments$2.apply((Object)0);
        if (seqOps == null) {
            throw null;
        }
        return result.setReplicationFactor((short)seqOps.length());
    }

    public static final /* synthetic */ boolean $anonfun$createTopics$24(CreatePartitionsMetadata x$4) {
        return x$4.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$deleteTopics$4(DeleteTopicMetadata x$5) {
        Errors errors = x$5.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createPartitions$4(Seq allBrokerIds$1, int numPartitionsIncrement$1, Map existingAssignment$1, java.util.List assignmentMap) {
        Buffer assignments = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(assignmentMap).asScala()).map((Function1 & Serializable)createPartitionAssignment -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(createPartitionAssignment.brokerIds()).asScala()).map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x$8))));
        scala.collection.immutable.Set set = ((IterableOnceOps)assignments.flatten((Function1)$less$colon$less$.MODULE$.refl())).toSet();
        if (set == null) {
            throw null;
        }
        scala.collection.immutable.Set unknownBrokers = (scala.collection.immutable.Set)set.removedAll((IterableOnce)allBrokerIds$1);
        if (unknownBrokers.nonEmpty()) {
            String mkString_sep = ", ";
            Object var6_6 = null;
            throw new InvalidReplicaAssignmentException(new StringBuilder(42).append("Unknown broker(s) in replica assignment: ").append(unknownBrokers.mkString("", mkString_sep, "")).append(".").toString());
        }
        if (assignments.length() != numPartitionsIncrement$1) {
            throw new InvalidReplicaAssignmentException(new StringBuilder(0).append(new StringBuilder(40).append("Increasing the number of partitions by ").append(numPartitionsIncrement$1).append(" ").toString()).append(new StringBuilder(26).append("but ").append(assignments.length()).append(" assignments provided.").toString()).toString());
        }
        return ((IterableOnceOps)((IterableOps)assignments.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            Buffer replicas = (Buffer)x0$2._1();
            int index = x0$2._2$mcI$sp();
            Integer n3 = n2 = Integer.valueOf(existingAssignment$1.size() + index);
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var5_6 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public static final /* synthetic */ boolean $anonfun$createPartitions$8(CreatePartitionsMetadata x$9) {
        return x$9.error().is(Errors.NONE);
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$2(Tuple2 x$10) {
        return x$10._2() != null;
    }

    private static final scala.collection.mutable.Map allConfigs$1(AbstractConfig config) {
        return (scala.collection.mutable.Map)((MapOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.originals()).asScala()).filter((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$2(x$10)))).$plus$plus((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(config.values()).asScala());
    }

    public static final /* synthetic */ boolean $anonfun$describeConfigs$3(Option configNames$1, Tuple2 x0$1) {
        boolean bl;
        if (x0$1 != null) {
            String configName = (String)x0$1._1();
            bl = configNames$1.isEmpty() || ((Set)configNames$1.get()).contains((Object)configName);
        } else {
            throw new MatchError(null);
        }
        return bl;
    }

    private static final DescribeConfigsResponse.Config createResponseConfig$1(Map configs, Function2 createConfigEntry, Option configNames$1) {
        IterableOnceOps iterableOnceOps = (IterableOnceOps)configs.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$describeConfigs$3(configNames, x0$1)));
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps toBuffer_this = iterableOnceOps;
        Object var4_3 = null;
        Buffer configEntries = (Buffer)((Buffer)Buffer$.MODULE$.from((IterableOnce)toBuffer_this)).map((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$2._1();
            Object value = x0$2._2();
            DescribeConfigsResponse.ConfigEntry configEntry = (DescribeConfigsResponse.ConfigEntry)createResponseConfig$1_createConfigEntry.apply((Object)name, value);
            return configEntry;
        });
        return new DescribeConfigsResponse.Config(ApiError.NONE, (Collection)JavaConverters$.MODULE$.bufferAsJavaListConverter(configEntries).asJava());
    }

    public static final /* synthetic */ boolean $anonfun$alterLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        boolean bl;
        String loggerName = alterConfigOp.configEntry().name();
        String logLevel = alterConfigOp.configEntry().value();
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            bl = Log4jController$.MODULE$.logLevel(loggerName, logLevel);
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            bl = Log4jController$.MODULE$.unsetLogLevel(loggerName);
        } else {
            throw new IllegalArgumentException(new StringBuilder(40).append("Log level cannot be changed for OpType: ").append(alterConfigOp.opType()).toString());
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$incrementalAlterConfigs$4(Tuple2 x$13) {
        return x$13._2$mcI$sp() > 1;
    }

    public static final /* synthetic */ Tuple2 $anonfun$incrementalAlterConfigs$5(AlterConfigOp entry) {
        return new Tuple2((Object)entry.configEntry().name(), (Object)entry.configEntry().value());
    }

    private static final void validateLoggerNameExists$1(String loggerName) {
        if (!Log4jController$.MODULE$.loggerExists(loggerName)) {
            throw new ConfigException(new StringBuilder(23).append("Logger ").append(loggerName).append(" does not exist!").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$validateLogLevelConfigs$1(AlterConfigOp alterConfigOp) {
        block9: {
            AlterConfigOp.OpType opType;
            block10: {
                block12: {
                    String string;
                    String string2;
                    block11: {
                        String loggerName;
                        block8: {
                            loggerName = alterConfigOp.configEntry().name();
                            opType = alterConfigOp.opType();
                            if (!AlterConfigOp.OpType.SET.equals(opType)) break block8;
                            AdminManager.validateLoggerNameExists$1(loggerName);
                            String logLevel = alterConfigOp.configEntry().value();
                            if (!LogLevelConfig.VALID_LOG_LEVELS.contains(logLevel)) {
                                void mkString_sep;
                                String string3;
                                IterableOnceOps iterableOnceOps = (IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(LogLevelConfig.VALID_LOG_LEVELS).asScala();
                                String string4 = ", ";
                                if (iterableOnceOps == null) {
                                    throw null;
                                }
                                IterableOnceOps mkString_this = iterableOnceOps;
                                String string5 = string3 = mkString_this.mkString("", (String)mkString_sep, "");
                                Object var6_5 = null;
                                string4 = null;
                                string3 = null;
                                String validLevelsStr = string5;
                                throw new ConfigException(new StringBuilder(0).append(new StringBuilder(69).append("Cannot set the log level of ").append(loggerName).append(" to ").append(logLevel).append(" as it is not a supported log level. ").toString()).append(new StringBuilder(21).append("Valid log levels are ").append(validLevelsStr).toString()).toString());
                            }
                            break block9;
                        }
                        if (!AlterConfigOp.OpType.DELETE.equals(opType)) break block10;
                        AdminManager.validateLoggerNameExists$1(loggerName);
                        string2 = loggerName;
                        string = Log4jController$.MODULE$.ROOT_LOGGER();
                        if (string2 != null) break block11;
                        if (string != null) {
                            return;
                        }
                        break block12;
                    }
                    if (!string2.equals(string)) break block9;
                }
                throw new InvalidRequestException(new StringBuilder(52).append("Removing the log level of the ").append(Log4jController$.MODULE$.ROOT_LOGGER()).append(" logger is not allowed").toString());
            }
            if (AlterConfigOp.OpType.APPEND.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.APPEND).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
                throw new InvalidRequestException(new StringBuilder(43).append(AlterConfigOp.OpType.SUBTRACT).append(" operation is not allowed for the ").append(ConfigResource.Type.BROKER_LOGGER).append(" resource").toString());
            }
            throw new MatchError((Object)opType);
        }
    }

    private static final boolean listType$1(String configName, Map configKeys) {
        ConfigDef.ConfigKey configKey = (ConfigDef.ConfigKey)configKeys.apply((Object)configName);
        if (configKey == null) {
            throw new InvalidConfigurationException(new StringBuilder(27).append("Unknown topic config name: ").append(configName).toString());
        }
        ConfigDef.Type type = configKey.type;
        ConfigDef.Type type2 = ConfigDef.Type.LIST;
        return !(type != null ? !type.equals(type2) : type2 != null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Object $anonfun$prepareIncrementalConfigs$1(Properties configProps$2, Map configKeys$1, AlterConfigOp alterConfigOp) {
        Object object;
        AlterConfigOp.OpType opType = alterConfigOp.opType();
        if (AlterConfigOp.OpType.SET.equals(opType)) {
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), alterConfigOp.configEntry().value());
        } else if (AlterConfigOp.OpType.DELETE.equals(opType)) {
            object = configProps$2.remove(alterConfigOp.configEntry().name());
        } else if (AlterConfigOp.OpType.APPEND.equals(opType)) {
            void mkString_end;
            void mkString_sep;
            List list;
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(51).append("Config value append is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])configProps$2.getProperty(alterConfigOp.configEntry().name()).split(","));
            if (ofRef2 == null) {
                throw null;
            }
            ArraySeq.ofRef toList_this = ofRef2;
            List list2 = list = IterableOnceOps.toList$((IterableOnceOps)toList_this);
            Object var11_5 = null;
            list = null;
            List oldValueList = list2;
            ArraySeq.ofRef ofRef3 = Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(","));
            if (ofRef3 == null) {
                throw null;
            }
            List newValueList = IterableOnceOps.toList$((IterableOnceOps)ofRef3).$colon$colon$colon(oldValueList);
            String string = ",";
            if (newValueList == null) {
                throw null;
            }
            String string2 = "";
            String mkString_start = "";
            Object var16_11 = null;
            string2 = null;
            string = null;
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), IterableOnceOps.mkString$((IterableOnceOps)newValueList, (String)mkString_start, (String)mkString_sep, (String)mkString_end));
        } else if (AlterConfigOp.OpType.SUBTRACT.equals(opType)) {
            void mkString_end;
            void mkString_sep;
            void diff_that;
            List list;
            if (!AdminManager.listType$1(alterConfigOp.configEntry().name(), configKeys$1)) {
                throw new InvalidRequestException(new StringBuilder(53).append("Config value subtract is not allowed for config key: ").append(alterConfigOp.configEntry().name()).toString());
            }
            ArraySeq.ofRef ofRef4 = Predef$.MODULE$.wrapRefArray((Object[])configProps$2.getProperty(alterConfigOp.configEntry().name()).split(","));
            if (ofRef4 == null) {
                throw null;
            }
            List oldValueList = IterableOnceOps.toList$((IterableOnceOps)ofRef4);
            ArraySeq.ofRef ofRef5 = Predef$.MODULE$.wrapRefArray((Object[])alterConfigOp.configEntry().value().split(","));
            if (ofRef5 == null) {
                throw null;
            }
            ArraySeq.ofRef toList_this = ofRef5;
            List list3 = list = IterableOnceOps.toList$((IterableOnceOps)toList_this);
            Object var13_13 = null;
            list = null;
            List list4 = list3;
            if (oldValueList == null) {
                throw null;
            }
            list4 = null;
            List newValueList = (List)StrictOptimizedSeqOps.diff$((StrictOptimizedSeqOps)oldValueList, (Seq)diff_that);
            String string = ",";
            if (newValueList == null) {
                throw null;
            }
            String string3 = "";
            String mkString_start = "";
            Object var18_19 = null;
            string3 = null;
            string = null;
            object = configProps$2.setProperty(alterConfigOp.configEntry().name(), IterableOnceOps.mkString$((IterableOnceOps)newValueList, (String)mkString_start, (String)mkString_sep, (String)mkString_end));
        } else {
            throw new MatchError((Object)opType);
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$configType$2(ConfigDef.Type x$16) {
        return x$16 != null;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Buffer $anonfun$configSynonyms$1(boolean isSensitive$1, Buffer allSynonyms$1, String name$1, DescribeConfigsResponse.ConfigSource source$1, String value) {
        void $plus$eq_elem;
        String configValue = isSensitive$1 ? null : value;
        DescribeConfigsResponse.ConfigSynonym configSynonym = new DescribeConfigsResponse.ConfigSynonym(name$1, configValue, source$1);
        if (allSynonyms$1 == null) {
            throw null;
        }
        return (Buffer)allSynonyms$1.addOne((Object)$plus$eq_elem);
    }

    private static final void maybeAddSynonym$1(Map map, DescribeConfigsResponse.ConfigSource source, String name, boolean isSensitive$1, Buffer allSynonyms$1) {
        Option option = map.get((Object)name);
        if (option == null) {
            throw null;
        }
        Option map_this = option;
        if (map_this.isEmpty()) {
            return;
        }
        String string = (String)map_this.get();
        new Some((Object)AdminManager.$anonfun$configSynonyms$1(isSensitive$1, allSynonyms$1, name, source, string));
    }

    public static final /* synthetic */ boolean $anonfun$configSynonyms$6(String name$2, DescribeConfigsResponse.ConfigSynonym s) {
        String string = s.name();
        return string == null ? name$2 != null : !string.equals(name$2);
    }

    public static final /* synthetic */ List $anonfun$createTopicConfigEntry$2() {
        return List$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$createBrokerConfigEntry$1(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$17) {
        block3: {
            block2: {
                if (perBrokerConfig$1) break block2;
                DescribeConfigsResponse.ConfigSource configSource = x$17.source();
                DescribeConfigsResponse.ConfigSource configSource2 = DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG;
                if (configSource != null ? !configSource.equals(configSource2) : configSource2 != null) break block3;
            }
            return true;
        }
        return false;
    }

    public AdminManager(KafkaConfig config, Metrics metrics, MetadataCache metadataCache, KafkaZkClient zkClient) {
        this.config = config;
        this.metrics = metrics;
        this.metadataCache = metadataCache;
        this.zkClient = zkClient;
        this.logIdent_$eq(new StringBuilder(28).append("[Admin Manager on Broker ").append(config.brokerId()).append("]: ").toString());
        this.topicPurgatory = DelayedOperationPurgatory$.MODULE$.apply("topic", config.brokerId(), 1000, true, true);
        this.adminZkClient = new AdminZkClient(zkClient);
        this.createTopicPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.CreateTopicPolicyClassNameProp(), CreateTopicPolicy.class));
        this.alterConfigPolicy = Option$.MODULE$.apply(config.getConfiguredInstance(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), AlterConfigPolicy.class));
        this.defaultNumPartitions = config.numPartitions();
        this.defaultReplicationFactor = Integer.valueOf(config.defaultReplicationFactor()).shortValue();
    }

    public static final /* synthetic */ Object $anonfun$alterLogLevelConfigs$1$adapted(AlterConfigOp alterConfigOp) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$alterLogLevelConfigs$1(alterConfigOp));
    }

    public static final /* synthetic */ Object $anonfun$validateLogLevelConfigs$1$adapted(AlterConfigOp alterConfigOp) {
        AdminManager.$anonfun$validateLogLevelConfigs$1(alterConfigOp);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$2$adapted(Map eta$0$1$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$1$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$3$adapted(Map eta$0$2$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(eta$0$2$1, DescribeConfigsResponse.ConfigSource.DYNAMIC_DEFAULT_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$4$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticBrokerConfigs(), DescribeConfigsResponse.ConfigSource.STATIC_BROKER_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$configSynonyms$5$adapted(DynamicBrokerConfig dynamicConfig$1, boolean isSensitive$1, Buffer allSynonyms$1, String name) {
        AdminManager.maybeAddSynonym$1(dynamicConfig$1.staticDefaultConfigs(), DescribeConfigsResponse.ConfigSource.DEFAULT_CONFIG, name, isSensitive$1, allSynonyms$1);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$createBrokerConfigEntry$1$adapted(boolean perBrokerConfig$1, DescribeConfigsResponse.ConfigSynonym x$17) {
        return BoxesRunTime.boxToBoolean((boolean)AdminManager.$anonfun$createBrokerConfigEntry$1(perBrokerConfig$1, x$17));
    }

    public static final /* synthetic */ Object $anonfun$createTopics$13$adapted(Object x$3) {
        return BoxesRunTime.boxToByte((byte)AdminManager.$anonfun$createTopics$13(BoxesRunTime.unboxToInt((Object)x$3)));
    }

    public static final /* synthetic */ Object $anonfun$describeConfigs$4$adapted(String configName$1, Set x$11) {
        return BoxesRunTime.boxToBoolean((boolean)x$11.contains((Object)configName$1));
    }

    public static final /* synthetic */ Object $anonfun$shutdown$2$adapted(CreateTopicPolicy x$14) {
        x$14.close();
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$shutdown$4$adapted(AlterConfigPolicy x$15) {
        x$15.close();
        return BoxedUnit.UNIT;
    }
}

