/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\b\u0011\u0001UA\u0001\u0002\f\u0001\u0003\u0006\u0004%\t!\f\u0005\tq\u0001\u0011\t\u0011)A\u0005]!A\u0011\b\u0001BC\u0002\u0013\u0005!\b\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003<\u0011!A\u0005A!b\u0001\n\u0003I\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b\u0011\u0002&\t\u0011E\u0003!\u0011!Q\u0001\nICQa\u0019\u0001\u0005\u0002\u0011Dqa\u001b\u0001A\u0002\u0013\u0005A\u000eC\u0004q\u0001\u0001\u0007I\u0011A9\t\rQ\u0004\u0001\u0015)\u0003n\u0011\u0015)\b\u0001\"\u0001w\u0011\u00159\b\u0001\"\u0011y\u0011\u0015q\b\u0001\"\u0011\u0000\u0005A!\u0006N]8ui2,Gm\u00115b]:,GN\u0003\u0002\u0012%\u000511/\u001a:wKJT\u0011aE\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001aC\b\u0014\u0011\u0005]aR\"\u0001\r\u000b\u0005eQ\u0012\u0001\u00027b]\u001eT\u0011aG\u0001\u0005U\u00064\u0018-\u0003\u0002\u001e1\t1qJ\u00196fGR\u0004\"a\b\u0013\u000e\u0003\u0001R!!\t\u0012\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002$5\u0005!Q\u000f^5m\u0013\t)\u0003EA\u0004EK2\f\u00170\u001a3\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0005%\u0012\u0012!B;uS2\u001c\u0018BA\u0016)\u0005\u001daunZ4j]\u001e\fqA]3rk\u0016\u001cH/F\u0001/!\tySG\u0004\u00021g5\t\u0011G\u0003\u00023%\u00059a.\u001a;x_J\\\u0017B\u0001\u001b2\u00039\u0011V-];fgR\u001c\u0005.\u00198oK2L!AN\u001c\u0003\u000fI+\u0017/^3ti*\u0011A'M\u0001\te\u0016\fX/Z:uA\u0005!A/[7f+\u0005Y\u0004C\u0001\u001fF\u001b\u0005i$BA\u0015?\u0015\ty\u0004)\u0001\u0004d_6lwN\u001c\u0006\u0003'\u0005S!AQ\"\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005!\u0015aA8sO&\u0011a)\u0010\u0002\u0005)&lW-A\u0003uS6,\u0007%\u0001\buQJ|G\u000f\u001e7f)&lW-T:\u0016\u0003)\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u00131!\u00138u\u0003=!\bN]8ui2,G+[7f\u001bN\u0004\u0013!G2iC:tW\r\u001c+ie>$H\u000f\\5oO\u000e\u000bG\u000e\u001c2bG.\u0004BaS*VA&\u0011A\u000b\u0014\u0002\n\rVt7\r^5p]F\u0002\"A\u00160\u000f\u0005]\u001bdB\u0001-^\u001d\tIF,D\u0001[\u0015\tYF#\u0001\u0004=e>|GOP\u0005\u0002'%\u0011!GE\u0005\u0003?^\u0012\u0001BU3ta>t7/\u001a\t\u0003\u0017\u0006L!A\u0019'\u0003\tUs\u0017\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b\u0015<\u0007.\u001b6\u0011\u0005\u0019\u0004Q\"\u0001\t\t\u000b1B\u0001\u0019\u0001\u0018\t\u000beB\u0001\u0019A\u001e\t\u000b!C\u0001\u0019\u0001&\t\u000bEC\u0001\u0019\u0001*\u0002\u000f\u0015tG\rV5nKV\tQ\u000e\u0005\u0002L]&\u0011q\u000e\u0014\u0002\u0005\u0019>tw-A\u0006f]\u0012$\u0016.\\3`I\u0015\fHC\u00011s\u0011\u001d\u0019(\"!AA\u00025\f1\u0001\u001f\u00132\u0003!)g\u000e\u001a+j[\u0016\u0004\u0013\u0001\u00068pi&4\u0017\u0010\u00165s_R$H.\u001b8h\t>tW\rF\u0001a\u0003!9W\r\u001e#fY\u0006LHCA7z\u0011\u0015QX\u00021\u0001|\u0003\u0011)h.\u001b;\u0011\u0005}a\u0018BA?!\u0005!!\u0016.\\3V]&$\u0018!C2p[B\f'/\u001a+p)\rQ\u0015\u0011\u0001\u0005\u0007\u0003\u0007q\u0001\u0019\u0001\u0010\u0002\u0003\u0011\u0004")
public class ThrottledChannel
implements Delayed,
Logging {
    private final RequestChannel.Request request;
    private final Time time;
    private final int throttleTimeMs;
    private final Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback;
    private long endTime;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public RequestChannel.Request request() {
        return this.request;
    }

    public Time time() {
        return this.time;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public long endTime() {
        return this.endTime;
    }

    public void endTime_$eq(long x$1) {
        this.endTime = x$1;
    }

    public void notifyThrottlingDone() {
        this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("Channel throttled for: ").append(this.throttleTimeMs()).append(" ms").toString());
        this.channelThrottlingCallback.apply((Object)new RequestChannel.EndThrottlingResponse(this.request()));
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.endTime() - this.time().milliseconds(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        ThrottledChannel other = (ThrottledChannel)d;
        if (this.endTime() < other.endTime()) {
            return -1;
        }
        if (this.endTime() > other.endTime()) {
            return 1;
        }
        return 0;
    }

    public ThrottledChannel(RequestChannel.Request request, Time time, int throttleTimeMs, Function1<RequestChannel.Response, BoxedUnit> channelThrottlingCallback) {
        this.request = request;
        this.time = time;
        this.throttleTimeMs = throttleTimeMs;
        this.channelThrottlingCallback = channelThrottlingCallback;
        this.endTime = time.milliseconds() + (long)throttleTimeMs;
        channelThrottlingCallback.apply((Object)new RequestChannel.StartThrottlingResponse(request));
    }
}

