/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import kafka.tools.MessageInfo;
import kafka.tools.ReplicaVerificationTool$;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MutableRecordBatch;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ue\u0001B\u0012%\t%B\u0001B\u000e\u0001\u0003\u0002\u0003\u0006Ia\u000e\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AQ\u000b\u0001B\u0001B\u0003%Q\n\u0003\u0005W\u0001\t\u0005\t\u0015!\u0003S\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u001dy\u0006A1A\u0005\n\u0001Da\u0001\u001a\u0001!\u0002\u0013\t\u0007bB3\u0001\u0005\u0004%IA\u001a\u0005\u0007s\u0002\u0001\u000b\u0011B4\t\u000fi\u0004!\u0019!C\u0005w\"9\u0011\u0011\u0004\u0001!\u0002\u0013a\b\u0002CA\u000e\u0001\t\u0007I\u0011B>\t\u000f\u0005u\u0001\u0001)A\u0005y\"I\u0011q\u0004\u0001A\u0002\u0013%\u0011\u0011\u0005\u0005\n\u0003G\u0001\u0001\u0019!C\u0005\u0003KAq!!\r\u0001A\u0003&!\u000bC\u0005\u0002<\u0001\u0001\r\u0011\"\u0003\u0002\"!I\u0011Q\b\u0001A\u0002\u0013%\u0011q\b\u0005\b\u0003\u0007\u0002\u0001\u0015)\u0003S\u0011%\t)\u0005\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0002H\u0001\u0001\r\u0011\"\u0003\u0002J!9\u0011Q\n\u0001!B\u0013\u0011\u0006\"CA(\u0001\u0001\u0007I\u0011BA)\u0011%\t\u0019\u0006\u0001a\u0001\n\u0013\t)\u0006C\u0004\u0002Z\u0001\u0001\u000b\u0015\u0002\"\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^!9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0004bBA2\u0001\u0011\u0005\u0011Q\f\u0005\b\u0003K\u0002A\u0011AA1\u0011\u001d\t9\u0007\u0001C\u0005\u0003;Bq!!\u001b\u0001\t\u0013\ti\u0006C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011\u0011\u0011\u0001\u0005\u0002\u0005\r%!\u0004*fa2L7-\u0019\"vM\u001a,'O\u0003\u0002&M\u0005)Ao\\8mg*\tq%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cQj\u0011A\r\u0006\u0003g\u0019\nQ!\u001e;jYNL!!\u000e\u001a\u0003\u000f1{wmZ5oO\u0006\tS\r\u001f9fGR,GMU3qY&\u001c\u0017m\u001d)feR{\u0007/[2QCJ$\u0018\u000e^5p]B!\u0001h\u0010\"N\u001d\tIT\b\u0005\u0002;Y5\t1H\u0003\u0002=Q\u00051AH]8pizJ!A\u0010\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015IA\u0002NCBT!A\u0010\u0017\u0011\u0005\r[U\"\u0001#\u000b\u0005\u00153\u0015AB2p[6|gN\u0003\u0002(\u000f*\u0011\u0001*S\u0001\u0007CB\f7\r[3\u000b\u0003)\u000b1a\u001c:h\u0013\taEI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005-r\u0015BA(-\u0005\rIe\u000e^\u0001\u000fS:LG/[1m\u001f\u001a47/\u001a;t!\u0011AtH\u0011*\u0011\u0005-\u001a\u0016B\u0001+-\u0005\u0011auN\\4\u0002'\u0015D\b/Z2uK\u0012tU/\u001c$fi\u000eDWM]:\u0002\u001dI,\u0007o\u001c:u\u0013:$XM\u001d<bY\u00061A(\u001b8jiz\"R!W.];z\u0003\"A\u0017\u0001\u000e\u0003\u0011BQAN\u0003A\u0002]BQ\u0001U\u0003A\u0002ECQ!V\u0003A\u00025CQAV\u0003A\u0002I\u000baBZ3uG\"|eMZ:fi6\u000b\u0007/F\u0001b!\u0011\t$M\u0011*\n\u0005\r\u0014$\u0001\u0002)p_2\fqBZ3uG\"|eMZ:fi6\u000b\u0007\u000fI\u0001\re\u0016\u001cwN\u001d3t\u0007\u0006\u001c\u0007.Z\u000b\u0002OB!\u0011G\u0019\"i!\u0011\t$-T5\u0011\u0007)\u00048O\u0004\u0002l]6\tAN\u0003\u0002n\t\u0006A!/Z9vKN$8/\u0003\u0002pY\u0006ia)\u001a;dQJ+7\u000f]8og\u0016L!!\u001d:\u0003\u001bA\u000b'\u000f^5uS>tG)\u0019;b\u0015\tyG\u000e\u0005\u0002uo6\tQO\u0003\u0002w\t\u00061!/Z2pe\u0012L!\u0001_;\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u00035\u0011XmY8sIN\u001c\u0015m\u00195fA\u0005qa-\u001a;dQ\u0016\u0014()\u0019:sS\u0016\u0014X#\u0001?\u0011\u000bu\fi!!\u0005\u000e\u0003yT1a`A\u0001\u0003\u0019\tGo\\7jG*!\u00111AA\u0003\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u000f\tI!\u0001\u0003vi&d'BAA\u0006\u0003\u0011Q\u0017M^1\n\u0007\u0005=aPA\bBi>l\u0017n\u0019*fM\u0016\u0014XM\\2f!\u0011\t\u0019\"!\u0006\u000e\u0005\u0005\u0005\u0011\u0002BA\f\u0003\u0003\u0011abQ8v]R$un\u001e8MCR\u001c\u0007.A\bgKR\u001c\u0007.\u001a:CCJ\u0014\u0018.\u001a:!\u0003M1XM]5gS\u000e\fG/[8o\u0005\u0006\u0014(/[3s\u0003Q1XM]5gS\u000e\fG/[8o\u0005\u0006\u0014(/[3sA\u0005qA.Y:u%\u0016\u0004xN\u001d;US6,W#\u0001*\u0002%1\f7\u000f\u001e*fa>\u0014H\u000fV5nK~#S-\u001d\u000b\u0005\u0003O\ti\u0003E\u0002,\u0003SI1!a\u000b-\u0005\u0011)f.\u001b;\t\u0011\u0005=r\"!AA\u0002I\u000b1\u0001\u001f\u00132\u0003=a\u0017m\u001d;SKB|'\u000f\u001e+j[\u0016\u0004\u0003f\u0001\t\u00026A\u00191&a\u000e\n\u0007\u0005eBF\u0001\u0005w_2\fG/\u001b7f\u0003\u0019i\u0017\r\u001f'bO\u0006QQ.\u0019=MC\u001e|F%Z9\u0015\t\u0005\u001d\u0012\u0011\t\u0005\t\u0003_\u0011\u0012\u0011!a\u0001%\u00069Q.\u0019=MC\u001e\u0004\u0013\u0001E8gMN,GoV5uQ6\u000b\u0007\u0010T1h\u0003QygMZ:fi^KG\u000f['bq2\u000bwm\u0018\u0013fcR!\u0011qEA&\u0011!\ty#FA\u0001\u0002\u0004\u0011\u0016!E8gMN,GoV5uQ6\u000b\u0007\u0010T1hA\u00059R.\u0019=MC\u001e$v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\\\u000b\u0002\u0005\u0006YR.\u0019=MC\u001e$v\u000e]5d\u0003:$\u0007+\u0019:uSRLwN\\0%KF$B!a\n\u0002X!A\u0011q\u0006\r\u0002\u0002\u0003\u0007!)\u0001\rnCbd\u0015m\u001a+pa&\u001c\u0017I\u001c3QCJ$\u0018\u000e^5p]\u0002\nqc\u0019:fCR,g*Z<GKR\u001c\u0007.\u001a:CCJ\u0014\u0018.\u001a:\u0015\u0005\u0005\u001d\u0012!E4fi\u001a+Go\u00195fe\n\u000b'O]5feR\u0011\u0011\u0011C\u0001\u001dGJ,\u0017\r^3OK^4VM]5gS\u000e\fG/[8o\u0005\u0006\u0014(/[3s\u0003Y9W\r\u001e,fe&4\u0017nY1uS>t')\u0019:sS\u0016\u0014\u0018AC5oSRL\u0017\r\\5{K\u0006\t2/\u001a;J]&$\u0018.\u00197PM\u001a\u001cX\r^:\u0002\u001d\u0005$GMR3uG\",G\rR1uCRA\u0011qEA8\u0003g\n9\b\u0003\u0004\u0002r\u0001\u0002\rAQ\u0001\u0012i>\u0004\u0018nY!oIB\u000b'\u000f^5uS>t\u0007BBA;A\u0001\u0007Q*A\u0005sKBd\u0017nY1JI\"1\u0011\u0011\u0010\u0011A\u0002%\fQ\u0002]1si&$\u0018n\u001c8ECR\f\u0017!C4fi>3gm]3u)\r\u0011\u0016q\u0010\u0005\u0007\u0003c\n\u0003\u0019\u0001\"\u0002\u001dY,'/\u001b4z\u0007\",7m[*v[R!\u0011qEAC\u0011\u001d\t9I\ta\u0001\u0003\u0013\u000bq\u0001\u001d:j]Rdg\u000eE\u0004,\u0003\u0017\u000by)a\n\n\u0007\u00055EFA\u0005Gk:\u001cG/[8ocA\u0019\u0001(!%\n\u0007\u0005M\u0015I\u0001\u0004TiJLgn\u001a")
public class ReplicaBuffer
implements Logging {
    private final Map<TopicPartition, Object> expectedReplicasPerTopicPartition;
    private final Map<TopicPartition, Object> initialOffsets;
    private final int expectedNumFetchers;
    private final long reportInterval;
    private final Pool<TopicPartition, Object> fetchOffsetMap;
    private final Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache;
    private final AtomicReference<CountDownLatch> fetcherBarrier;
    private final AtomicReference<CountDownLatch> verificationBarrier;
    private volatile long lastReportTime;
    private long maxLag;
    private long offsetWithMaxLag;
    private TopicPartition maxLagTopicAndPartition;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Pool<TopicPartition, Object> fetchOffsetMap() {
        return this.fetchOffsetMap;
    }

    private Pool<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>> recordsCache() {
        return this.recordsCache;
    }

    private AtomicReference<CountDownLatch> fetcherBarrier() {
        return this.fetcherBarrier;
    }

    private AtomicReference<CountDownLatch> verificationBarrier() {
        return this.verificationBarrier;
    }

    private long lastReportTime() {
        return this.lastReportTime;
    }

    private void lastReportTime_$eq(long x$1) {
        this.lastReportTime = x$1;
    }

    private long maxLag() {
        return this.maxLag;
    }

    private void maxLag_$eq(long x$1) {
        this.maxLag = x$1;
    }

    private long offsetWithMaxLag() {
        return this.offsetWithMaxLag;
    }

    private void offsetWithMaxLag_$eq(long x$1) {
        this.offsetWithMaxLag = x$1;
    }

    private TopicPartition maxLagTopicAndPartition() {
        return this.maxLagTopicAndPartition;
    }

    private void maxLagTopicAndPartition_$eq(TopicPartition x$1) {
        this.maxLagTopicAndPartition = x$1;
    }

    public void createNewFetcherBarrier() {
        this.fetcherBarrier().set(new CountDownLatch(this.expectedNumFetchers));
    }

    public CountDownLatch getFetcherBarrier() {
        return this.fetcherBarrier().get();
    }

    public void createNewVerificationBarrier() {
        this.verificationBarrier().set(new CountDownLatch(1));
    }

    public CountDownLatch getVerificationBarrier() {
        return this.verificationBarrier().get();
    }

    private void initialize() {
        this.expectedReplicasPerTopicPartition.keySet().foreach((Function1 & Serializable)topicPartition -> this.recordsCache().put((TopicPartition)topicPartition, new Pool(None$.MODULE$)));
        this.setInitialOffsets();
    }

    private void setInitialOffsets() {
        this.initialOffsets.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable)x$7 -> BoxesRunTime.boxToLong((long)ReplicaBuffer.$anonfun$setInitialOffsets$2(this, x$7)));
    }

    public void addFetchedData(TopicPartition topicAndPartition, int replicaId, FetchResponse.PartitionData<MemoryRecords> partitionData) {
        this.recordsCache().get(topicAndPartition).put(replicaId, partitionData);
    }

    public long getOffset(TopicPartition topicAndPartition) {
        return BoxesRunTime.unboxToLong((Object)this.fetchOffsetMap().get(topicAndPartition));
    }

    public void verifyCheckSum(Function1<String, BoxedUnit> println) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Begin verification");
        this.maxLag_$eq(-1L);
        this.recordsCache().withFilter((Function1<Tuple2<TopicPartition, Pool<Object, FetchResponse.PartitionData<MemoryRecords>>>, Object>)(Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$2 != null))).foreach((Function1 & Serializable)x$10 -> {
            ReplicaBuffer.$anonfun$verifyCheckSum$3(this, println, x$10);
            return BoxedUnit.UNIT;
        });
        long currentTimeMs = Time.SYSTEM.milliseconds();
        if (currentTimeMs - this.lastReportTime() > this.reportInterval) {
            println.apply((Object)new StringBuilder(57).append(ReplicaVerificationTool$.MODULE$.dateFormat().format(new Date(currentTimeMs))).append(": max lag is ").append(this.maxLag()).append(" for partition ").append(this.maxLagTopicAndPartition()).append(" at offset ").append(this.offsetWithMaxLag()).append(" among ").append(this.recordsCache().size()).append(" partitions").toString());
            this.lastReportTime_$eq(currentTimeMs);
        }
    }

    public static final /* synthetic */ long $anonfun$setInitialOffsets$2(ReplicaBuffer $this, Tuple2 x$7) {
        if (x$7 == null) {
            throw new MatchError(null);
        }
        TopicPartition tp = (TopicPartition)x$7._1();
        long offset = x$7._2$mcJ$sp();
        long l = BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().put(tp, offset));
        return l;
    }

    public static final /* synthetic */ String $anonfun$verifyCheckSum$5(ReplicaBuffer $this, Pool fetchResponsePerReplica$1, TopicPartition topicPartition$1) {
        return new StringBuilder(46).append("fetched ").append(fetchResponsePerReplica$1.size()).append(" replicas for ").append(topicPartition$1).append(", but expected ").append($this.expectedReplicasPerTopicPartition.apply((Object)topicPartition$1)).append(" replicas").toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$verifyCheckSum$9(ReplicaBuffer $this, Pool fetchResponsePerReplica$1, BooleanRef isMessageInAllReplicas$1, ObjectRef messageInfoFromFirstReplicaOpt$1, Function1 println$1, TopicPartition topicPartition$1, Tuple2 x$9) {
        if (x$9 == null) throw new MatchError(null);
        int replicaId = x$9._1$mcI$sp();
        Iterator recordBatchIterator = (Iterator)x$9._2();
        try {
            if (recordBatchIterator.hasNext()) {
                MutableRecordBatch batch = (MutableRecordBatch)recordBatchIterator.next();
                if (batch.lastOffset() >= ((FetchResponse.PartitionData)fetchResponsePerReplica$1.get(Integer.valueOf((int)replicaId))).highWatermark) {
                    isMessageInAllReplicas$1.elem = false;
                    return;
                } else {
                    Option option = (Option)messageInfoFromFirstReplicaOpt$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        messageInfoFromFirstReplicaOpt$1.elem = new Some((Object)new MessageInfo(replicaId, batch.lastOffset(), batch.nextOffset(), batch.checksum()));
                        return;
                    } else {
                        if (!(option instanceof Some)) throw new MatchError((Object)option);
                        MessageInfo messageInfoFromFirstReplica = (MessageInfo)((Some)option).value();
                        if (messageInfoFromFirstReplica.offset() != batch.lastOffset()) {
                            println$1.apply((Object)new StringBuilder(65).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(": replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s offset ").append(messageInfoFromFirstReplica.offset()).append(" doesn't match replica ").append(replicaId).append("'s offset ").append(batch.lastOffset()).toString());
                            throw Exit$.MODULE$.exit(1, (Option<String>)None$.MODULE$);
                        }
                        if (messageInfoFromFirstReplica.checksum() == batch.checksum()) return;
                        BoxedUnit cfr_ignored_0 = (BoxedUnit)println$1.apply((Object)new StringBuilder(90).append(ReplicaVerificationTool$.MODULE$.getCurrentTimeString()).append(": partition ").append(topicPartition$1).append(" has unmatched checksum at offset ").append(batch.lastOffset()).append("; replica ").append(messageInfoFromFirstReplica.replicaId()).append("'s checksum ").append(messageInfoFromFirstReplica.checksum()).append("; replica ").append(replicaId).append("'s checksum ").append(batch.checksum()).toString());
                        return;
                    }
                }
            }
            isMessageInAllReplicas$1.elem = false;
            return;
        }
        catch (Throwable t) {
            throw new RuntimeException(StringOps$.MODULE$.format$extension("Error in processing replica %d in partition %s at offset %d.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{replicaId, topicPartition$1, $this.fetchOffsetMap().get(topicPartition$1)})), t);
        }
    }

    public static final /* synthetic */ void $anonfun$verifyCheckSum$3(ReplicaBuffer $this, Function1 println$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicPartition topicPartition = (TopicPartition)x$10._1();
            Pool fetchResponsePerReplica = (Pool)x$10._2();
            $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(10).append("Verifying ").append(topicPartition).toString());
            if (!(fetchResponsePerReplica.size() == BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition)))) {
                throw new AssertionError((Object)new StringBuilder(18).append("assertion failed: ").append((Object)ReplicaBuffer.$anonfun$verifyCheckSum$5($this, fetchResponsePerReplica, topicPartition)).toString());
            }
            Iterable recordBatchIteratorMap = (Iterable)fetchResponsePerReplica.map((Function1 & Serializable)x0$1 -> {
                void $minus$greater$extension_y;
                Tuple2 tuple2;
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int replicaId = x0$1._1$mcI$sp();
                FetchResponse.PartitionData fetchResponse = (FetchResponse.PartitionData)x0$1._2();
                Iterator iterator = ((MemoryRecords)fetchResponse.records).batches().iterator();
                Integer $minus$greater$extension_$this = replicaId;
                Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
                Object var4_4 = null;
                iterator = null;
                tuple2 = null;
                Tuple2 tuple23 = tuple22;
                return tuple23;
            });
            long maxHw = BoxesRunTime.unboxToLong((Object)((IterableOnceOps)fetchResponsePerReplica.values().map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.highWatermark))).max((Ordering)Ordering.Long$.MODULE$));
            boolean create_e = true;
            BooleanRef isMessageInAllReplicas = new BooleanRef(create_e);
            while (isMessageInAllReplicas.elem) {
                ObjectRef objectRef;
                None$ create_e2 = None$.MODULE$;
                ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e2);
                Object var13_11 = null;
                objectRef = null;
                ObjectRef messageInfoFromFirstReplicaOpt = objectRef2;
                recordBatchIteratorMap.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$3 != null))).foreach((Function1 & Serializable)x$9 -> {
                    ReplicaBuffer.$anonfun$verifyCheckSum$9($this, fetchResponsePerReplica, isMessageInAllReplicas, messageInfoFromFirstReplicaOpt, println$1, topicPartition, x$9);
                    return BoxedUnit.UNIT;
                });
                if (!isMessageInAllReplicas.elem) continue;
                long nextOffset = ((MessageInfo)((Option)messageInfoFromFirstReplicaOpt.elem).get()).nextOffset();
                $this.fetchOffsetMap().put(topicPartition, nextOffset);
                $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append(BoxesRunTime.unboxToInt((Object)$this.expectedReplicasPerTopicPartition.apply((Object)topicPartition))).append(" replicas match at offset ").append(nextOffset).append(" for ").append(topicPartition).toString());
            }
            if (maxHw - BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)) > $this.maxLag()) {
                $this.offsetWithMaxLag_$eq(BoxesRunTime.unboxToLong((Object)$this.fetchOffsetMap().get(topicPartition)));
                $this.maxLag_$eq(maxHw - $this.offsetWithMaxLag());
                $this.maxLagTopicAndPartition_$eq(topicPartition);
            }
            fetchResponsePerReplica.clear();
            return;
        }
        throw new MatchError(null);
    }

    public ReplicaBuffer(Map<TopicPartition, Object> expectedReplicasPerTopicPartition, Map<TopicPartition, Object> initialOffsets, int expectedNumFetchers, long reportInterval) {
        this.expectedReplicasPerTopicPartition = expectedReplicasPerTopicPartition;
        this.initialOffsets = initialOffsets;
        this.expectedNumFetchers = expectedNumFetchers;
        this.reportInterval = reportInterval;
        this.fetchOffsetMap = new Pool(None$.MODULE$);
        this.recordsCache = new Pool(None$.MODULE$);
        this.fetcherBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(expectedNumFetchers));
        this.verificationBarrier = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
        this.lastReportTime = Time.SYSTEM.milliseconds();
        this.maxLag = -1L;
        this.offsetWithMaxLag = -1L;
        this.maxLagTopicAndPartition = null;
        this.initialize();
    }
}

