/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.log.Defaults$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t4Aa\u0004\t\u0001+!)a\u0005\u0001C\u0001O!9\u0011\u0006\u0001a\u0001\n\u0003Q\u0003bB\u001d\u0001\u0001\u0004%\tA\u000f\u0005\u0007\u0003\u0002\u0001\u000b\u0015B\u0016\t\u000b\t\u0003A\u0011I\"\t\u000b5\u0003A\u0011A\"\t\u000bI\u0003A\u0011A\"\t\u000bQ\u0003A\u0011A\"\t\u000bY\u0003A\u0011A\"\t\u000ba\u0003A\u0011A\"\t\u000bi\u0003A\u0011A\"\t\u000bq\u0003A\u0011A\"\t\u000by\u0003A\u0011A\"\t\u000b\u0001\u0004A\u0011A\"\u0003#\u0005#W.\u001b8[W\u000ec\u0017.\u001a8u)\u0016\u001cHO\u0003\u0002\u0012%\u0005)\u0011\rZ7j]*\t1#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u00011BD\t\t\u0003/ii\u0011\u0001\u0007\u0006\u00033I\t!A_6\n\u0005mA\"\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001eA5\taD\u0003\u0002 %\u0005)Q\u000f^5mg&\u0011\u0011E\b\u0002\b\u0019><w-\u001b8h!\t\u0019C%D\u0001\u0011\u0013\t)\u0003CA\u0007SC\u000e\\\u0017i^1sKR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\t\u0001\u0002\u000fM,'O^3sgV\t1\u0006E\u0002-cMj\u0011!\f\u0006\u0003]=\n!bY8mY\u0016\u001cG/[8o\u0015\u0005\u0001\u0014!B:dC2\f\u0017B\u0001\u001a.\u0005\r\u0019V-\u001d\t\u0003i]j\u0011!\u000e\u0006\u0003mI\taa]3sm\u0016\u0014\u0018B\u0001\u001d6\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u0003w}\u0002\"\u0001P\u001f\u000e\u0003=J!AP\u0018\u0003\tUs\u0017\u000e\u001e\u0005\b\u0001\u000e\t\t\u00111\u0001,\u0003\rAH%M\u0001\tg\u0016\u0014h/\u001a:tA\u0005AA/Z1s\t><h\u000eF\u0001<Q\t)Q\t\u0005\u0002G\u00176\tqI\u0003\u0002I\u0013\u0006)!.\u001e8ji*\t!*A\u0002pe\u001eL!\u0001T$\u0003\u000b\u00053G/\u001a:\u00027Q,7\u000f^'b]V\fGNU3qY&\u001c\u0017-Q:tS\u001etW.\u001a8uQ\t1q\n\u0005\u0002G!&\u0011\u0011k\u0012\u0002\u0005)\u0016\u001cH/A\u000buKN$Hk\u001c9jG\u000e\u0013X-\u0019;j_:LeNW&)\u0005\u001dy\u0015A\b;fgR$v\u000e]5d\u0007J,\u0017\r^5p]^KG\u000f[\"pY2L7/[8oQ\tAq*A\u0011uKN$Xj\\2lK\u0012\u001cuN\\2veJ,g\u000e\u001e+pa&\u001c7I]3bi&|g\u000e\u000b\u0002\n\u001f\u0006YB/Z:u\u0007>t7-\u001e:sK:$Hk\u001c9jG\u000e\u0013X-\u0019;j_:D#AC(\u0002+Q,7\u000f\u001e+pa&\u001c7i\u001c8gS\u001e\u001c\u0005.\u00198hK\"\u00121bT\u0001$g\"|W\u000f\u001c3Qe>\u0004\u0018mZ1uK\u0012Kh.Y7jG\n\u0013xn[3s\u0007>tg-[4tQ\taq*A\u000euKN$(i\\8ugR\u0014\u0018\r]\"mS\u0016tG/\u00133D_:4\u0017n\u001a\u0015\u0003\u001b=\u000ba\u0003^3ti\u001e+GO\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u001d\u0015\u0003\u001d=\u0003")
public class AdminZkClientTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testManualReplicaAssignment() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        Object object;
        void $minus$greater$extension_y2;
        void apply_elems3;
        Object object2;
        List brokers = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}));
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)brokers);
        Properties topicConfig = new Properties();
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object[] objectArray = new Tuple2[1];
            SeqOps $minus$greater$extension_y = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 0}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            Object[] objectArray = new Tuple2[2];
            SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0}));
            Integer $minus$greater$extension_$this2 = 1;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 67));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            Object[] objectArray = new Tuple2[2];
            SeqOps $minus$greater$extension_y2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = 1;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 2;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            Object[] objectArray = new Tuple2[3];
            SeqOps $minus$greater$extension_y3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = 0;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 0;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this3 = 3;
            Object var6_7 = null;
            seqOps2 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void $minus$greater$extension_y;
            void $minus$greater$extension_y2;
            void $minus$greater$extension_y3;
            Object[] objectArray = new Tuple2[4];
            SeqOps $minus$greater$extension_y4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this = -1;
            Object var2_3 = null;
            Object var3_2 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y4);
            SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this2 = 1;
            Object var4_5 = null;
            seqOps = null;
            objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y3);
            SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this3 = 2;
            Object var6_7 = null;
            seqOps2 = null;
            objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y2);
            SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2}));
            Integer $minus$greater$extension_$this4 = 4;
            Object var8_9 = null;
            seqOps3 = null;
            objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y);
            this.adminZkClient().createTopicWithAssignment("test", topicConfig, (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        }, ClassTag$.MODULE$.apply(InvalidReplicaAssignmentException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        Object[] objectArray = new Tuple2[2];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        List$ apply_this = List$.MODULE$;
        Object object3 = object2 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems3);
        Object var9_4 = null;
        arraySeq = null;
        object2 = null;
        Object object4 = object3;
        Integer $minus$greater$extension_$this = 0;
        Object var5_7 = null;
        object4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        List$ apply_this2 = List$.MODULE$;
        Object object5 = object = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems2);
        Object var12_9 = null;
        arraySeq2 = null;
        object = null;
        Object object6 = object5;
        Integer $minus$greater$extension_$this2 = 1;
        Object var7_12 = null;
        object6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        Map assignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        this.adminZkClient().createTopicWithAssignment("test", topicConfig, assignment);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"test"});
        if (set$ == null) {
            throw null;
        }
        arraySeq3 = null;
        Map found = this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertEquals((Object)assignment.mapValues((Function1 & Serializable)x$1 -> ReplicaAssignment$.MODULE$.apply((Seq)x$1, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Object)found.apply((Object)"test"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicCreationInZK() {
        void $minus$greater$extension_y;
        Integer n;
        void $minus$greater$extension_y2;
        Integer n2;
        void $minus$greater$extension_y3;
        Integer n3;
        void $minus$greater$extension_y4;
        Integer n4;
        void $minus$greater$extension_y5;
        Integer n5;
        void $minus$greater$extension_y6;
        Integer n6;
        void $minus$greater$extension_y7;
        Integer n7;
        void $minus$greater$extension_y8;
        Integer n8;
        void $minus$greater$extension_y9;
        Integer n9;
        void $minus$greater$extension_y10;
        Integer n10;
        void $minus$greater$extension_y11;
        Integer n11;
        void $minus$greater$extension_y12;
        Integer n12;
        void $minus$greater$extension_y13;
        void apply_elems;
        Object object;
        void $minus$greater$extension_y14;
        void apply_elems2;
        Object object2;
        void $minus$greater$extension_y15;
        void apply_elems3;
        Object object3;
        void $minus$greater$extension_y16;
        void apply_elems4;
        Object object4;
        void $minus$greater$extension_y17;
        void apply_elems5;
        Object object5;
        void $minus$greater$extension_y18;
        void apply_elems6;
        Object object6;
        void $minus$greater$extension_y19;
        void apply_elems7;
        Object object7;
        void $minus$greater$extension_y20;
        void apply_elems8;
        Object object8;
        void $minus$greater$extension_y21;
        void apply_elems9;
        Object object9;
        void $minus$greater$extension_y22;
        void apply_elems10;
        Object object10;
        void $minus$greater$extension_y23;
        void apply_elems11;
        Object object11;
        void $minus$greater$extension_y24;
        void apply_elems12;
        Object object12;
        Object[] objectArray = new Tuple2[12];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2});
        List$ apply_this = List$.MODULE$;
        Object object13 = object12 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems12);
        Object var55_2 = null;
        arraySeq = null;
        object12 = null;
        Object object14 = object13;
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var6_5 = null;
        object14 = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y24);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        List$ apply_this2 = List$.MODULE$;
        Object object15 = object11 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems11);
        Object var58_7 = null;
        arraySeq2 = null;
        object11 = null;
        Object object16 = object15;
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var8_10 = null;
        object16 = null;
        objectArray[1] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y23);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3, 4});
        List$ apply_this3 = List$.MODULE$;
        Object object17 = object10 = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems10);
        Object var61_12 = null;
        arraySeq3 = null;
        object10 = null;
        Object object18 = object17;
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var10_15 = null;
        object18 = null;
        objectArray[2] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y22);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 4, 0});
        List$ apply_this4 = List$.MODULE$;
        Object object19 = object9 = IterableFactory.apply$((IterableFactory)apply_this4, (scala.collection.immutable.Seq)apply_elems9);
        Object var64_17 = null;
        arraySeq4 = null;
        object9 = null;
        Object object20 = object19;
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var12_20 = null;
        object20 = null;
        objectArray[3] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y21);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 0, 1});
        List$ apply_this5 = List$.MODULE$;
        Object object21 = object8 = IterableFactory.apply$((IterableFactory)apply_this5, (scala.collection.immutable.Seq)apply_elems8);
        Object var67_22 = null;
        arraySeq5 = null;
        object8 = null;
        Object object22 = object21;
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)4);
        Object var14_25 = null;
        object22 = null;
        objectArray[4] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y20);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 2, 3});
        List$ apply_this6 = List$.MODULE$;
        Object object23 = object7 = IterableFactory.apply$((IterableFactory)apply_this6, (scala.collection.immutable.Seq)apply_elems7);
        Object var70_27 = null;
        arraySeq6 = null;
        object7 = null;
        Object object24 = object23;
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)5);
        Object var16_30 = null;
        object24 = null;
        objectArray[5] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y19);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4});
        List$ apply_this7 = List$.MODULE$;
        Object object25 = object6 = IterableFactory.apply$((IterableFactory)apply_this7, (scala.collection.immutable.Seq)apply_elems6);
        Object var73_32 = null;
        arraySeq7 = null;
        object6 = null;
        Object object26 = object25;
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)6);
        Object var18_35 = null;
        object26 = null;
        objectArray[6] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y18);
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 4, 0});
        List$ apply_this8 = List$.MODULE$;
        Object object27 = object5 = IterableFactory.apply$((IterableFactory)apply_this8, (scala.collection.immutable.Seq)apply_elems5);
        Object var76_37 = null;
        arraySeq8 = null;
        object5 = null;
        Object object28 = object27;
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)7);
        Object var20_40 = null;
        object28 = null;
        objectArray[7] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y17);
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 0, 1});
        List$ apply_this9 = List$.MODULE$;
        Object object29 = object4 = IterableFactory.apply$((IterableFactory)apply_this9, (scala.collection.immutable.Seq)apply_elems4);
        Object var79_42 = null;
        arraySeq9 = null;
        object4 = null;
        Object object30 = object29;
        Object $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc((Object)8);
        Object var22_45 = null;
        object30 = null;
        objectArray[8] = new Tuple2($minus$greater$extension_$this9, (Object)$minus$greater$extension_y16);
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 1, 2});
        List$ apply_this10 = List$.MODULE$;
        Object object31 = object3 = IterableFactory.apply$((IterableFactory)apply_this10, (scala.collection.immutable.Seq)apply_elems3);
        Object var82_47 = null;
        arraySeq10 = null;
        object3 = null;
        Object object32 = object31;
        Object $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc((Object)9);
        Object var24_50 = null;
        object32 = null;
        objectArray[9] = new Tuple2($minus$greater$extension_$this10, (Object)$minus$greater$extension_y15);
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3});
        List$ apply_this11 = List$.MODULE$;
        Object object33 = object2 = IterableFactory.apply$((IterableFactory)apply_this11, (scala.collection.immutable.Seq)apply_elems2);
        Object var85_52 = null;
        arraySeq11 = null;
        object2 = null;
        Object object34 = object33;
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)10);
        Object var26_55 = null;
        object34 = null;
        objectArray[10] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y14);
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 3, 4});
        List$ apply_this12 = List$.MODULE$;
        Object object35 = object = IterableFactory.apply$((IterableFactory)apply_this12, (scala.collection.immutable.Seq)apply_elems);
        Object var88_57 = null;
        arraySeq12 = null;
        object = null;
        Object object36 = object35;
        Object $minus$greater$extension_$this12 = Predef$.MODULE$.ArrowAssoc((Object)11);
        Object var28_60 = null;
        object36 = null;
        objectArray[11] = new Tuple2($minus$greater$extension_$this12, (Object)$minus$greater$extension_y13);
        Map expectedReplicaAssignment = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Object[] objectArray2 = new Tuple2[12];
        Integer n13 = n12 = Integer.valueOf(0);
        n12 = null;
        Integer n14 = n13;
        Object $minus$greater$extension_$this13 = Predef$.MODULE$.ArrowAssoc((Object)0);
        Object var30_64 = null;
        n14 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this13, (Object)$minus$greater$extension_y12);
        Integer n15 = n11 = Integer.valueOf(1);
        n11 = null;
        Integer n16 = n15;
        Object $minus$greater$extension_$this14 = Predef$.MODULE$.ArrowAssoc((Object)1);
        Object var32_67 = null;
        n16 = null;
        objectArray2[1] = new Tuple2($minus$greater$extension_$this14, (Object)$minus$greater$extension_y11);
        Integer n17 = n10 = Integer.valueOf(2);
        n10 = null;
        Integer n18 = n17;
        Object $minus$greater$extension_$this15 = Predef$.MODULE$.ArrowAssoc((Object)2);
        Object var34_70 = null;
        n18 = null;
        objectArray2[2] = new Tuple2($minus$greater$extension_$this15, (Object)$minus$greater$extension_y10);
        Integer n19 = n9 = Integer.valueOf(3);
        n9 = null;
        Integer n20 = n19;
        Object $minus$greater$extension_$this16 = Predef$.MODULE$.ArrowAssoc((Object)3);
        Object var36_73 = null;
        n20 = null;
        objectArray2[3] = new Tuple2($minus$greater$extension_$this16, (Object)$minus$greater$extension_y9);
        Integer n21 = n8 = Integer.valueOf(4);
        n8 = null;
        Integer n22 = n21;
        Object $minus$greater$extension_$this17 = Predef$.MODULE$.ArrowAssoc((Object)4);
        Object var38_76 = null;
        n22 = null;
        objectArray2[4] = new Tuple2($minus$greater$extension_$this17, (Object)$minus$greater$extension_y8);
        Integer n23 = n7 = Integer.valueOf(0);
        n7 = null;
        Integer n24 = n23;
        Object $minus$greater$extension_$this18 = Predef$.MODULE$.ArrowAssoc((Object)5);
        Object var40_79 = null;
        n24 = null;
        objectArray2[5] = new Tuple2($minus$greater$extension_$this18, (Object)$minus$greater$extension_y7);
        Integer n25 = n6 = Integer.valueOf(1);
        n6 = null;
        Integer n26 = n25;
        Object $minus$greater$extension_$this19 = Predef$.MODULE$.ArrowAssoc((Object)6);
        Object var42_82 = null;
        n26 = null;
        objectArray2[6] = new Tuple2($minus$greater$extension_$this19, (Object)$minus$greater$extension_y6);
        Integer n27 = n5 = Integer.valueOf(2);
        n5 = null;
        Integer n28 = n27;
        Object $minus$greater$extension_$this20 = Predef$.MODULE$.ArrowAssoc((Object)7);
        Object var44_85 = null;
        n28 = null;
        objectArray2[7] = new Tuple2($minus$greater$extension_$this20, (Object)$minus$greater$extension_y5);
        Integer n29 = n4 = Integer.valueOf(3);
        n4 = null;
        Integer n30 = n29;
        Object $minus$greater$extension_$this21 = Predef$.MODULE$.ArrowAssoc((Object)8);
        Object var46_88 = null;
        n30 = null;
        objectArray2[8] = new Tuple2($minus$greater$extension_$this21, (Object)$minus$greater$extension_y4);
        Integer n31 = n3 = Integer.valueOf(4);
        n3 = null;
        Integer n32 = n31;
        Object $minus$greater$extension_$this22 = Predef$.MODULE$.ArrowAssoc((Object)9);
        Object var48_91 = null;
        n32 = null;
        objectArray2[9] = new Tuple2($minus$greater$extension_$this22, (Object)$minus$greater$extension_y3);
        Integer n33 = n2 = Integer.valueOf(1);
        n2 = null;
        Integer n34 = n33;
        Object $minus$greater$extension_$this23 = Predef$.MODULE$.ArrowAssoc((Object)10);
        Object var50_94 = null;
        n34 = null;
        objectArray2[10] = new Tuple2($minus$greater$extension_$this23, (Object)$minus$greater$extension_y2);
        Integer n35 = n = Integer.valueOf(1);
        n = null;
        Integer n36 = n35;
        Object $minus$greater$extension_$this24 = Predef$.MODULE$.ArrowAssoc((Object)11);
        Object var52_97 = null;
        n36 = null;
        objectArray2[11] = new Tuple2($minus$greater$extension_$this24, (Object)$minus$greater$extension_y);
        scala.collection.immutable.Map leaderForPartitionMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)scala.collection.immutable.Map$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        String topic = "test";
        Properties topicConfig = new Properties();
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment);
        TestUtils$.MODULE$.makeLeaderForPartition(this.zkClient(), topic, (scala.collection.immutable.Map<Object, Object>)leaderForPartitionMap, 1);
        scala.collection.immutable.Map actualReplicaMap = ((IterableOnceOps)leaderForPartitionMap.keys().map((Function1 & Serializable)p -> AdminZkClientTest.$anonfun$testTopicCreationInZK$1(this, topic, BoxesRunTime.unboxToInt((Object)p)))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Assert.assertEquals((long)expectedReplicaAssignment.size(), (long)actualReplicaMap.size());
        int n37 = 0;
        int until$extension_end = actualReplicaMap.size();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n37, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicCreationInZK$2(expectedReplicaAssignment, actualReplicaMap, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var91_104 = null;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.adminZkClient().createTopicWithAssignment(topic, topicConfig, expectedReplicaAssignment), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
    }

    @Test
    public void testTopicCreationWithCollision() {
        String topic = "test.topic";
        String collidingTopic = "test_topic";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = qual$1.createTopic$default$4();
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, 3, 1, x$4, x$5);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            AdminZkClient qual$2 = this.adminZkClient();
            Properties x$9 = qual$2.createTopic$default$4();
            RackAwareMode x$10 = qual$2.createTopic$default$5();
            qual$2.createTopic(collidingTopic, 3, 1, x$9, x$10);
        }, ClassTag$.MODULE$.apply(InvalidTopicException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMockedConcurrentTopicCreation() {
        void apply_elems;
        String topic = "test.topic";
        KafkaZkClient zkMock = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        EasyMock.expect((Object)zkMock.topicExists(topic)).andReturn((Object)false);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"some.topic", topic, "some.other.topic"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        EasyMock.expect((Object)zkMock.getAllTopicsInCluster()).andReturn(IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        EasyMock.replay((Object[])new Object[]{zkMock});
        AdminZkClient adminZkClient = new AdminZkClient(zkMock);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> adminZkClient.validateTopicCreate(topic, (Map)Map$.MODULE$.empty(), new Properties()), ClassTag$.MODULE$.apply(TopicExistsException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
    }

    @Test
    public void testConcurrentTopicCreation() {
        String topic = "test-concurrent-topic-creation";
        TestUtils$.MODULE$.createBrokersInZk(this.zkClient(), (Seq<Object>)((Seq)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 4}))));
        Properties props = new Properties();
        props.setProperty("min.insync.replicas", "2");
        TestUtils$.MODULE$.assertConcurrent("Concurrent topic creation failed", (Seq<Function0<Object>>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props), (JFunction0.mcV.sp & Serializable)() -> this.createTopic$1(topic, props)}))), (int)15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicConfigChange() {
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        int partitions = 3;
        String topic = "my-topic";
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var11_5 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer server = kafkaServer2;
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        int maxMessageSize = 1024;
        int retentionMs = 1000000;
        AdminZkClient qual$1 = this.adminZkClient();
        Properties x$4 = AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1");
        RackAwareMode x$5 = qual$1.createTopic$default$5();
        qual$1.createTopic(topic, partitions, 1, x$4, x$5);
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        Properties newConfig = AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*");
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*"));
        AdminZkClientTest.checkConfig$1(2 * maxMessageSize, 2 * retentionMs, "*", "*", true, partitions, topic, server);
        Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
        Assert.assertEquals((Object)newConfig, (Object)configInZk);
        this.adminZkClient().changeTopicConfig(topic, new Properties());
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, AdminZkClientTest.makeConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1"));
        AdminZkClientTest.checkConfig$1(maxMessageSize, retentionMs, "0:0,1:0,2:0", "0:1,1:1,2:1", true, partitions, topic, server);
        this.adminZkClient().changeTopicConfig(topic, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), (Object)""), new Tuple2((Object)LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), (Object)"")})));
        AdminZkClientTest.checkConfig$1(Defaults$.MODULE$.MaxMessageSize(), Defaults$.MODULE$.RetentionMs(), "", "", false, partitions, topic, server);
    }

    @Test
    public void shouldPropagateDynamicBrokerConfigs() {
        Seq brokerIds = (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        this.servers_$eq((Seq<KafkaServer>)((Seq)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).map((Function1 & Serializable)x$2 -> {
            Time time;
            Time time2 = time = Time.SYSTEM;
            time = null;
            Time createServer_time = time2;
            return TestUtils$.MODULE$.createServer((KafkaConfig)x$2, createServer_time, (Option<String>)None$.MODULE$);
        })));
        long limit = 1000000L;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)limit).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)limit).toString())})));
        this.checkConfig$2(limit);
        long newLimit = 2L * limit;
        this.adminZkClient().changeBrokerConfig(brokerIds, CoreUtils$.MODULE$.propsWith((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Object)((Object)newLimit).toString()), new Tuple2((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Object)((Object)newLimit).toString())})));
        this.checkConfig$2(newLimit);
        brokerIds.foreach((Function1)(JFunction1.mcVI.sp & Serializable)brokerId -> {
            Properties configInZk = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Broker(), ((Object)brokerId).toString());
            Assert.assertEquals((long)newLimit, (long)Integer.parseInt(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp())));
            Assert.assertEquals((long)newLimit, (long)Integer.parseInt(configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp())));
        });
        this.adminZkClient().changeBrokerConfig(brokerIds, new Properties());
        this.checkConfig$2(DynamicConfig.Broker$.MODULE$.DefaultReplicationThrottledRate());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBootstrapClientIdConfig() {
        void createServer_time;
        void createServer_config;
        KafkaServer kafkaServer;
        String clientId = "my-client";
        Properties props = new Properties();
        props.setProperty("producer_byte_rate", "1000");
        props.setProperty("consumer_byte_rate", "2000");
        this.zkClient().setOrCreateEntityConfigs(ConfigType$.MODULE$.Client(), clientId, props);
        Map configInZk = this.adminZkClient().fetchAllEntityConfigs(ConfigType$.MODULE$.Client());
        Assert.assertEquals((String)"Must have 1 overridden client config", (long)1L, (long)configInZk.size());
        Assert.assertEquals((Object)props, (Object)configInZk.apply((Object)clientId));
        Time time = Time.SYSTEM;
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1));
        TestUtils$ createServer_this = TestUtils$.MODULE$;
        KafkaServer kafkaServer2 = kafkaServer = createServer_this.createServer((KafkaConfig)createServer_config, (Time)createServer_time, (Option<String>)None$.MODULE$);
        Object var5_6 = null;
        kafkaConfig = null;
        time = null;
        kafkaServer = null;
        KafkaServer server = kafkaServer2;
        this.servers_$eq((Seq<KafkaServer>)((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaServer[]{server}))));
        Assert.assertEquals((Object)new Quota(1000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().produce().quota("ANONYMOUS", clientId));
        Assert.assertEquals((Object)new Quota(2000.0, true), (Object)server.dataPlaneRequestProcessor().quotas().fetch().quota("ANONYMOUS", clientId));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetBrokerMetadatas() {
        void apply_elems;
        Object var41_34;
        Object var38_25;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        Range.Inclusive inclusive;
        int n = 0;
        int to$extension_end = 5;
        Range.Inclusive inclusive2 = inclusive = new Range.Inclusive(n, to$extension_end, 1);
        inclusive = null;
        Range.Inclusive brokerList = inclusive2;
        Object[] objectArray = new Tuple2[5];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var20_6 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var22_8 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var24_10 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var26_12 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y2);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 5;
        Object var28_14 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y);
        Map rackInfo = (Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Set filterNot_pred = rackInfo.keySet();
        Object var30_16 = null;
        Seq<BrokerMetadata> brokerMetadatas = this.toBrokerMetadata((Map<Object, String>)rackInfo, (Seq<Object>)((Seq)StrictOptimizedIterableOps.filterNot$((StrictOptimizedIterableOps)brokerList, (Function1)filterNot_pred)));
        TestUtils$.MODULE$.createBrokersInZk(brokerMetadatas, this.zkClient());
        AdminZkClient qual$1 = this.adminZkClient();
        RackAwareMode.Disabled$ x$1 = RackAwareMode.Disabled$.MODULE$;
        Option x$2 = qual$1.getBrokerMetadatas$default$2();
        Seq processedMetadatas1 = qual$1.getBrokerMetadatas((RackAwareMode)x$1, x$2);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas1.map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id())));
        int n2 = SeqOps.size$((SeqOps)brokerList);
        ListBuffer fill_b = new ListBuffer();
        fill_b.sizeHint(n2);
        for (int fill_i = 0; fill_i < n2; ++fill_i) {
            None$ none$;
            None$ none$2 = none$ = None$.MODULE$;
            none$ = null;
            None$ fill_$plus$eq_elem = none$2;
            fill_b.addOne((Object)fill_$plus$eq_elem);
            var38_25 = null;
        }
        Object var36_23 = null;
        var38_25 = null;
        Assert.assertEquals((Object)((SeqOps)fill_b.result()), (Object)processedMetadatas1.map((Function1 & Serializable)x$4 -> x$4.rack()));
        AdminZkClient qual$2 = this.adminZkClient();
        RackAwareMode.Safe$ x$32 = RackAwareMode.Safe$.MODULE$;
        Option x$42 = qual$2.getBrokerMetadatas$default$2();
        Seq processedMetadatas2 = qual$2.getBrokerMetadatas((RackAwareMode)x$32, x$42);
        Assert.assertEquals((Object)brokerList, (Object)processedMetadatas2.map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        int n3 = SeqOps.size$((SeqOps)brokerList);
        ListBuffer fill_b2 = new ListBuffer();
        fill_b2.sizeHint(n3);
        for (int fill_i = 0; fill_i < n3; ++fill_i) {
            None$ none$;
            None$ none$3 = none$ = None$.MODULE$;
            none$ = null;
            None$ fill_$plus$eq_elem = none$3;
            fill_b2.addOne((Object)fill_$plus$eq_elem);
            var41_34 = null;
        }
        Object var39_32 = null;
        var41_34 = null;
        Assert.assertEquals((Object)((SeqOps)fill_b2.result()), (Object)processedMetadatas2.map((Function1 & Serializable)x$6 -> x$6.rack()));
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            AdminZkClient qual$3 = this.adminZkClient();
            RackAwareMode.Enforced$ x$5 = RackAwareMode.Enforced$.MODULE$;
            Option x$6 = qual$3.getBrokerMetadatas$default$2();
            return qual$3.getBrokerMetadatas((RackAwareMode)x$5, x$6);
        }, ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("AdminZkClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 354));
        List partialList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3, 5}));
        Seq processedMetadatas3 = this.adminZkClient().getBrokerMetadatas((RackAwareMode)RackAwareMode.Enforced$.MODULE$, (Option)new Some((Object)partialList));
        Assert.assertEquals((Object)partialList, (Object)processedMetadatas3.map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id())));
        Assert.assertEquals((Object)partialList.map((Function1)rackInfo), (Object)processedMetadatas3.flatMap((Function1 & Serializable)x$8 -> x$8.rack()));
        int numPartitions = 3;
        AdminZkClient qual$4 = this.adminZkClient();
        RackAwareMode.Safe$ x$10 = RackAwareMode.Safe$.MODULE$;
        Properties x$11 = qual$4.createTopic$default$4();
        qual$4.createTopic("foo", numPartitions, 2, x$11, (RackAwareMode)x$10);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"foo"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Map assignment = this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems));
        Assert.assertEquals((long)numPartitions, (long)assignment.size());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Tuple2 $anonfun$testTopicCreationInZK$1(AdminZkClientTest $this, String topic$1, int p) {
        void $minus$greater$extension_y;
        Seq seq = $this.zkClient().getReplicasForPartition(new TopicPartition(topic$1, p));
        Integer $minus$greater$extension_$this = p;
        return new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
    }

    public static final /* synthetic */ void $anonfun$testTopicCreationInZK$2(Map expectedReplicaAssignment$1, scala.collection.immutable.Map actualReplicaMap$1, int i) {
        Assert.assertEquals((Object)expectedReplicaAssignment$1.get((Object)i).get(), (Object)actualReplicaMap$1.apply((Object)i));
    }

    public static final /* synthetic */ void $anonfun$testConcurrentTopicCreation$1(Tuple2 x0$1) {
        if (x0$1 != null) {
            int partition = x0$1._1$mcI$sp();
            ReplicaAssignment partitionReplicaAssignment = (ReplicaAssignment)x0$1._2();
            Seq seq = partitionReplicaAssignment.replicas();
            if (seq == null) {
                throw null;
            }
            Assert.assertEquals((String)new StringBuilder(34).append("Unexpected replication factor for ").append(partition).toString(), (long)1L, (long)seq.length());
            return;
        }
        throw new MatchError(null);
    }

    /*
     * WARNING - void declaration
     */
    private final void createTopic$1(String topic$3, Properties props$1) {
        void var6_7;
        void apply_elems;
        try {
            AdminZkClient qual$1 = this.adminZkClient();
            RackAwareMode x$5 = qual$1.createTopic$default$5();
            qual$1.createTopic(topic$3, 3, 1, props$1, x$5);
        }
        catch (TopicExistsException topicExistsException) {}
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$3});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Tuple2 tuple2 = (Tuple2)this.zkClient().getPartitionAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).head();
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map partitionAssignment = (Map)tuple2._2();
        Assert.assertEquals((long)3L, (long)var6_7.size());
        var6_7.foreach((Function1 & Serializable)x0$1 -> {
            AdminZkClientTest.$anonfun$testConcurrentTopicCreation$1(x0$1);
            return BoxedUnit.UNIT;
        });
        Properties savedProps = this.zkClient().getEntityConfigs(ConfigType$.MODULE$.Topic(), topic$3);
        Assert.assertEquals((Object)props$1, (Object)savedProps);
    }

    private static final Properties makeConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers) {
        Properties props = new Properties();
        props.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), ((Object)messageSize).toString());
        props.setProperty(LogConfig$.MODULE$.RetentionMsProp(), ((Object)retentionMs).toString());
        props.setProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), throttledLeaders);
        props.setProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), throttledFollowers);
        return props;
    }

    private static final void checkList$1(java.util.List actual, String expected) {
        Assert.assertNotNull((Object)actual);
        String string = expected;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            Assert.assertTrue((boolean)actual.isEmpty());
            return;
        }
        Assert.assertEquals((Object)ArrayOps$.MODULE$.toIndexedSeq$extension((Object)expected.split(",")), (Object)JavaConverters$.MODULE$.asScalaBufferConverter(actual).asScala());
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$2(String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1, int part) {
        TopicPartition tp = new TopicPartition(topic$4, part);
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Option log = qual$1.getLog(tp, x$2);
        Assert.assertTrue((boolean)log.isDefined());
        Assert.assertEquals((Object)retentionMs$1, (Object)((Log)log.get()).config().retentionMs());
        Assert.assertEquals((Object)messageSize$1, (Object)((Log)log.get()).config().maxMessageSize());
        AdminZkClientTest.checkList$1(((Log)log.get()).config().LeaderReplicationThrottledReplicas(), throttledLeaders$1);
        AdminZkClientTest.checkList$1(((Log)log.get()).config().FollowerReplicationThrottledReplicas(), throttledFollowers$1);
        Assert.assertEquals((Object)quotaManagerIsThrottled$1, (Object)server$1.quotaManagers().leader().isThrottled(tp));
    }

    public static final /* synthetic */ void $anonfun$testTopicConfigChange$1(int partitions$1, String topic$4, KafkaServer server$1, long retentionMs$1, int messageSize$1, String throttledLeaders$1, String throttledFollowers$1, boolean quotaManagerIsThrottled$1) {
        int n = 0;
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, partitions$1, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AdminZkClientTest.$anonfun$testTopicConfigChange$2(topic$4, server$1, retentionMs$1, messageSize$1, throttledLeaders$1, throttledFollowers$1, quotaManagerIsThrottled$1, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkConfig$1(int messageSize, long retentionMs, String throttledLeaders, String throttledFollowers, boolean quotaManagerIsThrottled, int partitions$1, String topic$4, KafkaServer server$1) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$testTopicConfigChange$1(partitions$1, topic$4, server$1, retentionMs, messageSize, throttledLeaders, throttledFollowers, quotaManagerIsThrottled);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var15_13 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$4(long limit$1, KafkaServer server) {
        Assert.assertEquals((String)"Leader Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().leader().upperBound());
        Assert.assertEquals((String)"Follower Quota Manager was not updated", (long)limit$1, (long)server.quotaManagers().follower().upperBound());
    }

    public static final /* synthetic */ void $anonfun$shouldPropagateDynamicBrokerConfigs$3(AdminZkClientTest $this, long limit$1) {
        $this.servers().foreach((Function1 & Serializable)server -> {
            AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$4(limit$1, server);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConfig$2(long limit) {
        long l = 10000L;
        TestUtils$ retry_this = TestUtils$.MODULE$;
        long l2 = 1L;
        long retry_startTime = System.currentTimeMillis();
        while (true) {
            try {
                AdminZkClientTest.$anonfun$shouldPropagateDynamicBrokerConfigs$3(this, limit);
            }
            catch (AssertionError retry_e) {
                void retry_maxWaitMs;
                if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                    throw retry_e;
                }
                if (retry_this.logger().underlying().isInfoEnabled()) {
                    String string;
                    String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                    string = null;
                    String msgWithLogIdent_msg = string2;
                    Object var9_7 = null;
                    retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                }
                Thread.sleep(l2);
                l2 += Math.min(l2, 1000L);
                continue;
            }
            break;
        }
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$testGetBrokerMetadatas$5() {
        return None$.MODULE$;
    }
}

