/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import kafka.admin.ConfigCommand;
import kafka.admin.ConfigCommand$;
import kafka.admin.ConfigCommandTest;
import kafka.admin.ConfigCommandTest$CredentialChange$2$;
import kafka.api.ApiVersion$;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.ConfigEntityName$;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig$;
import kafka.utils.PasswordEncoder;
import kafka.zk.AdminZkClient;
import kafka.zk.BrokerInfo;
import kafka.zk.BrokerInfo$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConfigTest;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.MockAdminClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Sanitizer;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u001db\u0001B$I\u00015CQA\u0017\u0001\u0005\u0002mCQA\u0018\u0001\u0005\u0002}CQa\u001c\u0001\u0005\u0002}CQ!\u001d\u0001\u0005\u0002}CQa\u001d\u0001\u0005\nQDa!a\u0003\u0001\t\u0003y\u0006BBA\b\u0001\u0011\u0005q\f\u0003\u0004\u0002\u0014\u0001!\ta\u0018\u0005\u0007\u0003/\u0001A\u0011A0\t\r\u0005m\u0001\u0001\"\u0001`\u0011\u0019\ty\u0002\u0001C\u0001?\"1\u00111\u0005\u0001\u0005\u0002}Cq!a\n\u0001\t\u0003\tI\u0003\u0003\u0004\u0002:\u0001!\ta\u0018\u0005\u0007\u0003{\u0001A\u0011A0\t\r\u0005]\u0003\u0001\"\u0001`\u0011\u0019\tY\u0006\u0001C\u0001?\"1\u0011q\f\u0001\u0005\u0002}Ca!a\u0019\u0001\t\u0003y\u0006BBA4\u0001\u0011\u0005q\f\u0003\u0004\u0002l\u0001!\ta\u0018\u0005\u0007\u0003_\u0002A\u0011A0\t\r\u0005M\u0004\u0001\"\u0001`\u0011\u0019\t9\b\u0001C\u0001?\"1\u00111\u0010\u0001\u0005\u0002}Ca!a \u0001\t\u0003y\u0006BBAB\u0001\u0011\u0005q\f\u0003\u0004\u0002\b\u0002!\ta\u0018\u0005\u0007\u0003\u0017\u0003A\u0011A0\t\r\u0005=\u0005\u0001\"\u0001`\u0011\u0019\t\u0019\n\u0001C\u0001?\"1\u0011q\u0013\u0001\u0005\u0002}Ca!a'\u0001\t\u0003y\u0006BBAP\u0001\u0011\u0005q\f\u0003\u0004\u0002$\u0002!\ta\u0018\u0005\u0007\u0003\u007f\u0003A\u0011A0\t\r\u0005\r\u0007\u0001\"\u0001`\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Da!!:\u0001\t\u0003y\u0006bBAu\u0001\u0011\u0005\u00111\u001e\u0005\u0007\u0005\u0013\u0001A\u0011A0\t\r\t5\u0001\u0001\"\u0001`\u0011\u0019\u0011\t\u0002\u0001C\u0001?\"1!Q\u0003\u0001\u0005\u0002}CaA!\u0007\u0001\t\u0003y\u0006B\u0002B\u000f\u0001\u0011\u0005q\f\u0003\u0004\u0003\"\u0001!\ta\u0018\u0005\u0007\u0005K\u0001A\u0011A0\t\r\t%\u0002\u0001\"\u0001`\u0011\u0019\u0011i\u0003\u0001C\u0001?\"1!\u0011\u0007\u0001\u0005\u0002}CaA!\u000e\u0001\t\u0003y\u0006B\u0002B\u001d\u0001\u0011\u0005q\f\u0003\u0004\u0003>\u0001!\ta\u0018\u0005\u0007\u0005\u0003\u0002A\u0011A0\t\u000f\t\u0015\u0003\u0001\"\u0003\u0003H\u00191!1\u000b\u0001\u0001\u0005+B!B!\u0018:\u0005\u0003\u0005\u000b\u0011\u0002B0\u0011\u0019Q\u0016\b\"\u0001\u0003f!9!QN\u001d\u0005B\t=\u0004b\u0002BKs\u0011\u0005#q\u0013\u0005\b\u0005;KD\u0011\tBP\u0011\u001d\u00119+\u000fC!\u0005SCqA!-:\t\u0003\u0012\u0019L\u0002\u0004\u0003<\u0002\u0001!Q\u0018\u0005\u000b\u0003\u001b\f%\u0011!Q\u0001\n\u0005=\u0007B\u0002.B\t\u0003\u0011)\rC\u0004\u0003L\u0006#\tE!4\t\u000f\tU\u0018\t\"\u0011\u0003x\"91qC!\u0005B\re!!E\"p]\u001aLwmQ8n[\u0006tG\rV3ti*\u0011\u0011JS\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0002\u0017\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001O)B\u0011qJU\u0007\u0002!*\u0011\u0011KS\u0001\u0003u.L!a\u0015)\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t!\t)\u0006,D\u0001W\u0015\t9&*A\u0003vi&d7/\u0003\u0002Z-\n9Aj\\4hS:<\u0017A\u0002\u001fj]&$h\bF\u0001]!\ti\u0006!D\u0001I\u0003\u0015\u001a\bn\\;mI\u0016C\u0018\u000e^,ji\"tuN\u001c.fe>\u001cF/\u0019;vg>s\u0017I]4FeJ|'\u000fF\u0001a!\t\tG-D\u0001c\u0015\u0005\u0019\u0017!B:dC2\f\u0017BA3c\u0005\u0011)f.\u001b;)\u0005\t9\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015QWO\\5u\u0015\u0005a\u0017aA8sO&\u0011a.\u001b\u0002\u0005)\u0016\u001cH/A\u0016tQ>,H\u000eZ#ySR<\u0016\u000e\u001e5O_:TVM]8Ti\u0006$Xo](o5.\u001cu.\\7b]\u0012,%O]8sQ\t\u0019q-A\u0018tQ>,H\u000eZ#ySR<\u0016\u000e\u001e5O_:TVM]8Ti\u0006$Xo](o\u0005J|7.\u001a:D_6l\u0017M\u001c3FeJ|'\u000f\u000b\u0002\u0005O\u00069\u0012m]:feRtuN\u001c.fe>\u001cF/\u0019;vg\u0016C\u0018\u000e\u001e\u000b\u0003AVDQA^\u0003A\u0002]\fA!\u0019:hgB\u0019\u0011\r\u001f>\n\u0005e\u0014'!B!se\u0006L\bcA>\u0002\u00069\u0019A0!\u0001\u0011\u0005u\u0014W\"\u0001@\u000b\u0005}d\u0015A\u0002\u001fs_>$h(C\u0002\u0002\u0004\t\fa\u0001\u0015:fI\u00164\u0017\u0002BA\u0004\u0003\u0013\u0011aa\u0015;sS:<'bAA\u0002E\u000614\u000f[8vY\u0012\u0004\u0016M]:f\u0003J<W/\\3oiN4uN]\"mS\u0016tGo]#oi&$\u0018\u0010V=qKV\u001b\u0018N\\4[_>\\W-\u001a9fe\"\u0012aaZ\u00015g\"|W\u000f\u001c3QCJ\u001cX-\u0011:hk6,g\u000e^:G_J,6/\u001a:t\u000b:$\u0018\u000e^=UsB,Wk]5oOj{wn[3fa\u0016\u0014\bFA\u0004h\u0003U\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'\u000fV8qS\u000e\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005!9\u0017aJ:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s)>\u0004\u0018nY:F]RLG/\u001f+za\u0016D#!C4\u0002mMDw.\u001e7e!\u0006\u00148/Z!sOVlWM\u001c;t\r>\u0014(I]8lKJ\u001cXI\u001c;jif$\u0016\u0010]3Vg&twMW8pW\u0016,\u0007/\u001a:)\u0005)9\u0017\u0001K:i_VdG\rU1sg\u0016\f%oZ;nK:$8OR8s\u0005J|7.\u001a:t\u000b:$\u0018\u000e^=UsB,\u0007FA\u0006h\u00039\u001a\bn\\;mIB\u000b'o]3Be\u001e,X.\u001a8ug\u001a{'O\u0011:pW\u0016\u0014Hj\\4hKJ\u001cXI\u001c;jif$\u0016\u0010]3)\u000519\u0017!\u0005;fgR\f%oZ;nK:$\b+\u0019:tKR)\u0001-a\u000b\u00020!1\u0011QF\u0007A\u0002i\f!\"\u001a8uSRLH+\u001f9f\u0011\u001d\t\t$\u0004a\u0001\u0003g\t\u0001B_6D_:4\u0017n\u001a\t\u0004C\u0006U\u0012bAA\u001cE\n9!i\\8mK\u0006t\u0017!\u0007;fgR|\u0005\u000f^5p]\u0016sG/\u001b;z)f\u0004XMT1nKND#AD4\u0002aMDw.\u001e7e\r\u0006LG.\u00134V]J,7m\\4oSN,G-\u00128uSRLH+\u001f9f+NLgn\u001a.p_.,W\r]3sQ\u0019yq-!\u0011\u0002D\u0005AQ\r\u001f9fGR,Gm\t\u0002\u0002FA!\u0011qIA)\u001d\u0011\tI%!\u0014\u000f\u0007u\fY%C\u0001d\u0013\r\tyEY\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019&!\u0016\u00031%cG.Z4bY\u0006\u0013x-^7f]R,\u0005pY3qi&|gNC\u0002\u0002P\t\f!e\u001d5pk2$g)Y5m\u0013\u001a,fN]3d_\u001et\u0017n]3e\u000b:$\u0018\u000e^=UsB,\u0007F\u0002\th\u0003\u0003\n\u0019%\u0001\u001dtQ>,H\u000e\u001a$bS2LeM\u0011:pW\u0016\u0014XI\u001c;jif$\u0016\u0010]3Jg:{G/\u00118J]R,w-\u001a:Vg&twMW8pW\u0016,\u0007/\u001a:)\rE9\u0017\u0011IA\"\u0003)\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g\u0005J|7.\u001a:F]RLG/\u001f+za\u0016L5OT8u\u0003:Le\u000e^3hKJDcAE4\u0002B\u0005\r\u0013!P:i_VdGMR1jY&37\u000b[8si\n\u0013xn[3s\u000b:$\u0018\u000e^=UsB,\u0017j\u001d(pi\u0006s\u0017J\u001c;fO\u0016\u0014Xk]5oOj{wn[3fa\u0016\u0014\bFB\nh\u0003\u0003\n\u0019%A\u0018tQ>,H\u000e\u001a$bS2Lem\u00155peR\u0014%o\\6fe\u0016sG/\u001b;z)f\u0004X-S:O_R\fe.\u00138uK\u001e,'\u000f\u000b\u0004\u0015O\u0006\u0005\u00131I\u0001/g\"|W\u000f\u001c3GC&d\u0017JZ'jq\u0016$WI\u001c;jif$\u0016\u0010]3GY\u0006<7/V:j]\u001eTvn\\6fKB,'\u000f\u000b\u0004\u0016O\u0006\u0005\u00131I\u0001$g\"|W\u000f\u001c3BI\u0012\u001cE.[3oi\u000e{gNZ5h+NLgn\u001a.p_.,W\r]3sQ\t1r-\u0001\u0012tQ>,H\u000eZ!eIR{\u0007/[2D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0003/\u001d\fac\u001d5pk2$\u0017\t\u001c;feR{\u0007/[2D_:4\u0017n\u001a\u0015\u00031\u001d\fAd\u001d5pk2$G)Z:de&\u0014WmQ8oM&<7+\u001f8p]fl7\u000f\u000b\u0002\u001aO\u0006Q2\u000f[8vY\u0012\fE\r\u001a\"s_.,'/U;pi\u0006\u001cuN\u001c4jO\"\u0012!dZ\u0001\u001cg\"|W\u000f\u001c3BI\u0012\u0014%o\\6fe2{wmZ3s\u0007>tg-[4)\u0005m9\u0017a\u000f;fgRtun\u00159fG&4\u0017.\u001a3F]RLG/_(qi&|gnV5uQ\u0012+7o\u0019:jE\u0016\u0014%o\\6feNLeNW&Jg\u0006cGn\\<fI\"\u0012AdZ\u0001Ii\u0016\u001cHOT8Ta\u0016\u001c\u0017NZ5fI\u0016sG/\u001b;z\u001fB$\u0018n\u001c8XSRDG)Z:de&\u0014WM\u0011:pW\u0016\u00148/\u00138C_>$8\u000f\u001e:baN+'O^3s\u0013N\fE\u000e\\8xK\u0012D#!H4\u00027Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3BY2\u0014%o\\6fe\u000e{gNZ5hQ\tqr-\u0001\u000euKN$H)Z:de&\u0014W-\u00117m)>\u0004\u0018nY\"p]\u001aLw\r\u000b\u0002 O\u0006\u0011D/Z:u\t\u0016\u001c8M]5cK\u0006cGN\u0011:pW\u0016\u00148i\u001c8gS\u001e\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u0014(+Z9vSJ,G\r\u000b\u0004!O\u0006\u0005\u00131I\u0001<i\u0016\u001cH/\u00128uSRLH)\u001a4bk2$x\n\u001d;j_:<\u0016\u000e\u001e5EKN\u001c'/\u001b2f\u0005J|7.\u001a:M_\u001e<WM]%t\u001d>$\u0018\t\u001c7po\u0016$\u0007FB\u0011h\u0003\u0003\n\u0019%\u0001\u001duKN$XI\u001c;jif$UMZ1vYR|\u0005\u000f^5p]^KG\u000f[!mi\u0016\u0014(I]8lKJdunZ4fe&\u001bhj\u001c;BY2|w/\u001a3)\r\t:\u0017\u0011IA\"\u0003-\u001b\bn\\;mIJ\u000b\u0017n]3J]Z\fG.\u001b3D_:4\u0017nZ;sCRLwN\\#yG\u0016\u0004H/[8o/\",g.\u00113eS:<\u0017J\u001c<bY&$'I]8lKJdunZ4fe\u000e{gNZ5hQ\u0019\u0019s-!\u0011\u0002(\u000e\u0012\u0011\u0011\u0016\t\u0005\u0003W\u000bY,\u0004\u0002\u0002.*!\u0011qVAY\u0003\u0019)'O]8sg*!\u00111WA[\u0003\u0019\u0019w.\\7p]*\u00191*a.\u000b\u0007\u0005e6.\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003{\u000biKA\u000fJ]Z\fG.\u001b3D_:4\u0017nZ;sCRLwN\\#yG\u0016\u0004H/[8o\u0003\r\u001a\bn\\;mI\u0006#G\rR3gCVdGO\u0011:pW\u0016\u0014H)\u001f8b[&\u001c7i\u001c8gS\u001eD#\u0001J4\u00029MDw.\u001e7e\u0003\u0012$'I]8lKJ$\u0015P\\1nS\u000e\u001cuN\u001c4jO\"\u0012QeZ\u0001\u0018m\u0016\u0014\u0018NZ=BYR,'O\u0011:pW\u0016\u00148i\u001c8gS\u001e$r\u0001YAf\u0003/\fY\u000eC\u0004\u0002N\u001a\u0002\r!a4\u0002\t9|G-\u001a\t\u0005\u0003#\f\u0019.\u0004\u0002\u00022&!\u0011Q[AY\u0005\u0011qu\u000eZ3\t\r\u0005eg\u00051\u0001{\u00031\u0011Xm]8ve\u000e,g*Y7f\u0011\u001d\tiN\na\u0001\u0003?\fAB]3t_V\u00148-Z(qiN\u0004R!a\u0012\u0002bjLA!a9\u0002V\t!A*[:u\u0003-\u001a\bn\\;mI\u0012+7o\u0019:jE\u0016\u001cuN\u001c4jO\n\u0013xn[3s/&$\bn\\;u\u000b:$\u0018\u000e^=OC6,\u0007FA\u0014h\u0003u1XM]5gs\u0006cG/\u001a:Ce>\\WM\u001d'pO\u001e,'oQ8oM&<G#\u00031\u0002n\u0006=\u0018\u0011_A{\u0011\u001d\ti\r\u000ba\u0001\u0003\u001fDa!!7)\u0001\u0004Q\bBBAzQ\u0001\u0007!0\u0001\u0006f]RLG/\u001f(b[\u0016Dq!a>)\u0001\u0004\tI0A\u000beKN\u001c'/\u001b2f\u0007>tg-[4F]R\u0014\u0018.Z:\u0011\r\u0005\u001d\u0013\u0011]A~!\u0011\tiP!\u0002\u000e\u0005\u0005}(bA%\u0003\u0002)!!1AA[\u0003\u001d\u0019G.[3oiNLAAa\u0002\u0002\u0000\nY1i\u001c8gS\u001e,e\u000e\u001e:z\u0003=\u001a\bn\\;mIN+\b\u000f]8si\u000e{W.\\1TKB\f'/\u0019;fIZ\u000bG.^3t+NLgn\u001a.p_.,W\r]3sQ\tIs-\u0001 tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012,e\u000e^5us:\u000bW.Z+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007U\u001d\f\t%a\u0011\u0002aMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,G-\u00128uSRLh*Y7fQ\u0019Ys-!\u0011\u0002D\u0005YC/Z:u\tft\u0017-\\5d\u0005J|7.\u001a:D_:4\u0017nZ+qI\u0006$X-V:j]\u001eTvn\\&fKB,'\u000f\u000b\u0002-O\u0006Q4\u000f[8vY\u0012tu\u000e^+qI\u0006$XM\u0011:pW\u0016\u00148i\u001c8gS\u001eLe-T1mM>\u0014X.\u001a3D_:4\u0017nZ+tS:<'l\\8lK\u0016\u0004XM\u001d\u0015\u0007[\u001d\f\t%a\u0011\u0002YMDw.\u001e7e\u001d>$X\u000b\u001d3bi\u0016\u0014%o\\6fe\u000e{gNZ5h\u0013\u001al\u0015\r\u001c4pe6,GmQ8oM&<\u0007F\u0002\u0018h\u0003\u0003\n\u0019%A!tQ>,H\u000e\u001a(piV\u0003H-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ%g\u001b\u0006dgm\u001c:nK\u0012\u0014%/Y2lKR\u001cuN\u001c4jOV\u001b\u0018N\\4[_>\\W-\u001a9fe\"2qfZA!\u0003\u0007\n1g\u001d5pk2$gj\u001c;Va\u0012\fG/\u001a\"s_.,'oQ8oM&<\u0017JZ'bY\u001a|'/\\3e\u0005J\f7m[3u\u0007>tg-[4)\rA:\u0017\u0011IA\"\u0003y\u001a\bn\\;mI:{G/\u00169eCR,7i\u001c8gS\u001eLeMT8o\u000bbL7\u000f^5oO\u000e{gNZ5h\u0013N$U\r\\3uK\u0012,6/\u001b8h5>|7.\u001a9fe\"2\u0011gZA!\u0003O\u000b\u0011g\u001d5pk2$gj\u001c;Va\u0012\fG/Z\"p]\u001aLw-\u00134O_:,\u00050[:uS:<7i\u001c8gS\u001eL5\u000fR3mKR,G\r\u000b\u00043O\u0006\u0005\u0013qU\u0001\u0019g\"|W\u000f\u001c3EK2,G/\u001a\"s_.,'oQ8oM&<\u0007FA\u001ah\u0003Q!Xm\u001d;TGJ\fWn\u0011:fI\u0016tG/[1mg\"\u0012AgZ\u0001\u0016i\u0016\u001cH/U;pi\u0006\u001cuN\u001c4jO\u0016sG/\u001b;zQ\t)t-A\fuKN$Xk]3s\u00072LWM\u001c;Rk>$\u0018m\u00149ug\"\u0012agZ\u0001\u001ai\u0016\u001cH/U;pi\u0006$Um]2sS\n,WI\u001c;ji&,7\u000f\u000b\u00028O\u0006\u0011\"/Z4jgR,'O\u0011:pW\u0016\u0014\u0018J\u001c.l)\r\u0001'\u0011\n\u0005\b\u0005\u0017B\u0004\u0019\u0001B'\u0003\tIG\rE\u0002b\u0005\u001fJ1A!\u0015c\u0005\rIe\u000e\u001e\u0002\u0013\tVlW._!e[&t'l[\"mS\u0016tGoE\u0002:\u0005/\u00022a\u0014B-\u0013\r\u0011Y\u0006\u0015\u0002\u000e\u0003\u0012l\u0017N\u001c.l\u00072LWM\u001c;\u0002\u0011i\\7\t\\5f]R\u00042a\u0014B1\u0013\r\u0011\u0019\u0007\u0015\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0015\t\t\u001d$1\u000e\t\u0004\u0005SJT\"\u0001\u0001\t\u000f\tu3\b1\u0001\u0003`\u0005\u00112\r[1oO\u0016\u0014%o\\6fe\u000e{gNZ5h)\u0015\u0001'\u0011\u000fBA\u0011\u001d\u0011\u0019\b\u0010a\u0001\u0005k\n\u0011B\u0019:pW\u0016\u0014\u0018\nZ:\u0011\r\t]$Q\u0010B'\u001b\t\u0011IHC\u0002\u0003|\t\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yH!\u001f\u0003\u0007M+\u0017\u000fC\u0004\u0003\u0004r\u0002\rA!\"\u0002\u000f\r|gNZ5hgB!!q\u0011BI\u001b\t\u0011II\u0003\u0003\u0003\f\n5\u0015\u0001B;uS2T!Aa$\u0002\t)\fg/Y\u0005\u0005\u0005'\u0013II\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011CZ3uG\",e\u000e^5us\u000e{gNZ5h)\u0019\u0011)I!'\u0003\u001c\"1\u0011QF\u001fA\u0002iDa!a=>\u0001\u0004Q\u0018\u0001F2iC:<Wm\u00117jK:$\u0018\nZ\"p]\u001aLw\rF\u0003a\u0005C\u0013)\u000b\u0003\u0004\u0003$z\u0002\rA_\u0001\tG2LWM\u001c;JI\"9!1\u0011 A\u0002\t\u0015\u0015AH2iC:<W-V:fe>\u0013Xk]3s\u00072LWM\u001c;JI\u000e{gNZ5h)\u0015\u0001'1\u0016BX\u0011\u0019\u0011ik\u0010a\u0001u\u0006\u00192/\u00198ji&TX\rZ#oi&$\u0018PT1nK\"9!1Q A\u0002\t\u0015\u0015!E2iC:<W\rV8qS\u000e\u001cuN\u001c4jOR)\u0001M!.\u0003:\"1!q\u0017!A\u0002i\fQ\u0001^8qS\u000eDqAa!A\u0001\u0004\u0011)I\u0001\tEk6l\u00170\u00113nS:\u001cE.[3oiN\u0019\u0011Ia0\u0011\t\u0005u(\u0011Y\u0005\u0005\u0005\u0007\fyPA\bN_\u000e\\\u0017\tZ7j]\u000ec\u0017.\u001a8u)\u0011\u00119M!3\u0011\u0007\t%\u0014\tC\u0004\u0002N\u000e\u0003\r!a4\u0002\u001f\u0011,7o\u0019:jE\u0016\u001cuN\u001c4jON$bAa4\u0003V\n-\b\u0003BA\u007f\u0005#LAAa5\u0002\u0000\n)B)Z:de&\u0014WmQ8oM&<7OU3tk2$\bb\u0002Bl\t\u0002\u0007!\u0011\\\u0001\ne\u0016\u001cx.\u001e:dKN\u0004bAa\"\u0003\\\n}\u0017\u0002\u0002Bo\u0005\u0013\u0013!bQ8mY\u0016\u001cG/[8o!\u0011\u0011\tOa:\u000e\u0005\t\r(\u0002\u0002Bs\u0003c\u000baaY8oM&<\u0017\u0002\u0002Bu\u0005G\u0014abQ8oM&<'+Z:pkJ\u001cW\rC\u0004\u0003n\u0012\u0003\rAa<\u0002\u000f=\u0004H/[8ogB!\u0011Q By\u0013\u0011\u0011\u00190a@\u0003-\u0011+7o\u0019:jE\u0016\u001cuN\u001c4jON|\u0005\u000f^5p]N\fq#\u001b8de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:\u0015\r\te(q`B\b!\u0011\tiPa?\n\t\tu\u0018q \u0002\u0013\u00032$XM]\"p]\u001aLwm\u001d*fgVdG\u000fC\u0004\u0003\u0004\u0016\u0003\ra!\u0001\u0011\u0011\t\u001d51\u0001Bp\u0007\u000fIAa!\u0002\u0003\n\n\u0019Q*\u00199\u0011\r\t\u001d%1\\B\u0005!\u0011\tipa\u0003\n\t\r5\u0011q \u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\t\u000f\t5X\t1\u0001\u0004\u0012A!\u0011Q`B\n\u0013\u0011\u0019)\"a@\u0003'\u0005cG/\u001a:D_:4\u0017nZ:PaRLwN\\:\u0002\u0019\u0005dG/\u001a:D_:4\u0017nZ:\u0015\r\te81DB\u0013\u0011\u001d\u0011\u0019I\u0012a\u0001\u0007;\u0001\u0002Ba\"\u0004\u0004\t}7q\u0004\t\u0005\u0003{\u001c\t#\u0003\u0003\u0004$\u0005}(AB\"p]\u001aLw\rC\u0004\u0003n\u001a\u0003\ra!\u0005")
public class ConfigCommandTest
extends ZooKeeperTestHarness {
    @Test
    public void shouldExitWithNonZeroStatusOnArgError() {
        this.assertNonZeroStatusExit(new String[]{"--blah"});
    }

    @Test
    public void shouldExitWithNonZeroStatusOnZkCommandError() {
        this.assertNonZeroStatusExit(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "security.inter.broker.protocol=PLAINTEXT"});
    }

    @Test
    public void shouldExitWithNonZeroStatusOnBrokerCommandError() {
        this.assertNonZeroStatusExit(new String[]{"--bootstrap-server", "invalid host", "--entity-type", "brokers", "--entity-name", "1", "--describe"});
    }

    private void assertNonZeroStatusExit(String[] args) {
        ObjectRef objectRef;
        None$ create_e = None$.MODULE$;
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e);
        Object var5_2 = null;
        objectRef = null;
        ObjectRef exitStatus = objectRef2;
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(status, x$1) -> ConfigCommandTest.$anonfun$assertNonZeroStatusExit$1(exitStatus, BoxesRunTime.unboxToInt((Object)status), x$1);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_5 = null;
        try {
            try {
                ConfigCommand$.MODULE$.main(args);
            }
            catch (RuntimeException runtimeException) {}
        }
        finally {
            Exit.resetExitProcedure();
        }
        Assert.assertEquals((Object)new Some((Object)1), (Object)((Option)exitStatus.elem));
    }

    @Test
    public void shouldParseArgumentsForClientsEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForUsersEntityTypeUsingZookeeper() {
        this.testArgumentParse("clients", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityTypeUsingZookeeper() {
        this.testArgumentParse("topics", true);
    }

    @Test
    public void shouldParseArgumentsForTopicsEntityType() {
        this.testArgumentParse("topics", false);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityTypeUsingZookeeper() {
        this.testArgumentParse("brokers", true);
    }

    @Test
    public void shouldParseArgumentsForBrokersEntityType() {
        this.testArgumentParse("brokers", false);
    }

    @Test
    public void shouldParseArgumentsForBrokerLoggersEntityType() {
        this.testArgumentParse("broker-loggers", false);
    }

    public void testArgumentParse(String entityType, boolean zkConfig) {
        String shortFlag = new StringBuilder(2).append("--").append(StringOps$.MODULE$.dropRight$extension(entityType, 1)).toString();
        Tuple2 connectOpts = zkConfig ? new Tuple2((Object)"--zookeeper", (Object)this.zkConnect()) : new Tuple2((Object)"--bootstrap-server", (Object)"localhost:9092");
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--describe"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--describe"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--delete-config", "a,b,c"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--delete-config", "a,b,c"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=d", "--delete-config", "a"});
        createOpts.checkArgs();
        Properties addedProps = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)2L, (long)addedProps.size());
        Assert.assertEquals((Object)"b", (Object)addedProps.getProperty("a"));
        Assert.assertEquals((Object)"d", (Object)addedProps.getProperty("c"));
        Seq deletedProps = ConfigCommand$.MODULE$.parseConfigsToBeDeleted(createOpts);
        if (deletedProps == null) {
            throw null;
        }
        Assert.assertEquals((long)1L, (long)deletedProps.length());
        Assert.assertEquals((Object)"a", (Object)deletedProps.head());
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), "--entity-name", "1", "--entity-type", entityType, "--alter", "--add-config", "a=b,c=,d=e,f="});
        createOpts.checkArgs();
        createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{(String)connectOpts._1(), (String)connectOpts._2(), shortFlag, "1", "--alter", "--add-config", "a=b,c=,d=e,f="});
        createOpts.checkArgs();
        Properties addedProps2 = ConfigCommand$.MODULE$.parseConfigsToBeAdded(createOpts);
        Assert.assertEquals((long)4L, (long)addedProps2.size());
        Assert.assertEquals((Object)"b", (Object)addedProps2.getProperty("a"));
        Assert.assertEquals((Object)"e", (Object)addedProps2.getProperty("d"));
        Assert.assertTrue((boolean)addedProps2.getProperty("c").isEmpty());
        Assert.assertTrue((boolean)addedProps2.getProperty("f").isEmpty());
    }

    @Test
    public void testOptionEntityTypeNames() {
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "0", "--entity-type", "brokers"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-type", "clients", "--entity-name", "A", "--entity-default"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"", (List)new .colon.colon((Object)"B", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-default", "--entity-name", "B", "--entity-type", "users", "--entity-type", "clients"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--topic", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)new .colon.colon((Object)"0", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--broker", "0"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"B", (List)new .colon.colon((Object)"", (List)Nil$.MODULE$)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--client", "B", "--user-defaults"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Client(), (List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$)), (List)new .colon.colon((Object)"A", (List)Nil$.MODULE$), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--entity-name", "A"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Topic(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "topics"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.User(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users"}));
        this.testExpectedEntityTypeNames$1((List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)Nil$.MODULE$), (List)Nil$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "brokers"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityTypeUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfUnrecognisedEntityType() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "client", "--entity-type", "not-recognised", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "A", "--entity-type", "brokers", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnIntegerUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfShortBrokerEntityTypeIsNotAnInteger() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--broker", "A", "--alter", "--add-config", "a=b,c=d"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldFailIfMixedEntityTypeFlagsUsingZookeeper() {
        new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "A", "--entity-type", "users", "--client", "B", "--describe"}).checkArgs();
    }

    @Test
    public void shouldAddClientConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-client-id", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$1
        extends AdminZkClient {
            public void changeClientIdConfig(String clientId, Properties configChange) {
                Assert.assertEquals((Object)"my-client-id", (Object)clientId);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$1(null, this.zkClient()));
    }

    @Test
    public void shouldAddTopicConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=d"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$2
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d", (Object)configChange.get("c"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$2(null, this.zkClient()));
    }

    @Test
    public void shouldAlterTopicConfig() {
        BooleanRef booleanRef;
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--add-config", "delete.retention.ms=1000000,min.insync.replicas=2", "--delete-config", "unclean.leader.election.enable"});
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef alteredConfigs = booleanRef2;
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "1"), (List)new .colon.colon((Object)ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", "1"), (List)Nil$.MODULE$))).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(this, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final /* synthetic */ ConfigCommandTest $outer;
            private final String resourceName$1;
            private final DescribeConfigsResult describeResult$1;
            private final BooleanRef alteredConfigs$1;
            private final AlterConfigsResult alterResult$1;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$1);
                return this.describeResult$1;
            }

            /*
             * WARNING - void declaration
             */
            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                void apply_elems;
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.TOPIC, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("delete.retention.ms", "1000000"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("min.insync.replicas", "2"), AlterConfigOp.OpType.SET), new AlterConfigOp(ConfigCommandTest.kafka$admin$ConfigCommandTest$$newConfigEntry$1("unclean.leader.election.enable", ""), AlterConfigOp.OpType.DELETE)});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                Assert.assertEquals((Object)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Object)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toSet());
                this.alteredConfigs$1.elem = true;
                return this.alterResult$1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resourceName$1 = resourceName$1;
                this.describeResult$1 = describeResult$1;
                this.alteredConfigs$1 = alteredConfigs$1;
                this.alterResult$1 = alterResult$1;
                super(Collections.singletonList(node$1), node$1);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldDescribeConfigSynonyms() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--describe", "--all"});
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(Collections.emptyList())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resource, describeResult){
            private final ConfigResource resource$1;
            private final DescribeConfigsResult describeResult$2;

            /*
             * WARNING - void declaration
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                void apply_elems;
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{this.resource$1});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(resources).asScala()).toSet());
                return this.describeResult$2;
            }
            {
                this.resource$1 = resource$1;
                this.describeResult$2 = describeResult$2;
                super(Collections.singletonList(node$2), node$2);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldAddBrokerQuotaConfig() {
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10,follower.replication.throttled.rate=20"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$3
        extends AdminZkClient {
            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1})), brokerIds);
                Assert.assertEquals((Object)"10", (Object)configChange.get("leader.replication.throttled.rate"));
                Assert.assertEquals((Object)"20", (Object)configChange.get("follower.replication.throttled.rate"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, alterOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$3(null, this.zkClient()));
    }

    @Test
    public void shouldAddBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.log.LogCleaner", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.ReplicaManager", "INFO"), (List)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$))));
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInZKIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--zookeeper", (List)new .colon.colon((Object)this.zkConnect(), (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testNoSpecifiedEntityOptionWithDescribeBrokersInBootstrapServerIsAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigType$.MODULE$.Broker(), (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$)))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllBrokerConfig() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test
    public void testDescribeAllTopicConfig() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigType$.MODULE$.Topic(), "--entity-name", "foo", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDescribeAllBrokerConfigBootstrapServerRequired() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--zookeeper", this.zkConnect(), "--entity-type", ConfigType$.MODULE$.Broker(), "--entity-name", "1", "--describe", "--all"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithDescribeBrokerLoggerIsNotAllowed() {
        .colon.colon optsList = new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)ConfigCommand$.MODULE$.BrokerLoggerConfigType(), (List)new .colon.colon((Object)"--entity-default", (List)new .colon.colon((Object)"--describe", (List)Nil$.MODULE$))))));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEntityDefaultOptionWithAlterBrokerLoggerIsNotAllowed() {
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--entity-default", "--alter", "--add-config", "kafka.log.LogCleaner=DEBUG"}));
        new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class))).checkArgs();
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldRaiseInvalidConfigurationExceptionWhenAddingInvalidBrokerLoggerConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerLoggerConfig(node, "1", "1", (List<ConfigEntry>)new .colon.colon((Object)new ConfigEntry("kafka.server.KafkaApi", "INFO"), (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddDefaultBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "", (List<String>)new .colon.colon((Object)"--entity-default", (List)Nil$.MODULE$));
    }

    @Test
    public void shouldAddBrokerDynamicConfig() {
        Node node = new Node(1, "localhost", 9092);
        this.verifyAlterBrokerConfig(node, "1", (List<String>)new .colon.colon((Object)"--entity-name", (List)new .colon.colon((Object)"1", (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    public void verifyAlterBrokerConfig(Node node, String resourceName, List<String> resourceOpts) {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        List optsList = (List)new .colon.colon((Object)"--bootstrap-server", (List)new .colon.colon((Object)"localhost:9092", (List)new .colon.colon((Object)"--entity-type", (List)new .colon.colon((Object)"brokers", (List)new .colon.colon((Object)"--alter", (List)new .colon.colon((Object)"--add-config", (List)new .colon.colon((Object)"message.max.bytes=10", (List)Nil$.MODULE$))))))).concat(resourceOpts);
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        Object[] objectArray = new Tuple2[1];
        String string = "5";
        String $minus$greater$extension_$this = "num.io.threads";
        Object var14_7 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y3);
        scala.collection.mutable.Map brokerConfigs = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER, resourceName);
        java.util.List<ConfigEntry> configEntries = Collections.singletonList(new ConfigEntry("num.io.threads", "5"));
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config(configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, brokerConfigs, alterResult){
            private final String resourceName$2;
            private final DescribeConfigsResult describeResult$3;
            private final scala.collection.mutable.Map brokerConfigs$1;
            private final AlterConfigsResult alterResult$2;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertFalse((String)"Config synonyms requested unnecessarily", (boolean)options.includeSynonyms());
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$2, (Object)resource.name());
                return this.describeResult$3;
            }

            public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Config> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Config config = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(config.entries()).asScala()).foreach((Function1 & Serializable)e -> $this.brokerConfigs$1.put((Object)e.name(), (Object)e.value()));
                return this.alterResult$2;
            }
            {
                this.resourceName$2 = resourceName$2;
                this.describeResult$3 = describeResult$3;
                this.brokerConfigs$1 = brokerConfigs$1;
                this.alterResult$2 = alterResult$2;
                super(Collections.singletonList(node$3), node$3);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$alterConfigs$1(kafka.admin.ConfigCommandTest$$anon$3 org.apache.kafka.clients.admin.ConfigEntry )}, serializedLambda);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        String string2 = "10";
        String $minus$greater$extension_$this2 = "message.max.bytes";
        Object var16_17 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string3 = "5";
        String $minus$greater$extension_$this3 = "num.io.threads";
        Object var18_19 = null;
        string3 = null;
        objectArray2[1] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Object)brokerConfigs.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldDescribeConfigBrokerWithoutEntityName() {
        void apply_elems;
        ConfigCommand.ConfigCommandOptions describeOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", "brokers", "--describe"});
        String BrokerDefaultEntityName = "";
        ConfigResource resourceCustom = new ConfigResource(ConfigResource.Type.BROKER, "1");
        ConfigResource resourceDefault = new ConfigResource(ConfigResource.Type.BROKER, BrokerDefaultEntityName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        Config emptyConfig = new Config(Collections.emptyList());
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)resourceCustom, (Object)emptyConfig);
        objectArray[1] = new Tuple2((Object)resourceDefault, (Object)emptyConfig);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map resultMap = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)).asJava();
        future.complete((Object)resultMap);
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).times(2);
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceCustom, resourceDefault, describeResult){
            private final ConfigResource resourceCustom$1;
            private final ConfigResource resourceDefault$1;
            private final DescribeConfigsResult describeResult$4;

            /*
             * Unable to fully structure code
             */
            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertTrue((String)"Synonyms not requested", (boolean)options.includeSynonyms());
                resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER, (Object)resource.type());
                v0 = this.resourceCustom$1.name();
                var4_4 = resource.name();
                if (!(v0 == null ? var4_4 != null : v0.equals(var4_4) == false)) ** GOTO lbl-1000
                v1 = this.resourceDefault$1.name();
                var5_5 = resource.name();
                if (!(v1 != null ? v1.equals(var5_5) == false : var5_5 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = true;
                } else {
                    v2 = false;
                }
                Assert.assertTrue((boolean)v2);
                Assert.assertEquals((long)1L, (long)resources.size());
                return this.describeResult$4;
            }
            {
                this.resourceCustom$1 = resourceCustom$1;
                this.resourceDefault$1 = resourceDefault$1;
                this.describeResult$4 = describeResult$4;
                super(Collections.singletonList(node$4), node$4);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.describeConfig((Admin)mockAdminClient, describeOpts);
        EasyMock.verify((Object[])new Object[]{describeResult});
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    public void verifyAlterBrokerLoggerConfig(Node node, String resourceName, String entityName, List<ConfigEntry> describeConfigEntries) {
        BooleanRef booleanRef;
        List optsList = (List)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--entity-type", ConfigCommand$.MODULE$.BrokerLoggerConfigType(), "--alter", "--entity-name", entityName, "--add-config", "kafka.log.LogCleaner=DEBUG", "--delete-config", "kafka.server.ReplicaManager,kafka.server.KafkaApi"}));
        ConfigCommand.ConfigCommandOptions alterOpts = new ConfigCommand.ConfigCommandOptions((String[])optsList.toArray(ClassTag$.MODULE$.apply(String.class)));
        boolean create_e = false;
        BooleanRef booleanRef2 = booleanRef = new BooleanRef(create_e);
        booleanRef = null;
        BooleanRef alteredConfigs = booleanRef2;
        ConfigResource resource = new ConfigResource(ConfigResource.Type.BROKER_LOGGER, resourceName);
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(describeConfigEntries).asJava())));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        KafkaFutureImpl alterFuture = new KafkaFutureImpl();
        alterFuture.complete(null);
        AlterConfigsResult alterResult = (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        EasyMock.expect((Object)alterResult.all()).andReturn((Object)alterFuture);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult, alteredConfigs, alterResult){
            private final String resourceName$3;
            private final DescribeConfigsResult describeResult$5;
            private final BooleanRef alteredConfigs$2;
            private final AlterConfigsResult alterResult$3;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((Object)this.resourceName$3, (Object)resource.name());
                return this.describeResult$5;
            }

            public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)configs.size());
                Map.Entry<ConfigResource, Collection<AlterConfigOp>> entry = configs.entrySet().iterator().next();
                ConfigResource resource = entry.getKey();
                Collection<AlterConfigOp> alterConfigOps = entry.getValue();
                Assert.assertEquals((Object)ConfigResource.Type.BROKER_LOGGER, (Object)resource.type());
                Assert.assertEquals((long)3L, (long)alterConfigOps.size());
                Assert.assertEquals((Object)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "DEBUG"), AlterConfigOp.OpType.SET), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", ""), AlterConfigOp.OpType.DELETE), (List)new .colon.colon((Object)new AlterConfigOp(new ConfigEntry("kafka.server.KafkaApi", ""), AlterConfigOp.OpType.DELETE), (List)Nil$.MODULE$))), (Object)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(alterConfigOps).asScala()).toList());
                this.alteredConfigs$2.elem = true;
                return this.alterResult$3;
            }
            {
                this.resourceName$3 = resourceName$3;
                this.describeResult$5 = describeResult$5;
                this.alteredConfigs$2 = alteredConfigs$2;
                this.alterResult$3 = alterResult$3;
                super(Collections.singletonList(node$5), node$5);
            }
        };
        EasyMock.replay((Object[])new Object[]{alterResult, describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, alterOpts);
        Assert.assertTrue((boolean)alteredConfigs.elem);
        EasyMock.reset((Object[])new Object[]{alterResult, describeResult});
    }

    @Test
    public void shouldSupportCommaSeparatedValuesUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--add-config", "a=b,c=[d,e ,f],g=[h,i]"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$4
        extends AdminZkClient {
            public void changeTopicConfig(String topic, Properties configChange) {
                Assert.assertEquals((Object)"my-topic", (Object)topic);
                Assert.assertEquals((Object)"b", (Object)configChange.get("a"));
                Assert.assertEquals((Object)"d,e ,f", (Object)configChange.get("c"));
                Assert.assertEquals((Object)"h,i", (Object)configChange.get("g"));
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$4(null, this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityNameUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedEntityName() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1,2,3", "--entity-type", "brokers", "--alter", "--add-config", "leader.replication.throttled.rate=10"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDynamicBrokerConfigUpdateUsingZooKeeper() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void apply_elems3;
        void $minus$greater$extension_y7;
        void apply_elems4;
        void $minus$greater$extension_y8;
        void apply_elems5;
        void $minus$greater$extension_y9;
        void $minus$greater$extension_y10;
        void apply_elems6;
        void apply_elems7;
        void $minus$greater$extension_y11;
        void apply_elems8;
        void apply_elems9;
        void apply_elems10;
        void $minus$greater$extension_y12;
        void apply_elems11;
        void $minus$greater$extension_y13;
        void apply_elems12;
        void $minus$greater$extension_y14;
        void apply_elems13;
        void $minus$greater$extension_y15;
        String brokerId = "1";
        AdminZkClient adminZkClient = new AdminZkClient(this.zkClient());
        String[] alterOpts = new String[]{"--zookeeper", this.zkConnect(), "--entity-type", "brokers", "--alter"};
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        String string = "110000";
        String $minus$greater$extension_$this = "message.max.size";
        Object var12_5 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y15);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems13), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        String string2 = "120000";
        String $minus$greater$extension_$this2 = "message.max.size";
        Object var14_8 = null;
        string2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y14);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems12), (Option)None$.MODULE$, alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        String string3 = "130000";
        String $minus$greater$extension_$this3 = "message.max.size";
        Object var16_11 = null;
        string3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y13);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems11), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        String string4 = "140000";
        String $minus$greater$extension_$this4 = "message.max.size";
        Object var18_14 = null;
        string4 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y12);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems10), (Option)None$.MODULE$, alterOpts, adminZkClient);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"});
        if (set$ == null) {
            throw null;
        }
        arraySeq5 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems9), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"message.max.size"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems8), (Option)None$.MODULE$, alterOpts, adminZkClient);
        scala.collection.immutable.Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        String string5 = "/tmp/test.jks";
        String $minus$greater$extension_$this5 = "listener.name.external.ssl.keystore.location";
        Object var20_19 = null;
        string5 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y11);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$5, (scala.collection.immutable.Seq)apply_elems7), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "/tmp/test.jks";
            String $minus$greater$extension_$this = "ssl.keystore.location";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 772));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "/tmp/test.jks";
            String $minus$greater$extension_$this = "listener.name.external.ssl.keystore.location";
            Object var3_4 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 775));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"listener.name.external.ssl.keystore.location"});
        if (set$3 == null) {
            throw null;
        }
        arraySeq8 = null;
        this.deleteAndVerifyConfig$1((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems6), (Option)new Some((Object)brokerId), alterOpts, adminZkClient);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "secret";
            String $minus$greater$extension_$this = "listener.name.external.ssl.keystore.password";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 779));
        scala.collection.immutable.Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[2];
        String string6 = "secret";
        String $minus$greater$extension_$this6 = "listener.name.external.ssl.keystore.password";
        Object var22_23 = null;
        string6 = null;
        objectArray6[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y10);
        String string7 = "2";
        String $minus$greater$extension_$this7 = "log.cleaner.threads";
        Object var24_25 = null;
        string7 = null;
        objectArray6[1] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y9);
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq9 = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$6, (scala.collection.immutable.Seq)apply_elems5);
        scala.collection.immutable.Map$ map$7 = Predef$.MODULE$.Map();
        Object[] objectArray7 = new Tuple2[1];
        String string8 = "encoder-secret";
        String $minus$greater$extension_$this8 = KafkaConfig$.MODULE$.PasswordEncoderSecretProp();
        Object var26_29 = null;
        string8 = null;
        objectArray7[0] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)$minus$greater$extension_y8);
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray7);
        if (map$7 == null) {
            throw null;
        }
        arraySeq10 = null;
        scala.collection.immutable.Map encoderConfigs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$7, (scala.collection.immutable.Seq)apply_elems4);
        this.alterConfigWithZk$1(configs, (Option)new Some((Object)brokerId), encoderConfigs, alterOpts, adminZkClient);
        Properties brokerConfigs = this.zkClient().getEntityConfigs("brokers", brokerId);
        Assert.assertFalse((String)"Encoder secret stored in ZooKeeper", (boolean)brokerConfigs.contains(KafkaConfig$.MODULE$.PasswordEncoderSecretProp()));
        Assert.assertEquals((Object)"2", (Object)brokerConfigs.getProperty("log.cleaner.threads"));
        String encodedPassword = brokerConfigs.getProperty("listener.name.external.ssl.keystore.password");
        PasswordEncoder passwordEncoder = ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs);
        Assert.assertEquals((Object)"secret", (Object)passwordEncoder.decode(encodedPassword).value());
        Assert.assertEquals((long)configs.size(), (long)brokerConfigs.size());
        scala.collection.immutable.Map$ map$8 = Predef$.MODULE$.Map();
        Object[] objectArray8 = new Tuple2[1];
        String string9 = "secret2";
        String $minus$greater$extension_$this9 = "listener.name.internal.ssl.keystore.password";
        Object var28_36 = null;
        string9 = null;
        objectArray8[0] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray8);
        if (map$8 == null) {
            throw null;
        }
        arraySeq11 = null;
        scala.collection.immutable.Map configs2 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$8, (scala.collection.immutable.Seq)apply_elems3);
        scala.collection.immutable.Map$ map$9 = Predef$.MODULE$.Map();
        Object[] objectArray9 = new Tuple2[5];
        String string10 = "encoder-secret";
        String $minus$greater$extension_$this10 = KafkaConfig$.MODULE$.PasswordEncoderSecretProp();
        Object var30_40 = null;
        string10 = null;
        objectArray9[0] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)$minus$greater$extension_y6);
        String string11 = "DES/CBC/PKCS5Padding";
        String $minus$greater$extension_$this11 = KafkaConfig$.MODULE$.PasswordEncoderCipherAlgorithmProp();
        Object var32_42 = null;
        string11 = null;
        objectArray9[1] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)$minus$greater$extension_y5);
        String string12 = "1024";
        String $minus$greater$extension_$this12 = KafkaConfig$.MODULE$.PasswordEncoderIterationsProp();
        Object var34_44 = null;
        string12 = null;
        objectArray9[2] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)$minus$greater$extension_y4);
        String string13 = "PBKDF2WithHmacSHA1";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.PasswordEncoderKeyFactoryAlgorithmProp();
        Object var36_46 = null;
        string13 = null;
        objectArray9[3] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y3);
        String string14 = "64";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.PasswordEncoderKeyLengthProp();
        Object var38_48 = null;
        string14 = null;
        objectArray9[4] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray9);
        if (map$9 == null) {
            throw null;
        }
        arraySeq12 = null;
        scala.collection.immutable.Map encoderConfigs2 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$9, (scala.collection.immutable.Seq)apply_elems2);
        this.alterConfigWithZk$1(configs2, (Option)new Some((Object)brokerId), encoderConfigs2, alterOpts, adminZkClient);
        String encodedPassword2 = this.zkClient().getEntityConfigs("brokers", brokerId).getProperty("listener.name.internal.ssl.keystore.password");
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs).decode(encodedPassword2).value());
        Assert.assertEquals((Object)"secret2", (Object)ConfigCommand$.MODULE$.createPasswordEncoder((Map)encoderConfigs2).decode(encodedPassword2).value());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterConfigWithZk$1(configs, (Option)None$.MODULE$, encoderConfigs, alterOpts, adminZkClient), ClassTag$.MODULE$.apply(ConfigException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 808));
        this.registerBrokerInZk(Integer.parseInt(brokerId));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "210000";
            String $minus$greater$extension_$this = "message.max.size";
            Object var4_5 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)brokerId), ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 812));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            void $minus$greater$extension_y;
            scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            String string = "220000";
            String $minus$greater$extension_$this = "message.max.size";
            Object var3_4 = null;
            string = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            this.alterConfigWithZk$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems), (Option)None$.MODULE$, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts, adminZkClient);
        }, ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("ConfigCommandTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 813));
        scala.collection.immutable.Map$ map$10 = Predef$.MODULE$.Map();
        Object[] objectArray10 = new Tuple2[1];
        String string15 = "230000";
        String $minus$greater$extension_$this15 = "message.max.size";
        Object var40_53 = null;
        string15 = null;
        objectArray10[0] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray10);
        if (map$10 == null) {
            throw null;
        }
        arraySeq13 = null;
        this.alterAndVerifyConfig$1((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$10, (scala.collection.immutable.Seq)apply_elems), (Option)new Some((Object)"2"), alterOpts, adminZkClient);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=="});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfigUsingZookeeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotUpdateBrokerConfigIfMalformedBracketConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", "1", "--entity-type", "brokers", "--alter", "--add-config", "a=[b,c,d=e"});
        ConfigCommand$.MODULE$.alterConfig((Admin)new DummyAdminClient(new Node(1, "localhost", 9092)), createOpts);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeletedUsingZookeper() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "my-topic", "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"});
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new DummyAdminZkClient(this.zkClient()));
    }

    @Test(expected=InvalidConfigurationException.class)
    public void shouldNotUpdateConfigIfNonExistingConfigIsDeleted() {
        String resourceName = "my-topic";
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--bootstrap-server", "localhost:9092", "--entity-name", resourceName, "--entity-type", "topics", "--alter", "--delete-config", "missing_config1, missing_config2"});
        ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, resourceName);
        java.util.List configEntries = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
        KafkaFutureImpl future = new KafkaFutureImpl();
        future.complete(Collections.singletonMap(resource, new Config((Collection)configEntries)));
        DescribeConfigsResult describeResult = (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        EasyMock.expect((Object)describeResult.all()).andReturn((Object)future).once();
        Node node = new Node(1, "localhost", 9092);
        MockAdminClient mockAdminClient = new MockAdminClient(null, node, resourceName, describeResult){
            private final String resourceName$4;
            private final DescribeConfigsResult describeResult$6;

            public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
                Assert.assertEquals((long)1L, (long)resources.size());
                ConfigResource resource = resources.iterator().next();
                Assert.assertEquals((Object)resource.type(), (Object)ConfigResource.Type.TOPIC);
                Assert.assertEquals((Object)resource.name(), (Object)this.resourceName$4);
                return this.describeResult$6;
            }
            {
                this.resourceName$4 = resourceName$4;
                this.describeResult$6 = describeResult$6;
                super(Collections.singletonList(node$6), node$6);
            }
        };
        EasyMock.replay((Object[])new Object[]{describeResult});
        ConfigCommand$.MODULE$.alterConfig((Admin)mockAdminClient, createOpts);
        EasyMock.reset((Object[])new Object[]{describeResult});
    }

    @Test
    public void shouldDeleteBrokerConfig() {
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", "1", "--entity-type", "brokers", "--alter", "--delete-config", "a,c"});
        public class Kafka_admin_ConfigCommandTest$TestAdminZkClient$5
        extends AdminZkClient {
            /*
             * WARNING - void declaration
             */
            public Properties fetchEntityConfig(String entityType, String entityName) {
                void var3_3;
                Properties properties = new Properties();
                properties.put("a", "b");
                properties.put("c", "d");
                properties.put("e", "f");
                return var3_3;
            }

            public void changeBrokerConfig(Seq<Object> brokerIds, Properties configChange) {
                Assert.assertEquals((Object)"f", (Object)configChange.get("e"));
                Assert.assertEquals((long)1L, (long)configChange.size());
            }

            public Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(ConfigCommandTest $outer, KafkaZkClient zkClient) {
                super(zkClient);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, createOpts, (AdminZkClient)new Kafka_admin_ConfigCommandTest$TestAdminZkClient$5(null, this.zkClient()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testScramCredentials() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        LazyRef CredentialChange$module = new LazyRef();
        scala.collection.mutable.Map credentials = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        ConfigCommand.ConfigCommandOptions optsA = this.createOpts$1("userA", "SCRAM-SHA-256=[iterations=8192,password=abc, def]");
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256"});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        public class Kafka_admin_ConfigCommandTest$CredentialChange$1
        extends AdminZkClient
        implements Product,
        Serializable {
            private final String user;
            private final Set<String> mechanisms;
            private final int iterations;
            private final /* synthetic */ ConfigCommandTest $outer;
            private final scala.collection.mutable.Map credentials$1;

            public Iterator<String> productElementNames() {
                return Product.productElementNames$((Product)this);
            }

            public String user() {
                return this.user;
            }

            public Set<String> mechanisms() {
                return this.mechanisms;
            }

            public int iterations() {
                return this.iterations;
            }

            public Properties fetchEntityConfig(String entityType, String entityName) {
                return (Properties)this.credentials$1.getOrElse((Object)entityName, (Function0 & Serializable)() -> new Properties());
            }

            public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configChange) {
                Assert.assertEquals((Object)this.user(), (Object)sanitizedEntityName);
                Assert.assertEquals(this.mechanisms(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(configChange.keySet()).asScala());
                this.mechanisms().foreach((Function1 & Serializable)mechanism -> {
                    String value = configChange.getProperty((String)mechanism);
                    Assert.assertEquals((long)-1L, (long)value.indexOf("password="));
                    ScramCredential scramCredential = ScramCredentialUtils.credentialFromString((String)value);
                    Assert.assertEquals((long)this.iterations(), (long)scramCredential.iterations());
                    return $this.credentials$1.put((Object)this.user(), (Object)configChange);
                });
            }

            public Kafka_admin_ConfigCommandTest$CredentialChange$1 copy(String user, Set<String> mechanisms, int iterations) {
                return new Kafka_admin_ConfigCommandTest$CredentialChange$1(this.$outer, user, mechanisms, iterations, this.credentials$1);
            }

            public String copy$default$1() {
                return this.user();
            }

            public Set<String> copy$default$2() {
                return this.mechanisms();
            }

            public int copy$default$3() {
                return this.iterations();
            }

            public String productPrefix() {
                return "CredentialChange";
            }

            public int productArity() {
                return 3;
            }

            public Object productElement(int x$1) {
                switch (x$1) {
                    case 0: {
                        return this.user();
                    }
                    case 1: {
                        return this.mechanisms();
                    }
                    case 2: {
                        return this.iterations();
                    }
                }
                return Statics.ioobe((int)x$1);
            }

            public Iterator<Object> productIterator() {
                return new /* Unavailable Anonymous Inner Class!! */;
            }

            public boolean canEqual(Object x$1) {
                return x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1;
            }

            public String productElementName(int x$1) {
                switch (x$1) {
                    case 0: {
                        return "user";
                    }
                    case 1: {
                        return "mechanisms";
                    }
                    case 2: {
                        return "iterations";
                    }
                }
                return (String)Statics.ioobe((int)x$1);
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)"CredentialChange".hashCode());
                n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.user()));
                n = Statics.mix((int)n, (int)Statics.anyHash(this.mechanisms()));
                n = Statics.mix((int)n, (int)this.iterations());
                int finalizeHash_length = 3;
                return Statics.avalanche((int)(n ^ finalizeHash_length));
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$1) {
                if (this == x$1) return true;
                if (!(x$1 instanceof Kafka_admin_ConfigCommandTest$CredentialChange$1)) return false;
                boolean bl = true;
                if (!bl) return false;
                Kafka_admin_ConfigCommandTest$CredentialChange$1 var3_3 = (Kafka_admin_ConfigCommandTest$CredentialChange$1)x$1;
                if (this.iterations() != var3_3.iterations()) return false;
                String string = this.user();
                String string2 = var3_3.user();
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                Set<String> set = this.mechanisms();
                Set<String> set2 = var3_3.mechanisms();
                if (set == null) {
                    if (set2 == null) return true;
                    return false;
                } else {
                    if (!set.equals(set2)) return false;
                    return true;
                }
            }

            /*
             * WARNING - void declaration
             */
            public Kafka_admin_ConfigCommandTest$CredentialChange$1(String user, Set<String> mechanisms, int iterations) {
                void var5_5;
                this.user = user;
                this.mechanisms = mechanisms;
                this.iterations = iterations;
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.credentials$1 = var5_5;
                super($outer.zkClient());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$changeUserOrUserClientIdConfig$1(kafka.admin.ConfigCommandTest$CredentialChange$1 java.util.Properties java.lang.String ), $anonfun$fetchEntityConfig$1()}, serializedLambda);
            }
        }
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsA, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userA", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems4)), 8192));
        ConfigCommand.ConfigCommandOptions optsB = this.createOpts$1("userB", "SCRAM-SHA-256=[iterations=4096,password=abc, def],SCRAM-SHA-512=[password=1234=abc]");
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-256", "SCRAM-SHA-512"});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, optsB, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems3)), 4096));
        ConfigCommand.ConfigCommandOptions del256 = this.deleteOpts$1("userB", "SCRAM-SHA-256");
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SCRAM-SHA-512"});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del256, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems2)), 4096));
        ConfigCommand.ConfigCommandOptions del512 = this.deleteOpts$1("userB", "SCRAM-SHA-512");
        Set$ set$4 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$4 == null) {
            throw null;
        }
        nil$ = null;
        ConfigCommand$.MODULE$.alterConfigWithZk(null, del512, (AdminZkClient)this.CredentialChange$3(CredentialChange$module, credentials).apply("userB", (Set<String>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems)), 4096));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaConfigEntity() {
        void $plus$plus$extension_evidence$25;
        void $plus$plus$extension_evidence$252;
        void $plus$plus$extension_evidence$253;
        void $plus$plus$extension_evidence$254;
        String[] describeOpts = new String[]{"--describe"};
        String[] alterOpts = new String[]{"--alter", "--add-config", "a=b,c=d"};
        String clientId = "client-1";
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$1(this, clientId, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("clients", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("clients", (Option)None$.MODULE$, alterOpts);
        String principal = "CN=ConfigCommandTest,O=Apache,L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        Assert.assertEquals((long)-1L, (long)sanitizedPrincipal.indexOf(61));
        Assert.assertEquals((Object)principal, (Object)Sanitizer.desanitize((String)sanitizedPrincipal));
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$2(this, principal, sanitizedPrincipal, opts);
            return BoxedUnit.UNIT;
        });
        this.checkEntity$1("users", (Option)None$.MODULE$, "", describeOpts);
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, alterOpts);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[][]{describeOpts, alterOpts})).foreach((Function1 & Serializable)opts -> {
            ConfigCommandTest.$anonfun$testQuotaConfigEntity$3(this, principal, userClient, clientId, sanitizedPrincipal, describeOpts, opts);
            return BoxedUnit.UNIT;
        });
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = new String[]{"--entity-type", "clients"};
        Object var7_8 = null;
        classTag = null;
        this.checkEntity$1("users", (Option)new Some((Object)principal), new StringBuilder(8).append(sanitizedPrincipal).append("/clients").toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)describeOpts, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$254));
        ClassTag classTag2 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs2 = new String[]{"--entity-type", "clients"};
        Object var9_10 = null;
        classTag2 = null;
        this.checkInvalidEntity$1("users", (Option)new Some((Object)principal), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs2, (ClassTag)$plus$plus$extension_evidence$253));
        ClassTag classTag3 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs3 = ConfigCommandTest.clientIdOpts$1(clientId);
        Object var11_12 = null;
        classTag3 = null;
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs3, (ClassTag)$plus$plus$extension_evidence$252));
        ClassTag classTag4 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs4 = new String[]{"--entity-type", "clients"};
        Object var13_14 = null;
        classTag4 = null;
        this.checkInvalidEntity$1("users", (Option)None$.MODULE$, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts, (Object)$plus$plus$extension_xs4, (ClassTag)$plus$plus$extension_evidence$25));
    }

    @Test
    public void testUserClientQuotaOpts() {
        this.checkEntity$2("users", Sanitizer.sanitize((String)"<default>"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("clients", Sanitizer.sanitize((String)"<default>"), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "<default>", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "users", "--entity-name", "CN=user1", "--entity-type", "clients", "--entity-name", "client1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "CN=user1", "--entity-type", "users", "--entity-name", "client1", "--entity-type", "clients", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "client1", "--entity-type", "users", "--entity-name", "CN=user1", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(16).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/client1").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
        this.checkEntity$2("users", new StringBuilder(8).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients").toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", "/clients", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-type", "clients", "--entity-type", "users", "--describe"}));
        this.checkEntity$2("users", new StringBuilder(9).append(Sanitizer.sanitize((String)"CN=user1")).append("/clients/").append(Sanitizer.sanitize((String)"client1?@%")).toString(), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"--entity-name", "client1?@%", "--entity-type", "clients", "--entity-name", "CN=user1", "--entity-type", "users", "--alter", "--add-config", "a=b,c=d"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testQuotaDescribeEntities() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        void apply_elems5;
        void $minus$greater$extension_y5;
        void apply_elems6;
        void $minus$greater$extension_y6;
        void apply_elems7;
        void $minus$greater$extension_y7;
        KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
        String clientId = "a-client";
        String principal = "CN=ConfigCommandTest.testQuotaDescribeEntities , O=Apache, L=<default>";
        String sanitizedPrincipal = Sanitizer.sanitize((String)principal);
        String userClient = new StringBuilder(9).append(sanitizedPrincipal).append("/clients/").append(clientId).toString();
        String[] opts = new String[]{"--entity-type", "clients", "--entity-name", clientId};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = new String[]{"--entity-type", "clients", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = new String[]{"--entity-type", "clients"};
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        SeqOps seqOps = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId}));
        String $minus$greater$extension_$this = "clients";
        Object var9_8 = null;
        seqOps = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems7), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{clientId})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{sanitizedPrincipal})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>"})), zkClient);
        opts = new String[]{"--entity-type", "users"};
        scala.collection.immutable.Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        SeqOps seqOps2 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        String $minus$greater$extension_$this2 = "users";
        Object var11_11 = null;
        seqOps2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y6);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$2, (scala.collection.immutable.Seq)apply_elems6), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-name", clientId};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{userClient})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients", "--entity-default"};
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(18).append(sanitizedPrincipal).append("/clients/<default>").toString()})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-name", principal, "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        SeqOps seqOps3 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-4"}));
        String $minus$greater$extension_$this3 = new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString();
        Object var13_14 = null;
        seqOps3 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$3, (scala.collection.immutable.Seq)apply_elems5), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-4").toString()})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-default", "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        SeqOps seqOps4 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-5"}));
        String $minus$greater$extension_$this4 = "users/<default>/clients";
        Object var15_17 = null;
        seqOps4 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$4, (scala.collection.immutable.Seq)apply_elems4), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-5"})), zkClient);
        opts = new String[]{"--entity-type", "users", "--entity-type", "clients"};
        scala.collection.immutable.Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        SeqOps seqOps5 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-2"}));
        String $minus$greater$extension_$this5 = new StringBuilder(14).append("users/").append(sanitizedPrincipal).append("/clients").toString();
        Object var17_20 = null;
        seqOps5 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        scala.collection.immutable.Map userMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$5, (scala.collection.immutable.Seq)apply_elems3);
        scala.collection.immutable.Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[1];
        SeqOps seqOps6 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"client-3"}));
        String $minus$greater$extension_$this6 = "users/<default>/clients";
        Object var19_24 = null;
        seqOps6 = null;
        objectArray6[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        scala.collection.immutable.Map defaultUserMap = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$6, (scala.collection.immutable.Seq)apply_elems2);
        scala.collection.immutable.Map$ map$7 = Predef$.MODULE$.Map();
        Object[] objectArray7 = new Tuple2[1];
        SeqOps seqOps7 = Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>", sanitizedPrincipal}));
        String $minus$greater$extension_$this7 = "users";
        Object var21_28 = null;
        seqOps7 = null;
        objectArray7[0] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray7);
        if (map$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        ConfigCommandTest.checkEntities$1(opts, (scala.collection.immutable.Map)((MapOps)((MapOps)MapFactory.apply$((MapFactory)map$7, (scala.collection.immutable.Seq)apply_elems)).$plus$plus((IterableOnce)defaultUserMap)).$plus$plus((IterableOnce)userMap), (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<default>/clients/client-3", new StringBuilder(17).append(sanitizedPrincipal).append("/clients/client-2").toString()})), zkClient);
    }

    private void registerBrokerInZk(int id) {
        this.zkClient().createTopLevelPaths();
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        EndPoint endpoint = new EndPoint("localhost", 9092, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
        BrokerInfo brokerInfo = BrokerInfo$.MODULE$.apply(new Broker(id, (Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new EndPoint[]{endpoint})), (Option)None$.MODULE$), ApiVersion$.MODULE$.latestVersion(), 9192);
        this.zkClient().registerBroker(brokerInfo);
    }

    public static final /* synthetic */ Nothing$ $anonfun$assertNonZeroStatusExit$1(ObjectRef exitStatus$1, int status, Option x$1) {
        exitStatus$1.elem = new Some((Object)status);
        throw new RuntimeException();
    }

    private final void testExpectedEntityTypeNames$1(List expectedTypes, List expectedNames, scala.collection.immutable.Seq args) {
        ClassTag $plus$plus$extension_evidence$24 = ClassTag$.MODULE$.apply(String.class);
        Object var5_4 = null;
        ConfigCommand.ConfigCommandOptions createOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{"--zookeeper", this.zkConnect(), "--describe"}, (IterableOnce)args, $plus$plus$extension_evidence$24));
        createOpts.checkArgs();
        Assert.assertEquals((Object)createOpts.entityTypes(), (Object)expectedTypes);
        Assert.assertEquals((Object)createOpts.entityNames(), (Object)expectedNames);
    }

    public static final ConfigEntry kafka$admin$ConfigCommandTest$$newConfigEntry$1(String name, String value) {
        return ConfigTest.newConfigEntry((String)name, (String)value, (ConfigEntry.ConfigSource)ConfigEntry.ConfigSource.DYNAMIC_TOPIC_CONFIG, (boolean)false, (boolean)false, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()));
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1(String id) {
        return new String[]{"--entity-name", id};
    }

    public static final /* synthetic */ String[] $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() {
        return new String[]{"--entity-default"};
    }

    private static final String[] entityOpt$1(Option brokerId) {
        Object object = brokerId.isEmpty() ? None$.MODULE$ : new Some((Object)ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$1((String)brokerId.get()));
        None$ none$ = object;
        object = null;
        None$ getOrElse_this = none$;
        Object object2 = getOrElse_this.isEmpty() ? ConfigCommandTest.$anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$2() : getOrElse_this.get();
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    private final void alterConfigWithZk$1(scala.collection.immutable.Map configs, Option brokerId, scala.collection.immutable.Map encoderConfigs, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        void $plus$plus$extension_evidence$25;
        void mkString_sep;
        String string;
        IterableOnceOps iterableOnceOps = (IterableOnceOps)configs.$plus$plus((IterableOnce)encoderConfigs).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            String string = new StringBuilder(1).append(k).append("=").append(v).toString();
            return string;
        });
        String string2 = ",";
        if (iterableOnceOps == null) {
            throw null;
        }
        IterableOnceOps mkString_this = iterableOnceOps;
        String string3 = string = mkString_this.mkString("", (String)mkString_sep, "");
        Object var8_7 = null;
        string2 = null;
        string = null;
        String configStr = string3;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.entityOpt$1(brokerId);
        Object var11_11 = null;
        classTag = null;
        ConfigCommand.ConfigCommandOptions addOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts$1, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25)), (Object)new String[]{"--add-config", configStr}, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), addOpts, adminZkClient$1);
    }

    private static final scala.collection.immutable.Map alterConfigWithZk$default$3$1() {
        Predef$.MODULE$.Map();
        return Map.EmptyMap$.MODULE$;
    }

    public static final /* synthetic */ String $anonfun$testDynamicBrokerConfigUpdateUsingZooKeeper$4() {
        return ConfigEntityName$.MODULE$.Default();
    }

    private final void verifyConfig$1(scala.collection.immutable.Map configs, Option brokerId) {
        Object object;
        KafkaZkClient kafkaZkClient = this.zkClient();
        if (brokerId == null) {
            throw null;
        }
        if (brokerId.isEmpty()) {
            String string;
            String string2 = string = ConfigEntityName$.MODULE$.Default();
            string = null;
            object = string2;
        } else {
            object = brokerId.get();
        }
        Object object2 = object;
        object = null;
        Properties entityConfigs = kafkaZkClient.getEntityConfigs("brokers", (String)object2);
        Assert.assertEquals((Object)configs, (Object)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(entityConfigs).asScala());
    }

    private final void alterAndVerifyConfig$1(scala.collection.immutable.Map configs, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        this.alterConfigWithZk$1(configs, brokerId, ConfigCommandTest.alterConfigWithZk$default$3$1(), alterOpts$1, adminZkClient$1);
        this.verifyConfig$1(configs, brokerId);
    }

    /*
     * WARNING - void declaration
     */
    private final void deleteAndVerifyConfig$1(Set configNames, Option brokerId, String[] alterOpts$1, AdminZkClient adminZkClient$1) {
        void $plus$plus$extension_evidence$25;
        void mkString_sep;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.entityOpt$1(brokerId);
        Object var6_6 = null;
        classTag = null;
        String[] stringArray = new String[2];
        stringArray[0] = "--delete-config";
        String string = ",";
        if (configNames == null) {
            throw null;
        }
        string = null;
        stringArray[1] = configNames.mkString("", (String)mkString_sep, "");
        ConfigCommand.ConfigCommandOptions deleteOpts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)alterOpts$1, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$25)), (Object)stringArray, ClassTag$.MODULE$.apply(String.class)));
        ConfigCommand$.MODULE$.alterConfigWithZk(this.zkClient(), deleteOpts, adminZkClient$1);
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        this.verifyConfig$1((scala.collection.immutable.Map)Map.EmptyMap$.MODULE$, brokerId);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$1(String user, String config) {
        return new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--add-config", config});
    }

    private final ConfigCommand.ConfigCommandOptions deleteOpts$1(String user, String mechanism) {
        return new ConfigCommand.ConfigCommandOptions(new String[]{"--zookeeper", this.zkConnect(), "--entity-name", user, "--entity-type", "users", "--alter", "--delete-config", mechanism});
    }

    private final /* synthetic */ ConfigCommandTest$CredentialChange$2$ CredentialChange$lzycompute$1(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        synchronized (CredentialChange$module$1) {
            ConfigCommandTest$CredentialChange$2$ configCommandTest$CredentialChange$2$ = CredentialChange$module$1.initialized() ? (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.value() : (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.initialize((Object)new ConfigCommandTest$CredentialChange$2$(this, credentials$1));
            return configCommandTest$CredentialChange$2$;
        }
    }

    private final ConfigCommandTest$CredentialChange$2$ CredentialChange$3(LazyRef CredentialChange$module$1, scala.collection.mutable.Map credentials$1) {
        if (CredentialChange$module$1.initialized()) {
            return (ConfigCommandTest$CredentialChange$2$)CredentialChange$module$1.value();
        }
        return this.CredentialChange$lzycompute$1(CredentialChange$module$1, credentials$1);
    }

    private final ConfigCommand.ConfigCommandOptions createOpts$2(String entityType, Option entityName, String[] otherArgs) {
        String[] stringArray;
        String[] optArray = new String[]{"--zookeeper", this.zkConnect(), "--entity-type", entityType};
        if (entityName instanceof Some) {
            String name = (String)((Some)entityName).value();
            stringArray = new String[]{"--entity-name", name};
        } else if (None$.MODULE$.equals(entityName)) {
            stringArray = (String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        } else {
            throw new MatchError((Object)entityName);
        }
        ClassTag $plus$plus$extension_evidence$25 = ClassTag$.MODULE$.apply(String.class);
        Object var7_7 = null;
        ClassTag $plus$plus$extension_evidence$252 = ClassTag$.MODULE$.apply(String.class);
        Object var8_8 = null;
        return new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)((Object[])ArrayOps$.MODULE$.appendedAll$extension((Object)optArray, (Object)stringArray, $plus$plus$extension_evidence$25)), (Object)otherArgs, $plus$plus$extension_evidence$252));
    }

    private final void checkEntity$1(String entityType, Option entityName, String expectedEntityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)entityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    private final void checkInvalidEntity$1(String entityType, Option entityName, String[] otherArgs) {
        ConfigCommand.ConfigCommandOptions opts = this.createOpts$2(entityType, entityName, otherArgs);
        try {
            opts.checkArgs();
            ConfigCommand$.MODULE$.parseEntity(opts);
            Assert.fail((String)"Did not fail with invalid argument list");
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$1(ConfigCommandTest $this, String clientId$1, String[] opts) {
        $this.checkEntity$1("clients", (Option)new Some((Object)clientId$1), clientId$1, opts);
        $this.checkEntity$1("clients", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$2(ConfigCommandTest $this, String principal$1, String sanitizedPrincipal$1, String[] opts) {
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), sanitizedPrincipal$1, opts);
        $this.checkEntity$1("users", (Option)new Some((Object)""), ConfigEntityName$.MODULE$.Default(), opts);
    }

    private static final String[] clientIdOpts$1(String name) {
        return new String[]{"--entity-type", "clients", "--entity-name", name};
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testQuotaConfigEntity$3(ConfigCommandTest $this, String principal$1, String userClient$1, String clientId$1, String sanitizedPrincipal$1, String[] describeOpts$1, String[] opts) {
        void $plus$plus$extension_evidence$25;
        void $plus$plus$extension_evidence$252;
        void $plus$plus$extension_evidence$253;
        void $plus$plus$extension_evidence$254;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs = ConfigCommandTest.clientIdOpts$1(clientId$1);
        Object var7_8 = null;
        classTag = null;
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), userClient$1, (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs, (ClassTag)$plus$plus$extension_evidence$254));
        ClassTag classTag2 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs2 = ConfigCommandTest.clientIdOpts$1("");
        Object var9_10 = null;
        classTag2 = null;
        $this.checkEntity$1("users", (Option)new Some((Object)principal$1), new StringBuilder(9).append(sanitizedPrincipal$1).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs2, (ClassTag)$plus$plus$extension_evidence$253));
        ClassTag classTag3 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs3 = ConfigCommandTest.clientIdOpts$1(clientId$1);
        Object var11_12 = null;
        classTag3 = null;
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(clientId$1).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)describeOpts$1, (Object)$plus$plus$extension_xs3, (ClassTag)$plus$plus$extension_evidence$252));
        ClassTag classTag4 = ClassTag$.MODULE$.apply(String.class);
        String[] $plus$plus$extension_xs4 = ConfigCommandTest.clientIdOpts$1("");
        Object var13_14 = null;
        classTag4 = null;
        $this.checkEntity$1("users", (Option)new Some((Object)""), new StringBuilder(9).append(ConfigEntityName$.MODULE$.Default()).append("/clients/").append(ConfigEntityName$.MODULE$.Default()).toString(), (String[])ArrayOps$.MODULE$.appendedAll$extension((Object)opts, (Object)$plus$plus$extension_xs4, (ClassTag)$plus$plus$extension_evidence$25));
    }

    private final void checkEntity$2(String expectedEntityType, String expectedEntityName, scala.collection.immutable.Seq args) {
        ClassTag $plus$plus$extension_evidence$24 = ClassTag$.MODULE$.apply(String.class);
        Object var6_4 = null;
        ConfigCommand.ConfigCommandOptions opts = new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appendedAll$extension((Object)new String[]{"--zookeeper", this.zkConnect()}, (IterableOnce)args, $plus$plus$extension_evidence$24));
        opts.checkArgs();
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(opts);
        Assert.assertEquals((Object)expectedEntityType, (Object)entity.root().entityType());
        Assert.assertEquals((Object)expectedEntityName, (Object)entity.fullSanitizedName());
    }

    /*
     * WARNING - void declaration
     */
    private static final void checkEntities$1(String[] opts, scala.collection.immutable.Map expectedFetches, Seq expectedEntityNames, KafkaZkClient zkClient$1) {
        void $colon$plus$extension_evidence$11;
        ClassTag classTag = ClassTag$.MODULE$.apply(String.class);
        String $colon$plus$extension_x = "--describe";
        Object var6_5 = null;
        classTag = null;
        ConfigCommand.ConfigEntity entity = ConfigCommand$.MODULE$.parseEntity(new ConfigCommand.ConfigCommandOptions((String[])ArrayOps$.MODULE$.appended$extension((Object)opts, (Object)$colon$plus$extension_x, (ClassTag)$colon$plus$extension_evidence$11)));
        expectedFetches.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String name = (String)x0$1._1();
            Seq values = (Seq)x0$1._2();
            IExpectationSetters iExpectationSetters = EasyMock.expect((Object)zkClient$1.getAllEntitiesWithConfig(name)).andReturn((Object)values);
            return iExpectationSetters;
        });
        EasyMock.replay((Object[])new Object[]{zkClient$1});
        Seq entities = entity.getAllEntities(zkClient$1);
        Assert.assertEquals((Object)expectedEntityNames, (Object)entities.map((Function1 & Serializable)e -> e.fullSanitizedName()));
        EasyMock.reset((Object[])new Object[]{zkClient$1});
    }

    public class DummyAdminClient
    extends MockAdminClient {
        public DescribeConfigsResult describeConfigs(Collection<ConfigResource> resources, DescribeConfigsOptions options) {
            return (DescribeConfigsResult)EasyMock.createNiceMock(DescribeConfigsResult.class);
        }

        public AlterConfigsResult incrementalAlterConfigs(java.util.Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public AlterConfigsResult alterConfigs(java.util.Map<ConfigResource, Config> configs, AlterConfigsOptions options) {
            return (AlterConfigsResult)EasyMock.createNiceMock(AlterConfigsResult.class);
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminClient(Node node) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(Collections.singletonList(node), node);
        }
    }

    public class DummyAdminZkClient
    extends AdminZkClient {
        public void changeBrokerConfig(Seq<Object> brokerIds, Properties configs) {
        }

        public Properties fetchEntityConfig(String entityType, String entityName) {
            return new Properties();
        }

        public void changeClientIdConfig(String clientId, Properties configs) {
        }

        public void changeUserOrUserClientIdConfig(String sanitizedEntityName, Properties configs) {
        }

        public void changeTopicConfig(String topic, Properties configs) {
        }

        public /* synthetic */ ConfigCommandTest kafka$admin$ConfigCommandTest$DummyAdminZkClient$$$outer() {
            return ConfigCommandTest.this;
        }

        public DummyAdminZkClient(KafkaZkClient zkClient) {
            if (ConfigCommandTest.this == null) {
                throw null;
            }
            super(zkClient);
        }
    }
}

