/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$;
import kafka.common.AdminCommandFailedException;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.ConfigType$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataCache;
import kafka.utils.TestUtils$;
import kafka.zk.ConfigEntityChangeNotificationZNode$;
import kafka.zk.DeleteTopicsTopicZNode$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientTestUtils;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\t\u001df\u0001\u0002$H\u00011CQ!\u0018\u0001\u0005\u0002yCQ\u0001\u0019\u0001\u0005B\u0005Dq\u0001\u001d\u0001C\u0002\u0013%\u0011\u000f\u0003\u0004w\u0001\u0001\u0006IA\u001d\u0005\bo\u0002\u0011\r\u0011\"\u0003y\u0011\u0019a\b\u0001)A\u0005s\"IQ\u0010\u0001a\u0001\u0002\u0004%IA \u0005\f\u00037\u0001\u0001\u0019!a\u0001\n\u0013\ti\u0002\u0003\u0006\u0002*\u0001\u0001\r\u0011!Q!\n}D1\"a\u000b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002.!Y\u0011q\t\u0001A\u0002\u0003\u0007I\u0011BA%\u0011-\ti\u0005\u0001a\u0001\u0002\u0003\u0006K!a\f\t\u0017\u0005=\u0003\u00011AA\u0002\u0013%\u0011\u0011\u000b\u0005\f\u0003G\u0002\u0001\u0019!a\u0001\n\u0013\t)\u0007C\u0006\u0002j\u0001\u0001\r\u0011!Q!\n\u0005M\u0003\"CA6\u0001\t\u0007I\u0011BA7\u0011!\ty\b\u0001Q\u0001\n\u0005=\u0004bBAA\u0001\u0011\u0005\u0011Q\u000e\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\ty\n\u0001C\u0001\u0003CCq!a,\u0001\t\u0003\t\t\fC\u0004\u00028\u0002!\t!!/\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0007bBAn\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0003O\u0004A\u0011AAo\u0011\u001d\t\t\u0010\u0001C\u0001\u0003;Dq!a?\u0001\t\u0003\ti\u000eC\u0004\u0002\u0000\u0002!\t!!8\t\u000f\t\r\u0001\u0001\"\u0001\u0002^\"9!q\u0001\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0006\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u001f\u0001A\u0011AAo\u0011\u001d\u0011\u0019\u0002\u0001C\u0001\u0003;DqAa\u0006\u0001\t\u0003\ti\u000eC\u0004\u0003\u001c\u0001!\t!!8\t\u000f\t}\u0001\u0001\"\u0001\u0002^\"9!1\u0005\u0001\u0005\u0002\u0005u\u0007b\u0002B\u0014\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005W\u0001A\u0011AAo\u0011\u001d\u0011y\u0003\u0001C\u0001\u0003;DqAa\r\u0001\t\u0003\ti\u000eC\u0004\u00038\u0001!\t!!8\t\u000f\tm\u0002\u0001\"\u0001\u0002^\"9!q\b\u0001\u0005\u0002\u0005u\u0007b\u0002B\"\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u000f\u0002A\u0011AAo\u0011\u001d\u0011Y\u0005\u0001C\u0001\u0003;DqAa\u0014\u0001\t\u0003\ti\u000eC\u0004\u0003T\u0001!\t!!8\t\u000f\t]\u0003\u0001\"\u0001\u0002^\"9!1\f\u0001\u0005\u0002\u0005u\u0007b\u0002B0\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005G\u0002A\u0011AAo\u0011\u001d\u00119\u0007\u0001C\u0001\u0003;DqAa\u001b\u0001\t\u0003\ti\u000eC\u0004\u0003p\u0001!\t!!8\t\u000f\tM\u0004\u0001\"\u0001\u0002^\"9!q\u000f\u0001\u0005\u0002\u0005u\u0007b\u0002B>\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u0005\u007f\u0002A\u0011AAo\u0011\u001d\u0011\u0019\t\u0001C\u0001\u0003;DqAa\"\u0001\t\u0003\ti\u000eC\u0004\u0003\f\u0002!\t!!8\t\u000f\t=\u0005\u0001\"\u0001\u0002^\"9!1\u0013\u0001\u0005\u0002\u0005u\u0007b\u0002BL\u0001\u0011\u0005\u0011Q\u001c\u0005\b\u00057\u0003A\u0011AAo\u0011\u001d\u0011y\n\u0001C\u0001\u0003;DqAa)\u0001\t\u0003\tiNA\u0010U_BL7mQ8n[\u0006tGmV5uQ\u0006#W.\u001b8DY&,g\u000e\u001e+fgRT!\u0001S%\u0002\u000b\u0005$W.\u001b8\u000b\u0003)\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\u001bNK\u0006C\u0001(R\u001b\u0005y%B\u0001)J\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005I{%AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0011\u0005Q;V\"A+\u000b\u0005YK\u0015!B;uS2\u001c\u0018B\u0001-V\u0005\u001daunZ4j]\u001e\u0004\"AW.\u000e\u0003\u001dK!\u0001X$\u0003\u001bI\u000b7m[!xCJ,G+Z:u\u0003\u0019a\u0014N\\5u}Q\tq\f\u0005\u0002[\u0001\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001c!\r\u0019\u0007N[\u0007\u0002I*\u0011QMZ\u0001\u000bG>dG.Z2uS>t'\"A4\u0002\u000bM\u001c\u0017\r\\1\n\u0005%$'aA*fcB\u00111N\\\u0007\u0002Y*\u0011Q.S\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005=d'aC&bM.\f7i\u001c8gS\u001e\fQB\\;n!\u0006\u0014H/\u001b;j_:\u001cX#\u0001:\u0011\u0005M$X\"\u00014\n\u0005U4'aA%oi\u0006qa.^7QCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\u00073fM\u0006,H\u000e\u001e*fa2L7-\u0019;j_:4\u0015m\u0019;peV\t\u0011\u0010\u0005\u0002tu&\u00111P\u001a\u0002\u0006'\"|'\u000f^\u0001\u001aI\u00164\u0017-\u001e7u%\u0016\u0004H.[2bi&|gNR1di>\u0014\b%\u0001\u0007u_BL7mU3sm&\u001cW-F\u0001\u0000!\u0011\t\t!!\u0006\u000f\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\tyA\u0004\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tYaS\u0001\u0007yI|w\u000e\u001e \n\u0003)K!\u0001S%\n\u0007\u0005Mq)\u0001\u0007U_BL7mQ8n[\u0006tG-\u0003\u0003\u0002\u0018\u0005e!aF!e[&t7\t\\5f]R$v\u000e]5d'\u0016\u0014h/[2f\u0015\r\t\u0019bR\u0001\u0011i>\u0004\u0018nY*feZL7-Z0%KF$B!a\b\u0002&A\u00191/!\t\n\u0007\u0005\rbM\u0001\u0003V]&$\b\u0002CA\u0014\u0011\u0005\u0005\t\u0019A@\u0002\u0007a$\u0013'A\u0007u_BL7mU3sm&\u001cW\rI\u0001\fC\u0012l\u0017N\\\"mS\u0016tG/\u0006\u0002\u00020A!\u0011\u0011GA\"\u001b\t\t\u0019DC\u0002I\u0003kQA!a\u000e\u0002:\u000591\r\\5f]R\u001c(b\u0001&\u0002<)!\u0011QHA \u0003\u0019\t\u0007/Y2iK*\u0011\u0011\u0011I\u0001\u0004_J<\u0017\u0002BA#\u0003g\u0011Q!\u00113nS:\fq\"\u00193nS:\u001cE.[3oi~#S-\u001d\u000b\u0005\u0003?\tY\u0005C\u0005\u0002(-\t\t\u00111\u0001\u00020\u0005a\u0011\rZ7j]\u000ec\u0017.\u001a8uA\u0005iA/Z:u)>\u0004\u0018n\u0019(b[\u0016,\"!a\u0015\u0011\t\u0005U\u0013Q\f\b\u0005\u0003/\nI\u0006E\u0002\u0002\b\u0019L1!a\u0017g\u0003\u0019\u0001&/\u001a3fM&!\u0011qLA1\u0005\u0019\u0019FO]5oO*\u0019\u00111\f4\u0002#Q,7\u000f\u001e+pa&\u001cg*Y7f?\u0012*\u0017\u000f\u0006\u0003\u0002 \u0005\u001d\u0004\"CA\u0014\u001d\u0005\u0005\t\u0019AA*\u00039!Xm\u001d;U_BL7MT1nK\u0002\n\u0011b\u0018;fgRt\u0015-\\3\u0016\u0005\u0005=\u0004\u0003BA9\u0003wj!!a\u001d\u000b\t\u0005U\u0014qO\u0001\u0006eVdWm\u001d\u0006\u0005\u0003s\ny$A\u0003kk:LG/\u0003\u0003\u0002~\u0005M$\u0001\u0003+fgRt\u0015-\\3\u0002\u0015}#Xm\u001d;OC6,\u0007%\u0001\u0005uKN$h*Y7fQ\r\u0011\u0012Q\u0011\t\u0005\u0003\u000f\u000bI)\u0004\u0002\u0002x%!\u00111RA<\u0005\u0011\u0011V\u000f\\3\u0002\u001d\u0005\u001c8/\u001a:u\u000bbLGoQ8eKR1\u0011qDAI\u0003+Ca!a%\u0014\u0001\u0004\u0011\u0018\u0001C3ya\u0016\u001cG/\u001a3\t\u000f\u0005]5\u00031\u0001\u0002\u001a\u00061Q.\u001a;i_\u0012\u0004Ra]AN\u0003?I1!!(g\u0005%1UO\\2uS>t\u0007'A\fbgN,'\u000f^\"iK\u000e\\\u0017I]4t\u000bbLGoQ8eKR1\u0011qDAR\u0003KCa!a%\u0015\u0001\u0004\u0011\bbBAT)\u0001\u0007\u0011\u0011V\u0001\b_B$\u0018n\u001c8t!\u0011\t\t!a+\n\t\u00055\u0016\u0011\u0004\u0002\u0014)>\u0004\u0018nY\"p[6\fg\u000eZ(qi&|gn]\u0001\u0013GJ,\u0017\r^3B]\u0012<\u0016-\u001b;U_BL7\r\u0006\u0003\u0002 \u0005M\u0006bBA[+\u0001\u0007\u0011\u0011V\u0001\u0005_B$8/A\nxC&$hi\u001c:U_BL7m\u0011:fCR,G\r\u0006\u0004\u0002 \u0005m\u0016q\u0018\u0005\b\u0003{3\u0002\u0019AA*\u0003%!x\u000e]5d\u001d\u0006lW\r\u0003\u0005\u0002BZ\u0001\n\u00111\u0001s\u0003\u001d!\u0018.\\3pkR\fQd^1ji\u001a{'\u000fV8qS\u000e\u001c%/Z1uK\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fT3A]AeW\t\tY\r\u0005\u0003\u0002N\u0006]WBAAh\u0015\u0011\t\t.a5\u0002\u0013Ut7\r[3dW\u0016$'bAAkM\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0017q\u001a\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!B:fiV\u0004HCAA\u0010Q\rA\u0012\u0011\u001d\t\u0005\u0003\u000f\u000b\u0019/\u0003\u0003\u0002f\u0006]$A\u0002\"fM>\u0014X-A\u0003dY>\u001cX\rK\u0002\u001a\u0003W\u0004B!a\"\u0002n&!\u0011q^A<\u0005\u0015\te\r^3s\u0003M!Xm\u001d;QCJ\u001cX-Q:tS\u001etW.\u001a8uQ\rQ\u0012Q\u001f\t\u0005\u0003\u000f\u000b90\u0003\u0003\u0002z\u0006]$\u0001\u0002+fgR\f1\u0005^3tiB\u000b'o]3BgNLwM\\7f]R$U\u000f\u001d7jG\u0006$X-\u00128ue&,7\u000fK\u0002\u001c\u0003k\fA\u0006^3tiB\u000b'o]3BgNLwM\\7f]R\u0004\u0016M\u001d;ji&|gn](g\t&4g-\u001a:f]R\u001c\u0016N_3)\u0007q\t)0A\u0011uKN$8i\u001c8gS\u001e|\u0005\u000f^,ji\"\u0014un\u001c;tiJ\f\u0007oU3sm\u0016\u00148\u000fK\u0002\u001e\u0003k\f!\u0002^3ti\u000e\u0013X-\u0019;fQ\rq\u0012Q_\u0001\u0017i\u0016\u001cHo\u0011:fCR,w+\u001b;i\t\u00164\u0017-\u001e7ug\"\u001aq$!>\u0002AQ,7\u000f^\"sK\u0006$XmV5uQ\u0012+g-Y;miJ+\u0007\u000f\\5dCRLwN\u001c\u0015\u0004A\u0005U\u0018a\b;fgR\u001c%/Z1uK^KG\u000f\u001b#fM\u0006,H\u000e\u001e)beRLG/[8og\"\u001a\u0011%!>\u0002+Q,7\u000f^\"sK\u0006$XmV5uQ\u000e{gNZ5hg\"\u001a!%!>\u00027Q,7\u000f^\"sK\u0006$X-\u00134Ji\u0006c'/Z1es\u0016C\u0018n\u001d;tQ\r\u0019\u0013Q_\u0001 i\u0016\u001cHo\u0011:fCR,w+\u001b;i%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bf\u0001\u0013\u0002v\u00061C/Z:u\u0007J,\u0017\r^3XSRD\u0017J\u001c<bY&$'+\u001a9mS\u000e\fG/[8o\r\u0006\u001cGo\u001c:)\u0007\u0015\n)0A\u0014uKN$8I]3bi\u0016<\u0016\u000e\u001e5OK\u001e\fG/\u001b<f%\u0016\u0004H.[2bi&|gNR1di>\u0014\bf\u0001\u0014\u0002v\u0006IC/Z:u\u0007J,\u0017\r^3XSRD\u0017i]:jO:lWM\u001c;B]\u0012\u0004\u0016M\u001d;ji&|gnQ8v]RD3aJA{\u00031\"Xm\u001d;De\u0016\fG/Z,ji\"\f5o]5h]6,g\u000e^!oIJ+\u0007\u000f\\5dCRLwN\u001c$bGR|'\u000fK\u0002)\u0003k\fA\u0005^3ti\u000e\u0013X-\u0019;f/&$\bNT3hCRLg/\u001a)beRLG/[8o\u0007>,h\u000e\u001e\u0015\u0004S\u0005U\u0018a\u0011;fgR\u001c%/Z1uK^KG\u000f[+ogB,7-\u001b4jK\u0012\u0014V\r\u001d7jG\u0006$\u0018n\u001c8GC\u000e$xN]!oIB\u000b'\u000f^5uS>t7oV5uQj[7\t\\5f]RD3AKA{\u0003m!Xm\u001d;J]Z\fG.\u001b3U_BL7\rT3wK2\u001cuN\u001c4jO\"\u001a1&!>\u0002\u001dQ,7\u000f\u001e'jgR$v\u000e]5dg\"\u001aA&!>\u00027Q,7\u000f\u001e'jgR$v\u000e]5dg^KG\u000f[,iSR,G.[:uQ\ri\u0013Q_\u0001\"i\u0016\u001cH\u000fT5tiR{\u0007/[2t/&$\b.\u0012=dYV$W-\u00138uKJt\u0017\r\u001c\u0015\u0004]\u0005U\u0018a\u0006;fgR\fE\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cu.\u001e8uQ\ry\u0013Q_\u0001\u0014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e\u001e\u0015\u0004a\u0005U\u0018a\r;fgR\fE\u000e^3s\u0003N\u001c\u0018n\u001a8nK:$x+\u001b;i\u001b>\u0014X-Q:tS\u001etW.\u001a8u)\"\fg\u000eU1si&$\u0018n\u001c8tQ\r\t\u0014Q_\u00014i\u0016\u001cH/\u00117uKJ\f5o]5h]6,g\u000e^,ji\"luN]3QCJ$\u0018\u000e^5p]N$\u0006.\u00198BgNLwM\\7f]RD3AMA{\u0003\t\"Xm\u001d;BYR,'oV5uQ&sg/\u00197jIB\u000b'\u000f^5uS>t7i\\;oi\"\u001a1'!>\u0002MQ,7\u000f^!mi\u0016\u0014x+\u001b;i+:\u001c\b/Z2jM&,G\rU1si&$\u0018n\u001c8D_VtG\u000fK\u00025\u0003k\fQ\u0004^3ti\u0006cG/\u001a:XQ\u0016tGk\u001c9jG\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u0015\u0004k\u0005U\u0018\u0001\u0010;fgRLe-\u0012=jgR\u001c\u0018I\u001c3JM:{G/\u0012=jgR\u001cx\n\u001d;j_:\u001c\u0018J\u001c<bY&$w+\u001b;i\u0005>|Go\u001d;sCB\u001cVM\u001d<feND3ANA{\u0003\u0005\"Xm\u001d;De\u0016\fG/Z!mi\u0016\u0014Hk\u001c9jG^KG\u000f\u001b*bG.\fu/\u0019:fQ\r9\u0014Q_\u00010i\u0016\u001cHoQ8oM&<\u0007K]3tKJ4\u0018\r^5p]\u0006\u001b'o\\:t!\u0006\u0014H/\u001b;j_:\fE\u000e^3sCRLwN\u001c\u0015\u0004q\u0005U\u0018!\u0005;fgR$v\u000e]5d\t\u0016dW\r^5p]\"\u001a\u0011(!>\u0002/Q,7\u000f\u001e#fY\u0016$X-\u00138uKJt\u0017\r\u001c+pa&\u001c\u0007f\u0001\u001e\u0002v\u0006\u0011B/Z:u\t\u0016dW\r^3JM\u0016C\u0018n\u001d;tQ\rY\u0014Q_\u0001\ri\u0016\u001cH\u000fR3tGJL'-\u001a\u0015\u0004y\u0005U\u0018!\t;fgR$Um]2sS\n,WK\\1wC&d\u0017M\u00197f!\u0006\u0014H/\u001b;j_:\u001c\bfA\u001f\u0002v\u0006)C/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004}\u0005U\u0018!\t;fgR$Um]2sS\n,WK\u001c3fe6Kg.S:s!\u0006\u0014H/\u001b;j_:\u001c\bfA \u0002v\u0006\tE/Z:u\t\u0016\u001c8M]5cKVsG-\u001a:SKBd\u0017nY1uK\u0012\u0004\u0016M\u001d;ji&|gn],iK:\u0014V-Y:tS\u001etW.\u001a8u\u0013NLe\u000e\u0015:pOJ,7o\u001d\u0015\u0004\u0001\u0006U\u0018A\b;fgR$Um]2sS\n,\u0017\t^'j]&\u001b(\u000fU1si&$\u0018n\u001c8tQ\r\t\u0015Q_\u0001'i\u0016\u001cH\u000fR3tGJL'-Z+oI\u0016\u0014X*\u001b8JgJ\u0004\u0016M\u001d;ji&|gn]'jq\u0016$\u0007f\u0001\"\u0002v\u0006\u0019C/Z:u\t\u0016\u001c8M]5cKJ+\u0007o\u001c:u\u001fZ,'O]5eI\u0016t7i\u001c8gS\u001e\u001c\bfA\"\u0002v\u0006qC/Z:u\t\u0016\u001c8M]5cK\u0006sG\rT5tiR{\u0007/[2t/&$\bn\\;u\u0013:$XM\u001d8bYR{\u0007/[2tQ\r!\u0015Q_\u0001=i\u0016\u001cH\u000fR3tGJL'-\u001a#pKNtu\u000e\u001e$bS2<\u0006.\u001a8MSN$\u0018N\\4SK\u0006\u001c8/[4o[\u0016tG/S:V]\u0006,H\u000f[8sSj,G\rK\u0002F\u0003k\u0004")
public class TopicCommandWithAdminClientTest
extends KafkaServerTestHarness
implements RackAwareTest {
    private final int numPartitions;
    private final short defaultReplicationFactor = (short)1;
    private TopicCommand.AdminClientTopicService topicService;
    private Admin adminClient;
    private String testTopicName;
    private final TestName _testName = new TestName();

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Seq<KafkaConfig> generateConfigs() {
        None$ none$;
        None$ none$2;
        None$ none$3;
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        String x$2 = this.zkConnect();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_3 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_5 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_7 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_9 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_11 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_13 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        int x$4 = this.numPartitions();
        short x$5 = this.defaultReplicationFactor();
        boolean bl = true;
        boolean bl2 = true;
        None$ none$4 = none$3 = None$.MODULE$;
        none$3 = null;
        None$ x$8 = none$4;
        None$ none$5 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$9 = none$5;
        None$ none$6 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$10 = none$6;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n = 1;
        boolean bl7 = false;
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(6, x$2, bl, bl2, (Option<SecurityProtocol>)x$8, (Option<File>)x$9, (Option<Properties>)x$10, bl3, bl4, bl5, bl6, (Map<Object, String>)x$3, n, bl7, x$4, x$5).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props));
    }

    private int numPartitions() {
        return this.numPartitions;
    }

    private short defaultReplicationFactor() {
        return this.defaultReplicationFactor;
    }

    private TopicCommand.AdminClientTopicService topicService() {
        return this.topicService;
    }

    private void topicService_$eq(TopicCommand.AdminClientTopicService x$1) {
        this.topicService = x$1;
    }

    private Admin adminClient() {
        return this.adminClient;
    }

    private void adminClient_$eq(Admin x$1) {
        this.adminClient = x$1;
    }

    private String testTopicName() {
        return this.testTopicName;
    }

    private void testTopicName_$eq(String x$1) {
        this.testTopicName = x$1;
    }

    private TestName _testName() {
        return this._testName;
    }

    @Rule
    public TestName testName() {
        return this._testName();
    }

    public void assertExitCode(int expected, Function0<BoxedUnit> method) {
        Function2 & Serializable setExitProcedure_exitProcedure = (Function2 & Serializable)(exitCode, exitMessage) -> TopicCommandWithAdminClientTest.mockExitProcedure$1(BoxesRunTime.unboxToInt((Object)exitCode), exitMessage, expected);
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        Object var4_3 = null;
        try {
            Assertions$.MODULE$.intercept(method, ClassTag$.MODULE$.apply(RuntimeException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 78));
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    public void assertCheckArgsExitCode(int expected, TopicCommand.TopicCommandOptions options) {
        this.assertExitCode(expected, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> options.checkArgs());
    }

    public void createAndWaitTopic(TopicCommand.TopicCommandOptions opts) {
        this.topicService().createTopic(opts);
        this.waitForTopicCreated((String)opts.topic().get(), this.waitForTopicCreated$default$2());
    }

    public void waitForTopicCreated(String topicName, int timeout) {
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), topicName, 0, timeout);
    }

    public int waitForTopicCreated$default$2() {
        return 10000;
    }

    /*
     * WARNING - void declaration
     */
    @Before
    public void setup() {
        void mkString_end;
        Properties props = new Properties();
        props.put("bootstrap.servers", this.brokerList());
        this.adminClient_$eq(Admin.create((Properties)props));
        Admin apply_adminClient = this.adminClient();
        Object var3_2 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        LazyList lazyList = Random$.MODULE$.alphanumeric().take(10);
        if (lazyList == null) {
            throw null;
        }
        LazyList mkString_this = lazyList;
        String mkString_mkString_sep = "";
        String string = "";
        String mkString_start = "";
        Object var5_6 = null;
        string = null;
        Object var4_4 = null;
        Object var2_3 = null;
        this.testTopicName_$eq(new StringBuilder(1).append(this.testName().getMethodName()).append("-").append(IterableOnceOps.mkString$((IterableOnceOps)mkString_this, (String)mkString_start, (String)mkString_mkString_sep, (String)mkString_end)).toString());
    }

    @After
    public void close() {
        if (this.topicService() != null) {
            this.topicService().close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testParseAssignment() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        Object object;
        void $minus$greater$extension_y2;
        void apply_elems3;
        Object object2;
        void apply_elems4;
        Object object3;
        Map actualAssignment = TopicCommand$.MODULE$.parseReplicaAssignment("5:4,3:2,1:0");
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[3];
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4});
        List$ apply_this = List$.MODULE$;
        Object object4 = object3 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems4);
        Object var8_3 = null;
        arraySeq = null;
        object3 = null;
        Object $minus$greater$extension_y3 = object4;
        Integer $minus$greater$extension_$this = 0;
        Object var2_6 = null;
        Object var3_5 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, $minus$greater$extension_y3);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2});
        List$ apply_this2 = List$.MODULE$;
        Object object5 = object2 = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems3);
        Object var11_8 = null;
        arraySeq2 = null;
        object2 = null;
        Object object6 = object5;
        Integer $minus$greater$extension_$this2 = 1;
        Object var4_11 = null;
        object6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0});
        List$ apply_this3 = List$.MODULE$;
        Object object7 = object = IterableFactory.apply$((IterableFactory)apply_this3, (scala.collection.immutable.Seq)apply_elems2);
        Object var14_13 = null;
        arraySeq3 = null;
        object = null;
        Object object8 = object7;
        Integer $minus$greater$extension_$this3 = 2;
        Object var6_16 = null;
        object8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)((scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems)), (Object)actualAssignment);
    }

    @Test
    public void testParseAssignmentDuplicateEntries() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:5"), ClassTag$.MODULE$.apply(AdminCommandFailedException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
    }

    @Test
    public void testParseAssignmentPartitionsOfDifferentSize() {
        Assertions$.MODULE$.intercept((Function0 & Serializable)() -> TopicCommand$.MODULE$.parseReplicaAssignment("5:4:3,2:1"), ClassTag$.MODULE$.apply(AdminOperationException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
    }

    @Test
    public void testConfigOptWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--config", "cleanup.policy=compact"}));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName(), "--partitions", "3", "--delete-config", "cleanup.policy"}));
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--topic", this.testTopicName(), "--partitions", "3", "--replication-factor", "3", "--config", "cleanup.policy=compact"});
        opts.checkArgs();
        Assert.assertTrue((boolean)opts.hasCreateOption());
        Assert.assertEquals((Object)this.brokerList(), (Object)opts.bootstrapServer().get());
        Assert.assertEquals((Object)"cleanup.policy=compact", ((java.util.List)opts.topicConfig().get()).get(0));
    }

    @Test
    public void testCreate() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "1", "--topic", this.testTopicName()}));
        ((java.util.Set)this.adminClient().listTopics().names().get()).contains(this.testTopicName());
    }

    @Test
    public void testCreateWithDefaults() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultReplication() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)2L);
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)this.defaultReplicationFactor());
    }

    @Test
    public void testCreateWithDefaultPartitions() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replication-factor", "2"}));
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)partitions.size(), (long)this.numPartitions());
        Assert.assertEquals((long)((TopicPartitionInfo)partitions.get(0)).replicas().size(), (long)2L);
    }

    @Test
    public void testCreateWithConfigs() {
        ConfigResource configResource = new ConfigResource(ConfigResource.Type.TOPIC, this.testTopicName());
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", "delete.retention.ms=1000"}));
        Config configs = (Config)((java.util.Map)this.adminClient().describeConfigs(Collections.singleton(configResource)).all().get()).get(configResource);
        Assert.assertEquals((Object)1000, (Object)Integer.valueOf(configs.get("delete.retention.ms").value()));
    }

    @Test
    public void testCreateIfItAlreadyExists() {
        int numPartitions = 1;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
    }

    @Test
    public void testCreateWithReplicaAssignment() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--replica-assignment", "5:4,3:2,1:0", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        java.util.List partitions = ((TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).get(this.testTopicName())).partitions();
        Assert.assertEquals((long)3L, (long)partitions.size());
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{5, 4})), (Object)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(0)).replicas()).asScala()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id())));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{3, 2})), (Object)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(1)).replicas()).asScala()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.id())));
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 0})), (Object)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)partitions.get(2)).replicas()).asScala()).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.id())));
    }

    @Test
    public void testCreateWithInvalidReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", ((Object)32768).toString(), "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
    }

    @Test
    public void testCreateWithNegativeReplicationFactor() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
    }

    @Test
    public void testCreateWithAssignmentAndPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--partitions", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithAssignmentAndReplicationFactor() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--create", "--replica-assignment", "3:0,5:1", "--replication-factor", "2", "--topic", "testTopic"}));
    }

    @Test
    public void testCreateWithNegativePartitionCount() {
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--replication-factor", "1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
    }

    @Test
    public void testCreateWithUnspecifiedReplicationFactorAndPartitionsWithZkClient() {
        this.assertExitCode(1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> new TopicCommand.TopicCommandOptions(new String[]{"--create", "--zookeeper", "zk", "--topic", this.testTopicName()}).checkArgs());
    }

    @Test
    public void testInvalidTopicLevelConfig() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName(), "--config", "message.timestamp.type=boom"});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().createTopic(createOpts), ClassTag$.MODULE$.apply(ConfigException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
    }

    @Test
    public void testListTopics() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var1_1 = null;
        Object var2_2 = null;
        Assert.assertTrue((boolean)grabConsoleOutput_out.toString().contains(this.testTopicName()));
    }

    @Test
    public void testListTopicsWithWhitelist() {
        String topic1 = "kafka.testTopic1";
        String topic2 = "kafka.testTopic2";
        String topic3 = "oooof.testTopic1";
        .colon.colon asJavaCollectionConverter_i = new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic2, 2, (short)2), (List)new .colon.colon((Object)new NewTopic(topic3, 2, (short)2), (List)Nil$.MODULE$)));
        Object var8_4 = null;
        this.adminClient().createTopics(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic2, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(topic3, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--topic", "kafka.*"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var5_5 = null;
        Object var6_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertTrue((boolean)output.contains(topic2));
        Assert.assertFalse((boolean)output.contains(topic3));
    }

    @Test
    public void testListTopicsWithExcludeInternal() {
        String topic1 = "kafka.testTopic1";
        .colon.colon asJavaCollectionConverter_i = new .colon.colon((Object)new NewTopic(topic1, 2, (short)2), (List)new .colon.colon((Object)new NewTopic("__consumer_offsets", 2, (short)2), (List)Nil$.MODULE$));
        Object var6_2 = null;
        this.adminClient().createTopics(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i).asJavaCollection()).all().get();
        this.waitForTopicCreated(topic1, this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var3_3 = null;
        Object var4_4 = null;
        String output = grabConsoleOutput_out.toString();
        Assert.assertTrue((boolean)output.contains(topic1));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testAlterPartitionCount() {
        .colon.colon asJavaCollectionConverter_i = new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$);
        Object var1_1 = null;
        this.adminClient().createTopics(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "3"}));
        Assert.assertTrue((((TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get()).partitions().size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testAlterAssignment() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "3"}));
        TopicDescription topicDescription = (TopicDescription)((KafkaFuture)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).values().get(this.testTopicName())).get();
        Assert.assertTrue((topicDescription.partitions().size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)List$.MODULE$, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{4, 2})), (Object)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)topicDescription.partitions().get(2)).replicas()).asScala()).map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.id())));
    }

    @Test
    public void testAlterAssignmentWithMoreAssignmentThanPartitions() {
        .colon.colon asJavaCollectionConverter_i = new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$);
        Object var1_1 = null;
        this.adminClient().createTopics(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2,3:2", "--partitions", "3"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 397));
    }

    @Test
    public void testAlterAssignmentWithMorePartitionsThanAssignment() {
        .colon.colon asJavaCollectionConverter_i = new .colon.colon((Object)new NewTopic(this.testTopicName(), 2, (short)2), (List)Nil$.MODULE$);
        Object var1_1 = null;
        this.adminClient().createTopics(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i).asJavaCollection()).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--replica-assignment", "5:3,3:1,4:2", "--partitions", "6"})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 409));
    }

    @Test
    public void testAlterWithInvalidPartitionCount() {
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().alterTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "-1", "--topic", this.testTopicName()})), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
    }

    @Test
    public void testAlterWithUnspecifiedPartitionCount() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", this.brokerList(), "--alter", "--topic", this.testTopicName()}));
    }

    @Test
    public void testAlterWhenTopicDoesntExist() {
        TopicCommand.AdminClientTopicService adminClientTopicService;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--partitions", "1"});
        Admin apply_adminClient = this.adminClient();
        TopicCommand.AdminClientTopicService adminClientTopicService2 = adminClientTopicService = new TopicCommand.AdminClientTopicService(apply_adminClient);
        Object var3_2 = null;
        adminClientTopicService = null;
        TopicCommand.AdminClientTopicService topicService = adminClientTopicService2;
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> topicService.alterTopic(alterOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 437));
    }

    @Test
    public void testIfExistsAndIfNotExistsOptionsInvalidWithBootstrapServers() {
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", "server1:9092", "--alter", "--if-exists", "--topic", this.testTopicName(), "--partitions", "1"}));
        this.assertCheckArgsExitCode(1, new TopicCommand.TopicCommandOptions(new String[]{"--bootstrap-server", "server1:9092", "--create", "--if-not-exists", "--topic", this.testTopicName(), "--partitions", "1", "--replication-factor", "1"}));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreateAlterTopicWithRackAware() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[6];
        String string = "rack1";
        Integer $minus$greater$extension_$this = 0;
        Object var8_2 = null;
        string = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Integer $minus$greater$extension_$this2 = 1;
        Object var10_4 = null;
        string2 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Integer $minus$greater$extension_$this3 = 2;
        Object var12_6 = null;
        string3 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Integer $minus$greater$extension_$this4 = 3;
        Object var14_8 = null;
        string4 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Integer $minus$greater$extension_$this5 = 4;
        Object var16_10 = null;
        string5 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Integer $minus$greater$extension_$this6 = 5;
        Object var18_12 = null;
        string6 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map rackInfo = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitions).toString(), "--replication-factor", ((Object)replicationFactor).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Map assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
        int alteredNumPartitions = 36;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)alteredNumPartitions).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.testTopicName()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        assignment = (Map)this.zkClient().getReplicaAssignmentForTopics((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2;
            Integer n;
            Integer n2;
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$2._1();
            Seq replicas = (Seq)x0$2._2();
            Integer n3 = n2 = Integer.valueOf(tp.partition());
            n2 = null;
            Integer n4 = n = n3;
            n = null;
            Integer $minus$greater$extension_$this = n4;
            Tuple2 tuple22 = tuple2 = new Tuple2((Object)$minus$greater$extension_$this, (Object)replicas);
            Object var4_5 = null;
            tuple2 = null;
            Tuple2 tuple23 = tuple22;
            return tuple23;
        });
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)rackInfo, rackInfo.size(), alteredNumPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    @Test
    public void testConfigPreservationAcrossPartitionAlteration() {
        int numPartitionsOriginal = 1;
        String cleanupKey = "cleanup.policy";
        String cleanupVal = "compact";
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsOriginal).toString(), "--replication-factor", "1", "--config", new StringBuilder(1).append(cleanupKey).append("=").append(cleanupVal).toString(), "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        Properties props = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(40).append("Properties after creation don't contain ").append(cleanupKey).toString(), (boolean)props.containsKey(cleanupKey));
        Assert.assertTrue((String)"Properties after creation have incorrect value", (boolean)props.getProperty(cleanupKey).equals(cleanupVal));
        this.zkClient().makeSurePersistentPathExists(ConfigEntityChangeNotificationZNode$.MODULE$.path());
        int numPartitionsModified = 3;
        TopicCommand.TopicCommandOptions alterOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", ((Object)numPartitionsModified).toString(), "--topic", this.testTopicName()});
        this.topicService().alterTopic(alterOpts);
        Properties newProps = this.adminZkClient().fetchEntityConfig(ConfigType$.MODULE$.Topic(), this.testTopicName());
        Assert.assertTrue((String)new StringBuilder(34).append("Updated properties do not contain ").append(cleanupKey).toString(), (boolean)newProps.containsKey(cleanupKey));
        Assert.assertTrue((String)"Updated properties have incorrect value", (boolean)newProps.getProperty(cleanupKey).equals(cleanupVal));
    }

    @Test
    public void testTopicDeletion() {
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()});
        this.createAndWaitTopic(createOpts);
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        String deletePath = DeleteTopicsTopicZNode$.MODULE$.path(this.testTopicName());
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deletePath));
        this.topicService().deleteTopic(deleteOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), this.testTopicName(), 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteInternalTopic() {
        TopicCommand.TopicCommandOptions createOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"});
        this.createAndWaitTopic(createOffsetTopicOpts);
        TopicCommand.TopicCommandOptions deleteOffsetTopicOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", "__consumer_offsets"});
        String deleteOffsetTopicPath = DeleteTopicsTopicZNode$.MODULE$.path("__consumer_offsets");
        Assert.assertFalse((String)"Delete path for topic shouldn't exist before deletion.", (boolean)this.zkClient().pathExists(deleteOffsetTopicPath));
        this.topicService().deleteTopic(deleteOffsetTopicOpts);
        TestUtils$.MODULE$.verifyTopicDeletion(this.zkClient(), "__consumer_offsets", 1, (Seq<KafkaServer>)this.servers());
    }

    @Test
    public void testDeleteIfExists() {
        TopicCommand.TopicCommandOptions deleteOpts = new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()});
        Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.topicService().deleteTopic(deleteOpts), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 545));
    }

    @Test
    public void testDescribe() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 2, (short)2))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_1 = null;
        Object var3_2 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)3L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:2").toString());
    }

    @Test
    public void testDescribeUnavailablePartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 6, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            TopicDescription testTopicDescription = (TopicDescription)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.adminClient().describeTopics(Collections.singletonList(this.testTopicName())).all().get()).asScala()).apply((Object)this.testTopicName());
            int partitionOnBroker0 = ((TopicPartitionInfo)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDescription.partitions()).asScala()).find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$1(x$8))).get()).partition();
            this.killBroker(0);
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$2(this, partitionOnBroker0)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$7(this), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                Thread.sleep(Math.min(l, l2));
            }
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName(), "--unavailable-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var7_6 = null;
            Object var8_7 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertTrue((boolean)rows[0].contains("Leader: none\tReplicas: 0\tIsr:"));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderReplicatedPartitions() {
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitions$1(x$12)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var3_2 = null;
            Object var4_3 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitions$1(x$13)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, this.testTopicName(), 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_3 = null;
            Object var5_4 = null;
            Assert.assertTrue((boolean)grabConsoleOutput_out.toString().split("\n")[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress() {
        void apply_elems;
        String string;
        void apply_elems2;
        HashMap configMap = new HashMap();
        short replicationFactor = 1;
        int partitions = 1;
        TopicPartition tp = new TopicPartition(this.testTopicName(), 0);
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), partitions, replicationFactor).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.testTopicName(), 10, -1);
        Buffer brokerIds = (Buffer)this.servers().map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToInteger((int)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(x$14)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.setReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), 1);
        TopicDescription testTopicDesc = (TopicDescription)((java.util.Map)this.adminClient().describeTopics(Collections.singleton(this.testTopicName())).all().get()).get(this.testTopicName());
        TopicPartitionInfo firstPartition = (TopicPartitionInfo)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(testTopicDesc.partitions()).asScala()).head();
        Buffer replicasOfFirstPartition = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(firstPartition.replicas()).asScala()).map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.id()));
        int targetReplica = BoxesRunTime.unboxToInt((Object)((IterableOps)brokerIds.diff((Seq)replicasOfFirstPartition)).head());
        this.adminClient().alterPartitionReassignments(Collections.singletonMap(tp, Optional.of(new NewPartitionReassignment(Collections.singletonList(targetReplica)))));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(this, tp)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Reassignment didn't add the second node", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var16_14 = null;
        Object var17_15 = null;
        String[] simpleDescribeOutputRows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertTrue((boolean)simpleDescribeOutputRows[0].startsWith(new StringBuilder(7).append("Topic: ").append(this.testTopicName()).toString()));
        Assert.assertEquals((long)2L, (long)simpleDescribeOutputRows.length);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-replicated-partitions"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out2.toString();
        Object var19_18 = null;
        Object var20_19 = null;
        string = null;
        String underReplicatedOutput = string2;
        Assert.assertEquals((String)"--under-replicated-partitions shouldn't return anything", (Object)"", (Object)underReplicatedOutput);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        TestUtils$.MODULE$.removeReplicationThrottleForPartitions(this.adminClient(), (Seq<Object>)brokerIds, (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)));
        TestUtils$.MODULE$.waitForAllReassignmentsToComplete(this.adminClient(), 100L);
    }

    @Test
    public void testDescribeAtMinIsrPartitions() {
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "4");
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)6).configs(configMap))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            this.killBroker(1);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--at-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var4_2 = null;
            Object var5_3 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(this.testTopicName()).toString()));
            Assert.assertEquals((long)1L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeUnderMinIsrPartitionsMixed() {
        String underMinIsrTopic = "under-min-isr-topic";
        String notUnderMinIsrTopic = "not-under-min-isr-topic";
        String offlineTopic = "offline-topic";
        String fullyReplicatedTopic = "fully-replicated-topic";
        HashMap<String, String> configMap = new HashMap<String, String>();
        configMap.put("min.insync.replicas", "6");
        this.adminClient().createTopics(Arrays.asList(new NewTopic(underMinIsrTopic, 1, (short)6).configs(configMap), new NewTopic(notUnderMinIsrTopic, 1, (short)6), new NewTopic(offlineTopic, Collections.singletonMap(0, Collections.singletonList(0))), new NewTopic(fullyReplicatedTopic, Collections.singletonMap(0, Arrays.asList(1, 2, 3))))).all().get();
        this.waitForTopicCreated(underMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(notUnderMinIsrTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(offlineTopic, this.waitForTopicCreated$default$2());
        this.waitForTopicCreated(fullyReplicatedTopic, this.waitForTopicCreated$default$2());
        try {
            this.killBroker(0);
            Buffer aliveServers = (Buffer)this.servers().filterNot((Function1 & Serializable)x$16 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnderMinIsrPartitionsMixed$1(x$16)));
            TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)aliveServers, underMinIsrTopic, 0, 15000L);
            JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--under-min-isr-partitions"}));
            ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
            try {
                Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
            }
            finally {
                Console$.MODULE$.out().flush();
            }
            Object var9_7 = null;
            Object var10_8 = null;
            String[] rows = grabConsoleOutput_out.toString().split("\n");
            Assert.assertTrue((boolean)rows[0].startsWith(new StringBuilder(8).append("\tTopic: ").append(underMinIsrTopic).toString()));
            Assert.assertTrue((boolean)rows[1].startsWith(new StringBuilder(8).append("\tTopic: ").append(offlineTopic).toString()));
            Assert.assertEquals((long)2L, (long)rows.length);
        }
        finally {
            this.restartDeadBrokers();
        }
    }

    @Test
    public void testDescribeReportOverriddenConfigs() {
        String string;
        String config = "file.delete.delay.ms=1000";
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "2", "--replication-factor", "2", "--topic", this.testTopicName(), "--config", config}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions((String[])Array$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class))));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var3_2 = null;
        Object var4_3 = null;
        string = null;
        String output = string2;
        Assert.assertTrue((String)new StringBuilder(38).append("Describe output should have contained ").append(config).toString(), (boolean)output.contains(config));
    }

    @Test
    public void testDescribeAndListTopicsWithoutInternalTopics() {
        String string;
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", this.testTopicName()}));
        this.createAndWaitTopic(new TopicCommand.TopicCommandOptions(new String[]{"--partitions", "1", "--replication-factor", "1", "--topic", "__consumer_offsets"}));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--describe", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        String string2 = string = grabConsoleOutput_out.toString();
        Object var2_1 = null;
        Object var3_2 = null;
        string = null;
        String output = string2;
        Assert.assertTrue((String)new StringBuilder(29).append("Output should have contained ").append(this.testTopicName()).toString(), (boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f2 = (JFunction0.mcV.sp & Serializable)() -> this.topicService().listTopics(new TopicCommand.TopicCommandOptions(new String[]{"--list", "--exclude-internal"}));
        ByteArrayOutputStream grabConsoleOutput_out2 = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out2, (Function0)grabConsoleOutput_f2);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_6 = null;
        Object var7_7 = null;
        output = grabConsoleOutput_out2.toString();
        Assert.assertTrue((boolean)output.contains(this.testTopicName()));
        Assert.assertFalse((boolean)output.contains("__consumer_offsets"));
    }

    @Test
    public void testDescribeDoesNotFailWhenListingReassignmentIsUnauthorized() {
        this.adminClient_$eq((Admin)Mockito.spy((Object)this.adminClient()));
        Admin apply_adminClient = this.adminClient();
        Object var5_1 = null;
        this.topicService_$eq(new TopicCommand.AdminClientTopicService(apply_adminClient));
        ((Admin)Mockito.doReturn((Object)AdminClientTestUtils.listPartitionReassignmentsResult((Throwable)new ClusterAuthorizationException("Unauthorized")), (Object[])new Object[]{null}).when((Object)this.adminClient())).listPartitionReassignments();
        this.adminClient().createTopics(Collections.singletonList(new NewTopic(this.testTopicName(), 1, (short)1))).all().get();
        this.waitForTopicCreated(this.testTopicName(), this.waitForTopicCreated$default$2());
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> this.topicService().describeTopic(new TopicCommand.TopicCommandOptions(new String[]{"--topic", this.testTopicName()}));
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var2_2 = null;
        Object var3_3 = null;
        String[] rows = grabConsoleOutput_out.toString().split("\n");
        Assert.assertEquals((long)2L, (long)rows.length);
        rows[0].startsWith(new StringBuilder(23).append("Topic:").append(this.testTopicName()).append("\tPartitionCount:1").toString());
    }

    private static final Nothing$ mockExitProcedure$1(int exitCode, Option exitMessage, int expected$1) {
        Assert.assertEquals((long)expected$1, (long)exitCode);
        throw new RuntimeException();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$1(TopicPartitionInfo x$8) {
        return x$8.leader().id() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$3(KafkaServer x$9) {
        return x$9.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$5(TopicCommandWithAdminClientTest $this, MetadataResponse.TopicMetadata x$10) {
        return x$10.topic().equals($this.testTopicName());
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$6(int partitionOnBroker0$1, MetadataResponse.PartitionMetadata x$11) {
        return x$11.partition() == partitionOnBroker0$1;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$4(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1, boolean result, KafkaServer server) {
        boolean x$4;
        boolean x$3;
        ListenerName x$2;
        void apply_elems;
        MetadataCache qual$1 = server.dataPlaneRequestProcessor().metadataCache();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{$this.testTopicName()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        Seq topicMetadatas = qual$1.getTopicMetadata((Set)x$1, x$2 = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), x$3 = qual$1.getTopicMetadata$default$3(), x$4 = qual$1.getTopicMetadata$default$4());
        Option testPartitionMetadata = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)topicMetadatas.find((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$5($this, x$10))).get()).partitionMetadata()).asScala()).find((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$6(partitionOnBroker0$1, x$11)));
        if (None$.MODULE$.equals(testPartitionMetadata)) {
            throw Assertions$.MODULE$.fail("Partition metadata is not found in metadata cache", new Position("TopicCommandWithAdminClientTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 587));
        }
        if (!(testPartitionMetadata instanceof Some)) throw new MatchError((Object)testPartitionMetadata);
        MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((Some)testPartitionMetadata).value();
        if (!result) return false;
        Errors errors = metadata.error;
        Errors errors2 = Errors.LEADER_NOT_AVAILABLE;
        if (errors != null) {
            if (!errors.equals(errors2)) return false;
            return true;
        }
        if (errors2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnavailablePartitions$2(TopicCommandWithAdminClientTest $this, int partitionOnBroker0$1) {
        return BoxesRunTime.unboxToBoolean((Object)((IterableOnceOps)$this.servers().filterNot((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$3(x$9)))).foldLeft((Object)true, (Function2 & Serializable)(result, server) -> BoxesRunTime.boxToBoolean((boolean)TopicCommandWithAdminClientTest.$anonfun$testDescribeUnavailablePartitions$4($this, partitionOnBroker0$1, BoxesRunTime.unboxToBoolean((Object)result), server))));
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnavailablePartitions$7(TopicCommandWithAdminClientTest $this) {
        return new StringBuilder(41).append("Partition metadata for ").append($this.testTopicName()).append(" is not propagated").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitions$1(KafkaServer x$12) {
        return x$12.config().brokerId() == 0;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitions$1(KafkaServer x$13) {
        return x$13.config().brokerId() == 0;
    }

    public static final /* synthetic */ int $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$1(KafkaServer x$14) {
        return x$14.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$3(TopicCommandWithAdminClientTest $this, TopicPartition tp$1) {
        return !((PartitionReassignment)((java.util.Map)$this.adminClient().listPartitionReassignments(Collections.singleton(tp$1)).reassignments().get()).get(tp$1)).addingReplicas().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$testDescribeUnderReplicatedPartitionsWhenReassignmentIsInProgress$4() {
        return "Reassignment didn't add the second node";
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeUnderMinIsrPartitionsMixed$1(KafkaServer x$16) {
        return x$16.config().brokerId() == 0;
    }

    public TopicCommandWithAdminClientTest() {
        this.numPartitions = 1;
    }
}

