/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.api.BaseAdminIntegrationTest;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.log.Log;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.security.authorizer.AclEntry$;
import kafka.server.Defaults$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.AlterReplicaLogDirsOptions;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.kafka.clients.admin.ConsumerGroupListing;
import org.apache.kafka.clients.admin.CreatePartitionsOptions;
import org.apache.kafka.clients.admin.CreatePartitionsResult;
import org.apache.kafka.clients.admin.CreateTopicsOptions;
import org.apache.kafka.clients.admin.DeleteConsumerGroupOffsetsResult;
import org.apache.kafka.clients.admin.DeleteConsumerGroupsResult;
import org.apache.kafka.clients.admin.DeleteRecordsResult;
import org.apache.kafka.clients.admin.DeletedRecords;
import org.apache.kafka.clients.admin.DescribeClusterResult;
import org.apache.kafka.clients.admin.DescribeConfigsResult;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsOptions;
import org.apache.kafka.clients.admin.DescribeConsumerGroupsResult;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.ElectLeadersOptions;
import org.apache.kafka.clients.admin.ElectLeadersResult;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.KafkaAdminClientTest;
import org.apache.kafka.clients.admin.ListConsumerGroupsResult;
import org.apache.kafka.clients.admin.MemberDescription;
import org.apache.kafka.clients.admin.MemberToRemove;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewPartitions;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.RecordsToDelete;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupOptions;
import org.apache.kafka.clients.admin.RemoveMembersFromConsumerGroupResult;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.ConsumerGroupState;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ElectionNotNeededException;
import org.apache.kafka.common.errors.EligibleLeadersNotAvailableException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.GroupSubscribedToTopicException;
import org.apache.kafka.common.errors.InterruptException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.LeaderNotAvailableException;
import org.apache.kafka.common.errors.NotLeaderForPartitionException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.PreferredLeaderNotAvailableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapFactory;
import scala.collection.MapOps;
import scala.collection.MapView;
import scala.collection.Seq$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StrictOptimizedSeqOps;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0005\rea\u0001\u0002'N\u0001ICQa\u0016\u0001\u0005\u0002aCqA\u0017\u0001C\u0002\u0013\u00051\f\u0003\u0004e\u0001\u0001\u0006I\u0001\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0011\u0019i\u0007\u0001)A\u0005O\"9a\u000e\u0001b\u0001\n\u0003y\u0007BB>\u0001A\u0003%\u0001\u000fC\u0005}\u0001\u0001\u0007\t\u0019!C\u0005{\"Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0011)\t9\u0002\u0001a\u0001\u0002\u0003\u0006KA \u0005\n\u00033\u0001!\u0019!C\u0005\u00037A\u0001\"!\u0011\u0001A\u0003%\u0011Q\u0004\u0005\b\u0003\u0007\u0002A\u0011IA#\u0011\u001d\t)\u0006\u0001C!\u0003\u000bBq!a\u0018\u0001\t\u0003\t)\u0005C\u0004\u0002j\u0001!\t!!\u0012\t\u000f\u00055\u0004\u0001\"\u0001\u0002F!9\u0011\u0011\u000f\u0001\u0005\u0002\u0005\u0015\u0003bBA;\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003s\u0002A\u0011AA#\u0011\u001d\ti\b\u0001C\u0001\u0003\u000bBq!!!\u0001\t\u0003\t)\u0005C\u0004\u0002\u0006\u0002!\t!!\u0012\t\u000f\u0005%\u0005\u0001\"\u0001\u0002F!9\u0011Q\u0012\u0001\u0005\u0002\u0005\u0015\u0003bBAI\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003+\u0003A\u0011AA#\u0011\u001d\tI\n\u0001C\u0001\u0003\u000bBq!!(\u0001\t\u0003\t)\u0005C\u0004\u0002\"\u0002!\t!!\u0012\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002F!9\u0011\u0011\u0016\u0001\u0005\u0002\u0005\u0015\u0003bBAW\u0001\u0011\u0005\u0011Q\t\u0005\b\u0003c\u0003A\u0011AA#\u0011\u001d\t)\f\u0001C\u0005\u0003oCq!!7\u0001\t\u0013\tY\u000eC\u0004\u0002r\u0002!\t!!\u0012\t\u000f\u0005U\b\u0001\"\u0001\u0002F!9\u0011\u0011 \u0001\u0005\u0002\u0005\u0015\u0003bBA\u007f\u0001\u0011\u0005\u0011Q\t\u0005\b\u0005\u0003\u0001A\u0011AA#\u0011\u001d\u0011)\u0001\u0001C\u0001\u0003\u000bBqA!\u0003\u0001\t\u0003\t)\u0005C\u0004\u0003\u000e\u0001!\t!!\u0012\t\u000f\tE\u0001\u0001\"\u0001\u0002F!9!Q\u0003\u0001\u0005\u0002\u0005\u0015\u0003b\u0002B\r\u0001\u0011\u0005\u0011Q\t\u0005\b\u0005;\u0001A\u0011AA#\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0003\u000bBqA!\n\u0001\t\u0003\t)\u0005C\u0004\u0003*\u0001!\t!!\u0012\t\u000f\t5\u0002\u0001\"\u0001\u0002F!9!\u0011\u0007\u0001\u0005\u0002\u0005\u0015\u0003b\u0002B\u001b\u0001\u0011\u0005\u0011Q\t\u0005\b\u0005s\u0001A\u0011AA#\u0011\u001d\u0011i\u0004\u0001C\u0001\u0003\u000bBqA!\u0011\u0001\t\u0003\t)\u0005C\u0004\u0003F\u0001!\t!!\u0012\t\u000f\t%\u0003\u0001\"\u0001\u0002F!9!Q\n\u0001\u0005\u0002\u0005\u0015\u0003b\u0002B)\u0001\u0011\u0005\u0011Q\t\u0005\b\u0005+\u0002A\u0011AA#\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003\u000bBqAa\u001a\u0001\t\u0003\t)\u0005C\u0004\u0003n\u0001!\t!!\u0012\t\u000f\tM\u0004\u0001\"\u0001\u0002F!9!\u0011\u0010\u0001\u0005\u0002\tm\u0004\"\u0003BR\u0001E\u0005I\u0011\u0001BS\u0011\u001d\u0011Y\f\u0001C\u0001\u0005{CqA!2\u0001\t\u0013\t)eB\u0004\u0003H6C\tA!3\u0007\r1k\u0005\u0012\u0001Bf\u0011\u00199\u0006\n\"\u0001\u0003T\"9!Q\u001b%\u0005\u0002\t]\u0007b\u0002Bv\u0011\u0012\u0005!Q\u001e\u0002\u001e!2\f\u0017N\u001c;fqR\fE-\\5o\u0013:$Xm\u001a:bi&|g\u000eV3ti*\u0011ajT\u0001\u0004CBL'\"\u0001)\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0015\t\u0003)Vk\u0011!T\u0005\u0003-6\u0013\u0001DQ1tK\u0006#W.\u001b8J]R,wM]1uS>tG+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\f\u0005\u0002U\u0001\u0005)Ao\u001c9jGV\tA\f\u0005\u0002^E6\taL\u0003\u0002`A\u0006!A.\u00198h\u0015\u0005\t\u0017\u0001\u00026bm\u0006L!a\u00190\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005I\u0001/\u0019:uSRLwN\\\u000b\u0002OB\u0011\u0001n[\u0007\u0002S*\t!.A\u0003tG\u0006d\u0017-\u0003\u0002mS\n\u0019\u0011J\u001c;\u0002\u0015A\f'\u000f^5uS>t\u0007%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0003A\u0004\"!]=\u000e\u0003IT!a\u001d;\u0002\r\r|W.\\8o\u0015\t\u0001VO\u0003\u0002wo\u00061\u0011\r]1dQ\u0016T\u0011\u0001_\u0001\u0004_J<\u0017B\u0001>s\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\u001bEJ|7.\u001a:M_\u001e<WM]\"p]\u001aLwMU3t_V\u00148-Z\u000b\u0002}B\u0019q0!\u0002\u000e\u0005\u0005\u0005!bAA\u0002e\u000611m\u001c8gS\u001eLA!a\u0002\u0002\u0002\tq1i\u001c8gS\u001e\u0014Vm]8ve\u000e,\u0017A\b2s_.,'\u000fT8hO\u0016\u00148i\u001c8gS\u001e\u0014Vm]8ve\u000e,w\fJ3r)\u0011\ti!a\u0005\u0011\u0007!\fy!C\u0002\u0002\u0012%\u0014A!\u00168ji\"A\u0011QC\u0005\u0002\u0002\u0003\u0007a0A\u0002yIE\n1D\u0019:pW\u0016\u0014Hj\\4hKJ\u001cuN\u001c4jOJ+7o\\;sG\u0016\u0004\u0013\u0001F2iC:<W\r\u001a\"s_.,'\u000fT8hO\u0016\u00148/\u0006\u0002\u0002\u001eA1\u0011qDA\u0015\u0003[i!!!\t\u000b\t\u0005\r\u0012QE\u0001\b[V$\u0018M\u00197f\u0015\r\t9#[\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0016\u0003C\u00111aU3u!\u0011\ty#!\u0010\u000f\t\u0005E\u0012\u0011\b\t\u0004\u0003gIWBAA\u001b\u0015\r\t9$U\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005m\u0012.\u0001\u0004Qe\u0016$WMZ\u0005\u0004G\u0006}\"bAA\u001eS\u0006)2\r[1oO\u0016$'I]8lKJdunZ4feN\u0004\u0013!B:fiV\u0003HCAA\u0007Q\ri\u0011\u0011\n\t\u0005\u0003\u0017\n\t&\u0004\u0002\u0002N)\u0019\u0011qJ<\u0002\u000b),h.\u001b;\n\t\u0005M\u0013Q\n\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3ADA-!\u0011\tY%a\u0017\n\t\u0005u\u0013Q\n\u0002\u0006\u0003\u001a$XM]\u0001\ni\u0016\u001cHo\u00117pg\u0016D3aDA2!\u0011\tY%!\u001a\n\t\u0005\u001d\u0014Q\n\u0002\u0005)\u0016\u001cH/A\u0007uKN$H*[:u\u001d>$Wm\u001d\u0015\u0004!\u0005\r\u0014!\r;fgR\u001c%/Z1uK\u0016C\u0018n\u001d;j]\u001e$v\u000e]5dgRC'o\\<U_BL7-\u0012=jgR\u001cX\t_2faRLwN\u001c\u0015\u0004#\u0005\r\u0014a\u0005;fgRlU\r^1eCR\f'+\u001a4sKND\u0007f\u0001\n\u0002d\u0005aB/Z:u\t\u0016\u001c8M]5cK:{g.\u0012=jgRLgn\u001a+pa&\u001c\u0007fA\n\u0002d\u0005\u0019B/Z:u\t\u0016\u001c8M]5cK\u000ecWo\u001d;fe\"\u001aA#a\u0019\u0002'Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3M_\u001e$\u0015N]:)\u0007U\t\u0019'\u0001\u000euKN$H)Z:de&\u0014WMU3qY&\u001c\u0017\rT8h\t&\u00148\u000fK\u0002\u0017\u0003G\nq\u0003^3ti\u0006cG/\u001a:SKBd\u0017nY1M_\u001e$\u0015N]:)\u0007]\t\u0019'A\u000euKN$H)Z:de&\u0014W-\u00118e\u00032$XM]\"p]\u001aLwm\u001d\u0015\u00041\u0005\r\u0014\u0001\u0006;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7\u000fK\u0002\u001a\u0003G\n!\u0004^3tiN+Wm[!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3AGA2\u0003q!Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]RD3aGA2\u0003\u0011\"Xm\u001d;M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bf\u0001\u000f\u0002d\u00059D/Z:u%\u0016\u0004H.[2b\u0007\u0006tg)\u001a;dQ\u001a\u0013x.\u001c'pON#\u0018M\u001d;PM\u001a\u001cX\r^!gi\u0016\u0014H)\u001a7fi\u0016\u0014VmY8sIND3!HA2\u0003\t\"Xm\u001d;BYR,'\u000fT8h\t&\u00148/\u00114uKJ$U\r\\3uKJ+7m\u001c:eg\"\u001aa$a\u0019\u0002KQ,7\u000f^(gMN,Go\u001d$peRKW.Z:BMR,'\u000fR3mKR,'+Z2pe\u0012\u001c\bfA\u0010\u0002d\u0005iB/Z:u\u0007>t7/^7f\u0003\u001a$XM\u001d#fY\u0016$XMU3d_J$7\u000fK\u0002!\u0003G\na\u0004^3ti\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t/&$\b.\u0012=dKB$\u0018n\u001c8)\u0007\u0005\n\u0019'A\u000euKN$H)Z:de&\u0014WmQ8oM&<7OR8s)>\u0004\u0018n\u0019\u0015\u0004E\u0005\r\u0014!H:vEN\u001c'/\u001b2f\u0003:$w+Y5u\r>\u0014\u0018i]:jO:lWM\u001c;\u0015\r\u00055\u0011\u0011XA^\u0011\u0019Q6\u00051\u0001\u0002.!9\u0011QX\u0012A\u0002\u0005}\u0016\u0001C2p]N,X.\u001a:\u0011\u0011\u0005\u0005\u0017\u0011ZAg\u0003\u001bl!!a1\u000b\t\u0005u\u0016Q\u0019\u0006\u0004\u0003\u000f$\u0018aB2mS\u0016tGo]\u0005\u0005\u0003\u0017\f\u0019MA\u0007LC\u001a\\\u0017mQ8ogVlWM\u001d\t\u0006Q\u0006=\u00171[\u0005\u0004\u0003#L'!B!se\u0006L\bc\u00015\u0002V&\u0019\u0011q[5\u0003\t\tKH/Z\u0001\fg\u0016tGMU3d_J$7\u000f\u0006\u0005\u0002\u000e\u0005u\u00171^Ax\u0011\u001d\ty\u000e\na\u0001\u0003C\f\u0001\u0002\u001d:pIV\u001cWM\u001d\t\t\u0003G\f9/!4\u0002N6\u0011\u0011Q\u001d\u0006\u0005\u0003?\f)-\u0003\u0003\u0002j\u0006\u0015(!D&bM.\f\u0007K]8ek\u000e,'\u000f\u0003\u0004\u0002n\u0012\u0002\raZ\u0001\u000b]Vl'+Z2pe\u0012\u001c\b\"\u00028%\u0001\u0004\u0001\u0018a\u0006;fgRLeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\r)\u00131M\u0001\u0012i\u0016\u001cH/Q2m\u001fB,'/\u0019;j_:\u001c\bf\u0001\u0014\u0002d\u0005\u0001B/Z:u\t\u0016d\u0017-_3e\u00072|7/\u001a\u0015\u0004O\u0005\r\u0014A\u0004;fgR4uN]2f\u00072|7/\u001a\u0015\u0004Q\u0005\r\u0014A\u0007;fgRl\u0015N\\5nk6\u0014V-];fgR$\u0016.\\3pkR\u001c\bfA\u0015\u0002d\u0005AB/Z:u\u0007\u0006dG.\u00138GY&<\u0007\u000e\u001e+j[\u0016|W\u000f^:)\u0007)\n\u0019'\u0001\nuKN$8i\u001c8tk6,'o\u0012:pkB\u001c\bfA\u0016\u0002d\u0005qB/Z:u\t\u0016dW\r^3D_:\u001cX/\\3s\u000fJ|W\u000f](gMN,Go\u001d\u0015\u0004Y\u0005\r\u0014!\u0007;fgR,E.Z2u!J,g-\u001a:sK\u0012dU-\u00193feND3!LA2\u0003\u0019\"Xm\u001d;FY\u0016\u001cG/\u00168dY\u0016\fg\u000eT3bI\u0016\u00148OR8s\u001f:,\u0007+\u0019:uSRLwN\u001c\u0015\u0004]\u0005\r\u0014\u0001\u000b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\r>\u0014X*\u00198z!\u0006\u0014H/\u001b;j_:\u001c\bfA\u0018\u0002d\u00059C/Z:u\u000b2,7\r^+oG2,\u0017M\u001c'fC\u0012,'o\u001d$pe\u0006cG\u000eU1si&$\u0018n\u001c8tQ\r\u0001\u00141M\u0001,i\u0016\u001cH/\u00127fGR,fn\u00197fC:dU-\u00193feN4uN]+oW:|wO\u001c)beRLG/[8og\"\u001a\u0011'a\u0019\u0002QQ,7\u000f^#mK\u000e$XK\\2mK\u0006tG*Z1eKJ\u001cx\u000b[3o\u001d>d\u0015N^3Ce>\\WM]:)\u0007I\n\u0019'A\u000euKN$X\t\\3diVs7\r\\3b]2+\u0017\rZ3sg:{w\u000e\u001d\u0015\u0004g\u0005\r\u0014A\b;fgR,E.Z2u+:\u001cG.Z1o\u0019\u0016\fG-\u001a:t\u0003:$gj\\8qQ\r!\u00141M\u00019i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|wOT8o%\u0016\f7o]5h]&tw\rU1si&$\u0018n\u001c8tQ\r)\u00141M\u00012i\u0016\u001cH\u000fT5tiJ+\u0017m]:jO:lWM\u001c;t\t>,7OT8u'\"|w\u000fR3mKR,G\rU1si&$\u0018n\u001c8tQ\r1\u00141M\u0001!i\u0016\u001cHOV1mS\u0012Len\u0019:f[\u0016tG/\u00197BYR,'oQ8oM&<7\u000fK\u00028\u0003G\nA\u0007^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001cH)\u001a7fi\u0016\fe\u000eZ*fi\n\u0013xn[3s\u0007>tg-[4tQ\rA\u00141M\u0001/i\u0016\u001cH/\u00138de\u0016lWM\u001c;bY\u0006cG/\u001a:D_:4\u0017nZ:EK2,G/\u001a\"s_.,'oQ8oM&<7\u000fK\u0002:\u0003G\n!\u0005^3ti&sg/\u00197jI&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001c\bf\u0001\u001e\u0002d\u00051C/Z:u\u0013:4\u0018\r\\5e\u00032$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e^:)\u0007m\n\u0019'\u0001\nuKN$Hj\u001c8h)>\u0004\u0018n\u0019(b[\u0016\u001c\bf\u0001\u001f\u0002d\u0005!C/Z:u\t\u0016\u001c8M]5cK\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fK\u0002>\u0003G\nA\u0006^3ti&s7M]3nK:$\u0018\r\\!mi\u0016\u00148i\u001c8gS\u001e\u001chi\u001c:M_\u001e$$\u000eT8h\u0019\u00164X\r\\:)\u0007y\u0012I\u0006\u0005\u0003\u0002L\tm\u0013\u0002\u0002B/\u0003\u001b\u0012a!S4o_J,\u0007f\u0001 \u0002d\u00059E/Z:u\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON4uN\u001d'pORRGj\\4MKZ,Gn]\"b]J+7/\u001a;M_\u001e<WM\u001d+p\u0007V\u0014(/\u001a8u%>|G\u000fK\u0002@\u00053B3aPA2\u0003\u0005#Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7oQ1o]>$(+Z:fiJ{w\u000e\u001e'pO\u001e,'\u000fK\u0002A\u00053B3\u0001QA2\u0003%#Xm\u001d;J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hg\u001a{'\u000fT8hi)dun\u001a'fm\u0016d7\u000fR8fg:{GoV8sW^KG\u000f[%om\u0006d\u0017\u000eZ\"p]\u001aLwm\u001d\u0015\u0004\u0003\ne\u0003fA!\u0002d\u0005aC/Z:u\u00032$XM]\"p]\u001aLwm\u001d$pe2{w\r\u000e6M_\u001edUM^3mg\u0012{Wm\u001d(pi^{'o\u001b\u0015\u0004\u0005\ne\u0003f\u0001\"\u0002d\u0005\u0011\u0012\r\u001c;fe\n\u0013xn[3s\u0019><w-\u001a:t)\u0019\tiA! \u0003\u001a\"9!qP\"A\u0002\t\u0005\u0015aB3oiJLWm\u001d\t\u0007\u0005\u0007\u0013II!$\u000e\u0005\t\u0015%b\u0001BDA\u0006!Q\u000f^5m\u0013\u0011\u0011YI!\"\u0003\u0015\r{G\u000e\\3di&|g\u000e\u0005\u0003\u0003\u0010\nUUB\u0001BI\u0015\u0011\u0011\u0019*!2\u0002\u000b\u0005$W.\u001b8\n\t\t]%\u0011\u0013\u0002\u000e\u00032$XM]\"p]\u001aLwm\u00149\t\u0013\tm5\t%AA\u0002\tu\u0015\u0001\u0004<bY&$\u0017\r^3P]2L\bc\u00015\u0003 &\u0019!\u0011U5\u0003\u000f\t{w\u000e\\3b]\u0006a\u0012\r\u001c;fe\n\u0013xn[3s\u0019><w-\u001a:tI\u0011,g-Y;mi\u0012\u0012TC\u0001BTU\u0011\u0011iJ!+,\u0005\t-\u0006\u0003\u0002BW\u0005ok!Aa,\u000b\t\tE&1W\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!.j\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005s\u0013yKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0003Z3tGJL'-\u001a\"s_.,'\u000fT8hO\u0016\u00148\u000f\u0006\u0002\u0003@B!!q\u0012Ba\u0013\u0011\u0011\u0019M!%\u0003\r\r{gNZ5h\u0003U!X-\u0019:e_^t'I]8lKJdunZ4feN\fQ\u0004\u00157bS:$X\r\u001f;BI6Lg.\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003)\"\u001b2\u0001\u0013Bg!\rA'qZ\u0005\u0004\u0005#L'AB!osJ+g\r\u0006\u0002\u0003J\u000612\r[3dWZ\u000bG.\u001b3BYR,'oQ8oM&<7\u000f\u0006\u0005\u0002\u000e\te'1\u001dBt\u0011\u001d\u0011YN\u0013a\u0001\u0005;\faa\u00197jK:$\b\u0003\u0002BH\u0005?LAA!9\u0003\u0012\n)\u0011\tZ7j]\"1!Q\u001d&A\u0002y\fa\u0002^8qS\u000e\u0014Vm]8ve\u000e,\u0017\u0007\u0003\u0004\u0003j*\u0003\rA`\u0001\u000fi>\u0004\u0018n\u0019*fg>,(oY33\u0003a\u0019\u0007.Z2l\u0013:4\u0018\r\\5e\u00032$XM]\"p]\u001aLwm\u001d\u000b\t\u0003\u001b\u0011yOa@\u0004\u0018!9!\u0011_&A\u0002\tM\u0018\u0001\u0003>l\u00072LWM\u001c;\u0011\t\tU(1`\u0007\u0003\u0005oT1A!?P\u0003\tQ8.\u0003\u0003\u0003~\n](!D&bM.\f'l[\"mS\u0016tG\u000fC\u0004\u0004\u0002-\u0003\raa\u0001\u0002\u000fM,'O^3sgB11QAB\u0004\u0007\u0017i!!!\n\n\t\r%\u0011Q\u0005\u0002\u0004'\u0016\f\b\u0003BB\u0007\u0007'i!aa\u0004\u000b\u0007\rEq*\u0001\u0004tKJ4XM]\u0005\u0005\u0007+\u0019yAA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\bb\u0002Bn\u0017\u0002\u0007!Q\u001c")
public class PlaintextAdminIntegrationTest
extends BaseAdminIntegrationTest {
    private final String topic;
    private final int partition;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), this.partition());
    private ConfigResource brokerLoggerConfigResource;
    private final Set<String> changedBrokerLoggers = (Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);

    public static void checkInvalidAlterConfigs(KafkaZkClient kafkaZkClient, scala.collection.Seq<KafkaServer> seq, Admin admin) {
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(kafkaZkClient, seq, admin);
    }

    public static void checkValidAlterConfigs(Admin admin, ConfigResource configResource, ConfigResource configResource2) {
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(admin, configResource, configResource2);
    }

    public String topic() {
        return this.topic;
    }

    public int partition() {
        return this.partition;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    private ConfigResource brokerLoggerConfigResource() {
        return this.brokerLoggerConfigResource;
    }

    private void brokerLoggerConfigResource_$eq(ConfigResource x$1) {
        this.brokerLoggerConfigResource = x$1;
    }

    private Set<String> changedBrokerLoggers() {
        return this.changedBrokerLoggers;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.brokerLoggerConfigResource_$eq(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, ((Object)((KafkaServer)this.servers().head()).config().brokerId()).toString()));
    }

    @Override
    @After
    public void tearDown() {
        this.teardownBrokerLoggers();
        super.tearDown();
    }

    @Test
    public void testClose() {
        Admin client = Admin.create(this.createConfig());
        client.close();
        client.close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListNodes() {
        void mkString_end;
        void mkString_end2;
        List nodeStrs;
        void sorted_ord;
        this.client_$eq(Admin.create(this.createConfig()));
        ArraySeq.ofRef ofRef2 = Predef$.MODULE$.wrapRefArray((Object[])this.brokerList().split(","));
        if (ofRef2 == null) {
            throw null;
        }
        List list = IterableOnceOps.toList$((IterableOnceOps)ofRef2);
        Ordering.String$ string$ = Ordering.String$.MODULE$;
        if (list == null) {
            throw null;
        }
        string$ = null;
        List brokerStrs = (List)StrictOptimizedSeqOps.sorted$((StrictOptimizedSeqOps)list, (Ordering)sorted_ord);
        do {
            void sorted_ord2;
            List list2 = ((IterableOnceOps)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)this.client().describeCluster().nodes().get()).asScala()).map((Function1 & Serializable)node -> new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString())).toList();
            Ordering.String$ string$2 = Ordering.String$.MODULE$;
            if (list2 == null) {
                throw null;
            }
            string$2 = null;
            nodeStrs = (List)StrictOptimizedSeqOps.sorted$((StrictOptimizedSeqOps)list2, (Ordering)sorted_ord2);
            if (nodeStrs == null) {
                throw null;
            }
            if (brokerStrs != null) continue;
            throw null;
        } while (SeqOps.size$((SeqOps)nodeStrs) < SeqOps.size$((SeqOps)brokerStrs));
        String mkString_sep = ",";
        String string = "";
        String mkString_start = "";
        Object var7_7 = null;
        string = null;
        Object var3_5 = null;
        String mkString_sep2 = ",";
        String string2 = "";
        String mkString_start2 = "";
        Object var9_10 = null;
        string2 = null;
        Object var4_8 = null;
        Assert.assertEquals((Object)IterableOnceOps.mkString$((IterableOnceOps)brokerStrs, (String)mkString_start, (String)mkString_sep, (String)mkString_end2), (Object)IterableOnceOps.mkString$((IterableOnceOps)nodeStrs, (String)mkString_start2, (String)mkString_sep2, (String)mkString_end));
    }

    @Test
    public void testCreateExistingTopicsThrowTopicExistsException() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "mytopic";
        scala.collection.Seq topics = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        scala.collection.Seq newTopics = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(topic, 1, (short)1)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)topics, (scala.collection.Seq<String>)Nil$.MODULE$);
        Object[] objectArray = new NewTopic[1];
        Buffer<KafkaServer> buffer = this.servers();
        if (buffer == null) {
            throw null;
        }
        objectArray[0] = new NewTopic(topic, 1, (short)(buffer.length() + 1));
        scala.collection.Seq newTopicsWithInvalidRF = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (Void)this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopicsWithInvalidRF).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112))).getCause() instanceof TopicExistsException));
    }

    @Test
    public void testMetadataRefresh() {
        this.client_$eq(Admin.create(this.createConfig()));
        scala.collection.Seq topics = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic"}));
        scala.collection.Seq newTopics = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic("mytopic", 3, (short)3)}));
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)topics, (scala.collection.Seq<String>)Nil$.MODULE$);
        KafkaServer controller = (KafkaServer)this.servers().find((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testMetadataRefresh$1(this, x$2))).get();
        controller.shutdown();
        controller.awaitShutdown();
        java.util.Map topicDesc = (java.util.Map)this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()).all().get();
        Assert.assertEquals((Object)topics.toSet(), (Object)JavaConverters$.MODULE$.asScalaSetConverter(topicDesc.keySet()).asScala());
    }

    @Test
    public void testDescribeNonExistingTopic() {
        this.client_$eq(Admin.create(this.createConfig()));
        String existingTopic = "existing-topic";
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic})).map((Function1 & Serializable)x$3 -> new NewTopic(x$3, 1, (short)1))).asJava()).all().get();
        this.waitForTopics(this.client(), (scala.collection.Seq<String>)((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{existingTopic}))), (scala.collection.Seq<String>)Nil$.MODULE$);
        String nonExistingTopic = "non-existing";
        java.util.Map results = this.client().describeTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{nonExistingTopic, existingTopic}))).asJava()).values();
        Assert.assertEquals((Object)existingTopic, (Object)((TopicDescription)((KafkaFuture)results.get(existingTopic)).get()).name());
        boolean cfr_ignored_0 = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (TopicDescription)((KafkaFuture)results.get(nonExistingTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147))).getCause() instanceof UnknownTopicOrPartitionException;
        Assert.assertEquals((Object)None$.MODULE$, (Object)this.zkClient().getTopicPartitionCount(nonExistingTopic));
    }

    @Test
    public void testDescribeCluster() {
        Object object;
        this.client_$eq(Admin.create(this.createConfig()));
        DescribeClusterResult result = this.client().describeCluster();
        Collection nodes = (Collection)result.nodes().get();
        String clusterId = (String)result.clusterId().get();
        Assert.assertEquals((Object)((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().clusterId(), (Object)clusterId);
        Node controller = (Node)result.controller().get();
        Option option = ((KafkaServer)this.servers().head()).dataPlaneRequestProcessor().metadataCache().getControllerId();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            Integer n;
            Integer n2 = n = Integer.valueOf(-1);
            n = null;
            object = n2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var6_5 = null;
        object = null;
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)object2), (long)controller.id());
        String[] brokers = this.brokerList().split(",");
        Assert.assertEquals((long)brokers.length, (long)nodes.size());
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nodes).asScala()).foreach((Function1 & Serializable)node -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeCluster$2(brokers, node);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDescribeLogDirs() {
        IndexedSeq indexedSeq;
        Integer n;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        MapView partitionsByBroker = this.createTopic(topic, 10, 1, this.createTopic$default$4()).groupBy((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$1(x0$1))).mapValues((Function1 & Serializable)x$4 -> x$4.keys().toSeq());
        int n2 = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive map_this = new Range.Exclusive(n2, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer n3;
            Integer n4;
            Integer n5 = n4 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            n4 = null;
            Integer n6 = n3 = n5;
            n3 = null;
            n = n6;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var7_5 = null;
        Object var8_6 = null;
        Object var9_7 = null;
        n = null;
        indexedSeq = null;
        IndexedSeq brokers = indexedSeq2;
        java.util.Map logDirInfosByBroker = (java.util.Map)this.client().describeLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)brokers).asJava()).all().get();
        int n7 = 0;
        int until$extension_end2 = this.brokerCount();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n7, until$extension_end2, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$4(this, partitionsByBroker, logDirInfosByBroker, topic, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    @Test
    public void testDescribeReplicaLogDirs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        Seq replicas = ((IterableOnceOps)this.createTopic(topic, 10, 1, this.createTopic$default$4()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partition = x0$1._1$mcI$sp();
            int brokerId = x0$1._2$mcI$sp();
            TopicPartitionReplica topicPartitionReplica = new TopicPartitionReplica(topic, partition, brokerId);
            return topicPartitionReplica;
        })).toSeq();
        java.util.Map replicaDirInfos = (java.util.Map)this.client().describeReplicaLogDirs(new JavaConverters.AsJavaCollection((Iterable)replicas).asJavaCollection()).all().get();
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(replicaDirInfos).asScala()).foreach((Function1 & Serializable)x0$2 -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$2(this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterReplicaLogDirs() {
        String string;
        void apply_unit;
        void apply_executor;
        void apply_body;
        scala.concurrent.Future future2;
        ExecutionContextExecutor executionContextExecutor;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "topic";
        TopicPartition tp = new TopicPartition(topic, 0);
        scala.collection.immutable.Map randomNums = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> {
            Integer n;
            Integer n2 = n = Integer.valueOf(Random$.MODULE$.nextInt(2));
            n = null;
            Integer $minus$greater$extension_y = n2;
            return new Tuple2(server, (Object)$minus$greater$extension_y);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map firstReplicaAssignment = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> {
            TopicPartitionReplica topicPartitionReplica;
            String logDir = new File((String)server.config().logDirs().apply(BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            TopicPartitionReplica topicPartitionReplica2 = topicPartitionReplica = new TopicPartitionReplica(topic, 0, server.config().brokerId());
            topicPartitionReplica = null;
            TopicPartitionReplica $minus$greater$extension_$this = topicPartitionReplica2;
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        scala.collection.immutable.Map secondReplicaAssignment = ((IterableOnceOps)this.servers().map((Function1 & Serializable)server -> {
            TopicPartitionReplica topicPartitionReplica;
            String logDir = new File((String)server.config().logDirs().apply(1 - BoxesRunTime.unboxToInt((Object)randomNums.apply(server)))).getAbsolutePath();
            TopicPartitionReplica topicPartitionReplica2 = topicPartitionReplica = new TopicPartitionReplica(topic, 0, server.config().brokerId());
            topicPartitionReplica = null;
            TopicPartitionReplica $minus$greater$extension_$this = topicPartitionReplica2;
            return new Tuple2((Object)$minus$greater$extension_$this, (Object)logDir);
        })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).values()).asScala()).values().foreach((Function1 & Serializable)future -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$4(future);
            return BoxedUnit.UNIT;
        });
        this.createTopic(topic, 1, this.brokerCount(), this.createTopic$default$4());
        this.servers().foreach((Function1 & Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$6(tp, firstReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)secondReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
        this.servers().foreach((Function1 & Serializable)server -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$7(tp, secondReplicaAssignment, topic, server);
            return BoxedUnit.UNIT;
        });
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger numMessages = new AtomicInteger();
        ExecutionContextExecutor executionContextExecutor2 = executionContextExecutor = ExecutionContext$.MODULE$.global();
        executionContextExecutor = null;
        ExecutionContextExecutor executionContextExecutor3 = executionContextExecutor2;
        JFunction0.mcI.sp & Serializable intersect = (JFunction0.mcI.sp & Serializable)() -> {
            int n;
            ByteArraySerializer byteArraySerializer;
            ByteArraySerializer byteArraySerializer2;
            None$ none$;
            String string;
            String x$5 = TestUtils$.MODULE$.getBrokerListStrFromServers((scala.collection.Seq<KafkaServer>)this.servers(), this.securityProtocol());
            SecurityProtocol x$6 = this.securityProtocol();
            Option<File> x$7 = this.trustStoreFile();
            long l = 60000L;
            long l2 = 0x100000L;
            int n2 = 30000;
            int n3 = 0;
            int n4 = 16384;
            String string2 = string = "none";
            string = null;
            String x$16 = string2;
            None$ none$2 = none$ = None$.MODULE$;
            none$ = null;
            None$ x$17 = none$2;
            ByteArraySerializer byteArraySerializer3 = byteArraySerializer2 = new ByteArraySerializer();
            byteArraySerializer2 = null;
            ByteArraySerializer x$18 = byteArraySerializer3;
            ByteArraySerializer byteArraySerializer4 = byteArraySerializer = new ByteArraySerializer();
            byteArraySerializer = null;
            ByteArraySerializer x$19 = byteArraySerializer4;
            boolean bl = false;
            try (KafkaProducer producer = TestUtils$.MODULE$.createProducer(x$5, -1, l, l2, 0, n2, n3, n4, x$16, 10000, x$6, x$7, (Option<Properties>)x$17, x$18, x$19, bl);){
                while (running.get()) {
                    Future future = producer.send(new ProducerRecord(topic, (Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(numMessages).toString().getBytes()));
                    numMessages.incrementAndGet();
                    future.get(10L, TimeUnit.SECONDS);
                }
                n = numMessages.get();
            }
            return n;
        };
        Future$ apply_this = Future$.MODULE$;
        scala.concurrent.Future future3 = future2 = apply_this.unit().map(arg_0 -> Future$.$anonfun$apply$1((Function0)apply_body, arg_0), (ExecutionContext)apply_executor);
        Object var16_11 = null;
        intersect = null;
        executionContextExecutor3 = null;
        future2 = null;
        scala.concurrent.Future producerFuture = future3;
        try {
            long l = 15000L;
            long l2 = 100L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$11(numMessages)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$12(numMessages, producerFuture), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                Thread.sleep(Math.min(l, l2));
            }
            this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)firstReplicaAssignment).asJava(), new AlterReplicaLogDirsOptions()).all().get();
            this.servers().foreach((Function1 & Serializable)server -> {
                PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$13(tp, firstReplicaAssignment, topic, producerFuture, server);
                return BoxedUnit.UNIT;
            });
            int currentMessagesNum = numMessages.get();
            long l3 = 15000L;
            long l4 = 100L;
            long waitUntilTrue_startTime2 = System.currentTimeMillis();
            while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$16(numMessages, currentMessagesNum)) {
                if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                    throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$17(numMessages, currentMessagesNum, producerFuture), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                }
                Thread.sleep(Math.min(l3, l4));
            }
        }
        finally {
            running.set(false);
        }
        TimeUnit timeUnit = TimeUnit.SECONDS;
        long apply_length = 20L;
        timeUnit = null;
        int finalNumMessages = BoxesRunTime.unboxToInt((Object)Await$.MODULE$.result((Awaitable)producerFuture, (Duration)new FiniteDuration(apply_length, (TimeUnit)apply_unit)));
        Buffer<KafkaServer> x$23 = this.servers();
        SecurityProtocol x$26 = this.securityProtocol();
        Option<File> x$27 = this.trustStoreFile();
        String string2 = string = "group";
        string = null;
        String x$28 = string2;
        long l = 15000L;
        ((IterableOnceOps)TestUtils$.MODULE$.consumeTopicRecords((scala.collection.Seq<KafkaServer>)x$23, topic, finalNumMessages, x$28, x$26, x$27, l).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$18(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDescribeAndAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1);
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        ConfigResource brokerResource1 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)((KafkaServer)this.servers().apply(1)).config().brokerId()).toString());
        ConfigResource brokerResource2 = new ConfigResource(ConfigResource.Type.BROKER, ((Object)((KafkaServer)this.servers().apply(2)).config().brokerId()).toString());
        scala.collection.Seq configResources = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, brokerResource1, brokerResource2}));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(configResources).asJava()).all().get();
        Assert.assertEquals((long)4L, (long)configs.size());
        ConfigEntry maxMessageBytes1 = ((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes1.name());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.MaxMessageBytesProp()), (Object)maxMessageBytes1.value());
        Assert.assertFalse((boolean)maxMessageBytes1.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes1.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes1.isReadOnly());
        Assert.assertEquals((Object)topicConfig1.get(LogConfig$.MODULE$.RetentionMsProp()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        ConfigEntry maxMessageBytes2 = ((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MaxMessageBytesProp());
        Assert.assertEquals((Object)((Object)Defaults$.MODULE$.MessageMaxBytes()).toString(), (Object)maxMessageBytes2.value());
        Assert.assertEquals((Object)LogConfig$.MODULE$.MaxMessageBytesProp(), (Object)maxMessageBytes2.name());
        Assert.assertTrue((boolean)maxMessageBytes2.isDefault());
        Assert.assertFalse((boolean)maxMessageBytes2.isSensitive());
        Assert.assertFalse((boolean)maxMessageBytes2.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(1)).config().values().size(), (long)((Config)configs.get(brokerResource1)).entries().size());
        Assert.assertEquals((Object)((Object)((KafkaServer)this.servers().apply(1)).config().brokerId()).toString(), (Object)((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        ConfigEntry listenerSecurityProtocolMap = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().getString(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp()), (Object)listenerSecurityProtocolMap.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), (Object)listenerSecurityProtocolMap.name());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isDefault());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isSensitive());
        Assert.assertFalse((boolean)listenerSecurityProtocolMap.isReadOnly());
        ConfigEntry truststorePassword = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.SslTruststorePasswordProp(), (Object)truststorePassword.name());
        Assert.assertNull((Object)truststorePassword.value());
        Assert.assertFalse((boolean)truststorePassword.isDefault());
        Assert.assertTrue((boolean)truststorePassword.isSensitive());
        Assert.assertFalse((boolean)truststorePassword.isReadOnly());
        ConfigEntry compressionType = ((Config)configs.get(brokerResource1)).get(KafkaConfig$.MODULE$.CompressionTypeProp());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(1)).config().compressionType(), (Object)compressionType.value());
        Assert.assertEquals((Object)KafkaConfig$.MODULE$.CompressionTypeProp(), (Object)compressionType.name());
        Assert.assertTrue((boolean)compressionType.isDefault());
        Assert.assertFalse((boolean)compressionType.isSensitive());
        Assert.assertFalse((boolean)compressionType.isReadOnly());
        Assert.assertEquals((long)((KafkaServer)this.servers().apply(2)).config().values().size(), (long)((Config)configs.get(brokerResource2)).entries().size());
        Assert.assertEquals((Object)((Object)((KafkaServer)this.servers().apply(2)).config().brokerId()).toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.BrokerIdProp()).value());
        Assert.assertEquals((Object)((KafkaServer)this.servers().apply(2)).config().logCleanerThreads().toString(), (Object)((Config)configs.get(brokerResource2)).get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).value());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCreatePartitions() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        void apply_elems3;
        void $minus$greater$extension_y4;
        void apply_elems4;
        void $minus$greater$extension_y5;
        void apply_elems5;
        void $minus$greater$extension_y6;
        ObjectRef objectRef;
        void apply_elems6;
        void $minus$greater$extension_y7;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "create-partitions-topic-1";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        String topic2 = "create-partitions-topic-2";
        this.createTopic(topic2, 1, 2, this.createTopic$default$4());
        TopicDescription topic1_metadata = this.getTopicMetadata(this.client(), topic1, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        TopicDescription topic2_metadata = this.getTopicMetadata(this.client(), topic2, this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4());
        Assert.assertEquals((long)1L, (long)topic1_metadata.partitions().size());
        Assert.assertEquals((long)1L, (long)topic2_metadata.partitions().size());
        CreatePartitionsOptions validateOnly = new CreatePartitionsOptions().validateOnly(true);
        CreatePartitionsOptions actuallyDoIt = new CreatePartitionsOptions().validateOnly(false);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)3);
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        Object var13_8 = null;
        newPartitions = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        CreatePartitionsResult create_e = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems6)).asJava(), validateOnly);
        Object var45_10 = null;
        ObjectRef alterResult = new ObjectRef((Object)create_e);
        Void create_e2 = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        ObjectRef objectRef2 = objectRef = new ObjectRef((Object)create_e2);
        Object var46_12 = null;
        objectRef = null;
        ObjectRef altered = objectRef2;
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        Object var15_16 = null;
        newPartitions2 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y6);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems5)).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$1(this, topic1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail("Timed out waiting for new partitions to appear", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
        }
        java.util.List<java.util.List> newPartition2Assignments = Arrays.asList(Arrays.asList(0, 1), Arrays.asList(1, 2));
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        Object var17_23 = null;
        newPartitions3 = null;
        objectArray3[0] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems4)).asJava(), validateOnly);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        Assert.assertEquals((long)1L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, newPartition2Assignments);
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        Object var19_26 = null;
        newPartitions4 = null;
        objectArray4[0] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems3)).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        java.util.List actualPartitions2 = this.partitions$1(topic2, (Option)new Some((Object)3));
        Assert.assertEquals((long)3L, (long)actualPartitions2.size());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(1)).replicas()).asScala()).map((Function1 & Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.id()))).toList());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(((TopicPartitionInfo)actualPartitions2.get(2)).replicas()).asScala()).map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.id()))).toList());
        Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CreatePartitionsOptions[]{validateOnly, actuallyDoIt})).foreach((Function1 & Serializable)option -> {
            PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$5(this, alterResult, topic1, topic2, newPartition2Assignments, altered, option);
            return BoxedUnit.UNIT;
        });
        Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[2];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)4);
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        Object var21_30 = null;
        newPartitions5 = null;
        objectArray5[0] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y3);
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)2);
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)topic2);
        Object var23_32 = null;
        newPartitions6 = null;
        objectArray5[1] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$5, (Seq)apply_elems2)).asJava(), actuallyDoIt);
        altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testCreatePartitions$6(this, topic1)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                throw Assertions$.MODULE$.fail("Timed out waiting for new partitions to appear", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
        }
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic2)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((Object)"Topic currently has 3 partitions, which is higher than the requested 2.", (Object)e.getCause().getMessage());
            Assert.assertEquals((long)3L, (long)this.numPartitions$1(topic2, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        ((KafkaFuture)this.client().deleteTopics(Arrays.asList(topic1)).values().get(topic1)).get();
        Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4);
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)topic1);
        Object var25_39 = null;
        newPartitions7 = null;
        objectArray6[0] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        alterResult.elem = this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$6, (Seq)apply_elems)).asJava(), validateOnly);
        try {
            altered.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult.elem).values().get(topic1)).get();
            Assert.fail((String)"Expect InvalidTopicException when the topic is queued for deletion");
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvalidTopicException));
            Assert.assertEquals((Object)"The topic is queued for deletion.", (Object)e.getCause().getMessage());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSeekAfterDeleteRecords() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        consumer.seekToBeginning(Collections.singleton(this.topicPartition()));
        Assert.assertEquals((long)0L, (long)consumer.position(this.topicPartition()));
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var5_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)5L, (long)lowWatermark);
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)5L, (long)consumer.position(this.topicPartition()));
        consumer.seek(this.topicPartition(), 7L);
        Assert.assertEquals((long)7L, (long)consumer.position(this.topicPartition()));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        TopicPartition $minus$greater$extension_$this2 = this.topicPartition();
        Object var7_8 = null;
        recordsToDelete2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        consumer.seekToBeginning(Collections.singletonList(this.topicPartition()));
        Assert.assertEquals((long)10L, (long)consumer.position(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetCheckpoint() {
        void apply_elems;
        void $minus$greater$extension_y;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var3_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        DeleteRecordsResult deleteRecordsResult = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava());
        Some some = new Some((Object)((DeletedRecords)((KafkaFuture)deleteRecordsResult.lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Assert.assertEquals((Object)new Some((Object)5), (Object)some);
        int n = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                this.killBroker(foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var7_10 = null;
        this.restartDeadBrokers();
        this.client().close();
        this.brokerList_$eq(TestUtils$.MODULE$.bootstrapServers((scala.collection.Seq<KafkaServer>)this.servers(), this.listenerName()));
        this.client_$eq(Admin.create(this.createConfig()));
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            ExecutionException executionException;
            boolean bl;
            void $anonfun$testLogStartOffsetCheckpoint$2_apply_elems;
            void $anonfun$testLogStartOffsetCheckpoint$2_$minus$greater$extension_y;
            Map$ map$2 = Predef$.MODULE$.Map();
            Object[] objectArray2 = new Tuple2[1];
            RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)0L);
            TopicPartition $anonfun$testLogStartOffsetCheckpoint$2_$minus$greater$extension_$this = this.topicPartition();
            Object var20_20 = null;
            recordsToDelete2 = null;
            objectArray2[0] = new Tuple2((Object)$anonfun$testLogStartOffsetCheckpoint$2_$minus$greater$extension_$this, (Object)$anonfun$testLogStartOffsetCheckpoint$2_$minus$greater$extension_y);
            ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
            if (map$2 == null) {
                throw null;
            }
            arraySeq2 = null;
            deleteRecordsResult = this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)$anonfun$testLogStartOffsetCheckpoint$2_apply_elems)).asJava());
            some = None$.MODULE$;
            KafkaFuture $anonfun$testLogStartOffsetCheckpoint$2_future = (KafkaFuture)deleteRecordsResult.lowWatermarks().get(this.topicPartition());
            try {
                some = new Some((Object)((DeletedRecords)$anonfun$testLogStartOffsetCheckpoint$2_future.get()).lowWatermark());
                bl = some.contains((Object)5L);
            }
            catch (Throwable throwable) {
                if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) {
                    throw throwable;
                }
                boolean bl2 = false;
                bl = bl2;
            }
            Object var17_16 = null;
            Object var18_17 = null;
            executionException = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Object object;
                String string;
                StringBuilder stringBuilder = new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ");
                Option $anonfun$testLogStartOffsetCheckpoint$3_getOrElse_this = (Option)some;
                if ($anonfun$testLogStartOffsetCheckpoint$3_getOrElse_this.isEmpty()) {
                    String string2 = string = "no response within the timeout";
                    string = null;
                    object = string2;
                } else {
                    object = $anonfun$testLogStartOffsetCheckpoint$3_getOrElse_this.get();
                }
                Object object2 = object;
                Object var23_23 = null;
                object = null;
                string = null;
                throw Assertions$.MODULE$.fail(stringBuilder.append(object2).toString(), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogStartOffsetAfterDeleteRecords() {
        void apply_elems;
        void $minus$greater$extension_y;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var5_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        long lowWatermark = ((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark();
        Assert.assertEquals((long)3L, (long)lowWatermark);
        int n = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testLogStartOffsetAfterDeleteRecords$1(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        int followerIndex = BoxesRunTime.unboxToInt((Object)this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4()).apply((Object)0)) != ((KafkaServer)this.servers().apply(0)).config().brokerId() ? 0 : 1;
        this.killBroker(followerIndex);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 100, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var3_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(3L, 100L, followerIndex);
        int n = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(this, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var10_8 = null;
        this.killBroker(followerIndex);
        this.sendRecords(producer, 100, this.topicPartition());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)117L);
        TopicPartition $minus$greater$extension_$this2 = this.topicPartition();
        Object var6_11 = null;
        recordsToDelete2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        this.restartDeadBrokers();
        this.waitForFollowerLog$1(117L, 200L, followerIndex);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAlterLogDirsAfterDeleteRecords() {
        void apply_elems;
        void apply_elems2;
        void $minus$greater$extension_y;
        this.client_$eq(Admin.create(this.createConfig()));
        this.createTopic(this.topic(), 1, this.brokerCount(), this.createTopic$default$4());
        int expectedLEO = 100;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, expectedLEO, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var5_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).all().get();
        int n = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive foreach$mVc$sp_this = new Range.Exclusive(n, until$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$1(this, expectedLEO, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var10_8 = null;
        String futureLogDir = (String)((KafkaServer)this.servers().apply(0)).config().logDirs().apply(1);
        TopicPartitionReplica futureReplica = new TopicPartitionReplica(this.topic(), 0, ((KafkaServer)this.servers().apply(0)).config().brokerId());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)futureReplica, (Object)futureLogDir);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterLogDirsAfterDeleteRecords$2(this, futureLogDir)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("timed out waiting for replica movement", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO, (long)((Log)((KafkaServer)this.servers().head()).replicaManager().localLog(this.topicPartition()).get()).logEndOffset());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testOffsetsForTimesAfterDeleteRecords() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        void apply_elems5;
        void $minus$greater$extension_y5;
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Long l = 0L;
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var3_4 = null;
        l = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((long)0L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems5)).asJava()).get(this.topicPartition())).offset());
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        TopicPartition $minus$greater$extension_$this2 = this.topicPartition();
        Object var5_7 = null;
        recordsToDelete = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems4)).asJava()).all().get();
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        Long l2 = 0L;
        TopicPartition $minus$greater$extension_$this3 = this.topicPartition();
        Object var7_10 = null;
        l2 = null;
        objectArray3[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((long)5L, (long)((OffsetAndTimestamp)consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems3)).asJava()).get(this.topicPartition())).offset());
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)-1L);
        TopicPartition $minus$greater$extension_$this4 = this.topicPartition();
        Object var9_13 = null;
        recordsToDelete2 = null;
        objectArray4[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems2)).asJava()).all().get();
        Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        Long l3 = 0L;
        TopicPartition $minus$greater$extension_$this5 = this.topicPartition();
        Object var11_16 = null;
        l3 = null;
        objectArray5[0] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertNull(consumer.offsetsForTimes((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$5, (Seq)apply_elems)).asJava()).get(this.topicPartition()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumeAfterDeleteRecords() {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        TestUtils$.MODULE$.consumeRecords(consumer, 10, 15000L);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)3L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var3_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 7, 15000L);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        RecordsToDelete recordsToDelete2 = RecordsToDelete.beforeOffset((long)8L);
        TopicPartition $minus$greater$extension_$this2 = this.topicPartition();
        Object var5_7 = null;
        recordsToDelete2 = null;
        objectArray2[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        consumer.seek(this.topicPartition(), 1L);
        TestUtils$.MODULE$.consumeRecords(consumer, 2, 15000L);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteRecordsWithException() {
        void apply_elems;
        void $minus$greater$extension_y;
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.subscribeAndWaitForAssignment(this.topic(), consumer);
        this.client_$eq(Admin.create(this.createConfig()));
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.sendRecords(producer, 10, this.topicPartition());
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)5L);
        TopicPartition $minus$greater$extension_$this = this.topicPartition();
        Object var5_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((long)5L, (long)((DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava()).lowWatermarks().get(this.topicPartition())).get()).lowWatermark());
        Throwable cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            RecordsToDelete $minus$greater$extension_y = RecordsToDelete.beforeOffset((long)20L);
            TopicPartition $minus$greater$extension_$this = this.topicPartition();
            Object var1_2 = null;
            Object var2_1 = null;
            objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava()).lowWatermarks().get(this.topicPartition())).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 859))).getCause();
        Assert.assertEquals(OffsetOutOfRangeException.class, cause.getClass());
        TopicPartition nonExistPartition = new TopicPartition(this.topic(), 3);
        cause = ((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> {
            void apply_elems;
            Map$ map$ = Predef$.MODULE$.Map();
            Object[] objectArray = new Tuple2[1];
            RecordsToDelete $minus$greater$extension_y = RecordsToDelete.beforeOffset((long)20L);
            Object var2_2 = null;
            objectArray[0] = new Tuple2((Object)nonExistPartition, (Object)$minus$greater$extension_y);
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
            if (map$ == null) {
                throw null;
            }
            arraySeq = null;
            return (DeletedRecords)((KafkaFuture)this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava()).lowWatermarks().get(nonExistPartition)).get();
        }, ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866))).getCause();
        Assert.assertEquals(LeaderNotAvailableException.class, cause.getClass());
    }

    @Test
    public void testDescribeConfigsForTopic() {
        this.createTopic(this.topic(), 2, this.brokerCount(), this.createTopic$default$4());
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource existingTopic = new ConfigResource(ConfigResource.Type.TOPIC, this.topic());
        ((KafkaFuture)this.client().describeConfigs(Collections.singletonList(existingTopic)).values().get(existingTopic)).get();
        ConfigResource nonExistentTopic = new ConfigResource(ConfigResource.Type.TOPIC, "unknown");
        DescribeConfigsResult describeResult1 = this.client().describeConfigs(Collections.singletonList(nonExistentTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (Config)((KafkaFuture)describeResult1.values().get(nonExistentTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 883))).getCause() instanceof UnknownTopicOrPartitionException));
        ConfigResource invalidTopic = new ConfigResource(ConfigResource.Type.TOPIC, "(invalid topic)");
        DescribeConfigsResult describeResult2 = this.client().describeConfigs(Collections.singletonList(invalidTopic));
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (Config)((KafkaFuture)describeResult2.values().get(invalidTopic)).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 888))).getCause() instanceof InvalidTopicException));
    }

    private void subscribeAndWaitForAssignment(String topic, KafkaConsumer<byte[], byte[]> consumer) {
        consumer.subscribe(Collections.singletonList(topic));
        long l = 15000L;
        long pollUntilTrue_waitUntilTrue_pause = 0L;
        long pollUntilTrue_waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            consumer.poll(java.time.Duration.ofMillis(100L));
            if (PlaintextAdminIntegrationTest.$anonfun$subscribeAndWaitForAssignment$1(consumer)) break;
            if (System.currentTimeMillis() > pollUntilTrue_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Expected non-empty assignment", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, pollUntilTrue_waitUntilTrue_pause));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sendRecords(KafkaProducer<byte[], byte[]> producer, int numRecords, TopicPartition topicPartition) {
        Future future;
        int n = 0;
        Range.Exclusive map_this = new Range.Exclusive(n, numRecords, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Future future2;
            Future future3 = future2 = PlaintextAdminIntegrationTest.$anonfun$sendRecords$1(this, topicPartition, producer, BoxesRunTime.unboxToInt((Object)object));
            future2 = null;
            future = future3;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            future = null;
        }
        Object var5_5 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        future = null;
        ((IndexedSeq)map_strictOptimizedMap_b.result()).foreach((Function1 & Serializable)x$11 -> (RecordMetadata)x$11.get());
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (scala.collection.Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testAclOperations() {
        AclBinding acl = new AclBinding(new ResourcePattern(ResourceType.TOPIC, "mytopic3", PatternType.LITERAL), new AccessControlEntry("User:ANONYMOUS", "*", AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        this.client_$eq(Admin.create(this.createConfig()));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().describeAcls(AclBindingFilter.ANY).values(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().createAcls(Collections.singleton(acl)).all(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(this.client().deleteAcls(Collections.singleton(acl.toFilter())).all(), SecurityDisabledException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testDelayedClose() {
        this.client_$eq(Admin.create(this.createConfig()));
        scala.collection.Seq newTopics = (scala.collection.Seq)((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"}))).map((Function1 & Serializable)x$12 -> new NewTopic(x$12, 1, (short)1));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        this.client().close(java.time.Duration.ofHours(2L));
        KafkaFuture future2 = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future2, TimeoutException.class, (Option<String>)None$.MODULE$);
        future.get();
        this.client().close(java.time.Duration.ofMinutes(30L));
    }

    @Test
    public void testForceClose() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        this.client_$eq(Admin.create(config));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"})).map((Function1 & Serializable)x$13 -> new NewTopic(x$13, 1, (short)1))).asJava(), new CreateTopicsOptions().timeoutMs(Integer.valueOf(900000))).all();
        this.client().close(java.time.Duration.ZERO);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
    }

    @Test
    public void testMinimumRequestTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("bootstrap.servers", new StringBuilder(10).append("localhost:").append(TestUtils$.MODULE$.IncorrectBrokerPort()).toString());
        config.put("request.timeout.ms", "0");
        this.client_$eq(Admin.create(config));
        long startTimeMs = Time.SYSTEM.milliseconds();
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"})).map((Function1 & Serializable)x$14 -> new NewTopic(x$14, 1, (short)1))).asJava(), new CreateTopicsOptions().timeoutMs(Integer.valueOf(2))).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
        long endTimeMs = Time.SYSTEM.milliseconds();
        Assert.assertTrue((String)"Expected the timeout to take at least one millisecond.", (endTimeMs > startTimeMs ? 1 : 0) != 0);
    }

    @Test
    public void testCallInFlightTimeouts() {
        java.util.Map<String, Object> config = this.createConfig();
        config.put("default.api.timeout.ms", "100000000");
        KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory factory = new KafkaAdminClientTest.FailureInjectingTimeoutProcessorFactory();
        this.client_$eq((Admin)KafkaAdminClientTest.createInternal((AdminClientConfig)new AdminClientConfig(config), (KafkaAdminClient.TimeoutProcessorFactory)factory));
        KafkaFuture future = this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic", "mytopic2"})).map((Function1 & Serializable)x$15 -> new NewTopic(x$15, 1, (short)1))).asJava(), new CreateTopicsOptions().validateOnly(true)).all();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(future, TimeoutException.class, (Option<String>)None$.MODULE$);
        this.client().createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mytopic3", "mytopic4"})).map((Function1 & Serializable)x$16 -> new NewTopic(x$16, 1, (short)1))).asJava(), new CreateTopicsOptions().validateOnly(true)).all().get();
        Assert.assertEquals((long)1L, (long)factory.failuresInjected());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerGroups() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            ListConsumerGroupsResult list1 = this.client().listConsumerGroups();
            Assert.assertTrue((0 == ((Collection)list1.all().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.errors().get()).size() ? 1 : 0) != 0);
            Assert.assertTrue((0 == ((Collection)list1.valid().get()).size() ? 1 : 0) != 0);
            String testTopicName = "test_topic";
            int testNumPartitions = 2;
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, testNumPartitions, (short)1))).all().get();
            this.waitForTopics(this.client(), (scala.collection.Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (scala.collection.Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                Integer n;
                Integer n2 = n = Integer.valueOf(0);
                n = null;
                producer.send(new ProducerRecord(testTopicName, n2, null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String testInstanceId = "test_instance_id";
            String fakeGroupId = "fake_group_id";
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("group.instance.id", testInstanceId);
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            CountDownLatch latch = new CountDownLatch(1);
            try {
                Thread consumerThread = new Thread(null, consumer, testTopicName, latch){
                    private final KafkaConsumer consumer$2;
                    private final String testTopicName$1;
                    private final CountDownLatch latch$1;

                    public void run() {
                        this.consumer$2.subscribe(Collections.singleton(this.testTopicName$1));
                        try {
                            while (true) {
                                this.consumer$2.poll(java.time.Duration.ofSeconds(5L));
                                if (!this.consumer$2.assignment().isEmpty() && this.latch$1.getCount() > 0L) {
                                    this.latch$1.countDown();
                                }
                                this.consumer$2.commitSync();
                            }
                        }
                        catch (InterruptException interruptException) {
                            return;
                        }
                    }
                    {
                        this.consumer$2 = consumer$2;
                        this.testTopicName$1 = testTopicName$1;
                        this.latch$1 = latch$1;
                    }
                };
                try {
                    consumerThread.start();
                    Assert.assertTrue((boolean)latch.await(30000L, TimeUnit.MILLISECONDS));
                    long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$1(this, testGroupId)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                            throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$3(testGroupId), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                        }
                        Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, (long)waitUntilTrue_pause));
                    }
                    DescribeConsumerGroupsResult describeWithFakeGroupResult = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)2L, (long)describeWithFakeGroupResult.describedGroups().size());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(testGroupId));
                    ConsumerGroupDescription testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertEquals((long)1L, (long)testGroupDescription.members().size());
                    MemberDescription member = (MemberDescription)testGroupDescription.members().iterator().next();
                    Assert.assertEquals((Object)testClientId, (Object)member.clientId());
                    java.util.Set topicPartitions = member.assignment().topicPartitions();
                    Assert.assertEquals((long)testNumPartitions, (long)topicPartitions.size());
                    Assert.assertEquals((long)testNumPartitions, (long)((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(topicPartitions).asScala()).count((Function1 & Serializable)tp -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$4(testTopicName, tp))));
                    java.util.Set expectedOperations = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)AclEntry$.MODULE$.supportedOperations(ResourceType.GROUP)).asJava();
                    Assert.assertEquals((Object)expectedOperations, (Object)testGroupDescription.authorizedOperations());
                    Assert.assertTrue((boolean)describeWithFakeGroupResult.describedGroups().containsKey(fakeGroupId));
                    ConsumerGroupDescription fakeGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeWithFakeGroupResult.describedGroups().get(fakeGroupId)).get();
                    Assert.assertEquals((Object)fakeGroupId, (Object)fakeGroupDescription.groupId());
                    Assert.assertEquals((long)0L, (long)fakeGroupDescription.members().size());
                    Assert.assertEquals((Object)"", (Object)fakeGroupDescription.partitionAssignor());
                    Assert.assertEquals((Object)ConsumerGroupState.DEAD, (Object)fakeGroupDescription.state());
                    Assert.assertEquals((Object)expectedOperations, (Object)fakeGroupDescription.authorizedOperations());
                    Assert.assertEquals((long)2L, (long)((java.util.Map)describeWithFakeGroupResult.all().get()).size());
                    long l2 = TestUtils$.MODULE$.waitUntilTrue$default$4();
                    long waitUntilTrue_waitTimeMs2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
                    long waitUntilTrue_startTime2 = System.currentTimeMillis();
                    while (!PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$5(this, testGroupId, testTopicName)) {
                        void waitUntilTrue_pause;
                        if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                            throw Assertions$.MODULE$.fail("Expected the offset for partition 0 to eventually become 1.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
                        }
                        Thread.sleep(Math.min(waitUntilTrue_waitTimeMs2, (long)waitUntilTrue_pause));
                    }
                    String invalidInstanceId = "invalid-instance-id";
                    RemoveMembersFromConsumerGroupResult removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(invalidInstanceId))));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(removeMembersResult.all(), UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    KafkaFuture firstMemberFuture = removeMembersResult.memberResult(new MemberToRemove(invalidInstanceId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals(firstMemberFuture, UnknownMemberIdException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    DeleteConsumerGroupsResult deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId, fakeGroupId}))).asJava());
                    Assert.assertEquals((long)2L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(fakeGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(fakeGroupId), GroupIdNotFoundException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)deleteResult.deletedGroups().get(testGroupId), GroupNotEmptyException.class, TestUtils$.MODULE$.assertFutureExceptionTypeEquals$default$3());
                    removeMembersResult = this.client().removeMembersFromConsumerGroup(testGroupId, new RemoveMembersFromConsumerGroupOptions(Collections.singleton(new MemberToRemove(testInstanceId))));
                    Assert.assertNull((Object)removeMembersResult.all().get());
                    Assert.assertNull((Object)removeMembersResult.memberResult(new MemberToRemove(testInstanceId)).get());
                    DescribeConsumerGroupsResult describeTestGroupResult = this.client().describeConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId}))).asJava(), new DescribeConsumerGroupsOptions().includeAuthorizedOperations(true));
                    Assert.assertEquals((long)1L, (long)describeTestGroupResult.describedGroups().size());
                    testGroupDescription = (ConsumerGroupDescription)((KafkaFuture)describeTestGroupResult.describedGroups().get(testGroupId)).get();
                    Assert.assertEquals((Object)testGroupId, (Object)testGroupDescription.groupId());
                    Assert.assertFalse((boolean)testGroupDescription.isSimpleConsumerGroup());
                    Assert.assertTrue((boolean)testGroupDescription.members().isEmpty());
                    deleteResult = this.client().deleteConsumerGroups((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{testGroupId}))).asJava());
                    Assert.assertEquals((long)1L, (long)deleteResult.deletedGroups().size());
                    Assert.assertTrue((boolean)deleteResult.deletedGroups().containsKey(testGroupId));
                    Assert.assertNull((Object)((KafkaFuture)deleteResult.deletedGroups().get(testGroupId)).get());
                }
                finally {
                    consumerThread.interrupt();
                    consumerThread.join();
                }
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteConsumerGroupOffsets() {
        java.util.Map<String, Object> config = this.createConfig();
        this.client_$eq(Admin.create(config));
        try {
            void apply_elems;
            String testTopicName = "test_topic";
            String testGroupId = "test_group_id";
            String testClientId = "test_client_id";
            String fakeGroupId = "fake_group_id";
            TopicPartition tp1 = new TopicPartition(testTopicName, 0);
            TopicPartition tp2 = new TopicPartition("foo", 0);
            this.client().createTopics(Collections.singleton(new NewTopic(testTopicName, 1, (short)1))).all().get();
            this.waitForTopics(this.client(), (scala.collection.Seq<String>)new .colon.colon((Object)testTopicName, (List)Nil$.MODULE$), (scala.collection.Seq<String>)Nil$.MODULE$);
            KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
            try {
                Integer n;
                Integer n2 = n = Integer.valueOf(0);
                n = null;
                producer.send(new ProducerRecord(testTopicName, n2, null, null)).get();
            }
            finally {
                Utils.closeQuietly(producer, (String)"producer");
            }
            Properties newConsumerConfig = new Properties(this.consumerConfig());
            newConsumerConfig.setProperty("group.id", testGroupId);
            newConsumerConfig.setProperty("client.id", testClientId);
            newConsumerConfig.setProperty("max.poll.interval.ms", ((Object)Integer.MAX_VALUE).toString());
            newConsumerConfig.setProperty("session.timeout.ms", ((Object)Defaults$.MODULE$.GroupMaxSessionTimeoutMs()).toString());
            ByteArrayDeserializer x$2 = this.createConsumer$default$1();
            ByteArrayDeserializer x$3 = this.createConsumer$default$2();
            List<String> x$4 = this.createConsumer$default$4();
            KafkaConsumer consumer = this.createConsumer(x$2, x$3, newConsumerConfig, x$4);
            try {
                void apply_elems2;
                void apply_elems3;
                TestUtils$.MODULE$.subscribeAndWaitForRecords(testTopicName, consumer, 15000L);
                consumer.commitSync();
                Set$ set$ = Predef$.MODULE$.Set();
                ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2});
                if (set$ == null) {
                    throw null;
                }
                arraySeq = null;
                DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3)).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp1), GroupSubscribedToTopicException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
                Set$ set$2 = Predef$.MODULE$.Set();
                ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2});
                if (set$2 == null) {
                    throw null;
                }
                arraySeq2 = null;
                DeleteConsumerGroupOffsetsResult fakeDeleteResult = this.client().deleteConsumerGroupOffsets(fakeGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2)).asJava());
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.all(), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp1), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
                TestUtils$.MODULE$.assertFutureExceptionTypeEquals(fakeDeleteResult.partitionResult(tp2), GroupIdNotFoundException.class, (Option<String>)None$.MODULE$);
            }
            finally {
                Utils.closeQuietly(consumer, (String)"consumer");
            }
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1, tp2});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            DeleteConsumerGroupOffsetsResult offsetDeleteResult = this.client().deleteConsumerGroupOffsets(testGroupId, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).asJava());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.all(), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
            Assert.assertNull((Object)offsetDeleteResult.partitionResult(tp1).get());
            TestUtils$.MODULE$.assertFutureExceptionTypeEquals(offsetDeleteResult.partitionResult(tp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        }
        finally {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"adminClient");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectPreferredLeaders() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        void apply_elems9;
        void apply_elems10;
        void apply_elems11;
        void apply_elems12;
        void apply_elems13;
        void apply_elems14;
        void apply_elems15;
        void apply_elems16;
        this.client_$eq(Admin.create(this.createConfig()));
        scala.collection.Seq prefer0 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 2}));
        scala.collection.Seq prefer1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 0}));
        scala.collection.Seq prefer2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 0, 1}));
        TopicPartition partition1 = new TopicPartition("elect-preferred-leaders-topic-1", 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)partition1.partition());
        Object var10_5 = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)prefer0);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems16)), (scala.collection.Seq<KafkaServer>)this.servers());
        TopicPartition partition2 = new TopicPartition("elect-preferred-leaders-topic-2", 0);
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)partition2.partition());
        Object var11_8 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this2, (Object)prefer0);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition2.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems15)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq3 = null;
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems14)).asJava());
        Throwable exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(ElectionNotNeededException.class, exception.getClass());
        Assert.assertEquals((Object)"Leader election not needed for topic partition", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Assert.assertTrue((boolean)((java.util.Map)electResult.partitions().get()).isEmpty());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 0);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$2 == null) {
            throw null;
        }
        arraySeq4 = null;
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems13)).asJava());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$3 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems12)).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 0);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2});
        if (set$4 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (Seq)apply_elems11), (Object)JavaConverters$.MODULE$.asScalaSetConverter(((java.util.Map)electResult.partitions().get()).keySet()).asScala());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        TopicPartition unknownPartition = new TopicPartition("topic-does-not-exist", 0);
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition});
        if (set$5 == null) {
            throw null;
        }
        arraySeq7 = null;
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$5, (Seq)apply_elems10)).asJava());
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition});
        if (set$6 == null) {
            throw null;
        }
        arraySeq8 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$6, (Seq)apply_elems9)).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        this.changePreferredLeader$1(prefer2, partition1, partition2);
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1});
        if (set$7 == null) {
            throw null;
        }
        arraySeq9 = null;
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$7, (Seq)apply_elems8)).asJava());
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, partition1});
        if (set$8 == null) {
            throw null;
        }
        arraySeq10 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$8, (Seq)apply_elems7)).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 1);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get();
        Assert.assertEquals(UnknownTopicOrPartitionException.class, exception.getClass());
        Assert.assertEquals((Object)"The partition does not exist.", (Object)exception.getMessage());
        Set$ set$9 = Predef$.MODULE$.Set();
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2});
        if (set$9 == null) {
            throw null;
        }
        arraySeq11 = null;
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$9, (Seq)apply_elems6)).asJava());
        Set$ set$10 = Predef$.MODULE$.Set();
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition2});
        if (set$10 == null) {
            throw null;
        }
        arraySeq12 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$10, (Seq)apply_elems5)).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
        this.changePreferredLeader$1(prefer1, partition1, partition2);
        ((KafkaServer)this.servers().apply(1)).shutdown();
        Set$ set$11 = Predef$.MODULE$.Set();
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2});
        if (set$11 == null) {
            throw null;
        }
        arraySeq13 = null;
        Set$ set$12 = Predef$.MODULE$.Set();
        ArraySeq arraySeq14 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1});
        if (set$12 == null) {
            throw null;
        }
        arraySeq14 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$11, (Seq)apply_elems4)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$12, (Seq)apply_elems3)));
        ElectLeadersOptions shortTimeout = (ElectLeadersOptions)new ElectLeadersOptions().timeoutMs(Integer.valueOf(10000));
        Set$ set$13 = Predef$.MODULE$.Set();
        ArraySeq arraySeq15 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$13 == null) {
            throw null;
        }
        arraySeq15 = null;
        electResult = this.client().electLeaders(ElectionType.PREFERRED, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$13, (Seq)apply_elems2)).asJava(), shortTimeout);
        Set$ set$14 = Predef$.MODULE$.Set();
        ArraySeq arraySeq16 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$14 == null) {
            throw null;
        }
        arraySeq16 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$14, (Seq)apply_elems)).asJava(), ((java.util.Map)electResult.partitions().get()).keySet());
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        electResult = this.client().electLeaders(ElectionType.PREFERRED, null, shortTimeout);
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-1-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        exception = (Throwable)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get();
        Assert.assertEquals(PreferredLeaderNotAvailableException.class, exception.getClass());
        Assert.assertTrue((String)new StringBuilder(14).append("Wrong message ").append(exception.getMessage()).toString(), (boolean)exception.getMessage().contains("Failed to elect leader for partition elect-preferred-leaders-topic-2-0 under strategy PreferredReplicaPartitionLeaderElectionStrategy"));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, 2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, 2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForOnePartition() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Integer n;
        Integer n2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        TopicPartition partition1 = new TopicPartition("unclean-test-topic-1", 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition1.partition());
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var5_7 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), partition1.topic(), (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems4)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2)));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertFalse((boolean)((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems)).asJava()).partitions().get()).get(partition1)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForManyPartitions() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        Integer n5 = n4 = Integer.valueOf(partition1.partition());
        n4 = null;
        Integer n6 = n3 = n5;
        n3 = null;
        Integer $minus$greater$extension_$this = n6;
        Object var9_10 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        Integer n7 = n2 = Integer.valueOf(partition2.partition());
        n2 = null;
        Integer n8 = n = n7;
        n = null;
        Integer $minus$greater$extension_$this2 = n8;
        Object var10_13 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems4)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2)));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition2, (Option<Object>)None$.MODULE$);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems)).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).isPresent());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker2);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForAllPartitions() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        Integer n5 = n4 = Integer.valueOf(partition1.partition());
        n4 = null;
        Integer n6 = n3 = n5;
        n3 = null;
        Integer $minus$greater$extension_$this = n6;
        Object var10_11 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        Integer n7 = n2 = Integer.valueOf(partition2.partition());
        n2 = null;
        Integer n8 = n = n7;
        n = null;
        Integer $minus$greater$extension_$this2 = n8;
        Object var11_14 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems3)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems2)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems)));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, null);
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertFalse((boolean)((java.util.Map)electResult.partitions().get()).containsKey(partition2));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersForUnknownPartitions() {
        void apply_elems;
        void apply_elems2;
        Integer n;
        Integer n2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition unknownPartition = new TopicPartition(topic, 1);
        TopicPartition unknownTopic = new TopicPartition("unknown-topic", 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(0);
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var8_9 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), new TopicPartition(topic, 0), broker1);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownPartition, unknownTopic});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).asJava());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownPartition)).get() instanceof UnknownTopicOrPartitionException));
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(unknownTopic)).get() instanceof UnknownTopicOrPartitionException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersWhenNoLiveBrokers() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Integer n;
        Integer n2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition1.partition());
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var6_8 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems4)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2)));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems)).asJava()).partitions().get()).get(partition1)).get() instanceof EligibleLeadersNotAvailableException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersNoop() {
        void apply_elems;
        void apply_elems2;
        Integer n;
        Integer n2;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Integer n3 = n2 = Integer.valueOf(partition1.partition());
        n2 = null;
        Integer n4 = n = n3;
        n = null;
        Integer $minus$greater$extension_$this = n4;
        Object var6_8 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        ((KafkaServer)this.servers().apply(broker1)).startup();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).asJava()).partitions().get()).get(partition1)).get() instanceof ElectionNotNeededException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testElectUncleanLeadersAndNoop() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        Integer n;
        Integer n2;
        Integer n3;
        Integer n4;
        this.client_$eq(Admin.create(this.createConfig()));
        int broker1 = 1;
        int broker2 = 2;
        int broker3 = 0;
        scala.collection.Seq assignment1 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker2}));
        scala.collection.Seq assignment2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker1, broker3}));
        String topic = "unclean-test-topic-1";
        TopicPartition partition1 = new TopicPartition(topic, 0);
        TopicPartition partition2 = new TopicPartition(topic, 1);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        Integer n5 = n4 = Integer.valueOf(partition1.partition());
        n4 = null;
        Integer n6 = n3 = n5;
        n3 = null;
        Integer $minus$greater$extension_$this = n6;
        Object var10_11 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)assignment1);
        Integer n7 = n2 = Integer.valueOf(partition2.partition());
        n2 = null;
        Integer n8 = n = n7;
        n = null;
        Integer $minus$greater$extension_$this2 = n8;
        Object var11_14 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)assignment2);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.createTopic(this.zkClient(), topic, (Map<Object, scala.collection.Seq<Object>>)((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems4)), (scala.collection.Seq<KafkaServer>)this.servers());
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker1);
        ((KafkaServer)this.servers().apply(broker2)).shutdown();
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{broker2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitForBrokersOutOfIsr(this.client(), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems3)), (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems2)));
        ((KafkaServer)this.servers().apply(broker1)).shutdown();
        TestUtils$.MODULE$.waitForLeaderToBecome(this.client(), partition1, (Option<Object>)None$.MODULE$);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
        ((KafkaServer)this.servers().apply(broker2)).startup();
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{partition1, partition2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        ElectLeadersResult electResult = this.client().electLeaders(ElectionType.UNCLEAN, (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems)).asJava());
        Assert.assertFalse((boolean)((Optional)((java.util.Map)electResult.partitions().get()).get(partition1)).isPresent());
        Assert.assertTrue((boolean)(((Optional)((java.util.Map)electResult.partitions().get()).get(partition2)).get() instanceof ElectionNotNeededException));
        TestUtils$.MODULE$.assertLeader(this.client(), partition1, broker2);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2, broker3);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListReassignmentsDoesNotShowNonReassigningPartitions() {
        void apply_elems;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        this.createTopic(topic, 1, 3, this.createTopic$default$4());
        TopicPartition tp = new TopicPartition(topic, 0);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testListReassignmentsDoesNotShowDeletedPartitions() {
        void apply_elems;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "list-reassignments-no-reassignments";
        TopicPartition tp = new TopicPartition(topic, 0);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map reassignmentsMap = (java.util.Map)this.client().listPartitionReassignments((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems)).asJava()).reassignments().get();
        Assert.assertEquals((long)0L, (long)reassignmentsMap.size());
        java.util.Map allReassignmentsMap = (java.util.Map)this.client().listPartitionReassignments().reassignments().get();
        Assert.assertEquals((long)0L, (long)allReassignmentsMap.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testValidIncrementalAlterConfigs() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topic1CreateConfigs = new Properties();
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        topic1CreateConfigs.setProperty(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.createTopic(topic1, 1, 1, topic1CreateConfigs);
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.FlushMsProp(), "1000"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete()), AlterConfigOp.OpType.APPEND), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.RetentionMsProp(), ""), AlterConfigOp.OpType.DELETE)}));
        Object var15_6 = null;
        Collection topic1AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "lz4"), AlterConfigOp.OpType.SET)}));
        Object var16_8 = null;
        Collection topic2AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        objectArray[1] = new Tuple2((Object)topic2Resource, (Object)topic2AlterConfigs);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems5)).asJava());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems4)).asJava(), alterResult.values().keySet());
        alterResult.all().get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        Assert.assertEquals((Object)"compact,delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)((Object)(Defaults$.MODULE$.LogRetentionHours() * 60 * 60 * 1000)).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.RetentionMsProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)"lz4", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.SUBTRACT)}))).asJava();
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        objectArray2[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems3)).asJava());
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava()).all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        Assert.assertEquals((Object)"1000", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.FlushMsProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact()), AlterConfigOp.OpType.APPEND)}))).asJava();
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        objectArray3[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq4 = null;
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems2)).asJava(), new AlterConfigsOptions().validateOnly(true));
        alterResult.all().get();
        configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource}))).asJava()).all().get();
        Assert.assertEquals((Object)"delete", (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CleanupPolicyProp()).value());
        topic1AlterConfigs = (Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "zip"), AlterConfigOp.OpType.SET)}))).asJava();
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        objectArray4[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq5 = null;
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems)).asJava(), new AlterConfigsOptions().validateOnly(true));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalAlterConfigsDeleteAndSetBrokerConfigs() {
        void apply_elems;
        void apply_elems2;
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET)}));
        Object var14_2 = null;
        Collection $minus$greater$extension_y = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Object var2_3 = null;
        objectArray[0] = new Tuple2((Object)broker0Resource, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).all().get();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Expected to see the broker properties we just set", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "654"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "987"), AlterConfigOp.OpType.SET)}));
        Object var15_8 = null;
        Collection $minus$greater$extension_y2 = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        Object var3_9 = null;
        objectArray2[0] = new Tuple2((Object)broker0Resource, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        long l2 = 15000L;
        long waitUntilTrue_pause2 = 25L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l2) {
                throw Assertions$.MODULE$.fail("Expected to see the broker properties we just modified", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l2, waitUntilTrue_pause2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIncrementalAlterConfigsDeleteBrokerConfigs() {
        void apply_elems;
        void apply_elems2;
        this.client_$eq(Admin.create(this.createConfig()));
        ConfigResource broker0Resource = new ConfigResource(ConfigResource.Type.BROKER, "0");
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), "123"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), "456"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), "789"), AlterConfigOp.OpType.SET)}));
        Object var14_2 = null;
        Collection $minus$greater$extension_y = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Object var2_3 = null;
        objectArray[0] = new Tuple2((Object)broker0Resource, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).all().get();
        long l = 15000L;
        long waitUntilTrue_pause = 25L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Expected to see the broker properties we just set", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, waitUntilTrue_pause));
        }
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), ""), AlterConfigOp.OpType.DELETE), new AlterConfigOp(new ConfigEntry(DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), ""), AlterConfigOp.OpType.DELETE)}));
        Object var15_8 = null;
        Collection $minus$greater$extension_y2 = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        Object var3_9 = null;
        objectArray2[0] = new Tuple2((Object)broker0Resource, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).all().get();
        long l2 = 15000L;
        long waitUntilTrue_pause2 = 25L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(this, broker0Resource)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l2) {
                throw Assertions$.MODULE$.fail("Expected to see the broker properties we just removed to be deleted", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l2, waitUntilTrue_pause2));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidIncrementalAlterConfigs() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "incremental-alter-configs-topic-1";
        ConfigResource topic1Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        String topic2 = "incremental-alter-configs-topic-2";
        ConfigResource topic2Resource = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4());
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.75"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.65"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.SET)}));
        Object var15_5 = null;
        Collection topic1AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), AlterConfigOp.OpType.SET)}));
        Object var16_7 = null;
        Collection topic2AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[2];
        objectArray[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        objectArray[1] = new Tuple2((Object)topic2Resource, (Object)topic2AlterConfigs);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        AlterConfigsResult alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems6)).asJava());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource});
        if (set$ == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$, (Seq)apply_elems5)).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Error due to duplicate config keys"));
        ((KafkaFuture)alterResult.values().get(topic2Resource)).get();
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource}))).asJava()).all().get();
        Assert.assertEquals((long)2L, (long)configs.size());
        Assert.assertEquals((Object)((Object)Defaults$.MODULE$.LogCleanerMinCleanRatio()).toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assert.assertEquals((Object)Defaults$.MODULE$.CompressionType().toString(), (Object)((Config)configs.get(topic1Resource)).get(LogConfig$.MODULE$.CompressionTypeProp()).value());
        Assert.assertEquals((Object)"0.9", (Object)((Config)configs.get(topic2Resource)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Iterable asJavaCollectionConverter_i3 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "gzip"), AlterConfigOp.OpType.APPEND)}));
        Object var17_13 = null;
        topic1AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i3).asJavaCollection();
        Iterable asJavaCollectionConverter_i4 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.CompressionTypeProp(), "snappy"), AlterConfigOp.OpType.SUBTRACT)}));
        Object var18_14 = null;
        topic2AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i4).asJavaCollection();
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[2];
        objectArray2[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        objectArray2[1] = new Tuple2((Object)topic2Resource, (Object)topic2AlterConfigs);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq3 = null;
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems4)).asJava());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource, topic2Resource});
        if (set$2 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$2, (Seq)apply_elems3)).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value append is not allowed for config"));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic2Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Config value subtract is not allowed for config"));
        Iterable asJavaCollectionConverter_i5 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "1.1"), AlterConfigOp.OpType.SET)}));
        Object var19_17 = null;
        topic1AlterConfigs = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i5).asJavaCollection();
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        objectArray3[0] = new Tuple2((Object)topic1Resource, (Object)topic1AlterConfigs);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq5 = null;
        alterResult = this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems2)).asJava());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topic1Resource});
        if (set$3 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((scala.collection.Set)IterableFactory.apply$((IterableFactory)set$3, (Seq)apply_elems)).asJava(), alterResult.values().keySet());
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)alterResult.values().get(topic1Resource), InvalidRequestException.class, (Option<String>)new Some((Object)"Invalid config value for resource"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidAlterPartitionReassignments() {
        void apply_elems;
        Integer n;
        void apply_elems2;
        Integer n2;
        this.client_$eq(Admin.create(this.createConfig()));
        String topic = "alter-reassignments-topic-1";
        TopicPartition tp1 = new TopicPartition(topic, 0);
        TopicPartition tp2 = new TopicPartition(topic, 1);
        TopicPartition tp3 = new TopicPartition(topic, 2);
        this.createTopic(topic, 4, this.createTopic$default$3(), this.createTopic$default$4());
        int n3 = 0;
        int until$extension_end = this.brokerCount();
        Range.Exclusive map_this = new Range.Exclusive(n3, until$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer n4;
            Integer n5;
            Integer n6;
            Integer n7 = n6 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            n6 = null;
            Integer n8 = n5 = n7;
            n5 = null;
            Integer n9 = n4 = n8;
            n4 = null;
            n2 = n9;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n2 = null;
        }
        Object var17_7 = null;
        Object var18_8 = null;
        Object var19_9 = null;
        n2 = null;
        Optional<NewPartitionReassignment> validAssignment = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)((IndexedSeq)map_strictOptimizedMap_b.result())).asJava()));
        TopicPartition nonExistentTp1 = new TopicPartition("topicA", 0);
        TopicPartition nonExistentTp2 = new TopicPartition(topic, 4);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[5];
        objectArray[0] = new Tuple2((Object)tp1, validAssignment);
        objectArray[1] = new Tuple2((Object)tp2, validAssignment);
        objectArray[2] = new Tuple2((Object)tp3, validAssignment);
        objectArray[3] = new Tuple2((Object)nonExistentTp1, validAssignment);
        objectArray[4] = new Tuple2((Object)nonExistentTp2, validAssignment);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        java.util.Map nonExistentPartitionsResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems2)).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp1), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)nonExistentPartitionsResult.get(nonExistentTp2), UnknownTopicOrPartitionException.class, (Option<String>)None$.MODULE$);
        int n10 = 0;
        int until$extension_end2 = this.brokerCount() + 1;
        Range.Exclusive map_this2 = new Range.Exclusive(n10, until$extension_end2, 1);
        map_this2.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b2 = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it2 = map_this2.iterator();
        while (map_strictOptimizedMap_it2.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Integer n11;
            Integer n12;
            Integer n13;
            Integer n14 = n13 = Integer.valueOf(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it2.next()));
            n13 = null;
            Integer n15 = n12 = n14;
            n12 = null;
            Integer n16 = n11 = n15;
            n11 = null;
            n = n16;
            if (map_strictOptimizedMap_b2 == null) {
                throw null;
            }
            map_strictOptimizedMap_b2.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            n = null;
        }
        Object var21_21 = null;
        Object var22_22 = null;
        Object var23_23 = null;
        n = null;
        Optional<NewPartitionReassignment> extraNonExistentReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)((IndexedSeq)map_strictOptimizedMap_b2.result())).asJava()));
        Optional<NewPartitionReassignment> negativeIdReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{-3, -2, -1})).map((Function1 & Serializable)x$20 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$3(BoxesRunTime.unboxToInt((Object)x$20)))).asJava()));
        Optional<NewPartitionReassignment> duplicateReplica = Optional.of(new NewPartitionReassignment((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{0, 1, 1})).map((Function1 & Serializable)x$21 -> PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$4(BoxesRunTime.unboxToInt((Object)x$21)))).asJava()));
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[3];
        objectArray2[0] = new Tuple2((Object)tp1, extraNonExistentReplica);
        objectArray2[1] = new Tuple2((Object)tp2, negativeIdReplica);
        objectArray2[2] = new Tuple2((Object)tp3, duplicateReplica);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        java.util.Map invalidReplicaResult = this.client().alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems)).asJava()).values();
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp1), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp2), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)invalidReplicaResult.get(tp3), InvalidReplicaAssignmentException.class, (Option<String>)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLongTopicNames() {
        void apply_elems;
        void $minus$greater$extension_y;
        Admin client = Admin.create(this.createConfig());
        String longTopicName = String.join((CharSequence)"", Collections.nCopies(249, "x"));
        String invalidTopicName = String.join((CharSequence)"", Collections.nCopies(250, "x"));
        scala.collection.Seq newTopics2 = (scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewTopic[]{new NewTopic(invalidTopicName, 3, (short)3), new NewTopic(longTopicName, 3, (short)3)}));
        java.util.Map results = client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(newTopics2).asJava()).values();
        Assert.assertTrue((boolean)results.containsKey(longTopicName));
        ((KafkaFuture)results.get(longTopicName)).get();
        Assert.assertTrue((boolean)results.containsKey(invalidTopicName));
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals((KafkaFuture)results.get(invalidTopicName), InvalidTopicException.class, (Option<String>)None$.MODULE$);
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Object object = ((KafkaServer)this.servers().apply(0)).config().logDirs().apply(0);
        TopicPartitionReplica $minus$greater$extension_$this = new TopicPartitionReplica(longTopicName, 0, 0);
        Object var6_7 = null;
        object = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        TestUtils$.MODULE$.assertFutureExceptionTypeEquals(client.alterReplicaLogDirs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava()).all(), InvalidTopicException.class, (Option<String>)None$.MODULE$);
        client.close();
    }

    @Test
    public void testDescribeConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config loggerConfig = this.describeBrokerLoggers();
        String rootLogLevel = loggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        ConfigEntry logCleanerLogLevelConfig = loggerConfig.get("kafka.cluster.Replica");
        Assert.assertEquals((Object)rootLogLevel, (Object)logCleanerLogLevelConfig.value());
        Assert.assertEquals((Object)"kafka.cluster.Replica", (Object)logCleanerLogLevelConfig.name());
        Assert.assertEquals((Object)ConfigEntry.ConfigSource.DYNAMIC_BROKER_LOGGER_CONFIG, (Object)logCleanerLogLevelConfig.source());
        Assert.assertEquals((Object)false, (Object)logCleanerLogLevelConfig.isReadOnly());
        Assert.assertEquals((Object)false, (Object)logCleanerLogLevelConfig.isSensitive());
        Assert.assertTrue((boolean)logCleanerLogLevelConfig.synonyms().isEmpty());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevels() {
        this.client_$eq(Admin.create(this.createConfig()));
        Config initialLoggerConfig = this.describeBrokerLoggers();
        String initialRootLogLevel = initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.server.ReplicaManager").value());
        String newRootLogLevel = "DEBUG";
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}));
        Object var11_4 = null;
        Collection alterRootLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, true);
        Config validatedLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)validatedLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)changedRootLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", "ERROR"), AlterConfigOp.OpType.SET)}));
        Object var12_8 = null;
        Collection alterZKLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        this.alterBrokerLoggers(alterZKLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedZKLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)"ERROR", (Object)changedZKLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
        Iterable asJavaCollectionConverter_i3 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.log.LogCleaner", "ERROR"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.server.ReplicaManager", "TRACE"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.zookeeper.ZooKeeperClient", ""), AlterConfigOp.OpType.DELETE)}));
        Object var13_11 = null;
        Collection alterLogLevelsEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i3).asJavaCollection();
        this.alterBrokerLoggers(alterLogLevelsEntries, this.alterBrokerLoggers$default$2());
        Config alteredLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)alteredLoggerConfig.get("kafka.controller.KafkaController").value());
        Assert.assertEquals((Object)"ERROR", (Object)alteredLoggerConfig.get("kafka.log.LogCleaner").value());
        Assert.assertEquals((Object)"TRACE", (Object)alteredLoggerConfig.get("kafka.server.ReplicaManager").value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)alteredLoggerConfig.get("kafka.zookeeper.ZooKeeperClient").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCanResetLoggerToCurrentRoot() {
        this.client_$eq(Admin.create(this.createConfig()));
        String initialRootLogLevel = "TRACE";
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), initialRootLogLevel), AlterConfigOp.OpType.SET)}));
        Object var11_2 = null;
        Collection alterRootLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        this.alterBrokerLoggers(alterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config initialLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)initialLoggerConfig.get("kafka.controller.KafkaController").value());
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", "INFO"), AlterConfigOp.OpType.SET)}));
        Object var12_5 = null;
        Collection alterControllerLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        this.alterBrokerLoggers(alterControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config changedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)changedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)"INFO", (Object)changedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        Iterable asJavaCollectionConverter_i3 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.controller.KafkaController", ""), AlterConfigOp.OpType.DELETE)}));
        Object var13_8 = null;
        Collection deleteControllerLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i3).asJavaCollection();
        this.alterBrokerLoggers(deleteControllerLoggerEntry, this.alterBrokerLoggers$default$2());
        Config deletedControllerLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)initialRootLogLevel, (Object)deletedControllerLoggerConfig.get("kafka.controller.KafkaController").value());
        String newRootLogLevel = "ERROR";
        Iterable asJavaCollectionConverter_i4 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), newRootLogLevel), AlterConfigOp.OpType.SET)}));
        Object var14_12 = null;
        Collection newAlterRootLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i4).asJavaCollection();
        this.alterBrokerLoggers(newAlterRootLoggerEntry, this.alterBrokerLoggers$default$2());
        Config newRootLoggerConfig = this.describeBrokerLoggers();
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get(Log4jController$.MODULE$.ROOT_LOGGER()).value());
        Assert.assertEquals((Object)newRootLogLevel, (Object)newRootLoggerConfig.get("kafka.controller.KafkaController").value());
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsCannotResetRootLogger() {
        this.client_$eq(Admin.create(this.createConfig()));
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), ""), AlterConfigOp.OpType.DELETE)}));
        Object var2_1 = null;
        Collection deleteRootLoggerEntry = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterBrokerLoggers(deleteRootLoggerEntry, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2075))).getCause() instanceof InvalidRequestException));
    }

    @Test
    @Ignore
    public void testIncrementalAlterConfigsForLog4jLogLevelsDoesNotWorkWithInvalidConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String validLoggerName = "kafka.server.KafkaRequestHandler";
        ConfigEntry expectedValidLoggerLogLevel = this.describeBrokerLoggers().get(validLoggerName);
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.APPEND)}));
        Object var7_3 = null;
        Collection appendLogLevelEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterBrokerLoggers(appendLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2095))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Iterable asJavaCollectionConverter_i2 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "ERROR"), AlterConfigOp.OpType.SUBTRACT)}));
        Object var8_5 = null;
        Collection subtractLogLevelEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i2).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterBrokerLoggers(subtractLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2102))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Iterable asJavaCollectionConverter_i3 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("kafka.network.SocketServer", "OFF"), AlterConfigOp.OpType.SET)}));
        Object var9_7 = null;
        Collection invalidLogLevelLogLevelEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i3).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterBrokerLoggers(invalidLogLevelLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2109))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
        Iterable asJavaCollectionConverter_i4 = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AlterConfigOp[]{new AlterConfigOp(new ConfigEntry("kafka.server.KafkaRequestHandler", "INFO"), AlterConfigOp.OpType.SET), new AlterConfigOp(new ConfigEntry("Some Other LogCleaner", "ERROR"), AlterConfigOp.OpType.SET)}));
        Object var10_9 = null;
        Collection invalidLoggerNameLogLevelEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i4).asJavaCollection();
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.alterBrokerLoggers(invalidLoggerNameLogLevelEntries, this.alterBrokerLoggers$default$2()), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2116))).getCause() instanceof InvalidRequestException));
        this.assertLogLevelDidNotChange$1(expectedValidLoggerLogLevel, validLoggerName);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Ignore
    public void testAlterConfigsForLog4jLogLevelsDoesNotWork() {
        void apply_elems;
        void $minus$greater$extension_y;
        this.client_$eq(Admin.create(this.createConfig()));
        Iterable asJavaCollectionConverter_i = (Iterable)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigEntry[]{new ConfigEntry("kafka.controller.KafkaController", "INFO")}));
        Object var6_1 = null;
        Collection alterLogLevelsEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        Config config = new Config(alterLogLevelsEntries);
        ConfigResource $minus$greater$extension_$this = this.brokerLoggerConfigResource();
        Object var3_4 = null;
        config = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        AlterConfigsResult alterResult = this.client().alterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava());
        Assert.assertTrue((boolean)(((Throwable)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (Void)((KafkaFuture)alterResult.values().get(this.brokerLoggerConfigResource())).get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2132))).getCause() instanceof InvalidRequestException));
    }

    /*
     * WARNING - void declaration
     */
    public void alterBrokerLoggers(Collection<AlterConfigOp> entries, boolean validateOnly) {
        void apply_elems;
        ConfigResource configResource;
        if (!validateOnly) {
            ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(entries).asScala()).foreach((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$alterBrokerLoggers$1(this, entry)));
        }
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        ConfigResource configResource2 = configResource = this.brokerLoggerConfigResource();
        configResource = null;
        ConfigResource $minus$greater$extension_$this = configResource2;
        Object var3_4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, entries);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        ((KafkaFuture)this.client().incrementalAlterConfigs((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava(), new AlterConfigsOptions().validateOnly(validateOnly)).values().get(this.brokerLoggerConfigResource())).get();
    }

    public boolean alterBrokerLoggers$default$2() {
        return false;
    }

    public Config describeBrokerLoggers() {
        return (Config)((KafkaFuture)this.client().describeConfigs(Collections.singletonList(this.brokerLoggerConfigResource())).values().get(this.brokerLoggerConfigResource())).get();
    }

    private void teardownBrokerLoggers() {
        if (this.changedBrokerLoggers().nonEmpty()) {
            scala.collection.immutable.Set validLoggers = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.describeBrokerLoggers().entries()).asScala()).filterNot((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$teardownBrokerLoggers$1(x$22)))).map((Function1 & Serializable)x$23 -> x$23.name())).toSet();
            Iterable asJavaCollectionConverter_i = (Iterable)this.changedBrokerLoggers().intersect((scala.collection.Set)validLoggers).map((Function1 & Serializable)logger -> new AlterConfigOp(new ConfigEntry(logger, ""), AlterConfigOp.OpType.DELETE));
            Object var3_2 = null;
            Collection unsetBrokerLoggersEntries = new JavaConverters.AsJavaCollection(asJavaCollectionConverter_i).asJavaCollection();
            .colon.colon asJavaCollectionConverter_i2 = new .colon.colon((Object)new AlterConfigOp(new ConfigEntry(Log4jController$.MODULE$.ROOT_LOGGER(), "FATAL"), AlterConfigOp.OpType.SET), (List)Nil$.MODULE$);
            Object var4_4 = null;
            this.alterBrokerLoggers(new JavaConverters.AsJavaCollection((Iterable)asJavaCollectionConverter_i2).asJavaCollection(), this.alterBrokerLoggers$default$2());
            this.alterBrokerLoggers(unsetBrokerLoggersEntries, this.alterBrokerLoggers$default$2());
            this.changedBrokerLoggers().clear();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testMetadataRefresh$1(PlaintextAdminIntegrationTest $this, KafkaServer x$2) {
        return x$2.config().brokerId() == TestUtils$.MODULE$.waitUntilControllerElected($this.zkClient(), 15000L);
    }

    public static final /* synthetic */ int $anonfun$testDescribeCluster$1() {
        return -1;
    }

    public static final /* synthetic */ void $anonfun$testDescribeCluster$2(String[] brokers$1, Node node) {
        String hostStr = new StringBuilder(1).append(node.host()).append(":").append(node.port()).toString();
        Assert.assertTrue((String)new StringBuilder(45).append("Unknown host:port pair ").append(hostStr).append(" in brokerVersionInfos").toString(), (boolean)ArrayOps$.MODULE$.contains$extension((Object)brokers$1, (Object)hostStr));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ int $anonfun$testDescribeLogDirs$1(Tuple2 x0$1) {
        void var1_1;
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        int leaderId = x0$1._2$mcI$sp();
        return (int)var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$5(int brokerId$1, KafkaServer x$5) {
        return x$5.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeLogDirs$7(String topic$1, TopicPartition x$6) {
        String string = x$6.topic();
        return !(string != null ? !string.equals(topic$1) : topic$1 != null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$10(KafkaServer server$1, String logDir$1, TopicPartition tp) {
        LogManager qual$1 = server$1.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)logDir$1);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$9(KafkaServer server$1, Tuple2 x0$3) {
        if (x0$3 != null) {
            String logDir = (String)x0$3._1();
            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)x0$3._2();
            ((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala()).keys().foreach((Function1 & Serializable)tp -> {
                PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$10(server$1, logDir, tp);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testDescribeLogDirs$4(PlaintextAdminIntegrationTest $this, MapView partitionsByBroker$1, java.util.Map logDirInfosByBroker$1, String topic$1, int brokerId) {
        KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$5(brokerId, x$5))).get();
        Seq expectedPartitions = (Seq)partitionsByBroker$1.apply((Object)brokerId);
        java.util.Map logDirInfos = (java.util.Map)logDirInfosByBroker$1.get(brokerId);
        MapView replicaInfos = ((MapOps)((MapOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            DescribeLogDirsResponse.LogDirInfo logDirInfo = (DescribeLogDirsResponse.LogDirInfo)x0$2._2();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfo.replicaInfos).asScala();
            return map;
        })).filterKeys((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$7(topic$1, x$6)));
        Assert.assertEquals((Object)expectedPartitions.toSet(), (Object)((IterableOnceOps)replicaInfos.keys().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.partition()))).toSet());
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(logDirInfos).asScala()).foreach((Function1 & Serializable)x0$3 -> {
            PlaintextAdminIntegrationTest.$anonfun$testDescribeLogDirs$9(server, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testDescribeReplicaLogDirs$3(TopicPartitionReplica topicPartitionReplica$1, KafkaServer x$8) {
        return x$8.config().brokerId() == topicPartitionReplica$1.brokerId();
    }

    public static final /* synthetic */ void $anonfun$testDescribeReplicaLogDirs$2(PlaintextAdminIntegrationTest $this, Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartitionReplica topicPartitionReplica = (TopicPartitionReplica)x0$2._1();
            DescribeReplicaLogDirsResult.ReplicaLogDirInfo replicaDirInfo = (DescribeReplicaLogDirsResult.ReplicaLogDirInfo)x0$2._2();
            KafkaServer server = (KafkaServer)$this.servers().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testDescribeReplicaLogDirs$3(topicPartitionReplica, x$8))).get();
            TopicPartition tp = new TopicPartition(topicPartitionReplica.topic(), topicPartitionReplica.partition());
            LogManager qual$1 = server.logManager();
            boolean x$2 = qual$1.getLog$default$2();
            Assert.assertEquals((Object)((Log)qual$1.getLog(tp, x$2).get()).dir().getParent(), (Object)replicaDirInfo.getCurrentReplicaLogDir());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$4(KafkaFuture future) {
        Assert.assertTrue((boolean)(((ExecutionException)Assertions$.MODULE$.intercept((Function0 & Serializable)() -> (Void)future.get(), ClassTag$.MODULE$.apply(ExecutionException.class), new Position("PlaintextAdminIntegrationTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231))).getCause() instanceof UnknownTopicOrPartitionException));
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$6(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, KafkaServer server) {
        LogManager qual$1 = server.logManager();
        boolean x$2 = qual$1.getLog$default$2();
        String logDir = ((Log)qual$1.getLog(tp$1, x$2).get()).dir().getParent();
        Assert.assertEquals((Object)firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server.config().brokerId())), (Object)logDir);
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$8(KafkaServer server$2, TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3) {
        LogManager qual$2 = server$2.logManager();
        boolean x$4 = qual$2.getLog$default$2();
        String logDir = ((Log)qual$2.getLog(tp$1, x$4).get()).dir().getParent();
        Object object = secondReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$2.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$9() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$7(TopicPartition tp$1, scala.collection.immutable.Map secondReplicaAssignment$1, String topic$3, KafkaServer server) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$8(server, tp$1, secondReplicaAssignment$1, topic$3)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("timed out waiting for replica movement", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$11(AtomicInteger numMessages$1) {
        return numMessages$1.get() > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$12(AtomicInteger numMessages$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(60).append("only ").append(numMessages$1).append(" messages are produced before timeout. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$14(KafkaServer server$3, TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3) {
        LogManager qual$3 = server$3.logManager();
        boolean x$22 = qual$3.getLog$default$2();
        String logDir = ((Log)qual$3.getLog(tp$1, x$22).get()).dir().getParent();
        Object object = firstReplicaAssignment$1.apply((Object)new TopicPartitionReplica(topic$3, 0, server$3.config().brokerId()));
        return !(object != null ? !object.equals(logDir) : logDir != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$15(scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(56).append("timed out waiting for replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$13(TopicPartition tp$1, scala.collection.immutable.Map firstReplicaAssignment$1, String topic$3, scala.concurrent.Future producerFuture$1, KafkaServer server) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$14(server, tp$1, firstReplicaAssignment$1, topic$3)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testAlterReplicaLogDirs$15(producerFuture$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testAlterReplicaLogDirs$16(AtomicInteger numMessages$1, int currentMessagesNum$1) {
        return numMessages$1.get() - currentMessagesNum$1 > 10;
    }

    public static final /* synthetic */ String $anonfun$testAlterReplicaLogDirs$17(AtomicInteger numMessages$1, int currentMessagesNum$1, scala.concurrent.Future producerFuture$1) {
        return new StringBuilder(83).append("only ").append(numMessages$1.get() - currentMessagesNum$1).append(" messages are produced within timeout after replica movement. Producer future ").append(producerFuture$1.value()).toString();
    }

    public static final /* synthetic */ void $anonfun$testAlterReplicaLogDirs$18(Tuple2 x0$1) {
        if (x0$1 != null) {
            ConsumerRecord consumerRecord = (ConsumerRecord)x0$1._1();
            int index = x0$1._2$mcI$sp();
            Assert.assertEquals((Object)new StringBuilder(21).append("xxxxxxxxxxxxxxxxxxxx-").append(index).toString(), (Object)new String((byte[])consumerRecord.value()));
            return;
        }
        throw new MatchError(null);
    }

    private final java.util.List partitions$1(String topic, Option expectedNumPartitionsOpt) {
        Admin x$1 = this.client();
        DescribeTopicsOptions x$4 = this.getTopicMetadata$default$3();
        return this.getTopicMetadata(x$1, topic, x$4, (Option<Object>)expectedNumPartitionsOpt).partitions();
    }

    private final int numPartitions$1(String topic, Option expectedNumPartitionsOpt) {
        return this.partitions$1(topic, expectedNumPartitionsOpt).size();
    }

    private static final Option numPartitions$default$2$1() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$1(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, (Option)None$.MODULE$) == 3;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$2() {
        return "Timed out waiting for new partitions to appear";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testCreatePartitions$5(PlaintextAdminIntegrationTest $this, ObjectRef alterResult$1, String topic1$1, String topic2$1, java.util.List newPartition2Assignments$1, ObjectRef altered$1, CreatePartitionsOptions option) {
        void apply_elems;
        void $minus$greater$extension_y;
        void apply_elems2;
        void $minus$greater$extension_y2;
        void apply_elems3;
        void $minus$greater$extension_y3;
        void apply_elems4;
        void $minus$greater$extension_y4;
        void apply_elems5;
        void $minus$greater$extension_y5;
        void apply_elems6;
        void $minus$greater$extension_y6;
        void apply_elems7;
        void $minus$greater$extension_y7;
        void apply_elems8;
        void $minus$greater$extension_y8;
        void apply_elems9;
        void $minus$greater$extension_y9;
        void apply_elems10;
        void $minus$greater$extension_y10;
        void apply_elems11;
        void $minus$greater$extension_y11;
        void apply_elems12;
        void $minus$greater$extension_y12;
        void apply_elems13;
        void $minus$greater$extension_y13;
        String desc = option.validateOnly() ? "validateOnly" : "validateOnly=false";
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        NewPartitions newPartitions = NewPartitions.increaseTo((int)1);
        Object $minus$greater$extension_$this = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var22_9 = null;
        newPartitions = null;
        objectArray[0] = new Tuple2($minus$greater$extension_$this, (Object)$minus$greater$extension_y13);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems13)).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(63).append(desc).append(": Expect InvalidPartitionsException when newCount is a decrease").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested 1.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$2 = Predef$.MODULE$.Map();
        Object[] objectArray2 = new Tuple2[1];
        NewPartitions newPartitions2 = NewPartitions.increaseTo((int)3);
        Object $minus$greater$extension_$this2 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        Object var24_13 = null;
        newPartitions2 = null;
        objectArray2[0] = new Tuple2($minus$greater$extension_$this2, (Object)$minus$greater$extension_y12);
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray2);
        if (map$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$2, (Seq)apply_elems12)).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidPartitionsException when requesting a noop").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)3)));
        }
        Map$ map$3 = Predef$.MODULE$.Map();
        Object[] objectArray3 = new Tuple2[1];
        NewPartitions newPartitions3 = NewPartitions.increaseTo((int)3, (java.util.List)newPartition2Assignments$1);
        Object $minus$greater$extension_$this3 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        Object var26_17 = null;
        newPartitions3 = null;
        objectArray3[0] = new Tuple2($minus$greater$extension_$this3, (Object)$minus$greater$extension_y11);
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray3);
        if (map$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$3, (Seq)apply_elems11)).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)3)));
        }
        Map$ map$4 = Predef$.MODULE$.Map();
        Object[] objectArray4 = new Tuple2[1];
        NewPartitions newPartitions4 = NewPartitions.increaseTo((int)3, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)((IterableOnceOps)((SeqOps)JavaConverters$.MODULE$.asScalaBufferConverter(newPartition2Assignments$1).asScala()).reverse()).toList()).asJava()));
        Object $minus$greater$extension_$this4 = Predef$.MODULE$.ArrowAssoc((Object)topic2$1);
        Object var28_21 = null;
        newPartitions4 = null;
        objectArray4[0] = new Tuple2($minus$greater$extension_$this4, (Object)$minus$greater$extension_y10);
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray4);
        if (map$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$4, (Seq)apply_elems10)).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic2$1)).get();
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic already has 3 partitions.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic2$1, (Option)new Some((Object)3)));
        }
        String unknownTopic = "an-unknown-topic";
        Map$ map$5 = Predef$.MODULE$.Map();
        Object[] objectArray5 = new Tuple2[1];
        NewPartitions newPartitions5 = NewPartitions.increaseTo((int)2);
        Object $minus$greater$extension_$this5 = Predef$.MODULE$.ArrowAssoc((Object)unknownTopic);
        Object var30_26 = null;
        newPartitions5 = null;
        objectArray5[0] = new Tuple2($minus$greater$extension_$this5, (Object)$minus$greater$extension_y9);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray5);
        if (map$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$5, (Seq)apply_elems9)).asJava(), option);
        try {
            ((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(unknownTopic)).get();
            Assert.fail((String)new StringBuilder(58).append(desc).append(": Expect InvalidTopicException when using an unknown topic").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof UnknownTopicOrPartitionException));
            Assert.assertEquals((String)desc, (Object)"The topic 'an-unknown-topic' does not exist.", (Object)e.getCause().getMessage());
        }
        Map$ map$6 = Predef$.MODULE$.Map();
        Object[] objectArray6 = new Tuple2[1];
        NewPartitions newPartitions6 = NewPartitions.increaseTo((int)-22);
        Object $minus$greater$extension_$this6 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var32_30 = null;
        newPartitions6 = null;
        objectArray6[0] = new Tuple2($minus$greater$extension_$this6, (Object)$minus$greater$extension_y8);
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray6);
        if (map$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$6, (Seq)apply_elems8)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(60).append(desc).append(": Expect InvalidPartitionsException when newCount is invalid").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidPartitionsException));
            Assert.assertEquals((String)desc, (Object)"Topic currently has 3 partitions, which is higher than the requested -22.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$7 = Predef$.MODULE$.Map();
        Object[] objectArray7 = new Tuple2[1];
        NewPartitions newPartitions7 = NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(1, 2)));
        Object $minus$greater$extension_$this7 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var34_34 = null;
        newPartitions7 = null;
        objectArray7[0] = new Tuple2($minus$greater$extension_$this7, (Object)$minus$greater$extension_y7);
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray7);
        if (map$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$7, (Seq)apply_elems7)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(71).append(desc).append(": Expect InvalidPartitionsException when #brokers != replication factor").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [3] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$8 = Predef$.MODULE$.Map();
        Object[] objectArray8 = new Tuple2[1];
        NewPartitions newPartitions8 = NewPartitions.increaseTo((int)6, Arrays.asList(Arrays.asList(1)));
        Object $minus$greater$extension_$this8 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var36_38 = null;
        newPartitions8 = null;
        objectArray8[0] = new Tuple2($minus$greater$extension_$this8, (Object)$minus$greater$extension_y6);
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray8);
        if (map$8 == null) {
            throw null;
        }
        arraySeq8 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$8, (Seq)apply_elems6)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 3 but 1 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$9 = Predef$.MODULE$.Map();
        Object[] objectArray9 = new Tuple2[1];
        NewPartitions newPartitions9 = NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(1), Arrays.asList(2)));
        Object $minus$greater$extension_$this9 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var38_42 = null;
        newPartitions9 = null;
        objectArray9[0] = new Tuple2($minus$greater$extension_$this9, (Object)$minus$greater$extension_y5);
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray9);
        if (map$9 == null) {
            throw null;
        }
        arraySeq9 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$9, (Seq)apply_elems5)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(83).append(desc).append(": Expect InvalidReplicaAssignmentException when #assignments != newCount - oldCount").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 2 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$10 = Predef$.MODULE$.Map();
        Object[] objectArray10 = new Tuple2[1];
        NewPartitions newPartitions10 = NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(1, 1)));
        Object $minus$greater$extension_$this10 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var40_46 = null;
        newPartitions10 = null;
        objectArray10[0] = new Tuple2($minus$greater$extension_$this10, (Object)$minus$greater$extension_y4);
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray10);
        if (map$10 == null) {
            throw null;
        }
        arraySeq10 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$10, (Seq)apply_elems4)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(81).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments has duplicate brokers").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Duplicate brokers not allowed in replica assignment: 1, 1 for partition id 3.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$11 = Predef$.MODULE$.Map();
        Object[] objectArray11 = new Tuple2[1];
        NewPartitions newPartitions11 = NewPartitions.increaseTo((int)5, Arrays.asList(Arrays.asList(1), Arrays.asList(1, 0)));
        Object $minus$greater$extension_$this11 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var42_50 = null;
        newPartitions11 = null;
        objectArray11[0] = new Tuple2($minus$greater$extension_$this11, (Object)$minus$greater$extension_y3);
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray11);
        if (map$11 == null) {
            throw null;
        }
        arraySeq11 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$11, (Seq)apply_elems3)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(94).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments have differently sized inner lists").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Inconsistent replication factor between partitions, partition 0 has 1 while partitions [4] have replication factors [2], respectively.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$12 = Predef$.MODULE$.Map();
        Object[] objectArray12 = new Tuple2[1];
        NewPartitions newPartitions12 = NewPartitions.increaseTo((int)4, Arrays.asList(Arrays.asList(12)));
        Object $minus$greater$extension_$this12 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var44_54 = null;
        newPartitions12 = null;
        objectArray12[0] = new Tuple2($minus$greater$extension_$this12, (Object)$minus$greater$extension_y2);
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray12);
        if (map$12 == null) {
            throw null;
        }
        arraySeq12 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$12, (Seq)apply_elems2)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(86).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments contains an unknown broker").toString());
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Unknown broker(s) in replica assignment: 12.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
        }
        Map$ map$13 = Predef$.MODULE$.Map();
        Object[] objectArray13 = new Tuple2[1];
        NewPartitions newPartitions13 = NewPartitions.increaseTo((int)4, Collections.emptyList());
        Object $minus$greater$extension_$this13 = Predef$.MODULE$.ArrowAssoc((Object)topic1$1);
        Object var46_58 = null;
        newPartitions13 = null;
        objectArray13[0] = new Tuple2($minus$greater$extension_$this13, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray13);
        if (map$13 == null) {
            throw null;
        }
        arraySeq13 = null;
        alterResult$1.elem = $this.client().createPartitions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$13, (Seq)apply_elems)).asJava(), option);
        try {
            altered$1.elem = (Void)((KafkaFuture)((CreatePartitionsResult)alterResult$1.elem).values().get(topic1$1)).get();
            Assert.fail((String)new StringBuilder(68).append(desc).append(": Expect InvalidReplicaAssignmentException when assignments is empty").toString());
            return;
        }
        catch (ExecutionException e) {
            Assert.assertTrue((String)desc, (boolean)(e.getCause() instanceof InvalidReplicaAssignmentException));
            Assert.assertEquals((String)desc, (Object)"Increasing the number of partitions by 1 but 0 assignments provided.", (Object)e.getCause().getMessage());
            Assert.assertEquals((String)desc, (long)3L, (long)$this.numPartitions$1(topic1$1, PlaintextAdminIntegrationTest.numPartitions$default$2$1()));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitions$6(PlaintextAdminIntegrationTest $this, String topic1$1) {
        return $this.numPartitions$1(topic1$1, (Option)None$.MODULE$) == 4;
    }

    public static final /* synthetic */ String $anonfun$testCreatePartitions$7() {
        return "Timed out waiting for new partitions to appear";
    }

    public static final /* synthetic */ void $anonfun$testLogStartOffsetCheckpoint$1(PlaintextAdminIntegrationTest $this, int i) {
        $this.killBroker(i);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testLogStartOffsetCheckpoint$2(PlaintextAdminIntegrationTest $this, ObjectRef result$1, ObjectRef lowWatermark$1) {
        void apply_elems;
        void $minus$greater$extension_y;
        Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        RecordsToDelete recordsToDelete = RecordsToDelete.beforeOffset((long)0L);
        TopicPartition $minus$greater$extension_$this = $this.topicPartition();
        Object var7_4 = null;
        recordsToDelete = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        result$1.elem = $this.client().deleteRecords((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)MapFactory.apply$((MapFactory)map$, (Seq)apply_elems)).asJava());
        lowWatermark$1.elem = None$.MODULE$;
        KafkaFuture future = (KafkaFuture)((DeleteRecordsResult)result$1.elem).lowWatermarks().get($this.topicPartition());
        try {
            lowWatermark$1.elem = new Some((Object)((DeletedRecords)future.get()).lowWatermark());
            return ((Option)lowWatermark$1.elem).contains((Object)5L);
        }
        catch (Throwable throwable) {
            ExecutionException executionException;
            if (!(throwable instanceof ExecutionException) || !((executionException = (ExecutionException)throwable).getCause() instanceof LeaderNotAvailableException) && !(executionException.getCause() instanceof NotLeaderForPartitionException)) {
                throw throwable;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$4() {
        return "no response within the timeout";
    }

    public static final /* synthetic */ String $anonfun$testLogStartOffsetCheckpoint$3(ObjectRef lowWatermark$1) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder(56).append("Expected low watermark of the partition to be 5 but got ");
        Option option = (Option)lowWatermark$1.elem;
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string;
            String string2 = string = "no response within the timeout";
            string = null;
            object = string2;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var1_1 = null;
        object = null;
        return stringBuilder.append(object2).toString();
    }

    public static final /* synthetic */ void $anonfun$testLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int followerIndex$1) {
        Option option = ((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition());
        None$ none$ = None$.MODULE$;
        return option == null || !option.equals(none$);
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$2() {
        return "Expected follower to create replica for partition";
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedStartOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset() == expectedStartOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(long expectedStartOffset$1) {
        return new StringBuilder(51).append("Expected follower to discover new log start offset ").append(expectedStartOffset$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(PlaintextAdminIntegrationTest $this, int followerIndex$1, long expectedEndOffset$1) {
        return ((Log)((KafkaServer)$this.servers().apply(followerIndex$1)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset() == expectedEndOffset$1;
    }

    public static final /* synthetic */ String $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(long expectedEndOffset$1) {
        return new StringBuilder(48).append("Expected follower to catch up to log end offset ").append(expectedEndOffset$1).toString();
    }

    private final void waitForFollowerLog$1(long expectedStartOffset, long expectedEndOffset, int followerIndex$1) {
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$1(this, followerIndex$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Expected follower to create replica for partition", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$3(this, followerIndex$1, expectedStartOffset)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$4(expectedStartOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$5(this, followerIndex$1, expectedEndOffset)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$6(expectedEndOffset), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l5, l6));
        }
    }

    public static final /* synthetic */ void $anonfun$testReplicaCanFetchFromLogStartOffsetAfterDeleteRecords$7(PlaintextAdminIntegrationTest $this, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
    }

    public static final /* synthetic */ void $anonfun$testAlterLogDirsAfterDeleteRecords$1(PlaintextAdminIntegrationTest $this, int expectedLEO$1, int i) {
        Assert.assertEquals((long)3L, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logStartOffset());
        Assert.assertEquals((long)expectedLEO$1, (long)((Log)((KafkaServer)$this.servers().apply(i)).replicaManager().localLog($this.topicPartition()).get()).logEndOffset());
    }

    public static final /* synthetic */ boolean $anonfun$testAlterLogDirsAfterDeleteRecords$2(PlaintextAdminIntegrationTest $this, String futureLogDir$1) {
        String string = futureLogDir$1;
        LogManager qual$1 = ((KafkaServer)$this.servers().apply(0)).logManager();
        TopicPartition x$1 = $this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        String string2 = ((Log)qual$1.getLog(x$1, x$2).get()).dir().getParent();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAlterLogDirsAfterDeleteRecords$3() {
        return "timed out waiting for replica movement";
    }

    public static final /* synthetic */ boolean $anonfun$subscribeAndWaitForAssignment$1(KafkaConsumer consumer$1) {
        return !consumer$1.assignment().isEmpty();
    }

    public static final /* synthetic */ String $anonfun$subscribeAndWaitForAssignment$2() {
        return "Expected non-empty assignment";
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, int i) {
        ProducerRecord record = new ProducerRecord(topicPartition$1.topic(), Integer.valueOf(topicPartition$1.partition()), (Object)String.valueOf((Object)i).getBytes(), (Object)String.valueOf((Object)i).getBytes());
        $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(21).append("Sending this record: ").append(record).toString());
        return producer$1.send(record);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$2(String testGroupId$1, ConsumerGroupListing x$17) {
        String string = x$17.groupId();
        return !(string != null ? !string.equals(testGroupId$1) : testGroupId$1 != null);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$1(PlaintextAdminIntegrationTest $this, String testGroupId$1) {
        return ((Iterable)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)$this.client().listConsumerGroups().all().get()).asScala()).filter((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)PlaintextAdminIntegrationTest.$anonfun$testConsumerGroups$2(testGroupId$1, x$17)))).nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$3(String testGroupId$1) {
        return new StringBuilder(28).append("Expected to be able to list ").append(testGroupId$1).toString();
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$4(String testTopicName$1, TopicPartition tp) {
        return tp.topic().equals(testTopicName$1);
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerGroups$5(PlaintextAdminIntegrationTest $this, String testGroupId$1, String testTopicName$1) {
        TopicPartition part;
        java.util.Map parts = (java.util.Map)$this.client().listConsumerGroupOffsets(testGroupId$1).partitionsToOffsetAndMetadata().get();
        return parts.containsKey(part = new TopicPartition(testTopicName$1, 0)) && ((OffsetAndMetadata)parts.get(part)).offset() == 1L;
    }

    public static final /* synthetic */ String $anonfun$testConsumerGroups$6() {
        return "Expected the offset for partition 0 to eventually become 1.";
    }

    private final int preferredLeader$1(TopicPartition topicPartition) {
        return ((Node)((TopicPartitionInfo)this.getTopicMetadata(this.client(), topicPartition.topic(), this.getTopicMetadata$default$3(), this.getTopicMetadata$default$4()).partitions().get(topicPartition.partition())).replicas().get(0)).id();
    }

    public static final /* synthetic */ boolean $anonfun$testElectPreferredLeaders$1(PlaintextAdminIntegrationTest $this, TopicPartition partition1$1, int preferred$1, TopicPartition partition2$1) {
        return $this.preferredLeader$1(partition1$1) == preferred$1 && $this.preferredLeader$1(partition2$1) == preferred$1;
    }

    public static final /* synthetic */ String $anonfun$testElectPreferredLeaders$2(PlaintextAdminIntegrationTest $this, int preferred$1, TopicPartition partition1$1, TopicPartition partition2$1) {
        return new StringBuilder(50).append("Expected preferred leader to become ").append(preferred$1).append(", but is ").append($this.preferredLeader$1(partition1$1)).append(" and ").append($this.preferredLeader$1(partition2$1)).toString();
    }

    private final void changePreferredLeader$1(scala.collection.Seq newAssignment, TopicPartition partition1$1, TopicPartition partition2$1) {
        Map.EmptyMap$ emptyMap$;
        int preferred = BoxesRunTime.unboxToInt((Object)newAssignment.head());
        int prior1 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition1$1).get());
        int prior2 = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(partition2$1).get());
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        Map.EmptyMap$ emptyMap$2 = emptyMap$ = Map.EmptyMap$.MODULE$;
        emptyMap$ = null;
        Map.EmptyMap$ m = emptyMap$2;
        if (prior1 != preferred) {
            m = (scala.collection.immutable.Map)m.$plus(new Tuple2((Object)partition1$1, (Object)newAssignment));
        }
        if (prior2 != preferred) {
            m = (scala.collection.immutable.Map)m.$plus(new Tuple2((Object)partition2$1, (Object)newAssignment));
        }
        this.zkClient().createPartitionReassignment((Map)m);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$1(this, partition1$1, preferred, partition2$1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                throw Assertions$.MODULE$.fail(PlaintextAdminIntegrationTest.$anonfun$testElectPreferredLeaders$2(this, preferred, partition1$1, partition2$1), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(waitUntilTrue_waitTimeMs, l));
        }
        TestUtils$.MODULE$.assertLeader(this.client(), partition1$1, prior1);
        TestUtils$.MODULE$.assertLeader(this.client(), partition2$1, prior2);
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{broker0Resource$1}))).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$5() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$6(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$1) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{broker0Resource$1}))).asJava()).all().get()).get(broker0Resource$1)).entries()).asScala()).map((Function1 & Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "654".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "987".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteAndSetBrokerConfigs$11() {
        return "Expected to see the broker properties we just modified";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$1(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{broker0Resource$2}))).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable)x0$1 -> new Tuple2((Object)x0$1.name(), (Object)x0$1.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "123".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "456".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "789".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$6() {
        return "Expected to see the broker properties we just set";
    }

    public static final /* synthetic */ boolean $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$7(PlaintextAdminIntegrationTest $this, ConfigResource broker0Resource$2) {
        scala.collection.immutable.Map broker0Configs = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((Config)((java.util.Map)$this.client().describeConfigs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((scala.collection.Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{broker0Resource$2}))).asJava()).all().get()).get(broker0Resource$2)).entries()).asScala()).map((Function1 & Serializable)x0$2 -> new Tuple2((Object)x0$2.name(), (Object)x0$2.value()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        return "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp(), (Function0 & Serializable)() -> "")) && "".equals(broker0Configs.getOrElse((Object)DynamicConfig.Broker$.MODULE$.ReplicaAlterLogDirsIoMaxBytesPerSecondProp(), (Function0 & Serializable)() -> ""));
    }

    public static final /* synthetic */ String $anonfun$testIncrementalAlterConfigsDeleteBrokerConfigs$12() {
        return "Expected to see the broker properties we just removed to be deleted";
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1(int x$18) {
        return BoxesRunTime.boxToInteger((int)x$18);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2(int x$19) {
        return BoxesRunTime.boxToInteger((int)x$19);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$3(int x$20) {
        return BoxesRunTime.boxToInteger((int)x$20);
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$4(int x$21) {
        return BoxesRunTime.boxToInteger((int)x$21);
    }

    private final void assertLogLevelDidNotChange$1(ConfigEntry expectedValidLoggerLogLevel$1, String validLoggerName$1) {
        Assert.assertEquals((Object)expectedValidLoggerLogLevel$1, (Object)this.describeBrokerLoggers().get(validLoggerName$1));
    }

    public static final /* synthetic */ boolean $anonfun$alterBrokerLoggers$1(PlaintextAdminIntegrationTest $this, AlterConfigOp entry) {
        return $this.changedBrokerLoggers().add((Object)entry.configEntry().name());
    }

    public static final /* synthetic */ boolean $anonfun$teardownBrokerLoggers$1(ConfigEntry x$22) {
        return x$22.name().equals(Log4jController$.MODULE$.ROOT_LOGGER());
    }

    public PlaintextAdminIntegrationTest() {
        this.topic = "topic";
        this.partition = 0;
    }

    public static final /* synthetic */ Integer $anonfun$testDescribeLogDirs$3$adapted(Object x$1) {
        return BoxesRunTime.unboxToInt((Object)x$1);
    }

    public static final /* synthetic */ Future $anonfun$sendRecords$1$adapted(PlaintextAdminIntegrationTest $this, TopicPartition topicPartition$1, KafkaProducer producer$1, Object i) {
        return PlaintextAdminIntegrationTest.$anonfun$sendRecords$1($this, topicPartition$1, producer$1, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$1$adapted(Object x$18) {
        return PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$1(BoxesRunTime.unboxToInt((Object)x$18));
    }

    public static final /* synthetic */ Integer $anonfun$testInvalidAlterPartitionReassignments$2$adapted(Object x$19) {
        return PlaintextAdminIntegrationTest.$anonfun$testInvalidAlterPartitionReassignments$2(BoxesRunTime.unboxToInt((Object)x$19));
    }
}

