/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import kafka.api.FixedPortTestUtils$;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]e\u0001B\u000e\u001d\u0001\u0005BQ\u0001\u000b\u0001\u0005\u0002%Bq\u0001\f\u0001C\u0002\u0013%Q\u0006\u0003\u00045\u0001\u0001\u0006IA\f\u0005\bk\u0001\u0011\r\u0011\"\u0003.\u0011\u00191\u0004\u0001)A\u0005]!9q\u0007\u0001b\u0001\n\u0013i\u0003B\u0002\u001d\u0001A\u0003%a\u0006C\u0004:\u0001\t\u0007I\u0011A\u0017\t\ri\u0002\u0001\u0015!\u0003/\u0011\u001dY\u0004A1A\u0005\nqBa!\u0012\u0001!\u0002\u0013i\u0004b\u0002$\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\u001f\t\u000f!\u0003!\u0019!C\u0001\u0013\"1\u0001\u000b\u0001Q\u0001\n)CQ!\u0015\u0001\u0005BICQ!\u0019\u0001\u0005\u0002\tDQa\u001c\u0001\u0005\u0002\tDQ!\u001d\u0001\u0005\nIDq!a\r\u0001\t\u0013\t)\u0004C\u0005\u0002\\\u0001\t\n\u0011\"\u0003\u0002^!9\u00111\u000f\u0001\u0005\n\u0005UdABA?\u0001\u0011\ty\b\u0003\u0004)/\u0011\u0005\u0011Q\u0012\u0005\u0007\u0003';B\u0011\t2\t\r\u0005Uu\u0003\"\u0011c\u0005Y!&/\u00198tC\u000e$\u0018n\u001c8t\u0005>,hnY3UKN$(BA\u000f\u001f\u0003\r\t\u0007/\u001b\u0006\u0002?\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\t)c$A\u0006j]R,wM]1uS>t\u0017BA\u0014%\u0005YY\u0015MZ6b'\u0016\u0014h/\u001a:UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001+!\tY\u0003!D\u0001\u001d\u0003I\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3\u0016\u00039\u0002\"a\f\u001a\u000e\u0003AR\u0011!M\u0001\u0006g\u000e\fG.Y\u0005\u0003gA\u00121!\u00138u\u0003M\u0001(o\u001c3vG\u0016\u0014()\u001e4gKJ\u001c\u0016N_3!\u0003U\u0019XM\u001d<fe6+7o]1hK6\u000b\u0007PQ=uKN\fac]3sm\u0016\u0014X*Z:tC\u001e,W*\u0019=CsR,7\u000fI\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0002\u001d9,X\u000eU1si&$\u0018n\u001c8tA\u0005Qa.^7TKJ4XM]:\u0002\u00179,XnU3sm\u0016\u00148\u000fI\u0001\f_V$\b/\u001e;U_BL7-F\u0001>!\tq4)D\u0001@\u0015\t\u0001\u0015)\u0001\u0003mC:<'\"\u0001\"\u0002\t)\fg/Y\u0005\u0003\t~\u0012aa\u0015;sS:<\u0017\u0001D8viB,H\u000fV8qS\u000e\u0004\u0013AC5oaV$Hk\u001c9jG\u0006Y\u0011N\u001c9viR{\u0007/[2!\u0003=yg/\u001a:sS\u0012Lgn\u001a)s_B\u001cX#\u0001&\u0011\u0005-sU\"\u0001'\u000b\u00055\u000b\u0015\u0001B;uS2L!a\u0014'\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001T!\r!\u0016lW\u0007\u0002+*\u0011akV\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u0017\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002[+\n\u00191+Z9\u0011\u0005q{V\"A/\u000b\u0005ys\u0012AB:feZ,'/\u0003\u0002a;\nY1*\u00194lC\u000e{gNZ5h\u0003=!Xm\u001d;XSRDwI]8va&#G#A2\u0011\u0005=\"\u0017BA31\u0005\u0011)f.\u001b;)\u0005E9\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015QWO\\5u\u0015\u0005a\u0017aA8sO&\u0011a.\u001b\u0002\u0005)\u0016\u001cH/A\u000buKN$x+\u001b;i\u000fJ|W\u000f]'fi\u0006$\u0017\r^1)\u0005I9\u0017!\u0005;fgR\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKR\u00111m\u001d\u0005\u0006iN\u0001\r!^\u0001\u0007G>lW.\u001b;\u0011\u0011=2\b0a\u0005\u0002(\rL!a\u001e\u0019\u0003\u0013\u0019+hn\u0019;j_:\u001c\u0004cB=\u0002\u0004\u0005\u001d\u0011qA\u0007\u0002u*\u00111\u0010`\u0001\taJ|G-^2fe*\u0011QP`\u0001\bG2LWM\u001c;t\u0015\tyrPC\u0002\u0002\u0002-\fa!\u00199bG\",\u0017bAA\u0003u\ni1*\u00194lCB\u0013x\u000eZ;dKJ\u0004RaLA\u0005\u0003\u001bI1!a\u00031\u0005\u0015\t%O]1z!\ry\u0013qB\u0005\u0004\u0003#\u0001$\u0001\u0002\"zi\u0016\u0004B!!\u0006\u0002$9!\u0011qCA\u0010!\r\tI\u0002M\u0007\u0003\u00037Q1!!\b!\u0003\u0019a$o\\8u}%\u0019\u0011\u0011\u0005\u0019\u0002\rA\u0013X\rZ3g\u0013\r!\u0015Q\u0005\u0006\u0004\u0003C\u0001\u0004\u0003CA\u0015\u0003_\t9!a\u0002\u000e\u0005\u0005-\"bAA\u0017y\u0006A1m\u001c8tk6,'/\u0003\u0003\u00022\u0005-\"!D&bM.\f7i\u001c8tk6,'/\u0001\u0012de\u0016\fG/Z\"p]N,X.\u001a:B]\u0012\u001cVOY:de&\u0014W\rV8U_BL7m\u001d\u000b\t\u0003O\t9$a\u000f\u0002R!9\u0011\u0011\b\u000bA\u0002\u0005M\u0011aB4s_V\u0004\u0018\n\u001a\u0005\b\u0003{!\u0002\u0019AA \u0003\u0019!x\u000e]5dgB1\u0011\u0011IA&\u0003'qA!a\u0011\u0002H9!\u0011\u0011DA#\u0013\u0005\t\u0014bAA%a\u00059\u0001/Y2lC\u001e,\u0017\u0002BA'\u0003\u001f\u0012A\u0001T5ti*\u0019\u0011\u0011\n\u0019\t\u0013\u0005MC\u0003%AA\u0002\u0005U\u0013!\u0004:fC\u0012\u001cu.\\7jiR,G\rE\u00020\u0003/J1!!\u00171\u0005\u001d\u0011un\u001c7fC:\fAf\u0019:fCR,7i\u001c8tk6,'/\u00118e'V\u00147o\u0019:jE\u0016$v\u000eV8qS\u000e\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005}#\u0006BA+\u0003CZ#!a\u0019\u0011\t\u0005\u0015\u0014qN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003[\u0002\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011OA4\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\rGJ,\u0017\r^3U_BL7m\u001d\u000b\u0003\u0003o\u0002R\u0001VA=]9J1!a\u001fV\u0005\ri\u0015\r\u001d\u0002\u0010\u0005>,hnY3TG\",G-\u001e7feN\u0019q#!!\u0011\t\u0005\r\u0015\u0011R\u0007\u0003\u0003\u000bS1!a\"\u001f\u0003\u0015)H/\u001b7t\u0013\u0011\tY)!\"\u0003%MCW\u000f\u001e3po:\f'\r\\3UQJ,\u0017\r\u001a\u000b\u0003\u0003\u001f\u00032!!%\u0018\u001b\u0005\u0001\u0011A\u00023p/>\u00148.\u0001\u0005tQV$Hm\\<o\u0001")
public class TransactionsBounceTest
extends KafkaServerTestHarness {
    private final int producerBufferSize;
    private final int serverMessageMaxBytes = this.producerBufferSize() / 2;
    private final int kafka$api$TransactionsBounceTest$$numPartitions;
    private final int numServers;
    private final String kafka$api$TransactionsBounceTest$$outputTopic;
    private final String inputTopic;
    private final Properties overridingProps = new Properties();

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    private int serverMessageMaxBytes() {
        return this.serverMessageMaxBytes;
    }

    public int kafka$api$TransactionsBounceTest$$numPartitions() {
        return this.kafka$api$TransactionsBounceTest$$numPartitions;
    }

    public int numServers() {
        return this.numServers;
    }

    public String kafka$api$TransactionsBounceTest$$outputTopic() {
        return this.kafka$api$TransactionsBounceTest$$outputTopic;
    }

    private String inputTopic() {
        return this.inputTopic;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public scala.collection.immutable.Seq<KafkaConfig> generateConfigs() {
        return (scala.collection.immutable.Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.numServers(), this.zkConnect(), true, false).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
    }

    @Test
    public void testWithGroupId() {
        IntRef intRef;
        IntRef intRef2;
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribeToTopics(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, 60000L, 60000L, 120000);
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        int testBrokerFailure_create_e = 0;
        IntRef intRef3 = intRef2 = new IntRef(testBrokerFailure_create_e);
        intRef2 = null;
        IntRef testBrokerFailure_numMessagesProcessed = intRef3;
        int testBrokerFailure_create_e2 = 0;
        IntRef intRef4 = intRef = new IntRef(testBrokerFailure_create_e2);
        intRef = null;
        IntRef testBrokerFailure_iteration = intRef4;
        try {
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumerGroup);
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.length();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_producer.close();
            testBrokerFailure_consumer.close();
        }
        testBrokerFailure_scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)x0$1 -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)x0$1, (Object)x0$1.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)x0$1);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        Set testBrokerFailure_expectedValues = new Range.Exclusive(n, testBrokerFailure_numInputRecords, 1).toSet();
        if (testBrokerFailure_expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.removedAll((IterableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
        testBrokerFailure_verifyingConsumer.close();
    }

    @Test
    public void testWithGroupMetadata() {
        IntRef intRef;
        IntRef intRef2;
        String testBrokerFailure_consumerGroup = "myGroup";
        int testBrokerFailure_numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), testBrokerFailure_numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> testBrokerFailure_consumer = this.createConsumerAndSubscribeToTopics(testBrokerFailure_consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> testBrokerFailure_producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, 60000L, 60000L, 120000);
        testBrokerFailure_producer.initTransactions();
        BounceScheduler testBrokerFailure_scheduler = new BounceScheduler();
        testBrokerFailure_scheduler.start();
        int testBrokerFailure_create_e = 0;
        IntRef intRef3 = intRef2 = new IntRef(testBrokerFailure_create_e);
        intRef2 = null;
        IntRef testBrokerFailure_numMessagesProcessed = intRef3;
        int testBrokerFailure_create_e2 = 0;
        IntRef intRef4 = intRef = new IntRef(testBrokerFailure_create_e2);
        intRef = null;
        IntRef testBrokerFailure_iteration = intRef4;
        try {
            while (testBrokerFailure_numMessagesProcessed.elem < testBrokerFailure_numInputRecords) {
                int testBrokerFailure_toRead = Math.min(200, testBrokerFailure_numInputRecords - testBrokerFailure_numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> testBrokerFailure_records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_consumer, testBrokerFailure_toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                testBrokerFailure_producer.beginTransaction();
                boolean testBrokerFailure_shouldAbort = testBrokerFailure_iteration.elem % 3 == 0;
                testBrokerFailure_records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                testBrokerFailure_producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)testBrokerFailure_consumer)).asJava(), testBrokerFailure_consumer.groupMetadata());
                if (testBrokerFailure_shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(testBrokerFailure_consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    testBrokerFailure_producer.commitTransaction();
                    testBrokerFailure_numMessagesProcessed.elem += testBrokerFailure_records.length();
                }
                ++testBrokerFailure_iteration.elem;
            }
        }
        finally {
            testBrokerFailure_producer.close();
            testBrokerFailure_consumer.close();
        }
        testBrokerFailure_scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> testBrokerFailure_verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap testBrokerFailure_recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(testBrokerFailure_verifyingConsumer, testBrokerFailure_numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer testBrokerFailure_outputRecords = new ListBuffer();
        testBrokerFailure_recordsByPartition.values().foreach((Function1 & Serializable)x0$1 -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)x0$1, (Object)x0$1.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)x0$1);
        });
        Set testBrokerFailure_recordSet = testBrokerFailure_outputRecords.toSet();
        Assert.assertEquals((long)testBrokerFailure_numInputRecords, (long)testBrokerFailure_recordSet.size());
        int n = 0;
        Set testBrokerFailure_expectedValues = new Range.Exclusive(n, testBrokerFailure_numInputRecords, 1).toSet();
        if (testBrokerFailure_expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(testBrokerFailure_expectedValues.removedAll((IterableOnce)testBrokerFailure_recordSet)).toString(), (Object)testBrokerFailure_expectedValues, (Object)testBrokerFailure_recordSet);
        testBrokerFailure_verifyingConsumer.close();
    }

    private void testBrokerFailure(Function3<KafkaProducer<byte[], byte[]>, String, KafkaConsumer<byte[], byte[]>, BoxedUnit> commit) {
        IntRef intRef;
        IntRef intRef2;
        String consumerGroup = "myGroup";
        int numInputRecords = 10000;
        this.createTopics();
        TestUtils$.MODULE$.seedTopicWithNumberedRecords(this.inputTopic(), numInputRecords, (Seq<KafkaServer>)this.servers());
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndSubscribeToTopics(consumerGroup, (List<String>)new .colon.colon((Object)this.inputTopic(), (List)Nil$.MODULE$), false);
        KafkaProducer<byte[], byte[]> producer = TestUtils$.MODULE$.createTransactionalProducer("test-txn", (Seq<KafkaServer>)this.servers(), 512, 60000L, 60000L, 120000);
        producer.initTransactions();
        BounceScheduler scheduler = new BounceScheduler();
        scheduler.start();
        int create_e = 0;
        IntRef intRef3 = intRef2 = new IntRef(create_e);
        intRef2 = null;
        IntRef numMessagesProcessed = intRef3;
        int create_e2 = 0;
        IntRef intRef4 = intRef = new IntRef(create_e2);
        intRef = null;
        IntRef iteration = intRef4;
        try {
            while (numMessagesProcessed.elem < numInputRecords) {
                int toRead = Math.min(200, numInputRecords - numMessagesProcessed.elem);
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append(iteration$1.elem).append(": About to read ").append(testBrokerFailure_toRead).append(" messages, processed ").append(numMessagesProcessed$1.elem).append(" so far..").toString());
                Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(consumer, toRead, 15000L);
                this.trace((Function0<String>)(Function0 & Serializable)() -> {
                    if (testBrokerFailure_records == null) {
                        throw null;
                    }
                    return new StringBuilder(52).append("Received ").append(testBrokerFailure_records.length()).append(" messages, sending them transactionally to ").append(this.kafka$api$TransactionsBounceTest$$outputTopic()).toString();
                });
                producer.beginTransaction();
                boolean shouldAbort = iteration.elem % 3 == 0;
                records.foreach((Function1 & Serializable)record -> testBrokerFailure_producer.send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.kafka$api$TransactionsBounceTest$$outputTopic(), null, (byte[])record.key(), (byte[])record.value(), !testBrokerFailure_shouldAbort), (Callback)new ErrorLoggingCallback(this.kafka$api$TransactionsBounceTest$$outputTopic(), (byte[])record.key(), (byte[])record.value(), true)));
                this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(35).append("Sent ").append(testBrokerFailure_records.length()).append(" messages. Committing offsets.").toString());
                commit.apply(producer, (Object)consumerGroup, consumer);
                if (shouldAbort) {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("Committed offsets. Aborting transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    producer.abortTransaction();
                    TestUtils$.MODULE$.resetToCommittedPositions(consumer);
                } else {
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Committed offsets. committing transaction of ").append(testBrokerFailure_records.length()).append(" messages.").toString());
                    producer.commitTransaction();
                    numMessagesProcessed.elem += records.length();
                }
                ++iteration.elem;
            }
        }
        finally {
            producer.close();
            consumer.close();
        }
        scheduler.shutdown();
        KafkaConsumer<byte[], byte[]> verifyingConsumer = this.createConsumerAndSubscribeToTopics("randomGroup", (List<String>)new .colon.colon((Object)this.kafka$api$TransactionsBounceTest$$outputTopic(), (List)Nil$.MODULE$), true);
        HashMap recordsByPartition = new HashMap();
        TestUtils$.MODULE$.pollUntilAtLeastNumRecords(verifyingConsumer, numInputRecords, 15000L).foreach((Function1 & Serializable)record -> {
            void append_elem;
            Integer n;
            int n2 = Integer.parseInt(TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
            TopicPartition topicPartition = new TopicPartition(record.topic(), record.partition());
            Buffer buffer = (Buffer)testBrokerFailure_recordsByPartition.getOrElseUpdate((Object)topicPartition, (Function0 & Serializable)() -> new ListBuffer());
            Integer n3 = n = Integer.valueOf(n2);
            n = null;
            Integer n4 = n3;
            if (buffer == null) {
                throw null;
            }
            return (ListBuffer)((Buffer)buffer.addOne((Object)append_elem));
        });
        ListBuffer outputRecords = new ListBuffer();
        recordsByPartition.values().foreach((Function1 & Serializable)x0$1 -> {
            Assert.assertEquals((String)"Out of order messages detected", (Object)x0$1, (Object)x0$1.sorted((Ordering)Ordering.Int$.MODULE$));
            return testBrokerFailure_outputRecords.addAll((IterableOnce)x0$1);
        });
        Set recordSet = outputRecords.toSet();
        Assert.assertEquals((long)numInputRecords, (long)recordSet.size());
        int n = 0;
        Set expectedValues = new Range.Exclusive(n, numInputRecords, 1).toSet();
        if (expectedValues == null) {
            throw null;
        }
        Assert.assertEquals((String)new StringBuilder(18).append("Missing messages: ").append(expectedValues.removedAll((IterableOnce)recordSet)).toString(), (Object)expectedValues, (Object)recordSet);
        verifyingConsumer.close();
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndSubscribeToTopics(String groupId, List<String> topics, boolean readCommitted) {
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String string2 = string = "earliest";
        string = null;
        String x$5 = string2;
        int n = 500;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$7 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        KafkaConsumer consumer = TestUtils$.MODULE$.createConsumer(x$1, groupId, x$5, false, readCommitted, n, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11);
        consumer.subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(topics).asJava());
        return consumer;
    }

    private boolean createConsumerAndSubscribeToTopics$default$3() {
        return false;
    }

    private scala.collection.immutable.Map<Object, Object> createTopics() {
        Properties topicConfig = new Properties();
        topicConfig.put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)2).toString());
        this.createTopic(this.inputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
        return this.createTopic(this.kafka$api$TransactionsBounceTest$$outputTopic(), this.kafka$api$TransactionsBounceTest$$numPartitions(), 3, topicConfig);
    }

    public TransactionsBounceTest() {
        this.producerBufferSize = 65536;
        this.kafka$api$TransactionsBounceTest$$numPartitions = 3;
        this.numServers = 4;
        this.kafka$api$TransactionsBounceTest$$outputTopic = "output-topic";
        this.inputTopic = "input-topic";
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), ((Object)this.serverMessageMaxBytes()).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)true).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)false).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)1).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), ((Object)3).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.MinInSyncReplicasProp(), ((Object)2).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)1).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)3).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        this.overridingProps().put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupId$1$adapted(KafkaProducer producer, String groupId, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), groupId);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testWithGroupMetadata$1$adapted(KafkaProducer producer, String x$2, KafkaConsumer consumer) {
        producer.sendOffsetsToTransaction((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(TestUtils$.MODULE$.consumerPositions((KafkaConsumer<byte[], byte[]>)consumer)).asJava(), consumer.groupMetadata());
        return BoxedUnit.UNIT;
    }

    public class BounceScheduler
    extends ShutdownableThread {
        public void doWork() {
            this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().servers().foreach((Function1 & Serializable)server -> {
                BounceScheduler.$anonfun$doWork$1(this, server);
                return BoxedUnit.UNIT;
            });
            int n = 0;
            int until$extension_end = this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$numPartitions();
            Range.Exclusive foreach_this = new Range.Exclusive(n, until$extension_end, 1);
            if (!foreach_this.isEmpty()) {
                int foreach_i = foreach_this.start();
                while (true) {
                    TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().zkClient(), this.kafka$api$TransactionsBounceTest$BounceScheduler$$$outer().kafka$api$TransactionsBounceTest$$outputTopic(), foreach_i, 30000L, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
                    if (foreach_i == foreach_this.scala$collection$immutable$Range$$lastElement) break;
                    foreach_i += foreach_this.step();
                }
            }
        }

        public void shutdown() {
            super.shutdown();
        }

        public /* synthetic */ TransactionsBounceTest kafka$api$TransactionsBounceTest$BounceScheduler$$$outer() {
            return TransactionsBounceTest.this;
        }

        public static final /* synthetic */ void $anonfun$doWork$1(BounceScheduler $this, KafkaServer server) {
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Shutting down server : %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            server.shutdown();
            server.awaitShutdown();
            Thread.sleep(500L);
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Server %s shut down. Starting it up again.", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            server.startup();
            $this.trace((Function0 & Serializable)() -> StringOps$.MODULE$.format$extension("Restarted server: %s", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{server.config().brokerId()})));
            Thread.sleep(500L);
        }

        public BounceScheduler() {
            if (TransactionsBounceTest.this == null) {
                throw null;
            }
            super("daemon-broker-bouncer", false);
        }
    }
}

