/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.InvalidPidMappingException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001B\u000b\u0017\u0001mAQA\t\u0001\u0005\u0002\rBqA\n\u0001C\u0002\u0013\u0005q\u0005\u0003\u00041\u0001\u0001\u0006I\u0001\u000b\u0005\bc\u0001\u0011\r\u0011\"\u0001(\u0011\u0019\u0011\u0004\u0001)A\u0005Q!91\u0007\u0001b\u0001\n\u0003!\u0004BB\u001e\u0001A\u0003%Q\u0007C\u0004=\u0001\t\u0007I\u0011\u0001\u001b\t\ru\u0002\u0001\u0015!\u00036\u0011%q\u0004\u00011AA\u0002\u0013\u0005q\bC\u0005S\u0001\u0001\u0007\t\u0019!C\u0001'\"I\u0011\f\u0001a\u0001\u0002\u0003\u0006K\u0001\u0011\u0005\n5\u0002\u0001\r\u00111A\u0005\u0002mC\u0011\"\u0019\u0001A\u0002\u0003\u0007I\u0011\u00012\t\u0013\u0011\u0004\u0001\u0019!A!B\u0013a\u0006\"B3\u0001\t\u00032\u0007\"B:\u0001\t\u0003\"\b\"\u0002?\u0001\t\u0003\"\bBBA\u0002\u0001\u0011\u0005A\u000fC\u0004\u0002\u000e\u0001!I!a\u0004\u00035Q\u0013\u0018M\\:bGRLwN\\:FqBL'/\u0019;j_:$Vm\u001d;\u000b\u0005]A\u0012aA1qS*\t\u0011$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0002CA\u000f!\u001b\u0005q\"BA\u0010\u0019\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005\u0005r\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005!\u0003CA\u0013\u0001\u001b\u00051\u0012A\u0002;pa&\u001c\u0017'F\u0001)!\tIc&D\u0001+\u0015\tYC&\u0001\u0003mC:<'\"A\u0017\u0002\t)\fg/Y\u0005\u0003_)\u0012aa\u0015;sS:<\u0017a\u0002;pa&\u001c\u0017\u0007I\u0001\u0007i>\u0004\u0018n\u0019\u001a\u0002\u000fQ|\u0007/[23A\u0005ia.^7QCJ$\u0018\u000e^5p]N,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!h\u000e\u0002\u0004\u0013:$\u0018A\u00048v[B\u000b'\u000f^5uS>t7\u000fI\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\u0018A\u0005:fa2L7-\u0019;j_:4\u0015m\u0019;pe\u0002\n\u0001\u0002\u001d:pIV\u001cWM]\u000b\u0002\u0001B!\u0011I\u0013'M\u001b\u0005\u0011%B\u0001 D\u0015\t!U)A\u0004dY&,g\u000e^:\u000b\u0005e1%BA$I\u0003\u0019\t\u0007/Y2iK*\t\u0011*A\u0002pe\u001eL!a\u0013\"\u0003\u001b-\u000bgm[1Qe>$WoY3s!\r1TjT\u0005\u0003\u001d^\u0012Q!\u0011:sCf\u0004\"A\u000e)\n\u0005E;$\u0001\u0002\"zi\u0016\fA\u0002\u001d:pIV\u001cWM]0%KF$\"\u0001V,\u0011\u0005Y*\u0016B\u0001,8\u0005\u0011)f.\u001b;\t\u000fa[\u0011\u0011!a\u0001\u0001\u0006\u0019\u0001\u0010J\u0019\u0002\u0013A\u0014x\u000eZ;dKJ\u0004\u0013\u0001C2p]N,X.\u001a:\u0016\u0003q\u0003B!X0M\u00196\taL\u0003\u0002[\u0007&\u0011\u0001M\u0018\u0002\u000e\u0017\u000647.Y\"p]N,X.\u001a:\u0002\u0019\r|gn];nKJ|F%Z9\u0015\u0005Q\u001b\u0007b\u0002-\u000f\u0003\u0003\u0005\r\u0001X\u0001\nG>t7/^7fe\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002OB\u0019\u0001n[7\u000e\u0003%T!A[\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\n\u00191+Z9\u0011\u00059\fX\"A8\u000b\u0005AD\u0012AB:feZ,'/\u0003\u0002s_\nY1*\u00194lC\u000e{gNZ5h\u0003\u0015\u0019X\r^+q)\u0005!\u0006FA\tw!\t9(0D\u0001y\u0015\tI\b*A\u0003kk:LG/\u0003\u0002|q\n1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0003%y\u0004\"a^@\n\u0007\u0005\u0005\u0001PA\u0003BMR,'/A\u001cuKN$()^7q)J\fgn]1di&|g.\u00197Fa>\u001c\u0007.\u00114uKJLeN^1mS\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ'baBLgn\u001a\u0015\u0004'\u0005\u001d\u0001cA<\u0002\n%\u0019\u00111\u0002=\u0003\tQ+7\u000f^\u0001\fg\u0016\u0014h/\u001a:Qe>\u00048\u000f\u0006\u0002\u0002\u0012A!\u00111CA\r\u001b\t\t)BC\u0002\u0002\u00181\nA!\u001e;jY&!\u00111DA\u000b\u0005)\u0001&o\u001c9feRLWm\u001d")
public class TransactionsExpirationTest
extends KafkaServerTestHarness {
    private final String topic1;
    private final String topic2;
    private final int numPartitions;
    private final int replicationFactor;
    private KafkaProducer<byte[], byte[]> producer;
    private KafkaConsumer<byte[], byte[]> consumer;

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(3, this.zkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$3 -> {
            Properties fromProps_overrides = this.serverProps();
            return KafkaConfig$.MODULE$.fromProps(x$3, fromProps_overrides, true);
        });
    }

    @Override
    @Before
    public void setUp() {
        ByteArrayDeserializer byteArrayDeserializer;
        ByteArrayDeserializer byteArrayDeserializer2;
        None$ none$;
        None$ none$2;
        SecurityProtocol securityProtocol;
        String string;
        String string2;
        super.setUp();
        this.producer_$eq(TestUtils$.MODULE$.createTransactionalProducer("transactionalProducer", (Seq<KafkaServer>)this.servers(), 16384, 60000L, 60000L, 120000));
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers((Seq<KafkaServer>)this.servers(), SecurityProtocol.PLAINTEXT);
        String string3 = string2 = "group";
        string2 = null;
        String x$4 = string3;
        String string4 = string = "earliest";
        string = null;
        String x$5 = string4;
        int n = 500;
        SecurityProtocol securityProtocol2 = securityProtocol = SecurityProtocol.PLAINTEXT;
        securityProtocol = null;
        SecurityProtocol x$7 = securityProtocol2;
        None$ none$3 = none$2 = None$.MODULE$;
        none$2 = null;
        None$ x$8 = none$3;
        None$ none$4 = none$ = None$.MODULE$;
        none$ = null;
        None$ x$9 = none$4;
        ByteArrayDeserializer byteArrayDeserializer3 = byteArrayDeserializer2 = new ByteArrayDeserializer();
        byteArrayDeserializer2 = null;
        ByteArrayDeserializer x$10 = byteArrayDeserializer3;
        ByteArrayDeserializer byteArrayDeserializer4 = byteArrayDeserializer = new ByteArrayDeserializer();
        byteArrayDeserializer = null;
        ByteArrayDeserializer x$11 = byteArrayDeserializer4;
        this.consumer_$eq(TestUtils$.MODULE$.createConsumer(x$1, x$4, x$5, false, true, n, x$7, (Option<File>)x$8, (Option<Properties>)x$9, x$10, x$11));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic1(), this.numPartitions(), 3, (Seq<KafkaServer>)this.servers(), new Properties());
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic2(), this.numPartitions(), 3, (Seq<KafkaServer>)this.servers(), new Properties());
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        this.consumer().close();
        super.tearDown();
    }

    @Test
    public void testBumpTransactionalEpochAfterInvalidProducerIdMapping() {
        this.producer().initTransactions();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)0, "2", "2", false));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), (Integer)0, "4", "4", false));
        this.producer().abortTransaction();
        Thread.sleep(3000L);
        this.producer().beginTransaction();
        Future failedFuture = this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)3, "1", "1", false));
        Thread.sleep(500L);
        TestUtils.assertFutureThrows((Future)failedFuture, InvalidPidMappingException.class);
        this.producer().abortTransaction();
        this.producer().beginTransaction();
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "2", "2", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)2, "4", "4", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic2(), null, "1", "1", true));
        this.producer().send(TestUtils$.MODULE$.producerRecordWithExpectedTransactionStatus(this.topic1(), (Integer)3, "3", "3", true));
        this.producer().commitTransaction();
        this.consumer().subscribe((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic1(), (List)new .colon.colon((Object)this.topic2(), (List)Nil$.MODULE$))).asJava());
        TestUtils$.MODULE$.consumeRecords(this.consumer(), 4, 15000L).foreach((Function1 & Serializable)record -> TestUtils$.MODULE$.assertCommittedAndGetValue((ConsumerRecord<byte[], byte[]>)record));
    }

    /*
     * WARNING - void declaration
     */
    private Properties serverProps() {
        void var1_1;
        Properties serverProps = new Properties();
        serverProps.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), ((Object)false).toString());
        serverProps.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), ((Object)1).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), ((Object)3).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), ((Object)2).toString());
        serverProps.put(KafkaConfig$.MODULE$.TransactionsTopicMinISRProp(), ((Object)2).toString());
        serverProps.put(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), ((Object)true).toString());
        serverProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), ((Object)false).toString());
        serverProps.put(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), ((Object)false).toString());
        serverProps.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsAbortTimedOutTransactionCleanupIntervalMsProp(), "200");
        serverProps.put(KafkaConfig$.MODULE$.TransactionalIdExpirationMsProp(), "2000");
        serverProps.put(KafkaConfig$.MODULE$.TransactionsRemoveExpiredTransactionalIdCleanupIntervalMsProp(), "500");
        return var1_1;
    }

    public TransactionsExpirationTest() {
        this.topic1 = "topic1";
        this.topic2 = "topic2";
        this.numPartitions = 4;
        this.replicationFactor = 3;
    }
}

