/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.authorizer;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.Kafka$;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_0_IV0$;
import kafka.api.KAFKA_2_0_IV1$;
import kafka.security.authorizer.AclAuthorizer;
import kafka.security.authorizer.AclAuthorizer$;
import kafka.security.authorizer.AclEntry$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkAclStore;
import kafka.zk.ZkAclStore$;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zookeeper.AsyncRequest;
import kafka.zookeeper.GetChildrenRequest;
import kafka.zookeeper.GetChildrenResponse;
import kafka.zookeeper.GetDataRequest;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ZooKeeperClient;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u001dh\u0001B4i\u0001=DQA\u001e\u0001\u0005\u0002]DqA\u001f\u0001C\u0002\u0013%1\u0010C\u0004\u0002\u0014\u0001\u0001\u000b\u0011\u0002?\t\u0011\u0005U\u0001A1A\u0005\nmDq!a\u0006\u0001A\u0003%A\u0010\u0003\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0003|\u0011\u001d\tY\u0002\u0001Q\u0001\nqD\u0011\"!\b\u0001\u0005\u0004%I!a\b\t\u0011\u00055\u0002\u0001)A\u0005\u0003CA\u0011\"a\f\u0001\u0005\u0004%I!a\b\t\u0011\u0005E\u0002\u0001)A\u0005\u0003CA\u0011\"a\r\u0001\u0005\u0004%I!a\b\t\u0011\u0005U\u0002\u0001)A\u0005\u0003CA\u0011\"a\u000e\u0001\u0005\u0004%I!!\u000f\t\u0011\u0005%\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0013\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\u0001\u0005\u0004%I!!\u0014\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u001fB1\"a\n\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002 !Y\u00111\f\u0001A\u0002\u0003\u0007I\u0011BA/\u0011-\ty\u0007\u0001a\u0001\u0002\u0003\u0006K!!\t\t\u0013\u0005E\u0004A1A\u0005\n\u0005M\u0004\u0002CAC\u0001\u0001\u0006I!!\u001e\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005M\u0004\u0002CAE\u0001\u0001\u0006I!!\u001e\t\u0013\u0005-\u0005A1A\u0005\n\u0005e\u0002\u0002CAG\u0001\u0001\u0006I!a\u000f\t\u0013\u0005=\u0005A1A\u0005\n\u0005E\u0005\u0002CAP\u0001\u0001\u0006I!a%\t\u0017\u0005\u0005\u0006\u00011AA\u0002\u0013%\u00111\u0015\u0005\f\u0003c\u0003\u0001\u0019!a\u0001\n\u0013\t\u0019\fC\u0006\u00028\u0002\u0001\r\u0011!Q!\n\u0005\u0015\u0006bCA]\u0001\u0001\u0007\t\u0019!C\u0005\u0003wC1\"!3\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002L\"Y\u0011q\u001a\u0001A\u0002\u0003\u0005\u000b\u0015BA_\r\u0019\t\t\u000e\u0001\u0001\u0002T\"Q\u0011Q[\u0013\u0003\u0002\u0003\u0006I!a6\t\u0015\u0005-XE!A!\u0002\u0013\t9\u000e\u0003\u0004wK\u0011\u0005\u0011Q\u001e\u0005\b\u0003o,C\u0011IA}\u0011\u001d\u0011Y\u0001\u0001C!\u0005\u001bAqA!\b\u0001\t\u0003\u0012i\u0001C\u0004\u0003(\u0001!\tA!\u0004\t\u000f\t\u001d\u0003\u0001\"\u0001\u0003\u000e!9!1\n\u0001\u0005\u0002\t5\u0001b\u0002B(\u0001\u0011\u0005!Q\u0002\u0005\b\u0005'\u0002A\u0011\u0001B\u0007\u0011\u001d\u00119\u0006\u0001C\u0001\u0005\u001bAqAa\u0017\u0001\t\u0003\u0011i\u0001C\u0004\u0003`\u0001!\tA!\u0004\t\u000f\t\r\u0004\u0001\"\u0001\u0003\u000e!9!q\r\u0001\u0005\u0002\t5\u0001b\u0002B6\u0001\u0011\u0005!Q\u0002\u0005\b\u0005_\u0002A\u0011\u0001B\u0007\u0011\u001d\u0011\u0019\b\u0001C\u0001\u0005\u001bAqAa\u001e\u0001\t\u0003\u0011i\u0001C\u0004\u0003|\u0001!\tA!\u0004\t\u000f\t}\u0004\u0001\"\u0001\u0003\u000e!9!1\u0011\u0001\u0005\u0002\t5\u0001b\u0002BD\u0001\u0011\u0005!Q\u0002\u0005\b\u0005\u0017\u0003A\u0011\u0001B\u0007\u0011\u001d\u0011y\t\u0001C\u0005\u0005#CqAa*\u0001\t\u0013\u0011I\u000bC\u0004\u00032\u0002!\tA!\u0004\t\u000f\tU\u0006\u0001\"\u0001\u0003\u000e!9!\u0011\u0018\u0001\u0005\u0002\t5\u0001b\u0002B_\u0001\u0011\u0005!Q\u0002\u0005\b\u0005\u0003\u0004A\u0011\u0001B\u0007\u0011\u001d\u0011)\r\u0001C\u0001\u0005\u001bAqA!3\u0001\t\u0003\u0011i\u0001C\u0004\u0003N\u0002!\tA!\u0004\t\u000f\tE\u0007\u0001\"\u0001\u0003\u000e!9!Q\u001b\u0001\u0005\u0002\t5\u0001b\u0002Bm\u0001\u0011\u0005!Q\u0002\u0005\b\u0005;\u0004A\u0011\u0001B\u0007\u0011\u001d\u0011\t\u000f\u0001C\u0001\u0005\u001bAqA!:\u0001\t\u0003\u0011i\u0001C\u0004\u0003j\u0002!\tA!\u0004\t\u000f\t5\b\u0001\"\u0001\u0003\u000e!9!\u0011\u001f\u0001\u0005\u0002\t5\u0001b\u0002B{\u0001\u0011\u0005!Q\u0002\u0005\b\u0005s\u0004A\u0011\u0001B\u0007\u0011\u001d\u0011i\u0010\u0001C\u0001\u0005\u001bAqa!\u0001\u0001\t\u0003\u0011i\u0001C\u0004\u0004\u0006\u0001!\tA!\u0004\t\u000f\r%\u0001\u0001\"\u0001\u0003\u000e!91Q\u0002\u0001\u0005\n\r=\u0001bBB\u0014\u0001\u0011%1\u0011\u0006\u0005\b\u0007k\u0001A\u0011BB\u001c\u0011%\u0019I\u0005AI\u0001\n\u0013\u0019Y\u0005C\u0004\u0004b\u0001!Iaa\u0019\t\u0013\r\u001d\u0005!%A\u0005\n\r%\u0005bBBG\u0001\u0011%1q\u0012\u0005\b\u00077\u0003A\u0011BBO\u0011\u001d\u0019I\u000b\u0001C\u0005\u0007WCqaa-\u0001\t\u0013\u0019)\fC\u0004\u00044\u0002!Iaa/\t\u000f\rM\u0006\u0001\"\u0003\u0004J\"91Q\u001a\u0001\u0005\n\r=\u0007bBBk\u0001\u0011%1q\u001b\u0005\b\u00073\u0004A\u0011BBn\u0005E\t5\r\\!vi\"|'/\u001b>feR+7\u000f\u001e\u0006\u0003S*\f!\"Y;uQ>\u0014\u0018N_3s\u0015\tYG.\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005i\u0017!B6bM.\f7\u0001A\n\u0003\u0001A\u0004\"!\u001d;\u000e\u0003IT!a\u001d7\u0002\u0005i\\\u0017BA;s\u0005QQvn\\&fKB,'\u000fV3ti\"\u000b'O\\3tg\u00061A(\u001b8jiz\"\u0012\u0001\u001f\t\u0003s\u0002i\u0011\u0001[\u0001\rC2dwn\u001e*fC\u0012\f5\r\\\u000b\u0002yB\u0019Q0a\u0004\u000e\u0003yT1a`A\u0001\u0003\r\t7\r\u001c\u0006\u0005\u0003\u0007\t)!\u0001\u0004d_6lwN\u001c\u0006\u0004[\u0006\u001d!\u0002BA\u0005\u0003\u0017\ta!\u00199bG\",'BAA\u0007\u0003\ry'oZ\u0005\u0004\u0003#q(AE!dG\u0016\u001c8oQ8oiJ|G.\u00128uef\fQ\"\u00197m_^\u0014V-\u00193BG2\u0004\u0013!D1mY><xK]5uK\u0006\u001bG.\u0001\bbY2|wo\u0016:ji\u0016\f5\r\u001c\u0011\u0002\u0017\u0011,g.\u001f*fC\u0012\f5\r\\\u0001\rI\u0016t\u0017PU3bI\u0006\u001bG\u000eI\u0001\u0011o&dGmQ1sIJ+7o\\;sG\u0016,\"!!\t\u0011\t\u0005\r\u0012\u0011F\u0007\u0003\u0003KQA!a\n\u0002\u0002\u0005A!/Z:pkJ\u001cW-\u0003\u0003\u0002,\u0005\u0015\"a\u0004*fg>,(oY3QCR$XM\u001d8\u0002#]LG\u000eZ\"be\u0012\u0014Vm]8ve\u000e,\u0007%\u0001\tqe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\u0006\t\u0002O]3gSb,GMU3t_V\u00148-\u001a\u0011\u0002\u001f\rdWo\u001d;feJ+7o\\;sG\u0016\f\u0001c\u00197vgR,'OU3t_V\u00148-\u001a\u0011\u0002#]LG\u000eZ2be\u0012\u0004&/\u001b8dSB\fG.\u0006\u0002\u0002<A!\u0011QHA#\u001b\t\tyD\u0003\u0003\u0002B\u0005\r\u0013\u0001B1vi\"T1a[A\u0001\u0013\u0011\t9%a\u0010\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\u0006\u0011r/\u001b7eG\u0006\u0014H\r\u0015:j]\u000eL\u0007/\u00197!\u00035\t7\r\\!vi\"|'/\u001b>feV\u0011\u0011q\n\t\u0004s\u0006E\u0013bAA*Q\ni\u0011i\u00197BkRDwN]5{KJ\fa\"Y2m\u0003V$\bn\u001c:ju\u0016\u0014\b%\u0001\bbG2\fU\u000f\u001e5pe&TXM\u001d\u001a\u0002\u001f\u0005\u001cG.Q;uQ>\u0014\u0018N_3se\u0001\nAB]3t_V\u00148-Z0%KF$B!a\u0018\u0002lA!\u0011\u0011MA4\u001b\t\t\u0019G\u0003\u0002\u0002f\u0005)1oY1mC&!\u0011\u0011NA2\u0005\u0011)f.\u001b;\t\u0013\u00055T#!AA\u0002\u0005\u0005\u0012a\u0001=%c\u0005I!/Z:pkJ\u001cW\rI\u0001\u000bgV\u0004XM]+tKJ\u001cXCAA;!\u0011\t9(!!\u000e\u0005\u0005e$\u0002BA>\u0003{\nA\u0001\\1oO*\u0011\u0011qP\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0004\u0006e$AB*ue&tw-A\u0006tkB,'/V:feN\u0004\u0013\u0001C;tKJt\u0017-\\3\u0002\u0013U\u001cXM\u001d8b[\u0016\u0004\u0013!\u00039sS:\u001c\u0017\u000e]1m\u0003)\u0001(/\u001b8dSB\fG\u000eI\u0001\u000fe\u0016\fX/Z:u\u0007>tG/\u001a=u+\t\t\u0019\n\u0005\u0003\u0002\u0016\u0006mUBAAL\u0015\u0011\tI*!\u0001\u0002\u0011I,\u0017/^3tiNLA!!(\u0002\u0018\nq!+Z9vKN$8i\u001c8uKb$\u0018a\u0004:fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0011\u0002\r\r|gNZ5h+\t\t)\u000b\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tY\u000b\\\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005=\u0016\u0011\u0016\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0006d_:4\u0017nZ0%KF$B!a\u0018\u00026\"I\u0011Q\u000e\u0011\u0002\u0002\u0003\u0007\u0011QU\u0001\bG>tg-[4!\u0003=Qxn\\&fKB,'o\u00117jK:$XCAA_!\u0011\ty,!2\u000e\u0005\u0005\u0005'bAAbY\u0006I!p\\8lK\u0016\u0004XM]\u0005\u0005\u0003\u000f\f\tMA\b[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u\u0003MQxn\\&fKB,'o\u00117jK:$x\fJ3r)\u0011\ty&!4\t\u0013\u000554%!AA\u0002\u0005u\u0016\u0001\u0005>p_.+W\r]3s\u00072LWM\u001c;!\u0005=\u0019Uo\u001d;p[B\u0013\u0018N\\2ja\u0006d7cA\u0013\u0002<\u0005i\u0001O]5oG&\u0004\u0018\r\u001c+za\u0016\u0004B!!7\u0002h:!\u00111\\Ar!\u0011\ti.a\u0019\u000e\u0005\u0005}'bAAq]\u00061AH]8pizJA!!:\u0002d\u00051\u0001K]3eK\u001aLA!a!\u0002j*!\u0011Q]A2\u0003\u0011q\u0017-\\3\u0015\r\u0005=\u00181_A{!\r\t\t0J\u0007\u0002\u0001!9\u0011Q\u001b\u0015A\u0002\u0005]\u0007bBAvQ\u0001\u0007\u0011q[\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m(\u0011\u0001\t\u0005\u0003C\ni0\u0003\u0003\u0002\u0000\u0006\r$a\u0002\"p_2,\u0017M\u001c\u0005\b\u0005\u0007I\u0003\u0019\u0001B\u0003\u0003\u0005y\u0007\u0003BA1\u0005\u000fIAA!\u0003\u0002d\t\u0019\u0011I\\=\u0002\u000bM,G/\u00169\u0015\u0005\u0005}\u0003f\u0001\u0016\u0003\u0012A!!1\u0003B\r\u001b\t\u0011)B\u0003\u0003\u0003\u0018\u0005-\u0011!\u00026v]&$\u0018\u0002\u0002B\u000e\u0005+\u0011aAQ3g_J,\u0017\u0001\u0003;fCJ$un\u001e8)\u0007-\u0012\t\u0003\u0005\u0003\u0003\u0014\t\r\u0012\u0002\u0002B\u0013\u0005+\u0011Q!\u00114uKJ\fq\u0005^3ti\u0006+H\u000f[8sSj,G\u000b\u001b:poN|eNT8o\u0019&$XM]1m%\u0016\u001cx.\u001e:dK\":AFa\u000b\u00032\tM\u0002\u0003\u0002B\n\u0005[IAAa\f\u0003\u0016\t!A+Z:u\u0003!)\u0007\u0010]3di\u0016$7E\u0001B\u001b!\u0011\u00119D!\u0011\u000f\t\te\"Q\b\b\u0005\u0003;\u0014Y$\u0003\u0002\u0002f%!!qHA2\u0003\u001d\u0001\u0018mY6bO\u0016LAAa\u0011\u0003F\tA\u0012\n\u001c7fO\u0006d\u0017I]4v[\u0016tG/\u0012=dKB$\u0018n\u001c8\u000b\t\t}\u00121M\u0001#i\u0016\u001cH/Q;uQ>\u0014\u0018N_3XSRDW)\u001c9usJ+7o\\;sG\u0016t\u0015-\\3)\u00075\u0012Y#A\u000euKN$X)\u001c9us\u0006\u001bG\u000e\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0004]\t-\u0012\u0001\u0004;fgR$v\u000e]5d\u0003\u000ed\u0007fA\u0018\u0003,\u0005\u0011C/Z:u\u00032dwn^!dG\u0016\u001c8oV5uQ\u000e+8\u000f^8n!JLgnY5qC2D3\u0001\rB\u0016\u0003]!Xm\u001d;EK:LH+Y6fgB\u0013XmY3eK:\u001cW\rK\u00022\u0005W\t!\u0003^3ti\u0006cGn\\<BY2\f5mY3tg\"\u001a!Ga\u000b\u0002-Q,7\u000f^*va\u0016\u0014Xk]3s\u0011\u0006\u001c\u0018iY2fgND3a\rB\u0016\u0003%\"Xm\u001d;TkB,'/V:fe^KG\u000f[\"vgR|W\u000e\u0015:j]\u000eL\u0007/\u00197ICN\f5mY3tg\"\u001aAGa\u000b\u0002!Q,7\u000f^,jY\u0012\u001c\u0015M\u001d3BG2\u001c\bfA\u001b\u0003,\u0005qA/Z:u\u001d>\f5\r\u001c$pk:$\u0007f\u0001\u001c\u0003,\u00051B/Z:u\u001d>\f5\r\u001c$pk:$wJ^3se&$W\rK\u00028\u0005W\tQ\u0003^3ti\u0006\u001bG.T1oC\u001e,W.\u001a8u\u0003BK5\u000fK\u00029\u0005W\tQ\u0002^3ti2{\u0017\rZ\"bG\",\u0007fA\u001d\u0003,\u0005AB/Z:u\u0007\"\fgnZ3MSN$XM\\3s)&l\u0017N\\4)\u0007i\u0012Y#A\u0017uKN$Hj\\2bY\u000e{gnY;se\u0016tG/T8eS\u001aL7-\u0019;j_:|eMU3t_V\u00148-Z!dYND3a\u000fB\u0016\u0003M\"Xm\u001d;ESN$(/\u001b2vi\u0016$7i\u001c8dkJ\u0014XM\u001c;N_\u0012Lg-[2bi&|gn\u00144SKN|WO]2f\u0003\u000ed7\u000fK\u0002=\u0005W\tQ\u0006^3ti\"Kw\r[\"p]\u000e,(O]3oGflu\u000eZ5gS\u000e\fG/[8o\u001f\u001a\u0014Vm]8ve\u000e,\u0017i\u00197tQ\ri$1F\u0001\u0013i\u0016\u001cH/Q2m\u0013:DWM]5uC:\u001cW\rK\u0002?\u0005W\tq\u0003^3ti&k\u0007\u000f\\5dCRLwN\\:PM\u0006cGn\\<\u0015\r\u0005}#1\u0013BO\u0011\u001d\u0011)j\u0010a\u0001\u0005/\u000b\u0001\u0002]1sK:$x\n\u001d\t\u0004{\ne\u0015b\u0001BN}\na\u0011i\u00197Pa\u0016\u0014\u0018\r^5p]\"9!qT A\u0002\t\u0005\u0016AC1mY><X\rZ(qgB1\u0011\u0011\u001cBR\u0005/KAA!*\u0002j\n\u00191+\u001a;\u0002-Q,7\u000f^%na2L7-\u0019;j_:\u001cxJ\u001a#f]f$b!a\u0018\u0003,\n5\u0006b\u0002BK\u0001\u0002\u0007!q\u0013\u0005\b\u0005_\u0003\u0005\u0019\u0001BQ\u0003%!WM\\5fI>\u00038/A\u0015uKN$\b*[4i\u0007>t7-\u001e:sK:\u001c\u0017\u0010R3mKRLwN\\(g%\u0016\u001cx.\u001e:dK\u0006\u001bGn\u001d\u0015\u0004\u0003\n-\u0012a\r;fgR\f5mY3tg\u0006cGn\\<fI&3\u0017\t\u001c7po\u0006\u001bG.\u0012=jgR\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\r\u0011%1F\u0001 i\u0016\u001cH\u000fR3mKR,\u0017i\u00197P]^KG\u000eZ2be\u0012\u0014Vm]8ve\u000e,\u0007fA\"\u0003,\u0005\u0011C/Z:u\t\u0016dW\r^3BY2\f5\r\\(o/&dGmY1sIJ+7o\\;sG\u0016D3\u0001\u0012B\u0016\u0003M\"Xm\u001d;BG\u000e,7o]!mY><X\rZ%g\u00032dwn^!dY\u0016C\u0018n\u001d;t\u001f:\u0004&/\u001a4jq\u0016$'+Z:pkJ\u001cW\rK\u0002F\u0005W\tq\u0004^3ti\u0012+G.\u001a;f\u0003\u000edwJ\u001c)sK\u001aL\u00070\u001a3SKN|WO]2fQ\r1%1F\u0001#i\u0016\u001cH\u000fR3mKR,\u0017\t\u001c7BG2|e\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007\u001d\u0013Y#\u0001\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\u001c'ji\u0016\u0014\u0018\r\u001c*fg>,(oY3)\u0007!\u0013Y#A\u000fuKN$\u0018\t\u001a3BG2\u001cxJ\\,jY\u0012\u001c\u0017M\u001d3SKN|WO]2fQ\rI%1F\u0001\u001ei\u0016\u001cH/\u00113e\u0003\u000ed7o\u00148Qe\u00164\u0017\u000e_3e%\u0016\u001cx.\u001e:dK\"\u001a!Ja\u000b\u0002CQ,7\u000f^!vi\"|'/\u001b>f/&$\b\u000e\u0015:fM&DX\r\u001a*fg>,(oY3)\u0007-\u0013Y#A\u0010uKN$8+\u001b8hY\u0016\u001c\u0005.\u0019:bGR,'OU3t_V\u00148-Z!dYND3\u0001\u0014B\u0016\u0003Q!Xm\u001d;HKR\f5\r\\:Qe&t7-\u001b9bY\"\u001aQJa\u000b\u0002\u001dQ,7\u000f^!dYN4\u0015\u000e\u001c;fe\"\u001aaJa\u000b\u0002yQ,7\u000f\u001e+ie><8o\u00148BI\u0012\u0004&/\u001a4jq\u0016$\u0017i\u00197JM&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8U_>dun\u001e\u0015\u0004\u001f\n-\u0012a\u000f;fgR<&/\u001b;fg\u0016CH/\u001a8eK\u0012\f5\r\\\"iC:<W-\u0012<f]RLe-\u00138uKJ\u0014%o\\6feB\u0013x\u000e^8d_2tu\u000e^*fi\"\u001a\u0001Ka\u000b\u0002\u000bR,7\u000f^,sSR,7/\u0012=uK:$W\rZ!dY\u000eC\u0017M\\4f\u000bZ,g\u000e^,iK:Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m\u0003RdU-Y:u\u0017\u000647.\u0019,3Q\r\t&1F\u0001yi\u0016\u001cHo\u0016:ji\u0016\u001cH*\u001b;fe\u0006dwK]5uKNd\u0015\u000e^3sC2\f5\r\\\"iC:<W-\u0012<f]R<\u0006.\u001a8J]R,'O\u0011:pW\u0016\u0014\bK]8u_\u000e|G\u000eT3tgRC\u0017M\\&bM.\fgKM3sC2\f5\r\\\"iC:<Wm\u001d$pe>cG-\u001a:Qe>$xnY8m-\u0016\u00148/[8og\"\u001a!Ka\u000b\u0002\u007fQ,7\u000f^,sSR,7\u000fT5uKJ\fG.Q2m\u0007\"\fgnZ3Fm\u0016tGo\u00165f]&sG/\u001a:Ce>\\WM\u001d)s_R|7m\u001c7Jg.\u000bgm[1We!\u001a1Ka\u000b\u00021Q,7\u000f^!vi\"|'/\u001b>fe:{'l[\"p]\u001aLw\rK\u0002U\u0005W\t\u0011\u0007^3ti\u0006+H\u000f[8sSj,'OW6D_:4\u0017n\u001a$s_6\\\u0015MZ6b\u0007>tg-[4XSRDG)\u001a4bk2$8\u000fK\u0002V\u0005W\tQ\u0005^3ti\u0006+H\u000f[8sSj,'OW6D_:4\u0017n\u001a$s_6\\\u0015MZ6b\u0007>tg-[4)\u0007Y\u0013Y#A\u0015uKN$\u0018)\u001e;i_JL'0\u001a:[W\u000e{gNZ5h\rJ|W\u000e\u0015:fM&DxJ^3se&$Wm\u001d\u0015\u0004/\n-\u0012AI4jm\u0016t\u0017)\u001e;i_JL'0\u001a:XSRD\u0007K]8u_\u000e|GNV3sg&|g\u000e\u0006\u0003\u0002`\rE\u0001bBB\n1\u0002\u00071QC\u0001\u0010aJ|Go\\2pYZ+'o]5p]B1\u0011\u0011MB\f\u00077IAa!\u0007\u0002d\t1q\n\u001d;j_:\u0004Ba!\b\u0004$5\u00111q\u0004\u0006\u0004\u0007Ca\u0017aA1qS&!1QEB\u0010\u0005)\t\u0005/\u001b,feNLwN\\\u0001\u001aO\u0016$\u0018i\u00197DQ\u0006tw-Z#wK:$\u0018i]*ue&tw\r\u0006\u0003\u0002v\r-\u0002bBB\u00173\u0002\u00071qF\u0001\fa\u0006$H/\u001a:o)f\u0004X\r\u0005\u0003\u0002$\rE\u0012\u0002BB\u001a\u0003K\u00111\u0002U1ui\u0016\u0014h\u000eV=qK\u0006\u00112\r[1oO\u0016\f5\r\\!oIZ+'/\u001b4z))\u0019Ida\u000f\u0004@\r\r3q\t\t\u0006\u00033\u0014\u0019\u000b \u0005\b\u0007{Q\u0006\u0019AB\u001d\u00031y'/[4j]\u0006d\u0017i\u00197t\u0011\u001d\u0019\tE\u0017a\u0001\u0007s\t\u0011\"\u00193eK\u0012\f5\r\\:\t\u000f\r\u0015#\f1\u0001\u0004:\u0005Y!/Z7pm\u0016$\u0017i\u00197t\u0011%\t9C\u0017I\u0001\u0002\u0004\t\t#\u0001\u000fdQ\u0006tw-Z!dY\u0006sGMV3sS\u001aLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\r5#\u0006BA\u0011\u0007\u001fZ#a!\u0015\u0011\t\rM3QL\u0007\u0003\u0007+RAaa\u0016\u0004Z\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0005\u00077\n\u0019'\u0001\u0006b]:|G/\u0019;j_:LAaa\u0018\u0004V\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002#9,wOU3rk\u0016\u001cHoQ8oi\u0016DH\u000f\u0006\u0005\u0002\u0014\u000e\u00154qMB<\u0011\u001d\tY\t\u0018a\u0001\u0003wAqa!\u001b]\u0001\u0004\u0019Y'A\u0007dY&,g\u000e^!eIJ,7o\u001d\t\u0005\u0007[\u001a\u0019(\u0004\u0002\u0004p)!1\u0011OA?\u0003\rqW\r^\u0005\u0005\u0007k\u001ayGA\u0006J]\u0016$\u0018\t\u001a3sKN\u001c\b\"CB=9B\u0005\t\u0019AB>\u0003\u0019\t\u0007/[&fsB!1QPBB\u001b\t\u0019yH\u0003\u0003\u0004\u0002\u0006\u0005\u0011\u0001\u00039s_R|7m\u001c7\n\t\r\u00155q\u0010\u0002\b\u0003BL7*Z=t\u0003mqWm\u001e*fcV,7\u000f^\"p]R,\u0007\u0010\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0012\u0016\u0005\u0007w\u001ay%A\u0005bkRDwN]5{KRQ\u00111`BI\u0007'\u001b)j!'\t\r%t\u0006\u0019AA(\u0011\u001d\tyI\u0018a\u0001\u0003'Cqaa&_\u0001\u0004\u00119*A\u0005pa\u0016\u0014\u0018\r^5p]\"9\u0011q\u00050A\u0002\u0005\u0005\u0012aB1eI\u0006\u001bGn\u001d\u000b\t\u0003?\u001ayj!)\u0004&\"1\u0011n\u0018a\u0001\u0003\u001fBqaa)`\u0001\u0004\u0019I$\u0001\u0003bG\u0016\u001c\bbBBT?\u0002\u0007\u0011\u0011E\u0001\u0010e\u0016\u001cx.\u001e:dKB\u000bG\u000f^3s]\u0006Q!/Z7pm\u0016\f5\r\\:\u0015\u0011\u0005m8QVBX\u0007cCa!\u001b1A\u0002\u0005=\u0003bBBRA\u0002\u00071\u0011\b\u0005\b\u0007O\u0003\u0007\u0019AA\u0011\u0003\u001d9W\r^!dYN$ba!\u000f\u00048\u000ee\u0006BB5b\u0001\u0004\ty\u0005C\u0004\u0004(\u0006\u0004\r!!\t\u0015\r\ru6QYBd!\u0019\tINa)\u0004@B\u0019Qp!1\n\u0007\r\rgP\u0001\u0006BG2\u0014\u0015N\u001c3j]\u001eDa!\u001b2A\u0002\u0005=\u0003bBAFE\u0002\u0007\u00111\b\u000b\u0005\u0007{\u001bY\r\u0003\u0004jG\u0002\u0007\u0011qJ\u0001\bm\u0006d\u0017\u000eZ(q)\u0011\tYp!5\t\u000f\rMG\r1\u0001\u0003\u0018\u0006\u0011q\u000e]\u0001\u0015aJ,\u0007/\u0019:f\t\u00164\u0017-\u001e7u\u0007>tg-[4\u0015\u0005\u0005]\u0017!\u00049sKB\f'/Z\"p]\u001aLw\r\u0006\u0003\u0002X\u000eu\u0007bBBpM\u0002\u00071\u0011]\u0001\u0006Y&tWm\u001d\t\u0007\u0003C\u001a\u0019/a6\n\t\r\u0015\u00181\r\u0002\u0006\u0003J\u0014\u0018-\u001f")
public class AclAuthorizerTest
extends ZooKeeperTestHarness {
    private final AccessControlEntry allowReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
    private final AccessControlEntry allowWriteAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
    private final AccessControlEntry denyReadAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
    private final ResourcePattern wildCardResource = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
    private final ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.PREFIXED);
    private final ResourcePattern clusterResource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
    private final KafkaPrincipal wildcardPrincipal = SecurityUtils.parseKafkaPrincipal((String)AclEntry$.MODULE$.WildcardPrincipalString());
    private final AclAuthorizer aclAuthorizer = new AclAuthorizer();
    private final AclAuthorizer aclAuthorizer2 = new AclAuthorizer();
    private ResourcePattern resource;
    private final String superUsers;
    private final String username;
    private final KafkaPrincipal principal = new KafkaPrincipal("User", this.username());
    private final RequestContext requestContext = this.newRequestContext(this.principal(), InetAddress.getByName("192.168.0.1"), ApiKeys.PRODUCE);
    private KafkaConfig config;
    private ZooKeeperClient zooKeeperClient;

    private AccessControlEntry allowReadAcl() {
        return this.allowReadAcl;
    }

    private AccessControlEntry allowWriteAcl() {
        return this.allowWriteAcl;
    }

    private AccessControlEntry denyReadAcl() {
        return this.denyReadAcl;
    }

    private ResourcePattern wildCardResource() {
        return this.wildCardResource;
    }

    private ResourcePattern prefixedResource() {
        return this.prefixedResource;
    }

    private ResourcePattern clusterResource() {
        return this.clusterResource;
    }

    private KafkaPrincipal wildcardPrincipal() {
        return this.wildcardPrincipal;
    }

    private AclAuthorizer aclAuthorizer() {
        return this.aclAuthorizer;
    }

    private AclAuthorizer aclAuthorizer2() {
        return this.aclAuthorizer2;
    }

    private ResourcePattern resource() {
        return this.resource;
    }

    private void resource_$eq(ResourcePattern x$1) {
        this.resource = x$1;
    }

    private String superUsers() {
        return this.superUsers;
    }

    private String username() {
        return this.username;
    }

    private KafkaPrincipal principal() {
        return this.principal;
    }

    private RequestContext requestContext() {
        return this.requestContext;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    private ZooKeeperClient zooKeeperClient() {
        return this.zooKeeperClient;
    }

    private void zooKeeperClient_$eq(ZooKeeperClient x$1) {
        this.zooKeeperClient = x$1;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.aclAuthorizer().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        this.aclAuthorizer2().maxUpdateRetries_$eq(Integer.MAX_VALUE);
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
        this.aclAuthorizer2().configure(this.config().originals());
        this.resource_$eq(new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL));
        this.zooKeeperClient_$eq(new ZooKeeperClient(this.zkConnect(), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "kafka.test", "AclAuthorizerTest"));
    }

    @Override
    @After
    public void tearDown() {
        this.aclAuthorizer().close();
        this.aclAuthorizer2().close();
        this.zooKeeperClient().close();
        super.tearDown();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAuthorizeThrowsOnNonLiteralResource() {
        this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "something", PatternType.PREFIXED));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizeWithEmptyResourceName() {
        void apply_elems;
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL)));
    }

    @Test
    public void testEmptyAclThrowsException() {
        ApiException e = (ApiException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.GROUP, "", PatternType.LITERAL));
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e).toString(), (boolean)(e.getCause() instanceof IllegalArgumentException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testTopicAcl() {
        void apply_elems;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "rob");
        KafkaPrincipal user3 = new KafkaPrincipal("User", "batman");
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl4 = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl5 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW);
        AccessControlEntry acl6 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl7 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4, acl5, acl6, acl7});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        RequestContext host2Context = this.newRequestContext(user1, host2, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User1 should have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
        Assert.assertFalse((String)"User1 should not have WRITE access from host2 as no allow acl is defined", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.WRITE, this.resource()));
        Assert.assertTrue((String)"User1 should not have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User1 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.ALTER, this.resource()));
        Assert.assertFalse((String)"User1 should not have edit access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.ALTER, this.resource()));
        RequestContext user2Context = this.newRequestContext(user2, host1, ApiKeys.PRODUCE);
        RequestContext user3Context = this.newRequestContext(user3, host1, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User2 should have DESCRIBE access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User3 should have DESCRIBE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.DESCRIBE, this.resource()));
        Assert.assertTrue((String)"User2 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), user2Context, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"User3 should have WRITE access from host2", (boolean)this.authorize(this.aclAuthorizer(), user3Context, AclOperation.WRITE, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAllowAccessWithCustomPrincipal() {
        void apply_elems;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        CustomPrincipal customUserPrincipal = new CustomPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.1.1");
        InetAddress host2 = InetAddress.getByName("192.168.1.2");
        AccessControlEntry acl1 = new AccessControlEntry(user.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.DENY);
        AccessControlEntry acl2 = new AccessControlEntry(user.toString(), host2.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext host1Context = this.newRequestContext(customUserPrincipal, host1, ApiKeys.PRODUCE);
        RequestContext host2Context = this.newRequestContext(customUserPrincipal, host2, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host2", (boolean)this.authorize(this.aclAuthorizer(), host2Context, AclOperation.READ, this.resource()));
        Assert.assertFalse((String)"User1 should not have READ access from host1 due to denyAcl", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDenyTakesPrecedence() {
        void apply_elems;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.2.1");
        RequestContext session = this.newRequestContext(user, host, ApiKeys.PRODUCE);
        AccessControlEntry allowAll = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        AccessControlEntry denyAcl = new AccessControlEntry(user.toString(), host.getHostAddress(), AclOperation.ALL, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAll, denyAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        Assert.assertFalse((String)"deny should take precedence over allow.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAllowAllAccess() {
        void apply_elems;
        AccessControlEntry allowAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{allowAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext context = this.newRequestContext(new KafkaPrincipal("User", "random"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"allow all acl should allow access to all.", (boolean)this.authorize(this.aclAuthorizer(), context, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuperUserHasAccess() {
        void apply_elems;
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext session1 = this.newRequestContext(new KafkaPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        RequestContext session2 = this.newRequestContext(new KafkaPrincipal("User", "superuser2"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session1, AclOperation.READ, this.resource()));
        Assert.assertTrue((String)"superuser always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session2, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuperUserWithCustomPrincipalHasAccess() {
        void apply_elems;
        AccessControlEntry denyAllAcl = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.DENY);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyAllAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        RequestContext session = this.newRequestContext(new CustomPrincipal("User", "superuser1"), InetAddress.getByName("192.0.4.4"), ApiKeys.PRODUCE);
        Assert.assertTrue((String)"superuser with custom principal always has access, no matter what acls.", (boolean)this.authorize(this.aclAuthorizer(), session, AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWildCardAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Assert.assertFalse((String)"when acls = [], authorizer should fail close.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        AccessControlEntry readAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.READ, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{readAcl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        Assert.assertTrue((String)"User1 should have READ access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.READ, this.resource()));
        AccessControlEntry writeAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{writeAcl});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        AccessControlEntry denyWriteOnWildCardResourceAcl = new AccessControlEntry(user1.toString(), host1.getHostAddress(), AclOperation.WRITE, AclPermissionType.DENY);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{denyWriteOnWildCardResourceAcl});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        Assert.assertFalse((String)"User1 should not have WRITE access from host1", (boolean)this.authorize(this.aclAuthorizer(), host1Context, AclOperation.WRITE, this.resource()));
    }

    @Test
    public void testNoAclFound() {
        Assert.assertFalse((String)"when acls = [], authorizer should deny op.", (boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    @Test
    public void testNoAclFoundOverride() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.AllowEveryoneIfNoAclIsFoundProp(), "true");
        KafkaConfig cfg = KafkaConfig$.MODULE$.fromProps(props);
        try (AclAuthorizer testAuthorizer = new AclAuthorizer();){
            testAuthorizer.configure(cfg.originals());
            Assert.assertTrue((String)"when acls = null or [],  authorizer should allow op with allow.everyone = true.", (boolean)this.authorize(testAuthorizer, this.requestContext(), AclOperation.READ, this.resource()));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclManagementAPIs() {
        void apply_elems;
        void apply_elems2;
        ResourcePattern resourcePattern;
        void apply_elems3;
        ResourcePattern resourcePattern2;
        ResourcePattern resourcePattern3;
        void $minus$greater$extension_y;
        void apply_elems4;
        Object object;
        void $minus$greater$extension_y2;
        void apply_elems5;
        Object object2;
        void apply_elems6;
        void apply_elems7;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        String host1 = "host1";
        String host2 = "host2";
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl2 = new AccessControlEntry(user1.toString(), host1, AclOperation.WRITE, AclPermissionType.ALLOW);
        AccessControlEntry acl3 = new AccessControlEntry(user2.toString(), host2, AclOperation.READ, AclPermissionType.ALLOW);
        AccessControlEntry acl4 = new AccessControlEntry(user2.toString(), host2, AclOperation.WRITE, AclPermissionType.ALLOW);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2, acl3, acl4});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set<AccessControlEntry> acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems7)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        AccessControlEntry acl5 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl5});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        acls = this.changeAclAndVerify(acls, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems6)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$1(this, acl1, acl2, user1)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l, l2));
        }
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$4(this, acl3, acl4, acl5, user2)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[4];
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$3 == null) {
            throw null;
        }
        Set$ apply_this = set$3;
        Object object3 = object2 = IterableFactory.apply$((IterableFactory)apply_this, (scala.collection.immutable.Seq)apply_elems5);
        Object var22_20 = null;
        arraySeq3 = null;
        object2 = null;
        Object object4 = object3;
        ResourcePattern $minus$greater$extension_$this = new ResourcePattern(ResourceType.TOPIC, "*", PatternType.LITERAL);
        Object var13_23 = null;
        object4 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user2.toString(), host1, AclOperation.READ, AclPermissionType.ALLOW)});
        if (set$4 == null) {
            throw null;
        }
        Set$ apply_this2 = set$4;
        Object object5 = object = IterableFactory.apply$((IterableFactory)apply_this2, (scala.collection.immutable.Seq)apply_elems4);
        Object var25_25 = null;
        arraySeq4 = null;
        object = null;
        Object object6 = object5;
        ResourcePattern $minus$greater$extension_$this2 = new ResourcePattern(ResourceType.CLUSTER, "*", PatternType.LITERAL);
        Object var15_28 = null;
        object6 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        ResourcePattern resourcePattern4 = resourcePattern3 = new ResourcePattern(ResourceType.GROUP, "*", PatternType.LITERAL);
        resourcePattern3 = null;
        ResourcePattern $minus$greater$extension_$this3 = resourcePattern4;
        Object var17_30 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, acls);
        ResourcePattern resourcePattern5 = resourcePattern2 = new ResourcePattern(ResourceType.GROUP, "test-ConsumerGroup", PatternType.LITERAL);
        resourcePattern2 = null;
        ResourcePattern $minus$greater$extension_$this4 = resourcePattern5;
        Object var18_32 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, acls);
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq5 = null;
        scala.collection.immutable.Map resourceToAcls = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems3);
        resourceToAcls.foreach((Function1 & Serializable)x0$1 -> {
            Set value;
            ResourcePattern key;
            if (x0$1 != null) {
                key = (ResourcePattern)x0$1._1();
                value = (Set)x0$1._2();
                if (Predef$.MODULE$.Set() == null) {
                    throw null;
                }
                if (Predef$.MODULE$.Set() == null) {
                    throw null;
                }
            } else {
                throw new MatchError(null);
            }
            Set<AccessControlEntry> set = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)value, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, key);
            return set;
        });
        ResourcePattern resourcePattern6 = resourcePattern = this.resource();
        resourcePattern = null;
        ResourcePattern $minus$greater$extension_$this5 = resourcePattern6;
        Object var19_36 = null;
        Set expectedAcls = ((IterableOnceOps)resourceToAcls.$plus(new Tuple2((Object)$minus$greater$extension_$this5, acls)).flatMap((Function1 & Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            ResourcePattern res = (ResourcePattern)x0$2._1();
            Set set = (Set)((Set)x0$2._2()).map((Function1 & Serializable)acl -> new AclBinding(res, acl));
            return set;
        })).toSet();
        long l5 = 15000L;
        long l6 = 100L;
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!AclAuthorizerTest.$anonfun$testAclManagementAPIs$10(this, expectedAcls)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + l5) {
                throw Assertions$.MODULE$.fail("changes not propagated in timeout period.", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 845));
            }
            Thread.sleep(Math.min(l5, l6));
        }
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl5});
        if (set$5 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2)), this.changeAclAndVerify$default$4());
        acls = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.resource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer(), this.resource());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$6 == null) {
            throw null;
        }
        arraySeq7 = null;
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        acls = this.changeAclAndVerify((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems)), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.changeAclAndVerify$default$4());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.changeAclAndVerify(acls, (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, acls, this.changeAclAndVerify$default$4());
        Assert.assertTrue((!this.zkClient().resourceExists(this.resource()) ? 1 : 0) != 0);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLoadCache() {
        void apply_elems;
        void apply_elems2;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, "test-2", PatternType.LITERAL);
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), "host3", AclOperation.READ, AclPermissionType.DENY);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Set acls1 = (Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls1, resource1);
        this.zkClient().deleteAclChangeNotifications();
        try (AclAuthorizer authorizer = new AclAuthorizer();){
            authorizer.configure(this.config().originals());
            Assert.assertEquals((Object)acls, this.getAcls(authorizer, this.resource()));
            Assert.assertEquals((Object)acls1, this.getAcls(authorizer, resource1));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testChangeListenerTiming() {
        Semaphore configureSemaphore = new Semaphore(0);
        Semaphore listenerSemaphore = new Semaphore(0);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        AclAuthorizer aclAuthorizer3 = new AclAuthorizer(null, configureSemaphore, listenerSemaphore){
            private final Semaphore configureSemaphore$1;
            private final Semaphore listenerSemaphore$1;

            public void startZkChangeListeners() {
                this.configureSemaphore$1.release();
                this.listenerSemaphore$1.acquireUninterruptibly();
                super.startZkChangeListeners();
            }
            {
                this.configureSemaphore$1 = configureSemaphore$1;
                this.listenerSemaphore$1 = listenerSemaphore$1;
            }
        };
        try {
            void apply_elems;
            Future<?> future = executor.submit(() -> aclAuthorizer3.configure(this.config().originals()));
            configureSemaphore.acquire();
            KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), "host-1", AclOperation.READ, AclPermissionType.DENY)});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.resource());
            listenerSemaphore.release();
            future.get(10L, TimeUnit.SECONDS);
            Assert.assertEquals((Object)acls, this.getAcls(aclAuthorizer3, this.resource()));
        }
        finally {
            aclAuthorizer3.close();
            executor.shutdownNow();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLocalConcurrentModificationOfResourceAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), commonResource);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), commonResource);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems)), (Authorizer)this.aclAuthorizer(), commonResource);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDistributedConcurrentModificationOfResourceAcls() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        AccessControlEntry acl1 = new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW);
        KafkaPrincipal user2 = new KafkaPrincipal("User", "bob");
        AccessControlEntry acl2 = new AccessControlEntry(user2.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems8)), commonResource);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems7)), commonResource);
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems6)), (Authorizer)this.aclAuthorizer(), commonResource);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems5)), (Authorizer)this.aclAuthorizer2(), commonResource);
        KafkaPrincipal user3 = new KafkaPrincipal("User", "joe");
        AccessControlEntry acl3 = new AccessControlEntry(user3.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.DENY);
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems4)), commonResource);
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        boolean deleted = this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems3)), commonResource);
        Assert.assertTrue((String)"The authorizer should see a value that needs to be deleted", (boolean)deleted);
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems2)), (Authorizer)this.aclAuthorizer(), commonResource);
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1, acl2});
        if (set$8 == null) {
            throw null;
        }
        arraySeq8 = null;
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems)), (Authorizer)this.aclAuthorizer2(), commonResource);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyModificationOfResourceAcls() {
        Tuple2 tuple2;
        ResourcePattern commonResource = new ResourcePattern(ResourceType.TOPIC, "test", PatternType.LITERAL);
        int n = 0;
        int to$extension_end = 50;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        Iterator map_strictOptimizedMap_it = map_this.iterator();
        while (map_strictOptimizedMap_it.hasNext()) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Tuple2 tuple22;
            Tuple2 tuple23 = tuple22 = AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)map_strictOptimizedMap_it.next()));
            tuple22 = null;
            tuple2 = tuple23;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            tuple2 = null;
        }
        Object var6_4 = null;
        Object var7_5 = null;
        Object var8_6 = null;
        tuple2 = null;
        IndexedSeq acls = (IndexedSeq)map_strictOptimizedMap_b.result();
        IndexedSeq concurrentFuctions = (IndexedSeq)acls.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            AccessControlEntry acl = (AccessControlEntry)x0$1._1();
            int aclId = x0$1._2$mcI$sp();
            Function0 & Serializable intersect = (Function0 & Serializable)() -> {
                if (aclId % 2 == 0) {
                    void apply_elems;
                    Set$ set$ = Predef$.MODULE$.Set();
                    ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                    if (set$ == null) {
                        throw null;
                    }
                    arraySeq = null;
                    this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                } else {
                    void apply_elems;
                    Set$ set$ = Predef$.MODULE$.Set();
                    ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                    if (set$ == null) {
                        throw null;
                    }
                    arraySeq = null;
                    this.addAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                }
                if (aclId % 10 == 0) {
                    void apply_elems;
                    Set$ set$ = Predef$.MODULE$.Set();
                    ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
                    if (set$ == null) {
                        throw null;
                    }
                    arraySeq = null;
                    return this.removeAcls(this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), commonResource);
                }
                return BoxedUnit.UNIT;
            };
            return intersect;
        });
        Set expectedAcls = ((IterableOnceOps)((IndexedSeqOps)acls.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$4(x0$2)))).map((Function1 & Serializable)x$4 -> (AccessControlEntry)x$4._1())).toSet();
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer(), commonResource);
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)expectedAcls, (Authorizer)this.aclAuthorizer2(), commonResource);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclInheritance() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        void apply_elems9;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.testImplicationsOfAllow(AclOperation.ALL, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems9)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.READ, AclOperation.WRITE, AclOperation.CREATE, AclOperation.DELETE, AclOperation.ALTER, AclOperation.DESCRIBE, AclOperation.CLUSTER_ACTION, AclOperation.DESCRIBE_CONFIGS, AclOperation.ALTER_CONFIGS, AclOperation.IDEMPOTENT_WRITE});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.testImplicationsOfDeny(AclOperation.ALL, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems8)));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.testImplicationsOfAllow(AclOperation.READ, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems7)));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.testImplicationsOfAllow(AclOperation.WRITE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems6)));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.testImplicationsOfAllow(AclOperation.DELETE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems5)));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.testImplicationsOfAllow(AclOperation.ALTER, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems4)));
        Set$ set$7 = Predef$.MODULE$.Set();
        Nil$ nil$ = Nil$.MODULE$;
        if (set$7 == null) {
            throw null;
        }
        nil$ = null;
        this.testImplicationsOfDeny(AclOperation.DESCRIBE, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems3)));
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclOperation[]{AclOperation.DESCRIBE_CONFIGS});
        if (set$8 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.testImplicationsOfAllow(AclOperation.ALTER_CONFIGS, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems2)));
        Set$ set$9 = Predef$.MODULE$.Set();
        Nil$ nil$2 = Nil$.MODULE$;
        if (set$9 == null) {
            throw null;
        }
        nil$2 = null;
        this.testImplicationsOfDeny(AclOperation.DESCRIBE_CONFIGS, (Set<AclOperation>)((Set)IterableFactory.apply$((IterableFactory)set$9, (scala.collection.immutable.Seq)apply_elems)));
    }

    /*
     * WARNING - void declaration
     */
    private void testImplicationsOfAllow(AclOperation parentOp, Set<AclOperation> allowedOps) {
        void apply_elems;
        Object object;
        AclOperation[] aclOperationArray;
        void apply_elems2;
        KafkaPrincipal user = new KafkaPrincipal("User", this.username());
        InetAddress host = InetAddress.getByName("192.168.3.1");
        RequestContext hostContext = this.newRequestContext(user, host, ApiKeys.PRODUCE);
        AccessControlEntry acl = new AccessControlEntry(user.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), this.clusterResource());
        AclOperation[] aclOperationArray2 = aclOperationArray = AclOperation.values();
        aclOperationArray = null;
        AclOperation[] filter$extension_$this = aclOperationArray2;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = object;
        Object var14_10 = null;
        object = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            AclOperation aclOperation;
            AclOperation aclOperation2 = aclOperation = filter$extension_$this[filter$extension_i];
            aclOperation = null;
            AclOperation filter$extension_x = aclOperation2;
            if (!this.validOp(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var10_9 = null;
        Object var11_13 = null;
        Object var13_15 = null;
        Object[] foreach$extension_$this = (Object[])filter$extension_res.result();
        int n = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < n; ++foreach$extension_i) {
            AclOperation aclOperation = (AclOperation)foreach$extension_$this[foreach$extension_i];
            AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2(this, hostContext, allowedOps, parentOp, aclOperation);
        }
        Object var17_17 = null;
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), this.clusterResource());
    }

    /*
     * WARNING - void declaration
     */
    private void testImplicationsOfDeny(AclOperation parentOp, Set<AclOperation> deniedOps) {
        Object object;
        AclOperation[] aclOperationArray;
        void apply_elems;
        KafkaPrincipal user1 = new KafkaPrincipal("User", this.username());
        InetAddress host1 = InetAddress.getByName("192.168.3.1");
        RequestContext host1Context = this.newRequestContext(user1, host1, ApiKeys.PRODUCE);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), parentOp, AclPermissionType.DENY), new AccessControlEntry(user1.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW)});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Set acls = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
        AclOperation[] aclOperationArray2 = aclOperationArray = AclOperation.values();
        aclOperationArray = null;
        AclOperation[] filter$extension_$this = aclOperationArray2;
        ClassTag filter$extension_make_evidence$1 = ClassTag$.MODULE$.apply(filter$extension_$this.getClass().getComponentType());
        Class clazz = filter$extension_make_evidence$1.runtimeClass();
        Class<Byte> clazz2 = Byte.TYPE;
        if (!(clazz2 != null ? !clazz2.equals(clazz) : clazz != null)) {
            object = new ArrayBuilder.ofByte();
        } else {
            Class<Short> clazz3 = Short.TYPE;
            if (!(clazz3 != null ? !clazz3.equals(clazz) : clazz != null)) {
                object = new ArrayBuilder.ofShort();
            } else {
                Class<Character> clazz4 = Character.TYPE;
                if (!(clazz4 != null ? !clazz4.equals(clazz) : clazz != null)) {
                    object = new ArrayBuilder.ofChar();
                } else {
                    Class<Integer> clazz5 = Integer.TYPE;
                    if (!(clazz5 != null ? !clazz5.equals(clazz) : clazz != null)) {
                        object = new ArrayBuilder.ofInt();
                    } else {
                        Class<Long> clazz6 = Long.TYPE;
                        if (!(clazz6 != null ? !clazz6.equals(clazz) : clazz != null)) {
                            object = new ArrayBuilder.ofLong();
                        } else {
                            Class<Float> clazz7 = Float.TYPE;
                            if (!(clazz7 != null ? !clazz7.equals(clazz) : clazz != null)) {
                                object = new ArrayBuilder.ofFloat();
                            } else {
                                Class<Double> clazz8 = Double.TYPE;
                                if (!(clazz8 != null ? !clazz8.equals(clazz) : clazz != null)) {
                                    object = new ArrayBuilder.ofDouble();
                                } else {
                                    Class<Boolean> clazz9 = Boolean.TYPE;
                                    if (!(clazz9 != null ? !clazz9.equals(clazz) : clazz != null)) {
                                        object = new ArrayBuilder.ofBoolean();
                                    } else {
                                        Class<Void> clazz10 = Void.TYPE;
                                        object = !(clazz10 != null ? !clazz10.equals(clazz) : clazz != null) ? new ArrayBuilder.ofUnit() : new ArrayBuilder.ofRef(filter$extension_make_evidence$1);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        ArrayBuilder.ofByte ofByte2 = object;
        Object var13_10 = null;
        object = null;
        clazz = null;
        ArrayBuilder.ofByte filter$extension_res = ofByte2;
        for (int filter$extension_i = 0; filter$extension_i < filter$extension_$this.length; ++filter$extension_i) {
            AclOperation aclOperation;
            AclOperation aclOperation2 = aclOperation = filter$extension_$this[filter$extension_i];
            aclOperation = null;
            AclOperation filter$extension_x = aclOperation2;
            if (!this.validOp(filter$extension_x)) continue;
            filter$extension_res.addOne((Object)filter$extension_x);
        }
        Object var9_9 = null;
        Object var10_13 = null;
        Object var12_15 = null;
        Object[] foreach$extension_$this = (Object[])filter$extension_res.result();
        int n = foreach$extension_$this.length;
        for (int foreach$extension_i = 0; foreach$extension_i < n; ++foreach$extension_i) {
            AclOperation aclOperation = (AclOperation)foreach$extension_$this[foreach$extension_i];
            AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2(this, host1Context, deniedOps, parentOp, aclOperation);
        }
        Object var16_17 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)acls, this.clusterResource());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighConcurrencyDeletionOfResourceAcls() {
        IndexedSeq indexedSeq;
        Function0 function0;
        AccessControlEntry acl = new AccessControlEntry(new KafkaPrincipal("User", this.username()).toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.ALL, AclPermissionType.ALLOW);
        int n = 0;
        int to$extension_end = 50;
        Range.Inclusive map_this = new Range.Inclusive(n, to$extension_end, 1);
        map_this.scala$collection$immutable$Range$$validateMaxLength();
        Builder map_strictOptimizedMap_b = IndexedSeq$.MODULE$.newBuilder();
        for (Object object : map_this) {
            void map_strictOptimizedMap_$plus$eq_elem;
            Function0 function02;
            Function0 function03 = function02 = AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1(this, acl, BoxesRunTime.unboxToInt((Object)object));
            function02 = null;
            function0 = function03;
            if (map_strictOptimizedMap_b == null) {
                throw null;
            }
            map_strictOptimizedMap_b.addOne((Object)map_strictOptimizedMap_$plus$eq_elem);
            function0 = null;
        }
        IndexedSeq indexedSeq2 = indexedSeq = (IndexedSeq)map_strictOptimizedMap_b.result();
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        function0 = null;
        indexedSeq = null;
        IndexedSeq concurrentFuctions = indexedSeq2;
        TestUtils$.MODULE$.assertConcurrent("Should support many concurrent calls", (Seq<Function0<Object>>)concurrentFuctions, 30000);
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer(), this.resource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        TestUtils$.MODULE$.waitAndVerifyAcls((Set<AccessControlEntry>)Set.EmptySet$.MODULE$, (Authorizer)this.aclAuthorizer2(), this.resource());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAccessAllowedIfAllowAclExistsOnWildcardResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.wildCardResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAclOnWildcardResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.wildCardResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.wildCardResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAllAclOnWildcardResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.wildCardResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.wildCardResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAccessAllowedIfAllowAclExistsOnPrefixedResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAclOnPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.prefixedResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.prefixedResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testDeleteAllAclOnPrefixedResource() {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.prefixedResource());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnLiteralResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.resource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.resource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.resource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnWildcardResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.wildCardResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.wildCardResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.resource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAddAclsOnPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems3)), this.prefixedResource());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowWriteAcl(), this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems2)), this.prefixedResource());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl(), this.allowWriteAcl(), this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems), this.getAcls(this.aclAuthorizer(), this.prefixedResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.wildCardResource()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, this.getAcls(this.aclAuthorizer(), this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizeWithPrefixedResource() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        void apply_elems7;
        void apply_elems8;
        void apply_elems9;
        void apply_elems10;
        void apply_elems11;
        void apply_elems12;
        void apply_elems13;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems13)), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.LITERAL));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems12)), new ResourcePattern(ResourceType.TOPIC, "a_other", PatternType.PREFIXED));
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems11)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems10)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems9)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(8).append("foo-").append(UUID.randomUUID()).append("-zzz").toString(), PatternType.PREFIXED));
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems8)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(5).append("fooo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$7 = Predef$.MODULE$.Set();
        ArraySeq arraySeq7 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$7 == null) {
            throw null;
        }
        arraySeq7 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$7, (scala.collection.immutable.Seq)apply_elems7)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(3).append("fo-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$8 = Predef$.MODULE$.Set();
        ArraySeq arraySeq8 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$8 == null) {
            throw null;
        }
        arraySeq8 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$8, (scala.collection.immutable.Seq)apply_elems6)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fop-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$9 = Predef$.MODULE$.Set();
        ArraySeq arraySeq9 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$9 == null) {
            throw null;
        }
        arraySeq9 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$9, (scala.collection.immutable.Seq)apply_elems5)), new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("fon-").append(UUID.randomUUID()).toString(), PatternType.PREFIXED));
        Set$ set$10 = Predef$.MODULE$.Set();
        ArraySeq arraySeq10 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$10 == null) {
            throw null;
        }
        arraySeq10 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$10, (scala.collection.immutable.Seq)apply_elems4)), new ResourcePattern(ResourceType.TOPIC, "fon-", PatternType.PREFIXED));
        Set$ set$11 = Predef$.MODULE$.Set();
        ArraySeq arraySeq11 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$11 == null) {
            throw null;
        }
        arraySeq11 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$11, (scala.collection.immutable.Seq)apply_elems3)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        Set$ set$12 = Predef$.MODULE$.Set();
        ArraySeq arraySeq12 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$12 == null) {
            throw null;
        }
        arraySeq12 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$12, (scala.collection.immutable.Seq)apply_elems2)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL));
        Set$ set$13 = Predef$.MODULE$.Set();
        ArraySeq arraySeq13 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$13 == null) {
            throw null;
        }
        arraySeq13 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$13, (scala.collection.immutable.Seq)apply_elems)), this.prefixedResource());
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, this.resource()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSingleCharacterResourceAcls() {
        void apply_elems;
        void apply_elems2;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "f", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL)));
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.allowReadAcl()});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.TOPIC, "_", PatternType.PREFIXED));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_foo", PatternType.LITERAL)));
        Assert.assertTrue((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "_", PatternType.LITERAL)));
        Assert.assertFalse((boolean)this.authorize(this.aclAuthorizer(), this.requestContext(), AclOperation.READ, new ResourcePattern(ResourceType.TOPIC, "foo_", PatternType.LITERAL)));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testGetAclsPrincipal() {
        void apply_elems;
        void apply_elems2;
        AccessControlEntry aclOnSpecificPrincipal = new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnSpecificPrincipal});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), this.resource());
        Assert.assertEquals((String)"acl on specific should not be returned for wildcard request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for specific request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
        Assert.assertEquals((String)"acl on specific should be returned for different principal instance", (long)1L, (long)this.getAcls(this.aclAuthorizer(), new KafkaPrincipal(this.principal().getPrincipalType(), this.principal().getName())).size());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        this.removeAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)Set.EmptySet$.MODULE$, this.resource());
        AccessControlEntry aclOnWildcardPrincipal = new AccessControlEntry(AclEntry$.MODULE$.WildcardPrincipalString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.WRITE, AclPermissionType.ALLOW);
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{aclOnWildcardPrincipal});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), this.resource());
        Assert.assertEquals((String)"acl on wildcard should be returned for wildcard request", (long)1L, (long)this.getAcls(this.aclAuthorizer(), this.wildcardPrincipal()).size());
        Assert.assertEquals((String)"acl on wildcard should not be returned for specific request", (long)0L, (long)this.getAcls(this.aclAuthorizer(), this.principal()).size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAclsFilter() {
        void apply_elems;
        void apply_elems2;
        void apply_elems3;
        void apply_elems4;
        void apply_elems5;
        void apply_elems6;
        ResourcePattern resource1 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("foo-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern resource2 = new ResourcePattern(ResourceType.TOPIC, new StringBuilder(4).append("bar-").append(UUID.randomUUID()).toString(), PatternType.LITERAL);
        ResourcePattern prefixedResource = new ResourcePattern(ResourceType.TOPIC, "bar-", PatternType.PREFIXED);
        AclBinding acl1 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        AclBinding acl2 = new AclBinding(resource1, new AccessControlEntry(this.principal().toString(), "192.168.0.1", AclOperation.WRITE, AclPermissionType.ALLOW));
        AclBinding acl3 = new AclBinding(resource2, new AccessControlEntry(this.principal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.DESCRIBE, AclPermissionType.ALLOW));
        AclBinding acl4 = new AclBinding(prefixedResource, new AccessControlEntry(this.wildcardPrincipal().toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW));
        this.aclAuthorizer().createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)acl1, (List)new .colon.colon((Object)acl2, (List)new .colon.colon((Object)acl3, (List)new .colon.colon((Object)acl4, (List)Nil$.MODULE$))))).asJava());
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2, acl3, acl4});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems6), (Object)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(AclBindingFilter.ANY)).asScala()).toSet());
        Set$ set$2 = Predef$.MODULE$.Set();
        ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1, acl2});
        if (set$2 == null) {
            throw null;
        }
        arraySeq2 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems5), (Object)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(resource1.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        Set$ set$3 = Predef$.MODULE$.Set();
        ArraySeq arraySeq3 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl4});
        if (set$3 == null) {
            throw null;
        }
        arraySeq3 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$3, (scala.collection.immutable.Seq)apply_elems4), (Object)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(new AclBindingFilter(prefixedResource.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet());
        AclBindingFilter matchingFilter = new AclBindingFilter(new ResourcePatternFilter(ResourceType.ANY, resource2.name(), PatternType.MATCH), AccessControlEntryFilter.ANY);
        Set$ set$4 = Predef$.MODULE$.Set();
        ArraySeq arraySeq4 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4});
        if (set$4 == null) {
            throw null;
        }
        arraySeq4 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$4, (scala.collection.immutable.Seq)apply_elems3), (Object)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.aclAuthorizer().acls(matchingFilter)).asScala()).toSet());
        .colon.colon filters = new .colon.colon((Object)matchingFilter, (List)new .colon.colon((Object)acl1.toFilter(), (List)new .colon.colon((Object)new AclBindingFilter(resource2.toFilter(), AccessControlEntryFilter.ANY), (List)new .colon.colon((Object)new AclBindingFilter(new ResourcePatternFilter(ResourceType.TOPIC, "baz", PatternType.ANY), AccessControlEntryFilter.ANY), (List)Nil$.MODULE$))));
        Buffer deleteResults = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(this.aclAuthorizer().deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)filters).asJava())).asScala()).map((Function1 & Serializable)x$6 -> (AclDeleteResult)x$6.toCompletableFuture().get());
        Assert.assertEquals((Object)Nil$.MODULE$, (Object)deleteResults.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$2(x$7))));
        Range range = filters.indices();
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                AclAuthorizerTest.$anonfun$testAclsFilter$3(deleteResults, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
        Object var17_15 = null;
        Set$ set$5 = Predef$.MODULE$.Set();
        ArraySeq arraySeq5 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl3, acl4});
        if (set$5 == null) {
            throw null;
        }
        arraySeq5 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$5, (scala.collection.immutable.Seq)apply_elems2), (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(0)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable)x$9 -> x$9.aclBinding())).toSet());
        Set$ set$6 = Predef$.MODULE$.Set();
        ArraySeq arraySeq6 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBinding[]{acl1});
        if (set$6 == null) {
            throw null;
        }
        arraySeq6 = null;
        Assert.assertEquals((Object)IterableFactory.apply$((IterableFactory)set$6, (scala.collection.immutable.Seq)apply_elems), (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(1)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable)x$10 -> x$10.aclBinding())).toSet());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(2)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable)x$11 -> x$11.aclBinding())).toSet());
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults.apply(3)).aclBindingDeleteResults()).asScala()).map((Function1 & Serializable)x$12 -> x$12.aclBinding())).toSet());
    }

    @Test
    public void testThrowsOnAddPrefixedAclIfInterBrokerProtocolVersionTooLow() {
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ApiException e = (ApiException)Assertions$.MODULE$.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED));
        }, ClassTag$.MODULE$.apply(ApiException.class), new Position("AclAuthorizerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 730));
        Assert.assertTrue((String)new StringBuilder(21).append("Unexpected exception ").append(e).toString(), (boolean)(e.getCause() instanceof UnsupportedVersionException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesExtendedAclChangeEventIfInterBrokerProtocolNotSet() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)None$.MODULE$);
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesExtendedAclChangeEventWhenInterBrokerProtocolAtLeastKafkaV2() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.PREFIXED);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.PREFIXED).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.PREFIXED);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesLiteralWritesLiteralAclChangeEventWhenInterBrokerProtocolLessThanKafkaV2eralAclChangesForOlderProtocolVersions() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV0$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testWritesLiteralAclChangeEventWhenInterBrokerProtocolIsKafkaV2() {
        void apply_elems;
        this.givenAuthorizerWithProtocolVersion((Option<ApiVersion>)Option$.MODULE$.apply((Object)KAFKA_2_0_IV1$.MODULE$));
        ResourcePattern resource = new ResourcePattern(ResourceType.TOPIC, "z_other", PatternType.LITERAL);
        String expected = new String(ZkAclStore$.MODULE$.apply(PatternType.LITERAL).changeStore().createChangeNode(resource).bytes(), StandardCharsets.UTF_8);
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{this.denyReadAcl()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        this.addAcls(this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)), resource);
        String actual = this.getAclChangeEventAsString(PatternType.LITERAL);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testAuthorizerNoZkConfig() {
        Properties noTlsProps = Kafka$.MODULE$.getPropsFromArgs(new String[]{this.prepareDefaultConfig()});
        Assert.assertEquals((Object)None$.MODULE$, (Object)AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(noTlsProps), (scala.collection.mutable.Map)Map$.MODULE$.apply(((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)noTlsProps).asScala()).toSeq())));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfigWithDefaults() {
        void apply_elems;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[11];
        String string10 = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var5_4 = null;
        string10 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y2);
        String string11 = "true";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var7_6 = null;
        string11 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y);
        String string12 = string9 = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        string9 = null;
        String $minus$greater$extension_$this3 = string12;
        Object var9_8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String string13 = string8 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        string8 = null;
        String $minus$greater$extension_$this4 = string13;
        Object var10_10 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String string14 = string7 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        string7 = null;
        String $minus$greater$extension_$this5 = string14;
        Object var11_12 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String string15 = string6 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        string6 = null;
        String $minus$greater$extension_$this6 = string15;
        Object var12_14 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String string16 = string5 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        string5 = null;
        String $minus$greater$extension_$this7 = string16;
        Object var13_16 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String string17 = string4 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        string4 = null;
        String $minus$greater$extension_$this8 = string17;
        Object var14_18 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String string18 = string3 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        string3 = null;
        String $minus$greater$extension_$this9 = string18;
        Object var15_20 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String string19 = string2 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        string2 = null;
        String $minus$greater$extension_$this10 = string19;
        Object var16_22 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String string20 = string = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        string = null;
        String $minus$greater$extension_$this11 = string20;
        Object var17_24 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromKafkaConfig() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[15];
        String string11 = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var5_4 = null;
        string11 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y5);
        String string12 = "true";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var7_6 = null;
        string12 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y4);
        String string13 = string10 = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        string10 = null;
        String $minus$greater$extension_$this3 = string13;
        Object var9_8 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String string14 = string9 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        string9 = null;
        String $minus$greater$extension_$this4 = string14;
        Object var10_10 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String string15 = string8 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        string8 = null;
        String $minus$greater$extension_$this5 = string15;
        Object var11_12 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String string16 = string7 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        string7 = null;
        String $minus$greater$extension_$this6 = string16;
        Object var12_14 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String string17 = string6 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        string6 = null;
        String $minus$greater$extension_$this7 = string17;
        Object var13_16 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String string18 = string5 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        string5 = null;
        String $minus$greater$extension_$this8 = string18;
        Object var14_18 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String string19 = string4 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        string4 = null;
        String $minus$greater$extension_$this9 = string19;
        Object var15_20 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String string20 = string3 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        string3 = null;
        String $minus$greater$extension_$this10 = string20;
        Object var16_22 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String string21 = string2 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        string2 = null;
        String $minus$greater$extension_$this11 = string21;
        Object var17_24 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        String string22 = string = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        string = null;
        String $minus$greater$extension_$this12 = string22;
        Object var18_26 = null;
        objectArray[11] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)kafkaValue);
        String string23 = "HTTPS";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Object var19_28 = null;
        string23 = null;
        objectArray[12] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y3);
        String string24 = "false";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Object var21_30 = null;
        string24 = null;
        objectArray[13] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y2);
        String string25 = "false";
        String $minus$greater$extension_$this15 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Object var23_32 = null;
        string25 = null;
        objectArray[14] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromKafkaConfig$2(zkClientConfig, kafkaValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAuthorizerZkConfigFromPrefixOverrides() {
        void apply_elems;
        void $minus$greater$extension_y;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_y3;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        String string9;
        String string10;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_y7;
        String string11;
        String string12;
        String string13;
        String string14;
        String string15;
        String string16;
        String string17;
        String string18;
        String string19;
        String string20;
        void $minus$greater$extension_y8;
        void $minus$greater$extension_y9;
        Properties props = new Properties();
        String kafkaValue = "kafkaValue";
        String prefixedValue = "prefixedValue";
        String prefix = "authorizer.";
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[29];
        String string21 = "somewhere";
        String $minus$greater$extension_$this = "zookeeper.connect";
        Object var7_6 = null;
        string21 = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y9);
        String string22 = "false";
        String $minus$greater$extension_$this2 = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        Object var9_8 = null;
        string22 = null;
        objectArray[1] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y8);
        String string23 = string20 = KafkaConfig$.MODULE$.ZkClientCnxnSocketProp();
        string20 = null;
        String $minus$greater$extension_$this3 = string23;
        Object var11_10 = null;
        objectArray[2] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)kafkaValue);
        String string24 = string19 = KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp();
        string19 = null;
        String $minus$greater$extension_$this4 = string24;
        Object var12_12 = null;
        objectArray[3] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)kafkaValue);
        String string25 = string18 = KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp();
        string18 = null;
        String $minus$greater$extension_$this5 = string25;
        Object var13_14 = null;
        objectArray[4] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)kafkaValue);
        String string26 = string17 = KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp();
        string17 = null;
        String $minus$greater$extension_$this6 = string26;
        Object var14_16 = null;
        objectArray[5] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)kafkaValue);
        String string27 = string16 = KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp();
        string16 = null;
        String $minus$greater$extension_$this7 = string27;
        Object var15_18 = null;
        objectArray[6] = new Tuple2((Object)$minus$greater$extension_$this7, (Object)kafkaValue);
        String string28 = string15 = KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp();
        string15 = null;
        String $minus$greater$extension_$this8 = string28;
        Object var16_20 = null;
        objectArray[7] = new Tuple2((Object)$minus$greater$extension_$this8, (Object)kafkaValue);
        String string29 = string14 = KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp();
        string14 = null;
        String $minus$greater$extension_$this9 = string29;
        Object var17_22 = null;
        objectArray[8] = new Tuple2((Object)$minus$greater$extension_$this9, (Object)kafkaValue);
        String string30 = string13 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        string13 = null;
        String $minus$greater$extension_$this10 = string30;
        Object var18_24 = null;
        objectArray[9] = new Tuple2((Object)$minus$greater$extension_$this10, (Object)kafkaValue);
        String string31 = string12 = KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp();
        string12 = null;
        String $minus$greater$extension_$this11 = string31;
        Object var19_26 = null;
        objectArray[10] = new Tuple2((Object)$minus$greater$extension_$this11, (Object)kafkaValue);
        String string32 = string11 = KafkaConfig$.MODULE$.ZkSslCipherSuitesProp();
        string11 = null;
        String $minus$greater$extension_$this12 = string32;
        Object var20_28 = null;
        objectArray[11] = new Tuple2((Object)$minus$greater$extension_$this12, (Object)kafkaValue);
        String string33 = "HTTPS";
        String $minus$greater$extension_$this13 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        Object var21_30 = null;
        string33 = null;
        objectArray[12] = new Tuple2((Object)$minus$greater$extension_$this13, (Object)$minus$greater$extension_y7);
        String string34 = "false";
        String $minus$greater$extension_$this14 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        Object var23_32 = null;
        string34 = null;
        objectArray[13] = new Tuple2((Object)$minus$greater$extension_$this14, (Object)$minus$greater$extension_y6);
        String string35 = "false";
        String $minus$greater$extension_$this15 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
        Object var25_34 = null;
        string35 = null;
        objectArray[14] = new Tuple2((Object)$minus$greater$extension_$this15, (Object)$minus$greater$extension_y5);
        String string36 = "true";
        String $minus$greater$extension_$this16 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslClientEnableProp()).toString();
        Object var27_36 = null;
        string36 = null;
        objectArray[15] = new Tuple2((Object)$minus$greater$extension_$this16, (Object)$minus$greater$extension_y4);
        String string37 = string10 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkClientCnxnSocketProp()).toString();
        string10 = null;
        String $minus$greater$extension_$this17 = string37;
        Object var29_38 = null;
        objectArray[16] = new Tuple2((Object)$minus$greater$extension_$this17, (Object)prefixedValue);
        String string38 = string9 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreLocationProp()).toString();
        string9 = null;
        String $minus$greater$extension_$this18 = string38;
        Object var30_40 = null;
        objectArray[17] = new Tuple2((Object)$minus$greater$extension_$this18, (Object)prefixedValue);
        String string39 = string8 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStorePasswordProp()).toString();
        string8 = null;
        String $minus$greater$extension_$this19 = string39;
        Object var31_42 = null;
        objectArray[18] = new Tuple2((Object)$minus$greater$extension_$this19, (Object)prefixedValue);
        String string40 = string7 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslKeyStoreTypeProp()).toString();
        string7 = null;
        String $minus$greater$extension_$this20 = string40;
        Object var32_44 = null;
        objectArray[19] = new Tuple2((Object)$minus$greater$extension_$this20, (Object)prefixedValue);
        String string41 = string6 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreLocationProp()).toString();
        string6 = null;
        String $minus$greater$extension_$this21 = string41;
        Object var33_46 = null;
        objectArray[20] = new Tuple2((Object)$minus$greater$extension_$this21, (Object)prefixedValue);
        String string42 = string5 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStorePasswordProp()).toString();
        string5 = null;
        String $minus$greater$extension_$this22 = string42;
        Object var34_48 = null;
        objectArray[21] = new Tuple2((Object)$minus$greater$extension_$this22, (Object)prefixedValue);
        String string43 = string4 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslTrustStoreTypeProp()).toString();
        string4 = null;
        String $minus$greater$extension_$this23 = string43;
        Object var35_50 = null;
        objectArray[22] = new Tuple2((Object)$minus$greater$extension_$this23, (Object)prefixedValue);
        String string44 = string3 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslProtocolProp()).toString();
        string3 = null;
        String $minus$greater$extension_$this24 = string44;
        Object var36_52 = null;
        objectArray[23] = new Tuple2((Object)$minus$greater$extension_$this24, (Object)prefixedValue);
        String string45 = string2 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEnabledProtocolsProp()).toString();
        string2 = null;
        String $minus$greater$extension_$this25 = string45;
        Object var37_54 = null;
        objectArray[24] = new Tuple2((Object)$minus$greater$extension_$this25, (Object)prefixedValue);
        String string46 = string = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCipherSuitesProp()).toString();
        string = null;
        String $minus$greater$extension_$this26 = string46;
        Object var38_56 = null;
        objectArray[25] = new Tuple2((Object)$minus$greater$extension_$this26, (Object)prefixedValue);
        String string47 = "";
        String $minus$greater$extension_$this27 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp()).toString();
        Object var39_58 = null;
        string47 = null;
        objectArray[26] = new Tuple2((Object)$minus$greater$extension_$this27, (Object)$minus$greater$extension_y3);
        String string48 = "true";
        String $minus$greater$extension_$this28 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslCrlEnableProp()).toString();
        Object var41_60 = null;
        string48 = null;
        objectArray[27] = new Tuple2((Object)$minus$greater$extension_$this28, (Object)$minus$greater$extension_y2);
        String string49 = "true";
        String $minus$greater$extension_$this29 = new StringBuilder(0).append(prefix).append(KafkaConfig$.MODULE$.ZkSslOcspEnableProp()).toString();
        Object var43_62 = null;
        string49 = null;
        objectArray[28] = new Tuple2((Object)$minus$greater$extension_$this29, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map configs = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        configs.foreach((Function1 & Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String key = (String)x0$1._1();
            String value = (String)x0$1._2();
            Object object = props.put(key, value.toString());
            return object;
        });
        Option zkClientConfig = AclAuthorizer$.MODULE$.zkClientConfigFromKafkaConfigAndMap(KafkaConfig$.MODULE$.fromProps(props), (scala.collection.mutable.Map)Map$.MODULE$.apply(configs.toSeq()));
        Assert.assertTrue((boolean)zkClientConfig.isDefined());
        KafkaConfig$.MODULE$.ZkSslConfigToSystemPropertyMap().keys().foreach((Function1 & Serializable)prop -> {
            AclAuthorizerTest.$anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(zkClientConfig, prefixedValue, prop);
            return BoxedUnit.UNIT;
        });
    }

    private void givenAuthorizerWithProtocolVersion(Option<ApiVersion> protocolVersion) {
        this.aclAuthorizer().close();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, this.zkConnect(), true, true, TestUtils$.MODULE$.RandomPort(), (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), false, TestUtils$.MODULE$.RandomPort(), (Option<String>)None$.MODULE$, 1, false, 1, (short)1);
        props.put(AclAuthorizer$.MODULE$.SuperUsersProp(), this.superUsers());
        if (protocolVersion == null) {
            throw null;
        }
        if (!protocolVersion.isEmpty()) {
            ApiVersion apiVersion = (ApiVersion)protocolVersion.get();
            props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), apiVersion.toString());
        }
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
        this.aclAuthorizer().configure(this.config().originals());
    }

    private String getAclChangeEventAsString(PatternType patternType) {
        ZkAclStore store = ZkAclStore$.MODULE$.apply(patternType);
        GetChildrenResponse children = (GetChildrenResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetChildrenRequest(store.changeStore().aclChangePath(), (Option)None$.MODULE$));
        children.maybeThrow();
        Seq seq = children.children();
        if (seq == null) {
            throw null;
        }
        Assert.assertEquals((String)"Expecting 1 change event", (long)1L, (long)seq.length());
        GetDataResponse data = (GetDataResponse)this.zooKeeperClient().handleRequest((AsyncRequest)new GetDataRequest(new StringBuilder(1).append(store.changeStore().aclChangePath()).append("/").append(children.children().head()).toString(), (Option)None$.MODULE$));
        data.maybeThrow();
        return new String(data.data(), StandardCharsets.UTF_8);
    }

    private Set<AccessControlEntry> changeAclAndVerify(Set<AccessControlEntry> originalAcls, Set<AccessControlEntry> addedAcls, Set<AccessControlEntry> removedAcls, ResourcePattern resource) {
        Set acls = originalAcls;
        if (addedAcls.nonEmpty()) {
            this.addAcls(this.aclAuthorizer(), addedAcls, resource);
            if (originalAcls == null) {
                throw null;
            }
            acls = (Set)originalAcls.concat(addedAcls);
        }
        if (removedAcls.nonEmpty()) {
            this.removeAcls(this.aclAuthorizer(), removedAcls, resource);
            if (acls == null) {
                throw null;
            }
            acls = (Set)acls.removedAll(removedAcls);
        }
        TestUtils$.MODULE$.waitAndVerifyAcls(acls, (Authorizer)this.aclAuthorizer(), resource);
        return acls;
    }

    private ResourcePattern changeAclAndVerify$default$4() {
        return this.resource();
    }

    private RequestContext newRequestContext(KafkaPrincipal principal, InetAddress clientAddress, ApiKeys apiKey) {
        SecurityProtocol securityProtocol = SecurityProtocol.SASL_PLAINTEXT;
        RequestHeader header = new RequestHeader(apiKey, 2, "", 1);
        return new RequestContext(header, "", clientAddress, principal, ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol, ClientInformation.EMPTY);
    }

    private ApiKeys newRequestContext$default$3() {
        return ApiKeys.PRODUCE;
    }

    private boolean authorize(AclAuthorizer authorizer, RequestContext requestContext, AclOperation operation, ResourcePattern resource) {
        Action action = new Action(operation, resource, 1, true, true);
        Object object = ((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.authorize((AuthorizableRequestContext)requestContext, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)action, (List)Nil$.MODULE$)).asJava())).asScala()).head();
        AuthorizationResult authorizationResult = AuthorizationResult.ALLOWED;
        return !(object != null ? !object.equals(authorizationResult) : authorizationResult != null);
    }

    private void addAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set bindings = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace));
        ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.createAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable)x$13 -> (AclCreateResult)x$13.toCompletableFuture().get())).foreach((Function1 & Serializable)result -> {
            AclAuthorizerTest.$anonfun$addAcls$3(result);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    private boolean removeAcls(AclAuthorizer authorizer, Set<AccessControlEntry> aces, ResourcePattern resourcePattern) {
        Set set;
        if (aces.isEmpty()) {
            void apply_elems;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AclBindingFilter[]{new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY)});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            set = (Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems);
        } else {
            set = (Set)aces.map((Function1 & Serializable)ace -> new AclBinding(resourcePattern, ace).toFilter());
        }
        Set bindings = set;
        return ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(authorizer.deleteAcls((AuthorizableRequestContext)this.requestContext(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)bindings.toList()).asJava())).asScala()).map((Function1 & Serializable)x$14 -> (AclDeleteResult)x$14.toCompletableFuture().get())).forall((Function1 & Serializable)result -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$3(result)));
    }

    private Set<AccessControlEntry> getAcls(AclAuthorizer authorizer, ResourcePattern resourcePattern) {
        return (Set)((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(new AclBindingFilter(resourcePattern.toFilter(), AccessControlEntryFilter.ANY))).asScala()).toSet().map((Function1 & Serializable)x$16 -> x$16.entry());
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer, KafkaPrincipal principal) {
        AclBindingFilter filter = new AclBindingFilter(ResourcePatternFilter.ANY, new AccessControlEntryFilter(principal.toString(), null, AclOperation.ANY, AclPermissionType.ANY));
        return ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(filter)).asScala()).toSet();
    }

    private Set<AclBinding> getAcls(AclAuthorizer authorizer) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(authorizer.acls(AclBindingFilter.ANY)).asScala()).toSet();
    }

    private boolean validOp(AclOperation op) {
        AclOperation aclOperation = op;
        AclOperation aclOperation2 = AclOperation.ANY;
        if (aclOperation == null ? aclOperation2 != null : !aclOperation.equals(aclOperation2)) {
            AclOperation aclOperation3 = op;
            AclOperation aclOperation4 = AclOperation.UNKNOWN;
            if (aclOperation3 == null ? aclOperation4 != null : !aclOperation3.equals(aclOperation4)) {
                return true;
            }
        }
        return false;
    }

    private String prepareDefaultConfig() {
        return this.prepareConfig(new String[]{"broker.id=1", "zookeeper.connect=somewhere"});
    }

    private String prepareConfig(String[] lines) {
        String string;
        File file = File.createTempFile("kafkatest", ".properties");
        file.deleteOnExit();
        try (OutputStream writer = Files.newOutputStream(file.toPath(), new OpenOption[0]);){
            for (String string2 : lines) {
                AclAuthorizerTest.$anonfun$prepareConfig$1(writer, string2);
            }
            string = file.getAbsolutePath();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$1(AclAuthorizerTest $this, AccessControlEntry acl1$1, AccessControlEntry acl2$1, KafkaPrincipal user1$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl1$1, acl2$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Object object = ((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user1$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$3() {
        return "changes not propagated in timeout period";
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$4(AclAuthorizerTest $this, AccessControlEntry acl3$1, AccessControlEntry acl4$1, AccessControlEntry acl5$1, KafkaPrincipal user2$1) {
        void apply_elems;
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl3$1, acl4$1, acl5$1});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Object object = ((IterableOps)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems)).map((Function1 & Serializable)acl -> new AclBinding($this.resource(), acl));
        Set<AclBinding> set = $this.getAcls($this.aclAuthorizer(), user2$1);
        return !(object != null ? !object.equals(set) : set != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$6() {
        return "changes not propagated in timeout period";
    }

    public static final /* synthetic */ boolean $anonfun$testAclManagementAPIs$10(AclAuthorizerTest $this, Set expectedAcls$1) {
        Set set = expectedAcls$1;
        Set<AclBinding> set2 = $this.getAcls($this.aclAuthorizer());
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ String $anonfun$testAclManagementAPIs$11() {
        return "changes not propagated in timeout period.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1(int i) {
        KafkaPrincipal useri = new KafkaPrincipal("User", ((Object)i).toString());
        return new Tuple2((Object)new AccessControlEntry(useri.toString(), AclEntry$.MODULE$.WildcardHost(), AclOperation.READ, AclPermissionType.ALLOW), (Object)i);
    }

    public static final /* synthetic */ boolean $anonfun$testHighConcurrencyModificationOfResourceAcls$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = x0$2._2$mcI$sp() % 10 != 0;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfAllow$2(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), hostContext$1, op, $this.clusterResource());
                if (allowedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$1) : parentOp$1 != null) break block3;
            }
            Assert.assertTrue((String)new StringBuilder(26).append("ALLOW ").append(parentOp$1).append(" should imply ALLOW ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertFalse((String)new StringBuilder(30).append("ALLOW ").append(parentOp$1).append(" should not imply ALLOW ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ void $anonfun$testImplicationsOfDeny$2(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        boolean authorized;
        block3: {
            block2: {
                authorized = $this.authorize($this.aclAuthorizer(), host1Context$1, op, $this.clusterResource());
                if (deniedOps$1.contains((Object)op)) break block2;
                AclOperation aclOperation = op;
                if (aclOperation != null ? !aclOperation.equals(parentOp$2) : parentOp$2 != null) break block3;
            }
            Assert.assertFalse((String)new StringBuilder(24).append("DENY ").append(parentOp$2).append(" should imply DENY ").append(op).toString(), (boolean)authorized);
            return;
        }
        Assert.assertTrue((String)new StringBuilder(28).append("DENY ").append(parentOp$2).append(" should not imply DENY ").append(op).toString(), (boolean)authorized);
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1(AclAuthorizerTest $this, AccessControlEntry acl$2, int x$5) {
        return (JFunction0.mcZ.sp & Serializable)() -> {
            void apply_elems;
            void apply_elems2;
            Set$ set$ = Predef$.MODULE$.Set();
            ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2});
            if (set$ == null) {
                throw null;
            }
            arraySeq = null;
            $this.addAcls($this.aclAuthorizer(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems2)), $this.resource());
            Set$ set$2 = Predef$.MODULE$.Set();
            ArraySeq arraySeq2 = ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AccessControlEntry[]{acl$2});
            if (set$2 == null) {
                throw null;
            }
            arraySeq2 = null;
            return $this.removeAcls($this.aclAuthorizer2(), (Set<AccessControlEntry>)((Set)IterableFactory.apply$((IterableFactory)set$2, (scala.collection.immutable.Seq)apply_elems)), $this.resource());
        };
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$2(AclDeleteResult x$7) {
        return x$7.exception().isPresent();
    }

    public static final /* synthetic */ boolean $anonfun$testAclsFilter$4(AclDeleteResult.AclBindingDeleteResult x$8) {
        return x$8.exception().isPresent();
    }

    public static final /* synthetic */ void $anonfun$testAclsFilter$3(Buffer deleteResults$1, int i) {
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((Object)Set.EmptySet$.MODULE$, (Object)((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((AclDeleteResult)deleteResults$1.apply(i)).aclBindingDeleteResults()).asScala()).toSet().filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$testAclsFilter$4(x$8))));
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$5() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$6() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfigWithDefaults$2(Option zkClientConfig$1, String kafkaValue$1, String prop) {
        Object object;
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Object object2;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string3;
                String string4 = string3 = "<None>";
                string3 = null;
                object2 = string4;
            } else {
                object2 = getOrElse_this.get();
            }
            Object object3 = object2;
            Object var5_4 = null;
            object2 = null;
            Assert.assertEquals((Object)"true", (Object)object3);
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string6 != null ? !string6.equals(prop) : prop != null);
        }
        if (bl) {
            Object object4;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string7;
                String string8 = string7 = "<None>";
                string7 = null;
                object4 = string8;
            } else {
                object4 = getOrElse_this.get();
            }
            Object object5 = object4;
            Object var7_8 = null;
            object4 = null;
            Assert.assertEquals((Object)"false", (Object)object5);
            return;
        }
        String string9 = KafkaConfig$.MODULE$.ZkSslProtocolProp();
        if (!(string9 != null ? !string9.equals(prop) : prop != null)) {
            Object object6;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string10;
                String string11 = string10 = "<None>";
                string10 = null;
                object6 = string11;
            } else {
                object6 = getOrElse_this.get();
            }
            Object object7 = object6;
            Object var9_11 = null;
            object6 = null;
            Assert.assertEquals((Object)"TLSv1.2", (Object)object7);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$1.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string12;
            String string13 = string12 = "<None>";
            string12 = null;
            object = string13;
        } else {
            object = getOrElse_this.get();
        }
        Object object8 = object;
        Object var11_14 = null;
        object = null;
        Assert.assertEquals((Object)kafkaValue$1, (Object)object8);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromKafkaConfig$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromKafkaConfig$2(Option zkClientConfig$2, String kafkaValue$2, String prop) {
        Object object;
        boolean bl;
        boolean bl2;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl2 = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
            bl2 = !(string2 != null ? !string2.equals(prop) : prop != null);
        }
        if (bl2) {
            Object object2;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string3;
                String string4 = string3 = "<None>";
                string3 = null;
                object2 = string4;
            } else {
                object2 = getOrElse_this.get();
            }
            Object object3 = object2;
            Object var5_4 = null;
            object2 = null;
            Assert.assertEquals((Object)"true", (Object)object3);
            return;
        }
        String string5 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
        if (!(string5 != null ? !string5.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string6 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
            bl = !(string6 != null ? !string6.equals(prop) : prop != null);
        }
        if (bl) {
            Object object4;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string7;
                String string8 = string7 = "<None>";
                string7 = null;
                object4 = string8;
            } else {
                object4 = getOrElse_this.get();
            }
            Object object5 = object4;
            Object var7_8 = null;
            object4 = null;
            Assert.assertEquals((Object)"false", (Object)object5);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$2.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string9;
            String string10 = string9 = "<None>";
            string9 = null;
            object = string10;
        } else {
            object = getOrElse_this.get();
        }
        Object object6 = object;
        Object var9_11 = null;
        object = null;
        Assert.assertEquals((Object)kafkaValue$2, (Object)object6);
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$3() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$4() {
        return "<None>";
    }

    public static final /* synthetic */ String $anonfun$testAuthorizerZkConfigFromPrefixOverrides$5() {
        return "<None>";
    }

    public static final /* synthetic */ void $anonfun$testAuthorizerZkConfigFromPrefixOverrides$2(Option zkClientConfig$3, String prefixedValue$1, String prop) {
        Object object;
        boolean bl;
        String string = KafkaConfig$.MODULE$.ZkSslClientEnableProp();
        if (!(string != null ? !string.equals(prop) : prop != null)) {
            bl = true;
        } else {
            String string2 = KafkaConfig$.MODULE$.ZkSslCrlEnableProp();
            if (!(string2 != null ? !string2.equals(prop) : prop != null)) {
                bl = true;
            } else {
                String string3 = KafkaConfig$.MODULE$.ZkSslOcspEnableProp();
                bl = !(string3 != null ? !string3.equals(prop) : prop != null);
            }
        }
        if (bl) {
            Object object2;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string4;
                String string5 = string4 = "<None>";
                string4 = null;
                object2 = string5;
            } else {
                object2 = getOrElse_this.get();
            }
            Object object3 = object2;
            Object var4_4 = null;
            object2 = null;
            Assert.assertEquals((Object)"true", (Object)object3);
            return;
        }
        String string6 = KafkaConfig$.MODULE$.ZkSslEndpointIdentificationAlgorithmProp();
        if (!(string6 != null ? !string6.equals(prop) : prop != null)) {
            Object object4;
            Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
            if (option == null) {
                throw null;
            }
            Option getOrElse_this = option;
            if (getOrElse_this.isEmpty()) {
                String string7;
                String string8 = string7 = "<None>";
                string7 = null;
                object4 = string8;
            } else {
                object4 = getOrElse_this.get();
            }
            Object object5 = object4;
            Object var6_7 = null;
            object4 = null;
            Assert.assertEquals((Object)"false", (Object)object5);
            return;
        }
        Option option = KafkaConfig$.MODULE$.getZooKeeperClientProperty((ZKClientConfig)zkClientConfig$3.get(), prop);
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            String string9;
            String string10 = string9 = "<None>";
            string9 = null;
            object = string10;
        } else {
            object = getOrElse_this.get();
        }
        Object object6 = object;
        Object var8_10 = null;
        object = null;
        Assert.assertEquals((Object)prefixedValue$1, (Object)object6);
    }

    public static final /* synthetic */ Nothing$ $anonfun$addAcls$4(ApiException e) {
        throw e;
    }

    public static final /* synthetic */ void $anonfun$addAcls$3(AclCreateResult result) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(result.exception());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            throw (ApiException)foreach_this.get();
        }
    }

    public static final /* synthetic */ Nothing$ $anonfun$removeAcls$4(ApiException e) {
        throw e;
    }

    public static final /* synthetic */ Nothing$ $anonfun$removeAcls$6(ApiException e) {
        throw e;
    }

    public static final /* synthetic */ void $anonfun$removeAcls$5(AclDeleteResult.AclBindingDeleteResult r) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(r.exception());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            throw (ApiException)foreach_this.get();
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$7(AclDeleteResult.AclBindingDeleteResult x$15) {
        return OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(x$15.exception()).isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$removeAcls$3(AclDeleteResult result) {
        Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(result.exception());
        if (option == null) {
            throw null;
        }
        Option foreach_this = option;
        if (!foreach_this.isEmpty()) {
            throw (ApiException)foreach_this.get();
        }
        Object var1_1 = null;
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).foreach((Function1 & Serializable)r -> {
            AclAuthorizerTest.$anonfun$removeAcls$5(r);
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(result.aclBindingDeleteResults()).asScala()).exists((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AclAuthorizerTest.$anonfun$removeAcls$7(x$15)));
    }

    public static final /* synthetic */ void $anonfun$prepareConfig$1(OutputStream writer$1, String l) {
        writer$1.write(l.getBytes());
        writer$1.write("\n".getBytes());
    }

    public AclAuthorizerTest() {
        this.superUsers = "User:superuser1; User:superuser2";
        this.username = "alice";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testHighConcurrencyModificationOfResourceAcls$1$adapted(Object i) {
        return AclAuthorizerTest.$anonfun$testHighConcurrencyModificationOfResourceAcls$1(BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfAllow$1$adapted(AclAuthorizerTest $this, AclOperation op) {
        return BoxesRunTime.boxToBoolean((boolean)$this.validOp(op));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfAllow$2$adapted(AclAuthorizerTest $this, RequestContext hostContext$1, Set allowedOps$1, AclOperation parentOp$1, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfAllow$2($this, hostContext$1, allowedOps$1, parentOp$1, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfDeny$1$adapted(AclAuthorizerTest $this, AclOperation op) {
        return BoxesRunTime.boxToBoolean((boolean)$this.validOp(op));
    }

    public static final /* synthetic */ Object $anonfun$testImplicationsOfDeny$2$adapted(AclAuthorizerTest $this, RequestContext host1Context$1, Set deniedOps$1, AclOperation parentOp$2, AclOperation op) {
        AclAuthorizerTest.$anonfun$testImplicationsOfDeny$2($this, host1Context$1, deniedOps$1, parentOp$2, op);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Function0 $anonfun$testHighConcurrencyDeletionOfResourceAcls$1$adapted(AclAuthorizerTest $this, AccessControlEntry acl$2, Object x$5) {
        return AclAuthorizerTest.$anonfun$testHighConcurrencyDeletionOfResourceAcls$1($this, acl$2, BoxesRunTime.unboxToInt((Object)x$5));
    }

    public static final /* synthetic */ Object $anonfun$prepareConfig$1$adapted(OutputStream writer$1, String l) {
        AclAuthorizerTest.$anonfun$prepareConfig$1(writer$1, l);
        return BoxedUnit.UNIT;
    }

    public class CustomPrincipal
    extends KafkaPrincipal {
        public boolean equals(Object o) {
            return false;
        }

        public /* synthetic */ AclAuthorizerTest kafka$security$authorizer$AclAuthorizerTest$CustomPrincipal$$$outer() {
            return AclAuthorizerTest.this;
        }

        public CustomPrincipal(String principalType, String name) {
            if (AclAuthorizerTest.this == null) {
                throw null;
            }
            super(principalType, name);
        }
    }
}

