/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableFactory;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ef\u0001\u0002\u0012$\u0001!BQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u0004S\u0001\u0001\u0007I\u0011A*\t\re\u0003\u0001\u0015)\u00036\u0011\u001dQ\u0006A1A\u0005\u0002mCaa\u0018\u0001!\u0002\u0013a\u0006b\u00021\u0001\u0005\u0004%\t!\u0019\u0005\u0007E\u0002\u0001\u000b\u0011B&\t\u000f\r\u0004!\u0019!C\u0001C\"1A\r\u0001Q\u0001\n-Cq!\u001a\u0001C\u0002\u0013\u00051\f\u0003\u0004g\u0001\u0001\u0006I\u0001\u0018\u0005\bO\u0002\u0011\r\u0011\"\u0001i\u0011\u0019\t\b\u0001)A\u0005S\"9!\u000f\u0001b\u0001\n\u0003\u0019\bB\u0002=\u0001A\u0003%A\u000fC\u0004z\u0001\t\u0007I\u0011\u0001>\t\u000f\u0005\u0005\u0001\u0001)A\u0005w\"I\u00111\u0001\u0001C\u0002\u0013\u0005\u0011Q\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\b!I\u0011Q\u0003\u0001C\u0002\u0013\u0005\u0011q\u0003\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002\u001a!I\u00111\u0007\u0001A\u0002\u0013\u0005\u0011Q\u0007\u0005\n\u0003{\u0001\u0001\u0019!C\u0001\u0003\u007fA\u0001\"a\u0011\u0001A\u0003&\u0011q\u0007\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t9\u0006\u0001C\u0001\u0003\u000fBq!!\u0019\u0001\t\u0003\t9\u0005C\u0004\u0002l\u0001!\t!a\u0012\t\u000f\u0005=\u0004\u0001\"\u0001\u0002H!9\u00111\u000f\u0001\u0005\u0002\u0005\u001d\u0003bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003[\u0003A\u0011BAX\u0005EI5O]#ya&\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003I\u0015\naa]3sm\u0016\u0014(\"\u0001\u0014\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\u000b\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005\t\u0004C\u0001\u001a\u0001\u001b\u0005\u0019\u0013!\u0005;pa&\u001c\u0007+\u0019:uSRLwN\\%teV\tQ\u0007\u0005\u00037wurU\"A\u001c\u000b\u0005aJ\u0014aB7vi\u0006\u0014G.\u001a\u0006\u0003u-\n!bY8mY\u0016\u001cG/[8o\u0013\tatGA\u0002NCB\u0004BA\u000b A\u0017&\u0011qh\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005\u0005CeB\u0001\"G!\t\u00195&D\u0001E\u0015\t)u%\u0001\u0004=e>|GOP\u0005\u0003\u000f.\na\u0001\u0015:fI\u00164\u0017BA%K\u0005\u0019\u0019FO]5oO*\u0011qi\u000b\t\u0003U1K!!T\u0016\u0003\u0007%sG\u000fE\u0002P!.k\u0011!O\u0005\u0003#f\u00121aU3r\u0003U!x\u000e]5d!\u0006\u0014H/\u001b;j_:L5O]0%KF$\"\u0001V,\u0011\u0005)*\u0016B\u0001,,\u0005\u0011)f.\u001b;\t\u000fa\u001b\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u0002%Q|\u0007/[2QCJ$\u0018\u000e^5p]&\u001b(\u000fI\u0001\u0014e\u0016\u0004H.[2b\u0019\u0006<G+[7f\u001b\u0006DXj]\u000b\u00029B\u0011!&X\u0005\u0003=.\u0012A\u0001T8oO\u0006!\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=Ng\u0002\nQC]3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5/F\u0001L\u0003Y\u0011X\r\u001d7jG\u00064U\r^2i/\u0006LG/T1y\u001bN\u0004\u0013A\u00057fC\u0012,'\u000fT8h\u000b:$wJ\u001a4tKR\f1\u0003\\3bI\u0016\u0014Hj\\4F]\u0012|eMZ:fi\u0002\na\u0003\\3bI\u0016\u0014Hj\\4IS\u001eDw+\u0019;fe6\f'o[\u0001\u0018Y\u0016\fG-\u001a:M_\u001eD\u0015n\u001a5XCR,'/\\1sW\u0002\nqb\u001c<feJLG-\u001b8h!J|\u0007o]\u000b\u0002SB\u0011!n\\\u0007\u0002W*\u0011A.\\\u0001\u0005kRLGNC\u0001o\u0003\u0011Q\u0017M^1\n\u0005A\\'A\u0003)s_B,'\u000f^5fg\u0006\u0001rN^3se&$\u0017N\\4Qe>\u00048\u000fI\u0001\bG>tg-[4t+\u0005!\bcA(QkB\u0011!G^\u0005\u0003o\u000e\u00121bS1gW\u0006\u001cuN\u001c4jO\u0006A1m\u001c8gS\u001e\u001c\b%A\u0003u_BL7-F\u0001|!\tax0D\u0001~\u0015\tqX.\u0001\u0003mC:<\u0017BA%~\u0003\u0019!x\u000e]5dA\u0005!A/[7f+\t\t9\u0001\u0005\u0003\u0002\n\u0005=QBAA\u0006\u0015\r\ti!J\u0001\u0006kRLGn]\u0005\u0005\u0003#\tYA\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\"!!\u0007\u0011\t\u0005m\u0011QF\u0007\u0003\u0003;QA!!\u0006\u0002 )!\u0011\u0011EA\u0012\u0003\u0019\u0019w.\\7p]*\u0019a%!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\u0007CB\f7\r[3\u000b\u0005\u0005-\u0012aA8sO&!\u0011qFA\u000f\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\u000fe\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s+\t\t9\u0004E\u00023\u0003sI1!a\u000f$\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\f!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019A+!\u0011\t\u0011aC\u0012\u0011!a\u0001\u0003o\tqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002)\"\u001a!$a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fRA!!\u0015\u0002*\u0005)!.\u001e8ji&!\u0011QKA(\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002\u001c\u00037\u0002B!!\u0014\u0002^%!\u0011qLA(\u0005\u0015\te\r^3s\u0003\t\"Xm\u001d;JgJ,\u0005\u0010]5sCRLwN\u001c$peN#XoY6G_2dwn^3sg\"\u001aA$!\u001a\u0011\t\u00055\u0013qM\u0005\u0005\u0003S\nyE\u0001\u0003UKN$\u0018!\n;fgRL5O]#ya&\u0014\u0018\r^5p]&3gj\u001c$fi\u000eD'+Z9vKN$X*\u00193fQ\ri\u0012QM\u0001\"i\u0016\u001cH/S:s\u000bb\u0004\u0018N]1uS>tgi\u001c:TY><hi\u001c7m_^,'o\u001d\u0015\u0004=\u0005\u0015\u0014!\n;fgRL5O]#ya&\u0014\u0018\r^5p]\u001a{'oQ1vO\"$X\u000b\u001d$pY2|w/\u001a:tQ\ry\u0012QM\u0001!O\u0016$\b+\u0019:uSRLwN\\,ji\"\fE\u000e\u001c*fa2L7-Y:J]&\u001b(\u000f\u0006\u0007\u0002|\u0005\u001d\u0015\u0011RAG\u00033\u000bi\n\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\t)J\u0001\bG2,8\u000f^3s\u0013\u0011\t))a \u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B=!\u0001\u0004\u0001\u0005BBAFA\u0001\u00071*A\u0006qCJ$\u0018\u000e^5p]&#\u0007bBA\u0002A\u0001\u0007\u0011q\u0012\t\u0005\u0003#\u000b)*\u0004\u0002\u0002\u0014*!\u0011QBA\u0010\u0013\u0011\t9*a%\u0003\tQKW.\u001a\u0005\u0007\u00037\u0003\u0003\u0019A;\u0002\r\r|gNZ5h\u0011\u001d\ty\n\ta\u0001\u0003C\u000b\u0001\u0002\\8dC2dun\u001a\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011qU\u0013\u0002\u00071|w-\u0003\u0003\u0002,\u0006\u0015&a\u0001'pO\u00069An\\4N_\u000e\\WCAAQ\u0001")
public class IsrExpirationTest {
    private scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final long leaderLogHighWatermark;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(scala.collection.mutable.Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public long leaderLogHighWatermark() {
        return this.leaderLogHighWatermark;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        Seq seq = ((KafkaConfig)this.configs().head()).logDirs();
        if (seq == null) {
            throw null;
        }
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(seq.length()), (Option)None$.MODULE$));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpirationForStuckFollowers() {
        void apply_elems;
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), partition0.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        void apply_elems;
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds());
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpirationForSlowFollowers() {
        void apply_elems;
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), partition0.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        this.time().sleep(75L);
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), partition0.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Set$ set$ = Predef$.MODULE$.Set();
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()});
        if (set$ == null) {
            throw null;
        }
        arraySeq = null;
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)IterableFactory.apply$((IterableFactory)set$, (scala.collection.immutable.Seq)apply_elems), (Object)partition0OSR);
        partition0.remoteReplicas().foreach((Function1 & Serializable)r -> {
            r.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), partition0.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((IterableOnceOps)this.configs().map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()))).toSet(), (Object)partition0.inSyncReplicaIds());
        partition0.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, this.time().milliseconds(), (long)this.leaderLogEndOffset(), partition0.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(BoxesRunTime.unboxToLong((Object)((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        if (Predef$.MODULE$.Set() == null) {
            throw null;
        }
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Set.EmptySet$.MODULE$, (Object)partition0OSR);
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().createPartition(tp);
        partition.setLog(localLog, false);
        partition.updateAssignmentAndIsr((Seq)this.configs().map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId())), ((IterableOnceOps)this.configs().map((Function1 & Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()))).toSet(), (Seq)Seq$.MODULE$.empty(), (Seq)Seq$.MODULE$.empty());
        partition.remoteReplicas().foreach((Function1 & Serializable)replica -> {
            replica.updateFetchState(new LogOffsetMetadata(0L, Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition()), 0L, time.milliseconds(), 0L, partition.localLogOrException().highWatermark());
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)leaderId));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils.tempDirectory(null, null)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), Log$.MODULE$.UnknownOffset(), LogOffsetMetadata$.MODULE$.UnknownFilePosition())).anyTimes();
        EasyMock.expect((Object)log.logEndOffset()).andReturn((Object)this.leaderLogEndOffset()).anyTimes();
        EasyMock.expect((Object)log.highWatermark()).andReturn((Object)this.leaderLogHighWatermark()).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.leaderLogHighWatermark = 20L;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)this.replicaLagTimeMaxMs()).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)this.replicaFetchWaitMaxMs()).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)x$1 -> {
            Properties fromProps_overrides = this.overridingProps();
            return KafkaConfig$.MODULE$.fromProps(x$1, fromProps_overrides, true);
        });
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

