/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.OffsetsForLeaderEpochRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapFactory;
import scala.collection.Seq;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005Y3A!\u0004\b\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0014\u0001A\u0003%!\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\r=\u0002\u0001\u0015!\u0003*\u0011\u001d\u0001\u0004A1A\u0005\nEBaA\u0010\u0001!\u0002\u0013\u0011\u0004bB \u0001\u0005\u0004%I\u0001\u0011\u0005\u0007\u000b\u0002\u0001\u000b\u0011B!\t\u000b\u0019\u0003A\u0011A$\t\u000bI\u0003A\u0011A$\t\u000bQ\u0003A\u0011A$\u00033=3gm]3ug\u001a{'\u000fT3bI\u0016\u0014X\t]8dQR+7\u000f\u001e\u0006\u0003\u001fA\tQ!\u001a9pG\"T!!\u0005\n\u0002\rM,'O^3s\u0015\u0005\u0019\u0012!B6bM.\f7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\u000f\u0003\u0019\u0019wN\u001c4jOV\t!\u0005\u0005\u0002$I5\t\u0001#\u0003\u0002&!\tY1*\u00194lC\u000e{gNZ5h\u0003\u001d\u0019wN\u001c4jO\u0002\nA\u0001^5nKV\t\u0011\u0006\u0005\u0002+[5\t1F\u0003\u0002-%\u0005)Q\u000f^5mg&\u0011af\u000b\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001\u001a\u0011\u0005MbT\"\u0001\u001b\u000b\u0005A*$B\u0001\u001c8\u0003\u0019\u0019w.\\7p]*\u00111\u0003\u000f\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014x-\u0003\u0002>i\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u0005Q\u0004X#A!\u0011\u0005\t\u001bU\"A\u001b\n\u0005\u0011+$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0004iB\u0004\u0013AG:i_VdGmR3u\u000bB|7\r[:Ge>l'+\u001a9mS\u000e\fG#\u0001%\u0011\u0005]I\u0015B\u0001&\u0019\u0005\u0011)f.\u001b;)\u0005)a\u0005CA'Q\u001b\u0005q%BA(;\u0003\u0015QWO\\5u\u0013\t\tfJ\u0001\u0003UKN$\u0018\u0001K:i_VdGMU3ukJtgj\u001c'fC\u0012,'OR8s!\u0006\u0014H/\u001b;j_:Le\r\u00165s_^t\u0007FA\u0006M\u0003-\u001a\bn\\;mIJ+G/\u001e:o+:\\gn\\<o)>\u0004\u0018nY(s!\u0006\u0014H/\u001b;j_:Le\r\u00165s_^t\u0007F\u0001\u0007M\u0001")
public class OffsetsForLeaderEpochTest {
    private final KafkaConfig config = (KafkaConfig)((IterableOps)TestUtils$.MODULE$.createBrokerConfigs(1, TestUtils$.MODULE$.MockZkConnect(), true, true, (Option<SecurityProtocol>)None$.MODULE$, (Option<File>)None$.MODULE$, (Option<Properties>)None$.MODULE$, true, false, false, false, (Map<Object, String>)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), 1, false, 1, (short)1).map((Function1 & Serializable)props -> KafkaConfig$.MODULE$.fromProps(props))).head();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final TopicPartition tp = new TopicPartition("topic", 1);

    private KafkaConfig config() {
        return this.config;
    }

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private TopicPartition tp() {
        return this.tp;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldGetEpochsFromReplica() {
        void apply_elems;
        void $minus$greater$extension_y;
        OffsetAndEpoch offsetAndEpoch = new OffsetAndEpoch(42L, 5);
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var8_4 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Log mockLog = (Log)EasyMock.createNiceMock(Log.class);
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)mockLog.endOffsetForEpoch(n)).andReturn((Object)new Some((Object)offsetAndEpoch));
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{mockLog, logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (Option)None$.MODULE$);
        Partition partition = replicaManager.createPartition(this.tp());
        partition.setLog(mockLog, false);
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)this.config().brokerId()));
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NONE, offsetAndEpoch.leaderEpoch(), offsetAndEpoch.offset()), (Object)response.apply((Object)this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnNoLeaderForPartitionIfThrown() {
        void apply_elems;
        void $minus$greater$extension_y;
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (Option)None$.MODULE$);
        replicaManager.createPartition(this.tp());
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var5_5 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.NOT_LEADER_FOR_PARTITION, -1, -1L), (Object)response.apply((Object)this.tp()));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void shouldReturnUnknownTopicOrPartitionIfThrown() {
        void apply_elems;
        void $minus$greater$extension_y;
        LogManager logManager = (LogManager)EasyMock.createNiceMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])new File[0])).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        Seq seq = this.config().logDirs();
        if (seq == null) {
            throw null;
        }
        ReplicaManager replicaManager = new ReplicaManager(this.config(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(this.config(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(this.config().brokerId()), new LogDirFailureChannel(seq.length()), (Option)None$.MODULE$);
        int n = 5;
        scala.collection.immutable.Map$ map$ = Predef$.MODULE$.Map();
        Object[] objectArray = new Tuple2[1];
        OffsetsForLeaderEpochRequest.PartitionData partitionData = new OffsetsForLeaderEpochRequest.PartitionData(Optional.empty(), n);
        TopicPartition $minus$greater$extension_$this = this.tp();
        Object var5_5 = null;
        partitionData = null;
        objectArray[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        ArraySeq arraySeq = ScalaRunTime$.MODULE$.wrapRefArray(objectArray);
        if (map$ == null) {
            throw null;
        }
        arraySeq = null;
        scala.collection.immutable.Map request = (scala.collection.immutable.Map)MapFactory.apply$((MapFactory)map$, (scala.collection.immutable.Seq)apply_elems);
        Map response = replicaManager.lastOffsetForLeaderEpoch((Map)request);
        Assert.assertEquals((Object)new EpochEndOffset(Errors.UNKNOWN_TOPIC_OR_PARTITION, -1, -1L), (Object)response.apply((Object)this.tp()));
    }
}

